import { AuthDto } from 'src/dtos/auth.dto';
import { UserPreferencesResponseDto, UserPreferencesUpdateDto } from 'src/dtos/user-preferences.dto';
import { UserAdminCreateDto, UserAdminDeleteDto, UserAdminResponseDto, UserAdminSearchDto, UserAdminUpdateDto } from 'src/dtos/user.dto';
import { UserAdminService } from 'src/services/user-admin.service';
import { UUIDParamDto } from 'src/validation';
export declare class UserAdminController {
    private service;
    constructor(service: UserAdminService);
    searchUsersAdmin(auth: AuthDto, dto: UserAdminSearchDto): Promise<UserAdminResponseDto[]>;
    createUserAdmin(createUserDto: UserAdminCreateDto): Promise<UserAdminResponseDto>;
    getUserAdmin(auth: AuthDto, { id }: UUIDParamDto): Promise<UserAdminResponseDto>;
    updateUserAdmin(auth: AuthDto, { id }: UUIDParamDto, dto: UserAdminUpdateDto): Promise<UserAdminResponseDto>;
    deleteUserAdmin(auth: AuthDto, { id }: UUIDParamDto, dto: UserAdminDeleteDto): Promise<UserAdminResponseDto>;
    getUserPreferencesAdmin(auth: AuthDto, { id }: UUIDParamDto): Promise<UserPreferencesResponseDto>;
    updateUserPreferencesAdmin(auth: AuthDto, { id }: UUIDParamDto, dto: UserPreferencesUpdateDto): Promise<UserPreferencesResponseDto>;
    restoreUserAdmin(auth: AuthDto, { id }: UUIDParamDto): Promise<UserAdminResponseDto>;
}
