"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemConfigController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const system_config_dto_1 = require("../dtos/system-config.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const storage_template_service_1 = require("../services/storage-template.service");
const system_config_service_1 = require("../services/system-config.service");
let SystemConfigController = class SystemConfigController {
    service;
    storageTemplateService;
    constructor(service, storageTemplateService) {
        this.service = service;
        this.storageTemplateService = storageTemplateService;
    }
    getConfig() {
        return this.service.getSystemConfig();
    }
    getConfigDefaults() {
        return this.service.getDefaults();
    }
    updateConfig(dto) {
        return this.service.updateSystemConfig(dto);
    }
    getStorageTemplateOptions() {
        return this.storageTemplateService.getStorageTemplateOptions();
    }
};
exports.SystemConfigController = SystemConfigController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SYSTEM_CONFIG_READ, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-config.dto").SystemConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SystemConfigController.prototype, "getConfig", null);
__decorate([
    (0, common_1.Get)('defaults'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SYSTEM_CONFIG_READ, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-config.dto").SystemConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", system_config_dto_1.SystemConfigDto)
], SystemConfigController.prototype, "getConfigDefaults", null);
__decorate([
    (0, common_1.Put)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SYSTEM_CONFIG_UPDATE, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-config.dto").SystemConfigDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [system_config_dto_1.SystemConfigDto]),
    __metadata("design:returntype", Promise)
], SystemConfigController.prototype, "updateConfig", null);
__decorate([
    (0, common_1.Get)('storage-template-options'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SYSTEM_CONFIG_READ, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-config.dto").SystemConfigTemplateStorageOptionDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", system_config_dto_1.SystemConfigTemplateStorageOptionDto)
], SystemConfigController.prototype, "getStorageTemplateOptions", null);
exports.SystemConfigController = SystemConfigController = __decorate([
    (0, swagger_1.ApiTags)('System Config'),
    (0, common_1.Controller)('system-config'),
    __metadata("design:paramtypes", [system_config_service_1.SystemConfigService,
        storage_template_service_1.StorageTemplateService])
], SystemConfigController);
//# sourceMappingURL=system-config.controller.js.map