"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const sync_dto_1 = require("../dtos/sync.dto");
const auth_guard_1 = require("../middleware/auth.guard");
const global_exception_filter_1 = require("../middleware/global-exception.filter");
const sync_service_1 = require("../services/sync.service");
let SyncController = class SyncController {
    service;
    errorService;
    constructor(service, errorService) {
        this.service = service;
        this.errorService = errorService;
    }
    getFullSyncForUser(auth, dto) {
        return this.service.getFullSync(auth, dto);
    }
    getDeltaSync(auth, dto) {
        return this.service.getDeltaSync(auth, dto);
    }
    async getSyncStream(auth, res, dto) {
        try {
            await this.service.stream(auth, res, dto);
        }
        catch (error) {
            res.setHeader('Content-Type', 'application/json');
            this.errorService.handleError(res, error);
        }
    }
    getSyncAck(auth) {
        return this.service.getAcks(auth);
    }
    sendSyncAck(auth, dto) {
        return this.service.setAcks(auth, dto);
    }
    deleteSyncAck(auth, dto) {
        return this.service.deleteAcks(auth, dto);
    }
};
exports.SyncController = SyncController;
__decorate([
    (0, common_1.Post)('full-sync'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, sync_dto_1.AssetFullSyncDto]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getFullSyncForUser", null);
__decorate([
    (0, common_1.Post)('delta-sync'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/sync.dto").AssetDeltaSyncResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, sync_dto_1.AssetDeltaSyncDto]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getDeltaSync", null);
__decorate([
    (0, common_1.Post)('stream'),
    (0, common_1.Header)('Content-Type', 'application/jsonlines+json'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, Object, sync_dto_1.SyncStreamDto]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getSyncStream", null);
__decorate([
    (0, common_1.Get)('ack'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/sync.dto").SyncAckDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getSyncAck", null);
__decorate([
    (0, common_1.Post)('ack'),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, sync_dto_1.SyncAckSetDto]),
    __metadata("design:returntype", void 0)
], SyncController.prototype, "sendSyncAck", null);
__decorate([
    (0, common_1.Delete)('ack'),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, sync_dto_1.SyncAckDeleteDto]),
    __metadata("design:returntype", void 0)
], SyncController.prototype, "deleteSyncAck", null);
exports.SyncController = SyncController = __decorate([
    (0, swagger_1.ApiTags)('Sync'),
    (0, common_1.Controller)('sync'),
    __metadata("design:paramtypes", [sync_service_1.SyncService,
        global_exception_filter_1.GlobalExceptionFilter])
], SyncController);
//# sourceMappingURL=sync.controller.js.map