import { BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { StackCreateDto, StackResponseDto, StackSearchDto, StackUpdateDto } from 'src/dtos/stack.dto';
import { StackService } from 'src/services/stack.service';
import { UUIDParamDto } from 'src/validation';
export declare class StackController {
    private service;
    constructor(service: StackService);
    searchStacks(auth: AuthDto, query: StackSearchDto): Promise<StackResponseDto[]>;
    createStack(auth: AuthDto, dto: StackCreateDto): Promise<StackResponseDto>;
    deleteStacks(auth: AuthDto, dto: BulkIdsDto): Promise<void>;
    getStack(auth: AuthDto, { id }: UUIDParamDto): Promise<StackResponseDto>;
    updateStack(auth: AuthDto, { id }: UUIDParamDto, dto: StackUpdateDto): Promise<StackResponseDto>;
    deleteStack(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
