"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const license_dto_1 = require("../dtos/license.dto");
const server_dto_1 = require("../dtos/server.dto");
const auth_guard_1 = require("../middleware/auth.guard");
const server_service_1 = require("../services/server.service");
const version_service_1 = require("../services/version.service");
let ServerController = class ServerController {
    service;
    versionService;
    constructor(service, versionService) {
        this.service = service;
        this.versionService = versionService;
    }
    getAboutInfo() {
        return this.service.getAboutInfo();
    }
    getStorage() {
        return this.service.getStorage();
    }
    pingServer() {
        return this.service.ping();
    }
    getServerVersion() {
        return this.versionService.getVersion();
    }
    getVersionHistory() {
        return this.versionService.getVersionHistory();
    }
    getServerFeatures() {
        return this.service.getFeatures();
    }
    getTheme() {
        return this.service.getTheme();
    }
    getServerConfig() {
        return this.service.getSystemConfig();
    }
    getServerStatistics() {
        return this.service.getStatistics();
    }
    getSupportedMediaTypes() {
        return this.service.getSupportedMediaTypes();
    }
    setServerLicense(license) {
        return this.service.setLicense(license);
    }
    deleteServerLicense() {
        return this.service.deleteLicense();
    }
    getServerLicense() {
        return this.service.getLicense();
    }
};
exports.ServerController = ServerController;
__decorate([
    (0, common_1.Get)('about'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerAboutResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getAboutInfo", null);
__decorate([
    (0, common_1.Get)('storage'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerStorageResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getStorage", null);
__decorate([
    (0, common_1.Get)('ping'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerPingResponse }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerPingResponse)
], ServerController.prototype, "pingServer", null);
__decorate([
    (0, common_1.Get)('version'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerVersionResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerVersionResponseDto)
], ServerController.prototype, "getServerVersion", null);
__decorate([
    (0, common_1.Get)('version-history'),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/server.dto").ServerVersionHistoryResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getVersionHistory", null);
__decorate([
    (0, common_1.Get)('features'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerFeaturesDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerFeatures", null);
__decorate([
    (0, common_1.Get)('theme'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerThemeDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getTheme", null);
__decorate([
    (0, common_1.Get)('config'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerConfig", null);
__decorate([
    (0, common_1.Get)('statistics'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerStatsResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerStatistics", null);
__decorate([
    (0, common_1.Get)('media-types'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerMediaTypesResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerMediaTypesResponseDto)
], ServerController.prototype, "getSupportedMediaTypes", null);
__decorate([
    (0, common_1.Put)('license'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [license_dto_1.LicenseKeyDto]),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "setServerLicense", null);
__decorate([
    (0, common_1.Delete)('license'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 200 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "deleteServerLicense", null);
__decorate([
    (0, common_1.Get)('license'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    (0, swagger_1.ApiNotFoundResponse)(),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerLicense", null);
exports.ServerController = ServerController = __decorate([
    (0, swagger_1.ApiTags)('Server'),
    (0, common_1.Controller)('server'),
    __metadata("design:paramtypes", [server_service_1.ServerService,
        version_service_1.VersionService])
], ServerController);
//# sourceMappingURL=server.controller.js.map