import { LicenseKeyDto, LicenseResponseDto } from 'src/dtos/license.dto';
import { ServerAboutResponseDto, ServerConfigDto, ServerFeaturesDto, ServerMediaTypesResponseDto, ServerPingResponse, ServerStatsResponseDto, ServerStorageResponseDto, ServerThemeDto, ServerVersionHistoryResponseDto, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { ServerService } from 'src/services/server.service';
import { VersionService } from 'src/services/version.service';
export declare class ServerController {
    private service;
    private versionService;
    constructor(service: ServerService, versionService: VersionService);
    getAboutInfo(): Promise<ServerAboutResponseDto>;
    getStorage(): Promise<ServerStorageResponseDto>;
    pingServer(): ServerPingResponse;
    getServerVersion(): ServerVersionResponseDto;
    getVersionHistory(): Promise<ServerVersionHistoryResponseDto[]>;
    getServerFeatures(): Promise<ServerFeaturesDto>;
    getTheme(): Promise<ServerThemeDto>;
    getServerConfig(): Promise<ServerConfigDto>;
    getServerStatistics(): Promise<ServerStatsResponseDto>;
    getSupportedMediaTypes(): ServerMediaTypesResponseDto;
    setServerLicense(license: LicenseKeyDto): Promise<LicenseResponseDto>;
    deleteServerLicense(): Promise<void>;
    getServerLicense(): Promise<LicenseResponseDto>;
}
