import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { PersonResponseDto } from 'src/dtos/person.dto';
import { MetadataSearchDto, PlacesResponseDto, RandomSearchDto, SearchExploreResponseDto, SearchPeopleDto, SearchPlacesDto, SearchResponseDto, SearchSuggestionRequestDto, SmartSearchDto } from 'src/dtos/search.dto';
import { SearchService } from 'src/services/search.service';
export declare class SearchController {
    private service;
    constructor(service: SearchService);
    searchAssets(auth: AuthDto, dto: MetadataSearchDto): Promise<SearchResponseDto>;
    searchRandom(auth: AuthDto, dto: RandomSearchDto): Promise<AssetResponseDto[]>;
    searchSmart(auth: AuthDto, dto: SmartSearchDto): Promise<SearchResponseDto>;
    getExploreData(auth: AuthDto): Promise<SearchExploreResponseDto[]>;
    searchPerson(auth: AuthDto, dto: SearchPeopleDto): Promise<PersonResponseDto[]>;
    searchPlaces(dto: SearchPlacesDto): Promise<PlacesResponseDto[]>;
    getAssetsByCity(auth: AuthDto): Promise<AssetResponseDto[]>;
    getSearchSuggestions(auth: AuthDto, dto: SearchSuggestionRequestDto): Promise<string[]>;
}
