"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersonController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const person_dto_1 = require("../dtos/person.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const logging_repository_1 = require("../repositories/logging.repository");
const person_service_1 = require("../services/person.service");
const file_1 = require("../utils/file");
const validation_1 = require("../validation");
let PersonController = class PersonController {
    service;
    logger;
    constructor(service, logger) {
        this.service = service;
        this.logger = logger;
    }
    getAllPeople(auth, options) {
        return this.service.getAll(auth, options);
    }
    createPerson(auth, dto) {
        return this.service.create(auth, dto);
    }
    updatePeople(auth, dto) {
        return this.service.updateAll(auth, dto);
    }
    getPerson(auth, { id }) {
        return this.service.getById(auth, id);
    }
    updatePerson(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    getPersonStatistics(auth, { id }) {
        return this.service.getStatistics(auth, id);
    }
    async getPersonThumbnail(res, next, auth, { id }) {
        await (0, file_1.sendFile)(res, next, () => this.service.getThumbnail(auth, id), this.logger);
    }
    reassignFaces(auth, { id }, dto) {
        return this.service.reassignFaces(auth, id, dto);
    }
    mergePerson(auth, { id }, dto) {
        return this.service.mergePerson(auth, id, dto);
    }
};
exports.PersonController = PersonController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_READ }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/person.dto").PeopleResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, person_dto_1.PersonSearchDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "getAllPeople", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_CREATE }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/person.dto").PersonResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, person_dto_1.PersonCreateDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "createPerson", null);
__decorate([
    (0, common_1.Put)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_UPDATE }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, person_dto_1.PeopleUpdateDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "updatePeople", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_READ }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/person.dto").PersonResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "getPerson", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_UPDATE }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/person.dto").PersonResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        person_dto_1.PersonUpdateDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "updatePerson", null);
__decorate([
    (0, common_1.Get)(':id/statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_STATISTICS }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/person.dto").PersonStatisticsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "getPersonStatistics", null);
__decorate([
    (0, common_1.Get)(':id/thumbnail'),
    (0, auth_guard_1.FileResponse)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_READ }),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Res)()),
    __param(1, (0, common_1.Next)()),
    __param(2, (0, auth_guard_1.Auth)()),
    __param(3, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Function, auth_dto_1.AuthDto,
        validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "getPersonThumbnail", null);
__decorate([
    (0, common_1.Put)(':id/reassign'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_REASSIGN }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/person.dto").PersonResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        person_dto_1.AssetFaceUpdateDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "reassignFaces", null);
__decorate([
    (0, common_1.Post)(':id/merge'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PERSON_MERGE }),
    openapi.ApiResponse({ status: 201, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        person_dto_1.MergePersonDto]),
    __metadata("design:returntype", Promise)
], PersonController.prototype, "mergePerson", null);
exports.PersonController = PersonController = __decorate([
    (0, swagger_1.ApiTags)('People'),
    (0, common_1.Controller)('people'),
    __metadata("design:paramtypes", [person_service_1.PersonService,
        logging_repository_1.LoggingRepository])
], PersonController);
//# sourceMappingURL=person.controller.js.map