import { AuthDto } from 'src/dtos/auth.dto';
import { PartnerResponseDto, PartnerSearchDto, UpdatePartnerDto } from 'src/dtos/partner.dto';
import { PartnerService } from 'src/services/partner.service';
import { UUIDParamDto } from 'src/validation';
export declare class PartnerController {
    private service;
    constructor(service: PartnerService);
    getPartners(auth: AuthDto, dto: PartnerSearchDto): Promise<PartnerResponseDto[]>;
    createPartner(auth: AuthDto, { id }: UUIDParamDto): Promise<PartnerResponseDto>;
    updatePartner(auth: AuthDto, { id }: UUIDParamDto, dto: UpdatePartnerDto): Promise<PartnerResponseDto>;
    removePartner(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
