import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { MemoryCreateDto, MemoryResponseDto, MemorySearchDto, MemoryUpdateDto } from 'src/dtos/memory.dto';
import { MemoryService } from 'src/services/memory.service';
import { UUIDParamDto } from 'src/validation';
export declare class MemoryController {
    private service;
    constructor(service: MemoryService);
    searchMemories(auth: AuthDto, dto: MemorySearchDto): Promise<MemoryResponseDto[]>;
    createMemory(auth: AuthDto, dto: MemoryCreateDto): Promise<MemoryResponseDto>;
    getMemory(auth: AuthDto, { id }: UUIDParamDto): Promise<MemoryResponseDto>;
    updateMemory(auth: AuthDto, { id }: UUIDParamDto, dto: MemoryUpdateDto): Promise<MemoryResponseDto>;
    deleteMemory(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    addMemoryAssets(auth: AuthDto, { id }: UUIDParamDto, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    removeMemoryAssets(auth: AuthDto, dto: BulkIdsDto, { id }: UUIDParamDto): Promise<BulkIdResponseDto[]>;
}
