"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const map_dto_1 = require("../dtos/map.dto");
const auth_guard_1 = require("../middleware/auth.guard");
const map_service_1 = require("../services/map.service");
let MapController = class MapController {
    service;
    constructor(service) {
        this.service = service;
    }
    getMapMarkers(auth, options) {
        return this.service.getMapMarkers(auth, options);
    }
    reverseGeocode(dto) {
        return this.service.reverseGeocode(dto);
    }
};
exports.MapController = MapController;
__decorate([
    (0, common_1.Get)('markers'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/map.dto").MapMarkerResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, map_dto_1.MapMarkerDto]),
    __metadata("design:returntype", Promise)
], MapController.prototype, "getMapMarkers", null);
__decorate([
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.Get)('reverse-geocode'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: [require("../dtos/map.dto").MapReverseGeocodeResponseDto] }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [map_dto_1.MapReverseGeocodeDto]),
    __metadata("design:returntype", Promise)
], MapController.prototype, "reverseGeocode", null);
exports.MapController = MapController = __decorate([
    (0, swagger_1.ApiTags)('Map'),
    (0, common_1.Controller)('map'),
    __metadata("design:paramtypes", [map_service_1.MapService])
], MapController);
//# sourceMappingURL=map.controller.js.map