"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const audit_dto_1 = require("../dtos/audit.dto");
const auth_guard_1 = require("../middleware/auth.guard");
const audit_service_1 = require("../services/audit.service");
let ReportController = class ReportController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAuditFiles() {
        return this.service.getFileReport();
    }
    getFileChecksums(dto) {
        return this.service.getChecksums(dto);
    }
    fixAuditFiles(dto) {
        return this.service.fixItems(dto.items);
    }
};
exports.ReportController = ReportController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/audit.dto").FileReportDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "getAuditFiles", null);
__decorate([
    (0, common_1.Post)('checksum'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 201, type: [require("../dtos/audit.dto").FileChecksumResponseDto] }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [audit_dto_1.FileChecksumDto]),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "getFileChecksums", null);
__decorate([
    (0, common_1.Post)('fix'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [audit_dto_1.FileReportFixDto]),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "fixAuditFiles", null);
exports.ReportController = ReportController = __decorate([
    (0, swagger_1.ApiTags)('File Reports'),
    (0, common_1.Controller)('reports'),
    __metadata("design:paramtypes", [audit_service_1.AuditService])
], ReportController);
//# sourceMappingURL=file-report.controller.js.map