"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const auth_service_1 = require("../services/auth.service");
const response_1 = require("../utils/response");
let AuthController = class AuthController {
    service;
    constructor(service) {
        this.service = service;
    }
    async login(loginCredential, res, loginDetails) {
        const body = await this.service.login(loginCredential, loginDetails);
        return (0, response_1.respondWithCookie)(res, body, {
            isSecure: loginDetails.isSecure,
            values: [
                { key: enum_1.ImmichCookie.ACCESS_TOKEN, value: body.accessToken },
                { key: enum_1.ImmichCookie.AUTH_TYPE, value: enum_1.AuthType.PASSWORD },
                { key: enum_1.ImmichCookie.IS_AUTHENTICATED, value: 'true' },
            ],
        });
    }
    signUpAdmin(dto) {
        return this.service.adminSignUp(dto);
    }
    validateAccessToken() {
        return { authStatus: true };
    }
    changePassword(auth, dto) {
        return this.service.changePassword(auth, dto);
    }
    async logout(request, res, auth) {
        const authType = (request.cookies || {})[enum_1.ImmichCookie.AUTH_TYPE];
        const body = await this.service.logout(auth, authType);
        return (0, response_1.respondWithoutCookie)(res, body, [
            enum_1.ImmichCookie.ACCESS_TOKEN,
            enum_1.ImmichCookie.AUTH_TYPE,
            enum_1.ImmichCookie.IS_AUTHENTICATED,
        ]);
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('login'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/auth.dto").LoginResponseDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.LoginCredentialDto, Object, Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('admin-sign-up'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SignUpDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "signUpAdmin", null);
__decorate([
    (0, common_1.Post)('validateToken'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/auth.dto").ValidateAccessTokenResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", auth_dto_1.ValidateAccessTokenResponseDto)
], AuthController.prototype, "validateAccessToken", null);
__decorate([
    (0, common_1.Post)('change-password'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.ChangePasswordDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "changePassword", null);
__decorate([
    (0, common_1.Post)('logout'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/auth.dto").LogoutResponseDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __param(2, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "logout", null);
exports.AuthController = AuthController = __decorate([
    (0, swagger_1.ApiTags)('Authentication'),
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map