import { Request, Response } from 'express';
import { AuthDto, ChangePasswordDto, LoginCredentialDto, LoginResponseDto, LogoutResponseDto, SignUpDto, ValidateAccessTokenResponseDto } from 'src/dtos/auth.dto';
import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { AuthService, LoginDetails } from 'src/services/auth.service';
export declare class AuthController {
    private service;
    constructor(service: AuthService);
    login(loginCredential: LoginCredentialDto, res: Response, loginDetails: LoginDetails): Promise<LoginResponseDto>;
    signUpAdmin(dto: SignUpDto): Promise<UserAdminResponseDto>;
    validateAccessToken(): ValidateAccessTokenResponseDto;
    changePassword(auth: AuthDto, dto: ChangePasswordDto): Promise<UserAdminResponseDto>;
    logout(request: Request, res: Response, auth: AuthDto): Promise<LogoutResponseDto>;
}
