import { AssetResponseDto, MemoryLaneResponseDto } from 'src/dtos/asset-response.dto';
import { AssetBulkDeleteDto, AssetBulkUpdateDto, AssetJobsDto, AssetStatsDto, AssetStatsResponseDto, DeviceIdDto, RandomAssetsDto, UpdateAssetDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { MemoryLaneDto } from 'src/dtos/search.dto';
import { AssetService } from 'src/services/asset.service';
import { UUIDParamDto } from 'src/validation';
export declare class AssetController {
    private service;
    constructor(service: AssetService);
    getMemoryLane(auth: AuthDto, dto: MemoryLaneDto): Promise<MemoryLaneResponseDto[]>;
    getRandom(auth: AuthDto, dto: RandomAssetsDto): Promise<AssetResponseDto[]>;
    getAllUserAssetsByDeviceId(auth: AuthDto, { deviceId }: DeviceIdDto): Promise<string[]>;
    getAssetStatistics(auth: AuthDto, dto: AssetStatsDto): Promise<AssetStatsResponseDto>;
    runAssetJobs(auth: AuthDto, dto: AssetJobsDto): Promise<void>;
    updateAssets(auth: AuthDto, dto: AssetBulkUpdateDto): Promise<void>;
    deleteAssets(auth: AuthDto, dto: AssetBulkDeleteDto): Promise<void>;
    getAssetInfo(auth: AuthDto, { id }: UUIDParamDto): Promise<AssetResponseDto>;
    updateAsset(auth: AuthDto, { id }: UUIDParamDto, dto: UpdateAssetDto): Promise<AssetResponseDto>;
}
