import { APIKeyCreateDto, APIKeyCreateResponseDto, APIKeyResponseDto, APIKeyUpdateDto } from 'src/dtos/api-key.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { ApiKeyService } from 'src/services/api-key.service';
import { UUIDParamDto } from 'src/validation';
export declare class APIKeyController {
    private service;
    constructor(service: ApiKeyService);
    createApiKey(auth: AuthDto, dto: APIKeyCreateDto): Promise<APIKeyCreateResponseDto>;
    getApiKeys(auth: AuthDto): Promise<APIKeyResponseDto[]>;
    getApiKey(auth: AuthDto, { id }: UUIDParamDto): Promise<APIKeyResponseDto>;
    updateApiKey(auth: AuthDto, { id }: UUIDParamDto, dto: APIKeyUpdateDto): Promise<APIKeyResponseDto>;
    deleteApiKey(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
