"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ORIENTATION_TO_SHARP_ROTATION = exports.CLIP_MODEL_INFO = exports.FACE_THUMBNAIL_SIZE = exports.excludePaths = exports.LOGIN_URL = exports.MOBILE_REDIRECT = exports.citiesFile = exports.MACHINE_LEARNING_AVAILABILITY_BACKOFF_TIME = exports.MACHINE_LEARNING_PING_TIMEOUT = exports.APP_MEDIA_LOCATION = exports.ONE_HOUR = exports.AUDIT_LOG_MAX_DURATION = exports.serverVersion = exports.IWorker = exports.SALT_ROUNDS = exports.EXTENSION_NAMES = exports.JOBS_LIBRARY_PAGINATION_SIZE = exports.JOBS_ASSET_PAGINATION_SIZE = exports.ADDED_IN_PREFIX = exports.DEPRECATED_IN_PREFIX = exports.LIFECYCLE_EXTENSION = exports.NEXT_RELEASE = exports.VECTOR_VERSION_RANGE = exports.VECTORS_VERSION_RANGE = exports.POSTGRES_VERSION_RANGE = void 0;
const luxon_1 = require("luxon");
const node_fs_1 = require("node:fs");
const semver_1 = require("semver");
const enum_1 = require("./enum");
exports.POSTGRES_VERSION_RANGE = '>=14.0.0';
exports.VECTORS_VERSION_RANGE = '>=0.2 <=0.4';
exports.VECTOR_VERSION_RANGE = '>=0.5 <1';
exports.NEXT_RELEASE = 'NEXT_RELEASE';
exports.LIFECYCLE_EXTENSION = 'x-immich-lifecycle';
exports.DEPRECATED_IN_PREFIX = 'This property was deprecated in ';
exports.ADDED_IN_PREFIX = 'This property was added in ';
exports.JOBS_ASSET_PAGINATION_SIZE = 1000;
exports.JOBS_LIBRARY_PAGINATION_SIZE = 10_000;
exports.EXTENSION_NAMES = {
    cube: 'cube',
    earthdistance: 'earthdistance',
    vector: 'pgvector',
    vectors: 'pgvecto.rs',
};
exports.SALT_ROUNDS = 10;
exports.IWorker = 'IWorker';
const { version } = JSON.parse((0, node_fs_1.readFileSync)('./package.json', 'utf8'));
exports.serverVersion = new semver_1.SemVer(version);
exports.AUDIT_LOG_MAX_DURATION = luxon_1.Duration.fromObject({ days: 100 });
exports.ONE_HOUR = luxon_1.Duration.fromObject({ hours: 1 });
exports.APP_MEDIA_LOCATION = process.env.IMMICH_MEDIA_LOCATION || './upload';
exports.MACHINE_LEARNING_PING_TIMEOUT = Number(process.env.MACHINE_LEARNING_PING_TIMEOUT || 2000);
exports.MACHINE_LEARNING_AVAILABILITY_BACKOFF_TIME = Number(process.env.MACHINE_LEARNING_AVAILABILITY_BACKOFF_TIME || 30_000);
exports.citiesFile = 'cities500.txt';
exports.MOBILE_REDIRECT = 'app.immich:///oauth-callback';
exports.LOGIN_URL = '/auth/login?autoLaunch=0';
exports.excludePaths = ['/.well-known/immich', '/custom.css', '/favicon.ico'];
exports.FACE_THUMBNAIL_SIZE = 250;
exports.CLIP_MODEL_INFO = {
    RN101__openai: { dimSize: 512 },
    RN101__yfcc15m: { dimSize: 512 },
    'ViT-B-16__laion400m_e31': { dimSize: 512 },
    'ViT-B-16__laion400m_e32': { dimSize: 512 },
    'ViT-B-16__openai': { dimSize: 512 },
    'ViT-B-32__laion2b-s34b-b79k': { dimSize: 512 },
    'ViT-B-32__laion2b_e16': { dimSize: 512 },
    'ViT-B-32__laion400m_e31': { dimSize: 512 },
    'ViT-B-32__laion400m_e32': { dimSize: 512 },
    'ViT-B-32__openai': { dimSize: 512 },
    'XLM-Roberta-Base-ViT-B-32__laion5b_s13b_b90k': { dimSize: 512 },
    'XLM-Roberta-Large-Vit-B-32': { dimSize: 512 },
    RN50x4__openai: { dimSize: 640 },
    'ViT-B-16-plus-240__laion400m_e31': { dimSize: 640 },
    'ViT-B-16-plus-240__laion400m_e32': { dimSize: 640 },
    'XLM-Roberta-Large-Vit-B-16Plus': { dimSize: 640 },
    'LABSE-Vit-L-14': { dimSize: 768 },
    RN50x16__openai: { dimSize: 768 },
    'ViT-B-16-SigLIP-256__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-384__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-512__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-i18n-256__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP__webli': { dimSize: 768 },
    'ViT-L-14-336__openai': { dimSize: 768 },
    'ViT-L-14-quickgelu__dfn2b': { dimSize: 768 },
    'ViT-L-14__laion2b-s32b-b82k': { dimSize: 768 },
    'ViT-L-14__laion400m_e31': { dimSize: 768 },
    'ViT-L-14__laion400m_e32': { dimSize: 768 },
    'ViT-L-14__openai': { dimSize: 768 },
    'XLM-Roberta-Large-Vit-L-14': { dimSize: 768 },
    'nllb-clip-base-siglip__mrl': { dimSize: 768 },
    'nllb-clip-base-siglip__v1': { dimSize: 768 },
    RN50__cc12m: { dimSize: 1024 },
    RN50__openai: { dimSize: 1024 },
    RN50__yfcc15m: { dimSize: 1024 },
    RN50x64__openai: { dimSize: 1024 },
    'ViT-H-14-378-quickgelu__dfn5b': { dimSize: 1024 },
    'ViT-H-14-quickgelu__dfn5b': { dimSize: 1024 },
    'ViT-H-14__laion2b-s32b-b79k': { dimSize: 1024 },
    'ViT-L-16-SigLIP-256__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP-384__webli': { dimSize: 1024 },
    'ViT-g-14__laion2b-s12b-b42k': { dimSize: 1024 },
    'XLM-Roberta-Large-ViT-H-14__frozen_laion5b_s13b_b90k': { dimSize: 1024 },
    'ViT-SO400M-14-SigLIP-384__webli': { dimSize: 1152 },
    'nllb-clip-large-siglip__mrl': { dimSize: 1152 },
    'nllb-clip-large-siglip__v1': { dimSize: 1152 },
    'ViT-B-16-SigLIP2__webli': { dimSize: 768 },
    'ViT-B-32-SigLIP2-256__webli': { dimSize: 768 },
    'ViT-L-16-SigLIP2-256__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP2-384__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP2-512__webli': { dimSize: 1024 },
    'ViT-SO400M-14-SigLIP2__webli': { dimSize: 1152 },
    'ViT-SO400M-14-SigLIP2-378__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-256__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-384__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-512__webli': { dimSize: 1152 },
    'ViT-gopt-16-SigLIP2-256__webli': { dimSize: 1536 },
    'ViT-gopt-16-SigLIP2-384__webli': { dimSize: 1536 },
};
exports.ORIENTATION_TO_SHARP_ROTATION = {
    [enum_1.ExifOrientation.Horizontal]: { angle: 0 },
    [enum_1.ExifOrientation.MirrorHorizontal]: { angle: 0, flop: true },
    [enum_1.ExifOrientation.Rotate180]: { angle: 180 },
    [enum_1.ExifOrientation.MirrorVertical]: { angle: 180, flop: true },
    [enum_1.ExifOrientation.MirrorHorizontalRotate270CW]: { angle: 270, flip: true },
    [enum_1.ExifOrientation.Rotate90CW]: { angle: 90 },
    [enum_1.ExifOrientation.MirrorHorizontalRotate90CW]: { angle: 90, flip: true },
    [enum_1.ExifOrientation.Rotate270CW]: { angle: 270 },
};
//# sourceMappingURL=constants.js.map