"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaults = void 0;
const schedule_1 = require("@nestjs/schedule");
const enum_1 = require("./enum");
exports.defaults = Object.freeze({
    backup: {
        database: {
            enabled: true,
            cronExpression: schedule_1.CronExpression.EVERY_DAY_AT_2AM,
            keepLastAmount: 14,
        },
    },
    ffmpeg: {
        crf: 23,
        threads: 0,
        preset: 'ultrafast',
        targetVideoCodec: enum_1.VideoCodec.H264,
        acceptedVideoCodecs: [enum_1.VideoCodec.H264],
        targetAudioCodec: enum_1.AudioCodec.AAC,
        acceptedAudioCodecs: [enum_1.AudioCodec.AAC, enum_1.AudioCodec.MP3, enum_1.AudioCodec.LIBOPUS, enum_1.AudioCodec.PCMS16LE],
        acceptedContainers: [enum_1.VideoContainer.MOV, enum_1.VideoContainer.OGG, enum_1.VideoContainer.WEBM],
        targetResolution: '720',
        maxBitrate: '0',
        bframes: -1,
        refs: 0,
        gopSize: 0,
        temporalAQ: false,
        cqMode: enum_1.CQMode.AUTO,
        twoPass: false,
        preferredHwDevice: 'auto',
        transcode: enum_1.TranscodePolicy.REQUIRED,
        tonemap: enum_1.ToneMapping.HABLE,
        accel: enum_1.TranscodeHWAccel.DISABLED,
        accelDecode: false,
    },
    job: {
        [enum_1.QueueName.BACKGROUND_TASK]: { concurrency: 5 },
        [enum_1.QueueName.SMART_SEARCH]: { concurrency: 2 },
        [enum_1.QueueName.METADATA_EXTRACTION]: { concurrency: 5 },
        [enum_1.QueueName.FACE_DETECTION]: { concurrency: 2 },
        [enum_1.QueueName.SEARCH]: { concurrency: 5 },
        [enum_1.QueueName.SIDECAR]: { concurrency: 5 },
        [enum_1.QueueName.LIBRARY]: { concurrency: 5 },
        [enum_1.QueueName.MIGRATION]: { concurrency: 5 },
        [enum_1.QueueName.THUMBNAIL_GENERATION]: { concurrency: 3 },
        [enum_1.QueueName.VIDEO_CONVERSION]: { concurrency: 1 },
        [enum_1.QueueName.NOTIFICATION]: { concurrency: 5 },
    },
    logging: {
        enabled: true,
        level: enum_1.LogLevel.LOG,
    },
    machineLearning: {
        enabled: process.env.IMMICH_MACHINE_LEARNING_ENABLED !== 'false',
        urls: [process.env.IMMICH_MACHINE_LEARNING_URL || 'http://immich-machine-learning:3003'],
        clip: {
            enabled: true,
            modelName: 'ViT-B-32__openai',
        },
        duplicateDetection: {
            enabled: true,
            maxDistance: 0.01,
        },
        facialRecognition: {
            enabled: true,
            modelName: 'buffalo_l',
            minScore: 0.7,
            maxDistance: 0.5,
            minFaces: 3,
        },
    },
    map: {
        enabled: true,
        lightStyle: 'https://tiles.immich.cloud/v1/style/light.json',
        darkStyle: 'https://tiles.immich.cloud/v1/style/dark.json',
    },
    reverseGeocoding: {
        enabled: true,
    },
    metadata: {
        faces: {
            import: false,
        },
    },
    oauth: {
        autoLaunch: false,
        autoRegister: true,
        buttonText: 'Login with OAuth',
        clientId: '',
        clientSecret: '',
        defaultStorageQuota: 0,
        enabled: false,
        issuerUrl: '',
        mobileOverrideEnabled: false,
        mobileRedirectUri: '',
        scope: 'openid email profile',
        signingAlgorithm: 'RS256',
        profileSigningAlgorithm: 'none',
        storageLabelClaim: 'preferred_username',
        storageQuotaClaim: 'immich_quota',
    },
    passwordLogin: {
        enabled: true,
    },
    storageTemplate: {
        enabled: false,
        hashVerificationEnabled: true,
        template: '{{y}}/{{y}}-{{MM}}-{{dd}}/{{filename}}',
    },
    image: {
        thumbnail: {
            format: enum_1.ImageFormat.WEBP,
            size: 250,
            quality: 80,
        },
        preview: {
            format: enum_1.ImageFormat.JPEG,
            size: 1440,
            quality: 80,
        },
        colorspace: enum_1.Colorspace.P3,
        extractEmbedded: false,
        fullsize: {
            enabled: false,
            format: enum_1.ImageFormat.JPEG,
            quality: 80,
        },
    },
    newVersionCheck: {
        enabled: true,
    },
    trash: {
        enabled: true,
        days: 30,
    },
    theme: {
        customCss: '',
    },
    library: {
        scan: {
            enabled: true,
            cronExpression: schedule_1.CronExpression.EVERY_DAY_AT_MIDNIGHT,
        },
        watch: {
            enabled: false,
        },
    },
    server: {
        externalDomain: '',
        loginPageMessage: '',
        publicUsers: true,
    },
    notifications: {
        smtp: {
            enabled: false,
            from: '',
            replyTo: '',
            transport: {
                ignoreCert: false,
                host: '',
                port: 587,
                username: '',
                password: '',
            },
        },
    },
    templates: {
        email: {
            welcomeTemplate: '',
            albumInviteTemplate: '',
            albumUpdateTemplate: '',
        },
    },
    user: {
        deleteDelay: 7,
    },
});
//# sourceMappingURL=config.js.map