#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
process.env.DB_URL = 'postgres://postgres:postgres@localhost:5432/immich';
const core_1 = require("@nestjs/core");
const app_module_1 = require("../app.module");
const misc_1 = require("../utils/misc");
const sync = async () => {
    const app = await core_1.NestFactory.create(app_module_1.ApiModule, { preview: true });
    (0, misc_1.useSwagger)(app, { write: true });
    await app.close();
};
sync()
    .then(() => {
    console.log('Done');
    process.exit(0);
})
    .catch((error) => {
    console.error(error);
    console.log('Something went wrong');
    process.exit(1);
});
//# sourceMappingURL=sync-open-api.js.map