import { OnModuleDestroy, OnModuleInit, ValidationPipe } from '@nestjs/common';
import { ImmichWorker } from 'src/enum';
import { AuthGuard } from 'src/middleware/auth.guard';
import { ErrorInterceptor } from 'src/middleware/error.interceptor';
import { FileUploadInterceptor } from 'src/middleware/file-upload.interceptor';
import { GlobalExceptionFilter } from 'src/middleware/global-exception.filter';
import { LoggingInterceptor } from 'src/middleware/logging.interceptor';
import { EventRepository } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { TelemetryRepository } from 'src/repositories/telemetry.repository';
import { AuthService } from 'src/services/auth.service';
import { CliService } from 'src/services/cli.service';
import { JobService } from 'src/services/job.service';
export declare const middleware: (typeof FileUploadInterceptor | {
    provide: string;
    useClass: typeof GlobalExceptionFilter;
    useValue?: undefined;
} | {
    provide: string;
    useValue: ValidationPipe;
    useClass?: undefined;
} | {
    provide: string;
    useClass: typeof LoggingInterceptor;
    useValue?: undefined;
} | {
    provide: string;
    useClass: typeof ErrorInterceptor;
    useValue?: undefined;
} | {
    provide: string;
    useClass: typeof AuthGuard;
    useValue?: undefined;
})[];
declare class BaseModule implements OnModuleInit, OnModuleDestroy {
    private worker;
    private eventRepository;
    private jobService;
    private telemetryRepository;
    private authService;
    constructor(worker: ImmichWorker, logger: LoggingRepository, eventRepository: EventRepository, jobService: JobService, telemetryRepository: TelemetryRepository, authService: AuthService);
    onModuleInit(): Promise<void>;
    onModuleDestroy(): Promise<void>;
}
export declare class ApiModule extends BaseModule {
}
export declare class MicroservicesModule extends BaseModule {
}
export declare class ImmichAdminModule implements OnModuleDestroy {
    private service;
    constructor(service: CliService);
    onModuleDestroy(): Promise<void>;
}
export {};
