# Installation
> `npm install --save @types/byte-size`

# Summary
This package contains type definitions for byte-size (https://github.com/75lb/byte-size#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/byte-size.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/byte-size/index.d.ts)
````ts
export interface ByteSizeOptions {
    precision?: number;
    units?: string;
    customUnits?: object;
    toStringFn?: () => string;
    locale?: string | string[];
}

export interface ByteSizeResult {
    value: string;
    unit: string;
    long: string;
    toString: () => string;
}

declare function byteSize(bytes: number, options?: ByteSizeOptions): ByteSizeResult;

declare namespace byteSize {
    function defaultOptions(options: ByteSizeOptions): void;
}

export default byteSize;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: none

# Credits
These definitions were written by [lntel](https://github.com/lntel).
