import { vi as vitest, type Mock } from 'vitest';
declare global {
    var fetchMock: FetchMock;
    namespace NodeJS {
        interface Global {
            fetchMock: FetchMock;
        }
    }
}
export type FetchMock = Mock<typeof global.fetch> & FetchMockObject;
declare class FetchMockObject {
    private mockedFetch;
    private originalFetch;
    private chainingResultProvider;
    readonly isMocking: Mock<(input: RequestInput, requestInit?: RequestInit) => boolean>;
    constructor(mockedFetch: Mock<typeof global.fetch>, originalFetch: typeof global.fetch, chainingResultProvider: () => FetchMock);
    enableMocks(): FetchMock;
    disableMocks(): FetchMock;
    resetMocks(): FetchMock;
    mockResponse(responseProvider: ResponseProvider, params?: MockParams): FetchMock;
    mockResponseOnce(responseProvider: ResponseProvider, params?: MockParams): FetchMock;
    mockResponseIf(urlOrPredicate: UrlOrPredicate, responseProvider: ResponseProvider, params?: MockParams): FetchMock;
    mockResponseOnceIf(urlOrPredicate: UrlOrPredicate, responseProvider: ResponseProvider, params?: MockParams): FetchMock;
    mockResponses(...responses: Array<ResponseBody | [ResponseBody, MockParams?] | ResponseProvider>): FetchMock;
    mockAbort(): FetchMock;
    mockAbortOnce(): FetchMock;
    mockReject(error?: ErrorOrFunction): FetchMock;
    mockRejectOnce(error?: ErrorOrFunction): FetchMock;
    doMock(responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    doMockOnce(responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    doMockIf(urlOrPredicate: UrlOrPredicate, responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    doMockOnceIf(urlOrPredicate: UrlOrPredicate, responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    dontMock(): FetchMock;
    dontMockOnce(): FetchMock;
    dontMockIf(urlOrPredicate: UrlOrPredicate): FetchMock;
    dontMockOnceIf(urlOrPredicate: UrlOrPredicate): FetchMock;
    requests(): Request[];
    /**
     * alias for mockResponseOnce
     */
    once(responseProvider: ResponseProvider, params?: MockParams): FetchMock;
    /**
     * alias for doMockOnce
     */
    mockOnce(responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    /**
     * alias for doMockIf
     */
    mockIf(urlOrPredicate: UrlOrPredicate, responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
    /**
     * alias for doMockOnceIf
     */
    mockOnceIf(urlOrPredicate: UrlOrPredicate, responseProvider?: ResponseProvider, params?: MockParams): FetchMock;
}
export type UrlOrPredicate = string | RegExp | ((input: Request) => boolean);
export type RequestInput = string | URL | Request;
export type ResponseProvider = ResponseLike | ((request: Request) => ResponseLike | Promise<ResponseLike>);
export type ResponseLike = MockResponse | ResponseBody | Response;
export type ResponseBody = string | null | undefined;
export type ErrorOrFunction = Error | ResponseBody | ResponseProvider;
export interface MockParams {
    status?: number;
    statusText?: string;
    headers?: [string, string][] | Record<string, string>;
    url?: string;
    /** Set >= 1 to have redirected return true. Only applicable to Node.js */
    counter?: number;
}
export interface MockResponse extends MockParams {
    body?: string;
}
export default function createFetchMock(vi: typeof vitest): FetchMock;
export declare function canParseURL(url: string): boolean;
export {};
