# builtin-modules

> A static list of the Node.js builtin modules from the latest Node.js version

The list is just a [JSON file](builtin-modules.json) and can be used anywhere.

## Install

```sh
npm install builtin-modules
```

## Usage

```js
import builtinModules from 'builtin-modules';

console.log(builtinModules);
//=> ['assert', 'buffer', …]
```

## Tip

To get a list from the current Node.js version, use the built-in API:

```js
import {builtinModules} from 'node:module';
```

## Related

- [is-builtin-module](https://github.com/sindresorhus/is-builtin-module) - Check if a string matches the name of a Node.js builtin module
