// Generated by go-wayland-scanner
// https://github.com/yaslama/go-wayland/cmd/go-wayland-scanner
// XML file : internal/proto/xml/wlr-screencopy-unstable-v1.xml
//
// wlr_screencopy_unstable_v1 Protocol Copyright:
//
// Copyright © 2018 Simon Ser
// Copyright © 2019 Andri Yngvason
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice (including the next
// paragraph) shall be included in all copies or substantial portions of the
// Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

package wlr_screencopy

import "github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/client"

// ZwlrScreencopyManagerV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrScreencopyManagerV1InterfaceName = "zwlr_screencopy_manager_v1"

// ZwlrScreencopyManagerV1 : manager to inform clients and begin capturing
//
// This object is a manager which offers requests to start capturing from a
// source.
type ZwlrScreencopyManagerV1 struct {
	client.BaseProxy
}

// NewZwlrScreencopyManagerV1 : manager to inform clients and begin capturing
//
// This object is a manager which offers requests to start capturing from a
// source.
func NewZwlrScreencopyManagerV1(ctx *client.Context) *ZwlrScreencopyManagerV1 {
	zwlrScreencopyManagerV1 := &ZwlrScreencopyManagerV1{}
	ctx.Register(zwlrScreencopyManagerV1)
	return zwlrScreencopyManagerV1
}

// CaptureOutput : capture an output
//
// Capture the next frame of an entire output.
//
//	overlayCursor: composite cursor onto the frame
func (i *ZwlrScreencopyManagerV1) CaptureOutput(overlayCursor int32, output *client.Output) (*ZwlrScreencopyFrameV1, error) {
	frame := NewZwlrScreencopyFrameV1(i.Context())
	const opcode = 0
	const _reqBufLen = 8 + 4 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], frame.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(overlayCursor))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], output.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return frame, err
}

// CaptureOutputRegion : capture an output's region
//
// Capture the next frame of an output's region.
//
// The region is given in output logical coordinates, see
// xdg_output.logical_size. The region will be clipped to the output's
// extents.
//
//	overlayCursor: composite cursor onto the frame
func (i *ZwlrScreencopyManagerV1) CaptureOutputRegion(overlayCursor int32, output *client.Output, x, y, width, height int32) (*ZwlrScreencopyFrameV1, error) {
	frame := NewZwlrScreencopyFrameV1(i.Context())
	const opcode = 1
	const _reqBufLen = 8 + 4 + 4 + 4 + 4 + 4 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], frame.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(overlayCursor))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], output.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(x))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(y))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(width))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(height))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return frame, err
}

// Destroy : destroy the manager
//
// All objects created by the manager will still remain valid, until their
// appropriate destroy request has been called.
func (i *ZwlrScreencopyManagerV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 2
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// ZwlrScreencopyFrameV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrScreencopyFrameV1InterfaceName = "zwlr_screencopy_frame_v1"

// ZwlrScreencopyFrameV1 : a frame ready for copy
//
// This object represents a single frame.
//
// When created, a series of buffer events will be sent, each representing a
// supported buffer type. The "buffer_done" event is sent afterwards to
// indicate that all supported buffer types have been enumerated. The client
// will then be able to send a "copy" request. If the capture is successful,
// the compositor will send a "flags" event followed by a "ready" event.
//
// For objects version 2 or lower, wl_shm buffers are always supported, ie.
// the "buffer" event is guaranteed to be sent.
//
// If the capture failed, the "failed" event is sent. This can happen anytime
// before the "ready" event.
//
// Once either a "ready" or a "failed" event is received, the client should
// destroy the frame.
type ZwlrScreencopyFrameV1 struct {
	client.BaseProxy
	bufferHandler      ZwlrScreencopyFrameV1BufferHandlerFunc
	flagsHandler       ZwlrScreencopyFrameV1FlagsHandlerFunc
	readyHandler       ZwlrScreencopyFrameV1ReadyHandlerFunc
	failedHandler      ZwlrScreencopyFrameV1FailedHandlerFunc
	damageHandler      ZwlrScreencopyFrameV1DamageHandlerFunc
	linuxDmabufHandler ZwlrScreencopyFrameV1LinuxDmabufHandlerFunc
	bufferDoneHandler  ZwlrScreencopyFrameV1BufferDoneHandlerFunc
}

// NewZwlrScreencopyFrameV1 : a frame ready for copy
//
// This object represents a single frame.
//
// When created, a series of buffer events will be sent, each representing a
// supported buffer type. The "buffer_done" event is sent afterwards to
// indicate that all supported buffer types have been enumerated. The client
// will then be able to send a "copy" request. If the capture is successful,
// the compositor will send a "flags" event followed by a "ready" event.
//
// For objects version 2 or lower, wl_shm buffers are always supported, ie.
// the "buffer" event is guaranteed to be sent.
//
// If the capture failed, the "failed" event is sent. This can happen anytime
// before the "ready" event.
//
// Once either a "ready" or a "failed" event is received, the client should
// destroy the frame.
func NewZwlrScreencopyFrameV1(ctx *client.Context) *ZwlrScreencopyFrameV1 {
	zwlrScreencopyFrameV1 := &ZwlrScreencopyFrameV1{}
	ctx.Register(zwlrScreencopyFrameV1)
	return zwlrScreencopyFrameV1
}

// Copy : copy the frame
//
// Copy the frame to the supplied buffer. The buffer must have the
// correct size, see zwlr_screencopy_frame_v1.buffer and
// zwlr_screencopy_frame_v1.linux_dmabuf. The buffer needs to have a
// supported format.
//
// If the frame is successfully copied, "flags" and "ready" events are
// sent. Otherwise, a "failed" event is sent.
func (i *ZwlrScreencopyFrameV1) Copy(buffer *client.Buffer) error {
	const opcode = 0
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], buffer.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Destroy : delete this object, used or not
//
// Destroys the frame. This request can be sent at any time by the client.
func (i *ZwlrScreencopyFrameV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 1
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// CopyWithDamage : copy the frame when it's damaged
//
// Same as copy, except it waits until there is damage to copy.
func (i *ZwlrScreencopyFrameV1) CopyWithDamage(buffer *client.Buffer) error {
	const opcode = 2
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], buffer.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrScreencopyFrameV1Error uint32

// ZwlrScreencopyFrameV1Error :
const (
	// ZwlrScreencopyFrameV1ErrorAlreadyUsed : the object has already been used to copy a wl_buffer
	ZwlrScreencopyFrameV1ErrorAlreadyUsed ZwlrScreencopyFrameV1Error = 0
	// ZwlrScreencopyFrameV1ErrorInvalidBuffer : buffer attributes are invalid
	ZwlrScreencopyFrameV1ErrorInvalidBuffer ZwlrScreencopyFrameV1Error = 1
)

func (e ZwlrScreencopyFrameV1Error) Name() string {
	switch e {
	case ZwlrScreencopyFrameV1ErrorAlreadyUsed:
		return "already_used"
	case ZwlrScreencopyFrameV1ErrorInvalidBuffer:
		return "invalid_buffer"
	default:
		return ""
	}
}

func (e ZwlrScreencopyFrameV1Error) Value() string {
	switch e {
	case ZwlrScreencopyFrameV1ErrorAlreadyUsed:
		return "0"
	case ZwlrScreencopyFrameV1ErrorInvalidBuffer:
		return "1"
	default:
		return ""
	}
}

func (e ZwlrScreencopyFrameV1Error) String() string {
	return e.Name() + "=" + e.Value()
}

type ZwlrScreencopyFrameV1Flags uint32

// ZwlrScreencopyFrameV1Flags :
const (
	// ZwlrScreencopyFrameV1FlagsYInvert : contents are y-inverted
	ZwlrScreencopyFrameV1FlagsYInvert ZwlrScreencopyFrameV1Flags = 1
)

func (e ZwlrScreencopyFrameV1Flags) Name() string {
	switch e {
	case ZwlrScreencopyFrameV1FlagsYInvert:
		return "y_invert"
	default:
		return ""
	}
}

func (e ZwlrScreencopyFrameV1Flags) Value() string {
	switch e {
	case ZwlrScreencopyFrameV1FlagsYInvert:
		return "1"
	default:
		return ""
	}
}

func (e ZwlrScreencopyFrameV1Flags) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrScreencopyFrameV1BufferEvent : wl_shm buffer information
//
// Provides information about wl_shm buffer parameters that need to be
// used for this frame. This event is sent once after the frame is created
// if wl_shm buffers are supported.
type ZwlrScreencopyFrameV1BufferEvent struct {
	Format uint32
	Width  uint32
	Height uint32
	Stride uint32
}
type ZwlrScreencopyFrameV1BufferHandlerFunc func(ZwlrScreencopyFrameV1BufferEvent)

// SetBufferHandler : sets handler for ZwlrScreencopyFrameV1BufferEvent
func (i *ZwlrScreencopyFrameV1) SetBufferHandler(f ZwlrScreencopyFrameV1BufferHandlerFunc) {
	i.bufferHandler = f
}

// ZwlrScreencopyFrameV1FlagsEvent : frame flags
//
// Provides flags about the frame. This event is sent once before the
// "ready" event.
type ZwlrScreencopyFrameV1FlagsEvent struct {
	Flags uint32
}
type ZwlrScreencopyFrameV1FlagsHandlerFunc func(ZwlrScreencopyFrameV1FlagsEvent)

// SetFlagsHandler : sets handler for ZwlrScreencopyFrameV1FlagsEvent
func (i *ZwlrScreencopyFrameV1) SetFlagsHandler(f ZwlrScreencopyFrameV1FlagsHandlerFunc) {
	i.flagsHandler = f
}

// ZwlrScreencopyFrameV1ReadyEvent : indicates frame is available for reading
//
// Called as soon as the frame is copied, indicating it is available
// for reading. This event includes the time at which the presentation took place.
//
// The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
// each component being an unsigned 32-bit value. Whole seconds are in
// tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
// and the additional fractional part in tv_nsec as nanoseconds. Hence,
// for valid timestamps tv_nsec must be in [0, 999999999]. The seconds part
// may have an arbitrary offset at start.
//
// After receiving this event, the client should destroy the object.
type ZwlrScreencopyFrameV1ReadyEvent struct {
	TvSecHi uint32
	TvSecLo uint32
	TvNsec  uint32
}
type ZwlrScreencopyFrameV1ReadyHandlerFunc func(ZwlrScreencopyFrameV1ReadyEvent)

// SetReadyHandler : sets handler for ZwlrScreencopyFrameV1ReadyEvent
func (i *ZwlrScreencopyFrameV1) SetReadyHandler(f ZwlrScreencopyFrameV1ReadyHandlerFunc) {
	i.readyHandler = f
}

// ZwlrScreencopyFrameV1FailedEvent : frame copy failed
//
// This event indicates that the attempted frame copy has failed.
//
// After receiving this event, the client should destroy the object.
type ZwlrScreencopyFrameV1FailedEvent struct{}
type ZwlrScreencopyFrameV1FailedHandlerFunc func(ZwlrScreencopyFrameV1FailedEvent)

// SetFailedHandler : sets handler for ZwlrScreencopyFrameV1FailedEvent
func (i *ZwlrScreencopyFrameV1) SetFailedHandler(f ZwlrScreencopyFrameV1FailedHandlerFunc) {
	i.failedHandler = f
}

// ZwlrScreencopyFrameV1DamageEvent : carries the coordinates of the damaged region
//
// This event is sent right before the ready event when copy_with_damage is
// requested. It may be generated multiple times for each copy_with_damage
// request.
//
// The arguments describe a box around an area that has changed since the
// last copy request that was derived from the current screencopy manager
// instance.
//
// The union of all regions received between the call to copy_with_damage
// and a ready event is the total damage since the prior ready event.
type ZwlrScreencopyFrameV1DamageEvent struct {
	X      uint32
	Y      uint32
	Width  uint32
	Height uint32
}
type ZwlrScreencopyFrameV1DamageHandlerFunc func(ZwlrScreencopyFrameV1DamageEvent)

// SetDamageHandler : sets handler for ZwlrScreencopyFrameV1DamageEvent
func (i *ZwlrScreencopyFrameV1) SetDamageHandler(f ZwlrScreencopyFrameV1DamageHandlerFunc) {
	i.damageHandler = f
}

// ZwlrScreencopyFrameV1LinuxDmabufEvent : linux-dmabuf buffer information
//
// Provides information about linux-dmabuf buffer parameters that need to
// be used for this frame. This event is sent once after the frame is
// created if linux-dmabuf buffers are supported.
type ZwlrScreencopyFrameV1LinuxDmabufEvent struct {
	Format uint32
	Width  uint32
	Height uint32
}
type ZwlrScreencopyFrameV1LinuxDmabufHandlerFunc func(ZwlrScreencopyFrameV1LinuxDmabufEvent)

// SetLinuxDmabufHandler : sets handler for ZwlrScreencopyFrameV1LinuxDmabufEvent
func (i *ZwlrScreencopyFrameV1) SetLinuxDmabufHandler(f ZwlrScreencopyFrameV1LinuxDmabufHandlerFunc) {
	i.linuxDmabufHandler = f
}

// ZwlrScreencopyFrameV1BufferDoneEvent : all buffer types reported
//
// This event is sent once after all buffer events have been sent.
//
// The client should proceed to create a buffer of one of the supported
// types, and send a "copy" request.
type ZwlrScreencopyFrameV1BufferDoneEvent struct{}
type ZwlrScreencopyFrameV1BufferDoneHandlerFunc func(ZwlrScreencopyFrameV1BufferDoneEvent)

// SetBufferDoneHandler : sets handler for ZwlrScreencopyFrameV1BufferDoneEvent
func (i *ZwlrScreencopyFrameV1) SetBufferDoneHandler(f ZwlrScreencopyFrameV1BufferDoneHandlerFunc) {
	i.bufferDoneHandler = f
}

func (i *ZwlrScreencopyFrameV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.bufferHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1BufferEvent
		l := 0
		e.Format = client.Uint32(data[l : l+4])
		l += 4
		e.Width = client.Uint32(data[l : l+4])
		l += 4
		e.Height = client.Uint32(data[l : l+4])
		l += 4
		e.Stride = client.Uint32(data[l : l+4])
		l += 4

		i.bufferHandler(e)
	case 1:
		if i.flagsHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1FlagsEvent
		l := 0
		e.Flags = client.Uint32(data[l : l+4])
		l += 4

		i.flagsHandler(e)
	case 2:
		if i.readyHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1ReadyEvent
		l := 0
		e.TvSecHi = client.Uint32(data[l : l+4])
		l += 4
		e.TvSecLo = client.Uint32(data[l : l+4])
		l += 4
		e.TvNsec = client.Uint32(data[l : l+4])
		l += 4

		i.readyHandler(e)
	case 3:
		if i.failedHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1FailedEvent

		i.failedHandler(e)
	case 4:
		if i.damageHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1DamageEvent
		l := 0
		e.X = client.Uint32(data[l : l+4])
		l += 4
		e.Y = client.Uint32(data[l : l+4])
		l += 4
		e.Width = client.Uint32(data[l : l+4])
		l += 4
		e.Height = client.Uint32(data[l : l+4])
		l += 4

		i.damageHandler(e)
	case 5:
		if i.linuxDmabufHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1LinuxDmabufEvent
		l := 0
		e.Format = client.Uint32(data[l : l+4])
		l += 4
		e.Width = client.Uint32(data[l : l+4])
		l += 4
		e.Height = client.Uint32(data[l : l+4])
		l += 4

		i.linuxDmabufHandler(e)
	case 6:
		if i.bufferDoneHandler == nil {
			return
		}
		var e ZwlrScreencopyFrameV1BufferDoneEvent

		i.bufferDoneHandler(e)
	}
}
