// Generated by go-wayland-scanner
// https://github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/cmd/go-wayland-scanner
// XML file : /home/brandon/repos/dankdots/wlr-output-management-unstable-v1.xml
//
// wlr_output_management_unstable_v1 Protocol Copyright:
//
// Copyright © 2019 Purism SPC
//
// Permission to use, copy, modify, distribute, and sell this
// software and its documentation for any purpose is hereby granted
// without fee, provided that the above copyright notice appear in
// all copies and that both that copyright notice and this permission
// notice appear in supporting documentation, and that the name of
// the copyright holders not be used in advertising or publicity
// pertaining to distribution of the software without specific,
// written prior permission.  The copyright holders make no
// representations about the suitability of this software for any
// purpose.  It is provided "as is" without express or implied
// warranty.
//
// THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
// AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
// ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
// THIS SOFTWARE.

package wlr_output_management

import (
	"reflect"
	"unsafe"

	"github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/client"
	"github.com/AvengeMedia/DankMaterialShell/core/pkg/syncmap"
)

func registerServerProxy(ctx *client.Context, proxy client.Proxy, serverID uint32) {
	defer func() {
		if r := recover(); r != nil {
			return
		}
	}()
	ctxVal := reflect.ValueOf(ctx).Elem()
	objectsField := ctxVal.FieldByName("objects")
	if !objectsField.IsValid() {
		return
	}
	objectsMapPtr := unsafe.Pointer(objectsField.UnsafeAddr())
	objectsMap := (*syncmap.Map[uint32, client.Proxy])(objectsMapPtr)
	objectsMap.Store(serverID, proxy)
}

// ZwlrOutputManagerV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrOutputManagerV1InterfaceName = "zwlr_output_manager_v1"

// ZwlrOutputManagerV1 : output device configuration manager
//
// This interface is a manager that allows reading and writing the current
// output device configuration.
//
// Output devices that display pixels (e.g. a physical monitor or a virtual
// output in a window) are represented as heads. Heads cannot be created nor
// destroyed by the client, but they can be enabled or disabled and their
// properties can be changed. Each head may have one or more available modes.
//
// Whenever a head appears (e.g. a monitor is plugged in), it will be
// advertised via the head event. Immediately after the output manager is
// bound, all current heads are advertised.
//
// Whenever a head's properties change, the relevant wlr_output_head events
// will be sent. Not all head properties will be sent: only properties that
// have changed need to.
//
// Whenever a head disappears (e.g. a monitor is unplugged), a
// wlr_output_head.finished event will be sent.
//
// After one or more heads appear, change or disappear, the done event will
// be sent. It carries a serial which can be used in a create_configuration
// request to update heads properties.
//
// The information obtained from this protocol should only be used for output
// configuration purposes. This protocol is not designed to be a generic
// output property advertisement protocol for regular clients. Instead,
// protocols such as xdg-output should be used.
type ZwlrOutputManagerV1 struct {
	client.BaseProxy
	headHandler     ZwlrOutputManagerV1HeadHandlerFunc
	doneHandler     ZwlrOutputManagerV1DoneHandlerFunc
	finishedHandler ZwlrOutputManagerV1FinishedHandlerFunc
}

// NewZwlrOutputManagerV1 : output device configuration manager
//
// This interface is a manager that allows reading and writing the current
// output device configuration.
//
// Output devices that display pixels (e.g. a physical monitor or a virtual
// output in a window) are represented as heads. Heads cannot be created nor
// destroyed by the client, but they can be enabled or disabled and their
// properties can be changed. Each head may have one or more available modes.
//
// Whenever a head appears (e.g. a monitor is plugged in), it will be
// advertised via the head event. Immediately after the output manager is
// bound, all current heads are advertised.
//
// Whenever a head's properties change, the relevant wlr_output_head events
// will be sent. Not all head properties will be sent: only properties that
// have changed need to.
//
// Whenever a head disappears (e.g. a monitor is unplugged), a
// wlr_output_head.finished event will be sent.
//
// After one or more heads appear, change or disappear, the done event will
// be sent. It carries a serial which can be used in a create_configuration
// request to update heads properties.
//
// The information obtained from this protocol should only be used for output
// configuration purposes. This protocol is not designed to be a generic
// output property advertisement protocol for regular clients. Instead,
// protocols such as xdg-output should be used.
func NewZwlrOutputManagerV1(ctx *client.Context) *ZwlrOutputManagerV1 {
	zwlrOutputManagerV1 := &ZwlrOutputManagerV1{}
	ctx.Register(zwlrOutputManagerV1)
	return zwlrOutputManagerV1
}

// CreateConfiguration : create a new output configuration object
//
// Create a new output configuration object. This allows to update head
// properties.
func (i *ZwlrOutputManagerV1) CreateConfiguration(serial uint32) (*ZwlrOutputConfigurationV1, error) {
	id := NewZwlrOutputConfigurationV1(i.Context())
	const opcode = 0
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], id.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(serial))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return id, err
}

// Stop : stop sending events
//
// Indicates the client no longer wishes to receive events for output
// configuration changes. However the compositor may emit further events,
// until the finished event is emitted.
//
// The client must not send any more requests after this one.
func (i *ZwlrOutputManagerV1) Stop() error {
	const opcode = 1
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

func (i *ZwlrOutputManagerV1) Destroy() error {
	i.MarkZombie()
	return nil
}

// ZwlrOutputManagerV1HeadEvent : introduce a new head
//
// This event introduces a new head. This happens whenever a new head
// appears (e.g. a monitor is plugged in) or after the output manager is
// bound.
type ZwlrOutputManagerV1HeadEvent struct {
	Head *ZwlrOutputHeadV1
}
type ZwlrOutputManagerV1HeadHandlerFunc func(ZwlrOutputManagerV1HeadEvent)

// SetHeadHandler : sets handler for ZwlrOutputManagerV1HeadEvent
func (i *ZwlrOutputManagerV1) SetHeadHandler(f ZwlrOutputManagerV1HeadHandlerFunc) {
	i.headHandler = f
}

// ZwlrOutputManagerV1DoneEvent : sent all information about current configuration
//
// This event is sent after all information has been sent after binding to
// the output manager object and after any subsequent changes. This applies
// to child head and mode objects as well. In other words, this event is
// sent whenever a head or mode is created or destroyed and whenever one of
// their properties has been changed. Not all state is re-sent each time
// the current configuration changes: only the actual changes are sent.
//
// This allows changes to the output configuration to be seen as atomic,
// even if they happen via multiple events.
//
// A serial is sent to be used in a future create_configuration request.
type ZwlrOutputManagerV1DoneEvent struct {
	Serial uint32
}
type ZwlrOutputManagerV1DoneHandlerFunc func(ZwlrOutputManagerV1DoneEvent)

// SetDoneHandler : sets handler for ZwlrOutputManagerV1DoneEvent
func (i *ZwlrOutputManagerV1) SetDoneHandler(f ZwlrOutputManagerV1DoneHandlerFunc) {
	i.doneHandler = f
}

// ZwlrOutputManagerV1FinishedEvent : the compositor has finished with the manager
//
// This event indicates that the compositor is done sending manager events.
// The compositor will destroy the object immediately after sending this
// event, so it will become invalid and the client should release any
// resources associated with it.
type ZwlrOutputManagerV1FinishedEvent struct{}
type ZwlrOutputManagerV1FinishedHandlerFunc func(ZwlrOutputManagerV1FinishedEvent)

// SetFinishedHandler : sets handler for ZwlrOutputManagerV1FinishedEvent
func (i *ZwlrOutputManagerV1) SetFinishedHandler(f ZwlrOutputManagerV1FinishedHandlerFunc) {
	i.finishedHandler = f
}

func (i *ZwlrOutputManagerV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.headHandler == nil {
			return
		}
		var e ZwlrOutputManagerV1HeadEvent
		l := 0
		objectID := client.Uint32(data[l : l+4])
		proxy := i.Context().GetProxy(objectID)
		if proxy != nil {
			e.Head = proxy.(*ZwlrOutputHeadV1)
		} else {
			head := &ZwlrOutputHeadV1{}
			head.SetContext(i.Context())
			head.SetID(objectID)
			registerServerProxy(i.Context(), head, objectID)
			e.Head = head
		}
		l += 4

		i.headHandler(e)
	case 1:
		if i.doneHandler == nil {
			return
		}
		var e ZwlrOutputManagerV1DoneEvent
		l := 0
		e.Serial = client.Uint32(data[l : l+4])
		l += 4

		i.doneHandler(e)
	case 2:
		if i.finishedHandler == nil {
			return
		}
		var e ZwlrOutputManagerV1FinishedEvent

		i.finishedHandler(e)
	}
}

// ZwlrOutputHeadV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrOutputHeadV1InterfaceName = "zwlr_output_head_v1"

// ZwlrOutputHeadV1 : output device
//
// A head is an output device. The difference between a wl_output object and
// a head is that heads are advertised even if they are turned off. A head
// object only advertises properties and cannot be used directly to change
// them.
//
// A head has some read-only properties: modes, name, description and
// physical_size. These cannot be changed by clients.
//
// Other properties can be updated via a wlr_output_configuration object.
//
// Properties sent via this interface are applied atomically via the
// wlr_output_manager.done event. No guarantees are made regarding the order
// in which properties are sent.
type ZwlrOutputHeadV1 struct {
	client.BaseProxy
	nameHandler         ZwlrOutputHeadV1NameHandlerFunc
	descriptionHandler  ZwlrOutputHeadV1DescriptionHandlerFunc
	physicalSizeHandler ZwlrOutputHeadV1PhysicalSizeHandlerFunc
	modeHandler         ZwlrOutputHeadV1ModeHandlerFunc
	enabledHandler      ZwlrOutputHeadV1EnabledHandlerFunc
	currentModeHandler  ZwlrOutputHeadV1CurrentModeHandlerFunc
	positionHandler     ZwlrOutputHeadV1PositionHandlerFunc
	transformHandler    ZwlrOutputHeadV1TransformHandlerFunc
	scaleHandler        ZwlrOutputHeadV1ScaleHandlerFunc
	finishedHandler     ZwlrOutputHeadV1FinishedHandlerFunc
	makeHandler         ZwlrOutputHeadV1MakeHandlerFunc
	modelHandler        ZwlrOutputHeadV1ModelHandlerFunc
	serialNumberHandler ZwlrOutputHeadV1SerialNumberHandlerFunc
	adaptiveSyncHandler ZwlrOutputHeadV1AdaptiveSyncHandlerFunc
}

// NewZwlrOutputHeadV1 : output device
//
// A head is an output device. The difference between a wl_output object and
// a head is that heads are advertised even if they are turned off. A head
// object only advertises properties and cannot be used directly to change
// them.
//
// A head has some read-only properties: modes, name, description and
// physical_size. These cannot be changed by clients.
//
// Other properties can be updated via a wlr_output_configuration object.
//
// Properties sent via this interface are applied atomically via the
// wlr_output_manager.done event. No guarantees are made regarding the order
// in which properties are sent.
func NewZwlrOutputHeadV1(ctx *client.Context) *ZwlrOutputHeadV1 {
	zwlrOutputHeadV1 := &ZwlrOutputHeadV1{}
	ctx.Register(zwlrOutputHeadV1)
	return zwlrOutputHeadV1
}

// Release : destroy the head object
//
// This request indicates that the client will no longer use this head
// object.
func (i *ZwlrOutputHeadV1) Release() error {
	defer i.MarkZombie()
	const opcode = 0
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrOutputHeadV1AdaptiveSyncState uint32

// ZwlrOutputHeadV1AdaptiveSyncState :
const (
	// ZwlrOutputHeadV1AdaptiveSyncStateDisabled : adaptive sync is disabled
	ZwlrOutputHeadV1AdaptiveSyncStateDisabled ZwlrOutputHeadV1AdaptiveSyncState = 0
	// ZwlrOutputHeadV1AdaptiveSyncStateEnabled : adaptive sync is enabled
	ZwlrOutputHeadV1AdaptiveSyncStateEnabled ZwlrOutputHeadV1AdaptiveSyncState = 1
)

func (e ZwlrOutputHeadV1AdaptiveSyncState) Name() string {
	switch e {
	case ZwlrOutputHeadV1AdaptiveSyncStateDisabled:
		return "disabled"
	case ZwlrOutputHeadV1AdaptiveSyncStateEnabled:
		return "enabled"
	default:
		return ""
	}
}

func (e ZwlrOutputHeadV1AdaptiveSyncState) Value() string {
	switch e {
	case ZwlrOutputHeadV1AdaptiveSyncStateDisabled:
		return "0"
	case ZwlrOutputHeadV1AdaptiveSyncStateEnabled:
		return "1"
	default:
		return ""
	}
}

func (e ZwlrOutputHeadV1AdaptiveSyncState) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrOutputHeadV1NameEvent : head name
//
// This event describes the head name.
//
// The naming convention is compositor defined, but limited to alphanumeric
// characters and dashes (-). Each name is unique among all wlr_output_head
// objects, but if a wlr_output_head object is destroyed the same name may
// be reused later. The names will also remain consistent across sessions
// with the same hardware and software configuration.
//
// Examples of names include 'HDMI-A-1', 'WL-1', 'X11-1', etc. However, do
// not assume that the name is a reflection of an underlying DRM
// connector, X11 connection, etc.
//
// If this head matches a wl_output, the wl_output.name event must report
// the same name.
//
// The name event is sent after a wlr_output_head object is created. This
// event is only sent once per object, and the name does not change over
// the lifetime of the wlr_output_head object.
type ZwlrOutputHeadV1NameEvent struct {
	Name string
}
type ZwlrOutputHeadV1NameHandlerFunc func(ZwlrOutputHeadV1NameEvent)

// SetNameHandler : sets handler for ZwlrOutputHeadV1NameEvent
func (i *ZwlrOutputHeadV1) SetNameHandler(f ZwlrOutputHeadV1NameHandlerFunc) {
	i.nameHandler = f
}

// ZwlrOutputHeadV1DescriptionEvent : head description
//
// This event describes a human-readable description of the head.
//
// The description is a UTF-8 string with no convention defined for its
// contents. Examples might include 'Foocorp 11" Display' or 'Virtual X11
// output via :1'. However, do not assume that the name is a reflection of
// the make, model, serial of the underlying DRM connector or the display
// name of the underlying X11 connection, etc.
//
// If this head matches a wl_output, the wl_output.description event must
// report the same name.
//
// The description event is sent after a wlr_output_head object is created.
// This event is only sent once per object, and the description does not
// change over the lifetime of the wlr_output_head object.
type ZwlrOutputHeadV1DescriptionEvent struct {
	Description string
}
type ZwlrOutputHeadV1DescriptionHandlerFunc func(ZwlrOutputHeadV1DescriptionEvent)

// SetDescriptionHandler : sets handler for ZwlrOutputHeadV1DescriptionEvent
func (i *ZwlrOutputHeadV1) SetDescriptionHandler(f ZwlrOutputHeadV1DescriptionHandlerFunc) {
	i.descriptionHandler = f
}

// ZwlrOutputHeadV1PhysicalSizeEvent : head physical size
//
// This event describes the physical size of the head. This event is only
// sent if the head has a physical size (e.g. is not a projector or a
// virtual device).
//
// The physical size event is sent after a wlr_output_head object is created. This
// event is only sent once per object, and the physical size does not change over
// the lifetime of the wlr_output_head object.
type ZwlrOutputHeadV1PhysicalSizeEvent struct {
	Width  int32
	Height int32
}
type ZwlrOutputHeadV1PhysicalSizeHandlerFunc func(ZwlrOutputHeadV1PhysicalSizeEvent)

// SetPhysicalSizeHandler : sets handler for ZwlrOutputHeadV1PhysicalSizeEvent
func (i *ZwlrOutputHeadV1) SetPhysicalSizeHandler(f ZwlrOutputHeadV1PhysicalSizeHandlerFunc) {
	i.physicalSizeHandler = f
}

// ZwlrOutputHeadV1ModeEvent : introduce a mode
//
// This event introduces a mode for this head. It is sent once per
// supported mode.
type ZwlrOutputHeadV1ModeEvent struct {
	Mode *ZwlrOutputModeV1
}
type ZwlrOutputHeadV1ModeHandlerFunc func(ZwlrOutputHeadV1ModeEvent)

// SetModeHandler : sets handler for ZwlrOutputHeadV1ModeEvent
func (i *ZwlrOutputHeadV1) SetModeHandler(f ZwlrOutputHeadV1ModeHandlerFunc) {
	i.modeHandler = f
}

// ZwlrOutputHeadV1EnabledEvent : head is enabled or disabled
//
// This event describes whether the head is enabled. A disabled head is not
// mapped to a region of the global compositor space.
//
// When a head is disabled, some properties (current_mode, position,
// transform and scale) are irrelevant.
type ZwlrOutputHeadV1EnabledEvent struct {
	Enabled int32
}
type ZwlrOutputHeadV1EnabledHandlerFunc func(ZwlrOutputHeadV1EnabledEvent)

// SetEnabledHandler : sets handler for ZwlrOutputHeadV1EnabledEvent
func (i *ZwlrOutputHeadV1) SetEnabledHandler(f ZwlrOutputHeadV1EnabledHandlerFunc) {
	i.enabledHandler = f
}

// ZwlrOutputHeadV1CurrentModeEvent : current mode
//
// This event describes the mode currently in use for this head. It is only
// sent if the output is enabled.
type ZwlrOutputHeadV1CurrentModeEvent struct {
	Mode *ZwlrOutputModeV1
}
type ZwlrOutputHeadV1CurrentModeHandlerFunc func(ZwlrOutputHeadV1CurrentModeEvent)

// SetCurrentModeHandler : sets handler for ZwlrOutputHeadV1CurrentModeEvent
func (i *ZwlrOutputHeadV1) SetCurrentModeHandler(f ZwlrOutputHeadV1CurrentModeHandlerFunc) {
	i.currentModeHandler = f
}

// ZwlrOutputHeadV1PositionEvent : current position
//
// This events describes the position of the head in the global compositor
// space. It is only sent if the output is enabled.
type ZwlrOutputHeadV1PositionEvent struct {
	X int32
	Y int32
}
type ZwlrOutputHeadV1PositionHandlerFunc func(ZwlrOutputHeadV1PositionEvent)

// SetPositionHandler : sets handler for ZwlrOutputHeadV1PositionEvent
func (i *ZwlrOutputHeadV1) SetPositionHandler(f ZwlrOutputHeadV1PositionHandlerFunc) {
	i.positionHandler = f
}

// ZwlrOutputHeadV1TransformEvent : current transformation
//
// This event describes the transformation currently applied to the head.
// It is only sent if the output is enabled.
type ZwlrOutputHeadV1TransformEvent struct {
	Transform int32
}
type ZwlrOutputHeadV1TransformHandlerFunc func(ZwlrOutputHeadV1TransformEvent)

// SetTransformHandler : sets handler for ZwlrOutputHeadV1TransformEvent
func (i *ZwlrOutputHeadV1) SetTransformHandler(f ZwlrOutputHeadV1TransformHandlerFunc) {
	i.transformHandler = f
}

// ZwlrOutputHeadV1ScaleEvent : current scale
//
// This events describes the scale of the head in the global compositor
// space. It is only sent if the output is enabled.
type ZwlrOutputHeadV1ScaleEvent struct {
	Scale float64
}
type ZwlrOutputHeadV1ScaleHandlerFunc func(ZwlrOutputHeadV1ScaleEvent)

// SetScaleHandler : sets handler for ZwlrOutputHeadV1ScaleEvent
func (i *ZwlrOutputHeadV1) SetScaleHandler(f ZwlrOutputHeadV1ScaleHandlerFunc) {
	i.scaleHandler = f
}

// ZwlrOutputHeadV1FinishedEvent : the head has disappeared
//
// This event indicates that the head is no longer available. The head
// object becomes inert. Clients should send a destroy request and release
// any resources associated with it.
type ZwlrOutputHeadV1FinishedEvent struct{}
type ZwlrOutputHeadV1FinishedHandlerFunc func(ZwlrOutputHeadV1FinishedEvent)

// SetFinishedHandler : sets handler for ZwlrOutputHeadV1FinishedEvent
func (i *ZwlrOutputHeadV1) SetFinishedHandler(f ZwlrOutputHeadV1FinishedHandlerFunc) {
	i.finishedHandler = f
}

// ZwlrOutputHeadV1MakeEvent : head manufacturer
//
// This event describes the manufacturer of the head.
//
// Together with the model and serial_number events the purpose is to
// allow clients to recognize heads from previous sessions and for example
// load head-specific configurations back.
//
// It is not guaranteed this event will be ever sent. A reason for that
// can be that the compositor does not have information about the make of
// the head or the definition of a make is not sensible in the current
// setup, for example in a virtual session. Clients can still try to
// identify the head by available information from other events but should
// be aware that there is an increased risk of false positives.
//
// If sent, the make event is sent after a wlr_output_head object is
// created and only sent once per object. The make does not change over
// the lifetime of the wlr_output_head object.
//
// It is not recommended to display the make string in UI to users. For
// that the string provided by the description event should be preferred.
type ZwlrOutputHeadV1MakeEvent struct {
	Make string
}
type ZwlrOutputHeadV1MakeHandlerFunc func(ZwlrOutputHeadV1MakeEvent)

// SetMakeHandler : sets handler for ZwlrOutputHeadV1MakeEvent
func (i *ZwlrOutputHeadV1) SetMakeHandler(f ZwlrOutputHeadV1MakeHandlerFunc) {
	i.makeHandler = f
}

// ZwlrOutputHeadV1ModelEvent : head model
//
// This event describes the model of the head.
//
// Together with the make and serial_number events the purpose is to
// allow clients to recognize heads from previous sessions and for example
// load head-specific configurations back.
//
// It is not guaranteed this event will be ever sent. A reason for that
// can be that the compositor does not have information about the model of
// the head or the definition of a model is not sensible in the current
// setup, for example in a virtual session. Clients can still try to
// identify the head by available information from other events but should
// be aware that there is an increased risk of false positives.
//
// If sent, the model event is sent after a wlr_output_head object is
// created and only sent once per object. The model does not change over
// the lifetime of the wlr_output_head object.
//
// It is not recommended to display the model string in UI to users. For
// that the string provided by the description event should be preferred.
type ZwlrOutputHeadV1ModelEvent struct {
	Model string
}
type ZwlrOutputHeadV1ModelHandlerFunc func(ZwlrOutputHeadV1ModelEvent)

// SetModelHandler : sets handler for ZwlrOutputHeadV1ModelEvent
func (i *ZwlrOutputHeadV1) SetModelHandler(f ZwlrOutputHeadV1ModelHandlerFunc) {
	i.modelHandler = f
}

// ZwlrOutputHeadV1SerialNumberEvent : head serial number
//
// This event describes the serial number of the head.
//
// Together with the make and model events the purpose is to allow clients
// to recognize heads from previous sessions and for example load head-
// specific configurations back.
//
// It is not guaranteed this event will be ever sent. A reason for that
// can be that the compositor does not have information about the serial
// number of the head or the definition of a serial number is not sensible
// in the current setup. Clients can still try to identify the head by
// available information from other events but should be aware that there
// is an increased risk of false positives.
//
// If sent, the serial number event is sent after a wlr_output_head object
// is created and only sent once per object. The serial number does not
// change over the lifetime of the wlr_output_head object.
//
// It is not recommended to display the serial_number string in UI to
// users. For that the string provided by the description event should be
// preferred.
type ZwlrOutputHeadV1SerialNumberEvent struct {
	SerialNumber string
}
type ZwlrOutputHeadV1SerialNumberHandlerFunc func(ZwlrOutputHeadV1SerialNumberEvent)

// SetSerialNumberHandler : sets handler for ZwlrOutputHeadV1SerialNumberEvent
func (i *ZwlrOutputHeadV1) SetSerialNumberHandler(f ZwlrOutputHeadV1SerialNumberHandlerFunc) {
	i.serialNumberHandler = f
}

// ZwlrOutputHeadV1AdaptiveSyncEvent : current adaptive sync state
//
// This event describes whether adaptive sync is currently enabled for
// the head or not. Adaptive sync is also known as Variable Refresh
// Rate or VRR.
type ZwlrOutputHeadV1AdaptiveSyncEvent struct {
	State uint32
}
type ZwlrOutputHeadV1AdaptiveSyncHandlerFunc func(ZwlrOutputHeadV1AdaptiveSyncEvent)

// SetAdaptiveSyncHandler : sets handler for ZwlrOutputHeadV1AdaptiveSyncEvent
func (i *ZwlrOutputHeadV1) SetAdaptiveSyncHandler(f ZwlrOutputHeadV1AdaptiveSyncHandlerFunc) {
	i.adaptiveSyncHandler = f
}

func (i *ZwlrOutputHeadV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.nameHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1NameEvent
		l := 0
		nameLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Name = client.String(data[l : l+nameLen])
		l += nameLen

		i.nameHandler(e)
	case 1:
		if i.descriptionHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1DescriptionEvent
		l := 0
		descriptionLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Description = client.String(data[l : l+descriptionLen])
		l += descriptionLen

		i.descriptionHandler(e)
	case 2:
		if i.physicalSizeHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1PhysicalSizeEvent
		l := 0
		e.Width = int32(client.Uint32(data[l : l+4]))
		l += 4
		e.Height = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.physicalSizeHandler(e)
	case 3:
		if i.modeHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1ModeEvent
		l := 0
		objectID := client.Uint32(data[l : l+4])
		proxy := i.Context().GetProxy(objectID)
		if proxy != nil {
			e.Mode = proxy.(*ZwlrOutputModeV1)
		} else {
			mode := &ZwlrOutputModeV1{}
			mode.SetContext(i.Context())
			mode.SetID(objectID)
			registerServerProxy(i.Context(), mode, objectID)
			e.Mode = mode
		}
		l += 4

		i.modeHandler(e)
	case 4:
		if i.enabledHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1EnabledEvent
		l := 0
		e.Enabled = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.enabledHandler(e)
	case 5:
		if i.currentModeHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1CurrentModeEvent
		l := 0
		e.Mode = i.Context().GetProxy(client.Uint32(data[l : l+4])).(*ZwlrOutputModeV1)
		l += 4

		i.currentModeHandler(e)
	case 6:
		if i.positionHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1PositionEvent
		l := 0
		e.X = int32(client.Uint32(data[l : l+4]))
		l += 4
		e.Y = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.positionHandler(e)
	case 7:
		if i.transformHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1TransformEvent
		l := 0
		e.Transform = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.transformHandler(e)
	case 8:
		if i.scaleHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1ScaleEvent
		l := 0
		e.Scale = client.Fixed(data[l : l+4])
		l += 4

		i.scaleHandler(e)
	case 9:
		if i.finishedHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1FinishedEvent

		i.finishedHandler(e)
	case 10:
		if i.makeHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1MakeEvent
		l := 0
		makeLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Make = client.String(data[l : l+makeLen])
		l += makeLen

		i.makeHandler(e)
	case 11:
		if i.modelHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1ModelEvent
		l := 0
		modelLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Model = client.String(data[l : l+modelLen])
		l += modelLen

		i.modelHandler(e)
	case 12:
		if i.serialNumberHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1SerialNumberEvent
		l := 0
		serialNumberLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.SerialNumber = client.String(data[l : l+serialNumberLen])
		l += serialNumberLen

		i.serialNumberHandler(e)
	case 13:
		if i.adaptiveSyncHandler == nil {
			return
		}
		var e ZwlrOutputHeadV1AdaptiveSyncEvent
		l := 0
		e.State = client.Uint32(data[l : l+4])
		l += 4

		i.adaptiveSyncHandler(e)
	}
}

// ZwlrOutputModeV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrOutputModeV1InterfaceName = "zwlr_output_mode_v1"

// ZwlrOutputModeV1 : output mode
//
// This object describes an output mode.
//
// Some heads don't support output modes, in which case modes won't be
// advertised.
//
// Properties sent via this interface are applied atomically via the
// wlr_output_manager.done event. No guarantees are made regarding the order
// in which properties are sent.
type ZwlrOutputModeV1 struct {
	client.BaseProxy
	sizeHandler      ZwlrOutputModeV1SizeHandlerFunc
	refreshHandler   ZwlrOutputModeV1RefreshHandlerFunc
	preferredHandler ZwlrOutputModeV1PreferredHandlerFunc
	finishedHandler  ZwlrOutputModeV1FinishedHandlerFunc
}

// NewZwlrOutputModeV1 : output mode
//
// This object describes an output mode.
//
// Some heads don't support output modes, in which case modes won't be
// advertised.
//
// Properties sent via this interface are applied atomically via the
// wlr_output_manager.done event. No guarantees are made regarding the order
// in which properties are sent.
func NewZwlrOutputModeV1(ctx *client.Context) *ZwlrOutputModeV1 {
	zwlrOutputModeV1 := &ZwlrOutputModeV1{}
	ctx.Register(zwlrOutputModeV1)
	return zwlrOutputModeV1
}

// Release : destroy the mode object
//
// This request indicates that the client will no longer use this mode
// object.
func (i *ZwlrOutputModeV1) Release() error {
	defer i.MarkZombie()
	const opcode = 0
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// ZwlrOutputModeV1SizeEvent : mode size
//
// This event describes the mode size. The size is given in physical
// hardware units of the output device. This is not necessarily the same as
// the output size in the global compositor space. For instance, the output
// may be scaled or transformed.
type ZwlrOutputModeV1SizeEvent struct {
	Width  int32
	Height int32
}
type ZwlrOutputModeV1SizeHandlerFunc func(ZwlrOutputModeV1SizeEvent)

// SetSizeHandler : sets handler for ZwlrOutputModeV1SizeEvent
func (i *ZwlrOutputModeV1) SetSizeHandler(f ZwlrOutputModeV1SizeHandlerFunc) {
	i.sizeHandler = f
}

// ZwlrOutputModeV1RefreshEvent : mode refresh rate
//
// This event describes the mode's fixed vertical refresh rate. It is only
// sent if the mode has a fixed refresh rate.
type ZwlrOutputModeV1RefreshEvent struct {
	Refresh int32
}
type ZwlrOutputModeV1RefreshHandlerFunc func(ZwlrOutputModeV1RefreshEvent)

// SetRefreshHandler : sets handler for ZwlrOutputModeV1RefreshEvent
func (i *ZwlrOutputModeV1) SetRefreshHandler(f ZwlrOutputModeV1RefreshHandlerFunc) {
	i.refreshHandler = f
}

// ZwlrOutputModeV1PreferredEvent : mode is preferred
//
// This event advertises this mode as preferred.
type ZwlrOutputModeV1PreferredEvent struct{}
type ZwlrOutputModeV1PreferredHandlerFunc func(ZwlrOutputModeV1PreferredEvent)

// SetPreferredHandler : sets handler for ZwlrOutputModeV1PreferredEvent
func (i *ZwlrOutputModeV1) SetPreferredHandler(f ZwlrOutputModeV1PreferredHandlerFunc) {
	i.preferredHandler = f
}

// ZwlrOutputModeV1FinishedEvent : the mode has disappeared
//
// This event indicates that the mode is no longer available. The mode
// object becomes inert. Clients should send a destroy request and release
// any resources associated with it.
type ZwlrOutputModeV1FinishedEvent struct{}
type ZwlrOutputModeV1FinishedHandlerFunc func(ZwlrOutputModeV1FinishedEvent)

// SetFinishedHandler : sets handler for ZwlrOutputModeV1FinishedEvent
func (i *ZwlrOutputModeV1) SetFinishedHandler(f ZwlrOutputModeV1FinishedHandlerFunc) {
	i.finishedHandler = f
}

func (i *ZwlrOutputModeV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.sizeHandler == nil {
			return
		}
		var e ZwlrOutputModeV1SizeEvent
		l := 0
		e.Width = int32(client.Uint32(data[l : l+4]))
		l += 4
		e.Height = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.sizeHandler(e)
	case 1:
		if i.refreshHandler == nil {
			return
		}
		var e ZwlrOutputModeV1RefreshEvent
		l := 0
		e.Refresh = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.refreshHandler(e)
	case 2:
		if i.preferredHandler == nil {
			return
		}
		var e ZwlrOutputModeV1PreferredEvent

		i.preferredHandler(e)
	case 3:
		if i.finishedHandler == nil {
			return
		}
		var e ZwlrOutputModeV1FinishedEvent

		i.finishedHandler(e)
	}
}

// ZwlrOutputConfigurationV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrOutputConfigurationV1InterfaceName = "zwlr_output_configuration_v1"

// ZwlrOutputConfigurationV1 : output configuration
//
// This object is used by the client to describe a full output configuration.
//
// First, the client needs to setup the output configuration. Each head can
// be either enabled (and configured) or disabled. It is a protocol error to
// send two enable_head or disable_head requests with the same head. It is a
// protocol error to omit a head in a configuration.
//
// Then, the client can apply or test the configuration. The compositor will
// then reply with a succeeded, failed or cancelled event. Finally the client
// should destroy the configuration object.
type ZwlrOutputConfigurationV1 struct {
	client.BaseProxy
	succeededHandler ZwlrOutputConfigurationV1SucceededHandlerFunc
	failedHandler    ZwlrOutputConfigurationV1FailedHandlerFunc
	cancelledHandler ZwlrOutputConfigurationV1CancelledHandlerFunc
}

// NewZwlrOutputConfigurationV1 : output configuration
//
// This object is used by the client to describe a full output configuration.
//
// First, the client needs to setup the output configuration. Each head can
// be either enabled (and configured) or disabled. It is a protocol error to
// send two enable_head or disable_head requests with the same head. It is a
// protocol error to omit a head in a configuration.
//
// Then, the client can apply or test the configuration. The compositor will
// then reply with a succeeded, failed or cancelled event. Finally the client
// should destroy the configuration object.
func NewZwlrOutputConfigurationV1(ctx *client.Context) *ZwlrOutputConfigurationV1 {
	zwlrOutputConfigurationV1 := &ZwlrOutputConfigurationV1{}
	ctx.Register(zwlrOutputConfigurationV1)
	return zwlrOutputConfigurationV1
}

// EnableHead : enable and configure a head
//
// Enable a head. This request creates a head configuration object that can
// be used to change the head's properties.
//
//	head: the head to be enabled
func (i *ZwlrOutputConfigurationV1) EnableHead(head *ZwlrOutputHeadV1) (*ZwlrOutputConfigurationHeadV1, error) {
	id := NewZwlrOutputConfigurationHeadV1(i.Context())
	const opcode = 0
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], id.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], head.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return id, err
}

// DisableHead : disable a head
//
// Disable a head.
//
//	head: the head to be disabled
func (i *ZwlrOutputConfigurationV1) DisableHead(head *ZwlrOutputHeadV1) error {
	const opcode = 1
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], head.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Apply : apply the configuration
//
// Apply the new output configuration.
//
// In case the configuration is successfully applied, there is no guarantee
// that the new output state matches completely the requested
// configuration. For instance, a compositor might round the scale if it
// doesn't support fractional scaling.
//
// After this request has been sent, the compositor must respond with an
// succeeded, failed or cancelled event. Sending a request that isn't the
// destructor is a protocol error.
func (i *ZwlrOutputConfigurationV1) Apply() error {
	const opcode = 2
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Test : test the configuration
//
// Test the new output configuration. The configuration won't be applied,
// but will only be validated.
//
// Even if the compositor succeeds to test a configuration, applying it may
// fail.
//
// After this request has been sent, the compositor must respond with an
// succeeded, failed or cancelled event. Sending a request that isn't the
// destructor is a protocol error.
func (i *ZwlrOutputConfigurationV1) Test() error {
	const opcode = 3
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Destroy : destroy the output configuration
//
// Using this request a client can tell the compositor that it is not going
// to use the configuration object anymore. Any changes to the outputs
// that have not been applied will be discarded.
//
// This request also destroys wlr_output_configuration_head objects created
// via this object.
func (i *ZwlrOutputConfigurationV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 4
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrOutputConfigurationV1Error uint32

// ZwlrOutputConfigurationV1Error :
const (
	// ZwlrOutputConfigurationV1ErrorAlreadyConfiguredHead : head has been configured twice
	ZwlrOutputConfigurationV1ErrorAlreadyConfiguredHead ZwlrOutputConfigurationV1Error = 1
	// ZwlrOutputConfigurationV1ErrorUnconfiguredHead : head has not been configured
	ZwlrOutputConfigurationV1ErrorUnconfiguredHead ZwlrOutputConfigurationV1Error = 2
	// ZwlrOutputConfigurationV1ErrorAlreadyUsed : request sent after configuration has been applied or tested
	ZwlrOutputConfigurationV1ErrorAlreadyUsed ZwlrOutputConfigurationV1Error = 3
)

func (e ZwlrOutputConfigurationV1Error) Name() string {
	switch e {
	case ZwlrOutputConfigurationV1ErrorAlreadyConfiguredHead:
		return "already_configured_head"
	case ZwlrOutputConfigurationV1ErrorUnconfiguredHead:
		return "unconfigured_head"
	case ZwlrOutputConfigurationV1ErrorAlreadyUsed:
		return "already_used"
	default:
		return ""
	}
}

func (e ZwlrOutputConfigurationV1Error) Value() string {
	switch e {
	case ZwlrOutputConfigurationV1ErrorAlreadyConfiguredHead:
		return "1"
	case ZwlrOutputConfigurationV1ErrorUnconfiguredHead:
		return "2"
	case ZwlrOutputConfigurationV1ErrorAlreadyUsed:
		return "3"
	default:
		return ""
	}
}

func (e ZwlrOutputConfigurationV1Error) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrOutputConfigurationV1SucceededEvent : configuration changes succeeded
//
// Sent after the compositor has successfully applied the changes or
// tested them.
//
// Upon receiving this event, the client should destroy this object.
//
// If the current configuration has changed, events to describe the changes
// will be sent followed by a wlr_output_manager.done event.
type ZwlrOutputConfigurationV1SucceededEvent struct{}
type ZwlrOutputConfigurationV1SucceededHandlerFunc func(ZwlrOutputConfigurationV1SucceededEvent)

// SetSucceededHandler : sets handler for ZwlrOutputConfigurationV1SucceededEvent
func (i *ZwlrOutputConfigurationV1) SetSucceededHandler(f ZwlrOutputConfigurationV1SucceededHandlerFunc) {
	i.succeededHandler = f
}

// ZwlrOutputConfigurationV1FailedEvent : configuration changes failed
//
// Sent if the compositor rejects the changes or failed to apply them. The
// compositor should revert any changes made by the apply request that
// triggered this event.
//
// Upon receiving this event, the client should destroy this object.
type ZwlrOutputConfigurationV1FailedEvent struct{}
type ZwlrOutputConfigurationV1FailedHandlerFunc func(ZwlrOutputConfigurationV1FailedEvent)

// SetFailedHandler : sets handler for ZwlrOutputConfigurationV1FailedEvent
func (i *ZwlrOutputConfigurationV1) SetFailedHandler(f ZwlrOutputConfigurationV1FailedHandlerFunc) {
	i.failedHandler = f
}

// ZwlrOutputConfigurationV1CancelledEvent : configuration has been cancelled
//
// Sent if the compositor cancels the configuration because the state of an
// output changed and the client has outdated information (e.g. after an
// output has been hotplugged).
//
// The client can create a new configuration with a newer serial and try
// again.
//
// Upon receiving this event, the client should destroy this object.
type ZwlrOutputConfigurationV1CancelledEvent struct{}
type ZwlrOutputConfigurationV1CancelledHandlerFunc func(ZwlrOutputConfigurationV1CancelledEvent)

// SetCancelledHandler : sets handler for ZwlrOutputConfigurationV1CancelledEvent
func (i *ZwlrOutputConfigurationV1) SetCancelledHandler(f ZwlrOutputConfigurationV1CancelledHandlerFunc) {
	i.cancelledHandler = f
}

func (i *ZwlrOutputConfigurationV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.succeededHandler == nil {
			return
		}
		var e ZwlrOutputConfigurationV1SucceededEvent

		i.succeededHandler(e)
	case 1:
		if i.failedHandler == nil {
			return
		}
		var e ZwlrOutputConfigurationV1FailedEvent

		i.failedHandler(e)
	case 2:
		if i.cancelledHandler == nil {
			return
		}
		var e ZwlrOutputConfigurationV1CancelledEvent

		i.cancelledHandler(e)
	}
}

// ZwlrOutputConfigurationHeadV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrOutputConfigurationHeadV1InterfaceName = "zwlr_output_configuration_head_v1"

// ZwlrOutputConfigurationHeadV1 : head configuration
//
// This object is used by the client to update a single head's configuration.
//
// It is a protocol error to set the same property twice.
type ZwlrOutputConfigurationHeadV1 struct {
	client.BaseProxy
}

// NewZwlrOutputConfigurationHeadV1 : head configuration
//
// This object is used by the client to update a single head's configuration.
//
// It is a protocol error to set the same property twice.
func NewZwlrOutputConfigurationHeadV1(ctx *client.Context) *ZwlrOutputConfigurationHeadV1 {
	zwlrOutputConfigurationHeadV1 := &ZwlrOutputConfigurationHeadV1{}
	ctx.Register(zwlrOutputConfigurationHeadV1)
	return zwlrOutputConfigurationHeadV1
}

// SetMode : set the mode
//
// This request sets the head's mode.
func (i *ZwlrOutputConfigurationHeadV1) SetMode(mode *ZwlrOutputModeV1) error {
	const opcode = 0
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], mode.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetCustomMode : set a custom mode
//
// This request assigns a custom mode to the head. The size is given in
// physical hardware units of the output device. If set to zero, the
// refresh rate is unspecified.
//
// It is a protocol error to set both a mode and a custom mode.
//
//	width: width of the mode in hardware units
//	height: height of the mode in hardware units
//	refresh: vertical refresh rate in mHz or zero
func (i *ZwlrOutputConfigurationHeadV1) SetCustomMode(width, height, refresh int32) error {
	const opcode = 1
	const _reqBufLen = 8 + 4 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(width))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(height))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(refresh))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetPosition : set the position
//
// This request sets the head's position in the global compositor space.
//
//	x: x position in the global compositor space
//	y: y position in the global compositor space
func (i *ZwlrOutputConfigurationHeadV1) SetPosition(x, y int32) error {
	const opcode = 2
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(x))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(y))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetTransform : set the transform
//
// This request sets the head's transform.
func (i *ZwlrOutputConfigurationHeadV1) SetTransform(transform int32) error {
	const opcode = 3
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(transform))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetScale : set the scale
//
// This request sets the head's scale.
func (i *ZwlrOutputConfigurationHeadV1) SetScale(scale float64) error {
	const opcode = 4
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutFixed(_reqBuf[l:l+4], scale)
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetAdaptiveSync : enable/disable adaptive sync
//
// This request enables/disables adaptive sync. Adaptive sync is also
// known as Variable Refresh Rate or VRR.
func (i *ZwlrOutputConfigurationHeadV1) SetAdaptiveSync(state uint32) error {
	const opcode = 5
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(state))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

func (i *ZwlrOutputConfigurationHeadV1) Destroy() error {
	i.MarkZombie()
	return nil
}

type ZwlrOutputConfigurationHeadV1Error uint32

// ZwlrOutputConfigurationHeadV1Error :
const (
	// ZwlrOutputConfigurationHeadV1ErrorAlreadySet : property has already been set
	ZwlrOutputConfigurationHeadV1ErrorAlreadySet ZwlrOutputConfigurationHeadV1Error = 1
	// ZwlrOutputConfigurationHeadV1ErrorInvalidMode : mode doesn't belong to head
	ZwlrOutputConfigurationHeadV1ErrorInvalidMode ZwlrOutputConfigurationHeadV1Error = 2
	// ZwlrOutputConfigurationHeadV1ErrorInvalidCustomMode : mode is invalid
	ZwlrOutputConfigurationHeadV1ErrorInvalidCustomMode ZwlrOutputConfigurationHeadV1Error = 3
	// ZwlrOutputConfigurationHeadV1ErrorInvalidTransform : transform value outside enum
	ZwlrOutputConfigurationHeadV1ErrorInvalidTransform ZwlrOutputConfigurationHeadV1Error = 4
	// ZwlrOutputConfigurationHeadV1ErrorInvalidScale : scale negative or zero
	ZwlrOutputConfigurationHeadV1ErrorInvalidScale ZwlrOutputConfigurationHeadV1Error = 5
	// ZwlrOutputConfigurationHeadV1ErrorInvalidAdaptiveSyncState : invalid enum value used in the set_adaptive_sync request
	ZwlrOutputConfigurationHeadV1ErrorInvalidAdaptiveSyncState ZwlrOutputConfigurationHeadV1Error = 6
)

func (e ZwlrOutputConfigurationHeadV1Error) Name() string {
	switch e {
	case ZwlrOutputConfigurationHeadV1ErrorAlreadySet:
		return "already_set"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidMode:
		return "invalid_mode"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidCustomMode:
		return "invalid_custom_mode"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidTransform:
		return "invalid_transform"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidScale:
		return "invalid_scale"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidAdaptiveSyncState:
		return "invalid_adaptive_sync_state"
	default:
		return ""
	}
}

func (e ZwlrOutputConfigurationHeadV1Error) Value() string {
	switch e {
	case ZwlrOutputConfigurationHeadV1ErrorAlreadySet:
		return "1"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidMode:
		return "2"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidCustomMode:
		return "3"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidTransform:
		return "4"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidScale:
		return "5"
	case ZwlrOutputConfigurationHeadV1ErrorInvalidAdaptiveSyncState:
		return "6"
	default:
		return ""
	}
}

func (e ZwlrOutputConfigurationHeadV1Error) String() string {
	return e.Name() + "=" + e.Value()
}
