// Generated by go-wayland-scanner
// https://github.com/yaslama/go-wayland/cmd/go-wayland-scanner
// XML file : internal/proto/xml/wlr-layer-shell-unstable-v1.xml
//
// wlr_layer_shell_unstable_v1 Protocol Copyright:
//
// Copyright © 2017 Drew DeVault
//
// Permission to use, copy, modify, distribute, and sell this
// software and its documentation for any purpose is hereby granted
// without fee, provided that the above copyright notice appear in
// all copies and that both that copyright notice and this permission
// notice appear in supporting documentation, and that the name of
// the copyright holders not be used in advertising or publicity
// pertaining to distribution of the software without specific,
// written prior permission.  The copyright holders make no
// representations about the suitability of this software for any
// purpose.  It is provided "as is" without express or implied
// warranty.
//
// THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
// AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
// ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
// THIS SOFTWARE.

package wlr_layer_shell

import (
	"github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/client"
	xdg_shell "github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/stable/xdg-shell"
)

// ZwlrLayerShellV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrLayerShellV1InterfaceName = "zwlr_layer_shell_v1"

// ZwlrLayerShellV1 : create surfaces that are layers of the desktop
//
// Clients can use this interface to assign the surface_layer role to
// wl_surfaces. Such surfaces are assigned to a "layer" of the output and
// rendered with a defined z-depth respective to each other. They may also be
// anchored to the edges and corners of a screen and specify input handling
// semantics. This interface should be suitable for the implementation of
// many desktop shell components, and a broad number of other applications
// that interact with the desktop.
type ZwlrLayerShellV1 struct {
	client.BaseProxy
}

// NewZwlrLayerShellV1 : create surfaces that are layers of the desktop
//
// Clients can use this interface to assign the surface_layer role to
// wl_surfaces. Such surfaces are assigned to a "layer" of the output and
// rendered with a defined z-depth respective to each other. They may also be
// anchored to the edges and corners of a screen and specify input handling
// semantics. This interface should be suitable for the implementation of
// many desktop shell components, and a broad number of other applications
// that interact with the desktop.
func NewZwlrLayerShellV1(ctx *client.Context) *ZwlrLayerShellV1 {
	zwlrLayerShellV1 := &ZwlrLayerShellV1{}
	ctx.Register(zwlrLayerShellV1)
	return zwlrLayerShellV1
}

// GetLayerSurface : create a layer_surface from a surface
//
// Create a layer surface for an existing surface. This assigns the role of
// layer_surface, or raises a protocol error if another role is already
// assigned.
//
// Creating a layer surface from a wl_surface which has a buffer attached
// or committed is a client error, and any attempts by a client to attach
// or manipulate a buffer prior to the first layer_surface.configure call
// must also be treated as errors.
//
// After creating a layer_surface object and setting it up, the client
// must perform an initial commit without any buffer attached.
// The compositor will reply with a layer_surface.configure event.
// The client must acknowledge it and is then allowed to attach a buffer
// to map the surface.
//
// You may pass NULL for output to allow the compositor to decide which
// output to use. Generally this will be the one that the user most
// recently interacted with.
//
// Clients can specify a namespace that defines the purpose of the layer
// surface.
//
//	layer: layer to add this surface to
//	namespace: namespace for the layer surface
func (i *ZwlrLayerShellV1) GetLayerSurface(surface *client.Surface, output *client.Output, layer uint32, namespace string) (*ZwlrLayerSurfaceV1, error) {
	id := NewZwlrLayerSurfaceV1(i.Context())
	const opcode = 0
	namespaceLen := client.PaddedLen(len(namespace) + 1)
	_reqBufLen := 8 + 4 + 4 + 4 + 4 + (4 + namespaceLen)
	_reqBuf := make([]byte, _reqBufLen)
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], id.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], surface.ID())
	l += 4
	if output == nil {
		client.PutUint32(_reqBuf[l:l+4], 0)
		l += 4
	} else {
		client.PutUint32(_reqBuf[l:l+4], output.ID())
		l += 4
	}
	client.PutUint32(_reqBuf[l:l+4], uint32(layer))
	l += 4
	client.PutString(_reqBuf[l:l+(4+namespaceLen)], namespace)
	l += (4 + namespaceLen)
	err := i.Context().WriteMsg(_reqBuf, nil)
	return id, err
}

// Destroy : destroy the layer_shell object
//
// This request indicates that the client will not use the layer_shell
// object any more. Objects that have been created through this instance
// are not affected.
func (i *ZwlrLayerShellV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 1
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrLayerShellV1Error uint32

// ZwlrLayerShellV1Error :
const (
	// ZwlrLayerShellV1ErrorRole : wl_surface has another role
	ZwlrLayerShellV1ErrorRole ZwlrLayerShellV1Error = 0
	// ZwlrLayerShellV1ErrorInvalidLayer : layer value is invalid
	ZwlrLayerShellV1ErrorInvalidLayer ZwlrLayerShellV1Error = 1
	// ZwlrLayerShellV1ErrorAlreadyConstructed : wl_surface has a buffer attached or committed
	ZwlrLayerShellV1ErrorAlreadyConstructed ZwlrLayerShellV1Error = 2
)

func (e ZwlrLayerShellV1Error) Name() string {
	switch e {
	case ZwlrLayerShellV1ErrorRole:
		return "role"
	case ZwlrLayerShellV1ErrorInvalidLayer:
		return "invalid_layer"
	case ZwlrLayerShellV1ErrorAlreadyConstructed:
		return "already_constructed"
	default:
		return ""
	}
}

func (e ZwlrLayerShellV1Error) Value() string {
	switch e {
	case ZwlrLayerShellV1ErrorRole:
		return "0"
	case ZwlrLayerShellV1ErrorInvalidLayer:
		return "1"
	case ZwlrLayerShellV1ErrorAlreadyConstructed:
		return "2"
	default:
		return ""
	}
}

func (e ZwlrLayerShellV1Error) String() string {
	return e.Name() + "=" + e.Value()
}

type ZwlrLayerShellV1Layer uint32

// ZwlrLayerShellV1Layer : available layers for surfaces
//
// These values indicate which layers a surface can be rendered in. They
// are ordered by z depth, bottom-most first. Traditional shell surfaces
// will typically be rendered between the bottom and top layers.
// Fullscreen shell surfaces are typically rendered at the top layer.
// Multiple surfaces can share a single layer, and ordering within a
// single layer is undefined.
const (
	ZwlrLayerShellV1LayerBackground ZwlrLayerShellV1Layer = 0
	ZwlrLayerShellV1LayerBottom     ZwlrLayerShellV1Layer = 1
	ZwlrLayerShellV1LayerTop        ZwlrLayerShellV1Layer = 2
	ZwlrLayerShellV1LayerOverlay    ZwlrLayerShellV1Layer = 3
)

func (e ZwlrLayerShellV1Layer) Name() string {
	switch e {
	case ZwlrLayerShellV1LayerBackground:
		return "background"
	case ZwlrLayerShellV1LayerBottom:
		return "bottom"
	case ZwlrLayerShellV1LayerTop:
		return "top"
	case ZwlrLayerShellV1LayerOverlay:
		return "overlay"
	default:
		return ""
	}
}

func (e ZwlrLayerShellV1Layer) Value() string {
	switch e {
	case ZwlrLayerShellV1LayerBackground:
		return "0"
	case ZwlrLayerShellV1LayerBottom:
		return "1"
	case ZwlrLayerShellV1LayerTop:
		return "2"
	case ZwlrLayerShellV1LayerOverlay:
		return "3"
	default:
		return ""
	}
}

func (e ZwlrLayerShellV1Layer) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrLayerSurfaceV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrLayerSurfaceV1InterfaceName = "zwlr_layer_surface_v1"

// ZwlrLayerSurfaceV1 : layer metadata interface
//
// An interface that may be implemented by a wl_surface, for surfaces that
// are designed to be rendered as a layer of a stacked desktop-like
// environment.
//
// Layer surface state (layer, size, anchor, exclusive zone,
// margin, interactivity) is double-buffered, and will be applied at the
// time wl_surface.commit of the corresponding wl_surface is called.
//
// Attaching a null buffer to a layer surface unmaps it.
//
// Unmapping a layer_surface means that the surface cannot be shown by the
// compositor until it is explicitly mapped again. The layer_surface
// returns to the state it had right after layer_shell.get_layer_surface.
// The client can re-map the surface by performing a commit without any
// buffer attached, waiting for a configure event and handling it as usual.
type ZwlrLayerSurfaceV1 struct {
	client.BaseProxy
	configureHandler ZwlrLayerSurfaceV1ConfigureHandlerFunc
	closedHandler    ZwlrLayerSurfaceV1ClosedHandlerFunc
}

// NewZwlrLayerSurfaceV1 : layer metadata interface
//
// An interface that may be implemented by a wl_surface, for surfaces that
// are designed to be rendered as a layer of a stacked desktop-like
// environment.
//
// Layer surface state (layer, size, anchor, exclusive zone,
// margin, interactivity) is double-buffered, and will be applied at the
// time wl_surface.commit of the corresponding wl_surface is called.
//
// Attaching a null buffer to a layer surface unmaps it.
//
// Unmapping a layer_surface means that the surface cannot be shown by the
// compositor until it is explicitly mapped again. The layer_surface
// returns to the state it had right after layer_shell.get_layer_surface.
// The client can re-map the surface by performing a commit without any
// buffer attached, waiting for a configure event and handling it as usual.
func NewZwlrLayerSurfaceV1(ctx *client.Context) *ZwlrLayerSurfaceV1 {
	zwlrLayerSurfaceV1 := &ZwlrLayerSurfaceV1{}
	ctx.Register(zwlrLayerSurfaceV1)
	return zwlrLayerSurfaceV1
}

// SetSize : sets the size of the surface
//
// Sets the size of the surface in surface-local coordinates. The
// compositor will display the surface centered with respect to its
// anchors.
//
// If you pass 0 for either value, the compositor will assign it and
// inform you of the assignment in the configure event. You must set your
// anchor to opposite edges in the dimensions you omit; not doing so is a
// protocol error. Both values are 0 by default.
//
// Size is double-buffered, see wl_surface.commit.
func (i *ZwlrLayerSurfaceV1) SetSize(width, height uint32) error {
	const opcode = 0
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(width))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(height))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetAnchor : configures the anchor point of the surface
//
// Requests that the compositor anchor the surface to the specified edges
// and corners. If two orthogonal edges are specified (e.g. 'top' and
// 'left'), then the anchor point will be the intersection of the edges
// (e.g. the top left corner of the output); otherwise the anchor point
// will be centered on that edge, or in the center if none is specified.
//
// Anchor is double-buffered, see wl_surface.commit.
func (i *ZwlrLayerSurfaceV1) SetAnchor(anchor uint32) error {
	const opcode = 1
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(anchor))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetExclusiveZone : configures the exclusive geometry of this surface
//
// Requests that the compositor avoids occluding an area with other
// surfaces. The compositor's use of this information is
// implementation-dependent - do not assume that this region will not
// actually be occluded.
//
// A positive value is only meaningful if the surface is anchored to one
// edge or an edge and both perpendicular edges. If the surface is not
// anchored, anchored to only two perpendicular edges (a corner), anchored
// to only two parallel edges or anchored to all edges, a positive value
// will be treated the same as zero.
//
// A positive zone is the distance from the edge in surface-local
// coordinates to consider exclusive.
//
// Surfaces that do not wish to have an exclusive zone may instead specify
// how they should interact with surfaces that do. If set to zero, the
// surface indicates that it would like to be moved to avoid occluding
// surfaces with a positive exclusive zone. If set to -1, the surface
// indicates that it would not like to be moved to accommodate for other
// surfaces, and the compositor should extend it all the way to the edges
// it is anchored to.
//
// For example, a panel might set its exclusive zone to 10, so that
// maximized shell surfaces are not shown on top of it. A notification
// might set its exclusive zone to 0, so that it is moved to avoid
// occluding the panel, but shell surfaces are shown underneath it. A
// wallpaper or lock screen might set their exclusive zone to -1, so that
// they stretch below or over the panel.
//
// The default value is 0.
//
// Exclusive zone is double-buffered, see wl_surface.commit.
func (i *ZwlrLayerSurfaceV1) SetExclusiveZone(zone int32) error {
	const opcode = 2
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(zone))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetMargin : sets a margin from the anchor point
//
// Requests that the surface be placed some distance away from the anchor
// point on the output, in surface-local coordinates. Setting this value
// for edges you are not anchored to has no effect.
//
// The exclusive zone includes the margin.
//
// Margin is double-buffered, see wl_surface.commit.
func (i *ZwlrLayerSurfaceV1) SetMargin(top, right, bottom, left int32) error {
	const opcode = 3
	const _reqBufLen = 8 + 4 + 4 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(top))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(right))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(bottom))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(left))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetKeyboardInteractivity : requests keyboard events
//
// Set how keyboard events are delivered to this surface. By default,
// layer shell surfaces do not receive keyboard events; this request can
// be used to change this.
//
// This setting is inherited by child surfaces set by the get_popup
// request.
//
// Layer surfaces receive pointer, touch, and tablet events normally. If
// you do not want to receive them, set the input region on your surface
// to an empty region.
//
// Keyboard interactivity is double-buffered, see wl_surface.commit.
func (i *ZwlrLayerSurfaceV1) SetKeyboardInteractivity(keyboardInteractivity uint32) error {
	const opcode = 4
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(keyboardInteractivity))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// GetPopup : assign this layer_surface as an xdg_popup parent
//
// This assigns an xdg_popup's parent to this layer_surface.  This popup
// should have been created via xdg_surface::get_popup with the parent set
// to NULL, and this request must be invoked before committing the popup's
// initial state.
//
// See the documentation of xdg_popup for more details about what an
// xdg_popup is and how it is used.
func (i *ZwlrLayerSurfaceV1) GetPopup(popup *xdg_shell.Popup) error {
	const opcode = 5
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], popup.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// AckConfigure : ack a configure event
//
// When a configure event is received, if a client commits the
// surface in response to the configure event, then the client
// must make an ack_configure request sometime before the commit
// request, passing along the serial of the configure event.
//
// If the client receives multiple configure events before it
// can respond to one, it only has to ack the last configure event.
//
// A client is not required to commit immediately after sending
// an ack_configure request - it may even ack_configure several times
// before its next surface commit.
//
// A client may send multiple ack_configure requests before committing, but
// only the last request sent before a commit indicates which configure
// event the client really is responding to.
//
//	serial: the serial from the configure event
func (i *ZwlrLayerSurfaceV1) AckConfigure(serial uint32) error {
	const opcode = 6
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(serial))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Destroy : destroy the layer_surface
//
// This request destroys the layer surface.
func (i *ZwlrLayerSurfaceV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 7
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetLayer : change the layer of the surface
//
// Change the layer that the surface is rendered on.
//
// Layer is double-buffered, see wl_surface.commit.
//
//	layer: layer to move this surface to
func (i *ZwlrLayerSurfaceV1) SetLayer(layer uint32) error {
	const opcode = 8
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(layer))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetExclusiveEdge : set the edge the exclusive zone will be applied to
//
// Requests an edge for the exclusive zone to apply. The exclusive
// edge will be automatically deduced from anchor points when possible,
// but when the surface is anchored to a corner, it will be necessary
// to set it explicitly to disambiguate, as it is not possible to deduce
// which one of the two corner edges should be used.
//
// The edge must be one the surface is anchored to, otherwise the
// invalid_exclusive_edge protocol error will be raised.
func (i *ZwlrLayerSurfaceV1) SetExclusiveEdge(edge uint32) error {
	const opcode = 9
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(edge))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrLayerSurfaceV1KeyboardInteractivity uint32

// ZwlrLayerSurfaceV1KeyboardInteractivity : types of keyboard interaction possible for a layer shell surface
//
// Types of keyboard interaction possible for layer shell surfaces. The
// rationale for this is twofold: (1) some applications are not interested
// in keyboard events and not allowing them to be focused can improve the
// desktop experience; (2) some applications will want to take exclusive
// keyboard focus.
const (
	ZwlrLayerSurfaceV1KeyboardInteractivityNone      ZwlrLayerSurfaceV1KeyboardInteractivity = 0
	ZwlrLayerSurfaceV1KeyboardInteractivityExclusive ZwlrLayerSurfaceV1KeyboardInteractivity = 1
	ZwlrLayerSurfaceV1KeyboardInteractivityOnDemand  ZwlrLayerSurfaceV1KeyboardInteractivity = 2
)

func (e ZwlrLayerSurfaceV1KeyboardInteractivity) Name() string {
	switch e {
	case ZwlrLayerSurfaceV1KeyboardInteractivityNone:
		return "none"
	case ZwlrLayerSurfaceV1KeyboardInteractivityExclusive:
		return "exclusive"
	case ZwlrLayerSurfaceV1KeyboardInteractivityOnDemand:
		return "on_demand"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1KeyboardInteractivity) Value() string {
	switch e {
	case ZwlrLayerSurfaceV1KeyboardInteractivityNone:
		return "0"
	case ZwlrLayerSurfaceV1KeyboardInteractivityExclusive:
		return "1"
	case ZwlrLayerSurfaceV1KeyboardInteractivityOnDemand:
		return "2"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1KeyboardInteractivity) String() string {
	return e.Name() + "=" + e.Value()
}

type ZwlrLayerSurfaceV1Error uint32

// ZwlrLayerSurfaceV1Error :
const (
	// ZwlrLayerSurfaceV1ErrorInvalidSurfaceState : provided surface state is invalid
	ZwlrLayerSurfaceV1ErrorInvalidSurfaceState ZwlrLayerSurfaceV1Error = 0
	// ZwlrLayerSurfaceV1ErrorInvalidSize : size is invalid
	ZwlrLayerSurfaceV1ErrorInvalidSize ZwlrLayerSurfaceV1Error = 1
	// ZwlrLayerSurfaceV1ErrorInvalidAnchor : anchor bitfield is invalid
	ZwlrLayerSurfaceV1ErrorInvalidAnchor ZwlrLayerSurfaceV1Error = 2
	// ZwlrLayerSurfaceV1ErrorInvalidKeyboardInteractivity : keyboard interactivity is invalid
	ZwlrLayerSurfaceV1ErrorInvalidKeyboardInteractivity ZwlrLayerSurfaceV1Error = 3
	// ZwlrLayerSurfaceV1ErrorInvalidExclusiveEdge : exclusive edge is invalid given the surface anchors
	ZwlrLayerSurfaceV1ErrorInvalidExclusiveEdge ZwlrLayerSurfaceV1Error = 4
)

func (e ZwlrLayerSurfaceV1Error) Name() string {
	switch e {
	case ZwlrLayerSurfaceV1ErrorInvalidSurfaceState:
		return "invalid_surface_state"
	case ZwlrLayerSurfaceV1ErrorInvalidSize:
		return "invalid_size"
	case ZwlrLayerSurfaceV1ErrorInvalidAnchor:
		return "invalid_anchor"
	case ZwlrLayerSurfaceV1ErrorInvalidKeyboardInteractivity:
		return "invalid_keyboard_interactivity"
	case ZwlrLayerSurfaceV1ErrorInvalidExclusiveEdge:
		return "invalid_exclusive_edge"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1Error) Value() string {
	switch e {
	case ZwlrLayerSurfaceV1ErrorInvalidSurfaceState:
		return "0"
	case ZwlrLayerSurfaceV1ErrorInvalidSize:
		return "1"
	case ZwlrLayerSurfaceV1ErrorInvalidAnchor:
		return "2"
	case ZwlrLayerSurfaceV1ErrorInvalidKeyboardInteractivity:
		return "3"
	case ZwlrLayerSurfaceV1ErrorInvalidExclusiveEdge:
		return "4"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1Error) String() string {
	return e.Name() + "=" + e.Value()
}

type ZwlrLayerSurfaceV1Anchor uint32

// ZwlrLayerSurfaceV1Anchor :
const (
	// ZwlrLayerSurfaceV1AnchorTop : the top edge of the anchor rectangle
	ZwlrLayerSurfaceV1AnchorTop ZwlrLayerSurfaceV1Anchor = 1
	// ZwlrLayerSurfaceV1AnchorBottom : the bottom edge of the anchor rectangle
	ZwlrLayerSurfaceV1AnchorBottom ZwlrLayerSurfaceV1Anchor = 2
	// ZwlrLayerSurfaceV1AnchorLeft : the left edge of the anchor rectangle
	ZwlrLayerSurfaceV1AnchorLeft ZwlrLayerSurfaceV1Anchor = 4
	// ZwlrLayerSurfaceV1AnchorRight : the right edge of the anchor rectangle
	ZwlrLayerSurfaceV1AnchorRight ZwlrLayerSurfaceV1Anchor = 8
)

func (e ZwlrLayerSurfaceV1Anchor) Name() string {
	switch e {
	case ZwlrLayerSurfaceV1AnchorTop:
		return "top"
	case ZwlrLayerSurfaceV1AnchorBottom:
		return "bottom"
	case ZwlrLayerSurfaceV1AnchorLeft:
		return "left"
	case ZwlrLayerSurfaceV1AnchorRight:
		return "right"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1Anchor) Value() string {
	switch e {
	case ZwlrLayerSurfaceV1AnchorTop:
		return "1"
	case ZwlrLayerSurfaceV1AnchorBottom:
		return "2"
	case ZwlrLayerSurfaceV1AnchorLeft:
		return "4"
	case ZwlrLayerSurfaceV1AnchorRight:
		return "8"
	default:
		return ""
	}
}

func (e ZwlrLayerSurfaceV1Anchor) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrLayerSurfaceV1ConfigureEvent : suggest a surface change
//
// The configure event asks the client to resize its surface.
//
// Clients should arrange their surface for the new states, and then send
// an ack_configure request with the serial sent in this configure event at
// some point before committing the new surface.
//
// The client is free to dismiss all but the last configure event it
// received.
//
// The width and height arguments specify the size of the window in
// surface-local coordinates.
//
// The size is a hint, in the sense that the client is free to ignore it if
// it doesn't resize, pick a smaller size (to satisfy aspect ratio or
// resize in steps of NxM pixels). If the client picks a smaller size and
// is anchored to two opposite anchors (e.g. 'top' and 'bottom'), the
// surface will be centered on this axis.
//
// If the width or height arguments are zero, it means the client should
// decide its own window dimension.
type ZwlrLayerSurfaceV1ConfigureEvent struct {
	Serial uint32
	Width  uint32
	Height uint32
}
type ZwlrLayerSurfaceV1ConfigureHandlerFunc func(ZwlrLayerSurfaceV1ConfigureEvent)

// SetConfigureHandler : sets handler for ZwlrLayerSurfaceV1ConfigureEvent
func (i *ZwlrLayerSurfaceV1) SetConfigureHandler(f ZwlrLayerSurfaceV1ConfigureHandlerFunc) {
	i.configureHandler = f
}

// ZwlrLayerSurfaceV1ClosedEvent : surface should be closed
//
// The closed event is sent by the compositor when the surface will no
// longer be shown. The output may have been destroyed or the user may
// have asked for it to be removed. Further changes to the surface will be
// ignored. The client should destroy the resource after receiving this
// event, and create a new surface if they so choose.
type ZwlrLayerSurfaceV1ClosedEvent struct{}
type ZwlrLayerSurfaceV1ClosedHandlerFunc func(ZwlrLayerSurfaceV1ClosedEvent)

// SetClosedHandler : sets handler for ZwlrLayerSurfaceV1ClosedEvent
func (i *ZwlrLayerSurfaceV1) SetClosedHandler(f ZwlrLayerSurfaceV1ClosedHandlerFunc) {
	i.closedHandler = f
}

func (i *ZwlrLayerSurfaceV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.configureHandler == nil {
			return
		}
		var e ZwlrLayerSurfaceV1ConfigureEvent
		l := 0
		e.Serial = client.Uint32(data[l : l+4])
		l += 4
		e.Width = client.Uint32(data[l : l+4])
		l += 4
		e.Height = client.Uint32(data[l : l+4])
		l += 4

		i.configureHandler(e)
	case 1:
		if i.closedHandler == nil {
			return
		}
		var e ZwlrLayerSurfaceV1ClosedEvent

		i.closedHandler(e)
	}
}
