// Generated by go-wayland-scanner
// https://github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/cmd/go-wayland-scanner
// XML file : wayland-protocols/wlr-gamma-control-unstable-v1.xml
//
// wlr_gamma_control_unstable_v1 Protocol Copyright:
//
// Copyright © 2015 Giulio camuffo
// Copyright © 2018 Simon Ser
//
// Permission to use, copy, modify, distribute, and sell this
// software and its documentation for any purpose is hereby granted
// without fee, provided that the above copyright notice appear in
// all copies and that both that copyright notice and this permission
// notice appear in supporting documentation, and that the name of
// the copyright holders not be used in advertising or publicity
// pertaining to distribution of the software without specific,
// written prior permission.  The copyright holders make no
// representations about the suitability of this software for any
// purpose.  It is provided "as is" without express or implied
// warranty.
//
// THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
// AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
// ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
// THIS SOFTWARE.

package wlr_gamma_control

import (
	"github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/client"
	"golang.org/x/sys/unix"
)

// ZwlrGammaControlManagerV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrGammaControlManagerV1InterfaceName = "zwlr_gamma_control_manager_v1"

// ZwlrGammaControlManagerV1 : manager to create per-output gamma controls
//
// This interface is a manager that allows creating per-output gamma
// controls.
type ZwlrGammaControlManagerV1 struct {
	client.BaseProxy
}

// NewZwlrGammaControlManagerV1 : manager to create per-output gamma controls
//
// This interface is a manager that allows creating per-output gamma
// controls.
func NewZwlrGammaControlManagerV1(ctx *client.Context) *ZwlrGammaControlManagerV1 {
	zwlrGammaControlManagerV1 := &ZwlrGammaControlManagerV1{}
	ctx.Register(zwlrGammaControlManagerV1)
	return zwlrGammaControlManagerV1
}

// GetGammaControl : get a gamma control for an output
//
// Create a gamma control that can be used to adjust gamma tables for the
// provided output.
func (i *ZwlrGammaControlManagerV1) GetGammaControl(output *client.Output) (*ZwlrGammaControlV1, error) {
	id := NewZwlrGammaControlV1(i.Context())
	const opcode = 0
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], id.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], output.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return id, err
}

// Destroy : destroy the manager
//
// All objects created by the manager will still remain valid, until their
// appropriate destroy request has been called.
func (i *ZwlrGammaControlManagerV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 1
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// ZwlrGammaControlV1InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZwlrGammaControlV1InterfaceName = "zwlr_gamma_control_v1"

// ZwlrGammaControlV1 : adjust gamma tables for an output
//
// This interface allows a client to adjust gamma tables for a particular
// output.
//
// The client will receive the gamma size, and will then be able to set gamma
// tables. At any time the compositor can send a failed event indicating that
// this object is no longer valid.
//
// There can only be at most one gamma control object per output, which
// has exclusive access to this particular output. When the gamma control
// object is destroyed, the gamma table is restored to its original value.
type ZwlrGammaControlV1 struct {
	client.BaseProxy
	gammaSizeHandler ZwlrGammaControlV1GammaSizeHandlerFunc
	failedHandler    ZwlrGammaControlV1FailedHandlerFunc
}

// NewZwlrGammaControlV1 : adjust gamma tables for an output
//
// This interface allows a client to adjust gamma tables for a particular
// output.
//
// The client will receive the gamma size, and will then be able to set gamma
// tables. At any time the compositor can send a failed event indicating that
// this object is no longer valid.
//
// There can only be at most one gamma control object per output, which
// has exclusive access to this particular output. When the gamma control
// object is destroyed, the gamma table is restored to its original value.
func NewZwlrGammaControlV1(ctx *client.Context) *ZwlrGammaControlV1 {
	zwlrGammaControlV1 := &ZwlrGammaControlV1{}
	ctx.Register(zwlrGammaControlV1)
	return zwlrGammaControlV1
}

// SetGamma : set the gamma table
//
// Set the gamma table. The file descriptor can be memory-mapped to provide
// the raw gamma table, which contains successive gamma ramps for the red,
// green and blue channels. Each gamma ramp is an array of 16-byte unsigned
// integers which has the same length as the gamma size.
//
// The file descriptor data must have the same length as three times the
// gamma size.
//
//	fd: gamma table file descriptor
func (i *ZwlrGammaControlV1) SetGamma(fd int) error {
	const opcode = 0
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	oob := unix.UnixRights(int(fd))
	err := i.Context().WriteMsg(_reqBuf[:], oob)
	return err
}

// Destroy : destroy this control
//
// Destroys the gamma control object. If the object is still valid, this
// restores the original gamma tables.
func (i *ZwlrGammaControlV1) Destroy() error {
	defer i.MarkZombie()
	const opcode = 1
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

type ZwlrGammaControlV1Error uint32

// ZwlrGammaControlV1Error :
const (
	// ZwlrGammaControlV1ErrorInvalidGamma : invalid gamma tables
	ZwlrGammaControlV1ErrorInvalidGamma ZwlrGammaControlV1Error = 1
)

func (e ZwlrGammaControlV1Error) Name() string {
	switch e {
	case ZwlrGammaControlV1ErrorInvalidGamma:
		return "invalid_gamma"
	default:
		return ""
	}
}

func (e ZwlrGammaControlV1Error) Value() string {
	switch e {
	case ZwlrGammaControlV1ErrorInvalidGamma:
		return "1"
	default:
		return ""
	}
}

func (e ZwlrGammaControlV1Error) String() string {
	return e.Name() + "=" + e.Value()
}

// ZwlrGammaControlV1GammaSizeEvent : size of gamma ramps
//
// Advertise the size of each gamma ramp.
//
// This event is sent immediately when the gamma control object is created.
type ZwlrGammaControlV1GammaSizeEvent struct {
	Size uint32
}
type ZwlrGammaControlV1GammaSizeHandlerFunc func(ZwlrGammaControlV1GammaSizeEvent)

// SetGammaSizeHandler : sets handler for ZwlrGammaControlV1GammaSizeEvent
func (i *ZwlrGammaControlV1) SetGammaSizeHandler(f ZwlrGammaControlV1GammaSizeHandlerFunc) {
	i.gammaSizeHandler = f
}

// ZwlrGammaControlV1FailedEvent : object no longer valid
//
// This event indicates that the gamma control is no longer valid. This
// can happen for a number of reasons, including:
// - The output doesn't support gamma tables
// - Setting the gamma tables failed
// - Another client already has exclusive gamma control for this output
// - The compositor has transferred gamma control to another client
//
// Upon receiving this event, the client should destroy this object.
type ZwlrGammaControlV1FailedEvent struct{}
type ZwlrGammaControlV1FailedHandlerFunc func(ZwlrGammaControlV1FailedEvent)

// SetFailedHandler : sets handler for ZwlrGammaControlV1FailedEvent
func (i *ZwlrGammaControlV1) SetFailedHandler(f ZwlrGammaControlV1FailedHandlerFunc) {
	i.failedHandler = f
}

func (i *ZwlrGammaControlV1) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.gammaSizeHandler == nil {
			return
		}
		var e ZwlrGammaControlV1GammaSizeEvent
		l := 0
		e.Size = client.Uint32(data[l : l+4])
		l += 4

		i.gammaSizeHandler(e)
	case 1:
		if i.failedHandler == nil {
			return
		}
		var e ZwlrGammaControlV1FailedEvent

		i.failedHandler(e)
	}
}
