// Generated by go-wayland-scanner
// https://github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/cmd/go-wayland-scanner
// XML file : internal/proto/xml/dwl-ipc-unstable-v2.xml
//
// dwl_ipc_unstable_v2 Protocol Copyright:

package dwl_ipc

import "github.com/AvengeMedia/DankMaterialShell/core/pkg/go-wayland/wayland/client"

// ZdwlIpcManagerV2InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZdwlIpcManagerV2InterfaceName = "zdwl_ipc_manager_v2"

// ZdwlIpcManagerV2 : manage dwl state
//
// This interface is exposed as a global in wl_registry.
//
// Clients can use this interface to get a dwl_ipc_output.
// After binding the client will recieve the dwl_ipc_manager.tags and dwl_ipc_manager.layout events.
// The dwl_ipc_manager.tags and dwl_ipc_manager.layout events expose tags and layouts to the client.
type ZdwlIpcManagerV2 struct {
	client.BaseProxy
	tagsHandler   ZdwlIpcManagerV2TagsHandlerFunc
	layoutHandler ZdwlIpcManagerV2LayoutHandlerFunc
}

// NewZdwlIpcManagerV2 : manage dwl state
//
// This interface is exposed as a global in wl_registry.
//
// Clients can use this interface to get a dwl_ipc_output.
// After binding the client will recieve the dwl_ipc_manager.tags and dwl_ipc_manager.layout events.
// The dwl_ipc_manager.tags and dwl_ipc_manager.layout events expose tags and layouts to the client.
func NewZdwlIpcManagerV2(ctx *client.Context) *ZdwlIpcManagerV2 {
	zdwlIpcManagerV2 := &ZdwlIpcManagerV2{}
	ctx.Register(zdwlIpcManagerV2)
	return zdwlIpcManagerV2
}

// Release : release dwl_ipc_manager
//
// Indicates that the client will not the dwl_ipc_manager object anymore.
// Objects created through this instance are not affected.
func (i *ZdwlIpcManagerV2) Release() error {
	defer i.MarkZombie()
	const opcode = 0
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// GetOutput : get a dwl_ipc_outout for a wl_output
//
// Get a dwl_ipc_outout for the specified wl_output.
func (i *ZdwlIpcManagerV2) GetOutput(output *client.Output) (*ZdwlIpcOutputV2, error) {
	id := NewZdwlIpcOutputV2(i.Context())
	const opcode = 1
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], id.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], output.ID())
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return id, err
}

// ZdwlIpcManagerV2TagsEvent : Announces tag amount
//
// This event is sent after binding.
// A roundtrip after binding guarantees the client recieved all tags.
type ZdwlIpcManagerV2TagsEvent struct {
	Amount uint32
}
type ZdwlIpcManagerV2TagsHandlerFunc func(ZdwlIpcManagerV2TagsEvent)

// SetTagsHandler : sets handler for ZdwlIpcManagerV2TagsEvent
func (i *ZdwlIpcManagerV2) SetTagsHandler(f ZdwlIpcManagerV2TagsHandlerFunc) {
	i.tagsHandler = f
}

// ZdwlIpcManagerV2LayoutEvent : Announces a layout
//
// This event is sent after binding.
// A roundtrip after binding guarantees the client recieved all layouts.
type ZdwlIpcManagerV2LayoutEvent struct {
	Name string
}
type ZdwlIpcManagerV2LayoutHandlerFunc func(ZdwlIpcManagerV2LayoutEvent)

// SetLayoutHandler : sets handler for ZdwlIpcManagerV2LayoutEvent
func (i *ZdwlIpcManagerV2) SetLayoutHandler(f ZdwlIpcManagerV2LayoutHandlerFunc) {
	i.layoutHandler = f
}

func (i *ZdwlIpcManagerV2) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.tagsHandler == nil {
			return
		}
		var e ZdwlIpcManagerV2TagsEvent
		l := 0
		e.Amount = client.Uint32(data[l : l+4])
		l += 4

		i.tagsHandler(e)
	case 1:
		if i.layoutHandler == nil {
			return
		}
		var e ZdwlIpcManagerV2LayoutEvent
		l := 0
		nameLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Name = client.String(data[l : l+nameLen])
		l += nameLen

		i.layoutHandler(e)
	}
}

// ZdwlIpcOutputV2InterfaceName is the name of the interface as it appears in the [client.Registry].
// It can be used to match the [client.RegistryGlobalEvent.Interface] in the
// [Registry.SetGlobalHandler] and can be used in [Registry.Bind] if this applies.
const ZdwlIpcOutputV2InterfaceName = "zdwl_ipc_output_v2"

// ZdwlIpcOutputV2 : control dwl output
//
// Observe and control a dwl output.
//
// Events are double-buffered:
// Clients should cache events and redraw when a dwl_ipc_output.frame event is sent.
//
// Request are not double-buffered:
// The compositor will update immediately upon request.
type ZdwlIpcOutputV2 struct {
	client.BaseProxy
	toggleVisibilityHandler ZdwlIpcOutputV2ToggleVisibilityHandlerFunc
	activeHandler           ZdwlIpcOutputV2ActiveHandlerFunc
	tagHandler              ZdwlIpcOutputV2TagHandlerFunc
	layoutHandler           ZdwlIpcOutputV2LayoutHandlerFunc
	titleHandler            ZdwlIpcOutputV2TitleHandlerFunc
	appidHandler            ZdwlIpcOutputV2AppidHandlerFunc
	layoutSymbolHandler     ZdwlIpcOutputV2LayoutSymbolHandlerFunc
	frameHandler            ZdwlIpcOutputV2FrameHandlerFunc
	fullscreenHandler       ZdwlIpcOutputV2FullscreenHandlerFunc
	floatingHandler         ZdwlIpcOutputV2FloatingHandlerFunc
	xHandler                ZdwlIpcOutputV2XHandlerFunc
	yHandler                ZdwlIpcOutputV2YHandlerFunc
	widthHandler            ZdwlIpcOutputV2WidthHandlerFunc
	heightHandler           ZdwlIpcOutputV2HeightHandlerFunc
	lastLayerHandler        ZdwlIpcOutputV2LastLayerHandlerFunc
	kbLayoutHandler         ZdwlIpcOutputV2KbLayoutHandlerFunc
	keymodeHandler          ZdwlIpcOutputV2KeymodeHandlerFunc
	scalefactorHandler      ZdwlIpcOutputV2ScalefactorHandlerFunc
}

// NewZdwlIpcOutputV2 : control dwl output
//
// Observe and control a dwl output.
//
// Events are double-buffered:
// Clients should cache events and redraw when a dwl_ipc_output.frame event is sent.
//
// Request are not double-buffered:
// The compositor will update immediately upon request.
func NewZdwlIpcOutputV2(ctx *client.Context) *ZdwlIpcOutputV2 {
	zdwlIpcOutputV2 := &ZdwlIpcOutputV2{}
	ctx.Register(zdwlIpcOutputV2)
	return zdwlIpcOutputV2
}

// Release : release dwl_ipc_outout
//
// Indicates to that the client no longer needs this dwl_ipc_output.
func (i *ZdwlIpcOutputV2) Release() error {
	defer i.MarkZombie()
	const opcode = 0
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetTags : Set the active tags of this output
//
//	tagmask: bitmask of the tags that should be set.
//	toggleTagset: toggle the selected tagset, zero for invalid, nonzero for valid.
func (i *ZdwlIpcOutputV2) SetTags(tagmask, toggleTagset uint32) error {
	const opcode = 1
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(tagmask))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(toggleTagset))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetClientTags : Set the tags of the focused client.
//
// The tags are updated as follows:
// new_tags = (current_tags AND and_tags) XOR xor_tags
func (i *ZdwlIpcOutputV2) SetClientTags(andTags, xorTags uint32) error {
	const opcode = 2
	const _reqBufLen = 8 + 4 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(andTags))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(xorTags))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SetLayout : Set the layout of this output
//
//	index: index of a layout recieved by dwl_ipc_manager.layout
func (i *ZdwlIpcOutputV2) SetLayout(index uint32) error {
	const opcode = 3
	const _reqBufLen = 8 + 4
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(index))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// Quit : Quit mango
// This request allows clients to instruct the compositor to quit mango.
func (i *ZdwlIpcOutputV2) Quit() error {
	const opcode = 4
	const _reqBufLen = 8
	var _reqBuf [_reqBufLen]byte
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	err := i.Context().WriteMsg(_reqBuf[:], nil)
	return err
}

// SendDispatch : Set the active tags of this output
//
//	dispatch: dispatch name.
//	arg1: arg1.
//	arg2: arg2.
//	arg3: arg3.
//	arg4: arg4.
//	arg5: arg5.
func (i *ZdwlIpcOutputV2) SendDispatch(dispatch, arg1, arg2, arg3, arg4, arg5 string) error {
	const opcode = 5
	dispatchLen := client.PaddedLen(len(dispatch) + 1)
	arg1Len := client.PaddedLen(len(arg1) + 1)
	arg2Len := client.PaddedLen(len(arg2) + 1)
	arg3Len := client.PaddedLen(len(arg3) + 1)
	arg4Len := client.PaddedLen(len(arg4) + 1)
	arg5Len := client.PaddedLen(len(arg5) + 1)
	_reqBufLen := 8 + (4 + dispatchLen) + (4 + arg1Len) + (4 + arg2Len) + (4 + arg3Len) + (4 + arg4Len) + (4 + arg5Len)
	_reqBuf := make([]byte, _reqBufLen)
	l := 0
	client.PutUint32(_reqBuf[l:4], i.ID())
	l += 4
	client.PutUint32(_reqBuf[l:l+4], uint32(_reqBufLen<<16|opcode&0x0000ffff))
	l += 4
	client.PutString(_reqBuf[l:l+(4+dispatchLen)], dispatch)
	l += (4 + dispatchLen)
	client.PutString(_reqBuf[l:l+(4+arg1Len)], arg1)
	l += (4 + arg1Len)
	client.PutString(_reqBuf[l:l+(4+arg2Len)], arg2)
	l += (4 + arg2Len)
	client.PutString(_reqBuf[l:l+(4+arg3Len)], arg3)
	l += (4 + arg3Len)
	client.PutString(_reqBuf[l:l+(4+arg4Len)], arg4)
	l += (4 + arg4Len)
	client.PutString(_reqBuf[l:l+(4+arg5Len)], arg5)
	l += (4 + arg5Len)
	err := i.Context().WriteMsg(_reqBuf, nil)
	return err
}

type ZdwlIpcOutputV2TagState uint32

// ZdwlIpcOutputV2TagState :
const (
	// ZdwlIpcOutputV2TagStateNone : no state
	ZdwlIpcOutputV2TagStateNone ZdwlIpcOutputV2TagState = 0
	// ZdwlIpcOutputV2TagStateActive : tag is active
	ZdwlIpcOutputV2TagStateActive ZdwlIpcOutputV2TagState = 1
	// ZdwlIpcOutputV2TagStateUrgent : tag has at least one urgent client
	ZdwlIpcOutputV2TagStateUrgent ZdwlIpcOutputV2TagState = 2
)

func (e ZdwlIpcOutputV2TagState) Name() string {
	switch e {
	case ZdwlIpcOutputV2TagStateNone:
		return "none"
	case ZdwlIpcOutputV2TagStateActive:
		return "active"
	case ZdwlIpcOutputV2TagStateUrgent:
		return "urgent"
	default:
		return ""
	}
}

func (e ZdwlIpcOutputV2TagState) Value() string {
	switch e {
	case ZdwlIpcOutputV2TagStateNone:
		return "0"
	case ZdwlIpcOutputV2TagStateActive:
		return "1"
	case ZdwlIpcOutputV2TagStateUrgent:
		return "2"
	default:
		return ""
	}
}

func (e ZdwlIpcOutputV2TagState) String() string {
	return e.Name() + "=" + e.Value()
}

// ZdwlIpcOutputV2ToggleVisibilityEvent : Toggle client visibilty
//
// Indicates the client should hide or show themselves.
// If the client is visible then hide, if hidden then show.
type ZdwlIpcOutputV2ToggleVisibilityEvent struct{}
type ZdwlIpcOutputV2ToggleVisibilityHandlerFunc func(ZdwlIpcOutputV2ToggleVisibilityEvent)

// SetToggleVisibilityHandler : sets handler for ZdwlIpcOutputV2ToggleVisibilityEvent
func (i *ZdwlIpcOutputV2) SetToggleVisibilityHandler(f ZdwlIpcOutputV2ToggleVisibilityHandlerFunc) {
	i.toggleVisibilityHandler = f
}

// ZdwlIpcOutputV2ActiveEvent : Update the selected output.
//
// Indicates if the output is active. Zero is invalid, nonzero is valid.
type ZdwlIpcOutputV2ActiveEvent struct {
	Active uint32
}
type ZdwlIpcOutputV2ActiveHandlerFunc func(ZdwlIpcOutputV2ActiveEvent)

// SetActiveHandler : sets handler for ZdwlIpcOutputV2ActiveEvent
func (i *ZdwlIpcOutputV2) SetActiveHandler(f ZdwlIpcOutputV2ActiveHandlerFunc) {
	i.activeHandler = f
}

// ZdwlIpcOutputV2TagEvent : Update the state of a tag.
//
// Indicates that a tag has been updated.
type ZdwlIpcOutputV2TagEvent struct {
	Tag     uint32
	State   uint32
	Clients uint32
	Focused uint32
}
type ZdwlIpcOutputV2TagHandlerFunc func(ZdwlIpcOutputV2TagEvent)

// SetTagHandler : sets handler for ZdwlIpcOutputV2TagEvent
func (i *ZdwlIpcOutputV2) SetTagHandler(f ZdwlIpcOutputV2TagHandlerFunc) {
	i.tagHandler = f
}

// ZdwlIpcOutputV2LayoutEvent : Update the layout.
//
// Indicates a new layout is selected.
type ZdwlIpcOutputV2LayoutEvent struct {
	Layout uint32
}
type ZdwlIpcOutputV2LayoutHandlerFunc func(ZdwlIpcOutputV2LayoutEvent)

// SetLayoutHandler : sets handler for ZdwlIpcOutputV2LayoutEvent
func (i *ZdwlIpcOutputV2) SetLayoutHandler(f ZdwlIpcOutputV2LayoutHandlerFunc) {
	i.layoutHandler = f
}

// ZdwlIpcOutputV2TitleEvent : Update the title.
//
// Indicates the title has changed.
type ZdwlIpcOutputV2TitleEvent struct {
	Title string
}
type ZdwlIpcOutputV2TitleHandlerFunc func(ZdwlIpcOutputV2TitleEvent)

// SetTitleHandler : sets handler for ZdwlIpcOutputV2TitleEvent
func (i *ZdwlIpcOutputV2) SetTitleHandler(f ZdwlIpcOutputV2TitleHandlerFunc) {
	i.titleHandler = f
}

// ZdwlIpcOutputV2AppidEvent : Update the appid.
//
// Indicates the appid has changed.
type ZdwlIpcOutputV2AppidEvent struct {
	Appid string
}
type ZdwlIpcOutputV2AppidHandlerFunc func(ZdwlIpcOutputV2AppidEvent)

// SetAppidHandler : sets handler for ZdwlIpcOutputV2AppidEvent
func (i *ZdwlIpcOutputV2) SetAppidHandler(f ZdwlIpcOutputV2AppidHandlerFunc) {
	i.appidHandler = f
}

// ZdwlIpcOutputV2LayoutSymbolEvent : Update the current layout symbol
//
// Indicates the layout has changed. Since layout symbols are dynamic.
// As opposed to the zdwl_ipc_manager.layout event, this should take precendence when displaying.
// You can ignore the zdwl_ipc_output.layout event.
type ZdwlIpcOutputV2LayoutSymbolEvent struct {
	Layout string
}
type ZdwlIpcOutputV2LayoutSymbolHandlerFunc func(ZdwlIpcOutputV2LayoutSymbolEvent)

// SetLayoutSymbolHandler : sets handler for ZdwlIpcOutputV2LayoutSymbolEvent
func (i *ZdwlIpcOutputV2) SetLayoutSymbolHandler(f ZdwlIpcOutputV2LayoutSymbolHandlerFunc) {
	i.layoutSymbolHandler = f
}

// ZdwlIpcOutputV2FrameEvent : The update sequence is done.
//
// Indicates that a sequence of status updates have finished and the client should redraw.
type ZdwlIpcOutputV2FrameEvent struct{}
type ZdwlIpcOutputV2FrameHandlerFunc func(ZdwlIpcOutputV2FrameEvent)

// SetFrameHandler : sets handler for ZdwlIpcOutputV2FrameEvent
func (i *ZdwlIpcOutputV2) SetFrameHandler(f ZdwlIpcOutputV2FrameHandlerFunc) {
	i.frameHandler = f
}

// ZdwlIpcOutputV2FullscreenEvent : Update fullscreen status
//
// Indicates if the selected client on this output is fullscreen.
type ZdwlIpcOutputV2FullscreenEvent struct {
	IsFullscreen uint32
}
type ZdwlIpcOutputV2FullscreenHandlerFunc func(ZdwlIpcOutputV2FullscreenEvent)

// SetFullscreenHandler : sets handler for ZdwlIpcOutputV2FullscreenEvent
func (i *ZdwlIpcOutputV2) SetFullscreenHandler(f ZdwlIpcOutputV2FullscreenHandlerFunc) {
	i.fullscreenHandler = f
}

// ZdwlIpcOutputV2FloatingEvent : Update the floating status
//
// Indicates if the selected client on this output is floating.
type ZdwlIpcOutputV2FloatingEvent struct {
	IsFloating uint32
}
type ZdwlIpcOutputV2FloatingHandlerFunc func(ZdwlIpcOutputV2FloatingEvent)

// SetFloatingHandler : sets handler for ZdwlIpcOutputV2FloatingEvent
func (i *ZdwlIpcOutputV2) SetFloatingHandler(f ZdwlIpcOutputV2FloatingHandlerFunc) {
	i.floatingHandler = f
}

// ZdwlIpcOutputV2XEvent : Update the x coordinates
//
// Indicates if x coordinates of the selected client.
type ZdwlIpcOutputV2XEvent struct {
	X int32
}
type ZdwlIpcOutputV2XHandlerFunc func(ZdwlIpcOutputV2XEvent)

// SetXHandler : sets handler for ZdwlIpcOutputV2XEvent
func (i *ZdwlIpcOutputV2) SetXHandler(f ZdwlIpcOutputV2XHandlerFunc) {
	i.xHandler = f
}

// ZdwlIpcOutputV2YEvent : Update the y coordinates
//
// Indicates if y coordinates of the selected client.
type ZdwlIpcOutputV2YEvent struct {
	Y int32
}
type ZdwlIpcOutputV2YHandlerFunc func(ZdwlIpcOutputV2YEvent)

// SetYHandler : sets handler for ZdwlIpcOutputV2YEvent
func (i *ZdwlIpcOutputV2) SetYHandler(f ZdwlIpcOutputV2YHandlerFunc) {
	i.yHandler = f
}

// ZdwlIpcOutputV2WidthEvent : Update the width
//
// Indicates if width of the selected client.
type ZdwlIpcOutputV2WidthEvent struct {
	Width int32
}
type ZdwlIpcOutputV2WidthHandlerFunc func(ZdwlIpcOutputV2WidthEvent)

// SetWidthHandler : sets handler for ZdwlIpcOutputV2WidthEvent
func (i *ZdwlIpcOutputV2) SetWidthHandler(f ZdwlIpcOutputV2WidthHandlerFunc) {
	i.widthHandler = f
}

// ZdwlIpcOutputV2HeightEvent : Update the height
//
// Indicates if height of the selected client.
type ZdwlIpcOutputV2HeightEvent struct {
	Height int32
}
type ZdwlIpcOutputV2HeightHandlerFunc func(ZdwlIpcOutputV2HeightEvent)

// SetHeightHandler : sets handler for ZdwlIpcOutputV2HeightEvent
func (i *ZdwlIpcOutputV2) SetHeightHandler(f ZdwlIpcOutputV2HeightHandlerFunc) {
	i.heightHandler = f
}

// ZdwlIpcOutputV2LastLayerEvent : last map layer.
//
// last map layer.
type ZdwlIpcOutputV2LastLayerEvent struct {
	LastLayer string
}
type ZdwlIpcOutputV2LastLayerHandlerFunc func(ZdwlIpcOutputV2LastLayerEvent)

// SetLastLayerHandler : sets handler for ZdwlIpcOutputV2LastLayerEvent
func (i *ZdwlIpcOutputV2) SetLastLayerHandler(f ZdwlIpcOutputV2LastLayerHandlerFunc) {
	i.lastLayerHandler = f
}

// ZdwlIpcOutputV2KbLayoutEvent : current keyboard layout.
//
// current keyboard layout.
type ZdwlIpcOutputV2KbLayoutEvent struct {
	KbLayout string
}
type ZdwlIpcOutputV2KbLayoutHandlerFunc func(ZdwlIpcOutputV2KbLayoutEvent)

// SetKbLayoutHandler : sets handler for ZdwlIpcOutputV2KbLayoutEvent
func (i *ZdwlIpcOutputV2) SetKbLayoutHandler(f ZdwlIpcOutputV2KbLayoutHandlerFunc) {
	i.kbLayoutHandler = f
}

// ZdwlIpcOutputV2KeymodeEvent : current keybind mode.
//
// current keybind mode.
type ZdwlIpcOutputV2KeymodeEvent struct {
	Keymode string
}
type ZdwlIpcOutputV2KeymodeHandlerFunc func(ZdwlIpcOutputV2KeymodeEvent)

// SetKeymodeHandler : sets handler for ZdwlIpcOutputV2KeymodeEvent
func (i *ZdwlIpcOutputV2) SetKeymodeHandler(f ZdwlIpcOutputV2KeymodeHandlerFunc) {
	i.keymodeHandler = f
}

// ZdwlIpcOutputV2ScalefactorEvent : scale factor of monitor.
//
// scale factor of monitor.
type ZdwlIpcOutputV2ScalefactorEvent struct {
	Scalefactor uint32
}
type ZdwlIpcOutputV2ScalefactorHandlerFunc func(ZdwlIpcOutputV2ScalefactorEvent)

// SetScalefactorHandler : sets handler for ZdwlIpcOutputV2ScalefactorEvent
func (i *ZdwlIpcOutputV2) SetScalefactorHandler(f ZdwlIpcOutputV2ScalefactorHandlerFunc) {
	i.scalefactorHandler = f
}

func (i *ZdwlIpcOutputV2) Dispatch(opcode uint32, fd int, data []byte) {
	switch opcode {
	case 0:
		if i.toggleVisibilityHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2ToggleVisibilityEvent

		i.toggleVisibilityHandler(e)
	case 1:
		if i.activeHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2ActiveEvent
		l := 0
		e.Active = client.Uint32(data[l : l+4])
		l += 4

		i.activeHandler(e)
	case 2:
		if i.tagHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2TagEvent
		l := 0
		e.Tag = client.Uint32(data[l : l+4])
		l += 4
		e.State = client.Uint32(data[l : l+4])
		l += 4
		e.Clients = client.Uint32(data[l : l+4])
		l += 4
		e.Focused = client.Uint32(data[l : l+4])
		l += 4

		i.tagHandler(e)
	case 3:
		if i.layoutHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2LayoutEvent
		l := 0
		e.Layout = client.Uint32(data[l : l+4])
		l += 4

		i.layoutHandler(e)
	case 4:
		if i.titleHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2TitleEvent
		l := 0
		titleLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Title = client.String(data[l : l+titleLen])
		l += titleLen

		i.titleHandler(e)
	case 5:
		if i.appidHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2AppidEvent
		l := 0
		appidLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Appid = client.String(data[l : l+appidLen])
		l += appidLen

		i.appidHandler(e)
	case 6:
		if i.layoutSymbolHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2LayoutSymbolEvent
		l := 0
		layoutLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Layout = client.String(data[l : l+layoutLen])
		l += layoutLen

		i.layoutSymbolHandler(e)
	case 7:
		if i.frameHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2FrameEvent

		i.frameHandler(e)
	case 8:
		if i.fullscreenHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2FullscreenEvent
		l := 0
		e.IsFullscreen = client.Uint32(data[l : l+4])
		l += 4

		i.fullscreenHandler(e)
	case 9:
		if i.floatingHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2FloatingEvent
		l := 0
		e.IsFloating = client.Uint32(data[l : l+4])
		l += 4

		i.floatingHandler(e)
	case 10:
		if i.xHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2XEvent
		l := 0
		e.X = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.xHandler(e)
	case 11:
		if i.yHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2YEvent
		l := 0
		e.Y = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.yHandler(e)
	case 12:
		if i.widthHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2WidthEvent
		l := 0
		e.Width = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.widthHandler(e)
	case 13:
		if i.heightHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2HeightEvent
		l := 0
		e.Height = int32(client.Uint32(data[l : l+4]))
		l += 4

		i.heightHandler(e)
	case 14:
		if i.lastLayerHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2LastLayerEvent
		l := 0
		lastLayerLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.LastLayer = client.String(data[l : l+lastLayerLen])
		l += lastLayerLen

		i.lastLayerHandler(e)
	case 15:
		if i.kbLayoutHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2KbLayoutEvent
		l := 0
		kbLayoutLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.KbLayout = client.String(data[l : l+kbLayoutLen])
		l += kbLayoutLen

		i.kbLayoutHandler(e)
	case 16:
		if i.keymodeHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2KeymodeEvent
		l := 0
		keymodeLen := client.PaddedLen(int(client.Uint32(data[l : l+4])))
		l += 4
		e.Keymode = client.String(data[l : l+keymodeLen])
		l += keymodeLen

		i.keymodeHandler(e)
	case 17:
		if i.scalefactorHandler == nil {
			return
		}
		var e ZdwlIpcOutputV2ScalefactorEvent
		l := 0
		e.Scalefactor = client.Uint32(data[l : l+4])
		l += 4

		i.scalefactorHandler(e)
	}
}
