#!/bin/bash

set -euo pipefail

# Colors for output
GREEN='\033[0;32m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Get latest version tag
VERSION=$(git describe --tags --abbrev=0 2>/dev/null || echo "v0.0.0")

echo -e "${GREEN}Building dankinstall ${VERSION}${NC}"

# Create bin directory if it doesn't exist
mkdir -p bin

# Build for each architecture
for ARCH in amd64 arm64; do
    echo -e "${BLUE}Building for ${ARCH}...${NC}"

    cd cmd/dankinstall
    GOOS=linux CGO_ENABLED=0 GOARCH=${ARCH} \
        go build -trimpath -ldflags "-s -w -X main.Version=${VERSION}" \
        -o ../../bin/dankinstall-${ARCH}
    cd ../..

    # Compress
    gzip -9 -k -f bin/dankinstall-${ARCH}

    # Generate checksum
    (cd bin && sha256sum dankinstall-${ARCH}.gz > dankinstall-${ARCH}.gz.sha256)

    echo -e "${GREEN}✓ Built bin/dankinstall-${ARCH}.gz${NC}"
done

echo -e "${GREEN}Done! Files ready in bin/:${NC}"
ls -lh bin/dankinstall-*
