"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactType = void 0;
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
    /**
     * Nested Cloud Assembly
     */
    ArtifactType["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
})(ArtifactType || (exports.ArtifactType = ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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