/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { UserSelfGroups } from './UserSelfGroups';
import {
    UserSelfGroupsFromJSON,
    UserSelfGroupsFromJSONTyped,
    UserSelfGroupsToJSON,
} from './UserSelfGroups';
import type { UserTypeEnum } from './UserTypeEnum';
import {
    UserTypeEnumFromJSON,
    UserTypeEnumFromJSONTyped,
    UserTypeEnumToJSON,
} from './UserTypeEnum';

/**
 * User Serializer for information a user can retrieve about themselves
 * @export
 * @interface UserSelf
 */
export interface UserSelf {
    /**
     * 
     * @type {number}
     * @memberof UserSelf
     */
    readonly pk: number;
    /**
     * Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.
     * @type {string}
     * @memberof UserSelf
     */
    username: string;
    /**
     * User's display name.
     * @type {string}
     * @memberof UserSelf
     */
    name: string;
    /**
     * Designates whether this user should be treated as active. Unselect this instead of deleting accounts.
     * @type {boolean}
     * @memberof UserSelf
     */
    readonly isActive: boolean;
    /**
     * 
     * @type {boolean}
     * @memberof UserSelf
     */
    readonly isSuperuser: boolean;
    /**
     * 
     * @type {Array<UserSelfGroups>}
     * @memberof UserSelf
     */
    readonly groups: Array<UserSelfGroups>;
    /**
     * 
     * @type {string}
     * @memberof UserSelf
     */
    email?: string;
    /**
     * User's avatar, either a http/https URL or a data URI
     * @type {string}
     * @memberof UserSelf
     */
    readonly avatar: string;
    /**
     * 
     * @type {string}
     * @memberof UserSelf
     */
    readonly uid: string;
    /**
     * Get user settings with brand and group settings applied
     * @type {{ [key: string]: any; }}
     * @memberof UserSelf
     */
    readonly settings: { [key: string]: any; };
    /**
     * 
     * @type {UserTypeEnum}
     * @memberof UserSelf
     */
    type?: UserTypeEnum;
    /**
     * Get all system permissions assigned to the user
     * @type {Array<string>}
     * @memberof UserSelf
     */
    readonly systemPermissions: Array<string>;
}

/**
 * Check if a given object implements the UserSelf interface.
 */
export function instanceOfUserSelf(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "username" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "isActive" in value;
    isInstance = isInstance && "isSuperuser" in value;
    isInstance = isInstance && "groups" in value;
    isInstance = isInstance && "avatar" in value;
    isInstance = isInstance && "uid" in value;
    isInstance = isInstance && "settings" in value;
    isInstance = isInstance && "systemPermissions" in value;

    return isInstance;
}

export function UserSelfFromJSON(json: any): UserSelf {
    return UserSelfFromJSONTyped(json, false);
}

export function UserSelfFromJSONTyped(json: any, ignoreDiscriminator: boolean): UserSelf {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'username': json['username'],
        'name': json['name'],
        'isActive': json['is_active'],
        'isSuperuser': json['is_superuser'],
        'groups': ((json['groups'] as Array<any>).map(UserSelfGroupsFromJSON)),
        'email': !exists(json, 'email') ? undefined : json['email'],
        'avatar': json['avatar'],
        'uid': json['uid'],
        'settings': json['settings'],
        'type': !exists(json, 'type') ? undefined : UserTypeEnumFromJSON(json['type']),
        'systemPermissions': json['system_permissions'],
    };
}

export function UserSelfToJSON(value?: UserSelf | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'username': value.username,
        'name': value.name,
        'email': value.email,
        'type': UserTypeEnumToJSON(value.type),
    };
}

