/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import {
    DigestAlgorithmEnumFromJSON,
    DigestAlgorithmEnumFromJSONTyped,
    DigestAlgorithmEnumToJSON,
} from './DigestAlgorithmEnum';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import {
    SignatureAlgorithmEnumFromJSON,
    SignatureAlgorithmEnumFromJSONTyped,
    SignatureAlgorithmEnumToJSON,
} from './SignatureAlgorithmEnum';
import type { SpBindingEnum } from './SpBindingEnum';
import {
    SpBindingEnumFromJSON,
    SpBindingEnumFromJSONTyped,
    SpBindingEnumToJSON,
} from './SpBindingEnum';

/**
 * SAMLProvider Serializer
 * @export
 * @interface SAMLProvider
 */
export interface SAMLProvider {
    /**
     * 
     * @type {number}
     * @memberof SAMLProvider
     */
    readonly pk: number;
    /**
     * 
     * @type {string}
     * @memberof SAMLProvider
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof SAMLProvider
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof SAMLProvider
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof SAMLProvider
     */
    propertyMappings?: Array<string>;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly component: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedApplicationName: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedBackchannelApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedBackchannelApplicationName: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly metaModelName: string;
    /**
     * 
     * @type {string}
     * @memberof SAMLProvider
     */
    acsUrl: string;
    /**
     * Value of the audience restriction field of the assertion. When left empty, no audience restriction will be added.
     * @type {string}
     * @memberof SAMLProvider
     */
    audience?: string;
    /**
     * Also known as EntityID
     * @type {string}
     * @memberof SAMLProvider
     */
    issuer?: string;
    /**
     * Assertion valid not before current time + this value (Format: hours=-1;minutes=-2;seconds=-3).
     * @type {string}
     * @memberof SAMLProvider
     */
    assertionValidNotBefore?: string;
    /**
     * Assertion not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProvider
     */
    assertionValidNotOnOrAfter?: string;
    /**
     * Session not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProvider
     */
    sessionValidNotOnOrAfter?: string;
    /**
     * Configure how the NameID value will be created. When left empty, the NameIDPolicy of the incoming request will be considered
     * @type {string}
     * @memberof SAMLProvider
     */
    nameIdMapping?: string | null;
    /**
     * 
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLProvider
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     * 
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLProvider
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Keypair used to sign outgoing Responses going to the Service Provider.
     * @type {string}
     * @memberof SAMLProvider
     */
    signingKp?: string | null;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLProvider
     */
    verificationKp?: string | null;
    /**
     * 
     * @type {SpBindingEnum}
     * @memberof SAMLProvider
     */
    spBinding?: SpBindingEnum;
    /**
     * Default relay_state value for IDP-initiated logins
     * @type {string}
     * @memberof SAMLProvider
     */
    defaultRelayState?: string;
    /**
     * Get metadata download URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlDownloadMetadata: string;
    /**
     * Get SSO Post URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoPost: string;
    /**
     * Get SSO Redirect URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoRedirect: string;
    /**
     * Get SSO IDP-Initiated URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoInit: string;
    /**
     * Get SLO POST URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSloPost: string;
    /**
     * Get SLO redirect URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSloRedirect: string;
}

/**
 * Check if a given object implements the SAMLProvider interface.
 */
export function instanceOfSAMLProvider(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;
    isInstance = isInstance && "component" in value;
    isInstance = isInstance && "assignedApplicationSlug" in value;
    isInstance = isInstance && "assignedApplicationName" in value;
    isInstance = isInstance && "assignedBackchannelApplicationSlug" in value;
    isInstance = isInstance && "assignedBackchannelApplicationName" in value;
    isInstance = isInstance && "verboseName" in value;
    isInstance = isInstance && "verboseNamePlural" in value;
    isInstance = isInstance && "metaModelName" in value;
    isInstance = isInstance && "acsUrl" in value;
    isInstance = isInstance && "urlDownloadMetadata" in value;
    isInstance = isInstance && "urlSsoPost" in value;
    isInstance = isInstance && "urlSsoRedirect" in value;
    isInstance = isInstance && "urlSsoInit" in value;
    isInstance = isInstance && "urlSloPost" in value;
    isInstance = isInstance && "urlSloRedirect" in value;

    return isInstance;
}

export function SAMLProviderFromJSON(json: any): SAMLProvider {
    return SAMLProviderFromJSONTyped(json, false);
}

export function SAMLProviderFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLProvider {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'component': json['component'],
        'assignedApplicationSlug': json['assigned_application_slug'],
        'assignedApplicationName': json['assigned_application_name'],
        'assignedBackchannelApplicationSlug': json['assigned_backchannel_application_slug'],
        'assignedBackchannelApplicationName': json['assigned_backchannel_application_name'],
        'verboseName': json['verbose_name'],
        'verboseNamePlural': json['verbose_name_plural'],
        'metaModelName': json['meta_model_name'],
        'acsUrl': json['acs_url'],
        'audience': !exists(json, 'audience') ? undefined : json['audience'],
        'issuer': !exists(json, 'issuer') ? undefined : json['issuer'],
        'assertionValidNotBefore': !exists(json, 'assertion_valid_not_before') ? undefined : json['assertion_valid_not_before'],
        'assertionValidNotOnOrAfter': !exists(json, 'assertion_valid_not_on_or_after') ? undefined : json['assertion_valid_not_on_or_after'],
        'sessionValidNotOnOrAfter': !exists(json, 'session_valid_not_on_or_after') ? undefined : json['session_valid_not_on_or_after'],
        'nameIdMapping': !exists(json, 'name_id_mapping') ? undefined : json['name_id_mapping'],
        'digestAlgorithm': !exists(json, 'digest_algorithm') ? undefined : DigestAlgorithmEnumFromJSON(json['digest_algorithm']),
        'signatureAlgorithm': !exists(json, 'signature_algorithm') ? undefined : SignatureAlgorithmEnumFromJSON(json['signature_algorithm']),
        'signingKp': !exists(json, 'signing_kp') ? undefined : json['signing_kp'],
        'verificationKp': !exists(json, 'verification_kp') ? undefined : json['verification_kp'],
        'spBinding': !exists(json, 'sp_binding') ? undefined : SpBindingEnumFromJSON(json['sp_binding']),
        'defaultRelayState': !exists(json, 'default_relay_state') ? undefined : json['default_relay_state'],
        'urlDownloadMetadata': json['url_download_metadata'],
        'urlSsoPost': json['url_sso_post'],
        'urlSsoRedirect': json['url_sso_redirect'],
        'urlSsoInit': json['url_sso_init'],
        'urlSloPost': json['url_slo_post'],
        'urlSloRedirect': json['url_slo_redirect'],
    };
}

export function SAMLProviderToJSON(value?: SAMLProvider | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'acs_url': value.acsUrl,
        'audience': value.audience,
        'issuer': value.issuer,
        'assertion_valid_not_before': value.assertionValidNotBefore,
        'assertion_valid_not_on_or_after': value.assertionValidNotOnOrAfter,
        'session_valid_not_on_or_after': value.sessionValidNotOnOrAfter,
        'name_id_mapping': value.nameIdMapping,
        'digest_algorithm': DigestAlgorithmEnumToJSON(value.digestAlgorithm),
        'signature_algorithm': SignatureAlgorithmEnumToJSON(value.signatureAlgorithm),
        'signing_kp': value.signingKp,
        'verification_kp': value.verificationKp,
        'sp_binding': SpBindingEnumToJSON(value.spBinding),
        'default_relay_state': value.defaultRelayState,
    };
}

