/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { PolicyEngineMode } from './PolicyEngineMode';
import {
    PolicyEngineModeFromJSON,
    PolicyEngineModeFromJSONTyped,
    PolicyEngineModeToJSON,
} from './PolicyEngineMode';
import type { ProviderTypeEnum } from './ProviderTypeEnum';
import {
    ProviderTypeEnumFromJSON,
    ProviderTypeEnumFromJSONTyped,
    ProviderTypeEnumToJSON,
} from './ProviderTypeEnum';
import type { SourceType } from './SourceType';
import {
    SourceTypeFromJSON,
    SourceTypeFromJSONTyped,
    SourceTypeToJSON,
} from './SourceType';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
import {
    UserMatchingModeEnumFromJSON,
    UserMatchingModeEnumFromJSONTyped,
    UserMatchingModeEnumToJSON,
} from './UserMatchingModeEnum';

/**
 * OAuth Source Serializer
 * @export
 * @interface OAuthSource
 */
export interface OAuthSource {
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    readonly pk: string;
    /**
     * Source's display Name.
     * @type {string}
     * @memberof OAuthSource
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof OAuthSource
     */
    slug: string;
    /**
     * 
     * @type {boolean}
     * @memberof OAuthSource
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof OAuthSource
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof OAuthSource
     */
    enrollmentFlow?: string | null;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof OAuthSource
     */
    readonly component: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof OAuthSource
     */
    readonly metaModelName: string;
    /**
     * 
     * @type {PolicyEngineMode}
     * @memberof OAuthSource
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     * 
     * @type {UserMatchingModeEnum}
     * @memberof OAuthSource
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     * Objects that are managed by authentik. These objects are created and updated automatically. This flag only indicates that an object can be overwritten by migrations. You can still modify the objects via the API, but expect changes to be overwritten in a later update.
     * @type {string}
     * @memberof OAuthSource
     */
    readonly managed: string | null;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    userPathTemplate?: string;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    readonly icon: string | null;
    /**
     * 
     * @type {ProviderTypeEnum}
     * @memberof OAuthSource
     */
    providerType: ProviderTypeEnum;
    /**
     * URL used to request the initial token. This URL is only required for OAuth 1.
     * @type {string}
     * @memberof OAuthSource
     */
    requestTokenUrl?: string | null;
    /**
     * URL the user is redirect to to conest the flow.
     * @type {string}
     * @memberof OAuthSource
     */
    authorizationUrl?: string | null;
    /**
     * URL used by authentik to retrieve tokens.
     * @type {string}
     * @memberof OAuthSource
     */
    accessTokenUrl?: string | null;
    /**
     * URL used by authentik to get user information.
     * @type {string}
     * @memberof OAuthSource
     */
    profileUrl?: string | null;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    consumerKey: string;
    /**
     * Get OAuth Callback URL
     * @type {string}
     * @memberof OAuthSource
     */
    readonly callbackUrl: string;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    additionalScopes?: string;
    /**
     * 
     * @type {SourceType}
     * @memberof OAuthSource
     */
    readonly type: SourceType;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    oidcWellKnownUrl?: string;
    /**
     * 
     * @type {string}
     * @memberof OAuthSource
     */
    oidcJwksUrl?: string;
    /**
     * 
     * @type {any}
     * @memberof OAuthSource
     */
    oidcJwks?: any | null;
}

/**
 * Check if a given object implements the OAuthSource interface.
 */
export function instanceOfOAuthSource(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "slug" in value;
    isInstance = isInstance && "component" in value;
    isInstance = isInstance && "verboseName" in value;
    isInstance = isInstance && "verboseNamePlural" in value;
    isInstance = isInstance && "metaModelName" in value;
    isInstance = isInstance && "managed" in value;
    isInstance = isInstance && "icon" in value;
    isInstance = isInstance && "providerType" in value;
    isInstance = isInstance && "consumerKey" in value;
    isInstance = isInstance && "callbackUrl" in value;
    isInstance = isInstance && "type" in value;

    return isInstance;
}

export function OAuthSourceFromJSON(json: any): OAuthSource {
    return OAuthSourceFromJSONTyped(json, false);
}

export function OAuthSourceFromJSONTyped(json: any, ignoreDiscriminator: boolean): OAuthSource {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'name': json['name'],
        'slug': json['slug'],
        'enabled': !exists(json, 'enabled') ? undefined : json['enabled'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'enrollmentFlow': !exists(json, 'enrollment_flow') ? undefined : json['enrollment_flow'],
        'component': json['component'],
        'verboseName': json['verbose_name'],
        'verboseNamePlural': json['verbose_name_plural'],
        'metaModelName': json['meta_model_name'],
        'policyEngineMode': !exists(json, 'policy_engine_mode') ? undefined : PolicyEngineModeFromJSON(json['policy_engine_mode']),
        'userMatchingMode': !exists(json, 'user_matching_mode') ? undefined : UserMatchingModeEnumFromJSON(json['user_matching_mode']),
        'managed': json['managed'],
        'userPathTemplate': !exists(json, 'user_path_template') ? undefined : json['user_path_template'],
        'icon': json['icon'],
        'providerType': ProviderTypeEnumFromJSON(json['provider_type']),
        'requestTokenUrl': !exists(json, 'request_token_url') ? undefined : json['request_token_url'],
        'authorizationUrl': !exists(json, 'authorization_url') ? undefined : json['authorization_url'],
        'accessTokenUrl': !exists(json, 'access_token_url') ? undefined : json['access_token_url'],
        'profileUrl': !exists(json, 'profile_url') ? undefined : json['profile_url'],
        'consumerKey': json['consumer_key'],
        'callbackUrl': json['callback_url'],
        'additionalScopes': !exists(json, 'additional_scopes') ? undefined : json['additional_scopes'],
        'type': SourceTypeFromJSON(json['type']),
        'oidcWellKnownUrl': !exists(json, 'oidc_well_known_url') ? undefined : json['oidc_well_known_url'],
        'oidcJwksUrl': !exists(json, 'oidc_jwks_url') ? undefined : json['oidc_jwks_url'],
        'oidcJwks': !exists(json, 'oidc_jwks') ? undefined : json['oidc_jwks'],
    };
}

export function OAuthSourceToJSON(value?: OAuthSource | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'slug': value.slug,
        'enabled': value.enabled,
        'authentication_flow': value.authenticationFlow,
        'enrollment_flow': value.enrollmentFlow,
        'policy_engine_mode': PolicyEngineModeToJSON(value.policyEngineMode),
        'user_matching_mode': UserMatchingModeEnumToJSON(value.userMatchingMode),
        'user_path_template': value.userPathTemplate,
        'provider_type': ProviderTypeEnumToJSON(value.providerType),
        'request_token_url': value.requestTokenUrl,
        'authorization_url': value.authorizationUrl,
        'access_token_url': value.accessTokenUrl,
        'profile_url': value.profileUrl,
        'consumer_key': value.consumerKey,
        'additional_scopes': value.additionalScopes,
        'oidc_well_known_url': value.oidcWellKnownUrl,
        'oidc_jwks_url': value.oidcJwksUrl,
        'oidc_jwks': value.oidcJwks,
    };
}

