/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { ClientTypeEnum } from './ClientTypeEnum';
import {
    ClientTypeEnumFromJSON,
    ClientTypeEnumFromJSONTyped,
    ClientTypeEnumToJSON,
} from './ClientTypeEnum';
import type { IssuerModeEnum } from './IssuerModeEnum';
import {
    IssuerModeEnumFromJSON,
    IssuerModeEnumFromJSONTyped,
    IssuerModeEnumToJSON,
} from './IssuerModeEnum';
import type { SubModeEnum } from './SubModeEnum';
import {
    SubModeEnumFromJSON,
    SubModeEnumFromJSONTyped,
    SubModeEnumToJSON,
} from './SubModeEnum';

/**
 * OAuth2Provider Serializer
 * @export
 * @interface OAuth2ProviderRequest
 */
export interface OAuth2ProviderRequest {
    /**
     * 
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    authorizationFlow: string;
    /**
     * 
     * @type {Array<string>}
     * @memberof OAuth2ProviderRequest
     */
    propertyMappings?: Array<string>;
    /**
     * 
     * @type {ClientTypeEnum}
     * @memberof OAuth2ProviderRequest
     */
    clientType?: ClientTypeEnum;
    /**
     * 
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    clientId?: string;
    /**
     * 
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    clientSecret?: string;
    /**
     * Access codes not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    accessCodeValidity?: string;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    accessTokenValidity?: string;
    /**
     * Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    refreshTokenValidity?: string;
    /**
     * Include User claims from scopes in the id_token, for applications that don't access the userinfo endpoint.
     * @type {boolean}
     * @memberof OAuth2ProviderRequest
     */
    includeClaimsInIdToken?: boolean;
    /**
     * Key used to sign the tokens. Only required when JWT Algorithm is set to RS256.
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    signingKey?: string | null;
    /**
     * Enter each URI on a new line.
     * @type {string}
     * @memberof OAuth2ProviderRequest
     */
    redirectUris?: string;
    /**
     * 
     * @type {SubModeEnum}
     * @memberof OAuth2ProviderRequest
     */
    subMode?: SubModeEnum;
    /**
     * 
     * @type {IssuerModeEnum}
     * @memberof OAuth2ProviderRequest
     */
    issuerMode?: IssuerModeEnum;
    /**
     * 
     * @type {Array<string>}
     * @memberof OAuth2ProviderRequest
     */
    jwksSources?: Array<string>;
}

/**
 * Check if a given object implements the OAuth2ProviderRequest interface.
 */
export function instanceOfOAuth2ProviderRequest(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "authorizationFlow" in value;

    return isInstance;
}

export function OAuth2ProviderRequestFromJSON(json: any): OAuth2ProviderRequest {
    return OAuth2ProviderRequestFromJSONTyped(json, false);
}

export function OAuth2ProviderRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): OAuth2ProviderRequest {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'name': json['name'],
        'authenticationFlow': !exists(json, 'authentication_flow') ? undefined : json['authentication_flow'],
        'authorizationFlow': json['authorization_flow'],
        'propertyMappings': !exists(json, 'property_mappings') ? undefined : json['property_mappings'],
        'clientType': !exists(json, 'client_type') ? undefined : ClientTypeEnumFromJSON(json['client_type']),
        'clientId': !exists(json, 'client_id') ? undefined : json['client_id'],
        'clientSecret': !exists(json, 'client_secret') ? undefined : json['client_secret'],
        'accessCodeValidity': !exists(json, 'access_code_validity') ? undefined : json['access_code_validity'],
        'accessTokenValidity': !exists(json, 'access_token_validity') ? undefined : json['access_token_validity'],
        'refreshTokenValidity': !exists(json, 'refresh_token_validity') ? undefined : json['refresh_token_validity'],
        'includeClaimsInIdToken': !exists(json, 'include_claims_in_id_token') ? undefined : json['include_claims_in_id_token'],
        'signingKey': !exists(json, 'signing_key') ? undefined : json['signing_key'],
        'redirectUris': !exists(json, 'redirect_uris') ? undefined : json['redirect_uris'],
        'subMode': !exists(json, 'sub_mode') ? undefined : SubModeEnumFromJSON(json['sub_mode']),
        'issuerMode': !exists(json, 'issuer_mode') ? undefined : IssuerModeEnumFromJSON(json['issuer_mode']),
        'jwksSources': !exists(json, 'jwks_sources') ? undefined : json['jwks_sources'],
    };
}

export function OAuth2ProviderRequestToJSON(value?: OAuth2ProviderRequest | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'name': value.name,
        'authentication_flow': value.authenticationFlow,
        'authorization_flow': value.authorizationFlow,
        'property_mappings': value.propertyMappings,
        'client_type': ClientTypeEnumToJSON(value.clientType),
        'client_id': value.clientId,
        'client_secret': value.clientSecret,
        'access_code_validity': value.accessCodeValidity,
        'access_token_validity': value.accessTokenValidity,
        'refresh_token_validity': value.refreshTokenValidity,
        'include_claims_in_id_token': value.includeClaimsInIdToken,
        'signing_key': value.signingKey,
        'redirect_uris': value.redirectUris,
        'sub_mode': SubModeEnumToJSON(value.subMode),
        'issuer_mode': IssuerModeEnumToJSON(value.issuerMode),
        'jwks_sources': value.jwksSources,
    };
}

