/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { OAuth2Provider } from './OAuth2Provider';
import {
    OAuth2ProviderFromJSON,
    OAuth2ProviderFromJSONTyped,
    OAuth2ProviderToJSON,
} from './OAuth2Provider';
import type { User } from './User';
import {
    UserFromJSON,
    UserFromJSONTyped,
    UserToJSON,
} from './User';

/**
 * Serializer for BaseGrantModel and ExpiringBaseGrant
 * @export
 * @interface ExpiringBaseGrantModel
 */
export interface ExpiringBaseGrantModel {
    /**
     * 
     * @type {number}
     * @memberof ExpiringBaseGrantModel
     */
    readonly pk: number;
    /**
     * 
     * @type {OAuth2Provider}
     * @memberof ExpiringBaseGrantModel
     */
    provider: OAuth2Provider;
    /**
     * 
     * @type {User}
     * @memberof ExpiringBaseGrantModel
     */
    user: User;
    /**
     * Check if token is expired yet.
     * @type {boolean}
     * @memberof ExpiringBaseGrantModel
     */
    readonly isExpired: boolean;
    /**
     * 
     * @type {Date}
     * @memberof ExpiringBaseGrantModel
     */
    expires?: Date | null;
    /**
     * 
     * @type {Array<string>}
     * @memberof ExpiringBaseGrantModel
     */
    scope: Array<string>;
}

/**
 * Check if a given object implements the ExpiringBaseGrantModel interface.
 */
export function instanceOfExpiringBaseGrantModel(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "pk" in value;
    isInstance = isInstance && "provider" in value;
    isInstance = isInstance && "user" in value;
    isInstance = isInstance && "isExpired" in value;
    isInstance = isInstance && "scope" in value;

    return isInstance;
}

export function ExpiringBaseGrantModelFromJSON(json: any): ExpiringBaseGrantModel {
    return ExpiringBaseGrantModelFromJSONTyped(json, false);
}

export function ExpiringBaseGrantModelFromJSONTyped(json: any, ignoreDiscriminator: boolean): ExpiringBaseGrantModel {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'pk': json['pk'],
        'provider': OAuth2ProviderFromJSON(json['provider']),
        'user': UserFromJSON(json['user']),
        'isExpired': json['is_expired'],
        'expires': !exists(json, 'expires') ? undefined : (json['expires'] === null ? null : new Date(json['expires'])),
        'scope': json['scope'],
    };
}

export function ExpiringBaseGrantModelToJSON(value?: ExpiringBaseGrantModel | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'provider': OAuth2ProviderToJSON(value.provider),
        'user': UserToJSON(value.user),
        'expires': value.expires === undefined ? undefined : (value.expires === null ? null : value.expires.toISOString()),
        'scope': value.scope,
    };
}

