/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { BindingTypeEnum } from './BindingTypeEnum';
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import type { NameIdPolicyEnum } from './NameIdPolicyEnum';
import type { PolicyEngineMode } from './PolicyEngineMode';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import type { UserMatchingModeEnum } from './UserMatchingModeEnum';
/**
 * SAMLSource Serializer
 * @export
 * @interface SAMLSourceRequest
 */
export interface SAMLSourceRequest {
    /**
     * Source's display Name.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    name: string;
    /**
     * Internal source name, used in URLs.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    slug: string;
    /**
     *
     * @type {boolean}
     * @memberof SAMLSourceRequest
     */
    enabled?: boolean;
    /**
     * Flow to use when authenticating existing users.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    authenticationFlow?: string | null;
    /**
     * Flow to use when enrolling new users.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    enrollmentFlow?: string | null;
    /**
     *
     * @type {PolicyEngineMode}
     * @memberof SAMLSourceRequest
     */
    policyEngineMode?: PolicyEngineMode;
    /**
     *
     * @type {UserMatchingModeEnum}
     * @memberof SAMLSourceRequest
     */
    userMatchingMode?: UserMatchingModeEnum;
    /**
     *
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    userPathTemplate?: string;
    /**
     * Flow used before authentication.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    preAuthenticationFlow: string;
    /**
     * Also known as Entity ID. Defaults the Metadata URL.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    issuer?: string;
    /**
     * URL that the initial Login request is sent to.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    ssoUrl: string;
    /**
     * Optional URL if your IDP supports Single-Logout.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    sloUrl?: string | null;
    /**
     * Allows authentication flows initiated by the IdP. This can be a security risk, as no validation of the request ID is done.
     * @type {boolean}
     * @memberof SAMLSourceRequest
     */
    allowIdpInitiated?: boolean;
    /**
     *
     * @type {NameIdPolicyEnum}
     * @memberof SAMLSourceRequest
     */
    nameIdPolicy?: NameIdPolicyEnum;
    /**
     *
     * @type {BindingTypeEnum}
     * @memberof SAMLSourceRequest
     */
    bindingType?: BindingTypeEnum;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    verificationKp?: string | null;
    /**
     * Keypair used to sign outgoing Responses going to the Identity Provider.
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    signingKp?: string | null;
    /**
     *
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLSourceRequest
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     *
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLSourceRequest
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Time offset when temporary users should be deleted. This only applies if your IDP uses the NameID Format 'transient', and the user doesn't log out manually. (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLSourceRequest
     */
    temporaryUserDeleteAfter?: string;
}
/**
 * Check if a given object implements the SAMLSourceRequest interface.
 */
export declare function instanceOfSAMLSourceRequest(value: object): boolean;
export declare function SAMLSourceRequestFromJSON(json: any): SAMLSourceRequest;
export declare function SAMLSourceRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLSourceRequest;
export declare function SAMLSourceRequestToJSON(value?: SAMLSourceRequest | null): any;
