/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime';
import type { Application, ApplicationRequest, AuthenticatedSession, Brand, BrandRequest, Coordinate, CurrentBrand, FilePathRequest, Group, GroupRequest, Link, PaginatedApplicationList, PaginatedAuthenticatedSessionList, PaginatedBrandList, PaginatedGroupList, PaginatedTokenList, PaginatedUserConsentList, PaginatedUserList, PatchedApplicationRequest, PatchedBrandRequest, PatchedGroupRequest, PatchedTokenRequest, PatchedUserRequest, PolicyTestResult, SessionUser, Token, TokenRequest, TokenSetKeyRequest, TokenView, TransactionApplicationRequest, TransactionApplicationResponse, UsedBy, User, UserAccountRequest, UserConsent, UserMetrics, UserPasswordSetRequest, UserPath, UserRequest, UserServiceAccountRequest, UserServiceAccountResponse } from '../models';
export interface CoreApplicationsCheckAccessRetrieveRequest {
    slug: string;
    forUser?: number;
}
export interface CoreApplicationsCreateRequest {
    applicationRequest: ApplicationRequest;
}
export interface CoreApplicationsDestroyRequest {
    slug: string;
}
export interface CoreApplicationsListRequest {
    forUser?: number;
    group?: string;
    metaDescription?: string;
    metaLaunchUrl?: string;
    metaPublisher?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    slug?: string;
    superuserFullList?: boolean;
}
export interface CoreApplicationsMetricsListRequest {
    slug: string;
}
export interface CoreApplicationsPartialUpdateRequest {
    slug: string;
    patchedApplicationRequest?: PatchedApplicationRequest;
}
export interface CoreApplicationsRetrieveRequest {
    slug: string;
}
export interface CoreApplicationsSetIconCreateRequest {
    slug: string;
    file?: Blob;
    clear?: boolean;
}
export interface CoreApplicationsSetIconUrlCreateRequest {
    slug: string;
    filePathRequest: FilePathRequest;
}
export interface CoreApplicationsUpdateRequest {
    slug: string;
    applicationRequest: ApplicationRequest;
}
export interface CoreApplicationsUsedByListRequest {
    slug: string;
}
export interface CoreAuthenticatedSessionsDestroyRequest {
    uuid: string;
}
export interface CoreAuthenticatedSessionsListRequest {
    lastIp?: string;
    lastUserAgent?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    userUsername?: string;
}
export interface CoreAuthenticatedSessionsRetrieveRequest {
    uuid: string;
}
export interface CoreAuthenticatedSessionsUsedByListRequest {
    uuid: string;
}
export interface CoreBrandsCreateRequest {
    brandRequest: BrandRequest;
}
export interface CoreBrandsDestroyRequest {
    brandUuid: string;
}
export interface CoreBrandsListRequest {
    brandUuid?: string;
    brandingFavicon?: string;
    brandingLogo?: string;
    brandingTitle?: string;
    _default?: boolean;
    domain?: string;
    flowAuthentication?: string;
    flowDeviceCode?: string;
    flowInvalidation?: string;
    flowRecovery?: string;
    flowUnenrollment?: string;
    flowUserSettings?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    webCertificate?: string;
}
export interface CoreBrandsPartialUpdateRequest {
    brandUuid: string;
    patchedBrandRequest?: PatchedBrandRequest;
}
export interface CoreBrandsRetrieveRequest {
    brandUuid: string;
}
export interface CoreBrandsUpdateRequest {
    brandUuid: string;
    brandRequest: BrandRequest;
}
export interface CoreBrandsUsedByListRequest {
    brandUuid: string;
}
export interface CoreGroupsAddUserCreateRequest {
    groupUuid: string;
    userAccountRequest: UserAccountRequest;
}
export interface CoreGroupsCreateRequest {
    groupRequest: GroupRequest;
}
export interface CoreGroupsDestroyRequest {
    groupUuid: string;
}
export interface CoreGroupsListRequest {
    attributes?: string;
    includeUsers?: boolean;
    isSuperuser?: boolean;
    membersByPk?: Array<number>;
    membersByUsername?: Array<string>;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}
export interface CoreGroupsPartialUpdateRequest {
    groupUuid: string;
    patchedGroupRequest?: PatchedGroupRequest;
}
export interface CoreGroupsRemoveUserCreateRequest {
    groupUuid: string;
    userAccountRequest: UserAccountRequest;
}
export interface CoreGroupsRetrieveRequest {
    groupUuid: string;
    includeUsers?: boolean;
}
export interface CoreGroupsUpdateRequest {
    groupUuid: string;
    groupRequest: GroupRequest;
}
export interface CoreGroupsUsedByListRequest {
    groupUuid: string;
}
export interface CoreTokensCreateRequest {
    tokenRequest: TokenRequest;
}
export interface CoreTokensDestroyRequest {
    identifier: string;
}
export interface CoreTokensListRequest {
    description?: string;
    expires?: Date;
    expiring?: boolean;
    identifier?: string;
    intent?: CoreTokensListIntentEnum;
    managed?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    userUsername?: string;
}
export interface CoreTokensPartialUpdateRequest {
    identifier: string;
    patchedTokenRequest?: PatchedTokenRequest;
}
export interface CoreTokensRetrieveRequest {
    identifier: string;
}
export interface CoreTokensSetKeyCreateRequest {
    identifier: string;
    tokenSetKeyRequest: TokenSetKeyRequest;
}
export interface CoreTokensUpdateRequest {
    identifier: string;
    tokenRequest: TokenRequest;
}
export interface CoreTokensUsedByListRequest {
    identifier: string;
}
export interface CoreTokensViewKeyRetrieveRequest {
    identifier: string;
}
export interface CoreTransactionalApplicationsUpdateRequest {
    transactionApplicationRequest: TransactionApplicationRequest;
}
export interface CoreUserConsentDestroyRequest {
    id: number;
}
export interface CoreUserConsentListRequest {
    application?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    user?: number;
}
export interface CoreUserConsentRetrieveRequest {
    id: number;
}
export interface CoreUserConsentUsedByListRequest {
    id: number;
}
export interface CoreUsersCreateRequest {
    userRequest: UserRequest;
}
export interface CoreUsersDestroyRequest {
    id: number;
}
export interface CoreUsersImpersonateCreateRequest {
    id: number;
}
export interface CoreUsersListRequest {
    attributes?: string;
    email?: string;
    groupsByName?: Array<string>;
    groupsByPk?: Array<string>;
    includeGroups?: boolean;
    isActive?: boolean;
    isSuperuser?: boolean;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    path?: string;
    pathStartswith?: string;
    search?: string;
    type?: Array<CoreUsersListTypeEnum>;
    username?: string;
    uuid?: string;
}
export interface CoreUsersMetricsRetrieveRequest {
    id: number;
}
export interface CoreUsersPartialUpdateRequest {
    id: number;
    patchedUserRequest?: PatchedUserRequest;
}
export interface CoreUsersPathsRetrieveRequest {
    search?: string;
}
export interface CoreUsersRecoveryCreateRequest {
    id: number;
}
export interface CoreUsersRecoveryEmailCreateRequest {
    emailStage: string;
    id: number;
}
export interface CoreUsersRetrieveRequest {
    id: number;
}
export interface CoreUsersServiceAccountCreateRequest {
    userServiceAccountRequest: UserServiceAccountRequest;
}
export interface CoreUsersSetPasswordCreateRequest {
    id: number;
    userPasswordSetRequest: UserPasswordSetRequest;
}
export interface CoreUsersUpdateRequest {
    id: number;
    userRequest: UserRequest;
}
export interface CoreUsersUsedByListRequest {
    id: number;
}
/**
 *
 */
export declare class CoreApi extends runtime.BaseAPI {
    /**
     * Check access to a single application by slug
     */
    coreApplicationsCheckAccessRetrieveRaw(requestParameters: CoreApplicationsCheckAccessRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PolicyTestResult>>;
    /**
     * Check access to a single application by slug
     */
    coreApplicationsCheckAccessRetrieve(requestParameters: CoreApplicationsCheckAccessRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PolicyTestResult>;
    /**
     * Application Viewset
     */
    coreApplicationsCreateRaw(requestParameters: CoreApplicationsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>>;
    /**
     * Application Viewset
     */
    coreApplicationsCreate(requestParameters: CoreApplicationsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application>;
    /**
     * Application Viewset
     */
    coreApplicationsDestroyRaw(requestParameters: CoreApplicationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Application Viewset
     */
    coreApplicationsDestroy(requestParameters: CoreApplicationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    coreApplicationsListRaw(requestParameters: CoreApplicationsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedApplicationList>>;
    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    coreApplicationsList(requestParameters?: CoreApplicationsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedApplicationList>;
    /**
     * Metrics for application logins
     */
    coreApplicationsMetricsListRaw(requestParameters: CoreApplicationsMetricsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Coordinate>>>;
    /**
     * Metrics for application logins
     */
    coreApplicationsMetricsList(requestParameters: CoreApplicationsMetricsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Coordinate>>;
    /**
     * Application Viewset
     */
    coreApplicationsPartialUpdateRaw(requestParameters: CoreApplicationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>>;
    /**
     * Application Viewset
     */
    coreApplicationsPartialUpdate(requestParameters: CoreApplicationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application>;
    /**
     * Application Viewset
     */
    coreApplicationsRetrieveRaw(requestParameters: CoreApplicationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>>;
    /**
     * Application Viewset
     */
    coreApplicationsRetrieve(requestParameters: CoreApplicationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application>;
    /**
     * Set application icon
     */
    coreApplicationsSetIconCreateRaw(requestParameters: CoreApplicationsSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set application icon
     */
    coreApplicationsSetIconCreate(requestParameters: CoreApplicationsSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Set application icon (as URL)
     */
    coreApplicationsSetIconUrlCreateRaw(requestParameters: CoreApplicationsSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set application icon (as URL)
     */
    coreApplicationsSetIconUrlCreate(requestParameters: CoreApplicationsSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Application Viewset
     */
    coreApplicationsUpdateRaw(requestParameters: CoreApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>>;
    /**
     * Application Viewset
     */
    coreApplicationsUpdate(requestParameters: CoreApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application>;
    /**
     * Get a list of all objects that use this object
     */
    coreApplicationsUsedByListRaw(requestParameters: CoreApplicationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreApplicationsUsedByList(requestParameters: CoreApplicationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsDestroyRaw(requestParameters: CoreAuthenticatedSessionsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsDestroy(requestParameters: CoreAuthenticatedSessionsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsListRaw(requestParameters: CoreAuthenticatedSessionsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedAuthenticatedSessionList>>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsList(requestParameters?: CoreAuthenticatedSessionsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedAuthenticatedSessionList>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsRetrieveRaw(requestParameters: CoreAuthenticatedSessionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthenticatedSession>>;
    /**
     * AuthenticatedSession Viewset
     */
    coreAuthenticatedSessionsRetrieve(requestParameters: CoreAuthenticatedSessionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthenticatedSession>;
    /**
     * Get a list of all objects that use this object
     */
    coreAuthenticatedSessionsUsedByListRaw(requestParameters: CoreAuthenticatedSessionsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreAuthenticatedSessionsUsedByList(requestParameters: CoreAuthenticatedSessionsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Brand Viewset
     */
    coreBrandsCreateRaw(requestParameters: CoreBrandsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>>;
    /**
     * Brand Viewset
     */
    coreBrandsCreate(requestParameters: CoreBrandsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand>;
    /**
     * Get current brand
     */
    coreBrandsCurrentRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CurrentBrand>>;
    /**
     * Get current brand
     */
    coreBrandsCurrentRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CurrentBrand>;
    /**
     * Brand Viewset
     */
    coreBrandsDestroyRaw(requestParameters: CoreBrandsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Brand Viewset
     */
    coreBrandsDestroy(requestParameters: CoreBrandsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Brand Viewset
     */
    coreBrandsListRaw(requestParameters: CoreBrandsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedBrandList>>;
    /**
     * Brand Viewset
     */
    coreBrandsList(requestParameters?: CoreBrandsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedBrandList>;
    /**
     * Brand Viewset
     */
    coreBrandsPartialUpdateRaw(requestParameters: CoreBrandsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>>;
    /**
     * Brand Viewset
     */
    coreBrandsPartialUpdate(requestParameters: CoreBrandsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand>;
    /**
     * Brand Viewset
     */
    coreBrandsRetrieveRaw(requestParameters: CoreBrandsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>>;
    /**
     * Brand Viewset
     */
    coreBrandsRetrieve(requestParameters: CoreBrandsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand>;
    /**
     * Brand Viewset
     */
    coreBrandsUpdateRaw(requestParameters: CoreBrandsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>>;
    /**
     * Brand Viewset
     */
    coreBrandsUpdate(requestParameters: CoreBrandsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand>;
    /**
     * Get a list of all objects that use this object
     */
    coreBrandsUsedByListRaw(requestParameters: CoreBrandsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreBrandsUsedByList(requestParameters: CoreBrandsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Add user to group
     */
    coreGroupsAddUserCreateRaw(requestParameters: CoreGroupsAddUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Add user to group
     */
    coreGroupsAddUserCreate(requestParameters: CoreGroupsAddUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Group Viewset
     */
    coreGroupsCreateRaw(requestParameters: CoreGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>>;
    /**
     * Group Viewset
     */
    coreGroupsCreate(requestParameters: CoreGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group>;
    /**
     * Group Viewset
     */
    coreGroupsDestroyRaw(requestParameters: CoreGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Group Viewset
     */
    coreGroupsDestroy(requestParameters: CoreGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Group Viewset
     */
    coreGroupsListRaw(requestParameters: CoreGroupsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedGroupList>>;
    /**
     * Group Viewset
     */
    coreGroupsList(requestParameters?: CoreGroupsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedGroupList>;
    /**
     * Group Viewset
     */
    coreGroupsPartialUpdateRaw(requestParameters: CoreGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>>;
    /**
     * Group Viewset
     */
    coreGroupsPartialUpdate(requestParameters: CoreGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group>;
    /**
     * Add user to group
     */
    coreGroupsRemoveUserCreateRaw(requestParameters: CoreGroupsRemoveUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Add user to group
     */
    coreGroupsRemoveUserCreate(requestParameters: CoreGroupsRemoveUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Group Viewset
     */
    coreGroupsRetrieveRaw(requestParameters: CoreGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>>;
    /**
     * Group Viewset
     */
    coreGroupsRetrieve(requestParameters: CoreGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group>;
    /**
     * Group Viewset
     */
    coreGroupsUpdateRaw(requestParameters: CoreGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>>;
    /**
     * Group Viewset
     */
    coreGroupsUpdate(requestParameters: CoreGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group>;
    /**
     * Get a list of all objects that use this object
     */
    coreGroupsUsedByListRaw(requestParameters: CoreGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreGroupsUsedByList(requestParameters: CoreGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Token Viewset
     */
    coreTokensCreateRaw(requestParameters: CoreTokensCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>>;
    /**
     * Token Viewset
     */
    coreTokensCreate(requestParameters: CoreTokensCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token>;
    /**
     * Token Viewset
     */
    coreTokensDestroyRaw(requestParameters: CoreTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Token Viewset
     */
    coreTokensDestroy(requestParameters: CoreTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Token Viewset
     */
    coreTokensListRaw(requestParameters: CoreTokensListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedTokenList>>;
    /**
     * Token Viewset
     */
    coreTokensList(requestParameters?: CoreTokensListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedTokenList>;
    /**
     * Token Viewset
     */
    coreTokensPartialUpdateRaw(requestParameters: CoreTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>>;
    /**
     * Token Viewset
     */
    coreTokensPartialUpdate(requestParameters: CoreTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token>;
    /**
     * Token Viewset
     */
    coreTokensRetrieveRaw(requestParameters: CoreTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>>;
    /**
     * Token Viewset
     */
    coreTokensRetrieve(requestParameters: CoreTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token>;
    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    coreTokensSetKeyCreateRaw(requestParameters: CoreTokensSetKeyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    coreTokensSetKeyCreate(requestParameters: CoreTokensSetKeyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Token Viewset
     */
    coreTokensUpdateRaw(requestParameters: CoreTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>>;
    /**
     * Token Viewset
     */
    coreTokensUpdate(requestParameters: CoreTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token>;
    /**
     * Get a list of all objects that use this object
     */
    coreTokensUsedByListRaw(requestParameters: CoreTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreTokensUsedByList(requestParameters: CoreTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * Return token key and log access
     */
    coreTokensViewKeyRetrieveRaw(requestParameters: CoreTokensViewKeyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TokenView>>;
    /**
     * Return token key and log access
     */
    coreTokensViewKeyRetrieve(requestParameters: CoreTokensViewKeyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TokenView>;
    /**
     * Convert data into a blueprint, validate it and apply it
     */
    coreTransactionalApplicationsUpdateRaw(requestParameters: CoreTransactionalApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TransactionApplicationResponse>>;
    /**
     * Convert data into a blueprint, validate it and apply it
     */
    coreTransactionalApplicationsUpdate(requestParameters: CoreTransactionalApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TransactionApplicationResponse>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentDestroyRaw(requestParameters: CoreUserConsentDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentDestroy(requestParameters: CoreUserConsentDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentListRaw(requestParameters: CoreUserConsentListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserConsentList>>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentList(requestParameters?: CoreUserConsentListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserConsentList>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentRetrieveRaw(requestParameters: CoreUserConsentRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserConsent>>;
    /**
     * UserConsent Viewset
     */
    coreUserConsentRetrieve(requestParameters: CoreUserConsentRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserConsent>;
    /**
     * Get a list of all objects that use this object
     */
    coreUserConsentUsedByListRaw(requestParameters: CoreUserConsentUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreUserConsentUsedByList(requestParameters: CoreUserConsentUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
    /**
     * User Viewset
     */
    coreUsersCreateRaw(requestParameters: CoreUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>>;
    /**
     * User Viewset
     */
    coreUsersCreate(requestParameters: CoreUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User>;
    /**
     * User Viewset
     */
    coreUsersDestroyRaw(requestParameters: CoreUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * User Viewset
     */
    coreUsersDestroy(requestParameters: CoreUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * Impersonate a user
     */
    coreUsersImpersonateCreateRaw(requestParameters: CoreUsersImpersonateCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Impersonate a user
     */
    coreUsersImpersonateCreate(requestParameters: CoreUsersImpersonateCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * End Impersonation a user
     */
    coreUsersImpersonateEndRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * End Impersonation a user
     */
    coreUsersImpersonateEndRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * User Viewset
     */
    coreUsersListRaw(requestParameters: CoreUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserList>>;
    /**
     * User Viewset
     */
    coreUsersList(requestParameters?: CoreUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserList>;
    /**
     * Get information about current user
     */
    coreUsersMeRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionUser>>;
    /**
     * Get information about current user
     */
    coreUsersMeRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionUser>;
    /**
     * User metrics per 1h
     */
    coreUsersMetricsRetrieveRaw(requestParameters: CoreUsersMetricsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserMetrics>>;
    /**
     * User metrics per 1h
     */
    coreUsersMetricsRetrieve(requestParameters: CoreUsersMetricsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserMetrics>;
    /**
     * User Viewset
     */
    coreUsersPartialUpdateRaw(requestParameters: CoreUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>>;
    /**
     * User Viewset
     */
    coreUsersPartialUpdate(requestParameters: CoreUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User>;
    /**
     * Get all user paths
     */
    coreUsersPathsRetrieveRaw(requestParameters: CoreUsersPathsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserPath>>;
    /**
     * Get all user paths
     */
    coreUsersPathsRetrieve(requestParameters?: CoreUsersPathsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserPath>;
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryCreateRaw(requestParameters: CoreUsersRecoveryCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Link>>;
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryCreate(requestParameters: CoreUsersRecoveryCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Link>;
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryEmailCreateRaw(requestParameters: CoreUsersRecoveryEmailCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    coreUsersRecoveryEmailCreate(requestParameters: CoreUsersRecoveryEmailCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * User Viewset
     */
    coreUsersRetrieveRaw(requestParameters: CoreUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>>;
    /**
     * User Viewset
     */
    coreUsersRetrieve(requestParameters: CoreUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User>;
    /**
     * Create a new user account that is marked as a service account
     */
    coreUsersServiceAccountCreateRaw(requestParameters: CoreUsersServiceAccountCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserServiceAccountResponse>>;
    /**
     * Create a new user account that is marked as a service account
     */
    coreUsersServiceAccountCreate(requestParameters: CoreUsersServiceAccountCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserServiceAccountResponse>;
    /**
     * Set password for user
     */
    coreUsersSetPasswordCreateRaw(requestParameters: CoreUsersSetPasswordCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;
    /**
     * Set password for user
     */
    coreUsersSetPasswordCreate(requestParameters: CoreUsersSetPasswordCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;
    /**
     * User Viewset
     */
    coreUsersUpdateRaw(requestParameters: CoreUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>>;
    /**
     * User Viewset
     */
    coreUsersUpdate(requestParameters: CoreUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User>;
    /**
     * Get a list of all objects that use this object
     */
    coreUsersUsedByListRaw(requestParameters: CoreUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>>;
    /**
     * Get a list of all objects that use this object
     */
    coreUsersUsedByList(requestParameters: CoreUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>>;
}
/**
 * @export
 */
export declare const CoreTokensListIntentEnum: {
    readonly Api: "api";
    readonly AppPassword: "app_password";
    readonly Recovery: "recovery";
    readonly Verification: "verification";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type CoreTokensListIntentEnum = typeof CoreTokensListIntentEnum[keyof typeof CoreTokensListIntentEnum];
/**
 * @export
 */
export declare const CoreUsersListTypeEnum: {
    readonly External: "external";
    readonly Internal: "internal";
    readonly InternalServiceAccount: "internal_service_account";
    readonly ServiceAccount: "service_account";
    readonly UnknownDefaultOpenApi: "11184809";
};
export type CoreUsersListTypeEnum = typeof CoreUsersListTypeEnum[keyof typeof CoreUsersListTypeEnum];
