/**
 * @file Prettier configuration for authentik.
 *
 * @import { Config as PrettierConfig } from "prettier";
 * @import { PluginConfig as SortPluginConfig } from "@trivago/prettier-plugin-sort-imports";
 *
 * @typedef {object} PackageJSONPluginConfig
 * @property {string[]} [packageSortOrder] Custom ordering array.
 */
/**
 * authentik Prettier configuration.
 *
 * @type {PrettierConfig & SortPluginConfig & PackageJSONPluginConfig}
 * @internal
 */
export const AuthentikPrettierConfig: PrettierConfig & SortPluginConfig & PackageJSONPluginConfig;
export type PackageJSONPluginConfig = {
    /**
     * Custom ordering array.
     */
    packageSortOrder?: string[] | undefined;
};
import type { Config as PrettierConfig } from "prettier";
import type { PluginConfig as SortPluginConfig } from "@trivago/prettier-plugin-sort-imports";
//# sourceMappingURL=constants.d.ts.map