{"content":"```yaml\nservices:\n    traefik:\n        image: traefik:v3.0\n        container_name: traefik\n        volumes:\n            - /var/run/docker.sock:/var/run/docker.sock\n        ports:\n            - 80:80\n        command:\n            - \"--api\"\n            - \"--providers.docker=true\"\n            - \"--providers.docker.exposedByDefault=false\"\n            - \"--entrypoints.web.address=:80\"\n\n    authentik-proxy:\n        image: ghcr.io/goauthentik/proxy\n        ports:\n            - 9000:9000\n            - 9443:9443\n        environment:\n            AUTHENTIK_HOST: https://your-authentik.tld\n            AUTHENTIK_INSECURE: \"false\"\n            AUTHENTIK_TOKEN: token-generated-by-authentik\n            # Starting with 2021.9, you can optionally set this too\n            # when authentik_host for internal communication doesn't match the public URL\n            # AUTHENTIK_HOST_BROWSER: https://external-domain.tld\n        labels:\n            traefik.enable: true\n            traefik.port: 9000\n            traefik.http.routers.authentik.rule: Host(`app.company`) && PathPrefix(`/outpost.goauthentik.io/`)\n            # `authentik-proxy` refers to the service name in the compose file.\n            traefik.http.middlewares.authentik.forwardauth.address: http://authentik-proxy:9000/outpost.goauthentik.io/auth/traefik\n            traefik.http.middlewares.authentik.forwardauth.trustForwardHeader: true\n            traefik.http.middlewares.authentik.forwardauth.authResponseHeaders: X-authentik-username,X-authentik-groups,X-authentik-entitlements,X-authentik-email,X-authentik-name,X-authentik-uid,X-authentik-jwt,X-authentik-meta-jwks,X-authentik-meta-outpost,X-authentik-meta-provider,X-authentik-meta-app,X-authentik-meta-version\n        restart: unless-stopped\n\n    whoami:\n        image: containous/whoami\n        labels:\n            traefik.enable: true\n            traefik.http.routers.whoami.rule: Host(`app.company`)\n            traefik.http.routers.whoami.middlewares: authentik@docker\n        restart: unless-stopped\n```\n","publicPath":"/add-secure-apps/providers/proxy/_traefik_compose.md","publicDirectory":"/add-secure-apps/providers/proxy"}