{"content":"```nginx\n# Upgrade WebSocket if requested, otherwise use keepalive\nmap $http_upgrade $connection_upgrade_keepalive {\n    default upgrade;\n    ''      '';\n}\n\nserver {\n    # SSL and VHost configuration\n    listen                  443 ssl http2;\n    server_name             _;\n\n    ssl_certificate         /etc/ssl/certs/ssl-cert-snakeoil.pem;\n    ssl_certificate_key     /etc/ssl/private/ssl-cert-snakeoil.key;\n\n    # Increase buffer size for large headers\n    # This is needed only if you get 'upstream sent too big header while reading response\n    # header from upstream' error when trying to access an application protected by goauthentik\n    proxy_buffers 8 16k;\n    proxy_buffer_size 32k;\n\n    location / {\n        # Put your proxy_pass to your application here, and all the other statements you'll need\n        # proxy_pass http://localhost:5000;\n        # proxy_set_header Host $host;\n        # proxy_set_header ...\n        # Support for websocket\n        proxy_set_header Upgrade $http_upgrade;\n        proxy_set_header Connection $connection_upgrade_keepalive;\n\n        ##############################\n        # authentik-specific config\n        ##############################\n        auth_request     /outpost.goauthentik.io/auth/nginx;\n        error_page       401 = @goauthentik_proxy_signin;\n        auth_request_set $auth_cookie $upstream_http_set_cookie;\n        add_header       Set-Cookie $auth_cookie;\n\n        # translate headers from the outposts back to the actual upstream\n        auth_request_set $authentik_username $upstream_http_x_authentik_username;\n        auth_request_set $authentik_groups $upstream_http_x_authentik_groups;\n        auth_request_set $authentik_entitlements $upstream_http_x_authentik_entitlements;\n        auth_request_set $authentik_email $upstream_http_x_authentik_email;\n        auth_request_set $authentik_name $upstream_http_x_authentik_name;\n        auth_request_set $authentik_uid $upstream_http_x_authentik_uid;\n\n        proxy_set_header X-authentik-username $authentik_username;\n        proxy_set_header X-authentik-groups $authentik_groups;\n        proxy_set_header X-authentik-entitlements $authentik_entitlements;\n        proxy_set_header X-authentik-email $authentik_email;\n        proxy_set_header X-authentik-name $authentik_name;\n        proxy_set_header X-authentik-uid $authentik_uid;\n\n        # This section should be uncommented when the \"Send HTTP Basic authentication\" option\n        # is enabled in the proxy provider\n        # auth_request_set $authentik_auth $upstream_http_authorization;\n        # proxy_set_header Authorization $authentik_auth;\n    }\n\n    # all requests to /outpost.goauthentik.io must be accessible without authentication\n    location /outpost.goauthentik.io {\n        # When using the embedded outpost, use:\n        proxy_pass              http://authentik.company:9000/outpost.goauthentik.io;\n        # For manual outpost deployments:\n        # proxy_pass              http://outpost.company:9000;\n\n        # Note: ensure the Host header matches your external authentik URL:\n        proxy_set_header        Host $host;\n\n        proxy_set_header        X-Original-URL $scheme://$http_host$request_uri;\n        add_header              Set-Cookie $auth_cookie;\n        auth_request_set        $auth_cookie $upstream_http_set_cookie;\n        proxy_pass_request_body off;\n        proxy_set_header        Content-Length \"\";\n    }\n\n    # Special location for when the /auth endpoint returns a 401,\n    # redirect to the /start URL which initiates SSO\n    location @goauthentik_proxy_signin {\n        internal;\n        add_header Set-Cookie $auth_cookie;\n        return 302 /outpost.goauthentik.io/start?rd=$scheme://$http_host$request_uri;\n        # For domain level, use the below error_page to redirect to your authentik server with the full redirect path\n        # return 302 https://authentik.company/outpost.goauthentik.io/start?rd=$scheme://$http_host$request_uri;\n    }\n}\n```\n","publicPath":"/add-secure-apps/providers/proxy/_nginx_standalone.md","publicDirectory":"/add-secure-apps/providers/proxy"}