{"content":"Create a new ingress for the outpost\n\n```yaml\napiVersion: networking.k8s.io/v1\nkind: Ingress\nmetadata:\n    name: authentik-outpost\nspec:\n    rules:\n        - host: app.company\n          http:\n              paths:\n                  - path: /outpost.goauthentik.io\n                    pathType: Prefix\n                    backend:\n                        # Or, to use an external Outpost, create an ExternalName service and reference that here.\n                        # See https://kubernetes.io/docs/concepts/services-networking/service/#externalname\n                        service:\n                            name: ak-outpost-example-outpost\n                            port:\n                                number: 9000\n```\n\nThis ingress handles authentication requests, and the sign-in flow.\n\nAdd these annotations to the ingress you want to protect\n\n:::warning\nThis configuration requires that you enable [`allow-snippet-annotations`](https://kubernetes.github.io/ingress-nginx/user-guide/nginx-configuration/configmap/#allow-snippet-annotations), for example by setting `controller.allowSnippetAnnotations` to `true` in your helm values for the ingress-nginx installation.\n:::\n\n```yaml\nmetadata:\n    annotations:\n        # This should be the in-cluster DNS name for the authentik outpost service\n        # as when the external URL is specified here, nginx will overwrite some crucial headers\n        nginx.ingress.kubernetes.io/auth-url: |-\n            http://ak-outpost-example.authentik.svc.cluster.local:9000/outpost.goauthentik.io/auth/nginx\n        # If you're using domain-level auth, use the authentication URL instead of the application URL\n        nginx.ingress.kubernetes.io/auth-signin: |-\n            https://app.company/outpost.goauthentik.io/start?rd=$scheme://$http_host$escaped_request_uri\n        nginx.ingress.kubernetes.io/auth-response-headers: |-\n            Set-Cookie,X-authentik-username,X-authentik-groups,X-authentik-entitlements,X-authentik-email,X-authentik-name,X-authentik-uid\n        nginx.ingress.kubernetes.io/auth-snippet: |\n            proxy_set_header X-Forwarded-Host $http_host;\n```\n","publicPath":"/add-secure-apps/providers/proxy/_nginx_ingress.md","publicDirectory":"/add-secure-apps/providers/proxy"}