r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Video
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from datetime import datetime
from typing import Any, Dict, List, Optional, Union, Iterator, AsyncIterator
from twilio.base import deserialize, serialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version
from twilio.base.page import Page


class TranscriptionsInstance(InstanceResource):

    class Status(object):
        STARTED = "started"
        STOPPED = "stopped"
        FAILED = "failed"

    """
    :ivar ttid: The unique string that we created to identify the transcriptions resource.
    :ivar account_sid: The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Room resource.
    :ivar room_sid: The SID of the transcriptions's room.
    :ivar status: 
    :ivar date_created: The date and time in GMT when the resource was created specified in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    :ivar date_updated: The date and time in GMT when the resource was last updated specified in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    :ivar start_time: The time of transcriptions connected to the room in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#UTC) format.
    :ivar end_time: The time when the transcriptions disconnected from the room in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#UTC) format.
    :ivar duration: The duration in seconds that the transcriptions were `connected`. Populated only after the transcriptions is `stopped`.
    :ivar url: The absolute URL of the resource.
    :ivar configuration: An JSON object that describes the video layout of the composition in terms of regions. See [Specifying Video Layouts](https://www.twilio.com/docs/video/api/compositions-resource#specifying-video-layouts) for more info.
    """

    def __init__(
        self,
        version: Version,
        payload: Dict[str, Any],
        room_sid: str,
        ttid: Optional[str] = None,
    ):
        super().__init__(version)

        self.ttid: Optional[str] = payload.get("ttid")
        self.account_sid: Optional[str] = payload.get("account_sid")
        self.room_sid: Optional[str] = payload.get("room_sid")
        self.status: Optional["TranscriptionsInstance.Status"] = payload.get("status")
        self.date_created: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_created")
        )
        self.date_updated: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_updated")
        )
        self.start_time: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("start_time")
        )
        self.end_time: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("end_time")
        )
        self.duration: Optional[int] = deserialize.integer(payload.get("duration"))
        self.url: Optional[str] = payload.get("url")
        self.configuration: Optional[Dict[str, object]] = payload.get("configuration")

        self._solution = {
            "room_sid": room_sid,
            "ttid": ttid or self.ttid,
        }
        self._context: Optional[TranscriptionsContext] = None

    @property
    def _proxy(self) -> "TranscriptionsContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: TranscriptionsContext for this TranscriptionsInstance
        """
        if self._context is None:
            self._context = TranscriptionsContext(
                self._version,
                room_sid=self._solution["room_sid"],
                ttid=self._solution["ttid"],
            )
        return self._context

    def fetch(self) -> "TranscriptionsInstance":
        """
        Fetch the TranscriptionsInstance


        :returns: The fetched TranscriptionsInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "TranscriptionsInstance":
        """
        Asynchronous coroutine to fetch the TranscriptionsInstance


        :returns: The fetched TranscriptionsInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self, status: Union["TranscriptionsInstance.Status", object] = values.unset
    ) -> "TranscriptionsInstance":
        """
        Update the TranscriptionsInstance

        :param status:

        :returns: The updated TranscriptionsInstance
        """
        return self._proxy.update(
            status=status,
        )

    async def update_async(
        self, status: Union["TranscriptionsInstance.Status", object] = values.unset
    ) -> "TranscriptionsInstance":
        """
        Asynchronous coroutine to update the TranscriptionsInstance

        :param status:

        :returns: The updated TranscriptionsInstance
        """
        return await self._proxy.update_async(
            status=status,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Video.V1.TranscriptionsInstance {}>".format(context)


class TranscriptionsContext(InstanceContext):

    def __init__(self, version: Version, room_sid: str, ttid: str):
        """
        Initialize the TranscriptionsContext

        :param version: Version that contains the resource
        :param room_sid: The SID of the room with the transcriptions resource to update.
        :param ttid: The Twilio type id of the transcriptions resource to update.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "room_sid": room_sid,
            "ttid": ttid,
        }
        self._uri = "/Rooms/{room_sid}/Transcriptions/{ttid}".format(**self._solution)

    def fetch(self) -> TranscriptionsInstance:
        """
        Fetch the TranscriptionsInstance


        :returns: The fetched TranscriptionsInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = self._version.fetch(method="GET", uri=self._uri, headers=headers)

        return TranscriptionsInstance(
            self._version,
            payload,
            room_sid=self._solution["room_sid"],
            ttid=self._solution["ttid"],
        )

    async def fetch_async(self) -> TranscriptionsInstance:
        """
        Asynchronous coroutine to fetch the TranscriptionsInstance


        :returns: The fetched TranscriptionsInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = await self._version.fetch_async(
            method="GET", uri=self._uri, headers=headers
        )

        return TranscriptionsInstance(
            self._version,
            payload,
            room_sid=self._solution["room_sid"],
            ttid=self._solution["ttid"],
        )

    def update(
        self, status: Union["TranscriptionsInstance.Status", object] = values.unset
    ) -> TranscriptionsInstance:
        """
        Update the TranscriptionsInstance

        :param status:

        :returns: The updated TranscriptionsInstance
        """

        data = values.of(
            {
                "Status": status,
            }
        )
        headers = values.of({})

        headers["Content-Type"] = "application/x-www-form-urlencoded"

        headers["Accept"] = "application/json"

        payload = self._version.update(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return TranscriptionsInstance(
            self._version,
            payload,
            room_sid=self._solution["room_sid"],
            ttid=self._solution["ttid"],
        )

    async def update_async(
        self, status: Union["TranscriptionsInstance.Status", object] = values.unset
    ) -> TranscriptionsInstance:
        """
        Asynchronous coroutine to update the TranscriptionsInstance

        :param status:

        :returns: The updated TranscriptionsInstance
        """

        data = values.of(
            {
                "Status": status,
            }
        )
        headers = values.of({})

        headers["Content-Type"] = "application/x-www-form-urlencoded"

        headers["Accept"] = "application/json"

        payload = await self._version.update_async(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return TranscriptionsInstance(
            self._version,
            payload,
            room_sid=self._solution["room_sid"],
            ttid=self._solution["ttid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Video.V1.TranscriptionsContext {}>".format(context)


class TranscriptionsPage(Page):

    def get_instance(self, payload: Dict[str, Any]) -> TranscriptionsInstance:
        """
        Build an instance of TranscriptionsInstance

        :param payload: Payload response from the API
        """
        return TranscriptionsInstance(
            self._version, payload, room_sid=self._solution["room_sid"]
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Video.V1.TranscriptionsPage>"


class TranscriptionsList(ListResource):

    def __init__(self, version: Version, room_sid: str):
        """
        Initialize the TranscriptionsList

        :param version: Version that contains the resource
        :param room_sid: The SID of the room with the transcriptions resources to read.

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "room_sid": room_sid,
        }
        self._uri = "/Rooms/{room_sid}/Transcriptions".format(**self._solution)

    def create(
        self, configuration: Union[object, object] = values.unset
    ) -> TranscriptionsInstance:
        """
        Create the TranscriptionsInstance

        :param configuration: A collection of properties that describe transcription behaviour.

        :returns: The created TranscriptionsInstance
        """

        data = values.of(
            {
                "Configuration": serialize.object(configuration),
            }
        )
        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Content-Type"] = "application/x-www-form-urlencoded"

        headers["Accept"] = "application/json"

        payload = self._version.create(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return TranscriptionsInstance(
            self._version, payload, room_sid=self._solution["room_sid"]
        )

    async def create_async(
        self, configuration: Union[object, object] = values.unset
    ) -> TranscriptionsInstance:
        """
        Asynchronously create the TranscriptionsInstance

        :param configuration: A collection of properties that describe transcription behaviour.

        :returns: The created TranscriptionsInstance
        """

        data = values.of(
            {
                "Configuration": serialize.object(configuration),
            }
        )
        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Content-Type"] = "application/x-www-form-urlencoded"

        headers["Accept"] = "application/json"

        payload = await self._version.create_async(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return TranscriptionsInstance(
            self._version, payload, room_sid=self._solution["room_sid"]
        )

    def stream(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> Iterator[TranscriptionsInstance]:
        """
        Streams TranscriptionsInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = self.page(page_size=limits["page_size"])

        return self._version.stream(page, limits["limit"])

    async def stream_async(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> AsyncIterator[TranscriptionsInstance]:
        """
        Asynchronously streams TranscriptionsInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = await self.page_async(page_size=limits["page_size"])

        return self._version.stream_async(page, limits["limit"])

    def list(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[TranscriptionsInstance]:
        """
        Lists TranscriptionsInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return list(
            self.stream(
                limit=limit,
                page_size=page_size,
            )
        )

    async def list_async(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[TranscriptionsInstance]:
        """
        Asynchronously lists TranscriptionsInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return [
            record
            async for record in await self.stream_async(
                limit=limit,
                page_size=page_size,
            )
        ]

    def page(
        self,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> TranscriptionsPage:
        """
        Retrieve a single page of TranscriptionsInstance records from the API.
        Request is executed immediately

        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of TranscriptionsInstance
        """
        data = values.of(
            {
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Accept"] = "application/json"

        response = self._version.page(
            method="GET", uri=self._uri, params=data, headers=headers
        )
        return TranscriptionsPage(self._version, response, self._solution)

    async def page_async(
        self,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> TranscriptionsPage:
        """
        Asynchronously retrieve a single page of TranscriptionsInstance records from the API.
        Request is executed immediately

        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of TranscriptionsInstance
        """
        data = values.of(
            {
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Accept"] = "application/json"

        response = await self._version.page_async(
            method="GET", uri=self._uri, params=data, headers=headers
        )
        return TranscriptionsPage(self._version, response, self._solution)

    def get_page(self, target_url: str) -> TranscriptionsPage:
        """
        Retrieve a specific page of TranscriptionsInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of TranscriptionsInstance
        """
        response = self._version.domain.twilio.request("GET", target_url)
        return TranscriptionsPage(self._version, response, self._solution)

    async def get_page_async(self, target_url: str) -> TranscriptionsPage:
        """
        Asynchronously retrieve a specific page of TranscriptionsInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of TranscriptionsInstance
        """
        response = await self._version.domain.twilio.request_async("GET", target_url)
        return TranscriptionsPage(self._version, response, self._solution)

    def get(self, ttid: str) -> TranscriptionsContext:
        """
        Constructs a TranscriptionsContext

        :param ttid: The Twilio type id of the transcriptions resource to update.
        """
        return TranscriptionsContext(
            self._version, room_sid=self._solution["room_sid"], ttid=ttid
        )

    def __call__(self, ttid: str) -> TranscriptionsContext:
        """
        Constructs a TranscriptionsContext

        :param ttid: The Twilio type id of the transcriptions resource to update.
        """
        return TranscriptionsContext(
            self._version, room_sid=self._solution["room_sid"], ttid=ttid
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Video.V1.TranscriptionsList>"
