r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Lookups
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from typing import Any, Dict, List, Optional, Union
from twilio.base import values

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class RateLimitInstance(InstanceResource):
    """
    :ivar rate_limits:
    """

    def __init__(self, version: Version, payload: Dict[str, Any]):
        super().__init__(version)

        self.rate_limits: Optional[List[str]] = payload.get("rate_limits")

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """

        return "<Twilio.Lookups.V2.RateLimitInstance>"


class RateLimitList(ListResource):

    def __init__(self, version: Version):
        """
        Initialize the RateLimitList

        :param version: Version that contains the resource

        """
        super().__init__(version)

        self._uri = "/RateLimits"

    def fetch(
        self, fields: Union[List[str], object] = values.unset
    ) -> RateLimitInstance:
        """
        Asynchronously fetch the RateLimitInstance

        :param fields:
        :returns: The fetched RateLimitInstance
        """
        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Accept"] = "application/json"

        params = values.of(
            {
                "Fields": fields,
            }
        )

        payload = self._version.fetch(
            method="GET", uri=self._uri, headers=headers, params=params
        )

        return RateLimitInstance(self._version, payload)

    async def fetch_async(
        self, fields: Union[List[str], object] = values.unset
    ) -> RateLimitInstance:
        """
        Asynchronously fetch the RateLimitInstance

        :param fields:
        :returns: The fetched RateLimitInstance
        """
        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Accept"] = "application/json"

        params = values.of(
            {
                "Fields": fields,
            }
        )

        payload = await self._version.fetch_async(
            method="GET", uri=self._uri, headers=headers, params=params
        )

        return RateLimitInstance(self._version, payload)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Lookups.V2.RateLimitList>"
