r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Lookups
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from twilio.base import values

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class QueryInstance(InstanceResource):

    class CallForwarding(object):
        """
        :ivar call_forwarding_enabled:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.call_forwarding_enabled: Optional[bool] = payload.get(
                "call_forwarding_enabled"
            )
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.call_forwarding_enabled,
                "": self.error_code,
            }

    class CallerName(object):
        """
        :ivar caller_name:
        :ivar caller_type:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.caller_name: Optional[str] = payload.get("caller_name")
            self.caller_type: Optional[str] = payload.get("caller_type")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.caller_name,
                "": self.caller_type,
                "": self.error_code,
            }

    class IdentityMatch(object):
        """
        :ivar first_name_match:
        :ivar last_name_match:
        :ivar address_line_match:
        :ivar city_match:
        :ivar state_match:
        :ivar postal_code_match:
        :ivar country_code_match:
        :ivar national_id_match:
        :ivar date_of_birth_match:
        :ivar summary_score:
        :ivar error_code:
        :ivar error_message:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.first_name_match: Optional[str] = payload.get("first_name_match")
            self.last_name_match: Optional[str] = payload.get("last_name_match")
            self.address_line_match: Optional[str] = payload.get("address_line_match")
            self.city_match: Optional[str] = payload.get("city_match")
            self.state_match: Optional[str] = payload.get("state_match")
            self.postal_code_match: Optional[str] = payload.get("postal_code_match")
            self.country_code_match: Optional[str] = payload.get("country_code_match")
            self.national_id_match: Optional[str] = payload.get("national_id_match")
            self.date_of_birth_match: Optional[str] = payload.get("date_of_birth_match")
            self.summary_score: Optional[int] = payload.get("summary_score")
            self.error_code: Optional[int] = payload.get("error_code")
            self.error_message: Optional[str] = payload.get("error_message")

        def to_dict(self):
            return {
                "": self.first_name_match,
                "": self.last_name_match,
                "": self.address_line_match,
                "": self.city_match,
                "": self.state_match,
                "": self.postal_code_match,
                "": self.country_code_match,
                "": self.national_id_match,
                "": self.date_of_birth_match,
                "": self.summary_score,
                "": self.error_code,
                "": self.error_message,
            }

    class IdentityMatchParameters(object):
        """
        :ivar first_name:
        :ivar last_name:
        :ivar address_line1:
        :ivar address_line2:
        :ivar city:
        :ivar state:
        :ivar postal_code:
        :ivar address_country_code:
        :ivar national_id:
        :ivar date_of_birth:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.first_name: Optional[str] = payload.get("first_name")
            self.last_name: Optional[str] = payload.get("last_name")
            self.address_line1: Optional[str] = payload.get("address_line1")
            self.address_line2: Optional[str] = payload.get("address_line2")
            self.city: Optional[str] = payload.get("city")
            self.state: Optional[str] = payload.get("state")
            self.postal_code: Optional[str] = payload.get("postal_code")
            self.address_country_code: Optional[str] = payload.get(
                "address_country_code"
            )
            self.national_id: Optional[str] = payload.get("national_id")
            self.date_of_birth: Optional[str] = payload.get("date_of_birth")

        def to_dict(self):
            return {
                "first_name": self.first_name,
                "last_name": self.last_name,
                "address_line1": self.address_line1,
                "address_line2": self.address_line2,
                "city": self.city,
                "state": self.state,
                "postal_code": self.postal_code,
                "address_country_code": self.address_country_code,
                "national_id": self.national_id,
                "date_of_birth": self.date_of_birth,
            }

    class LastSimSwap(object):
        """
        :ivar last_sim_swap_date:
        :ivar swapped_period:
        :ivar swapped_in_period:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_sim_swap_date: Optional[datetime] = payload.get(
                "last_sim_swap_date"
            )
            self.swapped_period: Optional[str] = payload.get("swapped_period")
            self.swapped_in_period: Optional[bool] = payload.get("swapped_in_period")

        def to_dict(self):
            return {
                "": self.last_sim_swap_date,
                "": self.swapped_period,
                "": self.swapped_in_period,
            }

    class LineStatus(object):
        """
        :ivar status:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.status: Optional[str] = payload.get("status")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.status,
                "": self.error_code,
            }

    class LineTypeIntelligence(object):
        """
        :ivar type:
        :ivar carrier_name:
        :ivar mobile_country_code:
        :ivar mobile_network_code:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.type: Optional[str] = payload.get("type")
            self.carrier_name: Optional[str] = payload.get("carrier_name")
            self.mobile_country_code: Optional[str] = payload.get("mobile_country_code")
            self.mobile_network_code: Optional[str] = payload.get("mobile_network_code")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.type,
                "": self.carrier_name,
                "": self.mobile_country_code,
                "": self.mobile_network_code,
                "": self.error_code,
            }

    class LookupRequest1(object):
        """
        :ivar phone_numbers:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.phone_numbers: Optional[List[QueryList.LookupRequestWithCorId]] = (
                payload.get("phone_numbers")
            )

        def to_dict(self):
            return {
                "phone_numbers": (
                    [phone_numbers.to_dict() for phone_numbers in self.phone_numbers]
                    if self.phone_numbers is not None
                    else None
                ),
            }

    class LookupRequestWithCorId(object):
        """
        :ivar correlation_id: Unique identifier used to match request with response
        :ivar phone_number:
        :ivar fields:
        :ivar country_code:
        :ivar identity_match:
        :ivar reassigned_number:
        :ivar sms_pumping_risk:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.correlation_id: Optional[str] = payload.get("correlation_id")
            self.phone_number: Optional[str] = payload.get("phone_number")
            self.fields: Optional[List[Enumstr]] = payload.get("fields")
            self.country_code: Optional[str] = payload.get("country_code")
            self.identity_match: Optional[QueryList.IdentityMatchParameters] = (
                payload.get("identity_match")
            )
            self.reassigned_number: Optional[QueryList.ReassignedNumberRequest] = (
                payload.get("reassigned_number")
            )
            self.sms_pumping_risk: Optional[QueryList.SmsPumpingRiskParameters] = (
                payload.get("sms_pumping_risk")
            )

        def to_dict(self):
            return {
                "correlation_id": self.correlation_id,
                "phone_number": self.phone_number,
                "fields": self.fields,
                "country_code": self.country_code,
                "identity_match": (
                    self.identity_match.to_dict()
                    if self.identity_match is not None
                    else None
                ),
                "reassigned_number": (
                    self.reassigned_number.to_dict()
                    if self.reassigned_number is not None
                    else None
                ),
                "sms_pumping_risk": (
                    self.sms_pumping_risk.to_dict()
                    if self.sms_pumping_risk is not None
                    else None
                ),
            }

    class ReassignedNumberRequest(object):
        """
        :ivar last_verified_date:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_verified_date: Optional[str] = payload.get("last_verified_date")

        def to_dict(self):
            return {
                "last_verified_date": self.last_verified_date,
            }

    class ReassignedNumberResponse(object):
        """
        :ivar last_verified_date:
        :ivar is_number_reassigned:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_verified_date: Optional[str] = payload.get("last_verified_date")
            self.is_number_reassigned: Optional[str] = payload.get(
                "is_number_reassigned"
            )
            self.error_code: Optional[str] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.last_verified_date,
                "": self.is_number_reassigned,
                "": self.error_code,
            }

    class SimSwap(object):
        """
        :ivar last_sim_swap:
        :ivar carrier_name:
        :ivar mobile_country_code:
        :ivar mobile_network_code:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_sim_swap: Optional[LastSimSwap] = payload.get("last_sim_swap")
            self.carrier_name: Optional[str] = payload.get("carrier_name")
            self.mobile_country_code: Optional[str] = payload.get("mobile_country_code")
            self.mobile_network_code: Optional[str] = payload.get("mobile_network_code")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": (
                    self.last_sim_swap.to_dict()
                    if self.last_sim_swap is not None
                    else None
                ),
                "": self.carrier_name,
                "": self.mobile_country_code,
                "": self.mobile_network_code,
                "": self.error_code,
            }

    class SmsPumpingRisk(object):
        """
        :ivar carrier_risk_category:
        :ivar number_blocked:
        :ivar number_blocked_date:
        :ivar number_blocked_last_3_months:
        :ivar sms_pumping_risk_score:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.carrier_risk_category: Optional[str] = payload.get(
                "carrier_risk_category"
            )
            self.number_blocked: Optional[bool] = payload.get("number_blocked")
            self.number_blocked_date: Optional[datetime] = payload.get(
                "number_blocked_date"
            )
            self.number_blocked_last_3_months: Optional[bool] = payload.get(
                "number_blocked_last_3_months"
            )
            self.sms_pumping_risk_score: Optional[int] = payload.get(
                "sms_pumping_risk_score"
            )
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.carrier_risk_category,
                "": self.number_blocked,
                "": self.number_blocked_date,
                "": self.number_blocked_last_3_months,
                "": self.sms_pumping_risk_score,
                "": self.error_code,
            }

    class SmsPumpingRiskParameters(object):
        """
        :ivar partner_sub_id:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.partner_sub_id: Optional[str] = payload.get("partner_sub_id")

        def to_dict(self):
            return {
                "partner_sub_id": self.partner_sub_id,
            }

    """
    :ivar phone_numbers: 
    """

    def __init__(self, version: Version, payload: Dict[str, Any]):
        super().__init__(version)

        self.phone_numbers: Optional[List[str]] = payload.get("phone_numbers")

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """

        return "<Twilio.Lookups.V2.QueryInstance>"


class QueryList(ListResource):

    class CallForwarding(object):
        """
        :ivar call_forwarding_enabled:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.call_forwarding_enabled: Optional[bool] = payload.get(
                "call_forwarding_enabled"
            )
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.call_forwarding_enabled,
                "": self.error_code,
            }

    class CallerName(object):
        """
        :ivar caller_name:
        :ivar caller_type:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.caller_name: Optional[str] = payload.get("caller_name")
            self.caller_type: Optional[str] = payload.get("caller_type")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.caller_name,
                "": self.caller_type,
                "": self.error_code,
            }

    class IdentityMatch(object):
        """
        :ivar first_name_match:
        :ivar last_name_match:
        :ivar address_line_match:
        :ivar city_match:
        :ivar state_match:
        :ivar postal_code_match:
        :ivar country_code_match:
        :ivar national_id_match:
        :ivar date_of_birth_match:
        :ivar summary_score:
        :ivar error_code:
        :ivar error_message:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.first_name_match: Optional[str] = payload.get("first_name_match")
            self.last_name_match: Optional[str] = payload.get("last_name_match")
            self.address_line_match: Optional[str] = payload.get("address_line_match")
            self.city_match: Optional[str] = payload.get("city_match")
            self.state_match: Optional[str] = payload.get("state_match")
            self.postal_code_match: Optional[str] = payload.get("postal_code_match")
            self.country_code_match: Optional[str] = payload.get("country_code_match")
            self.national_id_match: Optional[str] = payload.get("national_id_match")
            self.date_of_birth_match: Optional[str] = payload.get("date_of_birth_match")
            self.summary_score: Optional[int] = payload.get("summary_score")
            self.error_code: Optional[int] = payload.get("error_code")
            self.error_message: Optional[str] = payload.get("error_message")

        def to_dict(self):
            return {
                "": self.first_name_match,
                "": self.last_name_match,
                "": self.address_line_match,
                "": self.city_match,
                "": self.state_match,
                "": self.postal_code_match,
                "": self.country_code_match,
                "": self.national_id_match,
                "": self.date_of_birth_match,
                "": self.summary_score,
                "": self.error_code,
                "": self.error_message,
            }

    class IdentityMatchParameters(object):
        """
        :ivar first_name:
        :ivar last_name:
        :ivar address_line1:
        :ivar address_line2:
        :ivar city:
        :ivar state:
        :ivar postal_code:
        :ivar address_country_code:
        :ivar national_id:
        :ivar date_of_birth:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.first_name: Optional[str] = payload.get("first_name")
            self.last_name: Optional[str] = payload.get("last_name")
            self.address_line1: Optional[str] = payload.get("address_line1")
            self.address_line2: Optional[str] = payload.get("address_line2")
            self.city: Optional[str] = payload.get("city")
            self.state: Optional[str] = payload.get("state")
            self.postal_code: Optional[str] = payload.get("postal_code")
            self.address_country_code: Optional[str] = payload.get(
                "address_country_code"
            )
            self.national_id: Optional[str] = payload.get("national_id")
            self.date_of_birth: Optional[str] = payload.get("date_of_birth")

        def to_dict(self):
            return {
                "first_name": self.first_name,
                "last_name": self.last_name,
                "address_line1": self.address_line1,
                "address_line2": self.address_line2,
                "city": self.city,
                "state": self.state,
                "postal_code": self.postal_code,
                "address_country_code": self.address_country_code,
                "national_id": self.national_id,
                "date_of_birth": self.date_of_birth,
            }

    class LastSimSwap(object):
        """
        :ivar last_sim_swap_date:
        :ivar swapped_period:
        :ivar swapped_in_period:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_sim_swap_date: Optional[datetime] = payload.get(
                "last_sim_swap_date"
            )
            self.swapped_period: Optional[str] = payload.get("swapped_period")
            self.swapped_in_period: Optional[bool] = payload.get("swapped_in_period")

        def to_dict(self):
            return {
                "": self.last_sim_swap_date,
                "": self.swapped_period,
                "": self.swapped_in_period,
            }

    class LineStatus(object):
        """
        :ivar status:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.status: Optional[str] = payload.get("status")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.status,
                "": self.error_code,
            }

    class LineTypeIntelligence(object):
        """
        :ivar type:
        :ivar carrier_name:
        :ivar mobile_country_code:
        :ivar mobile_network_code:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.type: Optional[str] = payload.get("type")
            self.carrier_name: Optional[str] = payload.get("carrier_name")
            self.mobile_country_code: Optional[str] = payload.get("mobile_country_code")
            self.mobile_network_code: Optional[str] = payload.get("mobile_network_code")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.type,
                "": self.carrier_name,
                "": self.mobile_country_code,
                "": self.mobile_network_code,
                "": self.error_code,
            }

    class LookupRequest1(object):
        """
        :ivar phone_numbers:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.phone_numbers: Optional[List[QueryList.LookupRequestWithCorId]] = (
                payload.get("phone_numbers")
            )

        def to_dict(self):
            return {
                "phone_numbers": (
                    [phone_numbers.to_dict() for phone_numbers in self.phone_numbers]
                    if self.phone_numbers is not None
                    else None
                ),
            }

    class LookupRequestWithCorId(object):
        """
        :ivar correlation_id: Unique identifier used to match request with response
        :ivar phone_number:
        :ivar fields:
        :ivar country_code:
        :ivar identity_match:
        :ivar reassigned_number:
        :ivar sms_pumping_risk:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.correlation_id: Optional[str] = payload.get("correlation_id")
            self.phone_number: Optional[str] = payload.get("phone_number")
            self.fields: Optional[List[Enumstr]] = payload.get("fields")
            self.country_code: Optional[str] = payload.get("country_code")
            self.identity_match: Optional[QueryList.IdentityMatchParameters] = (
                payload.get("identity_match")
            )
            self.reassigned_number: Optional[QueryList.ReassignedNumberRequest] = (
                payload.get("reassigned_number")
            )
            self.sms_pumping_risk: Optional[QueryList.SmsPumpingRiskParameters] = (
                payload.get("sms_pumping_risk")
            )

        def to_dict(self):
            return {
                "correlation_id": self.correlation_id,
                "phone_number": self.phone_number,
                "fields": self.fields,
                "country_code": self.country_code,
                "identity_match": (
                    self.identity_match.to_dict()
                    if self.identity_match is not None
                    else None
                ),
                "reassigned_number": (
                    self.reassigned_number.to_dict()
                    if self.reassigned_number is not None
                    else None
                ),
                "sms_pumping_risk": (
                    self.sms_pumping_risk.to_dict()
                    if self.sms_pumping_risk is not None
                    else None
                ),
            }

    class ReassignedNumberRequest(object):
        """
        :ivar last_verified_date:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_verified_date: Optional[str] = payload.get("last_verified_date")

        def to_dict(self):
            return {
                "last_verified_date": self.last_verified_date,
            }

    class ReassignedNumberResponse(object):
        """
        :ivar last_verified_date:
        :ivar is_number_reassigned:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_verified_date: Optional[str] = payload.get("last_verified_date")
            self.is_number_reassigned: Optional[str] = payload.get(
                "is_number_reassigned"
            )
            self.error_code: Optional[str] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.last_verified_date,
                "": self.is_number_reassigned,
                "": self.error_code,
            }

    class SimSwap(object):
        """
        :ivar last_sim_swap:
        :ivar carrier_name:
        :ivar mobile_country_code:
        :ivar mobile_network_code:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.last_sim_swap: Optional[LastSimSwap] = payload.get("last_sim_swap")
            self.carrier_name: Optional[str] = payload.get("carrier_name")
            self.mobile_country_code: Optional[str] = payload.get("mobile_country_code")
            self.mobile_network_code: Optional[str] = payload.get("mobile_network_code")
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": (
                    self.last_sim_swap.to_dict()
                    if self.last_sim_swap is not None
                    else None
                ),
                "": self.carrier_name,
                "": self.mobile_country_code,
                "": self.mobile_network_code,
                "": self.error_code,
            }

    class SmsPumpingRisk(object):
        """
        :ivar carrier_risk_category:
        :ivar number_blocked:
        :ivar number_blocked_date:
        :ivar number_blocked_last_3_months:
        :ivar sms_pumping_risk_score:
        :ivar error_code:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.carrier_risk_category: Optional[str] = payload.get(
                "carrier_risk_category"
            )
            self.number_blocked: Optional[bool] = payload.get("number_blocked")
            self.number_blocked_date: Optional[datetime] = payload.get(
                "number_blocked_date"
            )
            self.number_blocked_last_3_months: Optional[bool] = payload.get(
                "number_blocked_last_3_months"
            )
            self.sms_pumping_risk_score: Optional[int] = payload.get(
                "sms_pumping_risk_score"
            )
            self.error_code: Optional[int] = payload.get("error_code")

        def to_dict(self):
            return {
                "": self.carrier_risk_category,
                "": self.number_blocked,
                "": self.number_blocked_date,
                "": self.number_blocked_last_3_months,
                "": self.sms_pumping_risk_score,
                "": self.error_code,
            }

    class SmsPumpingRiskParameters(object):
        """
        :ivar partner_sub_id:
        """

        def __init__(self, payload: Dict[str, Any]):

            self.partner_sub_id: Optional[str] = payload.get("partner_sub_id")

        def to_dict(self):
            return {
                "partner_sub_id": self.partner_sub_id,
            }

    def __init__(self, version: Version):
        """
        Initialize the QueryList

        :param version: Version that contains the resource

        """
        super().__init__(version)

        self._uri = "/batch/query"

    def create(
        self, lookup_request1: Union[LookupRequest1, object] = values.unset
    ) -> QueryInstance:
        """
        Create the QueryInstance

        :param lookup_request1:

        :returns: The created QueryInstance
        """
        data = lookup_request1.to_dict()

        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = self._version.create(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return QueryInstance(self._version, payload)

    async def create_async(
        self, lookup_request1: Union[LookupRequest1, object] = values.unset
    ) -> QueryInstance:
        """
        Asynchronously create the QueryInstance

        :param lookup_request1:

        :returns: The created QueryInstance
        """
        data = lookup_request1.to_dict()

        headers = values.of({"Content-Type": "application/x-www-form-urlencoded"})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = await self._version.create_async(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return QueryInstance(self._version, payload)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Lookups.V2.QueryList>"
