r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Lookups
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from typing import Any, Dict, Optional, Union
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class BucketInstance(InstanceResource):

    class RateLimitRequest(object):
        """
        :ivar limit: Limit of requests for the bucket
        :ivar ttl: Time to live of the rule
        """

        def __init__(self, payload: Dict[str, Any]):

            self.limit: Optional[int] = payload.get("limit")
            self.ttl: Optional[int] = payload.get("ttl")

        def to_dict(self):
            return {
                "limit": self.limit,
                "ttl": self.ttl,
            }

    """
    :ivar code: Twilio-specific error code
    :ivar message: Error message
    :ivar more_info: Link to Error Code References
    :ivar status: HTTP response status code
    :ivar field: Limit of requests for the bucket
    :ivar limit: Limit of requests for the bucket
    :ivar bucket: Name of the bucket
    :ivar owner: Owner of the rule
    :ivar ttl: Time to live of the rule
    """

    def __init__(
        self,
        version: Version,
        payload: Dict[str, Any],
        field: Optional[str] = None,
        bucket: Optional[str] = None,
    ):
        super().__init__(version)

        self.code: Optional[int] = payload.get("code")
        self.message: Optional[str] = payload.get("message")
        self.more_info: Optional[str] = payload.get("more_info")
        self.status: Optional[int] = payload.get("status")
        self.field: Optional[str] = payload.get("field")
        self.limit: Optional[int] = payload.get("limit")
        self.bucket: Optional[str] = payload.get("bucket")
        self.owner: Optional[str] = payload.get("owner")
        self.ttl: Optional[int] = payload.get("ttl")

        self._solution = {
            "field": field or self.field,
            "bucket": bucket or self.bucket,
        }
        self._context: Optional[BucketContext] = None

    @property
    def _proxy(self) -> "BucketContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: BucketContext for this BucketInstance
        """
        if self._context is None:
            self._context = BucketContext(
                self._version,
                field=self._solution["field"],
                bucket=self._solution["bucket"],
            )
        return self._context

    def delete(self) -> bool:
        """
        Deletes the BucketInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._proxy.delete()

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the BucketInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._proxy.delete_async()

    def fetch(self) -> "BucketInstance":
        """
        Fetch the BucketInstance


        :returns: The fetched BucketInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "BucketInstance":
        """
        Asynchronous coroutine to fetch the BucketInstance


        :returns: The fetched BucketInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self, rate_limit_request: Union[RateLimitRequest, object] = values.unset
    ) -> "BucketInstance":
        """
        Update the BucketInstance

        :param rate_limit_request:

        :returns: The updated BucketInstance
        """
        return self._proxy.update(
            rate_limit_request=rate_limit_request,
        )

    async def update_async(
        self, rate_limit_request: Union[RateLimitRequest, object] = values.unset
    ) -> "BucketInstance":
        """
        Asynchronous coroutine to update the BucketInstance

        :param rate_limit_request:

        :returns: The updated BucketInstance
        """
        return await self._proxy.update_async(
            rate_limit_request=rate_limit_request,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Lookups.V2.BucketInstance {}>".format(context)


class BucketContext(InstanceContext):

    class RateLimitRequest(object):
        """
        :ivar limit: Limit of requests for the bucket
        :ivar ttl: Time to live of the rule
        """

        def __init__(self, payload: Dict[str, Any]):

            self.limit: Optional[int] = payload.get("limit")
            self.ttl: Optional[int] = payload.get("ttl")

        def to_dict(self):
            return {
                "limit": self.limit,
                "ttl": self.ttl,
            }

    def __init__(self, version: Version, field: str, bucket: str):
        """
        Initialize the BucketContext

        :param version: Version that contains the resource
        :param field: field name
        :param bucket: bucket name
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "field": field,
            "bucket": bucket,
        }
        self._uri = "/RateLimits/Fields/{field}/Bucket/{bucket}".format(
            **self._solution
        )

    def delete(self) -> bool:
        """
        Deletes the BucketInstance


        :returns: True if delete succeeds, False otherwise
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        return self._version.delete(method="DELETE", uri=self._uri, headers=headers)

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the BucketInstance


        :returns: True if delete succeeds, False otherwise
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        return await self._version.delete_async(
            method="DELETE", uri=self._uri, headers=headers
        )

    def fetch(self) -> BucketInstance:
        """
        Fetch the BucketInstance


        :returns: The fetched BucketInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = self._version.fetch(method="GET", uri=self._uri, headers=headers)

        return BucketInstance(
            self._version,
            payload,
            field=self._solution["field"],
            bucket=self._solution["bucket"],
        )

    async def fetch_async(self) -> BucketInstance:
        """
        Asynchronous coroutine to fetch the BucketInstance


        :returns: The fetched BucketInstance
        """

        headers = values.of({})

        headers["Accept"] = "application/json"

        payload = await self._version.fetch_async(
            method="GET", uri=self._uri, headers=headers
        )

        return BucketInstance(
            self._version,
            payload,
            field=self._solution["field"],
            bucket=self._solution["bucket"],
        )

    def update(
        self, rate_limit_request: Union[RateLimitRequest, object] = values.unset
    ) -> BucketInstance:
        """
        Update the BucketInstance

        :param rate_limit_request:

        :returns: The updated BucketInstance
        """
        data = rate_limit_request.to_dict()

        headers = values.of({})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = self._version.update(
            method="PUT", uri=self._uri, data=data, headers=headers
        )

        return BucketInstance(
            self._version,
            payload,
            field=self._solution["field"],
            bucket=self._solution["bucket"],
        )

    async def update_async(
        self, rate_limit_request: Union[RateLimitRequest, object] = values.unset
    ) -> BucketInstance:
        """
        Asynchronous coroutine to update the BucketInstance

        :param rate_limit_request:

        :returns: The updated BucketInstance
        """
        data = rate_limit_request.to_dict()

        headers = values.of({})

        headers["Content-Type"] = "application/json"

        headers["Accept"] = "application/json"

        payload = await self._version.update_async(
            method="PUT", uri=self._uri, data=data, headers=headers
        )

        return BucketInstance(
            self._version,
            payload,
            field=self._solution["field"],
            bucket=self._solution["bucket"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Lookups.V2.BucketContext {}>".format(context)


class BucketList(ListResource):

    class RateLimitRequest(object):
        """
        :ivar limit: Limit of requests for the bucket
        :ivar ttl: Time to live of the rule
        """

        def __init__(self, payload: Dict[str, Any]):

            self.limit: Optional[int] = payload.get("limit")
            self.ttl: Optional[int] = payload.get("ttl")

        def to_dict(self):
            return {
                "limit": self.limit,
                "ttl": self.ttl,
            }

    def __init__(self, version: Version):
        """
        Initialize the BucketList

        :param version: Version that contains the resource

        """
        super().__init__(version)

    def get(self, field: str, bucket: str) -> BucketContext:
        """
        Constructs a BucketContext

        :param field: field name
        :param bucket: bucket name
        """
        return BucketContext(self._version, field=field, bucket=bucket)

    def __call__(self, field: str, bucket: str) -> BucketContext:
        """
        Constructs a BucketContext

        :param field: field name
        :param bucket: bucket name
        """
        return BucketContext(self._version, field=field, bucket=bucket)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Lookups.V2.BucketList>"
