r'''
# AWS::WAFv2 Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_wafv2 as wafv2
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for WAFv2 construct libraries](https://constructs.dev/search?q=wafv2)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::WAFv2 resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::WAFv2](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    ITaggable as _ITaggable_36806126,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnIPSet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnIPSet",
):
    '''.. epigraph::

   This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019.

    For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``IPSet`` to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure AWS WAF to block them using an IP set that lists those IP addresses.

    You use an IP set by providing its Amazon Resource Name (ARN) to the rule statement ``IPSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
    :cloudformationResource: AWS::WAFv2::IPSet
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        cfn_iPSet = wafv2.CfnIPSet(self, "MyCfnIPSet",
            addresses=["addresses"],
            ip_address_version="ipAddressVersion",
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope_: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want AWS WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - For requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__039afc69c65e0dd02b0d7963f7fa0f2983949d351922a3fbe8afc7cd0aa22eab)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnIPSetProps(
            addresses=addresses,
            ip_address_version=ip_address_version,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0600a367beb5e92220f305b2a290f7e6c367a23cdd9bdc5ba244ae1705a05b3a)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__179e205b0ee0cdd8de882b8a3fba1a899c4ff7e936aa2de1283121509e783188)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IP set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the IP set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="addresses")
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want AWS WAF to inspect for in incoming requests.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "addresses"))

    @addresses.setter
    def addresses(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f10a155b121165e58778a83d62545cfbfc395feeb362e4b1d092ad6be31ca8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "addresses", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="ipAddressVersion")
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .'''
        return typing.cast(builtins.str, jsii.get(self, "ipAddressVersion"))

    @ip_address_version.setter
    def ip_address_version(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a699244d4dfb348990708737607c0caf993fb45f4f6ad29f480c33b8209331d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ipAddressVersion", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.'''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__feee99d99d65eba762ddaa0e8744a3087cf92dbcdebb488d058953dbb010e8f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68a24131e312bc846012992c64cf5b9592365c9af854d2d4c50e4921aa058bb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c0c9ed63000c100a64f48977af0d5bcd4c1fdd0ec76ceef0e3e0d45fbe40fbe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae99337cdeb3e6b180e6ec4bbd7c9dfc2db1e07a5a4932f80d44ab784640f76a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnIPSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "ip_address_version": "ipAddressVersion",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnIPSetProps:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnIPSet``.

        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want AWS WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - For requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            cfn_iPSet_props = wafv2.CfnIPSetProps(
                addresses=["addresses"],
                ip_address_version="ipAddressVersion",
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96b0ead7c11c27cbe1678aa0bf080746e410b94c991c94a4b26268579d9f4d17)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument ip_address_version", value=ip_address_version, expected_type=type_hints["ip_address_version"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
            "ip_address_version": ip_address_version,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want AWS WAF to inspect for in incoming requests.

        All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` .

        Example address strings:

        - For requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` .
        - For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` .
        - For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` .
        - For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` .

        For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ .

        Example JSON ``Addresses`` specifications:

        - Empty array: ``"Addresses": []``
        - Array with one address: ``"Addresses": ["192.0.2.44/32"]``
        - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]``
        - INVALID specification: ``"Addresses": [""]`` INVALID

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
        '''
        result = self._values.get("ip_address_version")
        assert result is not None, "Required property 'ip_address_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.

        You cannot change the name of an ``IPSet`` after you create it.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnIPSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnLoggingConfiguration(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration",
):
    '''Defines an association between logging destinations and a web ACL resource, for logging from AWS WAF .

    As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.

    If you configure data protection for the web ACL, the protection applies to the data that AWS WAF sends to the logs.
    .. epigraph::

       You can define one logging destination per web ACL.

    You can access information about the traffic that AWS WAF inspects using the following steps:

    - Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.

    The name that you give the destination must start with ``aws-waf-logs-`` . Depending on the type of destination, you might need to configure additional settings or permissions.

    For configuration requirements and pricing information for each destination type, see `Logging web ACL traffic <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    - Associate your logging destination to your web ACL using a ``PutLoggingConfiguration`` request.

    When you successfully enable logging using a ``PutLoggingConfiguration`` request, AWS WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, AWS WAF creates a resource policy on the log group. For an Amazon S3 bucket, AWS WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, AWS WAF creates a service-linked role.

    For additional information about web ACL logging, see `Logging web ACL traffic information <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
    :cloudformationResource: AWS::WAFv2::LoggingConfiguration
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        # json_body: Any
        # logging_filter: Any
        # method: Any
        # query_string: Any
        # single_header: Any
        # uri_path: Any
        
        cfn_logging_configuration = wafv2.CfnLoggingConfiguration(self, "MyCfnLoggingConfiguration",
            log_destination_configs=["logDestinationConfigs"],
            resource_arn="resourceArn",
        
            # the properties below are optional
            logging_filter=logging_filter,
            redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                json_body=json_body,
                method=method,
                query_string=query_string,
                single_header=single_header,
                uri_path=uri_path
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting. If you configure data protection for the web ACL, the protection applies to the data that AWS WAF sends to the logs. Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` . > This setting has no impact on request sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a8c4ba5ee1b98a4ed1dd5001182ec8712406026687793bcb17c7a78771fa41c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnLoggingConfigurationProps(
            log_destination_configs=log_destination_configs,
            resource_arn=resource_arn,
            logging_filter=logging_filter,
            redacted_fields=redacted_fields,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__09d6ff21499349760b4e1833c701bb35da7d5f623b987204d2cba29df24d4dd5)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce45f42f3fc8a3306e3cf191c01b8b74f6f778f934881efc098c67eae0ab574f)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrManagedByFirewallManager")
    def attr_managed_by_firewall_manager(self) -> _IResolvable_da3f097b:
        '''Indicates whether the logging configuration was created by AWS Firewall Manager , as part of an AWS WAF policy configuration.

        If true, only Firewall Manager can modify or delete the configuration.

        :cloudformationAttribute: ManagedByFirewallManager
        '''
        return typing.cast(_IResolvable_da3f097b, jsii.get(self, "attrManagedByFirewallManager"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="logDestinationConfigs")
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "logDestinationConfigs"))

    @log_destination_configs.setter
    def log_destination_configs(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cea30baad623cdba4cda27c8a05e17294c73ce64e3c9306b0448944f2d2e7603)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "logDestinationConfigs", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="resourceArn")
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .'''
        return typing.cast(builtins.str, jsii.get(self, "resourceArn"))

    @resource_arn.setter
    def resource_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__131460b145114748342bba71adbba5e0de220ac6ea445093e05959407b65bd2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="loggingFilter")
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.'''
        return typing.cast(typing.Any, jsii.get(self, "loggingFilter"))

    @logging_filter.setter
    def logging_filter(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e432d8d1e0fc298c7c4d7f42acca7ba0c8edc61ee2795cd2454d866a80034faa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "loggingFilter", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="redactedFields")
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]]:
        '''The parts of the request that you want to keep out of the logs.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]], jsii.get(self, "redactedFields"))

    @redacted_fields.setter
    def redacted_fields(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77098387595faa6bc77b294170e26602e484493e0515112c5936ba88ceb70e6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "redactedFields", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ActionConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"action": "action"},
    )
    class ActionConditionProperty:
        def __init__(self, *, action: builtins.str) -> None:
            '''A single action condition for a condition in a logging filter.

            :param action: The action setting that a log record must contain in order to meet the condition. This is the action that AWS WAF applied to the web request. For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                action_condition_property = wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                    action="action"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b50ba1c68e04e01fa933a06e4c55e88e55cd8c0103f546e3e3df1cc633cebd96)
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "action": action,
            }

        @builtins.property
        def action(self) -> builtins.str:
            '''The action setting that a log record must contain in order to meet the condition.

            This is the action that AWS WAF applied to the web request.

            For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html#cfn-wafv2-loggingconfiguration-actioncondition-action
            '''
            result = self._values.get("action")
            assert result is not None, "Required property 'action' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ActionConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ConditionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "action_condition": "actionCondition",
            "label_name_condition": "labelNameCondition",
        },
    )
    class ConditionProperty:
        def __init__(
            self,
            *,
            action_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.ActionConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label_name_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.LabelNameConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A single match condition for a log filter.

            :param action_condition: A single action condition. This is the action setting that a log record must contain in order to meet the condition.
            :param label_name_condition: A single label name condition. This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                condition_property = wafv2.CfnLoggingConfiguration.ConditionProperty(
                    action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                        action="action"
                    ),
                    label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                        label_name="labelName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__656ff215ddddac51d5278c1b95b125cba525825694103354c56a1d5a69bccafa)
                check_type(argname="argument action_condition", value=action_condition, expected_type=type_hints["action_condition"])
                check_type(argname="argument label_name_condition", value=label_name_condition, expected_type=type_hints["label_name_condition"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if action_condition is not None:
                self._values["action_condition"] = action_condition
            if label_name_condition is not None:
                self._values["label_name_condition"] = label_name_condition

        @builtins.property
        def action_condition(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ActionConditionProperty"]]:
            '''A single action condition.

            This is the action setting that a log record must contain in order to meet the condition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-actioncondition
            '''
            result = self._values.get("action_condition")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ActionConditionProperty"]], result)

        @builtins.property
        def label_name_condition(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.LabelNameConditionProperty"]]:
            '''A single label name condition.

            This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-labelnamecondition
            '''
            result = self._values.get("label_name_condition")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.LabelNameConditionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            json_body: typing.Any = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The parts of the request that you want to keep out of the logs.

            This is used in the logging configuration ``RedactedFields`` specification.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param json_body: 
            :param method: Redact the indicated HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Redact the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Redact a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }``
            :param uri_path: Redact the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # json_body: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a114319b47aa4cd2b95781f4821770182938be36290f92e23536d594e9de8d12)
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def json_body(self) -> typing.Any:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Any, result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Redact the indicated HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Redact the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Redact a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Redact the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FilterProperty",
        jsii_struct_bases=[],
        name_mapping={
            "behavior": "behavior",
            "conditions": "conditions",
            "requirement": "requirement",
        },
    )
    class FilterProperty:
        def __init__(
            self,
            *,
            behavior: builtins.str,
            conditions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.ConditionProperty", typing.Dict[builtins.str, typing.Any]]]]],
            requirement: builtins.str,
        ) -> None:
            '''A single logging filter, used in ``LoggingFilter`` .

            :param behavior: How to handle logs that satisfy the filter's conditions and requirement.
            :param conditions: Match conditions for the filter.
            :param requirement: Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                filter_property = wafv2.CfnLoggingConfiguration.FilterProperty(
                    behavior="behavior",
                    conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                        action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                            action="action"
                        ),
                        label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                            label_name="labelName"
                        )
                    )],
                    requirement="requirement"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b78b0441cbfd332efa20e314d1f8d29adb0ea98f8aee71719041ba64fe798c15)
                check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
                check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
                check_type(argname="argument requirement", value=requirement, expected_type=type_hints["requirement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "behavior": behavior,
                "conditions": conditions,
                "requirement": requirement,
            }

        @builtins.property
        def behavior(self) -> builtins.str:
            '''How to handle logs that satisfy the filter's conditions and requirement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-behavior
            '''
            result = self._values.get("behavior")
            assert result is not None, "Required property 'behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def conditions(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ConditionProperty"]]]:
            '''Match conditions for the filter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-conditions
            '''
            result = self._values.get("conditions")
            assert result is not None, "Required property 'conditions' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ConditionProperty"]]], result)

        @builtins.property
        def requirement(self) -> builtins.str:
            '''Logic to apply to the filtering conditions.

            You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-requirement
            '''
            result = self._values.get("requirement")
            assert result is not None, "Required property 'requirement' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.MatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param match_pattern: 
            :param match_scope: 
            :param invalid_fallback_behavior: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnLoggingConfiguration.JsonBodyProperty(
                    match_pattern=wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__eecc91912e5b445e79d0bc6e4a9855bb182f496c1cd38ebc4465393f47e06750)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.MatchPatternProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.MatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LabelNameConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"label_name": "labelName"},
    )
    class LabelNameConditionProperty:
        def __init__(self, *, label_name: builtins.str) -> None:
            '''A single label name condition for a condition in a logging filter.

            :param label_name: The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_name_condition_property = wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                    label_name="labelName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ce4928adbdaf21f843c60f7ff46db78d9f71cd9a544213de312c7a389034c4c2)
                check_type(argname="argument label_name", value=label_name, expected_type=type_hints["label_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "label_name": label_name,
            }

        @builtins.property
        def label_name(self) -> builtins.str:
            '''The label name that a log record must contain in order to meet the condition.

            This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html#cfn-wafv2-loggingconfiguration-labelnamecondition-labelname
            '''
            result = self._values.get("label_name")
            assert result is not None, "Required property 'label_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelNameConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LoggingFilterProperty",
        jsii_struct_bases=[],
        name_mapping={"default_behavior": "defaultBehavior", "filters": "filters"},
    )
    class LoggingFilterProperty:
        def __init__(
            self,
            *,
            default_behavior: builtins.str,
            filters: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.FilterProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL's ``LoggingConfiguration`` .

            You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

            :param default_behavior: Default handling for logs that don't match any of the specified filtering conditions.
            :param filters: The filters that you want to apply to the logs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                logging_filter_property = wafv2.CfnLoggingConfiguration.LoggingFilterProperty(
                    default_behavior="defaultBehavior",
                    filters=[wafv2.CfnLoggingConfiguration.FilterProperty(
                        behavior="behavior",
                        conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                            action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                                action="action"
                            ),
                            label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                                label_name="labelName"
                            )
                        )],
                        requirement="requirement"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bfe62ade2e509570c793f0eb85aa51c6ec6f9070c34bb75ad87d9c454a31de06)
                check_type(argname="argument default_behavior", value=default_behavior, expected_type=type_hints["default_behavior"])
                check_type(argname="argument filters", value=filters, expected_type=type_hints["filters"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_behavior": default_behavior,
                "filters": filters,
            }

        @builtins.property
        def default_behavior(self) -> builtins.str:
            '''Default handling for logs that don't match any of the specified filtering conditions.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-defaultbehavior
            '''
            result = self._values.get("default_behavior")
            assert result is not None, "Required property 'default_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def filters(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FilterProperty"]]]:
            '''The filters that you want to apply to the logs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-filters
            '''
            result = self._values.get("filters")
            assert result is not None, "Required property 'filters' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FilterProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LoggingFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.MatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class MatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''
            :param all: 
            :param included_paths: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                match_pattern_property = wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7f5363956da4183fbbc9d58305c49d115c7f21916e1661cc8e8b3e772aeac3c5)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnLoggingConfiguration.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fcdbe2344105f56809989a50b71b674a0abcb188986d4b216ba3fc5f416632c2)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html#cfn-wafv2-loggingconfiguration-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfigurationProps",
    jsii_struct_bases=[],
    name_mapping={
        "log_destination_configs": "logDestinationConfigs",
        "resource_arn": "resourceArn",
        "logging_filter": "loggingFilter",
        "redacted_fields": "redactedFields",
    },
)
class CfnLoggingConfigurationProps:
    def __init__(
        self,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnLoggingConfiguration.FieldToMatchProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnLoggingConfiguration``.

        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting. If you configure data protection for the web ACL, the protection applies to the data that AWS WAF sends to the logs. Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` . > This setting has no impact on request sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            # json_body: Any
            # logging_filter: Any
            # method: Any
            # query_string: Any
            # single_header: Any
            # uri_path: Any
            
            cfn_logging_configuration_props = wafv2.CfnLoggingConfigurationProps(
                log_destination_configs=["logDestinationConfigs"],
                resource_arn="resourceArn",
            
                # the properties below are optional
                logging_filter=logging_filter,
                redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__713893ab58a2ac0a37391a960bcaeb40dad62a9addec656d6016e0911ff1d752)
            check_type(argname="argument log_destination_configs", value=log_destination_configs, expected_type=type_hints["log_destination_configs"])
            check_type(argname="argument resource_arn", value=resource_arn, expected_type=type_hints["resource_arn"])
            check_type(argname="argument logging_filter", value=logging_filter, expected_type=type_hints["logging_filter"])
            check_type(argname="argument redacted_fields", value=redacted_fields, expected_type=type_hints["redacted_fields"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "log_destination_configs": log_destination_configs,
            "resource_arn": resource_arn,
        }
        if logging_filter is not None:
            self._values["logging_filter"] = logging_filter
        if redacted_fields is not None:
            self._values["redacted_fields"] = redacted_fields

    @builtins.property
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.

        .. epigraph::

           You can associate one logging destination to a web ACL.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs
        '''
        result = self._values.get("log_destination_configs")
        assert result is not None, "Required property 'log_destination_configs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn
        '''
        result = self._values.get("resource_arn")
        assert result is not None, "Required property 'resource_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.

        You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter
        '''
        result = self._values.get("logging_filter")
        return typing.cast(typing.Any, result)

    @builtins.property
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnLoggingConfiguration.FieldToMatchProperty]]]]:
        '''The parts of the request that you want to keep out of the logs.

        For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting.

        If you configure data protection for the web ACL, the protection applies to the data that AWS WAF sends to the logs.

        Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` .
        .. epigraph::

           You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` . > This setting has no impact on request sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields
        '''
        result = self._values.get("redacted_fields")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnLoggingConfiguration.FieldToMatchProperty]]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLoggingConfigurationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnRegexPatternSet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRegexPatternSet",
):
    '''.. epigraph::

   This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019.

    For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RegexPatternSet`` to have AWS WAF inspect a web request component for a specific set of regular expression patterns.

    You use a regex pattern set by providing its Amazon Resource Name (ARN) to the rule statement ``RegexPatternSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
    :cloudformationResource: AWS::WAFv2::RegexPatternSet
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        cfn_regex_pattern_set = wafv2.CfnRegexPatternSet(self, "MyCfnRegexPatternSet",
            regular_expression_list=["regularExpressionList"],
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope_: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9cac4ad6f53737b9539cafcf1c5335cc1730b94e91e16609b8484eeb02a972c)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRegexPatternSetProps(
            regular_expression_list=regular_expression_list,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bb67597e6b986a810872fc80d040910cf0c649df66f8a90887b49bb15b1d104)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__131971a5443887615a0e02b763d8b00cc2eb6e5c404f9fa6d94b78266aefdffb)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the regex pattern set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the regex pattern set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="regularExpressionList")
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "regularExpressionList"))

    @regular_expression_list.setter
    def regular_expression_list(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4ca0288728c67165a7c1ac018aedf56cbbc29ab8b7d65a41aa53725cabca8c2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "regularExpressionList", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.'''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f64738019eff796073258de928c3af2e479868f96c5ac05ec7a01d8f1e6953ad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e92feb6e48a6da68fe36d1bef73657aa406f74df78d1b77d7d494a4b92949a9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b2d8f91c1720f07bbe37765c9c4ba11a88810bbc881356de626a279e0b29542)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a1e0f3d5ecf30ff25c1225094facbc468c6ce74c69952e7917c75a8a3a98376)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRegexPatternSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "regular_expression_list": "regularExpressionList",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnRegexPatternSetProps:
    def __init__(
        self,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRegexPatternSet``.

        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            cfn_regex_pattern_set_props = wafv2.CfnRegexPatternSetProps(
                regular_expression_list=["regularExpressionList"],
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4655926f3e763ad1701fea25b17a982c17326f38b7601267b5b7b6462571865e)
            check_type(argname="argument regular_expression_list", value=regular_expression_list, expected_type=type_hints["regular_expression_list"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "regular_expression_list": regular_expression_list,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
        '''
        result = self._values.get("regular_expression_list")
        assert result is not None, "Required property 'regular_expression_list' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.

        You cannot change the name after you create the set.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRegexPatternSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnRuleGroup(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup",
):
    '''.. epigraph::

   This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019.

    For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RuleGroup`` to define a collection of rules for inspecting and controlling web requests. You use a rule group in an ``WebACL`` by providing its Amazon Resource Name (ARN) to the rule statement ``RuleGroupReferenceStatement`` , when you add rules to the web ACL.

    When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
    :cloudformationResource: AWS::WAFv2::RuleGroup
    :exampleMetadata: fixture=_generated

    Example::

        
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        available_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope_: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the ``RuleLabels`` for a ``Rule`` .
        :param consumed_labels: The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39414085bb3516b24d65751cc1c079ecf5858068f282c2e495c8018706735edc)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRuleGroupProps(
            capacity=capacity,
            scope=scope,
            visibility_config=visibility_config,
            available_labels=available_labels,
            consumed_labels=consumed_labels,
            custom_response_bodies=custom_response_bodies,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__876762f27eecc699ae54746548a47c32e6e3addbc69b2ea95646b69ad890682c)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e035e41ba622b9f85376fe682de1ee8f6e8c3e3b255d40dc70db5eb415158e8)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the rule group.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the rule group.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this rule group.

        All labels added by rules in this rule group have this prefix.

        The syntax for the label namespace prefix for a rule group is the following: ``awswaf:<account ID>:rule group:<rule group name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="capacity")
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.'''
        return typing.cast(jsii.Number, jsii.get(self, "capacity"))

    @capacity.setter
    def capacity(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a56c37c7bc29f2831ea729412a7f600abdd6f1d91a82d7a5effddbb927d0dfa1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "capacity", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.'''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae8ffe104c6f6915775b7c5e65eddfe2215df681e4310f44b338e7e68c3b4873)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59c44d25e9138a6e2331abe9c20e650b2a9a6f305b0d924cd2ec4eb2a2b53c82)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="availableLabels")
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]]:
        '''The labels that one or more rules in this rule group add to matching web requests.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]], jsii.get(self, "availableLabels"))

    @available_labels.setter
    def available_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87efb1e72c16cf174a66f5de7e3a1acb593ad15b2a49891fedc3a05d24744ab7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "availableLabels", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="consumedLabels")
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]]:
        '''The labels that one or more rules in this rule group match against in label match statements.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]], jsii.get(self, "consumedLabels"))

    @consumed_labels.setter
    def consumed_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__151ac040118628222af413c1e8037639c78074fcbf0820eca1183493bbc6a276)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "consumedLabels", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]]:
        '''A map of custom response keys and content bodies.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c6734af8825be0006d3866bbb0cbe92224af63291661891e57e0c75552c6b52)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a74ba4694f9055d7fa9dea9d8533dae3a9863fe2c52936a40f56b5ee621a7bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__318f59356ef5efba50745f0edba0c5a641ba203e36f7ea75fa71db32f96cdffe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c59df75c410f1ef0e87781b4669ef58e1c494a030dbd329d9d3b33e5e5689c36)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df568e15c9e5493c807ab95814a97752a3859d4a0ead8c75ede59149decb8658)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AllowProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Allow traffic towards application.

            :param custom_request_handling: Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allow.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                allow_property = wafv2.CfnRuleGroup.AllowProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0cd21728bae207efe1b926b2fbc1d23015b74ee0d958e5665ab40b1f44536fb5)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allow.html#cfn-wafv2-rulegroup-allow-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # and_statement_property_: wafv2.CfnRuleGroup.AndStatementProperty
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                and_statement_property = wafv2.CfnRuleGroup.AndStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=and_statement_property_,
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                                cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                forwarded_ip=forwarded_ip,
                                header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                http_method=http_method,
                                ip=ip,
                                ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                                    namespace="namespace"
                                ),
                                query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                )
                            )],
                            evaluation_window_sec=123,
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__563d7c7c3c7b0cea107ea61895bf83f08deacaa77dd306915bce9745256ed662)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html#cfn-wafv2-rulegroup-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BlockProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Block traffic towards application.

            :param custom_response: Custom response.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-block.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                block_property = wafv2.CfnRuleGroup.BlockProperty(
                    custom_response=wafv2.CfnRuleGroup.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__48d37744c2bde6e8969fbbe9f60128093f4d69360ff6c086fcb635ca42f3ae63)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseProperty"]]:
            '''Custom response.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-block.html#cfn-wafv2-rulegroup-block-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnRuleGroup.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__506ec9a30f623a62378d6a06c17d4d19e8ba6fd573f92a7b1c1c0344e158f1c1)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html#cfn-wafv2-rulegroup-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e374dcbd15c82dd0423abc3fb66bf99c31bc4d6a714fc65deb3dbdbc83866d7a)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnRuleGroup.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ebafa919d6724cdf183a20541551119bce7173107fdd048a66c88459d0941bc1)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html#cfn-wafv2-rulegroup-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Checks valid token exists with request.

            :param custom_request_handling: Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captcha.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_property = wafv2.CfnRuleGroup.CaptchaProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__af6223a5f7ab5465cccb92f4c58392286f808a004540f62c1e1e9129cd070b73)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captcha.html#cfn-wafv2-rulegroup-captcha-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnRuleGroup.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__62c099b656c2f0c706d5eb59ef0ae29419c316ced387e2eadf3d991364f580a9)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html#cfn-wafv2-rulegroup-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Checks that the request has a valid token with an unexpired challenge timestamp and, if not, returns a browser challenge to the client.

            :param custom_request_handling: Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challenge.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_property = wafv2.CfnRuleGroup.ChallengeProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d906d833235c5ff91003135445d7c19e5b8c861e7c39ccfa0ef7dcfd1be6ef5f)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challenge.html#cfn-wafv2-rulegroup-challenge-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ba3427cb356d43e73608b1ba33a4b697440f7941676945db2ccd811c8adec13b)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``ALL`` , AWS WAF inspects both keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnRuleGroup.CookiesProperty(
                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__687d06c7916771b985b2d22b396936b0c009299c093162a7c6c07603792055aa)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookieMatchPatternProperty"]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookieMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``ALL`` , AWS WAF inspects both keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CountProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Count traffic towards application.

            :param custom_request_handling: Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-count.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                count_property = wafv2.CfnRuleGroup.CountProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__71e61a42e92f193c85d1fcfd81493f8469fc462d68588518298fa55ac4d312ce)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''Custom request handling.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-count.html#cfn-wafv2-rulegroup-count-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling``

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3d76773fc27e7f41d84dbd4e3336cc6488a3528c4316f455a7a0ae4a9a53cbdd)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__732e127a19f06b44c67d7c677da73501e7c1d2652c4330adfb7b2c8f89bd232f)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html#cfn-wafv2-rulegroup-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__95738aad7b36944436b448ead8858c2960f4aa04ae3ab6cdecc68eb1431cec78)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to ``Block`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. You can specify any header name except for ``content-type`` . Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnRuleGroup.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a656c09c13fc139cde331d7b8cda07db864bbfa6a8458d1482a84a0c4366634e)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]]:
            '''The HTTP headers to use in the response.

            You can specify any header name except for ``content-type`` . Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "ja3_fingerprint": "ja3Fingerprint",
            "ja4_fingerprint": "ja4Fingerprint",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_fragment": "uriFragment",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.BodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            cookies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CookiesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.HeadersProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ja3_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JA3FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ja4_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JA4FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_fragment: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.UriFragmentProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''Specifies a web request component to be used in a rule match statement or in a logging configuration.

            - In a rule statement, this is the part of the web request that you want AWS WAF to inspect. Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            - In a logging configuration, this is used in the ``RedactedFields`` property to specify a field to redact from the logging records. For this use case, note the following:
            - Even though all ``FieldToMatch`` settings are available, the only valid settings for field redaction are ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .
            - In this documentation, the descriptions of the individual fields talk about specifying the web request component to inspect, but for field redaction, you are specifying the component type to redact from the logs.
            - If you have request sampling enabled, the redacted fields configuration for logging has no impact on sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param ja3_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information. .. epigraph:: You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` . You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* . Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
            :param ja4_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information. .. epigraph:: You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` . You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* . Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_fragment: Inspect fragments of the request URI. You must configure scope and pattern matching filters in the ``UriFragment`` object, to define the fragment of a URI that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the ``UriFragment`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnRuleGroup.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnRuleGroup.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dcb790c3130e52c64e6b7cf00db86b37d1b54427689c46b6c9e6a712278d0a22)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument ja3_fingerprint", value=ja3_fingerprint, expected_type=type_hints["ja3_fingerprint"])
                check_type(argname="argument ja4_fingerprint", value=ja4_fingerprint, expected_type=type_hints["ja4_fingerprint"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_fragment", value=uri_fragment, expected_type=type_hints["uri_fragment"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if ja3_fingerprint is not None:
                self._values["ja3_fingerprint"] = ja3_fingerprint
            if ja4_fingerprint is not None:
                self._values["ja4_fingerprint"] = ja4_fingerprint
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_fragment is not None:
                self._values["uri_fragment"] = uri_fragment
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.BodyProperty"]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.BodyProperty"]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookiesProperty"]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookiesProperty"]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeadersProperty"]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeadersProperty"]], result)

        @builtins.property
        def ja3_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JA3FingerprintProperty"]]:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-ja3fingerprint
            '''
            result = self._values.get("ja3_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JA3FingerprintProperty"]], result)

        @builtins.property
        def ja4_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JA4FingerprintProperty"]]:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-ja4fingerprint
            '''
            result = self._values.get("ja4_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JA4FingerprintProperty"]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonBodyProperty"]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonBodyProperty"]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_fragment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.UriFragmentProperty"]]:
            '''Inspect fragments of the request URI.

            You must configure scope and pattern matching filters in the ``UriFragment`` object, to define the fragment of a URI that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the ``UriFragment`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-urifragment
            '''
            result = self._values.get("uri_fragment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.UriFragmentProperty"]], result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f2c77ca83e05726f506d897c08097d3d52f7d5b27d7ff87dc1e895b0430f3fd)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b307fe9ca02b540fc5c0f014f6b5a63a10a4add91a9ce999d840cbd0593ce99f)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bf53983f4986a7d25fa1269a0ff0b5cd93f641c4e17e3e63be425cfea9d5fa60)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``ALL`` , AWS WAF inspects both keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnRuleGroup.HeadersProperty(
                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__68939559f5ddc50a99055ff471636da558cafd33ea1a0679c73384843b36a382)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeaderMatchPatternProperty"]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeaderMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``ALL`` , AWS WAF inspects both keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fafdfae16db1aec677d9eb805b9fce3561f7cbd357f87afbf97e39466e915dd1)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa7f79ff40e6abfc4bf693b928feb685105969a0b0d18737637b0770de375f24)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f31a0b3f57889411d82cd445b651ca6964104416a165d4f1341a7386ece7f8a2)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html#cfn-wafv2-rulegroup-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JA3FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class JA3FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a JA3 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ja3fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                j_a3_fingerprint_property = wafv2.CfnRuleGroup.JA3FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1cba50229767598d7603bfa317a8bd11cfc2b12ca28d38737119d57d5d04667d)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a JA3 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ja3fingerprint.html#cfn-wafv2-rulegroup-ja3fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JA3FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JA4FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class JA4FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a JA4 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ja4fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                j_a4_fingerprint_property = wafv2.CfnRuleGroup.JA4FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__98d25072bace816c3ee0005576dfb4321dc85cb549d85f10845ec1379f11441b)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a JA4 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ja4fingerprint.html#cfn-wafv2-rulegroup-ja4fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JA4FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            For additional information about this request component option, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``ALL`` , AWS WAF matches against keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. .. epigraph:: AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnRuleGroup.JsonBodyProperty(
                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__602ab3bf019e524b1f85e0a2cdb3225626316719b294dfa66fcfd8b7fc9e7a09)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonMatchPatternProperty"]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``ALL`` , AWS WAF matches against keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
            .. epigraph::

               AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dab2a32ecd37609031b6a2466d7e688b30c96fc1ad44abc1ef8772113d9cb2f0)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8534d6484d98965904a22ba8bb87bf13a7731fb62ca8c77473924f20bf4ef2c5)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnRuleGroup.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__192de58f3deffa379dc85491b2590e2e3f6fc48000776732b0c87dc6f1301799)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html#cfn-wafv2-rulegroup-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelSummaryProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelSummaryProperty:
        def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
            '''List of labels used by one or more of the rules of a ``RuleGroup`` .

            This summary object is used for the following rule group lists:

            - ``AvailableLabels`` - Labels that rules add to matching requests. These labels are defined in the ``RuleLabels`` for a rule.
            - ``ConsumedLabels`` - Labels that rules match against. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

            :param name: An individual label specification.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_summary_property = wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4c5532fc362b33574821b7df757d816e9a7fbb8ef8a968abb72e759637b21f08)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''An individual label specification.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html#cfn-wafv2-rulegroup-labelsummary-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelSummaryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.NotStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statement": "statement"},
    )
    class NotStatementProperty:
        def __init__(
            self,
            *,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :param statement: The statement to negate. You can use any statement that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # not_statement_property_: wafv2.CfnRuleGroup.NotStatementProperty
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                not_statement_property = wafv2.CfnRuleGroup.NotStatementProperty(
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=not_statement_property_,
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                                cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                forwarded_ip=forwarded_ip,
                                header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                http_method=http_method,
                                ip=ip,
                                ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                                    namespace="namespace"
                                ),
                                query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                )
                            )],
                            evaluation_window_sec=123,
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5739539e5cf7f8d7c902a07e2068450067fcde040af783d61ea32e816467f4b0)
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statement": statement,
            }

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]:
            '''The statement to negate.

            You can use any statement that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html#cfn-wafv2-rulegroup-notstatement-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NotStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.OrStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class OrStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :param statements: The statements to combine with OR logic. You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # or_statement_property_: wafv2.CfnRuleGroup.OrStatementProperty
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                or_statement_property = wafv2.CfnRuleGroup.OrStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=or_statement_property_,
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                                cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                forwarded_ip=forwarded_ip,
                                header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                http_method=http_method,
                                ip=ip,
                                ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                                    namespace="namespace"
                                ),
                                query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                )
                            )],
                            evaluation_window_sec=123,
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ac0f7a31c2c062eaaca70b7d43c11c1e6b78ce7502ec2206e832cabc7d2428c0)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]]:
            '''The statements to combine with OR logic.

            You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html#cfn-wafv2-rulegroup-orstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OrStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cookie": "cookie",
            "forwarded_ip": "forwardedIp",
            "header": "header",
            "http_method": "httpMethod",
            "ip": "ip",
            "ja3_fingerprint": "ja3Fingerprint",
            "ja4_fingerprint": "ja4Fingerprint",
            "label_namespace": "labelNamespace",
            "query_argument": "queryArgument",
            "query_string": "queryString",
            "uri_path": "uriPath",
        },
    )
    class RateBasedStatementCustomKeyProperty:
        def __init__(
            self,
            *,
            cookie: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitCookieProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            forwarded_ip: typing.Any = None,
            header: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitHeaderProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            http_method: typing.Any = None,
            ip: typing.Any = None,
            ja3_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitJA3FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ja4_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitJA4FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label_namespace: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitLabelNamespaceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            query_argument: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitQueryArgumentProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            query_string: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitQueryStringProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            uri_path: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateLimitUriPathProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies a single custom aggregate key for a rate-base rule.

            .. epigraph::

               Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.

            :param cookie: Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
            :param forwarded_ip: Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance. When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying ``FORWARDED_IP`` in your rate-based statement's ``AggregateKeyType`` . With this option, you must specify the header to use in the rate-based rule's ``ForwardedIPConfig`` property.
            :param header: Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
            :param http_method: Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
            :param ip: Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance. When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying ``IP`` in your rate-based statement's ``AggregateKeyType`` .
            :param ja3_fingerprint: Use the request's JA3 fingerprint as an aggregate key. If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
            :param ja4_fingerprint: Use the request's JA4 fingerprint as an aggregate key. If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
            :param label_namespace: Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance. This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL. For information about label namespaces and names, see `Label syntax and naming requirements <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html>`_ in the *AWS WAF Developer Guide* .
            :param query_argument: Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
            :param query_string: Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
            :param uri_path: Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                
                rate_based_statement_custom_key_property = wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                    cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                        name="name",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    forwarded_ip=forwarded_ip,
                    header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                        name="name",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    http_method=http_method,
                    ip=ip,
                    ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                        namespace="namespace"
                    ),
                    query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                        name="name",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6bc232408309212f7b145d76c0106073269f111e106ab6d74a4d2168f41f248b)
                check_type(argname="argument cookie", value=cookie, expected_type=type_hints["cookie"])
                check_type(argname="argument forwarded_ip", value=forwarded_ip, expected_type=type_hints["forwarded_ip"])
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
                check_type(argname="argument http_method", value=http_method, expected_type=type_hints["http_method"])
                check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
                check_type(argname="argument ja3_fingerprint", value=ja3_fingerprint, expected_type=type_hints["ja3_fingerprint"])
                check_type(argname="argument ja4_fingerprint", value=ja4_fingerprint, expected_type=type_hints["ja4_fingerprint"])
                check_type(argname="argument label_namespace", value=label_namespace, expected_type=type_hints["label_namespace"])
                check_type(argname="argument query_argument", value=query_argument, expected_type=type_hints["query_argument"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if cookie is not None:
                self._values["cookie"] = cookie
            if forwarded_ip is not None:
                self._values["forwarded_ip"] = forwarded_ip
            if header is not None:
                self._values["header"] = header
            if http_method is not None:
                self._values["http_method"] = http_method
            if ip is not None:
                self._values["ip"] = ip
            if ja3_fingerprint is not None:
                self._values["ja3_fingerprint"] = ja3_fingerprint
            if ja4_fingerprint is not None:
                self._values["ja4_fingerprint"] = ja4_fingerprint
            if label_namespace is not None:
                self._values["label_namespace"] = label_namespace
            if query_argument is not None:
                self._values["query_argument"] = query_argument
            if query_string is not None:
                self._values["query_string"] = query_string
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def cookie(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitCookieProperty"]]:
            '''Use the value of a cookie in the request as an aggregate key.

            Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-cookie
            '''
            result = self._values.get("cookie")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitCookieProperty"]], result)

        @builtins.property
        def forwarded_ip(self) -> typing.Any:
            '''Use the first IP address in an HTTP header as an aggregate key.

            Each distinct forwarded IP address contributes to the aggregation instance.

            When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying ``FORWARDED_IP`` in your rate-based statement's ``AggregateKeyType`` .

            With this option, you must specify the header to use in the rate-based rule's ``ForwardedIPConfig`` property.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-forwardedip
            '''
            result = self._values.get("forwarded_ip")
            return typing.cast(typing.Any, result)

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitHeaderProperty"]]:
            '''Use the value of a header in the request as an aggregate key.

            Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitHeaderProperty"]], result)

        @builtins.property
        def http_method(self) -> typing.Any:
            '''Use the request's HTTP method as an aggregate key.

            Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-httpmethod
            '''
            result = self._values.get("http_method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def ip(self) -> typing.Any:
            '''Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.

            When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying ``IP`` in your rate-based statement's ``AggregateKeyType`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-ip
            '''
            result = self._values.get("ip")
            return typing.cast(typing.Any, result)

        @builtins.property
        def ja3_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitJA3FingerprintProperty"]]:
            '''Use the request's JA3 fingerprint as an aggregate key.

            If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-ja3fingerprint
            '''
            result = self._values.get("ja3_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitJA3FingerprintProperty"]], result)

        @builtins.property
        def ja4_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitJA4FingerprintProperty"]]:
            '''Use the request's JA4 fingerprint as an aggregate key.

            If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-ja4fingerprint
            '''
            result = self._values.get("ja4_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitJA4FingerprintProperty"]], result)

        @builtins.property
        def label_namespace(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitLabelNamespaceProperty"]]:
            '''Use the specified label namespace as an aggregate key.

            Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.

            This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.

            For information about label namespaces and names, see `Label syntax and naming requirements <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-labelnamespace
            '''
            result = self._values.get("label_namespace")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitLabelNamespaceProperty"]], result)

        @builtins.property
        def query_argument(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitQueryArgumentProperty"]]:
            '''Use the specified query argument as an aggregate key.

            Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-queryargument
            '''
            result = self._values.get("query_argument")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitQueryArgumentProperty"]], result)

        @builtins.property
        def query_string(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitQueryStringProperty"]]:
            '''Use the request's query string as an aggregate key.

            Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitQueryStringProperty"]], result)

        @builtins.property
        def uri_path(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitUriPathProperty"]]:
            '''Use the request's URI path as an aggregate key.

            Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementcustomkey.html#cfn-wafv2-rulegroup-ratebasedstatementcustomkey-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateLimitUriPathProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateBasedStatementCustomKeyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aggregate_key_type": "aggregateKeyType",
            "limit": "limit",
            "custom_keys": "customKeys",
            "evaluation_window_sec": "evaluationWindowSec",
            "forwarded_ip_config": "forwardedIpConfig",
            "scope_down_statement": "scopeDownStatement",
        },
    )
    class RateBasedStatementProperty:
        def __init__(
            self,
            *,
            aggregate_key_type: builtins.str,
            limit: jsii.Number,
            custom_keys: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateBasedStatementCustomKeyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            evaluation_window_sec: typing.Optional[jsii.Number] = None,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            scope_down_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate.

            The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
            .. epigraph::

               If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute.

            You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.

            Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.

            For example, assume the rule evaluates web requests with the following IP address and HTTP method values:

            - IP address 10.1.1.1, HTTP method POST
            - IP address 10.1.1.1, HTTP method GET
            - IP address 127.0.0.0, HTTP method POST
            - IP address 10.1.1.1, HTTP method GET

            The rule would create different aggregation instances according to your aggregation criteria, for example:

            - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
            - IP address 10.1.1.1: count 3
            - IP address 127.0.0.0: count 1
            - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
            - HTTP method POST: count 2
            - HTTP method GET: count 2
            - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
            - IP address 10.1.1.1, HTTP method POST: count 1
            - IP address 10.1.1.1, HTTP method GET: count 2
            - IP address 127.0.0.0, HTTP method POST: count 1

            For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            For additional information about the options, see `Rate limiting web requests using rate-based rules <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html>`_ in the *AWS WAF Developer Guide* .

            If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call ``GetRateBasedStatementManagedKeys`` . This option is not available for other aggregation configurations.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            :param aggregate_key_type: Setting that indicates how to aggregate the request counts. .. epigraph:: Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. - ``CONSTANT`` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement. With this option, you must configure the ``ScopeDownStatement`` property. - ``CUSTOM_KEYS`` - Aggregate the request counts using one or more web request components as the aggregate keys. With this option, you must specify the aggregate keys in the ``CustomKeys`` property. To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to ``IP`` or ``FORWARDED_IP`` . - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header. With this option, you must specify the header to use in the ``ForwardedIPConfig`` property. To aggregate on a combination of the forwarded IP address with other aggregate keys, use ``CUSTOM_KEYS`` . - ``IP`` - Aggregate the request counts on the IP address from the web request origin. To aggregate on a combination of the IP address with other aggregate keys, use ``CUSTOM_KEYS`` .
            :param limit: The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. If the rate-based statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement. Examples: - If you aggregate on just the IP address, this is the limit on requests from any single IP address. - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.
            :param custom_keys: Specifies the aggregate keys to use in a rate-base rule.
            :param evaluation_window_sec: The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600. This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds. Default: ``300`` (5 minutes)
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. This is required if you specify a forwarded IP in the rule's aggregate key settings.
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # query_string: Any
                # rate_based_statement_property_: wafv2.CfnRuleGroup.RateBasedStatementProperty
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rate_based_statement_property = wafv2.CfnRuleGroup.RateBasedStatementProperty(
                    aggregate_key_type="aggregateKeyType",
                    limit=123,
                
                    # the properties below are optional
                    custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                        cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                            name="name",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        forwarded_ip=forwarded_ip,
                        header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                            name="name",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        http_method=http_method,
                        ip=ip,
                        ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                            namespace="namespace"
                        ),
                        query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                            name="name",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )],
                    evaluation_window_sec=123,
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    ),
                    scope_down_statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=rate_based_statement_property_,
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__39e60064f8f4286866d2fa7f3c5494f2a2f33a4179f5370836b825ab35a02e19)
                check_type(argname="argument aggregate_key_type", value=aggregate_key_type, expected_type=type_hints["aggregate_key_type"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument custom_keys", value=custom_keys, expected_type=type_hints["custom_keys"])
                check_type(argname="argument evaluation_window_sec", value=evaluation_window_sec, expected_type=type_hints["evaluation_window_sec"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
                check_type(argname="argument scope_down_statement", value=scope_down_statement, expected_type=type_hints["scope_down_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "aggregate_key_type": aggregate_key_type,
                "limit": limit,
            }
            if custom_keys is not None:
                self._values["custom_keys"] = custom_keys
            if evaluation_window_sec is not None:
                self._values["evaluation_window_sec"] = evaluation_window_sec
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config
            if scope_down_statement is not None:
                self._values["scope_down_statement"] = scope_down_statement

        @builtins.property
        def aggregate_key_type(self) -> builtins.str:
            '''Setting that indicates how to aggregate the request counts.

            .. epigraph::

               Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.

            - ``CONSTANT`` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.

            With this option, you must configure the ``ScopeDownStatement`` property.

            - ``CUSTOM_KEYS`` - Aggregate the request counts using one or more web request components as the aggregate keys.

            With this option, you must specify the aggregate keys in the ``CustomKeys`` property.

            To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to ``IP`` or ``FORWARDED_IP`` .

            - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header.

            With this option, you must specify the header to use in the ``ForwardedIPConfig`` property.

            To aggregate on a combination of the forwarded IP address with other aggregate keys, use ``CUSTOM_KEYS`` .

            - ``IP`` - Aggregate the request counts on the IP address from the web request origin.

            To aggregate on a combination of the IP address with other aggregate keys, use ``CUSTOM_KEYS`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-aggregatekeytype
            '''
            result = self._values.get("aggregate_key_type")
            assert result is not None, "Required property 'aggregate_key_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def limit(self) -> jsii.Number:
            '''The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule.

            If the rate-based statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.

            Examples:

            - If you aggregate on just the IP address, this is the limit on requests from any single IP address.
            - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-limit
            '''
            result = self._values.get("limit")
            assert result is not None, "Required property 'limit' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_keys(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementCustomKeyProperty"]]]]:
            '''Specifies the aggregate keys to use in a rate-base rule.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-customkeys
            '''
            result = self._values.get("custom_keys")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementCustomKeyProperty"]]]], result)

        @builtins.property
        def evaluation_window_sec(self) -> typing.Optional[jsii.Number]:
            '''The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time.

            For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.

            This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.

            Default: ``300`` (5 minutes)

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-evaluationwindowsec
            '''
            result = self._values.get("evaluation_window_sec")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This is required if you specify a forwarded IP in the rule's aggregate key settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]], result)

        @builtins.property
        def scope_down_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]:
            '''An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement.

            When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-scopedownstatement
            '''
            result = self._values.get("scope_down_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateBasedStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitCookieProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "text_transformations": "textTransformations"},
    )
    class RateLimitCookieProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies a cookie as an aggregate key for a rate-based rule.

            Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.

            :param name: The name of the cookie to use.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitcookie.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_cookie_property = wafv2.CfnRuleGroup.RateLimitCookieProperty(
                    name="name",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__69f61b5947aab5ca5b47cef4e89f205f3b70cadd5f98a174f3e9e3ed87f82699)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the cookie to use.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitcookie.html#cfn-wafv2-rulegroup-ratelimitcookie-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitcookie.html#cfn-wafv2-rulegroup-ratelimitcookie-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitCookieProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "text_transformations": "textTransformations"},
    )
    class RateLimitHeaderProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies a header as an aggregate key for a rate-based rule.

            Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.

            :param name: The name of the header to use.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_header_property = wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                    name="name",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fdb02cef74b9bb28719ad3e0dbe3149e38c2bcf0347d4db5a38e8fae7fdc78d2)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the header to use.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitheader.html#cfn-wafv2-rulegroup-ratelimitheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitheader.html#cfn-wafv2-rulegroup-ratelimitheader-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class RateLimitJA3FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Use the request's JA3 fingerprint derived from the TLS Client Hello of an incoming request as an aggregate key.

            If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.

            :param fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitja3fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_jA3_fingerprint_property = wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__01cbbd4025c041374160f1ace2284204fed871076ebb05f8dbb9425055cf3060)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitja3fingerprint.html#cfn-wafv2-rulegroup-ratelimitja3fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitJA3FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class RateLimitJA4FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Use the request's JA4 fingerprint derived from the TLS Client Hello of an incoming request as an aggregate key.

            If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.

            :param fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitja4fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_jA4_fingerprint_property = wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7133c91d3834ea8b9f0c3938b2bfa71b20890314ee89527acbfc32927f991d59)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitja4fingerprint.html#cfn-wafv2-rulegroup-ratelimitja4fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitJA4FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty",
        jsii_struct_bases=[],
        name_mapping={"namespace": "namespace"},
    )
    class RateLimitLabelNamespaceProperty:
        def __init__(self, *, namespace: builtins.str) -> None:
            '''Specifies a label namespace to use as an aggregate key for a rate-based rule.

            Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.

            This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.

            For information about label namespaces and names, see `Label syntax and naming requirements <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html>`_ in the *AWS WAF Developer Guide* .

            :param namespace: The namespace to use for aggregation.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitlabelnamespace.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_label_namespace_property = wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                    namespace="namespace"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1b9d57259a6a98849a716499d960fb16a9c2fff26fa8916f287a6d4cbe4a1303)
                check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "namespace": namespace,
            }

        @builtins.property
        def namespace(self) -> builtins.str:
            '''The namespace to use for aggregation.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitlabelnamespace.html#cfn-wafv2-rulegroup-ratelimitlabelnamespace-namespace
            '''
            result = self._values.get("namespace")
            assert result is not None, "Required property 'namespace' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitLabelNamespaceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "text_transformations": "textTransformations"},
    )
    class RateLimitQueryArgumentProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies a query argument in the request as an aggregate key for a rate-based rule.

            Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.

            :param name: The name of the query argument to use.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitqueryargument.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_query_argument_property = wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                    name="name",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b966b3baf1e53a4cd2c905bd9250bc3fa1d56501f88e4652a5c916da55d0bbc0)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query argument to use.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitqueryargument.html#cfn-wafv2-rulegroup-ratelimitqueryargument-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitqueryargument.html#cfn-wafv2-rulegroup-ratelimitqueryargument-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitQueryArgumentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitQueryStringProperty",
        jsii_struct_bases=[],
        name_mapping={"text_transformations": "textTransformations"},
    )
    class RateLimitQueryStringProperty:
        def __init__(
            self,
            *,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies the request's query string as an aggregate key for a rate-based rule.

            Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.

            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitquerystring.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_query_string_property = wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__15cacccbea021d81553d6f2341534b64a1e385555ac80619807c38e159cc7f4c)
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "text_transformations": text_transformations,
            }

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimitquerystring.html#cfn-wafv2-rulegroup-ratelimitquerystring-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitQueryStringProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateLimitUriPathProperty",
        jsii_struct_bases=[],
        name_mapping={"text_transformations": "textTransformations"},
    )
    class RateLimitUriPathProperty:
        def __init__(
            self,
            *,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies the request's URI path as an aggregate key for a rate-based rule.

            Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.

            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimituripath.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rate_limit_uri_path_property = wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__100f4253de93cd02c5b6035a90c4aacc853e80d375f82214e8de501cc870886f)
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "text_transformations": text_transformations,
            }

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            Text transformations are used in rule match statements, to transform the ``FieldToMatch`` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratelimituripath.html#cfn-wafv2-rulegroup-ratelimituripath-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateLimitUriPathProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "regex_string": "regexString",
            "text_transformations": "textTransformations",
        },
    )
    class RegexMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            regex_string: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param regex_string: The string representing the regular expression.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_match_statement_property = wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    regex_string="regexString",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__19f93168f4e99e1fefe30605a0c36c70d5669dc501d923863dc01b02ed09edc1)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument regex_string", value=regex_string, expected_type=type_hints["regex_string"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "regex_string": regex_string,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def regex_string(self) -> builtins.str:
            '''The string representing the regular expression.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-regexstring
            '''
            result = self._values.get("regex_string")
            assert result is not None, "Required property 'regex_string' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class RegexPatternSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_pattern_set_reference_statement_property = wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                    arn="arn",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6910c2b882b693ee6a9ebfe30a376f3d75e7230122900daff24df6b399d3ba4e)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexPatternSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleActionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow": "allow",
            "block": "block",
            "captcha": "captcha",
            "challenge": "challenge",
            "count": "count",
        },
    )
    class RuleActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Any = None,
            block: typing.Any = None,
            captcha: typing.Any = None,
            challenge: typing.Any = None,
            count: typing.Any = None,
        ) -> None:
            '''The action that AWS WAF should take on a web request when it matches a rule's statement.

            Settings at the web ACL level can override the rule action setting.

            :param allow: Instructs AWS WAF to allow the web request.
            :param block: Instructs AWS WAF to block the web request.
            :param captcha: Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:. - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` . - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination. AWS WAF generates a response that it sends back to the client, which includes the following: - The header ``x-amzn-waf-action`` with a value of ``captcha`` . - The HTTP status code ``405 Method Not Allowed`` . - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge. You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting. This action option is available for rules. It isn't available for web ACL default actions.
            :param challenge: Instructs AWS WAF to run a ``Challenge`` check against the web request.
            :param count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # allow: Any
                # block: Any
                # captcha: Any
                # challenge: Any
                # count: Any
                
                rule_action_property = wafv2.CfnRuleGroup.RuleActionProperty(
                    allow=allow,
                    block=block,
                    captcha=captcha,
                    challenge=challenge,
                    count=count
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__39522e2876cae159806be752e9ce4c0e4fb8f4dd0ef92591b3957abd0202b035)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
                check_type(argname="argument captcha", value=captcha, expected_type=type_hints["captcha"])
                check_type(argname="argument challenge", value=challenge, expected_type=type_hints["challenge"])
                check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block
            if captcha is not None:
                self._values["captcha"] = captcha
            if challenge is not None:
                self._values["challenge"] = challenge
            if count is not None:
                self._values["count"] = count

        @builtins.property
        def allow(self) -> typing.Any:
            '''Instructs AWS WAF to allow the web request.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Any, result)

        @builtins.property
        def block(self) -> typing.Any:
            '''Instructs AWS WAF to block the web request.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Any, result)

        @builtins.property
        def captcha(self) -> typing.Any:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-captcha
            '''
            result = self._values.get("captcha")
            return typing.cast(typing.Any, result)

        @builtins.property
        def challenge(self) -> typing.Any:
            '''Instructs AWS WAF to run a ``Challenge`` check against the web request.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-challenge
            '''
            result = self._values.get("challenge")
            return typing.cast(typing.Any, result)

        @builtins.property
        def count(self) -> typing.Any:
            '''Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-count
            '''
            result = self._values.get("count")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "priority": "priority",
            "statement": "statement",
            "visibility_config": "visibilityConfig",
            "action": "action",
            "captcha_config": "captchaConfig",
            "challenge_config": "challengeConfig",
            "rule_labels": "ruleLabels",
        },
    )
    class RuleProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            priority: jsii.Number,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
            visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            action: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RuleActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            captcha_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            challenge_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rule_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A single rule, which you can use in a ``WebACL`` or ``RuleGroup`` to identify web requests that you want to manage in some way.

            Each rule includes one top-level ``Statement`` that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

            :param name: The name of the rule. If you change the name of a ``Rule`` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's ``VisibilityConfig`` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.
            :param priority: If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
            :param statement: The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .
            :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection. If you change the name of a ``Rule`` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.
            :param action: The action that AWS WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
            :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations. If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.
            :param challenge_config: Specifies how AWS WAF should handle ``Challenge`` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
            :param rule_labels: Labels to apply to web requests that match the rule match statement. AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace. .. epigraph:: Any rule that isn't a rule group reference statement or managed rule group statement can add labels to matching web requests. Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` . For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines: - Separate each component of the label with a colon. - Each namespace or name can have up to 128 characters. - You can specify up to 5 namespaces in a label. - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` . For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # allow: Any
                # all_query_arguments: Any
                # block: Any
                # captcha: Any
                # challenge: Any
                # count: Any
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rule_property = wafv2.CfnRuleGroup.RuleProperty(
                    name="name",
                    priority=123,
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                                cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                forwarded_ip=forwarded_ip,
                                header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                http_method=http_method,
                                ip=ip,
                                ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                                    namespace="namespace"
                                ),
                                query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                                    name="name",
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                ),
                                uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                        priority=123,
                                        type="type"
                                    )]
                                )
                            )],
                            evaluation_window_sec=123,
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                    fallback_behavior="fallbackBehavior"
                                ),
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    ),
                    visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                        cloud_watch_metrics_enabled=False,
                        metric_name="metricName",
                        sampled_requests_enabled=False
                    ),
                
                    # the properties below are optional
                    action=wafv2.CfnRuleGroup.RuleActionProperty(
                        allow=allow,
                        block=block,
                        captcha=captcha,
                        challenge=challenge,
                        count=count
                    ),
                    captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                        name="name"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__015056668c1a8717f25fff39a27fc12627cce51740c1528d560a3e6eb644647e)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
                check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
                check_type(argname="argument captcha_config", value=captcha_config, expected_type=type_hints["captcha_config"])
                check_type(argname="argument challenge_config", value=challenge_config, expected_type=type_hints["challenge_config"])
                check_type(argname="argument rule_labels", value=rule_labels, expected_type=type_hints["rule_labels"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "priority": priority,
                "statement": statement,
                "visibility_config": visibility_config,
            }
            if action is not None:
                self._values["action"] = action
            if captcha_config is not None:
                self._values["captcha_config"] = captcha_config
            if challenge_config is not None:
                self._values["challenge_config"] = challenge_config
            if rule_labels is not None:
                self._values["rule_labels"] = rule_labels

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule.

            If you change the name of a ``Rule`` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's ``VisibilityConfig`` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def priority(self) -> jsii.Number:
            '''If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` .

            AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]:
            '''The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"], result)

        @builtins.property
        def visibility_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"]:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            If you change the name of a ``Rule`` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-visibilityconfig
            '''
            result = self._values.get("visibility_config")
            assert result is not None, "Required property 'visibility_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"], result)

        @builtins.property
        def action(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleActionProperty"]]:
            '''The action that AWS WAF should take on a web request when it matches the rule statement.

            Settings at the web ACL level can override the rule action setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-action
            '''
            result = self._values.get("action")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleActionProperty"]], result)

        @builtins.property
        def captcha_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CaptchaConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-captchaconfig
            '''
            result = self._values.get("captcha_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CaptchaConfigProperty"]], result)

        @builtins.property
        def challenge_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ChallengeConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-challengeconfig
            '''
            result = self._values.get("challenge_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ChallengeConfigProperty"]], result)

        @builtins.property
        def rule_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelProperty"]]]]:
            '''Labels to apply to web requests that match the rule match statement.

            AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
            .. epigraph::

               Any rule that isn't a rule group reference statement or managed rule group statement can add labels to matching web requests.

            Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` .

            For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:

            - Separate each component of the label with a colon.
            - Each namespace or name can have up to 128 characters.
            - You can specify up to 5 namespaces in a label.
            - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` .

            For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-rulelabels
            '''
            result = self._values.get("rule_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnRuleGroup.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5cf567bf196203e16e1454b52367471780e0889d630c732027d4071cd2ab8640)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html#cfn-wafv2-rulegroup-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleQueryArgumentProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleQueryArgumentProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one query argument in the web request, identified by name, for example *UserName* or *SalesRegion* .

            The name isn't case sensitive.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :param name: The name of the query argument to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_query_argument_property = wafv2.CfnRuleGroup.SingleQueryArgumentProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f1ca125c090766441fe7b0776cf806a069b05f4a71f38f8657e8d10c4988ede)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query argument to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html#cfn-wafv2-rulegroup-singlequeryargument-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleQueryArgumentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "comparison_operator": "comparisonOperator",
            "field_to_match": "fieldToMatch",
            "size": "size",
            "text_transformations": "textTransformations",
        },
    )
    class SizeConstraintStatementProperty:
        def __init__(
            self,
            *,
            comparison_operator: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            size: jsii.Number,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see ``Body`` and ``JsonBody`` settings for the ``FieldToMatch`` data type.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :param comparison_operator: The operator to use to compare the request part to the size setting.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param size: The size, in byte, to compare to the request part, after any transformations.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                size_constraint_statement_property = wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                    comparison_operator="comparisonOperator",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    size=123,
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b4e71477ea891ae9537f70f2a7ad51756ce844f8e608371a6a7e0b43d47bcf37)
                check_type(argname="argument comparison_operator", value=comparison_operator, expected_type=type_hints["comparison_operator"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument size", value=size, expected_type=type_hints["size"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "comparison_operator": comparison_operator,
                "field_to_match": field_to_match,
                "size": size,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def comparison_operator(self) -> builtins.str:
            '''The operator to use to compare the request part to the size setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-comparisonoperator
            '''
            result = self._values.get("comparison_operator")
            assert result is not None, "Required property 'comparison_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def size(self) -> jsii.Number:
            '''The size, in byte, to compare to the request part, after any transformations.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-size
            '''
            result = self._values.get("size")
            assert result is not None, "Required property 'size' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SizeConstraintStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
            "sensitivity_level": "sensitivityLevel",
        },
    )
    class SqliMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            sensitivity_level: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* . ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives. Default: ``LOW``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                sqli_match_statement_property = wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    sensitivity_level="sensitivityLevel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b9ae549bd77f9cf10d97954d1e78a797db181843dcc5510b91fc32672eee8542)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument sensitivity_level", value=sensitivity_level, expected_type=type_hints["sensitivity_level"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }
            if sensitivity_level is not None:
                self._values["sensitivity_level"] = sensitivity_level

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        @builtins.property
        def sensitivity_level(self) -> typing.Optional[builtins.str]:
            '''The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.

            ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* .

            ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.

            Default: ``LOW``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-sensitivitylevel
            '''
            result = self._values.get("sensitivity_level")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SqliMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.StatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "and_statement": "andStatement",
            "byte_match_statement": "byteMatchStatement",
            "geo_match_statement": "geoMatchStatement",
            "ip_set_reference_statement": "ipSetReferenceStatement",
            "label_match_statement": "labelMatchStatement",
            "not_statement": "notStatement",
            "or_statement": "orStatement",
            "rate_based_statement": "rateBasedStatement",
            "regex_match_statement": "regexMatchStatement",
            "regex_pattern_set_reference_statement": "regexPatternSetReferenceStatement",
            "size_constraint_statement": "sizeConstraintStatement",
            "sqli_match_statement": "sqliMatchStatement",
            "xss_match_statement": "xssMatchStatement",
        },
    )
    class StatementProperty:
        def __init__(
            self,
            *,
            and_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.AndStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            byte_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ByteMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            geo_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.GeoMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ip_set_reference_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.IPSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            not_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.NotStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            or_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.OrStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rate_based_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateBasedStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            regex_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RegexMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            regex_pattern_set_reference_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RegexPatternSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            size_constraint_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.SizeConstraintStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sqli_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.SqliMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            xss_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.XssMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The processing guidance for a rule, used by AWS WAF to determine whether a web request matches the rule.

            :param and_statement: A logical rule statement used to combine other rule statements with AND logic. You provide more than one ``Statement`` within the ``AndStatement`` .
            :param byte_match_statement: A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
            :param geo_match_statement: A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match. - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array. - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed. AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` . If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` . If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` . For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param ip_set_reference_statement: A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement. Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param label_match_statement: A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL. The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
            :param not_statement: A logical rule statement used to negate the results of another rule statement. You provide one ``Statement`` within the ``NotStatement`` .
            :param or_statement: A logical rule statement used to combine other rule statements with OR logic. You provide more than one ``Statement`` within the ``OrStatement`` .
            :param rate_based_statement: A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance. .. epigraph:: If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute. You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie. Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition. For example, assume the rule evaluates web requests with the following IP address and HTTP method values: - IP address 10.1.1.1, HTTP method POST - IP address 10.1.1.1, HTTP method GET - IP address 127.0.0.0, HTTP method POST - IP address 10.1.1.1, HTTP method GET The rule would create different aggregation instances according to your aggregation criteria, for example: - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following: - IP address 10.1.1.1: count 3 - IP address 127.0.0.0: count 1 - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following: - HTTP method POST: count 2 - HTTP method GET: count 2 - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following: - IP address 10.1.1.1, HTTP method POST: count 1 - IP address 10.1.1.1, HTTP method GET: count 2 - IP address 127.0.0.0, HTTP method POST: count 1 For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually. You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule. You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group. For additional information about the options, see `Rate limiting web requests using rate-based rules <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html>`_ in the *AWS WAF Developer Guide* . If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call ``GetRateBasedStatementManagedKeys`` . This option is not available for other aggregation configurations. AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
            :param regex_match_statement: A rule statement used to search web request components for a match against a single regular expression.
            :param regex_pattern_set_reference_statement: A rule statement used to search web request components for matches with regular expressions. To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param size_constraint_statement: A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see ``Body`` and ``JsonBody`` settings for the ``FieldToMatch`` data type. If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.
            :param sqli_match_statement: A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
            :param xss_match_statement: A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # forwarded_ip: Any
                # http_method: Any
                # ip: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                statement_property = wafv2.CfnRuleGroup.StatementProperty(
                    and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                        statements=[statement_property_]
                    ),
                    byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        positional_constraint="positionalConstraint",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
                
                        # the properties below are optional
                        search_string="searchString",
                        search_string_base64="searchStringBase64"
                    ),
                    geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                        country_codes=["countryCodes"],
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        )
                    ),
                    ip_set_reference_statement={
                        "arn": "arn",
                
                        # the properties below are optional
                        "ip_set_forwarded_ip_config": {
                            "fallback_behavior": "fallbackBehavior",
                            "header_name": "headerName",
                            "position": "position"
                        }
                    },
                    label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                        key="key",
                        scope="scope"
                    ),
                    not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                        statement=statement_property_
                    ),
                    or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                        statements=[statement_property_]
                    ),
                    rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                        aggregate_key_type="aggregateKeyType",
                        limit=123,
                
                        # the properties below are optional
                        custom_keys=[wafv2.CfnRuleGroup.RateBasedStatementCustomKeyProperty(
                            cookie=wafv2.CfnRuleGroup.RateLimitCookieProperty(
                                name="name",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            forwarded_ip=forwarded_ip,
                            header=wafv2.CfnRuleGroup.RateLimitHeaderProperty(
                                name="name",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            http_method=http_method,
                            ip=ip,
                            ja3_fingerprint=wafv2.CfnRuleGroup.RateLimitJA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.RateLimitJA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            label_namespace=wafv2.CfnRuleGroup.RateLimitLabelNamespaceProperty(
                                namespace="namespace"
                            ),
                            query_argument=wafv2.CfnRuleGroup.RateLimitQueryArgumentProperty(
                                name="name",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            query_string=wafv2.CfnRuleGroup.RateLimitQueryStringProperty(
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            uri_path=wafv2.CfnRuleGroup.RateLimitUriPathProperty(
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            )
                        )],
                        evaluation_window_sec=123,
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        ),
                        scope_down_statement=statement_property_
                    ),
                    regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        regex_string="regexString",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                        arn="arn",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                        comparison_operator="comparisonOperator",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        size=123,
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
                
                        # the properties below are optional
                        sensitivity_level="sensitivityLevel"
                    ),
                    xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                                fallback_behavior="fallbackBehavior"
                            ),
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c10bc3e3f69d89ad06f25a44daee62e7de586ae4280e39230f29c24092fe4a4f)
                check_type(argname="argument and_statement", value=and_statement, expected_type=type_hints["and_statement"])
                check_type(argname="argument byte_match_statement", value=byte_match_statement, expected_type=type_hints["byte_match_statement"])
                check_type(argname="argument geo_match_statement", value=geo_match_statement, expected_type=type_hints["geo_match_statement"])
                check_type(argname="argument ip_set_reference_statement", value=ip_set_reference_statement, expected_type=type_hints["ip_set_reference_statement"])
                check_type(argname="argument label_match_statement", value=label_match_statement, expected_type=type_hints["label_match_statement"])
                check_type(argname="argument not_statement", value=not_statement, expected_type=type_hints["not_statement"])
                check_type(argname="argument or_statement", value=or_statement, expected_type=type_hints["or_statement"])
                check_type(argname="argument rate_based_statement", value=rate_based_statement, expected_type=type_hints["rate_based_statement"])
                check_type(argname="argument regex_match_statement", value=regex_match_statement, expected_type=type_hints["regex_match_statement"])
                check_type(argname="argument regex_pattern_set_reference_statement", value=regex_pattern_set_reference_statement, expected_type=type_hints["regex_pattern_set_reference_statement"])
                check_type(argname="argument size_constraint_statement", value=size_constraint_statement, expected_type=type_hints["size_constraint_statement"])
                check_type(argname="argument sqli_match_statement", value=sqli_match_statement, expected_type=type_hints["sqli_match_statement"])
                check_type(argname="argument xss_match_statement", value=xss_match_statement, expected_type=type_hints["xss_match_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if and_statement is not None:
                self._values["and_statement"] = and_statement
            if byte_match_statement is not None:
                self._values["byte_match_statement"] = byte_match_statement
            if geo_match_statement is not None:
                self._values["geo_match_statement"] = geo_match_statement
            if ip_set_reference_statement is not None:
                self._values["ip_set_reference_statement"] = ip_set_reference_statement
            if label_match_statement is not None:
                self._values["label_match_statement"] = label_match_statement
            if not_statement is not None:
                self._values["not_statement"] = not_statement
            if or_statement is not None:
                self._values["or_statement"] = or_statement
            if rate_based_statement is not None:
                self._values["rate_based_statement"] = rate_based_statement
            if regex_match_statement is not None:
                self._values["regex_match_statement"] = regex_match_statement
            if regex_pattern_set_reference_statement is not None:
                self._values["regex_pattern_set_reference_statement"] = regex_pattern_set_reference_statement
            if size_constraint_statement is not None:
                self._values["size_constraint_statement"] = size_constraint_statement
            if sqli_match_statement is not None:
                self._values["sqli_match_statement"] = sqli_match_statement
            if xss_match_statement is not None:
                self._values["xss_match_statement"] = xss_match_statement

        @builtins.property
        def and_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.AndStatementProperty"]]:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-andstatement
            '''
            result = self._values.get("and_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.AndStatementProperty"]], result)

        @builtins.property
        def byte_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ByteMatchStatementProperty"]]:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-bytematchstatement
            '''
            result = self._values.get("byte_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ByteMatchStatementProperty"]], result)

        @builtins.property
        def geo_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.GeoMatchStatementProperty"]]:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-geomatchstatement
            '''
            result = self._values.get("geo_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.GeoMatchStatementProperty"]], result)

        @builtins.property
        def ip_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetReferenceStatementProperty"]]:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ipsetreferencestatement
            '''
            result = self._values.get("ip_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetReferenceStatementProperty"]], result)

        @builtins.property
        def label_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelMatchStatementProperty"]]:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-labelmatchstatement
            '''
            result = self._values.get("label_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelMatchStatementProperty"]], result)

        @builtins.property
        def not_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.NotStatementProperty"]]:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-notstatement
            '''
            result = self._values.get("not_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.NotStatementProperty"]], result)

        @builtins.property
        def or_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.OrStatementProperty"]]:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-orstatement
            '''
            result = self._values.get("or_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.OrStatementProperty"]], result)

        @builtins.property
        def rate_based_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementProperty"]]:
            '''A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate.

            The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
            .. epigraph::

               If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute.

            You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.

            Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.

            For example, assume the rule evaluates web requests with the following IP address and HTTP method values:

            - IP address 10.1.1.1, HTTP method POST
            - IP address 10.1.1.1, HTTP method GET
            - IP address 127.0.0.0, HTTP method POST
            - IP address 10.1.1.1, HTTP method GET

            The rule would create different aggregation instances according to your aggregation criteria, for example:

            - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
            - IP address 10.1.1.1: count 3
            - IP address 127.0.0.0: count 1
            - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
            - HTTP method POST: count 2
            - HTTP method GET: count 2
            - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
            - IP address 10.1.1.1, HTTP method POST: count 1
            - IP address 10.1.1.1, HTTP method GET: count 2
            - IP address 127.0.0.0, HTTP method POST: count 1

            For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            For additional information about the options, see `Rate limiting web requests using rate-based rules <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html>`_ in the *AWS WAF Developer Guide* .

            If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call ``GetRateBasedStatementManagedKeys`` . This option is not available for other aggregation configurations.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ratebasedstatement
            '''
            result = self._values.get("rate_based_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementProperty"]], result)

        @builtins.property
        def regex_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexMatchStatementProperty"]]:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexmatchstatement
            '''
            result = self._values.get("regex_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexMatchStatementProperty"]], result)

        @builtins.property
        def regex_pattern_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexPatternSetReferenceStatementProperty"]]:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexpatternsetreferencestatement
            '''
            result = self._values.get("regex_pattern_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexPatternSetReferenceStatementProperty"]], result)

        @builtins.property
        def size_constraint_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SizeConstraintStatementProperty"]]:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see ``Body`` and ``JsonBody`` settings for the ``FieldToMatch`` data type.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sizeconstraintstatement
            '''
            result = self._values.get("size_constraint_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SizeConstraintStatementProperty"]], result)

        @builtins.property
        def sqli_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SqliMatchStatementProperty"]]:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sqlimatchstatement
            '''
            result = self._values.get("sqli_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SqliMatchStatementProperty"]], result)

        @builtins.property
        def xss_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.XssMatchStatementProperty"]]:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-xssmatchstatement
            '''
            result = self._values.get("xss_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.XssMatchStatementProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.TextTransformationProperty",
        jsii_struct_bases=[],
        name_mapping={"priority": "priority", "type": "type"},
    )
    class TextTransformationProperty:
        def __init__(self, *, priority: jsii.Number, type: builtins.str) -> None:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            :param priority: Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
            :param type: For detailed descriptions of each of the transformation types, see `Text transformations <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                text_transformation_property = wafv2.CfnRuleGroup.TextTransformationProperty(
                    priority=123,
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cbdf04ef9e923368f792f61fdb73e804a219fcd9c66ffb20e85214a5a0861eae)
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "priority": priority,
                "type": type,
            }

        @builtins.property
        def priority(self) -> jsii.Number:
            '''Sets the relative processing order for multiple transformations.

            AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def type(self) -> builtins.str:
            '''For detailed descriptions of each of the transformation types, see `Text transformations <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TextTransformationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.UriFragmentProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class UriFragmentProperty:
        def __init__(
            self,
            *,
            fallback_behavior: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect fragments of the request URI.

            You can specify the parts of the URI fragment to inspect and you can narrow the set of URI fragments to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"UriFragment": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. Example JSON: ``{ "UriFragment": { "FallbackBehavior": "MATCH"} }`` .. epigraph:: AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-urifragment.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                uri_fragment_property = wafv2.CfnRuleGroup.UriFragmentProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fe1c476d259659923a1664b8e966720fc48cf48f725562b81ef2c02997f8998a)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if fallback_behavior is not None:
                self._values["fallback_behavior"] = fallback_behavior

        @builtins.property
        def fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            Example JSON: ``{ "UriFragment": { "FallbackBehavior": "MATCH"} }``
            .. epigraph::

               AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-urifragment.html#cfn-wafv2-rulegroup-urifragment-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "UriFragmentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cloud_watch_metrics_enabled": "cloudWatchMetricsEnabled",
            "metric_name": "metricName",
            "sampled_requests_enabled": "sampledRequestsEnabled",
        },
    )
    class VisibilityConfigProperty:
        def __init__(
            self,
            *,
            cloud_watch_metrics_enabled: typing.Union[builtins.bool, _IResolvable_da3f097b],
            metric_name: builtins.str,
            sampled_requests_enabled: typing.Union[builtins.bool, _IResolvable_da3f097b],
        ) -> None:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :param cloud_watch_metrics_enabled: Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ in the *AWS WAF Developer Guide* . For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information, see `The web ACL default action <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html>`_ in the *AWS WAF Developer Guide* .
            :param metric_name: A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example ``All`` and ``Default_Action`` .
            :param sampled_requests_enabled: Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console. If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data. .. epigraph:: Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                visibility_config_property = wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ffc3de9fa9cd77d11c4487ad80fc48948664b917c8642b35ca709762ce71fddf)
                check_type(argname="argument cloud_watch_metrics_enabled", value=cloud_watch_metrics_enabled, expected_type=type_hints["cloud_watch_metrics_enabled"])
                check_type(argname="argument metric_name", value=metric_name, expected_type=type_hints["metric_name"])
                check_type(argname="argument sampled_requests_enabled", value=sampled_requests_enabled, expected_type=type_hints["sampled_requests_enabled"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cloud_watch_metrics_enabled": cloud_watch_metrics_enabled,
                "metric_name": metric_name,
                "sampled_requests_enabled": sampled_requests_enabled,
            }

        @builtins.property
        def cloud_watch_metrics_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_da3f097b]:
            '''Indicates whether the associated resource sends metrics to Amazon CloudWatch.

            For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ in the *AWS WAF Developer Guide* .

            For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
            see `The web ACL default action <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-cloudwatchmetricsenabled
            '''
            result = self._values.get("cloud_watch_metrics_enabled")
            assert result is not None, "Required property 'cloud_watch_metrics_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_da3f097b], result)

        @builtins.property
        def metric_name(self) -> builtins.str:
            '''A name of the Amazon CloudWatch metric dimension.

            The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example ``All`` and ``Default_Action`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-metricname
            '''
            result = self._values.get("metric_name")
            assert result is not None, "Required property 'metric_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def sampled_requests_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_da3f097b]:
            '''Indicates whether AWS WAF should store a sampling of the web requests that match the rules.

            You can view the sampled requests through the AWS WAF console.

            If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data.
            .. epigraph::

               Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-sampledrequestsenabled
            '''
            result = self._values.get("sampled_requests_enabled")
            assert result is not None, "Required property 'sampled_requests_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_da3f097b], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VisibilityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class XssMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                xss_match_statement_property = wafv2.CfnRuleGroup.XssMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnRuleGroup.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnRuleGroup.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnRuleGroup.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e502ec1c8bc4096eb797b55f6c0a1f9c506e23db360770a855cc273d36ce4b4a)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "XssMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "capacity": "capacity",
        "scope": "scope",
        "visibility_config": "visibilityConfig",
        "available_labels": "availableLabels",
        "consumed_labels": "consumedLabels",
        "custom_response_bodies": "customResponseBodies",
        "description": "description",
        "name": "name",
        "rules": "rules",
        "tags": "tags",
    },
)
class CfnRuleGroupProps:
    def __init__(
        self,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.VisibilityConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        available_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.CustomResponseBodyProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.RuleProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRuleGroup``.

        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the ``RuleLabels`` for a ``Rule`` .
        :param consumed_labels: The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
        :exampleMetadata: fixture=_generated

        Example::

            
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8dfa44d9c30297c12ad00bd34bbd4b85ea5438f4127e7e97226c16565c6ef5b)
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
            check_type(argname="argument available_labels", value=available_labels, expected_type=type_hints["available_labels"])
            check_type(argname="argument consumed_labels", value=consumed_labels, expected_type=type_hints["consumed_labels"])
            check_type(argname="argument custom_response_bodies", value=custom_response_bodies, expected_type=type_hints["custom_response_bodies"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "capacity": capacity,
            "scope": scope,
            "visibility_config": visibility_config,
        }
        if available_labels is not None:
            self._values["available_labels"] = available_labels
        if consumed_labels is not None:
            self._values["consumed_labels"] = consumed_labels
        if custom_response_bodies is not None:
            self._values["custom_response_bodies"] = custom_response_bodies
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if rules is not None:
            self._values["rules"] = rules
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
        '''
        result = self._values.get("capacity")
        assert result is not None, "Required property 'capacity' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnRuleGroup.VisibilityConfigProperty]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
        '''
        result = self._values.get("visibility_config")
        assert result is not None, "Required property 'visibility_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnRuleGroup.VisibilityConfigProperty], result)

    @builtins.property
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]]:
        '''The labels that one or more rules in this rule group add to matching web requests.

        These labels are defined in the ``RuleLabels`` for a ``Rule`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels
        '''
        result = self._values.get("available_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]], result)

    @builtins.property
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]]:
        '''The labels that one or more rules in this rule group match against in label match statements.

        These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels
        '''
        result = self._values.get("consumed_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]], result)

    @builtins.property
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, CfnRuleGroup.CustomResponseBodyProperty]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies
        '''
        result = self._values.get("custom_response_bodies")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, CfnRuleGroup.CustomResponseBodyProperty]]]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.

        You cannot change the name of a rule group after you create it.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.RuleProperty]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.RuleProperty]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRuleGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnWebACL(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL",
):
    '''.. epigraph::

   This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019.

    For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``WebACL`` to define a collection of rules to use to inspect and control web requests. Each rule in a web ACL has a statement that defines what to look for in web requests and an action that AWS WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that doesn't match any of the rules.

    The rules in a web ACL can be a combination of explicitly defined rules and rule groups that you reference from the web ACL. The rule groups can be rule groups that you manage or rule groups that are managed by others.

    You can associate a web ACL with one or more AWS resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer , an AWS AppSync GraphQL API , an Amazon Cognito user pool, an AWS App Runner service, an AWS Amplify application, or an AWS Verified Access instance.

    For more information, see `Web access control lists (web ACLs) <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl.html>`_ in the *AWS WAF developer guide* .

    *Web ACLs used in AWS Shield Advanced automatic application layer DDoS mitigation*

    If you use Shield Advanced automatic application layer DDoS mitigation, the web ACLs that you use with automatic mitigation have a rule group rule whose name starts with ``ShieldMitigationRuleGroup`` . This rule is used for automatic mitigations and it's managed for you in the web ACL by Shield Advanced and AWS WAF . You'll see the rule listed among the web ACL rules when you view the web ACL through the AWS WAF interfaces.

    When you manage the web ACL through AWS CloudFormation interfaces, you won't see the Shield Advanced rule. AWS CloudFormation doesn't include this type of rule in the stack drift status between the actual configuration of the web ACL and your web ACL template.

    Don't add the Shield Advanced rule group rule to your web ACL template. The rule shouldn't be in your template. When you update the web ACL template in a stack, the Shield Advanced rule is maintained for you by AWS WAF in the resulting web ACL.

    For more information, see `Shield Advanced automatic application layer DDoS mitigation <https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response.html>`_ in the *AWS Shield Advanced developer guide* .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
    :cloudformationResource: AWS::WAFv2::WebACL
    :exampleMetadata: fixture=_generated

    Example::

        
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        default_action: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.DefaultActionProperty", typing.Dict[builtins.str, typing.Any]]],
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        association_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AssociationConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        captcha_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        challenge_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        data_protection_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.DataProtectionConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        token_domains: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param scope_: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param default_action: The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use ``CLOUDFRONT`` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` . For information about how to define the association of the web ACL with your resource, see ``WebACLAssociation`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param association_config: Specifies custom configurations for the associations between the web ACL and protected resources. Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes). .. epigraph:: You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ . For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .
        :param challenge_config: Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``ChallengeConfig`` .
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param data_protection_config: Specifies data protection to apply to the web request data for the web ACL. This is a web ACL level data protection option. The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.
        :param description: A description of the web ACL that helps with identification.
        :param name: The name of the web ACL. You cannot change the name of a web ACL after you create it.
        :param rules: The rule statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        :param token_domains: Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03030a65c492e95a1d1ae5ddafd6acbb9efdfa7e18b6367ac7e03eb8fe504525)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnWebACLProps(
            default_action=default_action,
            scope=scope,
            visibility_config=visibility_config,
            association_config=association_config,
            captcha_config=captcha_config,
            challenge_config=challenge_config,
            custom_response_bodies=custom_response_bodies,
            data_protection_config=data_protection_config,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
            token_domains=token_domains,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__376231183b8e6168d309715ff2ec1f7a5bf235473ef67e8b905ee5400deee7e0)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10d5331eeda0a793d74c086edb4a25c85042aefaf4f3ed126aac4e1d2f840d07)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCapacity")
    def attr_capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) currently being used by this web ACL.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :cloudformationAttribute: Capacity
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrCapacity"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the web ACL.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this web ACL.

        All labels added by rules in this web ACL have this prefix.

        The syntax for the label namespace prefix for a web ACL is the following: ``awswaf:<account ID>:webacl:<web ACL name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="defaultAction")
    def default_action(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"]:
        '''The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"], jsii.get(self, "defaultAction"))

    @default_action.setter
    def default_action(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2278a10121edfa33bcba416640471cade86cfa4cd26e23a8e52483acce0b053c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultAction", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.'''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a713a6057870757511e9190984a673024b8e428fbfb62430ddca1be52f22a466)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c31cd418fc7ecfcb56c27ca59f7e1a72ad63669e0587305727953071e54beba5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="associationConfig")
    def association_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]]:
        '''Specifies custom configurations for the associations between the web ACL and protected resources.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]], jsii.get(self, "associationConfig"))

    @association_config.setter
    def association_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd4131e7b800e93fe8dbfa57a0b3448dcc676e6dccccd567162368dbc7b9aa88)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "associationConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="captchaConfig")
    def captcha_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]]:
        '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]], jsii.get(self, "captchaConfig"))

    @captcha_config.setter
    def captcha_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bec4912672ad4c39c01367d956dcf8b3173f9726891f89f7bcb98f5d113a5b96)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "captchaConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="challengeConfig")
    def challenge_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]]:
        '''Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]], jsii.get(self, "challengeConfig"))

    @challenge_config.setter
    def challenge_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e91b2b602941cac006704e7fffe237dd7367bae62a80676a727ef6f2d0ff5748)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "challengeConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]]:
        '''A map of custom response keys and content bodies.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5782b9cc65df721fabb81b38101a49b0dce480579e9b262edcfe915ec2bb91ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="dataProtectionConfig")
    def data_protection_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.DataProtectionConfigProperty"]]:
        '''Specifies data protection to apply to the web request data for the web ACL.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.DataProtectionConfigProperty"]], jsii.get(self, "dataProtectionConfig"))

    @data_protection_config.setter
    def data_protection_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.DataProtectionConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8fdb8c606175920c3facb5c8db0632e7cdc7bedffcd3c6c787bab31ba6f6474)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataProtectionConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the web ACL that helps with identification.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b7cfda3db6502d36377ec778a8c90e7487c0f54a00cb343261a4d256ace27df9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the web ACL.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__191460374393c7b9829682ab4faa571596cd3c2090e46352a427930a25736975)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]]:
        '''The rule statements used to identify the web requests that you want to manage.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e3abb4095a53abe30bca846b48411ffb15b0267398c52a824a8ffba45db4f4c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c74fad37a0c379b1aff5e14c6c06c7ca6d7553e008800f34da868f68c92ddeb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tokenDomains")
    def token_domains(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Specifies the domains that AWS WAF should accept in a web request token.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tokenDomains"))

    @token_domains.setter
    def token_domains(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99fc4e17b77f4f0f511e3dfadd416c0aa9910c2cf60e12f343bccd8e81d4c228)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tokenDomains", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={
            "creation_path": "creationPath",
            "registration_page_path": "registrationPagePath",
            "request_inspection": "requestInspection",
            "enable_regex_in_path": "enableRegexInPath",
            "response_inspection": "responseInspection",
        },
    )
    class AWSManagedRulesACFPRuleSetProperty:
        def __init__(
            self,
            *,
            creation_path: builtins.str,
            registration_page_path: builtins.str,
            request_inspection: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RequestInspectionACFPProperty", typing.Dict[builtins.str, typing.Any]]],
            enable_regex_in_path: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            response_inspection: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Details for your use of the account creation fraud prevention managed rule group, ``AWSManagedRulesACFPRuleSet`` .

            This configuration is used in ``ManagedRuleGroupConfig`` .

            :param creation_path: The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept ``POST`` requests. For example, for the URL ``https://example.com/web/newaccount`` , you would provide the path ``/web/newaccount`` . Account creation page paths that start with the path that you provide are considered a match. For example ``/web/newaccount`` matches the account creation paths ``/web/newaccount`` , ``/web/newaccount/`` , ``/web/newaccountPage`` , and ``/web/newaccount/thisPage`` , but doesn't match the path ``/home/web/newaccount`` or ``/website/newaccount`` .
            :param registration_page_path: The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. .. epigraph:: This page must accept ``GET`` text/html requests. For example, for the URL ``https://example.com/web/registration`` , you would provide the path ``/web/registration`` . Registration page paths that start with the path that you provide are considered a match. For example ``/web/registration`` matches the registration paths ``/web/registration`` , ``/web/registration/`` , ``/web/registrationPage`` , and ``/web/registration/thisPage`` , but doesn't match the path ``/home/web/registration`` or ``/website/registration`` .
            :param request_inspection: The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
            :param enable_regex_in_path: Allow the use of regular expressions in the registration page path and the account creation path.
            :param response_inspection: The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates. .. epigraph:: Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_aCFPRule_set_property = wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty(
                    creation_path="creationPath",
                    registration_page_path="registrationPagePath",
                    request_inspection=wafv2.CfnWebACL.RequestInspectionACFPProperty(
                        payload_type="payloadType",
                
                        # the properties below are optional
                        address_fields=[wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )],
                        email_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        ),
                        password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        ),
                        phone_number_fields=[wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )],
                        username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )
                    ),
                
                    # the properties below are optional
                    enable_regex_in_path=False,
                    response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                        body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                            failure_strings=["failureStrings"],
                            success_strings=["successStrings"]
                        ),
                        header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                            failure_values=["failureValues"],
                            name="name",
                            success_values=["successValues"]
                        ),
                        json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                            failure_values=["failureValues"],
                            identifier="identifier",
                            success_values=["successValues"]
                        ),
                        status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                            failure_codes=[123],
                            success_codes=[123]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5c08cfcfaa5f48620f4373a7a989846d398cb0e2ffb820ff7258061e249969ae)
                check_type(argname="argument creation_path", value=creation_path, expected_type=type_hints["creation_path"])
                check_type(argname="argument registration_page_path", value=registration_page_path, expected_type=type_hints["registration_page_path"])
                check_type(argname="argument request_inspection", value=request_inspection, expected_type=type_hints["request_inspection"])
                check_type(argname="argument enable_regex_in_path", value=enable_regex_in_path, expected_type=type_hints["enable_regex_in_path"])
                check_type(argname="argument response_inspection", value=response_inspection, expected_type=type_hints["response_inspection"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "creation_path": creation_path,
                "registration_page_path": registration_page_path,
                "request_inspection": request_inspection,
            }
            if enable_regex_in_path is not None:
                self._values["enable_regex_in_path"] = enable_regex_in_path
            if response_inspection is not None:
                self._values["response_inspection"] = response_inspection

        @builtins.property
        def creation_path(self) -> builtins.str:
            '''The path of the account creation endpoint for your application.

            This is the page on your website that accepts the completed registration form for a new user. This page must accept ``POST`` requests.

            For example, for the URL ``https://example.com/web/newaccount`` , you would provide the path ``/web/newaccount`` . Account creation page paths that start with the path that you provide are considered a match. For example ``/web/newaccount`` matches the account creation paths ``/web/newaccount`` , ``/web/newaccount/`` , ``/web/newaccountPage`` , and ``/web/newaccount/thisPage`` , but doesn't match the path ``/home/web/newaccount`` or ``/website/newaccount`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-creationpath
            '''
            result = self._values.get("creation_path")
            assert result is not None, "Required property 'creation_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def registration_page_path(self) -> builtins.str:
            '''The path of the account registration endpoint for your application.

            This is the page on your website that presents the registration form to new users.
            .. epigraph::

               This page must accept ``GET`` text/html requests.

            For example, for the URL ``https://example.com/web/registration`` , you would provide the path ``/web/registration`` . Registration page paths that start with the path that you provide are considered a match. For example ``/web/registration`` matches the registration paths ``/web/registration`` , ``/web/registration/`` , ``/web/registrationPage`` , and ``/web/registration/thisPage`` , but doesn't match the path ``/home/web/registration`` or ``/website/registration`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-registrationpagepath
            '''
            result = self._values.get("registration_page_path")
            assert result is not None, "Required property 'registration_page_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def request_inspection(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionACFPProperty"]:
            '''The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-requestinspection
            '''
            result = self._values.get("request_inspection")
            assert result is not None, "Required property 'request_inspection' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionACFPProperty"], result)

        @builtins.property
        def enable_regex_in_path(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Allow the use of regular expressions in the registration page path and the account creation path.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-enableregexinpath
            '''
            result = self._values.get("enable_regex_in_path")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def response_inspection(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]]:
            '''The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.

            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-responseinspection
            '''
            result = self._values.get("response_inspection")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesACFPRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={
            "login_path": "loginPath",
            "enable_regex_in_path": "enableRegexInPath",
            "request_inspection": "requestInspection",
            "response_inspection": "responseInspection",
        },
    )
    class AWSManagedRulesATPRuleSetProperty:
        def __init__(
            self,
            *,
            login_path: builtins.str,
            enable_regex_in_path: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            request_inspection: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RequestInspectionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            response_inspection: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Details for your use of the account takeover prevention managed rule group, ``AWSManagedRulesATPRuleSet`` .

            This configuration is used in ``ManagedRuleGroupConfig`` .

            :param login_path: The path of the login endpoint for your application. For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` . Login paths that start with the path that you provide are considered a match. For example ``/web/login`` matches the login paths ``/web/login`` , ``/web/login/`` , ``/web/loginPage`` , and ``/web/login/thisPage`` , but doesn't match the login path ``/home/web/login`` or ``/website/login`` . The rule group inspects only HTTP ``POST`` requests to your specified login endpoint.
            :param enable_regex_in_path: Allow the use of regular expressions in the login page path.
            :param request_inspection: The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
            :param response_inspection: The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. .. epigraph:: Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_aTPRule_set_property = wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty(
                    login_path="loginPath",
                
                    # the properties below are optional
                    enable_regex_in_path=False,
                    request_inspection=wafv2.CfnWebACL.RequestInspectionProperty(
                        password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        ),
                        payload_type="payloadType",
                        username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )
                    ),
                    response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                        body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                            failure_strings=["failureStrings"],
                            success_strings=["successStrings"]
                        ),
                        header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                            failure_values=["failureValues"],
                            name="name",
                            success_values=["successValues"]
                        ),
                        json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                            failure_values=["failureValues"],
                            identifier="identifier",
                            success_values=["successValues"]
                        ),
                        status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                            failure_codes=[123],
                            success_codes=[123]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f9aee7f94c21473b0495313f92d8a99724499d3f5a99e7229679efb1e73516ad)
                check_type(argname="argument login_path", value=login_path, expected_type=type_hints["login_path"])
                check_type(argname="argument enable_regex_in_path", value=enable_regex_in_path, expected_type=type_hints["enable_regex_in_path"])
                check_type(argname="argument request_inspection", value=request_inspection, expected_type=type_hints["request_inspection"])
                check_type(argname="argument response_inspection", value=response_inspection, expected_type=type_hints["response_inspection"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "login_path": login_path,
            }
            if enable_regex_in_path is not None:
                self._values["enable_regex_in_path"] = enable_regex_in_path
            if request_inspection is not None:
                self._values["request_inspection"] = request_inspection
            if response_inspection is not None:
                self._values["response_inspection"] = response_inspection

        @builtins.property
        def login_path(self) -> builtins.str:
            '''The path of the login endpoint for your application.

            For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` . Login paths that start with the path that you provide are considered a match. For example ``/web/login`` matches the login paths ``/web/login`` , ``/web/login/`` , ``/web/loginPage`` , and ``/web/login/thisPage`` , but doesn't match the login path ``/home/web/login`` or ``/website/login`` .

            The rule group inspects only HTTP ``POST`` requests to your specified login endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-loginpath
            '''
            result = self._values.get("login_path")
            assert result is not None, "Required property 'login_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def enable_regex_in_path(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Allow the use of regular expressions in the login page path.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-enableregexinpath
            '''
            result = self._values.get("enable_regex_in_path")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def request_inspection(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionProperty"]]:
            '''The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-requestinspection
            '''
            result = self._values.get("request_inspection")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionProperty"]], result)

        @builtins.property
        def response_inspection(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]]:
            '''The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.

            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-responseinspection
            '''
            result = self._values.get("response_inspection")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesATPRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={
            "inspection_level": "inspectionLevel",
            "enable_machine_learning": "enableMachineLearning",
        },
    )
    class AWSManagedRulesBotControlRuleSetProperty:
        def __init__(
            self,
            *,
            inspection_level: builtins.str,
            enable_machine_learning: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''Details for your use of the Bot Control managed rule group, ``AWSManagedRulesBotControlRuleSet`` .

            This configuration is used in ``ManagedRuleGroupConfig`` .

            :param inspection_level: The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ in the *AWS WAF Developer Guide* .
            :param enable_machine_learning: Applies only to the targeted inspection level. Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules ``TGT_ML_CoordinatedActivityLow`` and ``TGT_ML_CoordinatedActivityMedium`` , which inspect for anomalous behavior that might indicate distributed, coordinated bot activity. For more information about this choice, see the listing for these rules in the table at `Bot Control rules listing <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules>`_ in the *AWS WAF Developer Guide* . Default: ``TRUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_bot_control_rule_set_property = wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                    inspection_level="inspectionLevel",
                
                    # the properties below are optional
                    enable_machine_learning=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__23917b7bd12237aafb58493973b8f61366778e01800aad21ea2f95a01294dc76)
                check_type(argname="argument inspection_level", value=inspection_level, expected_type=type_hints["inspection_level"])
                check_type(argname="argument enable_machine_learning", value=enable_machine_learning, expected_type=type_hints["enable_machine_learning"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "inspection_level": inspection_level,
            }
            if enable_machine_learning is not None:
                self._values["enable_machine_learning"] = enable_machine_learning

        @builtins.property
        def inspection_level(self) -> builtins.str:
            '''The inspection level to use for the Bot Control rule group.

            The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-inspectionlevel
            '''
            result = self._values.get("inspection_level")
            assert result is not None, "Required property 'inspection_level' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def enable_machine_learning(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Applies only to the targeted inspection level.

            Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules ``TGT_ML_CoordinatedActivityLow`` and ``TGT_ML_CoordinatedActivityMedium`` , which
            inspect for anomalous behavior that might indicate distributed, coordinated bot activity.

            For more information about this choice, see the listing for these rules in the table at `Bot Control rules listing <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules>`_ in the *AWS WAF Developer Guide* .

            Default: ``TRUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-enablemachinelearning
            '''
            result = self._values.get("enable_machine_learning")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesBotControlRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AllowActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should allow the request and optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                allow_action_property = wafv2.CfnWebACL.AllowActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__69dee3824024f4ebf455961564f0743db7a203a492aae72706c2b03ec8de3725)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html#cfn-wafv2-webacl-allowaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e3977b616ebe935b8882258fb7fe1261468bceabf99977afc1c05b1df5a70def)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html#cfn-wafv2-webacl-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AssociationConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"request_body": "requestBody"},
    )
    class AssociationConfigProperty:
        def __init__(
            self,
            *,
            request_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Specifies custom configurations for the associations between the web ACL and protected resources.

            Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
            .. epigraph::

               You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).

            :param request_body: Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types. .. epigraph:: You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ . Example JSON: ``{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }`` For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                association_config_property = wafv2.CfnWebACL.AssociationConfigProperty(
                    request_body={
                        "request_body_key": wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty(
                            default_size_inspection_limit="defaultSizeInspectionLimit"
                        )
                    }
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__889bff55ba91160187275a11669025b829161457b27db183745c6a70c6fb0947)
                check_type(argname="argument request_body", value=request_body, expected_type=type_hints["request_body"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if request_body is not None:
                self._values["request_body"] = request_body

        @builtins.property
        def request_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty"]]]]:
            '''Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection.

            The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
            .. epigraph::

               You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            Example JSON: ``{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }``

            For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html#cfn-wafv2-webacl-associationconfig-requestbody
            '''
            result = self._values.get("request_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AssociationConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.BlockActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockActionProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should block the request and optionally defines additional custom handling for the response to the web request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_response: Defines a custom response for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                block_action_property = wafv2.CfnWebACL.BlockActionProperty(
                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2cd0779b093422bd5fd6a55e35abfcd7322ddfbd2b9d953493ef043b3fbf4cf8)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseProperty"]]:
            '''Defines a custom response for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html#cfn-wafv2-webacl-blockaction-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnWebACL.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__931342fa1a6c3c85b33cb0561c01b7d14274ade272ed3521abe036b843fa8f3e)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html#cfn-wafv2-webacl-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnWebACL.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        ja3_fingerprint=wafv2.CfnWebACL.JA3FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        ja4_fingerprint=wafv2.CfnWebACL.JA4FingerprintProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_fragment=wafv2.CfnWebACL.UriFragmentProperty(
                            fallback_behavior="fallbackBehavior"
                        ),
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa15ef2b16644ae01b4e67c309786112c6345b088bd7dc3abcd5ef657c4d06f9)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_action_property = wafv2.CfnWebACL.CaptchaActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c28ed2f577156216a396d23cdf94c64fd6f221d82920aea9a64f1c77e4acbd35)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html#cfn-wafv2-webacl-captchaaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.

            If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnWebACL.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b45a1ab97900eb88b801a9d476ef90fffa338929bfd860fb5818734249ab355d)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html#cfn-wafv2-webacl-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``Challenge`` check against the request to verify that the request is coming from a legitimate client session:  - If the request includes a valid, unexpired challenge token, AWS WAF applies any custom request handling and labels that you've configured and then allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .

            - If the request doesn't include a valid, unexpired challenge token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF then generates a challenge response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``challenge`` .
            - The HTTP status code ``202 Request Accepted`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a JavaScript page interstitial with a challenge script.

            Challenges run silent browser interrogations in the background, and don't generally affect the end user experience.

            A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots.

            After the client session successfully responds to the challenge, it receives a new token from AWS WAF , which the challenge script uses to resubmit the original request.

            You can configure the expiration time in the ``ChallengeConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_action_property = wafv2.CfnWebACL.ChallengeActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3e00e6c1f2ede04c7bc1e9b6ad5856518734b5452ceecd17f5010c5456ddf203)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html#cfn-wafv2-webacl-challengeaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnWebACL.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e59d4e09b55c6fb1e18f3dbf3d0659f147db2659c300a744e836928d4b000e7b)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html#cfn-wafv2-webacl-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnWebACL.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11e565e9aad1b474694cbb7c884715be324a3c5b38238a45e13e0d2ed78d816d)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``ALL`` , AWS WAF inspects both keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnWebACL.CookiesProperty(
                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5ad212e56575cb6c1346d11d3fd80ae8eba42e3155418b11a1bec538355e2656)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookieMatchPatternProperty"]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookieMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``ALL`` , AWS WAF inspects both keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CountActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should count the request. Optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                count_action_property = wafv2.CfnWebACL.CountActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad85beaba3815f0aba760c694686ca93d6643507bcf4f500bf71e7da4c260e18)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html#cfn-wafv2-webacl-countaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling`` .

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__32cba5cbfe0dd140f4c32592f1dc09f6de35627e0538709e1c9a3dd17aaa3aef)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnWebACL.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ba933811044d610695911a26490bdd0e276008bbe930839f73ea645c8f2b7316)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html#cfn-wafv2-webacl-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnWebACL.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__281879092afa665915e6fd969d0e9a5b5b4898fe8ef498c2dea6a4bf1109aafa)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to the block action.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF developer guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. You can specify any header name except for ``content-type`` . Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnWebACL.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6dbc9439dfbaeae9e0932894939e1048a58a2d028d4ee3fbdcead25e1600ad91)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]]:
            '''The HTTP headers to use in the response.

            You can specify any header name except for ``content-type`` . Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectProperty",
        jsii_struct_bases=[],
        name_mapping={
            "action": "action",
            "field": "field",
            "exclude_rate_based_details": "excludeRateBasedDetails",
            "exclude_rule_match_details": "excludeRuleMatchDetails",
        },
    )
    class DataProtectProperty:
        def __init__(
            self,
            *,
            action: builtins.str,
            field: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToProtectProperty", typing.Dict[builtins.str, typing.Any]]],
            exclude_rate_based_details: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            exclude_rule_match_details: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param action: 
            :param field: Field in log to protect.
            :param exclude_rate_based_details: 
            :param exclude_rule_match_details: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                data_protect_property = wafv2.CfnWebACL.DataProtectProperty(
                    action="action",
                    field=wafv2.CfnWebACL.FieldToProtectProperty(
                        field_type="fieldType",
                
                        # the properties below are optional
                        field_keys=["fieldKeys"]
                    ),
                
                    # the properties below are optional
                    exclude_rate_based_details=False,
                    exclude_rule_match_details=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__426b9eaa484bd1569796d5a87210701ae64a082cfa2a2f0342a5b25283344e18)
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
                check_type(argname="argument field", value=field, expected_type=type_hints["field"])
                check_type(argname="argument exclude_rate_based_details", value=exclude_rate_based_details, expected_type=type_hints["exclude_rate_based_details"])
                check_type(argname="argument exclude_rule_match_details", value=exclude_rule_match_details, expected_type=type_hints["exclude_rule_match_details"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "action": action,
                "field": field,
            }
            if exclude_rate_based_details is not None:
                self._values["exclude_rate_based_details"] = exclude_rate_based_details
            if exclude_rule_match_details is not None:
                self._values["exclude_rule_match_details"] = exclude_rule_match_details

        @builtins.property
        def action(self) -> builtins.str:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-action
            '''
            result = self._values.get("action")
            assert result is not None, "Required property 'action' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToProtectProperty"]:
            '''Field in log to protect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-field
            '''
            result = self._values.get("field")
            assert result is not None, "Required property 'field' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToProtectProperty"], result)

        @builtins.property
        def exclude_rate_based_details(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderatebaseddetails
            '''
            result = self._values.get("exclude_rate_based_details")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def exclude_rule_match_details(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderulematchdetails
            '''
            result = self._values.get("exclude_rule_match_details")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataProtectProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectionConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"data_protections": "dataProtections"},
    )
    class DataProtectionConfigProperty:
        def __init__(
            self,
            *,
            data_protections: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.DataProtectProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Specifies data protection to apply to the web request data for the web ACL.

            This is a web ACL level data protection option.

            The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.

            This is part of the data protection configuration for a web ACL.

            :param data_protections: An array of data protection configurations for specific web request field types. This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                data_protection_config_property = wafv2.CfnWebACL.DataProtectionConfigProperty(
                    data_protections=[wafv2.CfnWebACL.DataProtectProperty(
                        action="action",
                        field=wafv2.CfnWebACL.FieldToProtectProperty(
                            field_type="fieldType",
                
                            # the properties below are optional
                            field_keys=["fieldKeys"]
                        ),
                
                        # the properties below are optional
                        exclude_rate_based_details=False,
                        exclude_rule_match_details=False
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__00facdbed1fde99291b1bde086b472ce66ee6dd143e53d5639cc3ea8b02e5eac)
                check_type(argname="argument data_protections", value=data_protections, expected_type=type_hints["data_protections"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_protections": data_protections,
            }

        @builtins.property
        def data_protections(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.DataProtectProperty"]]]:
            '''An array of data protection configurations for specific web request field types.

            This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html#cfn-wafv2-webacl-dataprotectionconfig-dataprotections
            '''
            result = self._values.get("data_protections")
            assert result is not None, "Required property 'data_protections' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.DataProtectProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataProtectionConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.DefaultActionProperty",
        jsii_struct_bases=[],
        name_mapping={"allow": "allow", "block": "block"},
    )
    class DefaultActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AllowActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            block: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.BlockActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''In a ``WebACL`` , this is the action that you want AWS WAF to perform when a web request doesn't match any of the rules in the ``WebACL`` .

            The default action must be a terminating action.

            :param allow: Specifies that AWS WAF should allow requests by default.
            :param block: Specifies that AWS WAF should block requests by default.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                default_action_property = wafv2.CfnWebACL.DefaultActionProperty(
                    allow=wafv2.CfnWebACL.AllowActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    block=wafv2.CfnWebACL.BlockActionProperty(
                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                            response_code=123,
                
                            # the properties below are optional
                            custom_response_body_key="customResponseBodyKey",
                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4f9b2681c5a7f99be956a44a9c1d132bd2244e6fdc65ac82690f66a9402698b5)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block

        @builtins.property
        def allow(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]]:
            '''Specifies that AWS WAF should allow requests by default.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]], result)

        @builtins.property
        def block(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]]:
            '''Specifies that AWS WAF should block requests by default.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ExcludedRuleProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class ExcludedRuleProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Specifies a single rule in a rule group whose action you want to override to ``Count`` .

            .. epigraph::

               Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .

            :param name: The name of the rule whose action you want to override to ``Count`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                excluded_rule_property = wafv2.CfnWebACL.ExcludedRuleProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a96bf0217136d589753b415a4d08032d4bb70e9d17edcf46dbc160ad99e5935a)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule whose action you want to override to ``Count`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExcludedRuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.FieldIdentifierProperty",
        jsii_struct_bases=[],
        name_mapping={"identifier": "identifier"},
    )
    class FieldIdentifierProperty:
        def __init__(self, *, identifier: builtins.str) -> None:
            '''The identifier of a field in the web request payload that contains customer data.

            This data type is used to specify fields in the ``RequestInspection`` and ``RequestInspectionACFP`` configurations, which are used in the managed rule group configurations ``AWSManagedRulesATPRuleSet`` and ``AWSManagedRulesACFPRuleSet`` , respectively.

            :param identifier: The name of the field. When the ``PayloadType`` in the request inspection is ``JSON`` , this identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` . For more information, see the descriptions for each field type in the request inspection properties.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                field_identifier_property = wafv2.CfnWebACL.FieldIdentifierProperty(
                    identifier="identifier"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cb389deae2afd887b8a26e90f20af6819bccf430ed2ee28f87cc538c2e16bce6)
                check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "identifier": identifier,
            }

        @builtins.property
        def identifier(self) -> builtins.str:
            '''The name of the field.

            When the ``PayloadType`` in the request inspection is ``JSON`` , this identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` .

            For more information, see the descriptions for each field type in the request inspection properties.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html#cfn-wafv2-webacl-fieldidentifier-identifier
            '''
            result = self._values.get("identifier")
            assert result is not None, "Required property 'identifier' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldIdentifierProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "ja3_fingerprint": "ja3Fingerprint",
            "ja4_fingerprint": "ja4Fingerprint",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_fragment": "uriFragment",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.BodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            cookies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CookiesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.HeadersProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ja3_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JA3FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ja4_fingerprint: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JA4FingerprintProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_fragment: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.UriFragmentProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''Specifies a web request component to be used in a rule match statement or in a logging configuration.

            - In a rule statement, this is the part of the web request that you want AWS WAF to inspect. Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            - In a logging configuration, this is used in the ``RedactedFields`` property to specify a field to redact from the logging records. For this use case, note the following:
            - Even though all ``FieldToMatch`` settings are available, the only valid settings for field redaction are ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .
            - In this documentation, the descriptions of the individual fields talk about specifying the web request component to inspect, but for field redaction, you are specifying the component type to redact from the logs.
            - If you have request sampling enabled, the redacted fields configuration for logging has no impact on sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param ja3_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information. .. epigraph:: You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` . You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* . Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
            :param ja4_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information. .. epigraph:: You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` . You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* . Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_fragment: Inspect fragments of the request URI. You must configure scope and pattern matching filters in the ``UriFragment`` object, to define the fragment of a URI that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the ``UriFragment`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnWebACL.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnWebACL.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnWebACL.CookiesProperty(
                        match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnWebACL.HeadersProperty(
                        match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    ja3_fingerprint=wafv2.CfnWebACL.JA3FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    ja4_fingerprint=wafv2.CfnWebACL.JA4FingerprintProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    json_body=wafv2.CfnWebACL.JsonBodyProperty(
                        match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_fragment=wafv2.CfnWebACL.UriFragmentProperty(
                        fallback_behavior="fallbackBehavior"
                    ),
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__25d147c856e9a8fd64f4cc05856e4813e584f37ef787792ad3c4e07907417207)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument ja3_fingerprint", value=ja3_fingerprint, expected_type=type_hints["ja3_fingerprint"])
                check_type(argname="argument ja4_fingerprint", value=ja4_fingerprint, expected_type=type_hints["ja4_fingerprint"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_fragment", value=uri_fragment, expected_type=type_hints["uri_fragment"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if ja3_fingerprint is not None:
                self._values["ja3_fingerprint"] = ja3_fingerprint
            if ja4_fingerprint is not None:
                self._values["ja4_fingerprint"] = ja4_fingerprint
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_fragment is not None:
                self._values["uri_fragment"] = uri_fragment
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BodyProperty"]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BodyProperty"]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookiesProperty"]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookiesProperty"]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeadersProperty"]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeadersProperty"]], result)

        @builtins.property
        def ja3_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JA3FingerprintProperty"]]:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja3fingerprint
            '''
            result = self._values.get("ja3_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JA3FingerprintProperty"]], result)

        @builtins.property
        def ja4_fingerprint(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JA4FingerprintProperty"]]:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja4fingerprint
            '''
            result = self._values.get("ja4_fingerprint")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JA4FingerprintProperty"]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonBodyProperty"]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonBodyProperty"]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_fragment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.UriFragmentProperty"]]:
            '''Inspect fragments of the request URI.

            You must configure scope and pattern matching filters in the ``UriFragment`` object, to define the fragment of a URI that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the ``UriFragment`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-urifragment
            '''
            result = self._values.get("uri_fragment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.UriFragmentProperty"]], result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToProtectProperty",
        jsii_struct_bases=[],
        name_mapping={"field_type": "fieldType", "field_keys": "fieldKeys"},
    )
    class FieldToProtectProperty:
        def __init__(
            self,
            *,
            field_type: builtins.str,
            field_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Specifies a field type and keys to protect in stored web request data.

            This is part of the data protection configuration for a web ACL.

            :param field_type: Specifies the web request component type to protect.
            :param field_keys: Specifies the keys to protect for the specified field type. If you don't specify any key, then all keys for the field type are protected.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                field_to_protect_property = wafv2.CfnWebACL.FieldToProtectProperty(
                    field_type="fieldType",
                
                    # the properties below are optional
                    field_keys=["fieldKeys"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b289950ea26daa0c8967a6c0a3a4de1a0fa062f7bc5f28fcf70ab8e7fa4989f0)
                check_type(argname="argument field_type", value=field_type, expected_type=type_hints["field_type"])
                check_type(argname="argument field_keys", value=field_keys, expected_type=type_hints["field_keys"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_type": field_type,
            }
            if field_keys is not None:
                self._values["field_keys"] = field_keys

        @builtins.property
        def field_type(self) -> builtins.str:
            '''Specifies the web request component type to protect.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldtype
            '''
            result = self._values.get("field_type")
            assert result is not None, "Required property 'field_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_keys(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Specifies the keys to protect for the specified field type.

            If you don't specify any key, then all keys for the field type are protected.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldkeys
            '''
            result = self._values.get("field_keys")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToProtectProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__db1f5e352c4a5fdd9a13196892955f19f25065d63109402ea882298152866a75)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnWebACL.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__befc77fe4c1d7ff11b5fe89a367afb00688b31f469f3561e1dc2fc7c6cf1aea5)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnWebACL.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__74f4bafb0ceef9ccf5758d2d07f34c359f06d8608d8db4d517f5a02bf945ad72)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``ALL`` , AWS WAF inspects both keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnWebACL.HeadersProperty(
                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fb8a12a400cdb513abdda33ba661401606db55c8dc78fefe32c1a27bf31ea2c4)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeaderMatchPatternProperty"]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeaderMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``ALL`` , AWS WAF inspects both keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c84737e60b069b2a78f599f428b4ef9e093de8316e5c8534f5c2154d424da173)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__344492cd77103ff2a78ddd489f925b8d499c81f54082b275e70c59266867f37d)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.IPSetForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.IPSetForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4ebec44af1e8d72b72f8c361dc8efc545a044cf914ee07c895cf4c1d1acefad2)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html#cfn-wafv2-webacl-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JA3FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class JA3FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a JA3 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                j_a3_fingerprint_property = wafv2.CfnWebACL.JA3FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__129b51143b193ce4679091a559f9a4073c03a2bccc1ccb884fe1b4dd3856119e)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a JA3 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html#cfn-wafv2-webacl-ja3fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JA3FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JA4FingerprintProperty",
        jsii_struct_bases=[],
        name_mapping={"fallback_behavior": "fallbackBehavior"},
    )
    class JA4FingerprintProperty:
        def __init__(self, *, fallback_behavior: builtins.str) -> None:
            '''Available for use with Amazon CloudFront distributions and Application Load Balancers.

            Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
            .. epigraph::

               You can use this choice only with a string match ``ByteMatchStatement`` with the ``PositionalConstraint`` set to ``EXACTLY`` .

            You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see `Log fields <https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html>`_ in the *AWS WAF Developer Guide* .

            Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a JA4 fingerprint. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                j_a4_fingerprint_property = wafv2.CfnWebACL.JA4FingerprintProperty(
                    fallback_behavior="fallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d291ee91c69174f3c85a4f366df59f9a94555bb2191f94bfec169a28f40438d6)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a JA4 fingerprint.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html#cfn-wafv2-webacl-ja4fingerprint-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JA4FingerprintProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            For additional information about this request component option, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``ALL`` , AWS WAF matches against keys and values. ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. .. epigraph:: AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection. - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes). - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees. - For AWS Amplify , use the CloudFront limit. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnWebACL.JsonBodyProperty(
                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b371d01e6e192e377c25d061f5a40b73b3aca7d15781a83f612151eddebe6fa2)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonMatchPatternProperty"]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``ALL`` , AWS WAF matches against keys and values.

            ``All`` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical ``AND`` statement to combine two match rules, one that inspects the keys and another that inspects the values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
            .. epigraph::

               AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see `JSON body <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

            - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
            - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL ``AssociationConfig`` , for additional processing fees.
            - For AWS Amplify , use the CloudFront limit.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnWebACL.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0da90eac09d57420ee040ab315fb49e6de7faca7697217290633a02356c64b8c)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnWebACL.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7fbc144fb2899e7e14bfe8ef6fcbc18ee5df1b532334669d611524d95ba13a79)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnWebACL.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bf81be90baf4410ecf4fe3290d007b8b6c18da545bbac600a4ec86a29a24621d)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html#cfn-wafv2-webacl-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aws_managed_rules_acfp_rule_set": "awsManagedRulesAcfpRuleSet",
            "aws_managed_rules_atp_rule_set": "awsManagedRulesAtpRuleSet",
            "aws_managed_rules_bot_control_rule_set": "awsManagedRulesBotControlRuleSet",
            "login_path": "loginPath",
            "password_field": "passwordField",
            "payload_type": "payloadType",
            "username_field": "usernameField",
        },
    )
    class ManagedRuleGroupConfigProperty:
        def __init__(
            self,
            *,
            aws_managed_rules_acfp_rule_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AWSManagedRulesACFPRuleSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            aws_managed_rules_atp_rule_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AWSManagedRulesATPRuleSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            aws_managed_rules_bot_control_rule_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AWSManagedRulesBotControlRuleSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            login_path: typing.Optional[builtins.str] = None,
            password_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            payload_type: typing.Optional[builtins.str] = None,
            username_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Additional information that's used by a managed rule group. Many managed rule groups don't require this.

            The rule groups used for intelligent threat mitigation require additional configuration:

            - Use the ``AWSManagedRulesACFPRuleSet`` configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.
            - Use the ``AWSManagedRulesATPRuleSet`` configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.
            - Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.

            :param aws_managed_rules_acfp_rule_set: Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, ``AWSManagedRulesACFPRuleSet`` . Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests. For information about using the ACFP managed rule group, see `AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html>`_ and `AWS WAF Fraud Control account creation fraud prevention (ACFP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html>`_ in the *AWS WAF Developer Guide* .
            :param aws_managed_rules_atp_rule_set: Additional configuration for using the account takeover prevention (ATP) managed rule group, ``AWSManagedRulesATPRuleSet`` . Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests. This configuration replaces the individual configuration fields in ``ManagedRuleGroupConfig`` and provides additional feature configuration. For information about using the ATP managed rule group, see `AWS WAF Fraud Control account takeover prevention (ATP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html>`_ and `AWS WAF Fraud Control account takeover prevention (ATP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html>`_ in the *AWS WAF Developer Guide* .
            :param aws_managed_rules_bot_control_rule_set: Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .
            :param login_path: .. epigraph:: Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` .
            :param password_field: .. epigraph:: Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .
            :param payload_type: .. epigraph:: Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .
            :param username_field: .. epigraph:: Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                managed_rule_group_config_property = wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                    aws_managed_rules_acfp_rule_set=wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty(
                        creation_path="creationPath",
                        registration_page_path="registrationPagePath",
                        request_inspection=wafv2.CfnWebACL.RequestInspectionACFPProperty(
                            payload_type="payloadType",
                
                            # the properties below are optional
                            address_fields=[wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )],
                            email_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            ),
                            password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            ),
                            phone_number_fields=[wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )],
                            username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )
                        ),
                
                        # the properties below are optional
                        enable_regex_in_path=False,
                        response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                            body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                                failure_strings=["failureStrings"],
                                success_strings=["successStrings"]
                            ),
                            header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                                failure_values=["failureValues"],
                                name="name",
                                success_values=["successValues"]
                            ),
                            json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                                failure_values=["failureValues"],
                                identifier="identifier",
                                success_values=["successValues"]
                            ),
                            status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                                failure_codes=[123],
                                success_codes=[123]
                            )
                        )
                    ),
                    aws_managed_rules_atp_rule_set=wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty(
                        login_path="loginPath",
                
                        # the properties below are optional
                        enable_regex_in_path=False,
                        request_inspection=wafv2.CfnWebACL.RequestInspectionProperty(
                            password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            ),
                            payload_type="payloadType",
                            username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )
                        ),
                        response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                            body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                                failure_strings=["failureStrings"],
                                success_strings=["successStrings"]
                            ),
                            header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                                failure_values=["failureValues"],
                                name="name",
                                success_values=["successValues"]
                            ),
                            json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                                failure_values=["failureValues"],
                                identifier="identifier",
                                success_values=["successValues"]
                            ),
                            status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                                failure_codes=[123],
                                success_codes=[123]
                            )
                        )
                    ),
                    aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                        inspection_level="inspectionLevel",
                
                        # the properties below are optional
                        enable_machine_learning=False
                    ),
                    login_path="loginPath",
                    password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    ),
                    payload_type="payloadType",
                    username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__517661cb97cc58c609587fc6ca9907b2e23d8f3cd6e1e4034f3f6d82b85d2d77)
                check_type(argname="argument aws_managed_rules_acfp_rule_set", value=aws_managed_rules_acfp_rule_set, expected_type=type_hints["aws_managed_rules_acfp_rule_set"])
                check_type(argname="argument aws_managed_rules_atp_rule_set", value=aws_managed_rules_atp_rule_set, expected_type=type_hints["aws_managed_rules_atp_rule_set"])
                check_type(argname="argument aws_managed_rules_bot_control_rule_set", value=aws_managed_rules_bot_control_rule_set, expected_type=type_hints["aws_managed_rules_bot_control_rule_set"])
                check_type(argname="argument login_path", value=login_path, expected_type=type_hints["login_path"])
                check_type(argname="argument password_field", value=password_field, expected_type=type_hints["password_field"])
                check_type(argname="argument payload_type", value=payload_type, expected_type=type_hints["payload_type"])
                check_type(argname="argument username_field", value=username_field, expected_type=type_hints["username_field"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if aws_managed_rules_acfp_rule_set is not None:
                self._values["aws_managed_rules_acfp_rule_set"] = aws_managed_rules_acfp_rule_set
            if aws_managed_rules_atp_rule_set is not None:
                self._values["aws_managed_rules_atp_rule_set"] = aws_managed_rules_atp_rule_set
            if aws_managed_rules_bot_control_rule_set is not None:
                self._values["aws_managed_rules_bot_control_rule_set"] = aws_managed_rules_bot_control_rule_set
            if login_path is not None:
                self._values["login_path"] = login_path
            if password_field is not None:
                self._values["password_field"] = password_field
            if payload_type is not None:
                self._values["payload_type"] = payload_type
            if username_field is not None:
                self._values["username_field"] = username_field

        @builtins.property
        def aws_managed_rules_acfp_rule_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesACFPRuleSetProperty"]]:
            '''Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, ``AWSManagedRulesACFPRuleSet`` .

            Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.

            For information about using the ACFP managed rule group, see `AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html>`_ and `AWS WAF Fraud Control account creation fraud prevention (ACFP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesacfpruleset
            '''
            result = self._values.get("aws_managed_rules_acfp_rule_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesACFPRuleSetProperty"]], result)

        @builtins.property
        def aws_managed_rules_atp_rule_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesATPRuleSetProperty"]]:
            '''Additional configuration for using the account takeover prevention (ATP) managed rule group, ``AWSManagedRulesATPRuleSet`` .

            Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.

            This configuration replaces the individual configuration fields in ``ManagedRuleGroupConfig`` and provides additional feature configuration.

            For information about using the ATP managed rule group, see `AWS WAF Fraud Control account takeover prevention (ATP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html>`_ and `AWS WAF Fraud Control account takeover prevention (ATP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesatpruleset
            '''
            result = self._values.get("aws_managed_rules_atp_rule_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesATPRuleSetProperty"]], result)

        @builtins.property
        def aws_managed_rules_bot_control_rule_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesBotControlRuleSetProperty"]]:
            '''Additional configuration for using the Bot Control managed rule group.

            Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesbotcontrolruleset
            '''
            result = self._values.get("aws_managed_rules_bot_control_rule_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesBotControlRuleSetProperty"]], result)

        @builtins.property
        def login_path(self) -> typing.Optional[builtins.str]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-loginpath
            '''
            result = self._values.get("login_path")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def password_field(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-passwordfield
            '''
            result = self._values.get("password_field")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]], result)

        @builtins.property
        def payload_type(self) -> typing.Optional[builtins.str]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-payloadtype
            '''
            result = self._values.get("payload_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def username_field(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under the request inspection configuration for ``AWSManagedRulesATPRuleSet`` or ``AWSManagedRulesACFPRuleSet`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-usernamefield
            '''
            result = self._values.get("username_field")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]], result)

        def __eq__(self, rhs: typing