r'''
# Amazon SageMaker Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_sagemaker as sagemaker
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for SageMaker construct libraries](https://constructs.dev/search?q=sagemaker)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::SageMaker resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html) directly.

> An experimental construct library for this service is available in preview. Since it is not stable yet, it is distributed
> as a separate package so that you can pin its version independently of the rest of the CDK. See the package:
>
> <span class="package-reference">@aws-cdk/aws-sagemaker-alpha</span>

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::SageMaker](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    IResource as _IResource_c80c4260,
    ITaggable as _ITaggable_36806126,
    ITaggableV2 as _ITaggableV2_4e6798f8,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)
from ..aws_iam import Grant as _Grant_a7ae64f8, IGrantable as _IGrantable_71c4f5de


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnApp(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnApp",
):
    '''Creates a running app for the specified UserProfile.

    This operation is automatically invoked by Amazon SageMaker AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
    :cloudformationResource: AWS::SageMaker::App
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_app = sagemaker.CfnApp(self, "MyCfnApp",
            app_name="appName",
            app_type="appType",
            domain_id="domainId",
            user_profile_name="userProfileName",
        
            # the properties below are optional
            resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                instance_type="instanceType",
                lifecycle_config_arn="lifecycleConfigArn",
                sage_maker_image_arn="sageMakerImageArn",
                sage_maker_image_version_arn="sageMakerImageVersionArn"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnApp.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param app_name: The name of the app.
        :param app_type: The type of app.
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da207547ea530dc451bd8f33c6174b52ddcb5c9c348d4df84894bf6a2e2ada4a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppProps(
            app_name=app_name,
            app_type=app_type,
            domain_id=domain_id,
            user_profile_name=user_profile_name,
            resource_spec=resource_spec,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76b99b25d5846497c07368fb764a277782458a65eed58ef9398494227f100421)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed187eab5bee18dd53b1c928d2ccb0e90ab23f4cc25f17ae924a522946f79c87)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppArn")
    def attr_app_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the app, such as ``arn:aws:sagemaker:us-west-2:account-id:app/my-app-name`` .

        :cloudformationAttribute: AppArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appName")
    def app_name(self) -> builtins.str:
        '''The name of the app.'''
        return typing.cast(builtins.str, jsii.get(self, "appName"))

    @app_name.setter
    def app_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60338cb684c35adee2166006d8a5799b8774a901f8ecf9c2ac63ee250f468884)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="appType")
    def app_type(self) -> builtins.str:
        '''The type of app.'''
        return typing.cast(builtins.str, jsii.get(self, "appType"))

    @app_type.setter
    def app_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8050a2337833fa41f2f81b9f4cdfdb20ac505027fde6b3acfde898ba8800a4a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appType", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="domainId")
    def domain_id(self) -> builtins.str:
        '''The domain ID.'''
        return typing.cast(builtins.str, jsii.get(self, "domainId"))

    @domain_id.setter
    def domain_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__563ef9985abcabcd774803749869a87550a085a0ba09908e86c235da523c4d6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="userProfileName")
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.'''
        return typing.cast(builtins.str, jsii.get(self, "userProfileName"))

    @user_profile_name.setter
    def user_profile_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9231045eaa19a04e645ac4427861d86fb43ed510b73c35bda73d525ca58769ab)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "userProfileName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="resourceSpec")
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]], jsii.get(self, "resourceSpec"))

    @resource_spec.setter
    def resource_spec(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41e96c1fc82b070303e88c71e535d7b01017c13f06d3c4baf96523a46c257f09)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceSpec", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1e0fea60c9fcc98ad12e3c7e8c3b6ab7da4954ca4f3501ea10f407018e1d017)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnApp.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "lifecycle_config_arn": "lifecycleConfigArn",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            lifecycle_config_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker AI image and SageMaker AI image version, and the instance type that the version runs on.

            .. epigraph::

               When both ``SageMakerImageVersionArn`` and ``SageMakerImageArn`` are passed, ``SageMakerImageVersionArn`` is used. Any updates to ``SageMakerImageArn`` will not take effect if ``SageMakerImageVersionArn`` already exists in the ``ResourceSpec`` because ``SageMakerImageVersionArn`` always takes precedence. To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
            :param sage_maker_image_arn: The ARN of the SageMaker AI image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance. To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    lifecycle_config_arn="lifecycleConfigArn",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__59e5b32b2186d51d00289fe7e4950d7333bbf83c68ebe92d0bdb2eceb03ed406)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument lifecycle_config_arn", value=lifecycle_config_arn, expected_type=type_hints["lifecycle_config_arn"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if lifecycle_config_arn is not None:
                self._values["lifecycle_config_arn"] = lifecycle_config_arn
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lifecycle_config_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-lifecycleconfigarn
            '''
            result = self._values.get("lifecycle_config_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker AI image that the image version belongs to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnAppImageConfig(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig",
):
    '''Creates a configuration for running a SageMaker AI image as a KernelGateway app.

    The configuration specifies the Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
    :cloudformationResource: AWS::SageMaker::AppImageConfig
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_app_image_config = sagemaker.CfnAppImageConfig(self, "MyCfnAppImageConfig",
            app_image_config_name="appImageConfigName",
        
            # the properties below are optional
            code_editor_app_image_config=sagemaker.CfnAppImageConfig.CodeEditorAppImageConfigProperty(
                container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                        key="key",
                        value="value"
                    )]
                )
            ),
            jupyter_lab_app_image_config=sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty(
                container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                        key="key",
                        value="value"
                    )]
                )
            ),
            kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
        
                    # the properties below are optional
                    display_name="displayName"
                )],
        
                # the properties below are optional
                file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_image_config_name: builtins.str,
        code_editor_app_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.CodeEditorAppImageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        jupyter_lab_app_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.JupyterLabAppImageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        kernel_gateway_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param code_editor_app_image_config: The configuration for the file system and the runtime, such as the environment variables and entry point.
        :param jupyter_lab_app_image_config: The configuration for the file system and the runtime, such as the environment variables and entry point.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker AI image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5bddad57cf4d60d052f199fa18e6d92660d1097d0ea8d783dbde99f9c0a028d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppImageConfigProps(
            app_image_config_name=app_image_config_name,
            code_editor_app_image_config=code_editor_app_image_config,
            jupyter_lab_app_image_config=jupyter_lab_app_image_config,
            kernel_gateway_image_config=kernel_gateway_image_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bb94facbcc3b4d7b1de5aa9b83ce79e3da77d42eacbb7c16e3363a42398869b)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e215d4a475fe72e90d5dd156e3b19de51b712660dded95424cb42e06752b5395)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppImageConfigArn")
    def attr_app_image_config_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the AppImageConfig, such as ``arn:aws:sagemaker:us-west-2:account-id:app-image-config/my-app-image-config-name`` .

        :cloudformationAttribute: AppImageConfigArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppImageConfigArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appImageConfigName")
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.'''
        return typing.cast(builtins.str, jsii.get(self, "appImageConfigName"))

    @app_image_config_name.setter
    def app_image_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01fc550542699aeed5dd2d9ae695d23b69d475612dabef44e560292d011f07e0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appImageConfigName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="codeEditorAppImageConfig")
    def code_editor_app_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.CodeEditorAppImageConfigProperty"]]:
        '''The configuration for the file system and the runtime, such as the environment variables and entry point.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.CodeEditorAppImageConfigProperty"]], jsii.get(self, "codeEditorAppImageConfig"))

    @code_editor_app_image_config.setter
    def code_editor_app_image_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.CodeEditorAppImageConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4617d62c0b1a3643141e728729474c90e7cdd3d83d472bca3d71922b3b3ff93)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "codeEditorAppImageConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="jupyterLabAppImageConfig")
    def jupyter_lab_app_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.JupyterLabAppImageConfigProperty"]]:
        '''The configuration for the file system and the runtime, such as the environment variables and entry point.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.JupyterLabAppImageConfigProperty"]], jsii.get(self, "jupyterLabAppImageConfig"))

    @jupyter_lab_app_image_config.setter
    def jupyter_lab_app_image_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.JupyterLabAppImageConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aef39f4d8911200135ee7fdb47a08f8fa45069c4180729da9af97fa961d49e1a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jupyterLabAppImageConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]]:
        '''The configuration for the file system and kernels in the SageMaker AI image.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]], jsii.get(self, "kernelGatewayImageConfig"))

    @kernel_gateway_image_config.setter
    def kernel_gateway_image_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5129d030fcca687bbeeb2006415186516bbfe40d0eb84e4e1b19bda9233d80f0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kernelGatewayImageConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4462443074ff405184cbe7f0da1ea76390388cd02ffca07d1fbaf2ef6b2935b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.CodeEditorAppImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"container_config": "containerConfig"},
    )
    class CodeEditorAppImageConfigProperty:
        def __init__(
            self,
            *,
            container_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.ContainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for the file system and kernels in a SageMaker image running as a Code Editor app.

            The ``FileSystemConfig`` object is not supported.

            :param container_config: The container configuration for a SageMaker image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-codeeditorappimageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                code_editor_app_image_config_property = sagemaker.CfnAppImageConfig.CodeEditorAppImageConfigProperty(
                    container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                        container_arguments=["containerArguments"],
                        container_entrypoint=["containerEntrypoint"],
                        container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                            key="key",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9713ac75d63f3b659167fd7cd74d47b6ee84a2fa67cb9c59d4b991ead74b7536)
                check_type(argname="argument container_config", value=container_config, expected_type=type_hints["container_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if container_config is not None:
                self._values["container_config"] = container_config

        @builtins.property
        def container_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.ContainerConfigProperty"]]:
            '''The container configuration for a SageMaker image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-codeeditorappimageconfig.html#cfn-sagemaker-appimageconfig-codeeditorappimageconfig-containerconfig
            '''
            result = self._values.get("container_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.ContainerConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CodeEditorAppImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.ContainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "container_arguments": "containerArguments",
            "container_entrypoint": "containerEntrypoint",
            "container_environment_variables": "containerEnvironmentVariables",
        },
    )
    class ContainerConfigProperty:
        def __init__(
            self,
            *,
            container_arguments: typing.Optional[typing.Sequence[builtins.str]] = None,
            container_entrypoint: typing.Optional[typing.Sequence[builtins.str]] = None,
            container_environment_variables: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The configuration used to run the application image container.

            :param container_arguments: The arguments for the container when you're running the application.
            :param container_entrypoint: The entrypoint used to run the application in the container.
            :param container_environment_variables: The environment variables to set in the container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                container_config_property = sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                        key="key",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8b3f36d6876284a715882d9b4c7e6a8165d5d73b8f920f2b775524b827da5e17)
                check_type(argname="argument container_arguments", value=container_arguments, expected_type=type_hints["container_arguments"])
                check_type(argname="argument container_entrypoint", value=container_entrypoint, expected_type=type_hints["container_entrypoint"])
                check_type(argname="argument container_environment_variables", value=container_environment_variables, expected_type=type_hints["container_environment_variables"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if container_arguments is not None:
                self._values["container_arguments"] = container_arguments
            if container_entrypoint is not None:
                self._values["container_entrypoint"] = container_entrypoint
            if container_environment_variables is not None:
                self._values["container_environment_variables"] = container_environment_variables

        @builtins.property
        def container_arguments(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The arguments for the container when you're running the application.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerarguments
            '''
            result = self._values.get("container_arguments")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def container_entrypoint(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The entrypoint used to run the application in the container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerentrypoint
            '''
            result = self._values.get("container_entrypoint")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def container_environment_variables(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty"]]]]:
            '''The environment variables to set in the container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerenvironmentvariables
            '''
            result = self._values.get("container_environment_variables")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "value": "value"},
    )
    class CustomImageContainerEnvironmentVariableProperty:
        def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
            '''The environment variables to set in the container.

            :param key: The key that identifies a container environment variable.
            :param value: The value of the container environment variable.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                custom_image_container_environment_variable_property = sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                    key="key",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__98e74d81e240bc1b803f8637c6283046025ad0daa03d87091e2b1084f0f3d2c6)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "value": value,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The key that identifies a container environment variable.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the container environment variable.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomImageContainerEnvironmentVariableProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.FileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_gid": "defaultGid",
            "default_uid": "defaultUid",
            "mount_path": "mountPath",
        },
    )
    class FileSystemConfigProperty:
        def __init__(
            self,
            *,
            default_gid: typing.Optional[jsii.Number] = None,
            default_uid: typing.Optional[jsii.Number] = None,
            mount_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Elastic File System storage configuration for a SageMaker AI image.

            :param default_gid: The default POSIX group ID (GID). If not specified, defaults to ``100`` .
            :param default_uid: The default POSIX user ID (UID). If not specified, defaults to ``1000`` .
            :param mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                file_system_config_property = sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1bf5a54cea483597930e2acc9a52917d8d76e77acdbacf9c4d89c223259b37b0)
                check_type(argname="argument default_gid", value=default_gid, expected_type=type_hints["default_gid"])
                check_type(argname="argument default_uid", value=default_uid, expected_type=type_hints["default_uid"])
                check_type(argname="argument mount_path", value=mount_path, expected_type=type_hints["mount_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_gid is not None:
                self._values["default_gid"] = default_gid
            if default_uid is not None:
                self._values["default_uid"] = default_uid
            if mount_path is not None:
                self._values["mount_path"] = mount_path

        @builtins.property
        def default_gid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX group ID (GID).

            If not specified, defaults to ``100`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid
            '''
            result = self._values.get("default_gid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def default_uid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX user ID (UID).

            If not specified, defaults to ``1000`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid
            '''
            result = self._values.get("default_uid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def mount_path(self) -> typing.Optional[builtins.str]:
            '''The path within the image to mount the user's EFS home directory.

            The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath
            '''
            result = self._values.get("mount_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"container_config": "containerConfig"},
    )
    class JupyterLabAppImageConfigProperty:
        def __init__(
            self,
            *,
            container_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.ContainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for the file system and kernels in a SageMaker AI image running as a JupyterLab app.

            The ``FileSystemConfig`` object is not supported.

            :param container_config: The configuration used to run the application image container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                jupyter_lab_app_image_config_property = sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty(
                    container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                        container_arguments=["containerArguments"],
                        container_entrypoint=["containerEntrypoint"],
                        container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                            key="key",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bd5d67bc2196b2c23cd1a90bafc8959e0e0ab648e5d9b1751de6e158c015b17d)
                check_type(argname="argument container_config", value=container_config, expected_type=type_hints["container_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if container_config is not None:
                self._values["container_config"] = container_config

        @builtins.property
        def container_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.ContainerConfigProperty"]]:
            '''The configuration used to run the application image container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig-containerconfig
            '''
            result = self._values.get("container_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.ContainerConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JupyterLabAppImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "kernel_specs": "kernelSpecs",
            "file_system_config": "fileSystemConfig",
        },
    )
    class KernelGatewayImageConfigProperty:
        def __init__(
            self,
            *,
            kernel_specs: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.KernelSpecProperty", typing.Dict[builtins.str, typing.Any]]]]],
            file_system_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.FileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for the file system and kernels in a SageMaker AI image running as a KernelGateway app.

            :param kernel_specs: The specification of the Jupyter kernels in the image.
            :param file_system_config: The Amazon Elastic File System storage configuration for a SageMaker AI image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_gateway_image_config_property = sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
                
                        # the properties below are optional
                        display_name="displayName"
                    )],
                
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c86ddd58dc2d271d40ac6b9fe05c0ef722eda13bfa91f644e01a4fc42586ef1e)
                check_type(argname="argument kernel_specs", value=kernel_specs, expected_type=type_hints["kernel_specs"])
                check_type(argname="argument file_system_config", value=file_system_config, expected_type=type_hints["file_system_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "kernel_specs": kernel_specs,
            }
            if file_system_config is not None:
                self._values["file_system_config"] = file_system_config

        @builtins.property
        def kernel_specs(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelSpecProperty"]]]:
            '''The specification of the Jupyter kernels in the image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs
            '''
            result = self._values.get("kernel_specs")
            assert result is not None, "Required property 'kernel_specs' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelSpecProperty"]]], result)

        @builtins.property
        def file_system_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.FileSystemConfigProperty"]]:
            '''The Amazon Elastic File System storage configuration for a SageMaker AI image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig
            '''
            result = self._values.get("file_system_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.FileSystemConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelSpecProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "display_name": "displayName"},
    )
    class KernelSpecProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            display_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The specification of a Jupyter kernel.

            :param name: The name of the Jupyter kernel in the image. This value is case sensitive.
            :param display_name: The display name of the kernel.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_spec_property = sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
                
                    # the properties below are optional
                    display_name="displayName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ca51ca3546507d1ce51158d74b8fb17c6958c2747cd16f3b75aceb61d2159329)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument display_name", value=display_name, expected_type=type_hints["display_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }
            if display_name is not None:
                self._values["display_name"] = display_name

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the Jupyter kernel in the image.

            This value is case sensitive.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def display_name(self) -> typing.Optional[builtins.str]:
            '''The display name of the kernel.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname
            '''
            result = self._values.get("display_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_image_config_name": "appImageConfigName",
        "code_editor_app_image_config": "codeEditorAppImageConfig",
        "jupyter_lab_app_image_config": "jupyterLabAppImageConfig",
        "kernel_gateway_image_config": "kernelGatewayImageConfig",
        "tags": "tags",
    },
)
class CfnAppImageConfigProps:
    def __init__(
        self,
        *,
        app_image_config_name: builtins.str,
        code_editor_app_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnAppImageConfig.CodeEditorAppImageConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        jupyter_lab_app_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnAppImageConfig.JupyterLabAppImageConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        kernel_gateway_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnAppImageConfig.KernelGatewayImageConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnAppImageConfig``.

        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param code_editor_app_image_config: The configuration for the file system and the runtime, such as the environment variables and entry point.
        :param jupyter_lab_app_image_config: The configuration for the file system and the runtime, such as the environment variables and entry point.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker AI image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_app_image_config_props = sagemaker.CfnAppImageConfigProps(
                app_image_config_name="appImageConfigName",
            
                # the properties below are optional
                code_editor_app_image_config=sagemaker.CfnAppImageConfig.CodeEditorAppImageConfigProperty(
                    container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                        container_arguments=["containerArguments"],
                        container_entrypoint=["containerEntrypoint"],
                        container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                            key="key",
                            value="value"
                        )]
                    )
                ),
                jupyter_lab_app_image_config=sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty(
                    container_config=sagemaker.CfnAppImageConfig.ContainerConfigProperty(
                        container_arguments=["containerArguments"],
                        container_entrypoint=["containerEntrypoint"],
                        container_environment_variables=[sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty(
                            key="key",
                            value="value"
                        )]
                    )
                ),
                kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
            
                        # the properties below are optional
                        display_name="displayName"
                    )],
            
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff2672f4d222b0d6bb376871aa42ac2f1c78c70d0a1aa2fd3f19e08fcbb07857)
            check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
            check_type(argname="argument code_editor_app_image_config", value=code_editor_app_image_config, expected_type=type_hints["code_editor_app_image_config"])
            check_type(argname="argument jupyter_lab_app_image_config", value=jupyter_lab_app_image_config, expected_type=type_hints["jupyter_lab_app_image_config"])
            check_type(argname="argument kernel_gateway_image_config", value=kernel_gateway_image_config, expected_type=type_hints["kernel_gateway_image_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_image_config_name": app_image_config_name,
        }
        if code_editor_app_image_config is not None:
            self._values["code_editor_app_image_config"] = code_editor_app_image_config
        if jupyter_lab_app_image_config is not None:
            self._values["jupyter_lab_app_image_config"] = jupyter_lab_app_image_config
        if kernel_gateway_image_config is not None:
            self._values["kernel_gateway_image_config"] = kernel_gateway_image_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.

        Must be unique to your account.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
        '''
        result = self._values.get("app_image_config_name")
        assert result is not None, "Required property 'app_image_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def code_editor_app_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.CodeEditorAppImageConfigProperty]]:
        '''The configuration for the file system and the runtime, such as the environment variables and entry point.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-codeeditorappimageconfig
        '''
        result = self._values.get("code_editor_app_image_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.CodeEditorAppImageConfigProperty]], result)

    @builtins.property
    def jupyter_lab_app_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.JupyterLabAppImageConfigProperty]]:
        '''The configuration for the file system and the runtime, such as the environment variables and entry point.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig
        '''
        result = self._values.get("jupyter_lab_app_image_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.JupyterLabAppImageConfigProperty]], result)

    @builtins.property
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.KernelGatewayImageConfigProperty]]:
        '''The configuration for the file system and kernels in the SageMaker AI image.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
        '''
        result = self._values.get("kernel_gateway_image_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.KernelGatewayImageConfigProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppImageConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_name": "appName",
        "app_type": "appType",
        "domain_id": "domainId",
        "user_profile_name": "userProfileName",
        "resource_spec": "resourceSpec",
        "tags": "tags",
    },
)
class CfnAppProps:
    def __init__(
        self,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnApp.ResourceSpecProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnApp``.

        :param app_name: The name of the app.
        :param app_type: The type of app.
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_app_props = sagemaker.CfnAppProps(
                app_name="appName",
                app_type="appType",
                domain_id="domainId",
                user_profile_name="userProfileName",
            
                # the properties below are optional
                resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    lifecycle_config_arn="lifecycleConfigArn",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f03f5ccb1b2c4633c9ef3bee30e7429d047ef909520efe2cbcf88d12287682b)
            check_type(argname="argument app_name", value=app_name, expected_type=type_hints["app_name"])
            check_type(argname="argument app_type", value=app_type, expected_type=type_hints["app_type"])
            check_type(argname="argument domain_id", value=domain_id, expected_type=type_hints["domain_id"])
            check_type(argname="argument user_profile_name", value=user_profile_name, expected_type=type_hints["user_profile_name"])
            check_type(argname="argument resource_spec", value=resource_spec, expected_type=type_hints["resource_spec"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_name": app_name,
            "app_type": app_type,
            "domain_id": domain_id,
            "user_profile_name": user_profile_name,
        }
        if resource_spec is not None:
            self._values["resource_spec"] = resource_spec
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_name(self) -> builtins.str:
        '''The name of the app.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
        '''
        result = self._values.get("app_name")
        assert result is not None, "Required property 'app_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_type(self) -> builtins.str:
        '''The type of app.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
        '''
        result = self._values.get("app_type")
        assert result is not None, "Required property 'app_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def domain_id(self) -> builtins.str:
        '''The domain ID.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
        '''
        result = self._values.get("domain_id")
        assert result is not None, "Required property 'domain_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
        '''
        result = self._values.get("user_profile_name")
        assert result is not None, "Required property 'user_profile_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnApp.ResourceSpecProperty]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
        '''
        result = self._values.get("resource_spec")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnApp.ResourceSpecProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggableV2_4e6798f8)
class CfnCluster(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster",
):
    '''Creates a SageMaker HyperPod cluster.

    SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see `Amazon SageMaker HyperPod <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html>`_ in the *Amazon SageMaker Developer Guide* .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html
    :cloudformationResource: AWS::SageMaker::Cluster
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_cluster = sagemaker.CfnCluster(self, "MyCfnCluster",
            instance_groups=[sagemaker.CfnCluster.ClusterInstanceGroupProperty(
                execution_role="executionRole",
                instance_count=123,
                instance_group_name="instanceGroupName",
                instance_type="instanceType",
                life_cycle_config=sagemaker.CfnCluster.ClusterLifeCycleConfigProperty(
                    on_create="onCreate",
                    source_s3_uri="sourceS3Uri"
                ),
        
                # the properties below are optional
                current_count=123,
                instance_storage_configs=[sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty(
                    ebs_volume_config=sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty(
                        volume_size_in_gb=123
                    )
                )],
                on_start_deep_health_checks=["onStartDeepHealthChecks"],
                override_vpc_config=sagemaker.CfnCluster.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                ),
                threads_per_core=123
            )],
        
            # the properties below are optional
            cluster_name="clusterName",
            node_recovery="nodeRecovery",
            orchestrator=sagemaker.CfnCluster.OrchestratorProperty(
                eks=sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty(
                    cluster_arn="clusterArn"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            vpc_config=sagemaker.CfnCluster.VpcConfigProperty(
                security_group_ids=["securityGroupIds"],
                subnets=["subnets"]
            )
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        instance_groups: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.ClusterInstanceGroupProperty", typing.Dict[builtins.str, typing.Any]]]]],
        cluster_name: typing.Optional[builtins.str] = None,
        node_recovery: typing.Optional[builtins.str] = None,
        orchestrator: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.OrchestratorProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param instance_groups: The instance groups of the SageMaker HyperPod cluster. To delete an instance group, remove it from the array.
        :param cluster_name: The name of the SageMaker HyperPod cluster.
        :param node_recovery: Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod. Available values are ``Automatic`` for enabling and ``None`` for disabling.
        :param orchestrator: The orchestrator type for the SageMaker HyperPod cluster. Currently, ``'eks'`` is the only available option.
        :param tags: A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see `AddTags <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html>`_ . For more information on adding metadata to your AWS resources with tagging, see `Tagging AWS resources <https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html>`_ . For advice on best practices for managing AWS resources with tagging, see `Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy <https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf>`_ .
        :param vpc_config: Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see `Give SageMaker Access to Resources in your Amazon VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1441bbec1bb60460bda62b43765e140885fbb36e13b090ded31c919b4f27ca6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnClusterProps(
            instance_groups=instance_groups,
            cluster_name=cluster_name,
            node_recovery=node_recovery,
            orchestrator=orchestrator,
            tags=tags,
            vpc_config=vpc_config,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6bf38c830f5d60bc842320feb4dec3a217b386f6d517f4958fd6640eda19286)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23ff930ab861d82c5316349d3cb92e229dc76252f7fe321a81296dd8049216aa)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrClusterArn")
    def attr_cluster_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.

        :cloudformationAttribute: ClusterArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrClusterArn"))

    @builtins.property
    @jsii.member(jsii_name="attrClusterStatus")
    def attr_cluster_status(self) -> builtins.str:
        '''The status of the SageMaker HyperPod cluster.

        :cloudformationAttribute: ClusterStatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrClusterStatus"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the SageMaker HyperPod cluster is created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrFailureMessage")
    def attr_failure_message(self) -> builtins.str:
        '''The failure message of the SageMaker HyperPod cluster.

        :cloudformationAttribute: FailureMessage
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrFailureMessage"))

    @builtins.property
    @jsii.member(jsii_name="cdkTagManager")
    def cdk_tag_manager(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "cdkTagManager"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="instanceGroups")
    def instance_groups(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterInstanceGroupProperty"]]]:
        '''The instance groups of the SageMaker HyperPod cluster.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterInstanceGroupProperty"]]], jsii.get(self, "instanceGroups"))

    @instance_groups.setter
    def instance_groups(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterInstanceGroupProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e78b567f109d38ee1f8221168fe230f3c378e24d69dab4b08d88a01e417dae5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "instanceGroups", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="clusterName")
    def cluster_name(self) -> typing.Optional[builtins.str]:
        '''The name of the SageMaker HyperPod cluster.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterName"))

    @cluster_name.setter
    def cluster_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c72731c4fb9d1b248db78e05e403c022229ea39aa9884e7da88a1c9dd345bfb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "clusterName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="nodeRecovery")
    def node_recovery(self) -> typing.Optional[builtins.str]:
        '''Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nodeRecovery"))

    @node_recovery.setter
    def node_recovery(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4fbe65936cd747930256e6fb03ae406dcd4ea78b463b13ed47a475b84468f655)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "nodeRecovery", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="orchestrator")
    def orchestrator(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.OrchestratorProperty"]]:
        '''The orchestrator type for the SageMaker HyperPod cluster.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.OrchestratorProperty"]], jsii.get(self, "orchestrator"))

    @orchestrator.setter
    def orchestrator(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.OrchestratorProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b28b5799cdd1c859107ae372c1215ec60b0e0936d622ea46ffde5ae876779722)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "orchestrator", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tags"))

    @tags.setter
    def tags(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d084f139dda46e8f580a7b39f59ba1634670f397fa2aa5cb51e1f2f0cb2b6cbe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tags", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="vpcConfig")
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.VpcConfigProperty"]]:
        '''Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.VpcConfigProperty"]], jsii.get(self, "vpcConfig"))

    @vpc_config.setter
    def vpc_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.VpcConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__429f3349777c49353a90fb2e147d893a183eb1e53971ad423f88736afc16b14c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcConfig", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"volume_size_in_gb": "volumeSizeInGb"},
    )
    class ClusterEbsVolumeConfigProperty:
        def __init__(
            self,
            *,
            volume_size_in_gb: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Defines the configuration for attaching an additional Amazon Elastic Block Store (EBS) volume to each instance of the SageMaker HyperPod cluster instance group.

            To learn more, see `SageMaker HyperPod release notes: June 20, 2024 <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620>`_ .

            :param volume_size_in_gb: The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to ``/opt/sagemaker`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_ebs_volume_config_property = sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty(
                    volume_size_in_gb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9c3cafd59fbc880606685f87e0e67d5a5ce5428cfebf3db8838122cd54c4a361)
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if volume_size_in_gb is not None:
                self._values["volume_size_in_gb"] = volume_size_in_gb

        @builtins.property
        def volume_size_in_gb(self) -> typing.Optional[jsii.Number]:
            '''The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group.

            The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to ``/opt/sagemaker`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html#cfn-sagemaker-cluster-clusterebsvolumeconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterEbsVolumeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "instance_count": "instanceCount",
            "instance_group_name": "instanceGroupName",
            "instance_type": "instanceType",
            "life_cycle_config": "lifeCycleConfig",
            "current_count": "currentCount",
            "instance_storage_configs": "instanceStorageConfigs",
            "on_start_deep_health_checks": "onStartDeepHealthChecks",
            "override_vpc_config": "overrideVpcConfig",
            "threads_per_core": "threadsPerCore",
        },
    )
    class ClusterInstanceGroupProperty:
        def __init__(
            self,
            *,
            execution_role: builtins.str,
            instance_count: jsii.Number,
            instance_group_name: builtins.str,
            instance_type: builtins.str,
            life_cycle_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.ClusterLifeCycleConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            current_count: typing.Optional[jsii.Number] = None,
            instance_storage_configs: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.ClusterInstanceStorageConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            on_start_deep_health_checks: typing.Optional[typing.Sequence[builtins.str]] = None,
            override_vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            threads_per_core: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration information of the instance group within the HyperPod cluster.

            :param execution_role: The execution role for the instance group to assume.
            :param instance_count: The number of instances in an instance group of the SageMaker HyperPod cluster.
            :param instance_group_name: The name of the instance group of a SageMaker HyperPod cluster.
            :param instance_type: The instance type of the instance group of a SageMaker HyperPod cluster.
            :param life_cycle_config: The lifecycle configuration for a SageMaker HyperPod cluster.
            :param current_count: The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
            :param instance_storage_configs: The configurations of additional storage specified to the instance group where the instance (node) is launched.
            :param on_start_deep_health_checks: A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated. Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.
            :param override_vpc_config: Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC.
            :param threads_per_core: The number of threads per CPU core you specified under ``CreateCluster`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_instance_group_property = sagemaker.CfnCluster.ClusterInstanceGroupProperty(
                    execution_role="executionRole",
                    instance_count=123,
                    instance_group_name="instanceGroupName",
                    instance_type="instanceType",
                    life_cycle_config=sagemaker.CfnCluster.ClusterLifeCycleConfigProperty(
                        on_create="onCreate",
                        source_s3_uri="sourceS3Uri"
                    ),
                
                    # the properties below are optional
                    current_count=123,
                    instance_storage_configs=[sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty(
                        ebs_volume_config=sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty(
                            volume_size_in_gb=123
                        )
                    )],
                    on_start_deep_health_checks=["onStartDeepHealthChecks"],
                    override_vpc_config=sagemaker.CfnCluster.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    ),
                    threads_per_core=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3a19719ba9f3f785eebfbcc6ee996f6178944dfe9cbd5d5cdf73341bd47bcc03)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_group_name", value=instance_group_name, expected_type=type_hints["instance_group_name"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument life_cycle_config", value=life_cycle_config, expected_type=type_hints["life_cycle_config"])
                check_type(argname="argument current_count", value=current_count, expected_type=type_hints["current_count"])
                check_type(argname="argument instance_storage_configs", value=instance_storage_configs, expected_type=type_hints["instance_storage_configs"])
                check_type(argname="argument on_start_deep_health_checks", value=on_start_deep_health_checks, expected_type=type_hints["on_start_deep_health_checks"])
                check_type(argname="argument override_vpc_config", value=override_vpc_config, expected_type=type_hints["override_vpc_config"])
                check_type(argname="argument threads_per_core", value=threads_per_core, expected_type=type_hints["threads_per_core"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "execution_role": execution_role,
                "instance_count": instance_count,
                "instance_group_name": instance_group_name,
                "instance_type": instance_type,
                "life_cycle_config": life_cycle_config,
            }
            if current_count is not None:
                self._values["current_count"] = current_count
            if instance_storage_configs is not None:
                self._values["instance_storage_configs"] = instance_storage_configs
            if on_start_deep_health_checks is not None:
                self._values["on_start_deep_health_checks"] = on_start_deep_health_checks
            if override_vpc_config is not None:
                self._values["override_vpc_config"] = override_vpc_config
            if threads_per_core is not None:
                self._values["threads_per_core"] = threads_per_core

        @builtins.property
        def execution_role(self) -> builtins.str:
            '''The execution role for the instance group to assume.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-executionrole
            '''
            result = self._values.get("execution_role")
            assert result is not None, "Required property 'execution_role' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of instances in an instance group of the SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_group_name(self) -> builtins.str:
            '''The name of the instance group of a SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancegroupname
            '''
            result = self._values.get("instance_group_name")
            assert result is not None, "Required property 'instance_group_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The instance type of the instance group of a SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def life_cycle_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterLifeCycleConfigProperty"]:
            '''The lifecycle configuration for a SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-lifecycleconfig
            '''
            result = self._values.get("life_cycle_config")
            assert result is not None, "Required property 'life_cycle_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterLifeCycleConfigProperty"], result)

        @builtins.property
        def current_count(self) -> typing.Optional[jsii.Number]:
            '''The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-currentcount
            '''
            result = self._values.get("current_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def instance_storage_configs(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterInstanceStorageConfigProperty"]]]]:
            '''The configurations of additional storage specified to the instance group where the instance (node) is launched.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancestorageconfigs
            '''
            result = self._values.get("instance_storage_configs")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterInstanceStorageConfigProperty"]]]], result)

        @builtins.property
        def on_start_deep_health_checks(
            self,
        ) -> typing.Optional[typing.List[builtins.str]]:
            '''A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated.

            Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-onstartdeephealthchecks
            '''
            result = self._values.get("on_start_deep_health_checks")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def override_vpc_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.VpcConfigProperty"]]:
            '''Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.

            You can control access to and from your resources by configuring a VPC.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-overridevpcconfig
            '''
            result = self._values.get("override_vpc_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.VpcConfigProperty"]], result)

        @builtins.property
        def threads_per_core(self) -> typing.Optional[jsii.Number]:
            '''The number of threads per CPU core you specified under ``CreateCluster`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-threadspercore
            '''
            result = self._values.get("threads_per_core")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterInstanceGroupProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"ebs_volume_config": "ebsVolumeConfig"},
    )
    class ClusterInstanceStorageConfigProperty:
        def __init__(
            self,
            *,
            ebs_volume_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.ClusterEbsVolumeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group.

            To learn more, see `SageMaker HyperPod release notes: June 20, 2024 <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620>`_ .

            :param ebs_volume_config: Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to ``/opt/sagemaker`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_instance_storage_config_property = sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty(
                    ebs_volume_config=sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty(
                        volume_size_in_gb=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__43caf7c774c2545f8cff945a7d450e1acd83d6c11b7011b4cab6d25bea696218)
                check_type(argname="argument ebs_volume_config", value=ebs_volume_config, expected_type=type_hints["ebs_volume_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if ebs_volume_config is not None:
                self._values["ebs_volume_config"] = ebs_volume_config

        @builtins.property
        def ebs_volume_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterEbsVolumeConfigProperty"]]:
            '''Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.

            The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to ``/opt/sagemaker`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html#cfn-sagemaker-cluster-clusterinstancestorageconfig-ebsvolumeconfig
            '''
            result = self._values.get("ebs_volume_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterEbsVolumeConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterInstanceStorageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"on_create": "onCreate", "source_s3_uri": "sourceS3Uri"},
    )
    class ClusterLifeCycleConfigProperty:
        def __init__(
            self,
            *,
            on_create: builtins.str,
            source_s3_uri: builtins.str,
        ) -> None:
            '''The lifecycle configuration for a SageMaker HyperPod cluster.

            :param on_create: The file name of the entrypoint script of lifecycle scripts under ``SourceS3Uri`` . This entrypoint script runs during cluster creation.
            :param source_s3_uri: An Amazon S3 bucket path where your lifecycle scripts are stored. .. epigraph:: Make sure that the S3 bucket path starts with ``s3://sagemaker-`` . The `IAM role for SageMaker HyperPod <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod>`_ has the managed ```AmazonSageMakerClusterInstanceRolePolicy`` <https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html>`_ attached, which allows access to S3 buckets with the specific prefix ``sagemaker-`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_life_cycle_config_property = sagemaker.CfnCluster.ClusterLifeCycleConfigProperty(
                    on_create="onCreate",
                    source_s3_uri="sourceS3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9feca01a5855cd661f26c8dbf78069a1fe8e659c3851cf6144113cdfc3cdc58b)
                check_type(argname="argument on_create", value=on_create, expected_type=type_hints["on_create"])
                check_type(argname="argument source_s3_uri", value=source_s3_uri, expected_type=type_hints["source_s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "on_create": on_create,
                "source_s3_uri": source_s3_uri,
            }

        @builtins.property
        def on_create(self) -> builtins.str:
            '''The file name of the entrypoint script of lifecycle scripts under ``SourceS3Uri`` .

            This entrypoint script runs during cluster creation.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-oncreate
            '''
            result = self._values.get("on_create")
            assert result is not None, "Required property 'on_create' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def source_s3_uri(self) -> builtins.str:
            '''An Amazon S3 bucket path where your lifecycle scripts are stored.

            .. epigraph::

               Make sure that the S3 bucket path starts with ``s3://sagemaker-`` . The `IAM role for SageMaker HyperPod <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod>`_ has the managed ```AmazonSageMakerClusterInstanceRolePolicy`` <https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html>`_ attached, which allows access to S3 buckets with the specific prefix ``sagemaker-`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-sources3uri
            '''
            result = self._values.get("source_s3_uri")
            assert result is not None, "Required property 'source_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterLifeCycleConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_arn": "clusterArn"},
    )
    class ClusterOrchestratorEksConfigProperty:
        def __init__(self, *, cluster_arn: builtins.str) -> None:
            '''The configuration for the Amazon EKS cluster that is used as the orchestrator for the SageMaker HyperPod cluster.

            This includes the Amazon Resource Name (ARN) of the EKS cluster

            :param cluster_arn: The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_orchestrator_eks_config_property = sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty(
                    cluster_arn="clusterArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3b374679c88beb50318d8d8daa787c0b2f669d656010f29c3a5f6b1e4aa2fe2e)
                check_type(argname="argument cluster_arn", value=cluster_arn, expected_type=type_hints["cluster_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_arn": cluster_arn,
            }

        @builtins.property
        def cluster_arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html#cfn-sagemaker-cluster-clusterorchestratoreksconfig-clusterarn
            '''
            result = self._values.get("cluster_arn")
            assert result is not None, "Required property 'cluster_arn' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterOrchestratorEksConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty",
        jsii_struct_bases=[],
        name_mapping={"eks": "eks"},
    )
    class OrchestratorProperty:
        def __init__(
            self,
            *,
            eks: typing.Union[_IResolvable_da3f097b, typing.Union["CfnCluster.ClusterOrchestratorEksConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The orchestrator for a SageMaker HyperPod cluster.

            :param eks: The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                orchestrator_property = sagemaker.CfnCluster.OrchestratorProperty(
                    eks=sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty(
                        cluster_arn="clusterArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bd76c8323d4b86bae18d24faa04bdbae1945db1d8ba5ca351b2ce27ff07f8aa6)
                check_type(argname="argument eks", value=eks, expected_type=type_hints["eks"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "eks": eks,
            }

        @builtins.property
        def eks(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterOrchestratorEksConfigProperty"]:
            '''The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html#cfn-sagemaker-cluster-orchestrator-eks
            '''
            result = self._values.get("eks")
            assert result is not None, "Required property 'eks' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnCluster.ClusterOrchestratorEksConfigProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OrchestratorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.

            You can control access to and from your resources by configuring a VPC. For more information, see `Give SageMaker Access to Resources in your Amazon VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form ``sg-xxxxxxxx`` . Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnCluster.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c25c63e6108b86a8b4d868c1bea98ca33c486d394309500187dda4d53e294a1a)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form ``sg-xxxxxxxx`` .

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnClusterProps",
    jsii_struct_bases=[],
    name_mapping={
        "instance_groups": "instanceGroups",
        "cluster_name": "clusterName",
        "node_recovery": "nodeRecovery",
        "orchestrator": "orchestrator",
        "tags": "tags",
        "vpc_config": "vpcConfig",
    },
)
class CfnClusterProps:
    def __init__(
        self,
        *,
        instance_groups: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnCluster.ClusterInstanceGroupProperty, typing.Dict[builtins.str, typing.Any]]]]],
        cluster_name: typing.Optional[builtins.str] = None,
        node_recovery: typing.Optional[builtins.str] = None,
        orchestrator: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnCluster.OrchestratorProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnCluster.VpcConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnCluster``.

        :param instance_groups: The instance groups of the SageMaker HyperPod cluster. To delete an instance group, remove it from the array.
        :param cluster_name: The name of the SageMaker HyperPod cluster.
        :param node_recovery: Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod. Available values are ``Automatic`` for enabling and ``None`` for disabling.
        :param orchestrator: The orchestrator type for the SageMaker HyperPod cluster. Currently, ``'eks'`` is the only available option.
        :param tags: A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see `AddTags <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html>`_ . For more information on adding metadata to your AWS resources with tagging, see `Tagging AWS resources <https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html>`_ . For advice on best practices for managing AWS resources with tagging, see `Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy <https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf>`_ .
        :param vpc_config: Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see `Give SageMaker Access to Resources in your Amazon VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_cluster_props = sagemaker.CfnClusterProps(
                instance_groups=[sagemaker.CfnCluster.ClusterInstanceGroupProperty(
                    execution_role="executionRole",
                    instance_count=123,
                    instance_group_name="instanceGroupName",
                    instance_type="instanceType",
                    life_cycle_config=sagemaker.CfnCluster.ClusterLifeCycleConfigProperty(
                        on_create="onCreate",
                        source_s3_uri="sourceS3Uri"
                    ),
            
                    # the properties below are optional
                    current_count=123,
                    instance_storage_configs=[sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty(
                        ebs_volume_config=sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty(
                            volume_size_in_gb=123
                        )
                    )],
                    on_start_deep_health_checks=["onStartDeepHealthChecks"],
                    override_vpc_config=sagemaker.CfnCluster.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    ),
                    threads_per_core=123
                )],
            
                # the properties below are optional
                cluster_name="clusterName",
                node_recovery="nodeRecovery",
                orchestrator=sagemaker.CfnCluster.OrchestratorProperty(
                    eks=sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty(
                        cluster_arn="clusterArn"
                    )
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )],
                vpc_config=sagemaker.CfnCluster.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8126a53dc1741a2edde75d8d4eca79c53a2294746ea237dfba0097a758522ce)
            check_type(argname="argument instance_groups", value=instance_groups, expected_type=type_hints["instance_groups"])
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument node_recovery", value=node_recovery, expected_type=type_hints["node_recovery"])
            check_type(argname="argument orchestrator", value=orchestrator, expected_type=type_hints["orchestrator"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
            check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "instance_groups": instance_groups,
        }
        if cluster_name is not None:
            self._values["cluster_name"] = cluster_name
        if node_recovery is not None:
            self._values["node_recovery"] = node_recovery
        if orchestrator is not None:
            self._values["orchestrator"] = orchestrator
        if tags is not None:
            self._values["tags"] = tags
        if vpc_config is not None:
            self._values["vpc_config"] = vpc_config

    @builtins.property
    def instance_groups(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnCluster.ClusterInstanceGroupProperty]]]:
        '''The instance groups of the SageMaker HyperPod cluster.

        To delete an instance group, remove it from the array.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups
        '''
        result = self._values.get("instance_groups")
        assert result is not None, "Required property 'instance_groups' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnCluster.ClusterInstanceGroupProperty]]], result)

    @builtins.property
    def cluster_name(self) -> typing.Optional[builtins.str]:
        '''The name of the SageMaker HyperPod cluster.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername
        '''
        result = self._values.get("cluster_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_recovery(self) -> typing.Optional[builtins.str]:
        '''Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.

        Available values are ``Automatic`` for enabling and ``None`` for disabling.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery
        '''
        result = self._values.get("node_recovery")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def orchestrator(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnCluster.OrchestratorProperty]]:
        '''The orchestrator type for the SageMaker HyperPod cluster.

        Currently, ``'eks'`` is the only available option.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator
        '''
        result = self._values.get("orchestrator")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnCluster.OrchestratorProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.

        You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see `AddTags <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html>`_ .

        For more information on adding metadata to your AWS resources with tagging, see `Tagging AWS resources <https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html>`_ . For advice on best practices for managing AWS resources with tagging, see `Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy <https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    @builtins.property
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnCluster.VpcConfigProperty]]:
        '''Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.

        You can control access to and from your resources by configuring a VPC. For more information, see `Give SageMaker Access to Resources in your Amazon VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig
        '''
        result = self._values.get("vpc_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnCluster.VpcConfigProperty]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClusterProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnCodeRepository(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepository",
):
    '''Creates a Git repository as a resource in your SageMaker AI account.

    You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.

    The repository can be hosted either in `AWS CodeCommit <https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html>`_ or in any other Git repository.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
    :cloudformationResource: AWS::SageMaker::CodeRepository
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_code_repository = sagemaker.CfnCodeRepository(self, "MyCfnCodeRepository",
            git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                repository_url="repositoryUrl",
        
                # the properties below are optional
                branch="branch",
                secret_arn="secretArn"
            ),
        
            # the properties below are optional
            code_repository_name="codeRepositoryName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        git_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnCodeRepository.GitConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d17e8e1fa9515a89c3b89e14e1cbaa1aa86352b6f00eb195b7e040e28d143bb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnCodeRepositoryProps(
            git_config=git_config, code_repository_name=code_repository_name, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bff270252b12354536e07e0adbb6a99f9803ad93f114f8583a39db978a69fa3f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53e09fd075ed3c77659648b585bc9171f99083a9e3158fb4475a8f9ca5cf3e0a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCodeRepositoryName")
    def attr_code_repository_name(self) -> builtins.str:
        '''The name of the code repository, such as ``myCodeRepo`` .

        :cloudformationAttribute: CodeRepositoryName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCodeRepositoryName"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''
        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="gitConfig")
    def git_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"], jsii.get(self, "gitConfig"))

    @git_config.setter
    def git_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c94bc452a10c6b523d42959d6fd417ef8250361ea0998ca3fe23777c0086fc7d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "gitConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="codeRepositoryName")
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "codeRepositoryName"))

    @code_repository_name.setter
    def code_repository_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a0e39e1c2d26d01398986983ecd1ad412f11a1b0fcc8519842102d63b6f8dff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "codeRepositoryName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''List of tags for Code Repository.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0edc76fab76c0d705b0f03c8ebebadb42dab5a5dba0c022834796e6bd93720f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepository.GitConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_url": "repositoryUrl",
            "branch": "branch",
            "secret_arn": "secretArn",
        },
    )
    class GitConfigProperty:
        def __init__(
            self,
            *,
            repository_url: builtins.str,
            branch: typing.Optional[builtins.str] = None,
            secret_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies configuration details for a Git repository in your AWS account.

            :param repository_url: The URL where the Git repository is located.
            :param branch: The default branch for the Git repository.
            :param secret_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of ``AWSCURRENT`` and must be in the following format: ``{"username": *UserName* , "password": *Password* }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                git_config_property = sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
                
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7219bf58b36a2496c01c604d8614f6ea1469c9ff3b2619516c61e8e994b4dbe1)
                check_type(argname="argument repository_url", value=repository_url, expected_type=type_hints["repository_url"])
                check_type(argname="argument branch", value=branch, expected_type=type_hints["branch"])
                check_type(argname="argument secret_arn", value=secret_arn, expected_type=type_hints["secret_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_url": repository_url,
            }
            if branch is not None:
                self._values["branch"] = branch
            if secret_arn is not None:
                self._values["secret_arn"] = secret_arn

        @builtins.property
        def repository_url(self) -> builtins.str:
            '''The URL where the Git repository is located.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
            '''
            result = self._values.get("repository_url")
            assert result is not None, "Required property 'repository_url' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def branch(self) -> typing.Optional[builtins.str]:
            '''The default branch for the Git repository.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
            '''
            result = self._values.get("branch")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def secret_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository.

            The secret must have a staging label of ``AWSCURRENT`` and must be in the following format:

            ``{"username": *UserName* , "password": *Password* }``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
            '''
            result = self._values.get("secret_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GitConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepositoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "git_config": "gitConfig",
        "code_repository_name": "codeRepositoryName",
        "tags": "tags",
    },
)
class CfnCodeRepositoryProps:
    def __init__(
        self,
        *,
        git_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnCodeRepository.GitConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnCodeRepository``.

        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_code_repository_props = sagemaker.CfnCodeRepositoryProps(
                git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
            
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                ),
            
                # the properties below are optional
                code_repository_name="codeRepositoryName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c42ae1f0efe0811d1d204114356c2e0129a8f96e7aa17a0078217570e2903e4a)
            check_type(argname="argument git_config", value=git_config, expected_type=type_hints["git_config"])
            check_type(argname="argument code_repository_name", value=code_repository_name, expected_type=type_hints["code_repository_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "git_config": git_config,
        }
        if code_repository_name is not None:
            self._values["code_repository_name"] = code_repository_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def git_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnCodeRepository.GitConfigProperty]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
        '''
        result = self._values.get("git_config")
        assert result is not None, "Required property 'git_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnCodeRepository.GitConfigProperty], result)

    @builtins.property
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
        '''
        result = self._values.get("code_repository_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''List of tags for Code Repository.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCodeRepositoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnDataQualityJobDefinition(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition",
):
    '''Creates a definition for a job that monitors data quality and drift.

    For information about model monitor, see `Amazon SageMaker AI Model Monitor <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html>`_ .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
    :cloudformationResource: AWS::SageMaker::DataQualityJobDefinition
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_data_quality_job_definition = sagemaker.CfnDataQualityJobDefinition(self, "MyCfnDataQualityJobDefinition",
            data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                image_uri="imageUri",
        
                # the properties below are optional
                container_arguments=["containerArguments"],
                container_entrypoint=["containerEntrypoint"],
                environment={
                    "environment_key": "environment"
                },
                post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                record_preprocessor_source_uri="recordPreprocessorSourceUri"
            ),
            data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    exclude_features_attribute="excludeFeaturesAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                ),
                endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    exclude_features_attribute="excludeFeaturesAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            ),
            data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                ),
                statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        data_quality_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_input: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: The name of the endpoint used to run the monitoring job.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__738872af4917cc4a9c82bf05685c5bae3f1ac28542f97be97fe1f36cb1ba9f22)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDataQualityJobDefinitionProps(
            data_quality_app_specification=data_quality_app_specification,
            data_quality_job_input=data_quality_job_input,
            data_quality_job_output_config=data_quality_job_output_config,
            job_resources=job_resources,
            role_arn=role_arn,
            data_quality_baseline_config=data_quality_baseline_config,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f462bdc067fd44e78f92476e1454a553345a32c03985c226bd6553e4c637284a)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f21a6d8efc59d5475d29ea3eb6cb20caf535aef455944b20e340244406959398)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="dataQualityAppSpecification")
    def data_quality_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"]:
        '''Specifies the container that runs the monitoring job.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"], jsii.get(self, "dataQualityAppSpecification"))

    @data_quality_app_specification.setter
    def data_quality_app_specification(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d33a45fcf08092c0e108f025d8d4a4fc5872cb335e89ddc1f1c94f4d59bb502)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityAppSpecification", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobInput")
    def data_quality_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"]:
        '''A list of inputs for the monitoring job.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"], jsii.get(self, "dataQualityJobInput"))

    @data_quality_job_input.setter
    def data_quality_job_input(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22c7862ad92959194cfe02be5360375cb1cd67676ced8e0d0b87e7822af6ebde)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobInput", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"]:
        '''The output configuration for monitoring jobs.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"], jsii.get(self, "dataQualityJobOutputConfig"))

    @data_quality_job_output_config.setter
    def data_quality_job_output_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d029ecdfc6dcdfc0f1c62dff2897f3cb8d337d35dfcd0f36aa375a458bfcae9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobOutputConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"]:
        '''Identifies the resources to deploy for a monitoring job.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29ff9c2764c492630d1c5cc10ba5a43a5f0e949dfc7672232a6858b4fc679c55)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.'''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9f4267c53b0d493df8356e7f07d5aa41c917ddcfb48583b5137a53da86f4c13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="dataQualityBaselineConfig")
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]]:
        '''Configures the constraints and baselines for the monitoring job.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]], jsii.get(self, "dataQualityBaselineConfig"))

    @data_quality_baseline_config.setter
    def data_quality_baseline_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc8e3f65489594e046239891fcc106cf785fdad2448a7b413159063d4ec2baad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityBaselineConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint used to run the monitoring job.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2370e87925965d970102cac6226c13f49a0241b622030c01b2780bcb34a8ec19)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e482152aafd0979a35f29bc7cd47814ad3977ddb15a34b7c02c4b274ed8aea23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]]:
        '''Specifies networking configuration for the monitoring job.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5982fc49bfb59c2f83b476c77c84ae4a4e929f10dd2181018054a285dee2e87d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf7fbe101220056322d4ff1986d7e71874aee8887d658ccaa569c5000edefac0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bee59ab0f88a182cfa91a2b70a5d9d409b799e89e1e3e7f2ae811159215b0c10)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "exclude_features_attribute": "excludeFeaturesAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]]],
            local_path: builtins.str,
            exclude_features_attribute: typing.Optional[builtins.str] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the batch transform job.

            :param data_captured_destination_s3_uri: The Amazon S3 location being used to capture the data.
            :param dataset_format: The dataset format for your batch transform job.
            :param local_path: Path to the filesystem where the batch transform data is available to the container.
            :param exclude_features_attribute: The attributes of the input data to exclude from the analysis.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                batch_transform_input_property = sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    exclude_features_attribute="excludeFeaturesAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1b75b7b728f069893458a7695ee7ac0853bd8e23efc061ecf9829ddbd3a6dbdd)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument exclude_features_attribute", value=exclude_features_attribute, expected_type=type_hints["exclude_features_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if exclude_features_attribute is not None:
                self._values["exclude_features_attribute"] = exclude_features_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''The Amazon S3 location being used to capture the data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DatasetFormatProperty"]:
            '''The dataset format for your batch transform job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DatasetFormatProperty"], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the batch transform data is available to the container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def exclude_features_attribute(self) -> typing.Optional[builtins.str]:
            '''The attributes of the input data to exclude from the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-excludefeaturesattribute
            '''
            result = self._values.get("exclude_features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster of resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__441576a0f27acb41558fd46f071ce526510ec72480da00f75773b2a12013485c)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The constraints resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8248581daf5496221148b44514fed0064c1ab304d2086bed4146fdcb2aad1058)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html#cfn-sagemaker-dataqualityjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The CSV format.

            :param header: A boolean flag indicating if given CSV has header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6ee6b0eb617419663b4b8b32dff8e00b1f826734909bcd7b71edd3ae47218cec)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''A boolean flag indicating if given CSV has header.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html#cfn-sagemaker-dataqualityjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "image_uri": "imageUri",
            "container_arguments": "containerArguments",
            "container_entrypoint": "containerEntrypoint",
            "environment": "environment",
            "post_analytics_processor_source_uri": "postAnalyticsProcessorSourceUri",
            "record_preprocessor_source_uri": "recordPreprocessorSourceUri",
        },
    )
    class DataQualityAppSpecificationProperty:
        def __init__(
            self,
            *,
            image_uri: builtins.str,
            container_arguments: typing.Optional[typing.Sequence[builtins.str]] = None,
            container_entrypoint: typing.Optional[typing.Sequence[builtins.str]] = None,
            environment: typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]] = None,
            post_analytics_processor_source_uri: typing.Optional[builtins.str] = None,
            record_preprocessor_source_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about the container that a data quality monitoring job runs.

            :param image_uri: The container image that the data quality monitoring job runs.
            :param container_arguments: The arguments to send to the container that the monitoring job runs.
            :param container_entrypoint: The entrypoint for a container used to run a monitoring job.
            :param environment: Sets the environment variables in the container that the monitoring job runs.
            :param post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
            :param record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_app_specification_property = sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
                
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11ad7b07799b19e9d0c959ac5d51f2235fe7a36d54964df0e345ae8688d19922)
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument container_arguments", value=container_arguments, expected_type=type_hints["container_arguments"])
                check_type(argname="argument container_entrypoint", value=container_entrypoint, expected_type=type_hints["container_entrypoint"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument post_analytics_processor_source_uri", value=post_analytics_processor_source_uri, expected_type=type_hints["post_analytics_processor_source_uri"])
                check_type(argname="argument record_preprocessor_source_uri", value=record_preprocessor_source_uri, expected_type=type_hints["record_preprocessor_source_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "image_uri": image_uri,
            }
            if container_arguments is not None:
                self._values["container_arguments"] = container_arguments
            if container_entrypoint is not None:
                self._values["container_entrypoint"] = container_entrypoint
            if environment is not None:
                self._values["environment"] = environment
            if post_analytics_processor_source_uri is not None:
                self._values["post_analytics_processor_source_uri"] = post_analytics_processor_source_uri
            if record_preprocessor_source_uri is not None:
                self._values["record_preprocessor_source_uri"] = record_preprocessor_source_uri

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image that the data quality monitoring job runs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def container_arguments(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The arguments to send to the container that the monitoring job runs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerarguments
            '''
            result = self._values.get("container_arguments")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def container_entrypoint(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The entrypoint for a container used to run a monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerentrypoint
            '''
            result = self._values.get("container_entrypoint")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]]:
            '''Sets the environment variables in the container that the monitoring job runs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]], result)

        @builtins.property
        def post_analytics_processor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called after analysis has been performed.

            Applicable only for the built-in (first party) containers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-postanalyticsprocessorsourceuri
            '''
            result = self._values.get("post_analytics_processor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def record_preprocessor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called per row prior to running analysis.

            It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-recordpreprocessorsourceuri
            '''
            result = self._values.get("record_preprocessor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
            "statistics_resource": "statisticsResource",
        },
    )
    class DataQualityBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            statistics_resource: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.StatisticsResourceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :param baselining_job_name: The name of the job that performs baselining for the data quality monitoring job.
            :param constraints_resource: The constraints resource for a monitoring job.
            :param statistics_resource: Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_baseline_config_property = sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b3e1d4034764e8a8282c558559d3c93f2a5f23a1c1e5af323dec1e81a3e53562)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
                check_type(argname="argument statistics_resource", value=statistics_resource, expected_type=type_hints["statistics_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource
            if statistics_resource is not None:
                self._values["statistics_resource"] = statistics_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the job that performs baselining for the data quality monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ConstraintsResourceProperty"]]:
            '''The constraints resource for a monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ConstraintsResourceProperty"]], result)

        @builtins.property
        def statistics_resource(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StatisticsResourceProperty"]]:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-statisticsresource
            '''
            result = self._values.get("statistics_resource")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StatisticsResourceProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class DataQualityJobInputProperty:
        def __init__(
            self,
            *,
            batch_transform_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            endpoint_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The input for the data quality monitoring job.

            Currently endpoints are supported for input.

            :param batch_transform_input: Input object for the batch transform job.
            :param endpoint_input: Input object for the endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_job_input_property = sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        exclude_features_attribute="excludeFeaturesAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        exclude_features_attribute="excludeFeaturesAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__544455777165b176b920249188ba86b340ed4f77e4675683ab1522af2f4badf1)
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.BatchTransformInputProperty"]]:
            '''Input object for the batch transform job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.BatchTransformInputProperty"]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.EndpointInputProperty"]]:
            '''Input object for the endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.EndpointInputProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.JsonProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The dataset format of the data to monitor.

            :param csv: The CSV format.
            :param json: The Json format.
            :param parquet: A flag indicate if the dataset format is Parquet.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                dataset_format_property = sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                        line=False
                    ),
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__72b55db1656fb2bcc5633e486da62737a3f6d508f0d82b1ddd27a348b79b925b)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.CsvProperty"]]:
            '''The CSV format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.CsvProperty"]], result)

        @builtins.property
        def json(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.JsonProperty"]]:
            '''The Json format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.JsonProperty"]], result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''A flag indicate if the dataset format is Parquet.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "exclude_features_attribute": "excludeFeaturesAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            exclude_features_attribute: typing.Optional[builtins.str] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param exclude_features_attribute: The attributes of the input data to exclude from the analysis.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    exclude_features_attribute="excludeFeaturesAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__601305c78964ecde31263e255b74c778af52df31d8ef7cb4dd0eb2d3a6c28583)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument exclude_features_attribute", value=exclude_features_attribute, expected_type=type_hints["exclude_features_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if exclude_features_attribute is not None:
                self._values["exclude_features_attribute"] = exclude_features_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def exclude_features_attribute(self) -> typing.Optional[builtins.str]:
            '''The attributes of the input data to exclude from the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-excludefeaturesattribute
            '''
            result = self._values.get("exclude_features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key.

            Defaults to ``FullyReplicated``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The Json format.

            :param line: A boolean flag indicating if it is JSON line format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bbb228f2cc450802d77014c5761cf088476cfb96cca3c0ba2a6970015dab083b)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''A boolean flag indicating if it is JSON line format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html#cfn-sagemaker-dataqualityjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]]]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker AI uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__27ce8c4b0ff4f56b1642e027e445fa857c7e78618882f3465132c214aa3cefcd)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputProperty"]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputProperty"]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker AI uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__69c3b9716a30dd2e2aa8080d1792409d731b5674fbcbefd12fc5bc52de21eb03)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.S3OutputProperty"]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.S3OutputProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11b009463e27499e4088d4a4ff3eb32ac79a74cb796077eccef622663c7e78e1)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ClusterConfigProperty"]:
            '''The configuration for the cluster resources used to run the processing job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html#cfn-sagemaker-dataqualityjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ClusterConfigProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__80502177a4e5c8957484568926e21dfce6f3cab0e6313a34ee6bafac1ac94de4)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.VpcConfigProperty"]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.VpcConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c76b13f2c22215a02261c3002c67bac19ddd708df4133a02db04cf014d82159e)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            LocalPath is an absolute path for the output data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class StatisticsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The statistics resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the statistics resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                statistics_resource_property = sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e66a7ef5687cec2b47261b154bc007b591d204014d7afbc2b5d0700f91efa565)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the statistics resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html#cfn-sagemaker-dataqualityjobdefinition-statisticsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatisticsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a job can run.

            When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__080294505eaa0cfd3e651708dd9939428c82dd4a6df3e6ba24e70b042595bfc5)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.

            You can control access to and from your resources by configuring a VPC. For more information, see `Give SageMaker Access to Resources in your Amazon VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form ``sg-xxxxxxxx`` . Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9271b40223b97a4908066b16c9660259e46e7b1d4d693d3a2df71e4d8c31a21f)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form ``sg-xxxxxxxx`` .

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "data_quality_app_specification": "dataQualityAppSpecification",
        "data_quality_job_input": "dataQualityJobInput",
        "data_quality_job_output_config": "dataQualityJobOutputConfig",
        "job_resources": "jobResources",
        "role_arn": "roleArn",
        "data_quality_baseline_config": "dataQualityBaselineConfig",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnDataQualityJobDefinitionProps:
    def __init__(
        self,
        *,
        data_quality_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_input: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityJobInputProperty, typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDataQualityJobDefinition``.

        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: The name of the endpoint used to run the monitoring job.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_data_quality_job_definition_props = sagemaker.CfnDataQualityJobDefinitionProps(
                data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
            
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                ),
                data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        exclude_features_attribute="excludeFeaturesAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        exclude_features_attribute="excludeFeaturesAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                ),
                data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c5a27da69d6cdc76cfa83b348321ea97cb5023c0191ac16e8ba03f2ab76dac6)
            check_type(argname="argument data_quality_app_specification", value=data_quality_app_specification, expected_type=type_hints["data_quality_app_specification"])
            check_type(argname="argument data_quality_job_input", value=data_quality_job_input, expected_type=type_hints["data_quality_job_input"])
            check_type(argname="argument data_quality_job_output_config", value=data_quality_job_output_config, expected_type=type_hints["data_quality_job_output_config"])
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument data_quality_baseline_config", value=data_quality_baseline_config, expected_type=type_hints["data_quality_baseline_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_quality_app_specification": data_quality_app_specification,
            "data_quality_job_input": data_quality_job_input,
            "data_quality_job_output_config": data_quality_job_output_config,
            "job_resources": job_resources,
            "role_arn": role_arn,
        }
        if data_quality_baseline_config is not None:
            self._values["data_quality_baseline_config"] = data_quality_baseline_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def data_quality_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty]:
        '''Specifies the container that runs the monitoring job.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
        '''
        result = self._values.get("data_quality_app_specification")
        assert result is not None, "Required property 'data_quality_app_specification' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty], result)

    @builtins.property
    def data_quality_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityJobInputProperty]:
        '''A list of inputs for the monitoring job.

        Currently endpoints are supported as monitoring inputs.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
        '''
        result = self._values.get("data_quality_job_input")
        assert result is not None, "Required property 'data_quality_job_input' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityJobInputProperty], result)

    @builtins.property
    def data_quality_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringOutputConfigProperty]:
        '''The output configuration for monitoring jobs.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
        '''
        result = self._values.get("data_quality_job_output_config")
        assert result is not None, "Required property 'data_quality_job_output_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringOutputConfigProperty], result)

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringResourcesProperty]:
        '''Identifies the resources to deploy for a monitoring job.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringResourcesProperty], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty]]:
        '''Configures the constraints and baselines for the monitoring job.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
        '''
        result = self._values.get("data_quality_baseline_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint used to run the monitoring job.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.NetworkConfigProperty]]:
        '''Specifies networking configuration for the monitoring job.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.NetworkConfigProperty]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.StoppingConditionProperty]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.StoppingConditionProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDataQualityJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnDevice(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDevice",
):
    '''The ``AWS::SageMaker::Device`` resource is an Amazon SageMaker resource type that allows you to register your Devices against an existing SageMaker Edge Manager DeviceFleet.

    Each device must be listed individually in the CFN specification.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
    :cloudformationResource: AWS::SageMaker::Device
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_device = sagemaker.CfnDevice(self, "MyCfnDevice",
            device_fleet_name="deviceFleetName",
        
            # the properties below are optional
            device=sagemaker.CfnDevice.DeviceProperty(
                device_name="deviceName",
        
                # the properties below are optional
                description="description",
                iot_thing_name="iotThingName"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDevice.DeviceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3abcdef1d2ea64456171c0cbf08b0c16eae8b8d28f4815c6515aabe2e523270)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceProps(
            device_fleet_name=device_fleet_name, device=device, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a8d3dc37aebc873d0aeea906ad87c927cdf82cf7e9a80e28d7b2195c636a2b4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0506dad1f49196fefcbd13d570aff49c31dda0672510b37b43320d943cf268b7)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.'''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__946425d0a7da6f130191f8a0815402b1bda48bcc0627c7ed770b3d4f07198f79)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="device")
    def device(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]]:
        '''Edge device you want to create.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]], jsii.get(self, "device"))

    @device.setter
    def device(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76314385f9853a3bfe385c949d5b6a43dee2c54b479381ea9765bd304cba6476)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "device", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d6f7f7a38eb4816071db5d533c111cb8649922632e188b4325a82dd00675042)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDevice.DeviceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "description": "description",
            "iot_thing_name": "iotThingName",
        },
    )
    class DeviceProperty:
        def __init__(
            self,
            *,
            device_name: builtins.str,
            description: typing.Optional[builtins.str] = None,
            iot_thing_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information of a particular device.

            :param device_name: The name of the device.
            :param description: Description of the device.
            :param iot_thing_name: AWS Internet of Things (IoT) object name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                device_property = sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
                
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__43b40b55245978699774f9b5e56191c22e81a73552561f7190f32a80a2311431)
                check_type(argname="argument device_name", value=device_name, expected_type=type_hints["device_name"])
                check_type(argname="argument description", value=description, expected_type=type_hints["description"])
                check_type(argname="argument iot_thing_name", value=iot_thing_name, expected_type=type_hints["iot_thing_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "device_name": device_name,
            }
            if description is not None:
                self._values["description"] = description
            if iot_thing_name is not None:
                self._values["iot_thing_name"] = iot_thing_name

        @builtins.property
        def device_name(self) -> builtins.str:
            '''The name of the device.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-devicename
            '''
            result = self._values.get("device_name")
            assert result is not None, "Required property 'device_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            '''Description of the device.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-description
            '''
            result = self._values.get("description")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def iot_thing_name(self) -> typing.Optional[builtins.str]:
            '''AWS Internet of Things (IoT) object name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-iotthingname
            '''
            result = self._values.get("iot_thing_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeviceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnDeviceFleet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleet",
):
    '''The ``AWS::SageMaker::DeviceFleet`` resource is an Amazon SageMaker resource type that allows you to create a DeviceFleet that manages your SageMaker Edge Manager Devices.

    You must register your devices against the ``DeviceFleet`` separately.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
    :cloudformationResource: AWS::SageMaker::DeviceFleet
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_device_fleet = sagemaker.CfnDeviceFleet(self, "MyCfnDeviceFleet",
            device_fleet_name="deviceFleetName",
            output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                s3_output_location="s3OutputLocation",
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            description="description",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5c11192822cf6a7274bcacd8c8147149a9111d09d2701f9547a16c89d2d2c06)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceFleetProps(
            device_fleet_name=device_fleet_name,
            output_config=output_config,
            role_arn=role_arn,
            description=description,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cb330fe6c6b70769b12318fb10174ed458f16ae84753429881454642514e4e9)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d262d2dfa0a766b9ef88b7d0180a9a007a4589ca64179969667e5c835a27524)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.'''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc1ebf19bb8d12d33f46194921833987903a772f1f8219286b1e902fb541b0a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="outputConfig")
    def output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"]:
        '''The output configuration for storing sample data collected by the fleet.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"], jsii.get(self, "outputConfig"))

    @output_config.setter
    def output_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7fc98ed95422b4cc9f6b42674ea7654ba952161c116c8516d593f0414b33cb81)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "outputConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).'''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2032a1e19b80658a94b8bed07221ad9072ce3559dc064b8ec7b727b4080ed28a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eeedc707895aa3002c706479748ee7820bd530fd99db1b35f3953bbe5c0681d5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f53f02381a9dd5e349f8db9586bd32761b8f0f1adab26fa442b152d97868e36)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_output_location": "s3OutputLocation",
            "kms_key_id": "kmsKeyId",
        },
    )
    class EdgeOutputConfigProperty:
        def __init__(
            self,
            *,
            s3_output_location: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for storing sample data collected by the fleet.

            :param s3_output_location: The Amazon Simple Storage (S3) bucket URI.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                edge_output_config_property = sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1eb8f35c611515659c53b813c3fef2016ed31d467e5dfe3e9720e7ec96acc382)
                check_type(argname="argument s3_output_location", value=s3_output_location, expected_type=type_hints["s3_output_location"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output_location": s3_output_location,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_output_location(self) -> builtins.str:
            '''The Amazon Simple Storage (S3) bucket URI.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-s3outputlocation
            '''
            result = self._values.get("s3_output_location")
            assert result is not None, "Required property 's3_output_location' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.

            If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EdgeOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleetProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "output_config": "outputConfig",
        "role_arn": "roleArn",
        "description": "description",
        "tags": "tags",
    },
)
class CfnDeviceFleetProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDeviceFleet.EdgeOutputConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDeviceFleet``.

        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_device_fleet_props = sagemaker.CfnDeviceFleetProps(
                device_fleet_name="deviceFleetName",
                output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                description="description",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2dc3d0951ad79f71353b3ad32783516a322539ca7717d79ffa74bab3f2b0300)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
            "output_config": output_config,
            "role_arn": role_arn,
        }
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDeviceFleet.EdgeOutputConfigProperty]:
        '''The output configuration for storing sample data collected by the fleet.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
        '''
        result = self._values.get("output_config")
        assert result is not None, "Required property 'output_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDeviceFleet.EdgeOutputConfigProperty], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.

        Each tag consists of a key and a value, both of which you define.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceFleetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "device": "device",
        "tags": "tags",
    },
)
class CfnDeviceProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDevice.DeviceProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDevice``.

        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_device_props = sagemaker.CfnDeviceProps(
                device_fleet_name="deviceFleetName",
            
                # the properties below are optional
                device=sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
            
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73e7f76537702c6066451ab74616be8106d0374344002438b8bafb5d35f7440e)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument device", value=device, expected_type=type_hints["device"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
        }
        if device is not None:
            self._values["device"] = device
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def device(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDevice.DeviceProperty]]:
        '''Edge device you want to create.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
        '''
        result = self._values.get("device")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDevice.DeviceProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.

        Each tag consists of a key and a value, both of which you define.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnDomain(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain",
):
    '''Creates a ``Domain`` .

    A domain consists of an associated Amazon Elastic File System volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.

    *EFS storage*

    When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.

    SageMaker AI uses the AWS Key Management Service ( AWS KMS) to encrypt the EFS volume attached to the domain with an AWS managed key by default. For more control, you can specify a customer managed key. For more information, see `Protect Data at Rest Using Encryption <https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html>`_ .

    *VPC configuration*

    All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other traffic, you can specify the ``AppNetworkAccessType`` parameter. ``AppNetworkAccessType`` corresponds to the network access type that you choose when you onboard to the domain. The following options are available:

    - ``PublicInternetOnly`` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows internet access. This is the default value.
    - ``VpcOnly`` - All traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.

    When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and your security groups allow outbound connections.
    .. epigraph::

       NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a Amazon SageMaker AI Studio app successfully.

    For more information, see `Connect Amazon SageMaker AI Studio Notebooks to Resources in a VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html>`_ .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
    :cloudformationResource: AWS::SageMaker::Domain
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_domain = sagemaker.CfnDomain(self, "MyCfnDomain",
            auth_mode="authMode",
            default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                execution_role="executionRole",
        
                # the properties below are optional
                code_editor_app_settings=sagemaker.CfnDomain.CodeEditorAppSettingsProperty(
                    app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                        idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                            idle_timeout_in_minutes=123,
                            lifecycle_management="lifecycleManagement",
                            max_idle_timeout_in_minutes=123,
                            min_idle_timeout_in_minutes=123
                        )
                    ),
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                    efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                        file_system_id="fileSystemId",
        
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    ),
                    f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                        file_system_id="fileSystemId",
        
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    )
                )],
                custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                    gid=123,
                    uid=123
                ),
                default_landing_uri="defaultLandingUri",
                jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                    app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                        idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                            idle_timeout_in_minutes=123,
                            lifecycle_management="lifecycleManagement",
                            max_idle_timeout_in_minutes=123,
                            min_idle_timeout_in_minutes=123
                        )
                    ),
                    code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                        repository_url="repositoryUrl"
                    )],
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                ),
                security_groups=["securityGroups"],
                sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                ),
                space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                    default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                        default_ebs_volume_size_in_gb=123,
                        maximum_ebs_volume_size_in_gb=123
                    )
                ),
                studio_web_portal="studioWebPortal",
                studio_web_portal_settings=sagemaker.CfnDomain.StudioWebPortalSettingsProperty(
                    hidden_app_types=["hiddenAppTypes"],
                    hidden_ml_tools=["hiddenMlTools"]
                )
            ),
            domain_name="domainName",
            subnet_ids=["subnetIds"],
            vpc_id="vpcId",
        
            # the properties below are optional
            app_network_access_type="appNetworkAccessType",
            app_security_group_management="appSecurityGroupManagement",
            default_space_settings=sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                execution_role="executionRole",
        
                # the properties below are optional
                custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                    efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                        file_system_id="fileSystemId",
        
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    ),
                    f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                        file_system_id="fileSystemId",
        
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    )
                )],
                custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                    gid=123,
                    uid=123
                ),
                jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                    app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                        idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                            idle_timeout_in_minutes=123,
                            lifecycle_management="lifecycleManagement",
                            max_idle_timeout_in_minutes=123,
                            min_idle_timeout_in_minutes=123
                        )
                    ),
                    code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                        repository_url="repositoryUrl"
                    )],
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                ),
                security_groups=["securityGroups"],
                space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                    default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                        default_ebs_volume_size_in_gb=123,
                        maximum_ebs_volume_size_in_gb=123
                    )
                )
            ),
            domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                docker_settings=sagemaker.CfnDomain.DockerSettingsProperty(
                    enable_docker_access="enableDockerAccess",
                    vpc_only_trusted_accounts=["vpcOnlyTrustedAccounts"]
                ),
                execution_role_identity_config="executionRoleIdentityConfig",
                r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
        
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                ),
                security_group_ids=["securityGroupIds"]
            ),
            kms_key_id="kmsKeyId",
            tag_propagation="tagPropagation",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.UserSettingsProperty", typing.Dict[builtins.str, typing.Any]]],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        default_space_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DefaultSpaceSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DomainSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tag_propagation: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker AI , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` . *Allowed Values* : ``Service`` | ``Customer``
        :param default_space_settings: The default settings for shared spaces that users create in the domain. SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tag_propagation: Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a98e719c58aab3299db52c4086bfb65ee6438882423af805478e9ea3fda998f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDomainProps(
            auth_mode=auth_mode,
            default_user_settings=default_user_settings,
            domain_name=domain_name,
            subnet_ids=subnet_ids,
            vpc_id=vpc_id,
            app_network_access_type=app_network_access_type,
            app_security_group_management=app_security_group_management,
            default_space_settings=default_space_settings,
            domain_settings=domain_settings,
            kms_key_id=kms_key_id,
            tag_propagation=tag_propagation,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__054b92073504f806c8065046fb755c4424b063db14ea01d662bf1a3799b913a9)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27b8551bfeb2abb4c1faf2dad1939e476fbe0902c5876e849b3a2a2526fef410)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainArn")
    def attr_domain_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the Domain, such as ``arn:aws:sagemaker:us-west-2:account-id:domain/my-domain-name`` .

        :cloudformationAttribute: DomainArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainArn"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainId")
    def attr_domain_id(self) -> builtins.str:
        '''The Domain ID.

        :cloudformationAttribute: DomainId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainId"))

    @builtins.property
    @jsii.member(jsii_name="attrHomeEfsFileSystemId")
    def attr_home_efs_file_system_id(self) -> builtins.str:
        '''The ID of the Amazon Elastic File System (EFS) managed by this Domain.

        :cloudformationAttribute: HomeEfsFileSystemId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrHomeEfsFileSystemId"))

    @builtins.property
    @jsii.member(jsii_name="attrSecurityGroupIdForDomainBoundary")
    def attr_security_group_id_for_domain_boundary(self) -> builtins.str:
        '''The ID of the security group that authorizes traffic between the ``RSessionGateway`` apps and the ``RStudioServerPro`` app.

        :cloudformationAttribute: SecurityGroupIdForDomainBoundary
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSecurityGroupIdForDomainBoundary"))

    @builtins.property
    @jsii.member(jsii_name="attrSingleSignOnApplicationArn")
    def attr_single_sign_on_application_arn(self) -> builtins.str:
        '''The ARN of the application managed by SageMaker in IAM Identity Center.

        This value is only returned for domains created after October 1, 2023.

        :cloudformationAttribute: SingleSignOnApplicationArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSingleSignOnApplicationArn"))

    @builtins.property
    @jsii.member(jsii_name="attrSingleSignOnManagedApplicationInstanceId")
    def attr_single_sign_on_managed_application_instance_id(self) -> builtins.str:
        '''The IAM Identity Center managed application instance ID.

        :cloudformationAttribute: SingleSignOnManagedApplicationInstanceId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSingleSignOnManagedApplicationInstanceId"))

    @builtins.property
    @jsii.member(jsii_name="attrUrl")
    def attr_url(self) -> builtins.str:
        '''The URL for the Domain.

        :cloudformationAttribute: Url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrUrl"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="authMode")
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.'''
        return typing.cast(builtins.str, jsii.get(self, "authMode"))

    @auth_mode.setter
    def auth_mode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a67fdecfd1f892afa5b5efc44318f01b5d8286aec268d01fb468966f5a4710fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "authMode", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="defaultUserSettings")
    def default_user_settings(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"]:
        '''The default user settings.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"], jsii.get(self, "defaultUserSettings"))

    @default_user_settings.setter
    def default_user_settings(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14263bf0f3dae6b010cee5a9a7de240a41a79f8f655ed36f1444e579a936fc5d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultUserSettings", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        '''The domain name.'''
        return typing.cast(builtins.str, jsii.get(self, "domainName"))

    @domain_name.setter
    def domain_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76d0ed31020f4eadd792cd5d7897939d99ef06ed557509d040b88b5f6e9cca9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "subnetIds"))

    @subnet_ids.setter
    def subnet_ids(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6556642f81d027deb80da8cf42e945b715e6966790a8ab41e68da4acaaf3a9eb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "subnetIds", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.'''
        return typing.cast(builtins.str, jsii.get(self, "vpcId"))

    @vpc_id.setter
    def vpc_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0aca1d756799cd6468a535127ee441605b164991ff11c6effe6c40c519ff5c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="appNetworkAccessType")
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic.

        The default value is ``PublicInternetOnly`` .
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appNetworkAccessType"))

    @app_network_access_type.setter
    def app_network_access_type(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66770e15c78955514aa53519369aa0389610ff7cbd94793f5ee385fb2c96a0cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appNetworkAccessType", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="appSecurityGroupManagement")
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appSecurityGroupManagement"))

    @app_security_group_management.setter
    def app_security_group_management(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfaaa586058b1b8f2197fde6ee73bb9b0d7df2f79e82996c1d47c48d7c51b1c5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appSecurityGroupManagement", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="defaultSpaceSettings")
    def default_space_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]]:
        '''The default settings for shared spaces that users create in the domain.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]], jsii.get(self, "defaultSpaceSettings"))

    @default_space_settings.setter
    def default_space_settings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5d0e056a481e730ebed277f032ef13b3337668137169bd966cc3fc66b40464e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultSpaceSettings", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="domainSettings")
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]], jsii.get(self, "domainSettings"))

    @domain_settings.setter
    def domain_settings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a80dc18546bde6c82a5e78a8e60c044ce75c01a498f10fd5d6422d2fecfbbd61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainSettings", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__705995dde312c66454de0b9e9f6a8d7e895beb5c34f61395d1dab1369dd40850)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagPropagation")
    def tag_propagation(self) -> typing.Optional[builtins.str]:
        '''Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tagPropagation"))

    @tag_propagation.setter
    def tag_propagation(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3d58c631c2c753ff6694e786e5b7271c0e621cef1413bccab572fda47a21ab3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagPropagation", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags to associated with the Domain.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d1a70c209913231f1eb30dba814eb3a3bc58f6f4341ea1392c5061d8dbc8d51)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.AppLifecycleManagementProperty",
        jsii_struct_bases=[],
        name_mapping={"idle_settings": "idleSettings"},
    )
    class AppLifecycleManagementProperty:
        def __init__(
            self,
            *,
            idle_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.IdleSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Settings that are used to configure and manage the lifecycle of Amazon SageMaker Studio applications.

            :param idle_settings: Settings related to idle shutdown of Studio applications.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-applifecyclemanagement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                app_lifecycle_management_property = sagemaker.CfnDomain.AppLifecycleManagementProperty(
                    idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                        idle_timeout_in_minutes=123,
                        lifecycle_management="lifecycleManagement",
                        max_idle_timeout_in_minutes=123,
                        min_idle_timeout_in_minutes=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7effd4411e9cef3285cdb58cb66208ce801332047fd17028be8db70aea812d86)
                check_type(argname="argument idle_settings", value=idle_settings, expected_type=type_hints["idle_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if idle_settings is not None:
                self._values["idle_settings"] = idle_settings

        @builtins.property
        def idle_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.IdleSettingsProperty"]]:
            '''Settings related to idle shutdown of Studio applications.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-applifecyclemanagement.html#cfn-sagemaker-domain-applifecyclemanagement-idlesettings
            '''
            result = self._values.get("idle_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.IdleSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AppLifecycleManagementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CodeEditorAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "app_lifecycle_management": "appLifecycleManagement",
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
            "lifecycle_config_arns": "lifecycleConfigArns",
        },
    )
    class CodeEditorAppSettingsProperty:
        def __init__(
            self,
            *,
            app_lifecycle_management: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.AppLifecycleManagementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            lifecycle_config_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The Code Editor application settings.

            For more information about Code Editor, see `Get started with Code Editor in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/code-editor.html>`_ .

            :param app_lifecycle_management: Settings that are used to configure and manage the lifecycle of CodeEditor applications.
            :param custom_images: A list of custom SageMaker images that are configured to run as a Code Editor app.
            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
            :param lifecycle_config_arns: The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                code_editor_app_settings_property = sagemaker.CfnDomain.CodeEditorAppSettingsProperty(
                    app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                        idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                            idle_timeout_in_minutes=123,
                            lifecycle_management="lifecycleManagement",
                            max_idle_timeout_in_minutes=123,
                            min_idle_timeout_in_minutes=123
                        )
                    ),
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fc744bb58e49877db429fbdcea73e31d9e5326375463940bb48321473f97dfaa)
                check_type(argname="argument app_lifecycle_management", value=app_lifecycle_management, expected_type=type_hints["app_lifecycle_management"])
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument lifecycle_config_arns", value=lifecycle_config_arns, expected_type=type_hints["lifecycle_config_arns"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if app_lifecycle_management is not None:
                self._values["app_lifecycle_management"] = app_lifecycle_management
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if lifecycle_config_arns is not None:
                self._values["lifecycle_config_arns"] = lifecycle_config_arns

        @builtins.property
        def app_lifecycle_management(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.AppLifecycleManagementProperty"]]:
            '''Settings that are used to configure and manage the lifecycle of CodeEditor applications.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-applifecyclemanagement
            '''
            result = self._values.get("app_lifecycle_management")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.AppLifecycleManagementProperty"]], result)

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker images that are configured to run as a Code Editor app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def lifecycle_config_arns(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-lifecycleconfigarns
            '''
            result = self._values.get("lifecycle_config_arns")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CodeEditorAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CodeRepositoryProperty",
        jsii_struct_bases=[],
        name_mapping={"repository_url": "repositoryUrl"},
    )
    class CodeRepositoryProperty:
        def __init__(self, *, repository_url: builtins.str) -> None:
            '''A Git repository that SageMaker AI automatically displays to users for cloning in the JupyterServer application.

            :param repository_url: The URL of the Git repository.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                code_repository_property = sagemaker.CfnDomain.CodeRepositoryProperty(
                    repository_url="repositoryUrl"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1ca7d1d6cdc42171e1cf7375238fa986babdf04453e194f3a1f0615c62b65fa1)
                check_type(argname="argument repository_url", value=repository_url, expected_type=type_hints["repository_url"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_url": repository_url,
            }

        @builtins.property
        def repository_url(self) -> builtins.str:
            '''The URL of the Git repository.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html#cfn-sagemaker-domain-coderepository-repositoryurl
            '''
            result = self._values.get("repository_url")
            assert result is not None, "Required property 'repository_url' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CodeRepositoryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomFileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "efs_file_system_config": "efsFileSystemConfig",
            "f_sx_lustre_file_system_config": "fSxLustreFileSystemConfig",
        },
    )
    class CustomFileSystemConfigProperty:
        def __init__(
            self,
            *,
            efs_file_system_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.EFSFileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            f_sx_lustre_file_system_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.FSxLustreFileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The settings for assigning a custom file system to a user profile or space for an Amazon SageMaker AI Domain.

            Permitted users can access this file system in Amazon SageMaker AI Studio.

            :param efs_file_system_config: The settings for a custom Amazon EFS file system.
            :param f_sx_lustre_file_system_config: The settings for a custom Amazon FSx for Lustre file system.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                custom_file_system_config_property = sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                    efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                        file_system_id="fileSystemId",
                
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    ),
                    f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                        file_system_id="fileSystemId",
                
                        # the properties below are optional
                        file_system_path="fileSystemPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__acb2194c11b5367f9afdacac546d8288c9357d3ca5f49b7d828264eb239b24c8)
                check_type(argname="argument efs_file_system_config", value=efs_file_system_config, expected_type=type_hints["efs_file_system_config"])
                check_type(argname="argument f_sx_lustre_file_system_config", value=f_sx_lustre_file_system_config, expected_type=type_hints["f_sx_lustre_file_system_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if efs_file_system_config is not None:
                self._values["efs_file_system_config"] = efs_file_system_config
            if f_sx_lustre_file_system_config is not None:
                self._values["f_sx_lustre_file_system_config"] = f_sx_lustre_file_system_config

        @builtins.property
        def efs_file_system_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.EFSFileSystemConfigProperty"]]:
            '''The settings for a custom Amazon EFS file system.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html#cfn-sagemaker-domain-customfilesystemconfig-efsfilesystemconfig
            '''
            result = self._values.get("efs_file_system_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.EFSFileSystemConfigProperty"]], result)

        @builtins.property
        def f_sx_lustre_file_system_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.FSxLustreFileSystemConfigProperty"]]:
            '''The settings for a custom Amazon FSx for Lustre file system.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html#cfn-sagemaker-domain-customfilesystemconfig-fsxlustrefilesystemconfig
            '''
            result = self._values.get("f_sx_lustre_file_system_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.FSxLustreFileSystemConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomFileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomImageProperty",
        jsii_struct_bases=[],
        name_mapping={
            "app_image_config_name": "appImageConfigName",
            "image_name": "imageName",
            "image_version_number": "imageVersionNumber",
        },
    )
    class CustomImageProperty:
        def __init__(
            self,
            *,
            app_image_config_name: builtins.str,
            image_name: builtins.str,
            image_version_number: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''A custom SageMaker AI image.

            For more information, see `Bring your own SageMaker AI image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

            :param app_image_config_name: The name of the AppImageConfig.
            :param image_name: The name of the CustomImage. Must be unique to your account.
            :param image_version_number: The version number of the CustomImage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                custom_image_property = sagemaker.CfnDomain.CustomImageProperty(
                    app_image_config_name="appImageConfigName",
                    image_name="imageName",
                
                    # the properties below are optional
                    image_version_number=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2406a28ab5a6558d6675669b44f0ae0fc98be5d4a9d0f1426d9e8ba1b3a2b623)
                check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
                check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
                check_type(argname="argument image_version_number", value=image_version_number, expected_type=type_hints["image_version_number"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "app_image_config_name": app_image_config_name,
                "image_name": image_name,
            }
            if image_version_number is not None:
                self._values["image_version_number"] = image_version_number

        @builtins.property
        def app_image_config_name(self) -> builtins.str:
            '''The name of the AppImageConfig.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname
            '''
            result = self._values.get("app_image_config_name")
            assert result is not None, "Required property 'app_image_config_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_name(self) -> builtins.str:
            '''The name of the CustomImage.

            Must be unique to your account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename
            '''
            result = self._values.get("image_name")
            assert result is not None, "Required property 'image_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_version_number(self) -> typing.Optional[jsii.Number]:
            '''The version number of the CustomImage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber
            '''
            result = self._values.get("image_version_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomImageProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomPosixUserConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"gid": "gid", "uid": "uid"},
    )
    class CustomPosixUserConfigProperty:
        def __init__(self, *, gid: jsii.Number, uid: jsii.Number) -> None:
            '''Details about the POSIX identity that is used for file system operations.

            :param gid: The POSIX group ID.
            :param uid: The POSIX user ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                custom_posix_user_config_property = sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                    gid=123,
                    uid=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b89c0efcbc897595afb135954faed4acca8f58bad6b6be89e253973b9d9aeb4d)
                check_type(argname="argument gid", value=gid, expected_type=type_hints["gid"])
                check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "gid": gid,
                "uid": uid,
            }

        @builtins.property
        def gid(self) -> jsii.Number:
            '''The POSIX group ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-gid
            '''
            result = self._values.get("gid")
            assert result is not None, "Required property 'gid' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def uid(self) -> jsii.Number:
            '''The POSIX user ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-uid
            '''
            result = self._values.get("uid")
            assert result is not None, "Required property 'uid' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomPosixUserConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_ebs_volume_size_in_gb": "defaultEbsVolumeSizeInGb",
            "maximum_ebs_volume_size_in_gb": "maximumEbsVolumeSizeInGb",
        },
    )
    class DefaultEbsStorageSettingsProperty:
        def __init__(
            self,
            *,
            default_ebs_volume_size_in_gb: jsii.Number,
            maximum_ebs_volume_size_in_gb: jsii.Number,
        ) -> None:
            '''A collection of default EBS storage settings that apply to spaces created within a domain or user profile.

            :param default_ebs_volume_size_in_gb: The default size of the EBS storage volume for a space.
            :param maximum_ebs_volume_size_in_gb: The maximum size of the EBS storage volume for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                default_ebs_storage_settings_property = sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                    default_ebs_volume_size_in_gb=123,
                    maximum_ebs_volume_size_in_gb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b52c119b99eae7bccd0ea69c20d2eb78b4e2a18d561fcfd418dff5adba549437)
                check_type(argname="argument default_ebs_volume_size_in_gb", value=default_ebs_volume_size_in_gb, expected_type=type_hints["default_ebs_volume_size_in_gb"])
                check_type(argname="argument maximum_ebs_volume_size_in_gb", value=maximum_ebs_volume_size_in_gb, expected_type=type_hints["maximum_ebs_volume_size_in_gb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_ebs_volume_size_in_gb": default_ebs_volume_size_in_gb,
                "maximum_ebs_volume_size_in_gb": maximum_ebs_volume_size_in_gb,
            }

        @builtins.property
        def default_ebs_volume_size_in_gb(self) -> jsii.Number:
            '''The default size of the EBS storage volume for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-defaultebsvolumesizeingb
            '''
            result = self._values.get("default_ebs_volume_size_in_gb")
            assert result is not None, "Required property 'default_ebs_volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def maximum_ebs_volume_size_in_gb(self) -> jsii.Number:
            '''The maximum size of the EBS storage volume for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-maximumebsvolumesizeingb
            '''
            result = self._values.get("maximum_ebs_volume_size_in_gb")
            assert result is not None, "Required property 'maximum_ebs_volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultEbsStorageSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "custom_file_system_configs": "customFileSystemConfigs",
            "custom_posix_user_config": "customPosixUserConfig",
            "jupyter_lab_app_settings": "jupyterLabAppSettings",
            "jupyter_server_app_settings": "jupyterServerAppSettings",
            "kernel_gateway_app_settings": "kernelGatewayAppSettings",
            "security_groups": "securityGroups",
            "space_storage_settings": "spaceStorageSettings",
        },
    )
    class DefaultSpaceSettingsProperty:
        def __init__(
            self,
            *,
            execution_role: builtins.str,
            custom_file_system_configs: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomFileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            custom_posix_user_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomPosixUserConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            jupyter_lab_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterLabAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            jupyter_server_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterServerAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            kernel_gateway_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_groups: typing.Optional[typing.Sequence[builtins.str]] = None,
            space_storage_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DefaultSpaceStorageSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The default settings for shared spaces that users create in the domain.

            SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.

            :param execution_role: The ARN of the execution role for the space.
            :param custom_file_system_configs: The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker AI Studio.
            :param custom_posix_user_config: 
            :param jupyter_lab_app_settings: The JupyterLab app settings.
            :param jupyter_server_app_settings: The JupyterServer app settings.
            :param kernel_gateway_app_settings: The KernelGateway app settings.
            :param security_groups: The security group IDs for the Amazon VPC that the space uses for communication.
            :param space_storage_settings: Default storage settings for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                default_space_settings_property = sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                    execution_role="executionRole",
                
                    # the properties below are optional
                    custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                        efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                            file_system_id="fileSystemId",
                
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        ),
                        f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                            file_system_id="fileSystemId",
                
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        )
                    )],
                    custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                        gid=123,
                        uid=123
                    ),
                    jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                            repository_url="repositoryUrl"
                        )],
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    security_groups=["securityGroups"],
                    space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                        default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                            default_ebs_volume_size_in_gb=123,
                            maximum_ebs_volume_size_in_gb=123
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6f9de66f7050e50e98d4b4c96b379ab71681a650698564e825f452052572214f)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument custom_file_system_configs", value=custom_file_system_configs, expected_type=type_hints["custom_file_system_configs"])
                check_type(argname="argument custom_posix_user_config", value=custom_posix_user_config, expected_type=type_hints["custom_posix_user_config"])
                check_type(argname="argument jupyter_lab_app_settings", value=jupyter_lab_app_settings, expected_type=type_hints["jupyter_lab_app_settings"])
                check_type(argname="argument jupyter_server_app_settings", value=jupyter_server_app_settings, expected_type=type_hints["jupyter_server_app_settings"])
                check_type(argname="argument kernel_gateway_app_settings", value=kernel_gateway_app_settings, expected_type=type_hints["kernel_gateway_app_settings"])
                check_type(argname="argument security_groups", value=security_groups, expected_type=type_hints["security_groups"])
                check_type(argname="argument space_storage_settings", value=space_storage_settings, expected_type=type_hints["space_storage_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "execution_role": execution_role,
            }
            if custom_file_system_configs is not None:
                self._values["custom_file_system_configs"] = custom_file_system_configs
            if custom_posix_user_config is not None:
                self._values["custom_posix_user_config"] = custom_posix_user_config
            if jupyter_lab_app_settings is not None:
                self._values["jupyter_lab_app_settings"] = jupyter_lab_app_settings
            if jupyter_server_app_settings is not None:
                self._values["jupyter_server_app_settings"] = jupyter_server_app_settings
            if kernel_gateway_app_settings is not None:
                self._values["kernel_gateway_app_settings"] = kernel_gateway_app_settings
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if space_storage_settings is not None:
                self._values["space_storage_settings"] = space_storage_settings

        @builtins.property
        def execution_role(self) -> builtins.str:
            '''The ARN of the execution role for the space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-executionrole
            '''
            result = self._values.get("execution_role")
            assert result is not None, "Required property 'execution_role' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def custom_file_system_configs(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomFileSystemConfigProperty"]]]]:
            '''The settings for assigning a custom file system to a domain.

            Permitted users can access this file system in Amazon SageMaker AI Studio.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customfilesystemconfigs
            '''
            result = self._values.get("custom_file_system_configs")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomFileSystemConfigProperty"]]]], result)

        @builtins.property
        def custom_posix_user_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomPosixUserConfigProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customposixuserconfig
            '''
            result = self._values.get("custom_posix_user_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomPosixUserConfigProperty"]], result)

        @builtins.property
        def jupyter_lab_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterLabAppSettingsProperty"]]:
            '''The JupyterLab app settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterlabappsettings
            '''
            result = self._values.get("jupyter_lab_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterLabAppSettingsProperty"]], result)

        @builtins.property
        def jupyter_server_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]]:
            '''The JupyterServer app settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterserverappsettings
            '''
            result = self._values.get("jupyter_server_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]], result)

        @builtins.property
        def kernel_gateway_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]]:
            '''The KernelGateway app settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-kernelgatewayappsettings
            '''
            result = self._values.get("kernel_gateway_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]], result)

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security group IDs for the Amazon VPC that the space uses for communication.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-securitygroups
            '''
            result = self._values.get("security_groups")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def space_storage_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceStorageSettingsProperty"]]:
            '''Default storage settings for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-spacestoragesettings
            '''
            result = self._values.get("space_storage_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceStorageSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultSpaceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"default_ebs_storage_settings": "defaultEbsStorageSettings"},
    )
    class DefaultSpaceStorageSettingsProperty:
        def __init__(
            self,
            *,
            default_ebs_storage_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DefaultEbsStorageSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The default storage settings for a space.

            :param default_ebs_storage_settings: The default EBS storage settings for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                default_space_storage_settings_property = sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                    default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                        default_ebs_volume_size_in_gb=123,
                        maximum_ebs_volume_size_in_gb=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__65b37e511dc3aca202a4950f1f8750ff3beb0c7745987fbeac5766d6635c681e)
                check_type(argname="argument default_ebs_storage_settings", value=default_ebs_storage_settings, expected_type=type_hints["default_ebs_storage_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_ebs_storage_settings is not None:
                self._values["default_ebs_storage_settings"] = default_ebs_storage_settings

        @builtins.property
        def default_ebs_storage_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultEbsStorageSettingsProperty"]]:
            '''The default EBS storage settings for a space.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html#cfn-sagemaker-domain-defaultspacestoragesettings-defaultebsstoragesettings
            '''
            result = self._values.get("default_ebs_storage_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultEbsStorageSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultSpaceStorageSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DockerSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_docker_access": "enableDockerAccess",
            "vpc_only_trusted_accounts": "vpcOnlyTrustedAccounts",
        },
    )
    class DockerSettingsProperty:
        def __init__(
            self,
            *,
            enable_docker_access: typing.Optional[builtins.str] = None,
            vpc_only_trusted_accounts: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''A collection of settings that configure the domain's Docker interaction.

            :param enable_docker_access: Indicates whether the domain can access Docker.
            :param vpc_only_trusted_accounts: The list of AWS accounts that are trusted when the domain is created in VPC-only mode.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                docker_settings_property = sagemaker.CfnDomain.DockerSettingsProperty(
                    enable_docker_access="enableDockerAccess",
                    vpc_only_trusted_accounts=["vpcOnlyTrustedAccounts"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1936e7c64bbc1c0c5b8c086a1111acac047651d9cb6495a9c2f8961d2ede3cd7)
                check_type(argname="argument enable_docker_access", value=enable_docker_access, expected_type=type_hints["enable_docker_access"])
                check_type(argname="argument vpc_only_trusted_accounts", value=vpc_only_trusted_accounts, expected_type=type_hints["vpc_only_trusted_accounts"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_docker_access is not None:
                self._values["enable_docker_access"] = enable_docker_access
            if vpc_only_trusted_accounts is not None:
                self._values["vpc_only_trusted_accounts"] = vpc_only_trusted_accounts

        @builtins.property
        def enable_docker_access(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the domain can access Docker.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-enabledockeraccess
            '''
            result = self._values.get("enable_docker_access")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def vpc_only_trusted_accounts(
            self,
        ) -> typing.Optional[typing.List[builtins.str]]:
            '''The list of AWS accounts that are trusted when the domain is created in VPC-only mode.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-vpconlytrustedaccounts
            '''
            result = self._values.get("vpc_only_trusted_accounts")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DockerSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "docker_settings": "dockerSettings",
            "execution_role_identity_config": "executionRoleIdentityConfig",
            "r_studio_server_pro_domain_settings": "rStudioServerProDomainSettings",
            "security_group_ids": "securityGroupIds",
        },
    )
    class DomainSettingsProperty:
        def __init__(
            self,
            *,
            docker_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DockerSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            execution_role_identity_config: typing.Optional[builtins.str] = None,
            r_studio_server_pro_domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RStudioServerProDomainSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_group_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''A collection of settings that apply to the ``SageMaker Domain`` .

            These settings are specified through the ``CreateDomain`` API call.

            :param docker_settings: A collection of settings that configure the domain's Docker interaction.
            :param execution_role_identity_config: The configuration for attaching a SageMaker AI user profile name to the execution role as a `sts:SourceIdentity key <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html>`_ .
            :param r_studio_server_pro_domain_settings: A collection of settings that configure the ``RStudioServerPro`` Domain-level app.
            :param security_group_ids: The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                domain_settings_property = sagemaker.CfnDomain.DomainSettingsProperty(
                    docker_settings=sagemaker.CfnDomain.DockerSettingsProperty(
                        enable_docker_access="enableDockerAccess",
                        vpc_only_trusted_accounts=["vpcOnlyTrustedAccounts"]
                    ),
                    execution_role_identity_config="executionRoleIdentityConfig",
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
                
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b23323cc301476d59d77a279da88bfc3d14a3c21fb8709a0ecc6db6074a56cf9)
                check_type(argname="argument docker_settings", value=docker_settings, expected_type=type_hints["docker_settings"])
                check_type(argname="argument execution_role_identity_config", value=execution_role_identity_config, expected_type=type_hints["execution_role_identity_config"])
                check_type(argname="argument r_studio_server_pro_domain_settings", value=r_studio_server_pro_domain_settings, expected_type=type_hints["r_studio_server_pro_domain_settings"])
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if docker_settings is not None:
                self._values["docker_settings"] = docker_settings
            if execution_role_identity_config is not None:
                self._values["execution_role_identity_config"] = execution_role_identity_config
            if r_studio_server_pro_domain_settings is not None:
                self._values["r_studio_server_pro_domain_settings"] = r_studio_server_pro_domain_settings
            if security_group_ids is not None:
                self._values["security_group_ids"] = security_group_ids

        @builtins.property
        def docker_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DockerSettingsProperty"]]:
            '''A collection of settings that configure the domain's Docker interaction.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-dockersettings
            '''
            result = self._values.get("docker_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DockerSettingsProperty"]], result)

        @builtins.property
        def execution_role_identity_config(self) -> typing.Optional[builtins.str]:
            '''The configuration for attaching a SageMaker AI user profile name to the execution role as a `sts:SourceIdentity key <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-executionroleidentityconfig
            '''
            result = self._values.get("execution_role_identity_config")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def r_studio_server_pro_domain_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProDomainSettingsProperty"]]:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-rstudioserverprodomainsettings
            '''
            result = self._values.get("r_studio_server_pro_domain_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProDomainSettingsProperty"]], result)

        @builtins.property
        def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.EFSFileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "file_system_id": "fileSystemId",
            "file_system_path": "fileSystemPath",
        },
    )
    class EFSFileSystemConfigProperty:
        def __init__(
            self,
            *,
            file_system_id: builtins.str,
            file_system_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for assigning a custom Amazon EFS file system to a user profile or space for an Amazon SageMaker AI Domain.

            :param file_system_id: The ID of your Amazon EFS file system.
            :param file_system_path: The path to the file system directory that is accessible in Amazon SageMaker AI Studio. Permitted users can access only this directory and below.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                e_fSFile_system_config_property = sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                    file_system_id="fileSystemId",
                
                    # the properties below are optional
                    file_system_path="fileSystemPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f58dbfc3d8dc294c7e7f3e4dbd80fef3d00950f110fa9f391ce587b6d1499684)
                check_type(argname="argument file_system_id", value=file_system_id, expected_type=type_hints["file_system_id"])
                check_type(argname="argument file_system_path", value=file_system_path, expected_type=type_hints["file_system_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "file_system_id": file_system_id,
            }
            if file_system_path is not None:
                self._values["file_system_path"] = file_system_path

        @builtins.property
        def file_system_id(self) -> builtins.str:
            '''The ID of your Amazon EFS file system.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystemid
            '''
            result = self._values.get("file_system_id")
            assert result is not None, "Required property 'file_system_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def file_system_path(self) -> typing.Optional[builtins.str]:
            '''The path to the file system directory that is accessible in Amazon SageMaker AI Studio.

            Permitted users can access only this directory and below.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystempath
            '''
            result = self._values.get("file_system_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EFSFileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "file_system_id": "fileSystemId",
            "file_system_path": "fileSystemPath",
        },
    )
    class FSxLustreFileSystemConfigProperty:
        def __init__(
            self,
            *,
            file_system_id: builtins.str,
            file_system_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for assigning a custom Amazon FSx for Lustre file system to a user profile or space for an Amazon SageMaker Domain.

            :param file_system_id: The globally unique, 17-digit, ID of the file system, assigned by Amazon FSx for Lustre.
            :param file_system_path: The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-fsxlustrefilesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                f_sx_lustre_file_system_config_property = sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                    file_system_id="fileSystemId",
                
                    # the properties below are optional
                    file_system_path="fileSystemPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d8a1d62d2d0cebecfadffff928c7dca834df99c045099ba63d00955c27bdcc34)
                check_type(argname="argument file_system_id", value=file_system_id, expected_type=type_hints["file_system_id"])
                check_type(argname="argument file_system_path", value=file_system_path, expected_type=type_hints["file_system_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "file_system_id": file_system_id,
            }
            if file_system_path is not None:
                self._values["file_system_path"] = file_system_path

        @builtins.property
        def file_system_id(self) -> builtins.str:
            '''The globally unique, 17-digit, ID of the file system, assigned by Amazon FSx for Lustre.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-fsxlustrefilesystemconfig.html#cfn-sagemaker-domain-fsxlustrefilesystemconfig-filesystemid
            '''
            result = self._values.get("file_system_id")
            assert result is not None, "Required property 'file_system_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def file_system_path(self) -> typing.Optional[builtins.str]:
            '''The path to the file system directory that is accessible in Amazon SageMaker Studio.

            Permitted users can access only this directory and below.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-fsxlustrefilesystemconfig.html#cfn-sagemaker-domain-fsxlustrefilesystemconfig-filesystempath
            '''
            result = self._values.get("file_system_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FSxLustreFileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.IdleSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "idle_timeout_in_minutes": "idleTimeoutInMinutes",
            "lifecycle_management": "lifecycleManagement",
            "max_idle_timeout_in_minutes": "maxIdleTimeoutInMinutes",
            "min_idle_timeout_in_minutes": "minIdleTimeoutInMinutes",
        },
    )
    class IdleSettingsProperty:
        def __init__(
            self,
            *,
            idle_timeout_in_minutes: typing.Optional[jsii.Number] = None,
            lifecycle_management: typing.Optional[builtins.str] = None,
            max_idle_timeout_in_minutes: typing.Optional[jsii.Number] = None,
            min_idle_timeout_in_minutes: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Settings related to idle shutdown of Studio applications.

            :param idle_timeout_in_minutes: The time that SageMaker waits after the application becomes idle before shutting it down.
            :param lifecycle_management: Indicates whether idle shutdown is activated for the application type.
            :param max_idle_timeout_in_minutes: The maximum value in minutes that custom idle shutdown can be set to by the user.
            :param min_idle_timeout_in_minutes: The minimum value in minutes that custom idle shutdown can be set to by the user.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-idlesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                idle_settings_property = sagemaker.CfnDomain.IdleSettingsProperty(
                    idle_timeout_in_minutes=123,
                    lifecycle_management="lifecycleManagement",
                    max_idle_timeout_in_minutes=123,
                    min_idle_timeout_in_minutes=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9e3d0f1226c122e790812fdc875a758ed55021588a3e9f6f3227062284b60c8b)
                check_type(argname="argument idle_timeout_in_minutes", value=idle_timeout_in_minutes, expected_type=type_hints["idle_timeout_in_minutes"])
                check_type(argname="argument lifecycle_management", value=lifecycle_management, expected_type=type_hints["lifecycle_management"])
                check_type(argname="argument max_idle_timeout_in_minutes", value=max_idle_timeout_in_minutes, expected_type=type_hints["max_idle_timeout_in_minutes"])
                check_type(argname="argument min_idle_timeout_in_minutes", value=min_idle_timeout_in_minutes, expected_type=type_hints["min_idle_timeout_in_minutes"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if idle_timeout_in_minutes is not None:
                self._values["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            if lifecycle_management is not None:
                self._values["lifecycle_management"] = lifecycle_management
            if max_idle_timeout_in_minutes is not None:
                self._values["max_idle_timeout_in_minutes"] = max_idle_timeout_in_minutes
            if min_idle_timeout_in_minutes is not None:
                self._values["min_idle_timeout_in_minutes"] = min_idle_timeout_in_minutes

        @builtins.property
        def idle_timeout_in_minutes(self) -> typing.Optional[jsii.Number]:
            '''The time that SageMaker waits after the application becomes idle before shutting it down.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-idlesettings.html#cfn-sagemaker-domain-idlesettings-idletimeoutinminutes
            '''
            result = self._values.get("idle_timeout_in_minutes")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def lifecycle_management(self) -> typing.Optional[builtins.str]:
            '''Indicates whether idle shutdown is activated for the application type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-idlesettings.html#cfn-sagemaker-domain-idlesettings-lifecyclemanagement
            '''
            result = self._values.get("lifecycle_management")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def max_idle_timeout_in_minutes(self) -> typing.Optional[jsii.Number]:
            '''The maximum value in minutes that custom idle shutdown can be set to by the user.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-idlesettings.html#cfn-sagemaker-domain-idlesettings-maxidletimeoutinminutes
            '''
            result = self._values.get("max_idle_timeout_in_minutes")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min_idle_timeout_in_minutes(self) -> typing.Optional[jsii.Number]:
            '''The minimum value in minutes that custom idle shutdown can be set to by the user.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-idlesettings.html#cfn-sagemaker-domain-idlesettings-minidletimeoutinminutes
            '''
            result = self._values.get("min_idle_timeout_in_minutes")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IdleSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterLabAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "app_lifecycle_management": "appLifecycleManagement",
            "code_repositories": "codeRepositories",
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
            "lifecycle_config_arns": "lifecycleConfigArns",
        },
    )
    class JupyterLabAppSettingsProperty:
        def __init__(
            self,
            *,
            app_lifecycle_management: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.AppLifecycleManagementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            code_repositories: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CodeRepositoryProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            lifecycle_config_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The settings for the JupyterLab application.

            :param app_lifecycle_management: Indicates whether idle shutdown is activated for JupyterLab applications.
            :param code_repositories: A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
            :param custom_images: A list of custom SageMaker images that are configured to run as a JupyterLab app.
            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
            :param lifecycle_config_arns: The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To remove a lifecycle config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                jupyter_lab_app_settings_property = sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                    app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                        idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                            idle_timeout_in_minutes=123,
                            lifecycle_management="lifecycleManagement",
                            max_idle_timeout_in_minutes=123,
                            min_idle_timeout_in_minutes=123
                        )
                    ),
                    code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                        repository_url="repositoryUrl"
                    )],
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3cd086b89fbe936eaaa5fb775d9cbd0e29ad00fb21eb2a45265c217414f406d1)
                check_type(argname="argument app_lifecycle_management", value=app_lifecycle_management, expected_type=type_hints["app_lifecycle_management"])
                check_type(argname="argument code_repositories", value=code_repositories, expected_type=type_hints["code_repositories"])
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument lifecycle_config_arns", value=lifecycle_config_arns, expected_type=type_hints["lifecycle_config_arns"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if app_lifecycle_management is not None:
                self._values["app_lifecycle_management"] = app_lifecycle_management
            if code_repositories is not None:
                self._values["code_repositories"] = code_repositories
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if lifecycle_config_arns is not None:
                self._values["lifecycle_config_arns"] = lifecycle_config_arns

        @builtins.property
        def app_lifecycle_management(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.AppLifecycleManagementProperty"]]:
            '''Indicates whether idle shutdown is activated for JupyterLab applications.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-applifecyclemanagement
            '''
            result = self._values.get("app_lifecycle_management")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.AppLifecycleManagementProperty"]], result)

        @builtins.property
        def code_repositories(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CodeRepositoryProperty"]]]]:
            '''A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-coderepositories
            '''
            result = self._values.get("code_repositories")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CodeRepositoryProperty"]]]], result)

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker images that are configured to run as a JupyterLab app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def lifecycle_config_arns(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.

            To remove a lifecycle config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-lifecycleconfigarns
            '''
            result = self._values.get("lifecycle_config_arns")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JupyterLabAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_resource_spec": "defaultResourceSpec",
            "lifecycle_config_arns": "lifecycleConfigArns",
        },
    )
    class JupyterServerAppSettingsProperty:
        def __init__(
            self,
            *,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            lifecycle_config_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The JupyterServer app settings.

            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
            :param lifecycle_config_arns: The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use this parameter, the ``DefaultResourceSpec`` parameter is also required. .. epigraph:: To remove a Lifecycle Config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                jupyter_server_app_settings_property = sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__942897b920fdd808a5ea532138ac1b0df0fb1c9ddd37871604e65d095f882b59)
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument lifecycle_config_arns", value=lifecycle_config_arns, expected_type=type_hints["lifecycle_config_arns"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if lifecycle_config_arns is not None:
                self._values["lifecycle_config_arns"] = lifecycle_config_arns

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def lifecycle_config_arns(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.

            If you use this parameter, the ``DefaultResourceSpec`` parameter is also required.
            .. epigraph::

               To remove a Lifecycle Config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-lifecycleconfigarns
            '''
            result = self._values.get("lifecycle_config_arns")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JupyterServerAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
            "lifecycle_config_arns": "lifecycleConfigArns",
        },
    )
    class KernelGatewayAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            lifecycle_config_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The KernelGateway app settings.

            :param custom_images: A list of custom SageMaker AI images that are configured to run as a KernelGateway app. The maximum number of custom images are as follows. - On a domain level: 200 - On a space level: 5 - On a user profile level: 5
            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the KernelGateway app. .. epigraph:: The Amazon SageMaker AI Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
            :param lifecycle_config_arns: The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain. .. epigraph:: To remove a Lifecycle Config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_gateway_app_settings_property = sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    lifecycle_config_arns=["lifecycleConfigArns"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__976135962fc7c07e542fc30bab2304803e495b79c9c357ea5114ddc4b0dbb7ed)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument lifecycle_config_arns", value=lifecycle_config_arns, expected_type=type_hints["lifecycle_config_arns"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if lifecycle_config_arns is not None:
                self._values["lifecycle_config_arns"] = lifecycle_config_arns

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker AI images that are configured to run as a KernelGateway app.

            The maximum number of custom images are as follows.

            - On a domain level: 200
            - On a space level: 5
            - On a user profile level: 5

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the KernelGateway app.

            .. epigraph::

               The Amazon SageMaker AI Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def lifecycle_config_arns(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.

            .. epigraph::

               To remove a Lifecycle Config, you must set ``LifecycleConfigArns`` to an empty list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-lifecycleconfigarns
            '''
            result = self._values.get("lifecycle_config_arns")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
        },
    )
    class RSessionAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A collection of settings that apply to an ``RSessionGateway`` app.

            :param custom_images: A list of custom SageMaker AI images that are configured to run as a RSession app.
            :param default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_session_app_settings_property = sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ed9236f4ca80bc2b976cbd6c7f549652ec32a05dfb3665bd8630243e309c6276)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker AI images that are configured to run as a RSession app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RSessionAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"access_status": "accessStatus", "user_group": "userGroup"},
    )
    class RStudioServerProAppSettingsProperty:
        def __init__(
            self,
            *,
            access_status: typing.Optional[builtins.str] = None,
            user_group: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            :param access_status: Indicates whether the current user has access to the ``RStudioServerPro`` app.
            :param user_group: The level of permissions that the user has within the ``RStudioServerPro`` app. This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_app_settings_property = sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5bdad69d0d7dd9f412f84d21f9ef9cb6bb758f797a769d60e05dab58f67a85af)
                check_type(argname="argument access_status", value=access_status, expected_type=type_hints["access_status"])
                check_type(argname="argument user_group", value=user_group, expected_type=type_hints["user_group"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if access_status is not None:
                self._values["access_status"] = access_status
            if user_group is not None:
                self._values["user_group"] = user_group

        @builtins.property
        def access_status(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the current user has access to the ``RStudioServerPro`` app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-accessstatus
            '''
            result = self._values.get("access_status")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def user_group(self) -> typing.Optional[builtins.str]:
            '''The level of permissions that the user has within the ``RStudioServerPro`` app.

            This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-usergroup
            '''
            result = self._values.get("user_group")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "domain_execution_role_arn": "domainExecutionRoleArn",
            "default_resource_spec": "defaultResourceSpec",
            "r_studio_connect_url": "rStudioConnectUrl",
            "r_studio_package_manager_url": "rStudioPackageManagerUrl",
        },
    )
    class RStudioServerProDomainSettingsProperty:
        def __init__(
            self,
            *,
            domain_execution_role_arn: builtins.str,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_studio_connect_url: typing.Optional[builtins.str] = None,
            r_studio_package_manager_url: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :param domain_execution_role_arn: The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.
            :param default_resource_spec: A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.
            :param r_studio_connect_url: A URL pointing to an RStudio Connect server.
            :param r_studio_package_manager_url: A URL pointing to an RStudio Package Manager server.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_domain_settings_property = sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
                
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a53076bef887f5d807ddb5491cbeabe991590efba7801d2aa8d981d6913eb70c)
                check_type(argname="argument domain_execution_role_arn", value=domain_execution_role_arn, expected_type=type_hints["domain_execution_role_arn"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument r_studio_connect_url", value=r_studio_connect_url, expected_type=type_hints["r_studio_connect_url"])
                check_type(argname="argument r_studio_package_manager_url", value=r_studio_package_manager_url, expected_type=type_hints["r_studio_package_manager_url"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "domain_execution_role_arn": domain_execution_role_arn,
            }
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if r_studio_connect_url is not None:
                self._values["r_studio_connect_url"] = r_studio_connect_url
            if r_studio_package_manager_url is not None:
                self._values["r_studio_package_manager_url"] = r_studio_package_manager_url

        @builtins.property
        def domain_execution_role_arn(self) -> builtins.str:
            '''The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-domainexecutionrolearn
            '''
            result = self._values.get("domain_execution_role_arn")
            assert result is not None, "Required property 'domain_execution_role_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def r_studio_connect_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Connect server.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudioconnecturl
            '''
            result = self._values.get("r_studio_connect_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def r_studio_package_manager_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Package Manager server.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudiopackagemanagerurl
            '''
            result = self._values.get("r_studio_package_manager_url")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProDomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "lifecycle_config_arn": "lifecycleConfigArn",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            lifecycle_config_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker AI image and SageMaker AI image version, and the instance type that the version runs on.

            .. epigraph::

               When both ``SageMakerImageVersionArn`` and ``SageMakerImageArn`` are passed, ``SageMakerImageVersionArn`` is used. Any updates to ``SageMakerImageArn`` will not take effect if ``SageMakerImageVersionArn`` already exists in the ``ResourceSpec`` because ``SageMakerImageVersionArn`` always takes precedence. To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
            :param sage_maker_image_arn: The ARN of the SageMaker AI image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance. To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnDomain.ResourceSpecProperty(
                    instance_type="instanceType",
                    lifecycle_config_arn="lifecycleConfigArn",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a15c1a8a4f296645dbaf164af882f41bb1cf89c7585a52dc9b76a9ade4b3f49a)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument lifecycle_config_arn", value=lifecycle_config_arn, expected_type=type_hints["lifecycle_config_arn"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if lifecycle_config_arn is not None:
                self._values["lifecycle_config_arn"] = lifecycle_config_arn
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lifecycle_config_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-lifecycleconfigarn
            '''
            result = self._values.get("lifecycle_config_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker AI image that the image version belongs to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            To clear the value set for ``SageMakerImageVersionArn`` , pass ``None`` as the value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.SharingSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "notebook_output_option": "notebookOutputOption",
            "s3_kms_key_id": "s3KmsKeyId",
            "s3_output_path": "s3OutputPath",
        },
    )
    class SharingSettingsProperty:
        def __init__(
            self,
            *,
            notebook_output_option: typing.Optional[builtins.str] = None,
            s3_kms_key_id: typing.Optional[builtins.str] = None,
            s3_output_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies options when sharing an Amazon SageMaker Studio notebook.

            These settings are specified as part of ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called, and as part of ``UserSettings`` when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called.

            :param notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is ``Disabled`` .
            :param s3_kms_key_id: When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
            :param s3_output_path: When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                sharing_settings_property = sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__548dd396dfd935cd647f2a1297e1f20836fc0ddc163c1659d63bbf9e9cf88849)
                check_type(argname="argument notebook_output_option", value=notebook_output_option, expected_type=type_hints["notebook_output_option"])
                check_type(argname="argument s3_kms_key_id", value=s3_kms_key_id, expected_type=type_hints["s3_kms_key_id"])
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if notebook_output_option is not None:
                self._values["notebook_output_option"] = notebook_output_option
            if s3_kms_key_id is not None:
                self._values["s3_kms_key_id"] = s3_kms_key_id
            if s3_output_path is not None:
                self._values["s3_output_path"] = s3_output_path

        @builtins.property
        def notebook_output_option(self) -> typing.Optional[builtins.str]:
            '''Whether to include the notebook cell output when sharing the notebook.

            The default is ``Disabled`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption
            '''
            result = self._values.get("notebook_output_option")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid
            '''
            result = self._values.get("s3_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_output_path(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SharingSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.StudioWebPortalSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "hidden_app_types": "hiddenAppTypes",
            "hidden_ml_tools": "hiddenMlTools",
        },
    )
    class StudioWebPortalSettingsProperty:
        def __init__(
            self,
            *,
            hidden_app_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            hidden_ml_tools: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Studio settings.

            If these settings are applied on a user level, they take priority over the settings applied on a domain level.

            :param hidden_app_types: The `Applications supported in Studio <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html>`_ that are hidden from the Studio left navigation pane.
            :param hidden_ml_tools: The machine learning tools that are hidden from the Studio left navigation pane.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-studiowebportalsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                studio_web_portal_settings_property = sagemaker.CfnDomain.StudioWebPortalSettingsProperty(
                    hidden_app_types=["hiddenAppTypes"],
                    hidden_ml_tools=["hiddenMlTools"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8a8ec723792b0ed26599d28b5d7a21fbc89e286f4d03c0e5a17ecf55972981f1)
                check_type(argname="argument hidden_app_types", value=hidden_app_types, expected_type=type_hints["hidden_app_types"])
                check_type(argname="argument hidden_ml_tools", value=hidden_ml_tools, expected_type=type_hints["hidden_ml_tools"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if hidden_app_types is not None:
                self._values["hidden_app_types"] = hidden_app_types
            if hidden_ml_tools is not None:
                self._values["hidden_ml_tools"] = hidden_ml_tools

        @builtins.property
        def hidden_app_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The `Applications supported in Studio <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html>`_ that are hidden from the Studio left navigation pane.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-studiowebportalsettings.html#cfn-sagemaker-domain-studiowebportalsettings-hiddenapptypes
            '''
            result = self._values.get("hidden_app_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def hidden_ml_tools(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The machine learning tools that are hidden from the Studio left navigation pane.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-studiowebportalsettings.html#cfn-sagemaker-domain-studiowebportalsettings-hiddenmltools
            '''
            result = self._values.get("hidden_ml_tools")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StudioWebPortalSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.UserSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "code_editor_app_settings": "codeEditorAppSettings",
            "custom_file_system_configs": "customFileSystemConfigs",
            "custom_posix_user_config": "customPosixUserConfig",
            "default_landing_uri": "defaultLandingUri",
            "jupyter_lab_app_settings": "jupyterLabAppSettings",
            "jupyter_server_app_settings": "jupyterServerAppSettings",
            "kernel_gateway_app_settings": "kernelGatewayAppSettings",
            "r_session_app_settings": "rSessionAppSettings",
            "r_studio_server_pro_app_settings": "rStudioServerProAppSettings",
            "security_groups": "securityGroups",
            "sharing_settings": "sharingSettings",
            "space_storage_settings": "spaceStorageSettings",
            "studio_web_portal": "studioWebPortal",
            "studio_web_portal_settings": "studioWebPortalSettings",
        },
    )
    class UserSettingsProperty:
        def __init__(
            self,
            *,
            execution_role: builtins.str,
            code_editor_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CodeEditorAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            custom_file_system_configs: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomFileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            custom_posix_user_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomPosixUserConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_landing_uri: typing.Optional[builtins.str] = None,
            jupyter_lab_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterLabAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            jupyter_server_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterServerAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            kernel_gateway_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_session_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RSessionAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_studio_server_pro_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RStudioServerProAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_groups: typing.Optional[typing.Sequence[builtins.str]] = None,
            sharing_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.SharingSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            space_storage_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DefaultSpaceStorageSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            studio_web_portal: typing.Optional[builtins.str] = None,
            studio_web_portal_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.StudioWebPortalSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A collection of settings that apply to users of Amazon SageMaker Studio.

            These settings are specified when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called, and as ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called.

            ``SecurityGroups`` is aggregated when specified in both calls. For all other settings in ``UserSettings`` , the values specified in ``CreateUserProfile`` take precedence over those specified in ``CreateDomain`` .

            :param execution_role: The execution role for the user. SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.
            :param code_editor_app_settings: The Code Editor application settings. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param custom_file_system_configs: The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker AI Studio. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param custom_posix_user_config: Details about the POSIX identity that is used for file system operations. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param default_landing_uri: The default experience that the user is directed to when accessing the domain. The supported values are:. - ``studio::`` : Indicates that Studio is the default experience. This value can only be passed if ``StudioWebPortal`` is set to ``ENABLED`` . - ``app:JupyterServer:`` : Indicates that Studio Classic is the default experience.
            :param jupyter_lab_app_settings: The settings for the JupyterLab application. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param jupyter_server_app_settings: The Jupyter server's app settings.
            :param kernel_gateway_app_settings: The kernel gateway app settings.
            :param r_session_app_settings: A collection of settings that configure the ``RSessionGateway`` app.
            :param r_studio_server_pro_app_settings: A collection of settings that configure user interaction with the ``RStudioServerPro`` app.
            :param security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication. Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` . Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` , unless specified as part of the ``DefaultUserSettings`` for the domain. Amazon SageMaker AI adds a security group to allow NFS traffic from Amazon SageMaker AI Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param sharing_settings: Specifies options for sharing Amazon SageMaker AI Studio notebooks.
            :param space_storage_settings: The storage settings for a space. SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
            :param studio_web_portal: Whether the user can access Studio. If this value is set to ``DISABLED`` , the user cannot access Studio, even if that is the default experience for the domain.
            :param studio_web_portal_settings: Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                user_settings_property = sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
                
                    # the properties below are optional
                    code_editor_app_settings=sagemaker.CfnDomain.CodeEditorAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                        efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                            file_system_id="fileSystemId",
                
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        ),
                        f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                            file_system_id="fileSystemId",
                
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        )
                    )],
                    custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                        gid=123,
                        uid=123
                    ),
                    default_landing_uri="defaultLandingUri",
                    jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                            repository_url="repositoryUrl"
                        )],
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    ),
                    space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                        default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                            default_ebs_volume_size_in_gb=123,
                            maximum_ebs_volume_size_in_gb=123
                        )
                    ),
                    studio_web_portal="studioWebPortal",
                    studio_web_portal_settings=sagemaker.CfnDomain.StudioWebPortalSettingsProperty(
                        hidden_app_types=["hiddenAppTypes"],
                        hidden_ml_tools=["hiddenMlTools"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__88423e90a647fb1fb625855a5ca5160b5e8125e664363a24f90939664cc2d507)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument code_editor_app_settings", value=code_editor_app_settings, expected_type=type_hints["code_editor_app_settings"])
                check_type(argname="argument custom_file_system_configs", value=custom_file_system_configs, expected_type=type_hints["custom_file_system_configs"])
                check_type(argname="argument custom_posix_user_config", value=custom_posix_user_config, expected_type=type_hints["custom_posix_user_config"])
                check_type(argname="argument default_landing_uri", value=default_landing_uri, expected_type=type_hints["default_landing_uri"])
                check_type(argname="argument jupyter_lab_app_settings", value=jupyter_lab_app_settings, expected_type=type_hints["jupyter_lab_app_settings"])
                check_type(argname="argument jupyter_server_app_settings", value=jupyter_server_app_settings, expected_type=type_hints["jupyter_server_app_settings"])
                check_type(argname="argument kernel_gateway_app_settings", value=kernel_gateway_app_settings, expected_type=type_hints["kernel_gateway_app_settings"])
                check_type(argname="argument r_session_app_settings", value=r_session_app_settings, expected_type=type_hints["r_session_app_settings"])
                check_type(argname="argument r_studio_server_pro_app_settings", value=r_studio_server_pro_app_settings, expected_type=type_hints["r_studio_server_pro_app_settings"])
                check_type(argname="argument security_groups", value=security_groups, expected_type=type_hints["security_groups"])
                check_type(argname="argument sharing_settings", value=sharing_settings, expected_type=type_hints["sharing_settings"])
                check_type(argname="argument space_storage_settings", value=space_storage_settings, expected_type=type_hints["space_storage_settings"])
                check_type(argname="argument studio_web_portal", value=studio_web_portal, expected_type=type_hints["studio_web_portal"])
                check_type(argname="argument studio_web_portal_settings", value=studio_web_portal_settings, expected_type=type_hints["studio_web_portal_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "execution_role": execution_role,
            }
            if code_editor_app_settings is not None:
                self._values["code_editor_app_settings"] = code_editor_app_settings
            if custom_file_system_configs is not None:
                self._values["custom_file_system_configs"] = custom_file_system_configs
            if custom_posix_user_config is not None:
                self._values["custom_posix_user_config"] = custom_posix_user_config
            if default_landing_uri is not None:
                self._values["default_landing_uri"] = default_landing_uri
            if jupyter_lab_app_settings is not None:
                self._values["jupyter_lab_app_settings"] = jupyter_lab_app_settings
            if jupyter_server_app_settings is not None:
                self._values["jupyter_server_app_settings"] = jupyter_server_app_settings
            if kernel_gateway_app_settings is not None:
                self._values["kernel_gateway_app_settings"] = kernel_gateway_app_settings
            if r_session_app_settings is not None:
                self._values["r_session_app_settings"] = r_session_app_settings
            if r_studio_server_pro_app_settings is not None:
                self._values["r_studio_server_pro_app_settings"] = r_studio_server_pro_app_settings
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if sharing_settings is not None:
                self._values["sharing_settings"] = sharing_settings
            if space_storage_settings is not None:
                self._values["space_storage_settings"] = space_storage_settings
            if studio_web_portal is not None:
                self._values["studio_web_portal"] = studio_web_portal
            if studio_web_portal_settings is not None:
                self._values["studio_web_portal_settings"] = studio_web_portal_settings

        @builtins.property
        def execution_role(self) -> builtins.str:
            '''The execution role for the user.

            SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole
            '''
            result = self._values.get("execution_role")
            assert result is not None, "Required property 'execution_role' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def code_editor_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CodeEditorAppSettingsProperty"]]:
            '''The Code Editor application settings.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-codeeditorappsettings
            '''
            result = self._values.get("code_editor_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CodeEditorAppSettingsProperty"]], result)

        @builtins.property
        def custom_file_system_configs(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomFileSystemConfigProperty"]]]]:
            '''The settings for assigning a custom file system to a user profile.

            Permitted users can access this file system in Amazon SageMaker AI Studio.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customfilesystemconfigs
            '''
            result = self._values.get("custom_file_system_configs")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomFileSystemConfigProperty"]]]], result)

        @builtins.property
        def custom_posix_user_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomPosixUserConfigProperty"]]:
            '''Details about the POSIX identity that is used for file system operations.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customposixuserconfig
            '''
            result = self._values.get("custom_posix_user_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomPosixUserConfigProperty"]], result)

        @builtins.property
        def default_landing_uri(self) -> typing.Optional[builtins.str]:
            '''The default experience that the user is directed to when accessing the domain. The supported values are:.

            - ``studio::`` : Indicates that Studio is the default experience. This value can only be passed if ``StudioWebPortal`` is set to ``ENABLED`` .
            - ``app:JupyterServer:`` : Indicates that Studio Classic is the default experience.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-defaultlandinguri
            '''
            result = self._values.get("default_landing_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def jupyter_lab_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterLabAppSettingsProperty"]]:
            '''The settings for the JupyterLab application.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterlabappsettings
            '''
            result = self._values.get("jupyter_lab_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterLabAppSettingsProperty"]], result)

        @builtins.property
        def jupyter_server_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]]:
            '''The Jupyter server's app settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings
            '''
            result = self._values.get("jupyter_server_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]], result)

        @builtins.property
        def kernel_gateway_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]]:
            '''The kernel gateway app settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings
            '''
            result = self._values.get("kernel_gateway_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]], result)

        @builtins.property
        def r_session_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RSessionAppSettingsProperty"]]:
            '''A collection of settings that configure the ``RSessionGateway`` app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rsessionappsettings
            '''
            result = self._values.get("r_session_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RSessionAppSettingsProperty"]], result)

        @builtins.property
        def r_studio_server_pro_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProAppSettingsProperty"]]:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rstudioserverproappsettings
            '''
            result = self._values.get("r_studio_server_pro_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProAppSettingsProperty"]], result)

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.

            Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` .

            Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` , unless specified as part of the ``DefaultUserSettings`` for the domain.

            Amazon SageMaker AI adds a security group to allow NFS traffic from Amazon SageMaker AI Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups
            '''
            result = self._values.get("security_groups")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def sharing_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.SharingSettingsProperty"]]:
            '''Specifies options for sharing Amazon SageMaker AI Studio notebooks.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings
            '''
            result = self._values.get("sharing_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.SharingSettingsProperty"]], result)

        @builtins.property
        def space_storage_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceStorageSettingsProperty"]]:
            '''The storage settings for a space.

            SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-spacestoragesettings
            '''
            result = self._values.get("space_storage_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceStorageSettingsProperty"]], result)

        @builtins.property
        def studio_web_portal(self) -> typing.Optional[builtins.str]:
            '''Whether the user can access Studio.

            If this value is set to ``DISABLED`` , the user cannot access Studio, even if that is the default experience for the domain.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-studiowebportal
            '''
            result = self._values.get("studio_web_portal")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def studio_web_portal_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.StudioWebPortalSettingsProperty"]]:
            '''Studio settings.

            If these settings are applied on a user level, they take priority over the settings applied on a domain level.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-studiowebportalsettings
            '''
            result = self._values.get("studio_web_portal_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.StudioWebPortalSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "UserSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomainProps",
    jsii_struct_bases=[],
    name_mapping={
        "auth_mode": "authMode",
        "default_user_settings": "defaultUserSettings",
        "domain_name": "domainName",
        "subnet_ids": "subnetIds",
        "vpc_id": "vpcId",
        "app_network_access_type": "appNetworkAccessType",
        "app_security_group_management": "appSecurityGroupManagement",
        "default_space_settings": "defaultSpaceSettings",
        "domain_settings": "domainSettings",
        "kms_key_id": "kmsKeyId",
        "tag_propagation": "tagPropagation",
        "tags": "tags",
    },
)
class CfnDomainProps:
    def __init__(
        self,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.UserSettingsProperty, typing.Dict[builtins.str, typing.Any]]],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        default_space_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.DefaultSpaceSettingsProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.DomainSettingsProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tag_propagation: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDomain``.

        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker AI , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` . *Allowed Values* : ``Service`` | ``Customer``
        :param default_space_settings: The default settings for shared spaces that users create in the domain. SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tag_propagation: Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_domain_props = sagemaker.CfnDomainProps(
                auth_mode="authMode",
                default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
            
                    # the properties below are optional
                    code_editor_app_settings=sagemaker.CfnDomain.CodeEditorAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                        efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                            file_system_id="fileSystemId",
            
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        ),
                        f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                            file_system_id="fileSystemId",
            
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        )
                    )],
                    custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                        gid=123,
                        uid=123
                    ),
                    default_landing_uri="defaultLandingUri",
                    jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                            repository_url="repositoryUrl"
                        )],
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    ),
                    space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                        default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                            default_ebs_volume_size_in_gb=123,
                            maximum_ebs_volume_size_in_gb=123
                        )
                    ),
                    studio_web_portal="studioWebPortal",
                    studio_web_portal_settings=sagemaker.CfnDomain.StudioWebPortalSettingsProperty(
                        hidden_app_types=["hiddenAppTypes"],
                        hidden_ml_tools=["hiddenMlTools"]
                    )
                ),
                domain_name="domainName",
                subnet_ids=["subnetIds"],
                vpc_id="vpcId",
            
                # the properties below are optional
                app_network_access_type="appNetworkAccessType",
                app_security_group_management="appSecurityGroupManagement",
                default_space_settings=sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                    execution_role="executionRole",
            
                    # the properties below are optional
                    custom_file_system_configs=[sagemaker.CfnDomain.CustomFileSystemConfigProperty(
                        efs_file_system_config=sagemaker.CfnDomain.EFSFileSystemConfigProperty(
                            file_system_id="fileSystemId",
            
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        ),
                        f_sx_lustre_file_system_config=sagemaker.CfnDomain.FSxLustreFileSystemConfigProperty(
                            file_system_id="fileSystemId",
            
                            # the properties below are optional
                            file_system_path="fileSystemPath"
                        )
                    )],
                    custom_posix_user_config=sagemaker.CfnDomain.CustomPosixUserConfigProperty(
                        gid=123,
                        uid=123
                    ),
                    jupyter_lab_app_settings=sagemaker.CfnDomain.JupyterLabAppSettingsProperty(
                        app_lifecycle_management=sagemaker.CfnDomain.AppLifecycleManagementProperty(
                            idle_settings=sagemaker.CfnDomain.IdleSettingsProperty(
                                idle_timeout_in_minutes=123,
                                lifecycle_management="lifecycleManagement",
                                max_idle_timeout_in_minutes=123,
                                min_idle_timeout_in_minutes=123
                            )
                        ),
                        code_repositories=[sagemaker.CfnDomain.CodeRepositoryProperty(
                            repository_url="repositoryUrl"
                        )],
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        lifecycle_config_arns=["lifecycleConfigArns"]
                    ),
                    security_groups=["securityGroups"],
                    space_storage_settings=sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty(
                        default_ebs_storage_settings=sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty(
                            default_ebs_volume_size_in_gb=123,
                            maximum_ebs_volume_size_in_gb=123
                        )
                    )
                ),
                domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                    docker_settings=sagemaker.CfnDomain.DockerSettingsProperty(
                        enable_docker_access="enableDockerAccess",
                        vpc_only_trusted_accounts=["vpcOnlyTrustedAccounts"]
                    ),
                    execution_role_identity_config="executionRoleIdentityConfig",
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
            
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                ),
                kms_key_id="kmsKeyId",
                tag_propagation="tagPropagation",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d70b90cbf9af0f3b53a18e5f11f7de868ef5fe3e6110bb229fd1350019f730e5)
            check_type(argname="argument auth_mode", value=auth_mode, expected_type=type_hints["auth_mode"])
            check_type(argname="argument default_user_settings", value=default_user_settings, expected_type=type_hints["default_user_settings"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument subnet_ids", value=subnet_ids, expected_type=type_hints["subnet_ids"])
            check_type(argname="argument vpc_id", value=vpc_id, expected_type=type_hints["vpc_id"])
            check_type(argname="argument app_network_access_type", value=app_network_access_type, expected_type=type_hints["app_network_access_type"])
            check_type(argname="argument app_security_group_management", value=app_security_group_management, expected_type=type_hints["app_security_group_management"])
            check_type(argname="argument default_space_settings", value=default_space_settings, expected_type=type_hints["default_space_settings"])
            check_type(argname="argument domain_settings", value=domain_settings, expected_type=type_hints["domain_settings"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument tag_propagation", value=tag_propagation, expected_type=type_hints["tag_propagation"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "auth_mode": auth_mode,
            "default_user_settings": default_user_settings,
            "domain_name": domain_name,
            "subnet_ids": subnet_ids,
            "vpc_id": vpc_id,
        }
        if app_network_access_type is not None:
            self._values["app_network_access_type"] = app_network_access_type
        if app_security_group_management is not None:
            self._values["app_security_group_management"] = app_security_group_management
        if default_space_settings is not None:
            self._values["default_space_settings"] = default_space_settings
        if domain_settings is not None:
            self._values["domain_settings"] = domain_settings
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if tag_propagation is not None:
            self._values["tag_propagation"] = tag_propagation
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.

        *Valid Values* : ``SSO | IAM``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
        '''
        result = self._values.get("auth_mode")
        assert result is not None, "Required property 'auth_mode' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def default_user_settings(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDomain.UserSettingsProperty]:
        '''The default user settings.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
        '''
        result = self._values.get("default_user_settings")
        assert result is not None, "Required property 'default_user_settings' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDomain.UserSettingsProperty], result)

    @builtins.property
    def domain_name(self) -> builtins.str:
        '''The domain name.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
        '''
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Array members* : Minimum number of 1 item. Maximum number of 16 items.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
        '''
        result = self._values.get("subnet_ids")
        assert result is not None, "Required property 'subnet_ids' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
        '''
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` .

        - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker AI , which allows direct internet access
        - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets

        *Valid Values* : ``PublicInternetOnly | VpcOnly``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
        '''
        result = self._values.get("app_network_access_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.

        Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` .

        *Allowed Values* : ``Service`` | ``Customer``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement
        '''
        result = self._values.get("app_security_group_management")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def default_space_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DefaultSpaceSettingsProperty]]:
        '''The default settings for shared spaces that users create in the domain.

        SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings
        '''
        result = self._values.get("default_space_settings")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DefaultSpaceSettingsProperty]], result)

    @builtins.property
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DomainSettingsProperty]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .

        These settings are specified through the ``CreateDomain`` API call.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings
        '''
        result = self._values.get("domain_settings")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DomainSettingsProperty]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.

        For more control, specify a customer managed CMK.

        *Length Constraints* : Maximum length of 2048.

        *Pattern* : ``.*``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tag_propagation(self) -> typing.Optional[builtins.str]:
        '''Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tagpropagation
        '''
        result = self._values.get("tag_propagation")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags to associated with the Domain.

        Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.

        Tags that you specify for the Domain are also added to all apps that are launched in the Domain.

        *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDomainProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnEndpoint(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint",
):
    '''Use the ``AWS::SageMaker::Endpoint`` resource to create an endpoint using the specified configuration in the request.

    Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource. For more information, see `Deploy a Model on Amazon SageMaker Hosting Services <https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html>`_ in the *Amazon SageMaker Developer Guide* .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
    :cloudformationResource: AWS::SageMaker::Endpoint
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_endpoint = sagemaker.CfnEndpoint(self, "MyCfnEndpoint",
            endpoint_config_name="endpointConfigName",
        
            # the properties below are optional
            deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                ),
                blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
        
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
        
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                ),
                rolling_update_policy=sagemaker.CfnEndpoint.RollingUpdatePolicyProperty(
                    maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123,
        
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    rollback_maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    )
                )
            ),
            endpoint_name="endpointName",
            exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                variant_property_type="variantPropertyType"
            )],
            retain_all_variant_properties=False,
            retain_deployment_config=False,
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.DeploymentConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.VariantPropertyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint. The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__25a1b782521c912d49f8881f9136b81a31874db7423cbc69dd4d592308ab1637)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointProps(
            endpoint_config_name=endpoint_config_name,
            deployment_config=deployment_config,
            endpoint_name=endpoint_name,
            exclude_retained_variant_properties=exclude_retained_variant_properties,
            retain_all_variant_properties=retain_all_variant_properties,
            retain_deployment_config=retain_deployment_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30e2eaf7ae1d65739ce7b332f2d2eaa983053d55ecf4081e243a2ac5f47961eb)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f47dbdb18a90354facd890ea710422eaf2acd63bfcef2ca594f9c45be4c0741)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointArn")
    def attr_endpoint_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the endpoint.

        :cloudformationAttribute: EndpointArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointArn"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointName")
    def attr_endpoint_name(self) -> builtins.str:
        '''The name of the endpoint, such as ``MyEndpoint`` .

        :cloudformationAttribute: EndpointName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointName"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''
        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .'''
        return typing.cast(builtins.str, jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fc46b5a4608391c5b023fa1800209955387c9abc04000465c1497a02ffcc73b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="deploymentConfig")
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]], jsii.get(self, "deploymentConfig"))

    @deployment_config.setter
    def deployment_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__282ad840d284416c74cb1dec9d8585464ab2fdabef85c02a2157137e553d929d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deploymentConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed57f464bb55b112eacf852ffafe64ee93beb0dd0f9a9c81cfed938f546e9413)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="excludeRetainedVariantProperties")
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]], jsii.get(self, "excludeRetainedVariantProperties"))

    @exclude_retained_variant_properties.setter
    def exclude_retained_variant_properties(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ee6a8f5fa98cdfc488825acbd1978c8669d4e6de4cdb626a755c8b4462edb18)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "excludeRetainedVariantProperties", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="retainAllVariantProperties")
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.'''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "retainAllVariantProperties"))

    @retain_all_variant_properties.setter
    def retain_all_variant_properties(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a449b8aec7663417625aba5613780daefbd54794f3fc085c8275ee15b03e0ddd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainAllVariantProperties", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="retainDeploymentConfig")
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Specifies whether to reuse the last deployment configuration.'''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "retainDeploymentConfig"))

    @retain_deployment_config.setter
    def retain_deployment_config(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edaf654b3efad8522601d55dc70b1fbe91565b325788322fd32078ba331c7236)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainDeploymentConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a09ce1e0fbf50769fe1466ab68006be1481654b4884a0501ebd711c3f0d46435)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.AlarmProperty",
        jsii_struct_bases=[],
        name_mapping={"alarm_name": "alarmName"},
    )
    class AlarmProperty:
        def __init__(self, *, alarm_name: builtins.str) -> None:
            '''An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.

            :param alarm_name: The name of a CloudWatch alarm in your account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                alarm_property = sagemaker.CfnEndpoint.AlarmProperty(
                    alarm_name="alarmName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__545f901797973de76167553f39b693c4f1564abc9dfaeb5563cb8afd7917adb1)
                check_type(argname="argument alarm_name", value=alarm_name, expected_type=type_hints["alarm_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarm_name": alarm_name,
            }

        @builtins.property
        def alarm_name(self) -> builtins.str:
            '''The name of a CloudWatch alarm in your account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname
            '''
            result = self._values.get("alarm_name")
            assert result is not None, "Required property 'alarm_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AlarmProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.AutoRollbackConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"alarms": "alarms"},
    )
    class AutoRollbackConfigProperty:
        def __init__(
            self,
            *,
            alarms: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.AlarmProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :param alarms: List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                auto_rollback_config_property = sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d86e3846eb32ca90c0c7fbf8652bbfcc5f60c6360575c7f19bc7e9da7d2fe467)
                check_type(argname="argument alarms", value=alarms, expected_type=type_hints["alarms"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarms": alarms,
            }

        @builtins.property
        def alarms(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AlarmProperty"]]]:
            '''List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.

            If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms
            '''
            result = self._values.get("alarms")
            assert result is not None, "Required property 'alarms' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AlarmProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AutoRollbackConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "traffic_routing_configuration": "trafficRoutingConfiguration",
            "maximum_execution_timeout_in_seconds": "maximumExecutionTimeoutInSeconds",
            "termination_wait_in_seconds": "terminationWaitInSeconds",
        },
    )
    class BlueGreenUpdatePolicyProperty:
        def __init__(
            self,
            *,
            traffic_routing_configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.TrafficRoutingConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            maximum_execution_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            termination_wait_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :param traffic_routing_configuration: Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
            :param maximum_execution_timeout_in_seconds: Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .
            :param termination_wait_in_seconds: Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                blue_green_update_policy_property = sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
                
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
                
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d28be213bc658ab75fb13a94b106b4201e989c105915c39fb50705be12d37728)
                check_type(argname="argument traffic_routing_configuration", value=traffic_routing_configuration, expected_type=type_hints["traffic_routing_configuration"])
                check_type(argname="argument maximum_execution_timeout_in_seconds", value=maximum_execution_timeout_in_seconds, expected_type=type_hints["maximum_execution_timeout_in_seconds"])
                check_type(argname="argument termination_wait_in_seconds", value=termination_wait_in_seconds, expected_type=type_hints["termination_wait_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "traffic_routing_configuration": traffic_routing_configuration,
            }
            if maximum_execution_timeout_in_seconds is not None:
                self._values["maximum_execution_timeout_in_seconds"] = maximum_execution_timeout_in_seconds
            if termination_wait_in_seconds is not None:
                self._values["termination_wait_in_seconds"] = termination_wait_in_seconds

        @builtins.property
        def traffic_routing_configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpoint.TrafficRoutingConfigProperty"]:
            '''Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration
            '''
            result = self._values.get("traffic_routing_configuration")
            assert result is not None, "Required property 'traffic_routing_configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpoint.TrafficRoutingConfigProperty"], result)

        @builtins.property
        def maximum_execution_timeout_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Maximum execution timeout for the deployment.

            Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds
            '''
            result = self._values.get("maximum_execution_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def termination_wait_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet.

            Default is 0.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds
            '''
            result = self._values.get("termination_wait_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlueGreenUpdatePolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.CapacitySizeProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type", "value": "value"},
    )
    class CapacitySizeProperty:
        def __init__(self, *, type: builtins.str, value: jsii.Number) -> None:
            '''Specifies the type and size of the endpoint capacity to activate for a blue/green deployment, a rolling deployment, or a rollback strategy.

            You can specify your batches as either instance count or the overall percentage or your fleet.

            For a rollback strategy, if you don't specify the fields in this object, or if you set the ``Value`` to 100%, then SageMaker uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.

            :param type: Specifies the endpoint capacity type. - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances. - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.
            :param value: Defines the capacity size, either as a number of instances or a capacity percentage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capacity_size_property = sagemaker.CfnEndpoint.CapacitySizeProperty(
                    type="type",
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__620e1fd2701901a3771895d025a10da547bd6349c473e05ba7dd2b7c1ee9235b)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
                "value": value,
            }

        @builtins.property
        def type(self) -> builtins.str:
            '''Specifies the endpoint capacity type.

            - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances.
            - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> jsii.Number:
            '''Defines the capacity size, either as a number of instances or a capacity percentage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacitySizeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.DeploymentConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "auto_rollback_configuration": "autoRollbackConfiguration",
            "blue_green_update_policy": "blueGreenUpdatePolicy",
            "rolling_update_policy": "rollingUpdatePolicy",
        },
    )
    class DeploymentConfigProperty:
        def __init__(
            self,
            *,
            auto_rollback_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.AutoRollbackConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            blue_green_update_policy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.BlueGreenUpdatePolicyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rolling_update_policy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.RollingUpdatePolicyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

            :param auto_rollback_configuration: Automatic rollback configuration for handling endpoint deployment failures and recovery.
            :param blue_green_update_policy: Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
            :param rolling_update_policy: Specifies a rolling deployment strategy for updating a SageMaker endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                deployment_config_property = sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    ),
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
                
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
                
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
                    rolling_update_policy=sagemaker.CfnEndpoint.RollingUpdatePolicyProperty(
                        maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123,
                
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        rollback_maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ef4fd0099485ae9d7fd2d7347509c94feea591075e4c9b0ec8f5dd9747851049)
                check_type(argname="argument auto_rollback_configuration", value=auto_rollback_configuration, expected_type=type_hints["auto_rollback_configuration"])
                check_type(argname="argument blue_green_update_policy", value=blue_green_update_policy, expected_type=type_hints["blue_green_update_policy"])
                check_type(argname="argument rolling_update_policy", value=rolling_update_policy, expected_type=type_hints["rolling_update_policy"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if auto_rollback_configuration is not None:
                self._values["auto_rollback_configuration"] = auto_rollback_configuration
            if blue_green_update_policy is not None:
                self._values["blue_green_update_policy"] = blue_green_update_policy
            if rolling_update_policy is not None:
                self._values["rolling_update_policy"] = rolling_update_policy

        @builtins.property
        def auto_rollback_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AutoRollbackConfigProperty"]]:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration
            '''
            result = self._values.get("auto_rollback_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AutoRollbackConfigProperty"]], result)

        @builtins.property
        def blue_green_update_policy(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.BlueGreenUpdatePolicyProperty"]]:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy
            '''
            result = self._values.get("blue_green_update_policy")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.BlueGreenUpdatePolicyProperty"]], result)

        @builtins.property
        def rolling_update_policy(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.RollingUpdatePolicyProperty"]]:
            '''Specifies a rolling deployment strategy for updating a SageMaker endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-rollingupdatepolicy
            '''
            result = self._values.get("rolling_update_policy")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.RollingUpdatePolicyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeploymentConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.RollingUpdatePolicyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "maximum_batch_size": "maximumBatchSize",
            "wait_interval_in_seconds": "waitIntervalInSeconds",
            "maximum_execution_timeout_in_seconds": "maximumExecutionTimeoutInSeconds",
            "rollback_maximum_batch_size": "rollbackMaximumBatchSize",
        },
    )
    class RollingUpdatePolicyProperty:
        def __init__(
            self,
            *,
            maximum_batch_size: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]],
            wait_interval_in_seconds: jsii.Number,
            maximum_execution_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            rollback_maximum_batch_size: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies a rolling deployment strategy for updating a SageMaker endpoint.

            :param maximum_batch_size: Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count.
            :param wait_interval_in_seconds: The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
            :param maximum_execution_timeout_in_seconds: The time limit for the total deployment. Exceeding this limit causes a timeout.
            :param rollback_maximum_batch_size: Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                rolling_update_policy_property = sagemaker.CfnEndpoint.RollingUpdatePolicyProperty(
                    maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123,
                
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    rollback_maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0d94ee607e8086635b8f00b305f4dbb6e2be8a4dfe79113facceefda72439b8c)
                check_type(argname="argument maximum_batch_size", value=maximum_batch_size, expected_type=type_hints["maximum_batch_size"])
                check_type(argname="argument wait_interval_in_seconds", value=wait_interval_in_seconds, expected_type=type_hints["wait_interval_in_seconds"])
                check_type(argname="argument maximum_execution_timeout_in_seconds", value=maximum_execution_timeout_in_seconds, expected_type=type_hints["maximum_execution_timeout_in_seconds"])
                check_type(argname="argument rollback_maximum_batch_size", value=rollback_maximum_batch_size, expected_type=type_hints["rollback_maximum_batch_size"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "maximum_batch_size": maximum_batch_size,
                "wait_interval_in_seconds": wait_interval_in_seconds,
            }
            if maximum_execution_timeout_in_seconds is not None:
                self._values["maximum_execution_timeout_in_seconds"] = maximum_execution_timeout_in_seconds
            if rollback_maximum_batch_size is not None:
                self._values["rollback_maximum_batch_size"] = rollback_maximum_batch_size

        @builtins.property
        def maximum_batch_size(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]:
            '''Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet.

            Value must be between 5% to 50% of the variant's total instance count.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumbatchsize
            '''
            result = self._values.get("maximum_batch_size")
            assert result is not None, "Required property 'maximum_batch_size' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"], result)

        @builtins.property
        def wait_interval_in_seconds(self) -> jsii.Number:
            '''The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-waitintervalinseconds
            '''
            result = self._values.get("wait_interval_in_seconds")
            assert result is not None, "Required property 'wait_interval_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def maximum_execution_timeout_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''The time limit for the total deployment.

            Exceeding this limit causes a timeout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumexecutiontimeoutinseconds
            '''
            result = self._values.get("maximum_execution_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def rollback_maximum_batch_size(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]]:
            '''Batch size for rollback to the old endpoint fleet.

            Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-rollbackmaximumbatchsize
            '''
            result = self._values.get("rollback_maximum_batch_size")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RollingUpdatePolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.TrafficRoutingConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "type": "type",
            "canary_size": "canarySize",
            "linear_step_size": "linearStepSize",
            "wait_interval_in_seconds": "waitIntervalInSeconds",
        },
    )
    class TrafficRoutingConfigProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            canary_size: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            linear_step_size: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            wait_interval_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.

            :param type: Traffic routing strategy type. - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step. - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic. - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.
            :param canary_size: Batch size for the first step to turn on traffic on the new endpoint fleet. ``Value`` must be less than or equal to 50% of the variant's total instance count.
            :param linear_step_size: Batch size for each step to turn on traffic on the new endpoint fleet. ``Value`` must be 10-50% of the variant's total instance count.
            :param wait_interval_in_seconds: The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                traffic_routing_config_property = sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                    type="type",
                
                    # the properties below are optional
                    canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ed93bec369cf789d2763e6fe66be5df767a5c5c4c898134732efbeb60fd121ee)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument canary_size", value=canary_size, expected_type=type_hints["canary_size"])
                check_type(argname="argument linear_step_size", value=linear_step_size, expected_type=type_hints["linear_step_size"])
                check_type(argname="argument wait_interval_in_seconds", value=wait_interval_in_seconds, expected_type=type_hints["wait_interval_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
            }
            if canary_size is not None:
                self._values["canary_size"] = canary_size
            if linear_step_size is not None:
                self._values["linear_step_size"] = linear_step_size
            if wait_interval_in_seconds is not None:
                self._values["wait_interval_in_seconds"] = wait_interval_in_seconds

        @builtins.property
        def type(self) -> builtins.str:
            '''Traffic routing strategy type.

            - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step.
            - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.
            - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def canary_size(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]]:
            '''Batch size for the first step to turn on traffic on the new endpoint fleet.

            ``Value`` must be less than or equal to 50% of the variant's total instance count.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize
            '''
            result = self._values.get("canary_size")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]], result)

        @builtins.property
        def linear_step_size(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]]:
            '''Batch size for each step to turn on traffic on the new endpoint fleet.

            ``Value`` must be 10-50% of the variant's total instance count.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-linearstepsize
            '''
            result = self._values.get("linear_step_size")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]], result)

        @builtins.property
        def wait_interval_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds
            '''
            result = self._values.get("wait_interval_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TrafficRoutingConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.VariantPropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"variant_property_type": "variantPropertyType"},
    )
    class VariantPropertyProperty:
        def __init__(
            self,
            *,
            variant_property_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies a production variant property type for an Endpoint.

            If you are updating an Endpoint with the `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ option set to ``true`` , the ``VarientProperty`` objects listed in `ExcludeRetainedVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-ExcludeRetainedVariantProperties>`_ override the existing variant properties of the Endpoint.

            :param variant_property_type: The type of variant property. The supported values are:. - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DataCaptureConfig`` : (Not currently supported.)

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                variant_property_property = sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a64f8f48a2b5af883cfc2cd98614bb5fc82a1ad9e9bad182f015286151da4d68)
                check_type(argname="argument variant_property_type", value=variant_property_type, expected_type=type_hints["variant_property_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if variant_property_type is not None:
                self._values["variant_property_type"] = variant_property_type

        @builtins.property
        def variant_property_type(self) -> typing.Optional[builtins.str]:
            '''The type of variant property. The supported values are:.

            - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DataCaptureConfig`` : (Not currently supported.)

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
            '''
            result = self._values.get("variant_property_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VariantPropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnEndpointConfig(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig",
):
    '''The ``AWS::SageMaker::EndpointConfig`` resource creates a configuration for an Amazon SageMaker endpoint.

    For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ in the *SageMaker Developer Guide* .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
    :cloudformationResource: AWS::SageMaker::EndpointConfig
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_endpoint_config = sagemaker.CfnEndpointConfig(self, "MyCfnEndpointConfig",
            production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                enable_ssm_access=False,
                inference_ami_version="inferenceAmiVersion",
                initial_instance_count=123,
                initial_variant_weight=123,
                instance_type="instanceType",
                managed_instance_scaling=sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                    max_instance_count=123,
                    min_instance_count=123,
                    status="status"
                ),
                model_data_download_timeout_in_seconds=123,
                model_name="modelName",
                routing_config=sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                    routing_strategy="routingStrategy"
                ),
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
        
                    # the properties below are optional
                    provisioned_concurrency=123
                ),
                volume_size_in_gb=123
            )],
        
            # the properties below are optional
            async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        include_inference_response_in=["includeInferenceResponseIn"],
                        success_topic="successTopic"
                    ),
                    s3_failure_path="s3FailurePath",
                    s3_output_path="s3OutputPath"
                ),
        
                # the properties below are optional
                client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            ),
            data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )],
                destination_s3_uri="destinationS3Uri",
                initial_sampling_percentage=123,
        
                # the properties below are optional
                capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                ),
                enable_capture=False,
                kms_key_id="kmsKeyId"
            ),
            enable_network_isolation=False,
            endpoint_config_name="endpointConfigName",
            execution_role_arn="executionRoleArn",
            explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
        
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
        
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            ),
            kms_key_id="kmsKeyId",
            shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                enable_ssm_access=False,
                inference_ami_version="inferenceAmiVersion",
                initial_instance_count=123,
                initial_variant_weight=123,
                instance_type="instanceType",
                managed_instance_scaling=sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                    max_instance_count=123,
                    min_instance_count=123,
                    status="status"
                ),
                model_data_download_timeout_in_seconds=123,
                model_name="modelName",
                routing_config=sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                    routing_strategy="routingStrategy"
                ),
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
        
                    # the properties below are optional
                    provisioned_concurrency=123
                ),
                volume_size_in_gb=123
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            vpc_config=sagemaker.CfnEndpointConfig.VpcConfigProperty(
                security_group_ids=["securityGroupIds"],
                subnets=["subnets"]
            )
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        production_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]]]]],
        async_inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        data_capture_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        execution_role_arn: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param enable_network_isolation: 
        :param endpoint_config_name: The name of the endpoint configuration.
        :param execution_role_arn: 
        :param explainer_config: A parameter to activate explainers.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .
        :param vpc_config: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5ec3761393d0c2344de58784b3017f7e1498d65c80ca0e29094c617103903e4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointConfigProps(
            production_variants=production_variants,
            async_inference_config=async_inference_config,
            data_capture_config=data_capture_config,
            enable_network_isolation=enable_network_isolation,
            endpoint_config_name=endpoint_config_name,
            execution_role_arn=execution_role_arn,
            explainer_config=explainer_config,
            kms_key_id=kms_key_id,
            shadow_production_variants=shadow_production_variants,
            tags=tags,
            vpc_config=vpc_config,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2d94310d95f958331f33f530628190b1b0cb9f396a80c916a18ff5d4f37f1b4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d017ceb78f627a4d082938a9d00f60606064212462ecc172f2732ca4cfecf4e)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointConfigName")
    def attr_endpoint_config_name(self) -> builtins.str:
        '''The name of the endpoint configuration, such as ``MyEndpointConfiguration`` .

        :cloudformationAttribute: EndpointConfigName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointConfigName"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''
        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="productionVariants")
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]], jsii.get(self, "productionVariants"))

    @production_variants.setter
    def production_variants(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfd9dbaba28aed3cd83027875322f2cbb70f3fea264bd0ad0c78e962c341e3e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "productionVariants", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="asyncInferenceConfig")
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]], jsii.get(self, "asyncInferenceConfig"))

    @async_inference_config.setter
    def async_inference_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d66437c5253334608419691e2755c084d9f098a57fe7460e997e14374a4394b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "asyncInferenceConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="dataCaptureConfig")
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]]:
        '''Specifies how to capture endpoint data for model monitor.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]], jsii.get(self, "dataCaptureConfig"))

    @data_capture_config.setter
    def data_capture_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13ddfd0a291efa4705835c0f8adb807852e0c61e1bcff1144556e06335ac7f46)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataCaptureConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="enableNetworkIsolation")
    def enable_network_isolation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "enableNetworkIsolation"))

    @enable_network_isolation.setter
    def enable_network_isolation(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b84b130678c86998100d841aba59b69e7249ee09f47b89e205eddb9f70d59cd6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableNetworkIsolation", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c1e35e22547536b5f3a9420b1327dcc09512d00f5a6fcb7050fb847aef3cc7e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="executionRoleArn")
    def execution_role_arn(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "executionRoleArn"))

    @execution_role_arn.setter
    def execution_role_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__581dfd37743e4c2af9ac0f0eecf04a51838a2258349beb74cea64c57f10c1b56)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "executionRoleArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="explainerConfig")
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]]:
        '''A parameter to activate explainers.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]], jsii.get(self, "explainerConfig"))

    @explainer_config.setter
    def explainer_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f3348af00a67f21513de8698151acf7998ee647db8a9740c9d0d51eb170a4fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "explainerConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1feedfcd01ce7ecf1fca052ce76bf378f4ce268fabd561d3ec301f697053426d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="shadowProductionVariants")
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]]:
        '''Array of ``ProductionVariant`` objects.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]], jsii.get(self, "shadowProductionVariants"))

    @shadow_production_variants.setter
    def shadow_production_variants(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__364e8e55ae8c7122cb952ab736c20798058ad6defc1088f9d91757193a806d68)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "shadowProductionVariants", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a87b0cdee3111cac9d994b2db39e4afee50e739e8856c202cbae175391893dd6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="vpcConfig")
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.VpcConfigProperty"]]:
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.VpcConfigProperty"]], jsii.get(self, "vpcConfig"))

    @vpc_config.setter
    def vpc_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.VpcConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b56879c446ab33e312f91778c0221db7735c2aed701c929318efc4707ff5c69f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcConfig", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrent_invocations_per_instance": "maxConcurrentInvocationsPerInstance",
        },
    )
    class AsyncInferenceClientConfigProperty:
        def __init__(
            self,
            *,
            max_concurrent_invocations_per_instance: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :param max_concurrent_invocations_per_instance: The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, SageMaker will choose an optimal value for you.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_client_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3dee0d44cdca5f0d19568fbd2782436822015939f8aeb568463590b55f41cfe6)
                check_type(argname="argument max_concurrent_invocations_per_instance", value=max_concurrent_invocations_per_instance, expected_type=type_hints["max_concurrent_invocations_per_instance"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max_concurrent_invocations_per_instance is not None:
                self._values["max_concurrent_invocations_per_instance"] = max_concurrent_invocations_per_instance

        @builtins.property
        def max_concurrent_invocations_per_instance(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The maximum number of concurrent requests sent by the SageMaker client to the model container.

            If no value is provided, SageMaker will choose an optimal value for you.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceclientconfig-maxconcurrentinvocationsperinstance
            '''
            result = self._values.get("max_concurrent_invocations_per_instance")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceClientConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "output_config": "outputConfig",
            "client_config": "clientConfig",
        },
    )
    class AsyncInferenceConfigProperty:
        def __init__(
            self,
            *,
            output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            client_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceClientConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies configuration for how an endpoint performs asynchronous inference.

            :param output_config: Specifies the configuration for asynchronous inference invocation outputs.
            :param client_config: Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            include_inference_response_in=["includeInferenceResponseIn"],
                            success_topic="successTopic"
                        ),
                        s3_failure_path="s3FailurePath",
                        s3_output_path="s3OutputPath"
                    ),
                
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9d6279f6f1637a7f063e020863fb6143db719f071239eaff4a14abcffa4e236c)
                check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
                check_type(argname="argument client_config", value=client_config, expected_type=type_hints["client_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "output_config": output_config,
            }
            if client_config is not None:
                self._values["client_config"] = client_config

        @builtins.property
        def output_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceOutputConfigProperty"]:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-outputconfig
            '''
            result = self._values.get("output_config")
            assert result is not None, "Required property 'output_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceOutputConfigProperty"], result)

        @builtins.property
        def client_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceClientConfigProperty"]]:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-clientconfig
            '''
            result = self._values.get("client_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceClientConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "error_topic": "errorTopic",
            "include_inference_response_in": "includeInferenceResponseIn",
            "success_topic": "successTopic",
        },
    )
    class AsyncInferenceNotificationConfigProperty:
        def __init__(
            self,
            *,
            error_topic: typing.Optional[builtins.str] = None,
            include_inference_response_in: typing.Optional[typing.Sequence[builtins.str]] = None,
            success_topic: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :param error_topic: Amazon SNS topic to post a notification to when an inference fails. If no topic is provided, no notification is sent on failure.
            :param include_inference_response_in: The Amazon SNS topics where you want the inference response to be included. .. epigraph:: The inference response is included only if the response size is less than or equal to 128 KB.
            :param success_topic: Amazon SNS topic to post a notification to when an inference completes successfully. If no topic is provided, no notification is sent on success.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_notification_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                    error_topic="errorTopic",
                    include_inference_response_in=["includeInferenceResponseIn"],
                    success_topic="successTopic"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__78f6f560c2b90941cc4af6490a3ab4a8382e19112589f81c2bff6e63dfa574bb)
                check_type(argname="argument error_topic", value=error_topic, expected_type=type_hints["error_topic"])
                check_type(argname="argument include_inference_response_in", value=include_inference_response_in, expected_type=type_hints["include_inference_response_in"])
                check_type(argname="argument success_topic", value=success_topic, expected_type=type_hints["success_topic"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if error_topic is not None:
                self._values["error_topic"] = error_topic
            if include_inference_response_in is not None:
                self._values["include_inference_response_in"] = include_inference_response_in
            if success_topic is not None:
                self._values["success_topic"] = success_topic

        @builtins.property
        def error_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference fails.

            If no topic is provided, no notification is sent on failure.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-errortopic
            '''
            result = self._values.get("error_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def include_inference_response_in(
            self,
        ) -> typing.Optional[typing.List[builtins.str]]:
            '''The Amazon SNS topics where you want the inference response to be included.

            .. epigraph::

               The inference response is included only if the response size is less than or equal to 128 KB.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-includeinferenceresponsein
            '''
            result = self._values.get("include_inference_response_in")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def success_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference completes successfully.

            If no topic is provided, no notification is sent on success.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-successtopic
            '''
            result = self._values.get("success_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceNotificationConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "kms_key_id": "kmsKeyId",
            "notification_config": "notificationConfig",
            "s3_failure_path": "s3FailurePath",
            "s3_output_path": "s3OutputPath",
        },
    )
    class AsyncInferenceOutputConfigProperty:
        def __init__(
            self,
            *,
            kms_key_id: typing.Optional[builtins.str] = None,
            notification_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceNotificationConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            s3_failure_path: typing.Optional[builtins.str] = None,
            s3_output_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
            :param notification_config: Specifies the configuration for notifications of inference results for asynchronous inference.
            :param s3_failure_path: The Amazon S3 location to upload failure inference responses to.
            :param s3_output_path: The Amazon S3 location to upload inference responses to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_output_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        include_inference_response_in=["includeInferenceResponseIn"],
                        success_topic="successTopic"
                    ),
                    s3_failure_path="s3FailurePath",
                    s3_output_path="s3OutputPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c3ae80c64de4a57385622840864bf472efd012f72363c8a905b70c436e071533)
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
                check_type(argname="argument notification_config", value=notification_config, expected_type=type_hints["notification_config"])
                check_type(argname="argument s3_failure_path", value=s3_failure_path, expected_type=type_hints["s3_failure_path"])
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id
            if notification_config is not None:
                self._values["notification_config"] = notification_config
            if s3_failure_path is not None:
                self._values["s3_failure_path"] = s3_failure_path
            if s3_output_path is not None:
                self._values["s3_output_path"] = s3_output_path

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def notification_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"]]:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-notificationconfig
            '''
            result = self._values.get("notification_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"]], result)

        @builtins.property
        def s3_failure_path(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 location to upload failure inference responses to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3failurepath
            '''
            result = self._values.get("s3_failure_path")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_output_path(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 location to upload inference responses to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={
            "csv_content_types": "csvContentTypes",
            "json_content_types": "jsonContentTypes",
        },
    )
    class CaptureContentTypeHeaderProperty:
        def __init__(
            self,
            *,
            csv_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            json_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Specifies the JSON and CSV content types of the data that the endpoint captures.

            :param csv_content_types: A list of the CSV content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
            :param json_content_types: A list of the JSON content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capture_content_type_header_property = sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8f365f85e452b00846d8dd4987370795343fee0c95178a92e6cb69c5d32bba4e)
                check_type(argname="argument csv_content_types", value=csv_content_types, expected_type=type_hints["csv_content_types"])
                check_type(argname="argument json_content_types", value=json_content_types, expected_type=type_hints["json_content_types"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv_content_types is not None:
                self._values["csv_content_types"] = csv_content_types
            if json_content_types is not None:
                self._values["json_content_types"] = json_content_types

        @builtins.property
        def csv_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the CSV content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-csvcontenttypes
            '''
            result = self._values.get("csv_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def json_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the JSON content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-jsoncontenttypes
            '''
            result = self._values.get("json_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureContentTypeHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureOptionProperty",
        jsii_struct_bases=[],
        name_mapping={"capture_mode": "captureMode"},
    )
    class CaptureOptionProperty:
        def __init__(self, *, capture_mode: builtins.str) -> None:
            '''Specifies whether the endpoint captures input data or output data.

            :param capture_mode: Specifies whether the endpoint captures input data or output data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capture_option_property = sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__025dde0eee27b1ccd2ed0364dddac7611f70b70c09602593590e4a1cc7047b37)
                check_type(argname="argument capture_mode", value=capture_mode, expected_type=type_hints["capture_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_mode": capture_mode,
            }

        @builtins.property
        def capture_mode(self) -> builtins.str:
            '''Specifies whether the endpoint captures input data or output data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
            '''
            result = self._values.get("capture_mode")
            assert result is not None, "Required property 'capture_mode' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureOptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_config": "shapConfig",
            "enable_explanations": "enableExplanations",
            "inference_config": "inferenceConfig",
        },
    )
    class ClarifyExplainerConfigProperty:
        def __init__(
            self,
            *,
            shap_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyShapConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            enable_explanations: typing.Optional[builtins.str] = None,
            inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration parameters for the SageMaker Clarify explainer.

            :param shap_config: The configuration for SHAP analysis.
            :param enable_explanations: A JMESPath boolean expression used to filter which records to explain. Explanations are activated by default. See ```EnableExplanations`` <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable>`_ for additional information.
            :param inference_config: The inference configuration parameter for the model container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_explainer_config_property = sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
                
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
                
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__558fc059462816c0491f464603da3fabbd56effd8ec81519187f942727b6f280)
                check_type(argname="argument shap_config", value=shap_config, expected_type=type_hints["shap_config"])
                check_type(argname="argument enable_explanations", value=enable_explanations, expected_type=type_hints["enable_explanations"])
                check_type(argname="argument inference_config", value=inference_config, expected_type=type_hints["inference_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_config": shap_config,
            }
            if enable_explanations is not None:
                self._values["enable_explanations"] = enable_explanations
            if inference_config is not None:
                self._values["inference_config"] = inference_config

        @builtins.property
        def shap_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapConfigProperty"]:
            '''The configuration for SHAP analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-shapconfig
            '''
            result = self._values.get("shap_config")
            assert result is not None, "Required property 'shap_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapConfigProperty"], result)

        @builtins.property
        def enable_explanations(self) -> typing.Optional[builtins.str]:
            '''A JMESPath boolean expression used to filter which records to explain.

            Explanations are activated by default. See ```EnableExplanations`` <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable>`_ for additional information.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-enableexplanations
            '''
            result = self._values.get("enable_explanations")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyInferenceConfigProperty"]]:
            '''The inference configuration parameter for the model container.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-inferenceconfig
            '''
            result = self._values.get("inference_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyInferenceConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "content_template": "contentTemplate",
            "feature_headers": "featureHeaders",
            "features_attribute": "featuresAttribute",
            "feature_types": "featureTypes",
            "label_attribute": "labelAttribute",
            "label_headers": "labelHeaders",
            "label_index": "labelIndex",
            "max_payload_in_mb": "maxPayloadInMb",
            "max_record_count": "maxRecordCount",
            "probability_attribute": "probabilityAttribute",
            "probability_index": "probabilityIndex",
        },
    )
    class ClarifyInferenceConfigProperty:
        def __init__(
            self,
            *,
            content_template: typing.Optional[builtins.str] = None,
            feature_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            feature_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_attribute: typing.Optional[builtins.str] = None,
            label_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_index: typing.Optional[jsii.Number] = None,
            max_payload_in_mb: typing.Optional[jsii.Number] = None,
            max_record_count: typing.Optional[jsii.Number] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_index: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The inference configuration parameter for the model container.

            :param content_template: A template string used to format a JSON record into an acceptable model container input. For example, a ``ContentTemplate`` string ``'{"myfeatures":$features}'`` will format a list of features ``[1,2,3]`` into the record string ``'{"myfeatures":[1,2,3]}'`` . Required only when the model container input is in JSON Lines format.
            :param feature_headers: The names of the features. If provided, these are included in the endpoint response payload to help readability of the ``InvokeEndpoint`` output. See the `Response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information.
            :param features_attribute: Provides the JMESPath expression to extract the features from a model container input in JSON Lines format. For example, if ``FeaturesAttribute`` is the JMESPath expression ``'myfeatures'`` , it extracts a list of features ``[1,2,3]`` from request data ``'{"myfeatures":[1,2,3]}'`` .
            :param feature_types: A list of data types of the features (optional). Applicable only to NLP explainability. If provided, ``FeatureTypes`` must have at least one ``'text'`` string (for example, ``['text']`` ). If ``FeatureTypes`` is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the `response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information.
            :param label_attribute: A JMESPath expression used to locate the list of label headers in the model container output. *Example* : If the model container output of a batch request is ``'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'`` , then set ``LabelAttribute`` to ``'labels'`` to extract the list of label headers ``["cat","dog","fish"]``
            :param label_headers: For multiclass classification problems, the label headers are the names of the classes. Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the ``InvokeEndpoint`` API. See the `response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.
            :param label_index: A zero-based index used to extract a label header or list of label headers from model container output in CSV format. *Example for a multiclass model:* If the model container output consists of label headers followed by probabilities: ``'"[\\'cat\\',\\'dog\\',\\'fish\\']","[0.1,0.6,0.3]"'`` , set ``LabelIndex`` to ``0`` to select the label headers ``['cat','dog','fish']`` .
            :param max_payload_in_mb: The maximum payload size (MB) allowed of a request from the explainer to the model container. Defaults to ``6`` MB.
            :param max_record_count: The maximum number of records in a request that the model container can process when querying the model container for the predictions of a `synthetic dataset <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic>`_ . A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If ``MaxRecordCount`` is ``1`` , the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.
            :param probability_attribute: A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format. *Example* : If the model container output of a single request is ``'{"predicted_label":1,"probability":0.6}'`` , then set ``ProbabilityAttribute`` to ``'probability'`` .
            :param probability_index: A zero-based index used to extract a probability value (score) or list from model container output in CSV format. If this value is not provided, the entire model container output will be treated as a probability value (score) or list. *Example for a single class model:* If the model container output consists of a string-formatted prediction label followed by its probability: ``'1,0.6'`` , set ``ProbabilityIndex`` to ``1`` to select the probability value ``0.6`` . *Example for a multiclass model:* If the model container output consists of a string-formatted prediction label followed by its probability: ``'"[\\'cat\\',\\'dog\\',\\'fish\\']","[0.1,0.6,0.3]"'`` , set ``ProbabilityIndex`` to ``1`` to select the probability values ``[0.1,0.6,0.3]`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_inference_config_property = sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                    content_template="contentTemplate",
                    feature_headers=["featureHeaders"],
                    features_attribute="featuresAttribute",
                    feature_types=["featureTypes"],
                    label_attribute="labelAttribute",
                    label_headers=["labelHeaders"],
                    label_index=123,
                    max_payload_in_mb=123,
                    max_record_count=123,
                    probability_attribute="probabilityAttribute",
                    probability_index=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__219c4bc4be82ae8b985455b761775c8949e24bde8f8339359c77ac29849deaa3)
                check_type(argname="argument content_template", value=content_template, expected_type=type_hints["content_template"])
                check_type(argname="argument feature_headers", value=feature_headers, expected_type=type_hints["feature_headers"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument feature_types", value=feature_types, expected_type=type_hints["feature_types"])
                check_type(argname="argument label_attribute", value=label_attribute, expected_type=type_hints["label_attribute"])
                check_type(argname="argument label_headers", value=label_headers, expected_type=type_hints["label_headers"])
                check_type(argname="argument label_index", value=label_index, expected_type=type_hints["label_index"])
                check_type(argname="argument max_payload_in_mb", value=max_payload_in_mb, expected_type=type_hints["max_payload_in_mb"])
                check_type(argname="argument max_record_count", value=max_record_count, expected_type=type_hints["max_record_count"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_index", value=probability_index, expected_type=type_hints["probability_index"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if content_template is not None:
                self._values["content_template"] = content_template
            if feature_headers is not None:
                self._values["feature_headers"] = feature_headers
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if feature_types is not None:
                self._values["feature_types"] = feature_types
            if label_attribute is not None:
                self._values["label_attribute"] = label_attribute
            if label_headers is not None:
                self._values["label_headers"] = label_headers
            if label_index is not None:
                self._values["label_index"] = label_index
            if max_payload_in_mb is not None:
                self._values["max_payload_in_mb"] = max_payload_in_mb
            if max_record_count is not None:
                self._values["max_record_count"] = max_record_count
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_index is not None:
                self._values["probability_index"] = probability_index

        @builtins.property
        def content_template(self) -> typing.Optional[builtins.str]:
            '''A template string used to format a JSON record into an acceptable model container input.

            For example, a ``ContentTemplate`` string ``'{"myfeatures":$features}'`` will format a list of features ``[1,2,3]`` into the record string ``'{"myfeatures":[1,2,3]}'`` . Required only when the model container input is in JSON Lines format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-contenttemplate
            '''
            result = self._values.get("content_template")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The names of the features.

            If provided, these are included in the endpoint response payload to help readability of the ``InvokeEndpoint`` output. See the `Response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featureheaders
            '''
            result = self._values.get("feature_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''Provides the JMESPath expression to extract the features from a model container input in JSON Lines format.

            For example, if ``FeaturesAttribute`` is the JMESPath expression ``'myfeatures'`` , it extracts a list of features ``[1,2,3]`` from request data ``'{"myfeatures":[1,2,3]}'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of data types of the features (optional).

            Applicable only to NLP explainability. If provided, ``FeatureTypes`` must have at least one ``'text'`` string (for example, ``['text']`` ). If ``FeatureTypes`` is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the `response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuretypes
            '''
            result = self._values.get("feature_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_attribute(self) -> typing.Optional[builtins.str]:
            '''A JMESPath expression used to locate the list of label headers in the model container output.

            *Example* : If the model container output of a batch request is ``'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'`` , then set ``LabelAttribute`` to ``'labels'`` to extract the list of label headers ``["cat","dog","fish"]``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelattribute
            '''
            result = self._values.get("label_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def label_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''For multiclass classification problems, the label headers are the names of the classes.

            Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the ``InvokeEndpoint`` API. See the `response <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response>`_ section under *Invoke the endpoint* in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelheaders
            '''
            result = self._values.get("label_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_index(self) -> typing.Optional[jsii.Number]:
            '''A zero-based index used to extract a label header or list of label headers from model container output in CSV format.

            *Example for a multiclass model:* If the model container output consists of label headers followed by probabilities: ``'"[\\'cat\\',\\'dog\\',\\'fish\\']","[0.1,0.6,0.3]"'`` , set ``LabelIndex`` to ``0`` to select the label headers ``['cat','dog','fish']`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelindex
            '''
            result = self._values.get("label_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_payload_in_mb(self) -> typing.Optional[jsii.Number]:
            '''The maximum payload size (MB) allowed of a request from the explainer to the model container.

            Defaults to ``6`` MB.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxpayloadinmb
            '''
            result = self._values.get("max_payload_in_mb")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_record_count(self) -> typing.Optional[jsii.Number]:
            '''The maximum number of records in a request that the model container can process when querying the model container for the predictions of a `synthetic dataset <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic>`_ . A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If ``MaxRecordCount`` is ``1`` , the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxrecordcount
            '''
            result = self._values.get("max_record_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.

            *Example* : If the model container output of a single request is ``'{"predicted_label":1,"probability":0.6}'`` , then set ``ProbabilityAttribute`` to ``'probability'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_index(self) -> typing.Optional[jsii.Number]:
            '''A zero-based index used to extract a probability value (score) or list from model container output in CSV format.

            If this value is not provided, the entire model container output will be treated as a probability value (score) or list.

            *Example for a single class model:* If the model container output consists of a string-formatted prediction label followed by its probability: ``'1,0.6'`` , set ``ProbabilityIndex`` to ``1`` to select the probability value ``0.6`` .

            *Example for a multiclass model:* If the model container output consists of a string-formatted prediction label followed by its probability: ``'"[\\'cat\\',\\'dog\\',\\'fish\\']","[0.1,0.6,0.3]"'`` , set ``ProbabilityIndex`` to ``1`` to select the probability values ``[0.1,0.6,0.3]`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityindex
            '''
            result = self._values.get("probability_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "mime_type": "mimeType",
            "shap_baseline": "shapBaseline",
            "shap_baseline_uri": "shapBaselineUri",
        },
    )
    class ClarifyShapBaselineConfigProperty:
        def __init__(
            self,
            *,
            mime_type: typing.Optional[builtins.str] = None,
            shap_baseline: typing.Optional[builtins.str] = None,
            shap_baseline_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the `SHAP baseline <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-feature-attribute-shap-baselines.html>`_ (also called the background or reference dataset) of the Kernal SHAP algorithm.

            .. epigraph::

               - The number of records in the baseline data determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the *Synthetic data* of `Configure and create an endpoint <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html>`_ .
               - ``ShapBaseline`` and ``ShapBaselineUri`` are mutually exclusive parameters. One or the either is required to configure a SHAP baseline.

            :param mime_type: The MIME type of the baseline data. Choose from ``'text/csv'`` or ``'application/jsonlines'`` . Defaults to ``'text/csv'`` .
            :param shap_baseline: The inline SHAP baseline data in string format. ``ShapBaseline`` can have one or multiple records to be used as the baseline dataset. The format of the SHAP baseline file should be the same format as the training dataset. For example, if the training dataset is in CSV format and each record contains four features, and all features are numerical, then the format of the baseline data should also share these characteristics. For natural language processing (NLP) of text columns, the baseline value should be the value used to replace the unit of text specified by the ``Granularity`` of the ``TextConfig`` parameter. The size limit for ``ShapBasline`` is 4 KB. Use the ``ShapBaselineUri`` parameter if you want to provide more than 4 KB of baseline data.
            :param shap_baseline_uri: The uniform resource identifier (URI) of the S3 bucket where the SHAP baseline file is stored. The format of the SHAP baseline file should be the same format as the format of the training dataset. For example, if the training dataset is in CSV format, and each record in the training dataset has four features, and all features are numerical, then the baseline file should also have this same format. Each record should contain only the features. If you are using a virtual private cloud (VPC), the ``ShapBaselineUri`` should be accessible to the VPC. For more information about setting up endpoints with Amazon Virtual Private Cloud, see `Give SageMaker access to Resources in your Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_shap_baseline_config_property = sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                    mime_type="mimeType",
                    shap_baseline="shapBaseline",
                    shap_baseline_uri="shapBaselineUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cdc07b2ae81ca067b669ad8eee10c233a84cec6816b6e1eaeb4a3c9022fb49f4)
                check_type(argname="argument mime_type", value=mime_type, expected_type=type_hints["mime_type"])
                check_type(argname="argument shap_baseline", value=shap_baseline, expected_type=type_hints["shap_baseline"])
                check_type(argname="argument shap_baseline_uri", value=shap_baseline_uri, expected_type=type_hints["shap_baseline_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if mime_type is not None:
                self._values["mime_type"] = mime_type
            if shap_baseline is not None:
                self._values["shap_baseline"] = shap_baseline
            if shap_baseline_uri is not None:
                self._values["shap_baseline_uri"] = shap_baseline_uri

        @builtins.property
        def mime_type(self) -> typing.Optional[builtins.str]:
            '''The MIME type of the baseline data.

            Choose from ``'text/csv'`` or ``'application/jsonlines'`` . Defaults to ``'text/csv'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-mimetype
            '''
            result = self._values.get("mime_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline(self) -> typing.Optional[builtins.str]:
            '''The inline SHAP baseline data in string format.

            ``ShapBaseline`` can have one or multiple records to be used as the baseline dataset. The format of the SHAP baseline file should be the same format as the training dataset. For example, if the training dataset is in CSV format and each record contains four features, and all features are numerical, then the format of the baseline data should also share these characteristics. For natural language processing (NLP) of text columns, the baseline value should be the value used to replace the unit of text specified by the ``Granularity`` of the ``TextConfig`` parameter. The size limit for ``ShapBasline`` is 4 KB. Use the ``ShapBaselineUri`` parameter if you want to provide more than 4 KB of baseline data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaseline
            '''
            result = self._values.get("shap_baseline")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline_uri(self) -> typing.Optional[builtins.str]:
            '''The uniform resource identifier (URI) of the S3 bucket where the SHAP baseline file is stored.

            The format of the SHAP baseline file should be the same format as the format of the training dataset. For example, if the training dataset is in CSV format, and each record in the training dataset has four features, and all features are numerical, then the baseline file should also have this same format. Each record should contain only the features. If you are using a virtual private cloud (VPC), the ``ShapBaselineUri`` should be accessible to the VPC. For more information about setting up endpoints with Amazon Virtual Private Cloud, see `Give SageMaker access to Resources in your Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaselineuri
            '''
            result = self._values.get("shap_baseline_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_baseline_config": "shapBaselineConfig",
            "number_of_samples": "numberOfSamples",
            "seed": "seed",
            "text_config": "textConfig",
            "use_logit": "useLogit",
        },
    )
    class ClarifyShapConfigProperty:
        def __init__(
            self,
            *,
            shap_baseline_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyShapBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            number_of_samples: typing.Optional[jsii.Number] = None,
            seed: typing.Optional[jsii.Number] = None,
            text_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyTextConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            use_logit: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The configuration for SHAP analysis using SageMaker Clarify Explainer.

            :param shap_baseline_config: The configuration for the SHAP baseline of the Kernal SHAP algorithm.
            :param number_of_samples: The number of samples to be used for analysis by the Kernal SHAP algorithm. .. epigraph:: The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the *Synthetic data* of `Configure and create an endpoint <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html>`_ .
            :param seed: The starting value used to initialize the random number generator in the explainer. Provide a value for this parameter to obtain a deterministic SHAP result.
            :param text_config: A parameter that indicates if text features are treated as text and explanations are provided for individual units of text. Required for natural language processing (NLP) explainability only.
            :param use_logit: A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions. Defaults to false.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_shap_config_property = sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                    shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                        mime_type="mimeType",
                        shap_baseline="shapBaseline",
                        shap_baseline_uri="shapBaselineUri"
                    ),
                
                    # the properties below are optional
                    number_of_samples=123,
                    seed=123,
                    text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                        granularity="granularity",
                        language="language"
                    ),
                    use_logit=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d13ff204bac34e66abda71c300286f5367bc3e95b80ce1f5be250f0fd508e677)
                check_type(argname="argument shap_baseline_config", value=shap_baseline_config, expected_type=type_hints["shap_baseline_config"])
                check_type(argname="argument number_of_samples", value=number_of_samples, expected_type=type_hints["number_of_samples"])
                check_type(argname="argument seed", value=seed, expected_type=type_hints["seed"])
                check_type(argname="argument text_config", value=text_config, expected_type=type_hints["text_config"])
                check_type(argname="argument use_logit", value=use_logit, expected_type=type_hints["use_logit"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_baseline_config": shap_baseline_config,
            }
            if number_of_samples is not None:
                self._values["number_of_samples"] = number_of_samples
            if seed is not None:
                self._values["seed"] = seed
            if text_config is not None:
                self._values["text_config"] = text_config
            if use_logit is not None:
                self._values["use_logit"] = use_logit

        @builtins.property
        def shap_baseline_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapBaselineConfigProperty"]:
            '''The configuration for the SHAP baseline of the Kernal SHAP algorithm.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-shapbaselineconfig
            '''
            result = self._values.get("shap_baseline_config")
            assert result is not None, "Required property 'shap_baseline_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapBaselineConfigProperty"], result)

        @builtins.property
        def number_of_samples(self) -> typing.Optional[jsii.Number]:
            '''The number of samples to be used for analysis by the Kernal SHAP algorithm.

            .. epigraph::

               The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the *Synthetic data* of `Configure and create an endpoint <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-numberofsamples
            '''
            result = self._values.get("number_of_samples")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def seed(self) -> typing.Optional[jsii.Number]:
            '''The starting value used to initialize the random number generator in the explainer.

            Provide a value for this parameter to obtain a deterministic SHAP result.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-seed
            '''
            result = self._values.get("seed")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def text_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyTextConfigProperty"]]:
            '''A parameter that indicates if text features are treated as text and explanations are provided for individual units of text.

            Required for natural language processing (NLP) explainability only.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-textconfig
            '''
            result = self._values.get("text_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyTextConfigProperty"]], result)

        @builtins.property
        def use_logit(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions.

            Defaults to false.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-uselogit
            '''
            result = self._values.get("use_logit")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"granularity": "granularity", "language": "language"},
    )
    class ClarifyTextConfigProperty:
        def __init__(
            self,
            *,
            granularity: builtins.str,
            language: builtins.str,
        ) -> None:
            '''A parameter used to configure the SageMaker Clarify explainer to treat text features as text so that explanations are provided for individual units of text.

            Required only for natural language processing (NLP) explainability.

            :param granularity: The unit of granularity for the analysis of text features. For example, if the unit is ``'token'`` , then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.
            :param language: Specifies the language of the text features in [ISO 639-1](https://docs.aws.amazon.com/ https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or `ISO 639-3 <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_639-3>`_ code of a supported language. .. epigraph:: For a mix of multiple languages, use code ``'xx'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_text_config_property = sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                    granularity="granularity",
                    language="language"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bb02c2885c5605c12d9e5b35849a33c20ae5db4791746707dc4165477061ed2d)
                check_type(argname="argument granularity", value=granularity, expected_type=type_hints["granularity"])
                check_type(argname="argument language", value=language, expected_type=type_hints["language"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "granularity": granularity,
                "language": language,
            }

        @builtins.property
        def granularity(self) -> builtins.str:
            '''The unit of granularity for the analysis of text features.

            For example, if the unit is ``'token'`` , then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-granularity
            '''
            result = self._values.get("granularity")
            assert result is not None, "Required property 'granularity' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def language(self) -> builtins.str:
            '''Specifies the language of the text features in [ISO 639-1](https://docs.aws.amazon.com/ https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or `ISO 639-3 <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_639-3>`_ code of a supported language.

            .. epigraph::

               For a mix of multiple languages, use code ``'xx'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-language
            '''
            result = self._values.get("language")
            assert result is not None, "Required property 'language' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyTextConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.DataCaptureConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "capture_options": "captureOptions",
            "destination_s3_uri": "destinationS3Uri",
            "initial_sampling_percentage": "initialSamplingPercentage",
            "capture_content_type_header": "captureContentTypeHeader",
            "enable_capture": "enableCapture",
            "kms_key_id": "kmsKeyId",
        },
    )
    class DataCaptureConfigProperty:
        def __init__(
            self,
            *,
            capture_options: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.CaptureOptionProperty", typing.Dict[builtins.str, typing.Any]]]]],
            destination_s3_uri: builtins.str,
            initial_sampling_percentage: jsii.Number,
            capture_content_type_header: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.CaptureContentTypeHeaderProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            enable_capture: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration of your endpoint for model monitor data capture.

            :param capture_options: Specifies whether the endpoint captures input data to your model, output data from your model, or both.
            :param destination_s3_uri: The S3 bucket where model monitor stores captured data.
            :param initial_sampling_percentage: The percentage of data to capture.
            :param capture_content_type_header: A list of the JSON and CSV content type that the endpoint captures.
            :param enable_capture: Set to ``True`` to enable data capture.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption. The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_capture_config_property = sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
                
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f66371a559ba65ff125b2321cd8b6a93386ca97a2bbac0b89139668121914bb)
                check_type(argname="argument capture_options", value=capture_options, expected_type=type_hints["capture_options"])
                check_type(argname="argument destination_s3_uri", value=destination_s3_uri, expected_type=type_hints["destination_s3_uri"])
                check_type(argname="argument initial_sampling_percentage", value=initial_sampling_percentage, expected_type=type_hints["initial_sampling_percentage"])
                check_type(argname="argument capture_content_type_header", value=capture_content_type_header, expected_type=type_hints["capture_content_type_header"])
                check_type(argname="argument enable_capture", value=enable_capture, expected_type=type_hints["enable_capture"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_options": capture_options,
                "destination_s3_uri": destination_s3_uri,
                "initial_sampling_percentage": initial_sampling_percentage,
            }
            if capture_content_type_header is not None:
                self._values["capture_content_type_header"] = capture_content_type_header
            if enable_capture is not None:
                self._values["enable_capture"] = enable_capture
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def capture_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureOptionProperty"]]]:
            '''Specifies whether the endpoint captures input data to your model, output data from your model, or both.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
            '''
            result = self._values.get("capture_options")
            assert result is not None, "Required property 'capture_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureOptionProperty"]]], result)

        @builtins.property
        def destination_s3_uri(self) -> builtins.str:
            '''The S3 bucket where model monitor stores captured data.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
            '''
            result = self._values.get("destination_s3_uri")
            assert result is not None, "Required property 'destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def initial_sampling_percentage(self) -> jsii.Number:
            '''The percentage of data to capture.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
            '''
            result = self._values.get("initial_sampling_percentage")
            assert result is not None, "Required property 'initial_sampling_percentage' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def capture_content_type_header(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureContentTypeHeaderProperty"]]:
            '''A list of the JSON and CSV content type that the endpoint captures.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
            '''
            result = self._values.get("capture_content_type_header")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureContentTypeHeaderProperty"]], result)

        @builtins.property
        def enable_capture(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Set to ``True`` to enable data capture.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
            '''
            result = self._values.get("enable_capture")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.

            The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCaptureConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"clarify_explainer_config": "clarifyExplainerConfig"},
    )
    class ExplainerConfigProperty:
        def __init__(
            self,
            *,
            clarify_explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A parameter to activate explainers.

            :param clarify_explainer_config: A member of ``ExplainerConfig`` that contains configuration parameters for the SageMaker Clarify explainer.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                explainer_config_property = sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
                
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
                
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bca400d67b7e0b7493acf5a52ff4165f4d522d876c087e0e3b8c804a10c9e4e5)
                check_type(argname="argument clarify_explainer_config", value=clarify_explainer_config, expected_type=type_hints["clarify_explainer_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if clarify_explainer_config is not None:
                self._values["clarify_explainer_config"] = clarify_explainer_config

        @builtins.property
        def clarify_explainer_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyExplainerConfigProperty"]]:
            '''A member of ``ExplainerConfig`` that contains configuration parameters for the SageMaker Clarify explainer.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html#cfn-sagemaker-endpointconfig-explainerconfig-clarifyexplainerconfig
            '''
            result = self._values.get("clarify_explainer_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyExplainerConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_instance_count": "maxInstanceCount",
            "min_instance_count": "minInstanceCount",
            "status": "status",
        },
    )
    class ManagedInstanceScalingProperty:
        def __init__(
            self,
            *,
            max_instance_count: typing.Optional[jsii.Number] = None,
            min_instance_count: typing.Optional[jsii.Number] = None,
            status: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param max_instance_count: 
            :param min_instance_count: 
            :param status: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                managed_instance_scaling_property = sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                    max_instance_count=123,
                    min_instance_count=123,
                    status="status"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__46cb311c857cc447bc44e0db8728dd4118d07da4d442a846a68ff8c75a4c5e62)
                check_type(argname="argument max_instance_count", value=max_instance_count, expected_type=type_hints["max_instance_count"])
                check_type(argname="argument min_instance_count", value=min_instance_count, expected_type=type_hints["min_instance_count"])
                check_type(argname="argument status", value=status, expected_type=type_hints["status"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max_instance_count is not None:
                self._values["max_instance_count"] = max_instance_count
            if min_instance_count is not None:
                self._values["min_instance_count"] = min_instance_count
            if status is not None:
                self._values["status"] = status

        @builtins.property
        def max_instance_count(self) -> typing.Optional[jsii.Number]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-maxinstancecount
            '''
            result = self._values.get("max_instance_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min_instance_count(self) -> typing.Optional[jsii.Number]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-mininstancecount
            '''
            result = self._values.get("min_instance_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def status(self) -> typing.Optional[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-status
            '''
            result = self._values.get("status")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ManagedInstanceScalingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ProductionVariantProperty",
        jsii_struct_bases=[],
        name_mapping={
            "variant_name": "variantName",
            "accelerator_type": "acceleratorType",
            "container_startup_health_check_timeout_in_seconds": "containerStartupHealthCheckTimeoutInSeconds",
            "enable_ssm_access": "enableSsmAccess",
            "inference_ami_version": "inferenceAmiVersion",
            "initial_instance_count": "initialInstanceCount",
            "initial_variant_weight": "initialVariantWeight",
            "instance_type": "instanceType",
            "managed_instance_scaling": "managedInstanceScaling",
            "model_data_download_timeout_in_seconds": "modelDataDownloadTimeoutInSeconds",
            "model_name": "modelName",
            "routing_config": "routingConfig",
            "serverless_config": "serverlessConfig",
            "volume_size_in_gb": "volumeSizeInGb",
        },
    )
    class ProductionVariantProperty:
        def __init__(
            self,
            *,
            variant_name: builtins.str,
            accelerator_type: typing.Optional[builtins.str] = None,
            container_startup_health_check_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            enable_ssm_access: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            inference_ami_version: typing.Optional[builtins.str] = None,
            initial_instance_count: typing.Optional[jsii.Number] = None,
            initial_variant_weight: typing.Optional[jsii.Number] = None,
            instance_type: typing.Optional[builtins.str] = None,
            managed_instance_scaling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ManagedInstanceScalingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            model_data_download_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            model_name: typing.Optional[builtins.str] = None,
            routing_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.RoutingConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            serverless_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ServerlessConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            volume_size_in_gb: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies a model that you want to host and the resources to deploy for hosting it.

            If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying the ``InitialVariantWeight`` objects.

            :param variant_name: The name of the production variant.
            :param accelerator_type: The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .
            :param container_startup_health_check_timeout_in_seconds: The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see `How Your Container Should Respond to Health Check (Ping) Requests <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests>`_ .
            :param enable_ssm_access: You can use this parameter to turn on native AWS Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling ``UpdateEndpoint`` .
            :param inference_ami_version: 
            :param initial_instance_count: Number of instances to launch initially.
            :param initial_variant_weight: Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.
            :param instance_type: The ML compute instance type.
            :param managed_instance_scaling: 
            :param model_data_download_timeout_in_seconds: The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
            :param model_name: The name of the model that you want to host. This is the name that you specified when creating the model.
            :param routing_config: 
            :param serverless_config: The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
            :param volume_size_in_gb: The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currently only Amazon EBS gp2 storage volumes are supported.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                production_variant_property = sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    variant_name="variantName",
                
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    inference_ami_version="inferenceAmiVersion",
                    initial_instance_count=123,
                    initial_variant_weight=123,
                    instance_type="instanceType",
                    managed_instance_scaling=sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                        max_instance_count=123,
                        min_instance_count=123,
                        status="status"
                    ),
                    model_data_download_timeout_in_seconds=123,
                    model_name="modelName",
                    routing_config=sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                        routing_strategy="routingStrategy"
                    ),
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
                
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__685c22aefe4bd12e237f4e6f239c6de7809e228c81d2604127d6824fa36dee01)
                check_type(argname="argument variant_name", value=variant_name, expected_type=type_hints["variant_name"])
                check_type(argname="argument accelerator_type", value=accelerator_type, expected_type=type_hints["accelerator_type"])
                check_type(argname="argument container_startup_health_check_timeout_in_seconds", value=container_startup_health_check_timeout_in_seconds, expected_type=type_hints["container_startup_health_check_timeout_in_seconds"])
                check_type(argname="argument enable_ssm_access", value=enable_ssm_access, expected_type=type_hints["enable_ssm_access"])
                check_type(argname="argument inference_ami_version", value=inference_ami_version, expected_type=type_hints["inference_ami_version"])
                check_type(argname="argument initial_instance_count", value=initial_instance_count, expected_type=type_hints["initial_instance_count"])
                check_type(argname="argument initial_variant_weight", value=initial_variant_weight, expected_type=type_hints["initial_variant_weight"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument managed_instance_scaling", value=managed_instance_scaling, expected_type=type_hints["managed_instance_scaling"])
                check_type(argname="argument model_data_download_timeout_in_seconds", value=model_data_download_timeout_in_seconds, expected_type=type_hints["model_data_download_timeout_in_seconds"])
                check_type(argname="argument model_name", value=model_name, expected_type=type_hints["model_name"])
                check_type(argname="argument routing_config", value=routing_config, expected_type=type_hints["routing_config"])
                check_type(argname="argument serverless_config", value=serverless_config, expected_type=type_hints["serverless_config"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "variant_name": variant_name,
            }
            if accelerator_type is not None:
                self._values["accelerator_type"] = accelerator_type
            if container_startup_health_check_timeout_in_seconds is not None:
                self._values["container_startup_health_check_timeout_in_seconds"] = container_startup_health_check_timeout_in_seconds
            if enable_ssm_access is not None:
                self._values["enable_ssm_access"] = enable_ssm_access
            if inference_ami_version is not None:
                self._values["inference_ami_version"] = inference_ami_version
            if initial_instance_count is not None:
                self._values["initial_instance_count"] = initial_instance_count
            if initial_variant_weight is not None:
                self._values["initial_variant_weight"] = initial_variant_weight
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if managed_instance_scaling is not None:
                self._values["managed_instance_scaling"] = managed_instance_scaling
            if model_data_download_timeout_in_seconds is not None:
                self._values["model_data_download_timeout_in_seconds"] = model_data_download_timeout_in_seconds
            if model_name is not None:
                self._values["model_name"] = model_name
            if routing_config is not None:
                self._values["routing_config"] = routing_config
            if serverless_config is not None:
                self._values["serverless_config"] = serverless_config
            if volume_size_in_gb is not None:
                self._values["volume_size_in_gb"] = volume_size_in_gb

        @builtins.property
        def variant_name(self) -> builtins.str:
            '''The name of the production variant.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
            '''
            result = self._values.get("variant_name")
            assert result is not None, "Required property 'variant_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def accelerator_type(self) -> typing.Optional[builtins.str]:
            '''The size of the Elastic Inference (EI) instance to use for the production variant.

            EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
            '''
            result = self._values.get("accelerator_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def container_startup_health_check_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting.

            For more information about health check, see `How Your Container Should Respond to Health Check (Ping) Requests <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-containerstartuphealthchecktimeoutinseconds
            '''
            result = self._values.get("container_startup_health_check_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def enable_ssm_access(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''You can use this parameter to turn on native AWS Systems Manager (SSM) access for a production variant behind an endpoint.

            By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling ``UpdateEndpoint`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-enablessmaccess
            '''
            result = self._values.get("enable_ssm_access")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def inference_ami_version(self) -> typing.Optional[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-inferenceamiversion
            '''
            result = self._values.get("inference_ami_version")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def initial_instance_count(self) -> typing.Optional[jsii.Number]:
            '''Number of instances to launch initially.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
            '''
            result = self._values.get("initial_instance_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def initial_variant_weight(self) -> typing.Optional[jsii.Number]:
            '''Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.

            The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
            '''
            result = self._values.get("initial_variant_weight")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The ML compute instance type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def managed_instance_scaling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ManagedInstanceScalingProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-managedinstancescaling
            '''
            result = self._values.get("managed_instance_scaling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ManagedInstanceScalingProperty"]], result)

        @builtins.property
        def model_data_download_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modeldatadownloadtimeoutinseconds
            '''
            result = self._values.get("model_data_download_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def model_name(self) -> typing.Optional[builtins.str]:
            '''The name of the model that you want to host.

            This is the name that you specified when creating the model.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
            '''
            result = self._values.get("model_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def routing_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.RoutingConfigProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-routingconfig
            '''
            result = self._values.get("routing_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.RoutingConfigProperty"]], result)

        @builtins.property
        def serverless_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ServerlessConfigProperty"]]:
            '''The serverless configuration for an endpoint.

            Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig
            '''
            result = self._values.get("serverless_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ServerlessConfigProperty"]], result)

        @builtins.property
        def volume_size_in_gb(self) -> typing.Optional[jsii.Number]:
            '''The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant.

            Currently only Amazon EBS gp2 storage volumes are supported.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ProductionVariantProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.RoutingConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"routing_strategy": "routingStrategy"},
    )
    class RoutingConfigProperty:
        def __init__(
            self,
            *,
            routing_strategy: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param routing_strategy: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                routing_config_property = sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                    routing_strategy="routingStrategy"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__41a70a45b46693d52cb9cc5fc85772297ca38491c9ce53c7e06d6304a7c4f1e0)
                check_type(argname="argument routing_strategy", value=routing_strategy, expected_type=type_hints["routing_strategy"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if routing_strategy is not None:
                self._values["routing_strategy"] = routing_strategy

        @builtins.property
        def routing_strategy(self) -> typing.Optional[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html#cfn-sagemaker-endpointconfig-routingconfig-routingstrategy
            '''
            result = self._values.get("routing_strategy")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RoutingConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ServerlessConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrency": "maxConcurrency",
            "memory_size_in_mb": "memorySizeInMb",
            "provisioned_concurrency": "provisionedConcurrency",
        },
    )
    class ServerlessConfigProperty:
        def __init__(
            self,
            *,
            max_concurrency: jsii.Number,
            memory_size_in_mb: jsii.Number,
            provisioned_concurrency: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies the serverless configuration for an endpoint variant.

            :param max_concurrency: The maximum number of concurrent invocations your serverless endpoint can process.
            :param memory_size_in_mb: The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
            :param provisioned_concurrency: The amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or equal to ``MaxConcurrency`` . .. epigraph:: This field is not supported for serverless endpoint recommendations for Inference Recommender jobs. For more information about creating an Inference Recommender job, see `CreateInferenceRecommendationsJobs <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                serverless_config_property = sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
                
                    # the properties below are optional
                    provisioned_concurrency=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__106fe363b377b1cd93971d0e7e50c104cd6274d6f8c54c71faa17da1c784753b)
                check_type(argname="argument max_concurrency", value=max_concurrency, expected_type=type_hints["max_concurrency"])
                check_type(argname="argument memory_size_in_mb", value=memory_size_in_mb, expected_type=type_hints["memory_size_in_mb"])
                check_type(argname="argument provisioned_concurrency", value=provisioned_concurrency, expected_type=type_hints["provisioned_concurrency"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_concurrency": max_concurrency,
                "memory_size_in_mb": memory_size_in_mb,
            }
            if provisioned_concurrency is not None:
                self._values["provisioned_concurrency"] = provisioned_concurrency

        @builtins.property
        def max_concurrency(self) -> jsii.Number:
            '''The maximum number of concurrent invocations your serverless endpoint can process.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-maxconcurrency
            '''
            result = self._values.get("max_concurrency")
            assert result is not None, "Required property 'max_concurrency' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def memory_size_in_mb(self) -> jsii.Number:
            '''The memory size of your serverless endpoint.

            Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-memorysizeinmb
            '''
            result = self._values.get("memory_size_in_mb")
            assert result is not None, "Required property 'memory_size_in_mb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def provisioned_concurrency(self) -> typing.Optional[jsii.Number]:
            '''The amount of provisioned concurrency to allocate for the serverless endpoint.

            Should be less than or equal to ``MaxConcurrency`` .
            .. epigraph::

               This field is not supported for serverless endpoint recommendations for Inference Recommender jobs. For more information about creating an Inference Recommender job, see `CreateInferenceRecommendationsJobs <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-provisionedconcurrency
            '''
            result = self._values.get("provisioned_concurrency")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ServerlessConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''
            :param security_group_ids: 
            :param subnets: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnEndpointConfig.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1c6a09f61bc385349b0211430cceb3d842e9c43b8196ce0da566274f27b2a59e)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "production_variants": "productionVariants",
        "async_inference_config": "asyncInferenceConfig",
        "data_capture_config": "dataCaptureConfig",
        "enable_network_isolation": "enableNetworkIsolation",
        "endpoint_config_name": "endpointConfigName",
        "execution_role_arn": "executionRoleArn",
        "explainer_config": "explainerConfig",
        "kms_key_id": "kmsKeyId",
        "shadow_production_variants": "shadowProductionVariants",
        "tags": "tags",
        "vpc_config": "vpcConfig",
    },
)
class CfnEndpointConfigProps:
    def __init__(
        self,
        *,
        production_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]]]]],
        async_inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.AsyncInferenceConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        data_capture_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.DataCaptureConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        execution_role_arn: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ExplainerConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.VpcConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpointConfig``.

        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param enable_network_isolation: 
        :param endpoint_config_name: The name of the endpoint configuration.
        :param execution_role_arn: 
        :param explainer_config: A parameter to activate explainers.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .
        :param vpc_config: 

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_config_props = sagemaker.CfnEndpointConfigProps(
                production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    inference_ami_version="inferenceAmiVersion",
                    initial_instance_count=123,
                    initial_variant_weight=123,
                    instance_type="instanceType",
                    managed_instance_scaling=sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                        max_instance_count=123,
                        min_instance_count=123,
                        status="status"
                    ),
                    model_data_download_timeout_in_seconds=123,
                    model_name="modelName",
                    routing_config=sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                        routing_strategy="routingStrategy"
                    ),
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
            
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )],
            
                # the properties below are optional
                async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            include_inference_response_in=["includeInferenceResponseIn"],
                            success_topic="successTopic"
                        ),
                        s3_failure_path="s3FailurePath",
                        s3_output_path="s3OutputPath"
                    ),
            
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                ),
                data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
            
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                ),
                enable_network_isolation=False,
                endpoint_config_name="endpointConfigName",
                execution_role_arn="executionRoleArn",
                explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
            
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
            
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                ),
                kms_key_id="kmsKeyId",
                shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    inference_ami_version="inferenceAmiVersion",
                    initial_instance_count=123,
                    initial_variant_weight=123,
                    instance_type="instanceType",
                    managed_instance_scaling=sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty(
                        max_instance_count=123,
                        min_instance_count=123,
                        status="status"
                    ),
                    model_data_download_timeout_in_seconds=123,
                    model_name="modelName",
                    routing_config=sagemaker.CfnEndpointConfig.RoutingConfigProperty(
                        routing_strategy="routingStrategy"
                    ),
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
            
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )],
                tags=[CfnTag(
                    key="key",
                    value="value"
                )],
                vpc_config=sagemaker.CfnEndpointConfig.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78ef2b9ddede793caaf7b19d01bb59252a5dbfeb2526319f7e6ad617b37c5814)
            check_type(argname="argument production_variants", value=production_variants, expected_type=type_hints["production_variants"])
            check_type(argname="argument async_inference_config", value=async_inference_config, expected_type=type_hints["async_inference_config"])
            check_type(argname="argument data_capture_config", value=data_capture_config, expected_type=type_hints["data_capture_config"])
            check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument execution_role_arn", value=execution_role_arn, expected_type=type_hints["execution_role_arn"])
            check_type(argname="argument explainer_config", value=explainer_config, expected_type=type_hints["explainer_config"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument shadow_production_variants", value=shadow_production_variants, expected_type=type_hints["shadow_production_variants"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
            check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "production_variants": production_variants,
        }
        if async_inference_config is not None:
            self._values["async_inference_config"] = async_inference_config
        if data_capture_config is not None:
            self._values["data_capture_config"] = data_capture_config
        if enable_network_isolation is not None:
            self._values["enable_network_isolation"] = enable_network_isolation
        if endpoint_config_name is not None:
            self._values["endpoint_config_name"] = endpoint_config_name
        if execution_role_arn is not None:
            self._values["execution_role_arn"] = execution_role_arn
        if explainer_config is not None:
            self._values["explainer_config"] = explainer_config
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if shadow_production_variants is not None:
            self._values["shadow_production_variants"] = shadow_production_variants
        if tags is not None:
            self._values["tags"] = tags
        if vpc_config is not None:
            self._values["vpc_config"] = vpc_config

    @builtins.property
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
        '''
        result = self._values.get("production_variants")
        assert result is not None, "Required property 'production_variants' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]], result)

    @builtins.property
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.AsyncInferenceConfigProperty]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig
        '''
        result = self._values.get("async_inference_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.AsyncInferenceConfigProperty]], result)

    @builtins.property
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.DataCaptureConfigProperty]]:
        '''Specifies how to capture endpoint data for model monitor.

        The data capture configuration applies to all production variants hosted at the endpoint.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
        '''
        result = self._values.get("data_capture_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.DataCaptureConfigProperty]], result)

    @builtins.property
    def enable_network_isolation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-enablenetworkisolation
        '''
        result = self._values.get("enable_network_isolation")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def execution_role_arn(self) -> typing.Optional[builtins.str]:
        '''
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-executionrolearn
        '''
        result = self._values.get("execution_role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ExplainerConfigProperty]]:
        '''A parameter to activate explainers.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig
        '''
        result = self._values.get("explainer_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ExplainerConfigProperty]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.

        - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab``
        - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab``
        - Alias name: ``alias/ExampleAlias``
        - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias``

        The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_
        .. epigraph::

           Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails.

           For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ .

           For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]]:
        '''Array of ``ProductionVariant`` objects.

        There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants
        '''
        result = self._values.get("shadow_production_variants")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    @builtins.property
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.VpcConfigProperty]]:
        '''
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-vpcconfig
        '''
        result = self._values.get("vpc_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.VpcConfigProperty]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointProps",
    jsii_struct_bases=[],
    name_mapping={
        "endpoint_config_name": "endpointConfigName",
        "deployment_config": "deploymentConfig",
        "endpoint_name": "endpointName",
        "exclude_retained_variant_properties": "excludeRetainedVariantProperties",
        "retain_all_variant_properties": "retainAllVariantProperties",
        "retain_deployment_config": "retainDeploymentConfig",
        "tags": "tags",
    },
)
class CfnEndpointProps:
    def __init__(
        self,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpoint.DeploymentConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpoint.VariantPropertyProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpoint``.

        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint. The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_props = sagemaker.CfnEndpointProps(
                endpoint_config_name="endpointConfigName",
            
                # the properties below are optional
                deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    ),
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
            
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
            
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
                    rolling_update_policy=sagemaker.CfnEndpoint.RollingUpdatePolicyProperty(
                        maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123,
            
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        rollback_maximum_batch_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        )
                    )
                ),
                endpoint_name="endpointName",
                exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )],
                retain_all_variant_properties=False,
                retain_deployment_config=False,
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52a2e56834295c61b7da5a9bf2f08a781f50e70d1e6a1452ded8f8b0cc1245c1)
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument deployment_config", value=deployment_config, expected_type=type_hints["deployment_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument exclude_retained_variant_properties", value=exclude_retained_variant_properties, expected_type=type_hints["exclude_retained_variant_properties"])
            check_type(argname="argument retain_all_variant_properties", value=retain_all_variant_properties, expected_type=type_hints["retain_all_variant_properties"])
            check_type(argname="argument retain_deployment_config", value=retain_deployment_config, expected_type=type_hints["retain_deployment_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoint_config_name": endpoint_config_name,
        }
        if deployment_config is not None:
            self._values["deployment_config"] = deployment_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if exclude_retained_variant_properties is not None:
            self._values["exclude_retained_variant_properties"] = exclude_retained_variant_properties
        if retain_all_variant_properties is not None:
            self._values["retain_all_variant_properties"] = retain_all_variant_properties
        if retain_deployment_config is not None:
            self._values["retain_deployment_config"] = retain_deployment_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        assert result is not None, "Required property 'endpoint_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpoint.DeploymentConfigProperty]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
        '''
        result = self._values.get("deployment_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpoint.DeploymentConfigProperty]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.

        The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpoint.VariantPropertyProperty]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
        '''
        result = self._values.get("exclude_retained_variant_properties")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpoint.VariantPropertyProperty]]]], result)

    @builtins.property
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.

        To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
        '''
        result = self._values.get("retain_all_variant_properties")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Specifies whether to reuse the last deployment configuration.

        The default value is false (the configuration is not reused).

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig
        '''
        result = self._values.get("retain_deployment_config")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnFeatureGroup(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup",
):
    '''Create a new ``FeatureGroup`` .

    A ``FeatureGroup`` is a group of ``Features`` defined in the ``FeatureStore`` to describe a ``Record`` .

    The ``FeatureGroup`` defines the schema and features contained in the FeatureGroup. A ``FeatureGroup`` definition is composed of a list of ``Features`` , a ``RecordIdentifierFeatureName`` , an ``EventTimeFeatureName`` and configurations for its ``OnlineStore`` and ``OfflineStore`` . Check `AWS service quotas <https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html>`_ to see the ``FeatureGroup`` s quota for your AWS account.
    .. epigraph::

       You must include at least one of ``OnlineStoreConfig`` and ``OfflineStoreConfig`` to create a ``FeatureGroup`` .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
    :cloudformationResource: AWS::SageMaker::FeatureGroup
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        # offline_store_config: Any
        # online_store_config: Any
        
        cfn_feature_group = sagemaker.CfnFeatureGroup(self, "MyCfnFeatureGroup",
            event_time_feature_name="eventTimeFeatureName",
            feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                feature_name="featureName",
                feature_type="featureType"
            )],
            feature_group_name="featureGroupName",
            record_identifier_feature_name="recordIdentifierFeatureName",
        
            # the properties below are optional
            description="description",
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn="roleArn",
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            throughput_config=sagemaker.CfnFeatureGroup.ThroughputConfigProperty(
                throughput_mode="throughputMode",
        
                # the properties below are optional
                provisioned_read_capacity_units=123,
                provisioned_write_capacity_units=123
            )
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        throughput_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.ThroughputConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .
        :param throughput_config: Used to set feature group throughput configuration. There are two modes: ``ON_DEMAND`` and ``PROVISIONED`` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled. Note: ``PROVISIONED`` throughput mode is supported only for feature groups that are offline-only, or use the ```Standard`` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType>`_ tier online store.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4102c01580236aeaa8183dc09f0ab2d908ee3b4650df43ce2419ef038f864258)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnFeatureGroupProps(
            event_time_feature_name=event_time_feature_name,
            feature_definitions=feature_definitions,
            feature_group_name=feature_group_name,
            record_identifier_feature_name=record_identifier_feature_name,
            description=description,
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn=role_arn,
            tags=tags,
            throughput_config=throughput_config,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cd6259820b736e87a6da7d27e2e1e1a14b614640e31da0fcb54668a45db785f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4377922dbd7c3d2d8d521bce16c0e6ef23d2e76a3cd1823cfe6bb698934e9794)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time a ``FeatureGroup`` was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrFeatureGroupStatus")
    def attr_feature_group_status(self) -> builtins.str:
        '''A ``FeatureGroup`` status.

        :cloudformationAttribute: FeatureGroupStatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrFeatureGroupStatus"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="eventTimeFeatureName")
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .'''
        return typing.cast(builtins.str, jsii.get(self, "eventTimeFeatureName"))

    @event_time_feature_name.setter
    def event_time_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8adfc53ff0bc63839afe55973c1f5c8873bebb52fb98328b9839255298b674b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "eventTimeFeatureName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="featureDefinitions")
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]]:
        '''A list of ``Feature`` s.

        Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]], jsii.get(self, "featureDefinitions"))

    @feature_definitions.setter
    def feature_definitions(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__554ed28625ccedc71ce244f01f302b22d68e2b9ad204918f91e7f3fd85527e61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureDefinitions", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="featureGroupName")
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .'''
        return typing.cast(builtins.str, jsii.get(self, "featureGroupName"))

    @feature_group_name.setter
    def feature_group_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6f4169fe264f570e3e6859737b587e566b9716d614cf3a24902f6b04cde8b93)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureGroupName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .'''
        return typing.cast(builtins.str, jsii.get(self, "recordIdentifierFeatureName"))

    @record_identifier_feature_name.setter
    def record_identifier_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b78873bd7aeb067f399e0d34bbfcead148ee8cd93f599510cd64c6e738908832)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "recordIdentifierFeatureName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b3eb81281cd3d68bb6a0b5a3ea79863153df71f1420743d27c3d773a2fd6c98)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="offlineStoreConfig")
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .'''
        return typing.cast(typing.Any, jsii.get(self, "offlineStoreConfig"))

    @offline_store_config.setter
    def offline_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35a3cd1a7f2eeb38ecbdecb8d787b667dd2fb89f595b3887438fb9c49ebe2125)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "offlineStoreConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="onlineStoreConfig")
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .'''
        return typing.cast(typing.Any, jsii.get(self, "onlineStoreConfig"))

    @online_store_config.setter
    def online_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36874ea58589f290874ec1f6e4483a6eaf3b42f76d17dd0b2c0aa81106ea1710)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "onlineStoreConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dd4c4dc86f0dd4d52ceac67d70b2ea2229a255079338500d2261a011ff1b32ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags used to define a ``FeatureGroup`` .'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8168817a8eaecafae45794cccbd827fb5a8ecca77d875940f9f6a69e039d7b6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="throughputConfig")
    def throughput_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.ThroughputConfigProperty"]]:
        '''Used to set feature group throughput configuration.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.ThroughputConfigProperty"]], jsii.get(self, "throughputConfig"))

    @throughput_config.setter
    def throughput_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.ThroughputConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af00a14f14915d9468127ac75d20463075f7aef1c7623208e6c755ca9f7feba2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "throughputConfig", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "catalog": "catalog",
            "database": "database",
            "table_name": "tableName",
        },
    )
    class DataCatalogConfigProperty:
        def __init__(
            self,
            *,
            catalog: builtins.str,
            database: builtins.str,
            table_name: builtins.str,
        ) -> None:
            '''The meta data of the Glue table which serves as data catalog for the ``OfflineStore`` .

            :param catalog: The name of the Glue table catalog.
            :param database: The name of the Glue table database.
            :param table_name: The name of the Glue table.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_catalog_config_property = sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                    catalog="catalog",
                    database="database",
                    table_name="tableName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4caa5f76e9359d50b237d02f2288070020184465e320800c861a60749c9be45b)
                check_type(argname="argument catalog", value=catalog, expected_type=type_hints["catalog"])
                check_type(argname="argument database", value=database, expected_type=type_hints["database"])
                check_type(argname="argument table_name", value=table_name, expected_type=type_hints["table_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "catalog": catalog,
                "database": database,
                "table_name": table_name,
            }

        @builtins.property
        def catalog(self) -> builtins.str:
            '''The name of the Glue table catalog.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-catalog
            '''
            result = self._values.get("catalog")
            assert result is not None, "Required property 'catalog' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def database(self) -> builtins.str:
            '''The name of the Glue table database.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-database
            '''
            result = self._values.get("database")
            assert result is not None, "Required property 'database' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def table_name(self) -> builtins.str:
            '''The name of the Glue table.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-tablename
            '''
            result = self._values.get("table_name")
            assert result is not None, "Required property 'table_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCatalogConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={"feature_name": "featureName", "feature_type": "featureType"},
    )
    class FeatureDefinitionProperty:
        def __init__(
            self,
            *,
            feature_name: builtins.str,
            feature_type: builtins.str,
        ) -> None:
            '''A list of features.

            You must include ``FeatureName`` and ``FeatureType`` . Valid feature ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

            :param feature_name: The name of a feature. The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . The name: - Must start with an alphanumeric character. - Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
            :param feature_type: The value type of a feature. Valid values are Integral, Fractional, or String.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                feature_definition_property = sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__04848822e3ad8782bf48bda17c952f5ed10b1558aac29dcca56aa3c21c34f2a1)
                check_type(argname="argument feature_name", value=feature_name, expected_type=type_hints["feature_name"])
                check_type(argname="argument feature_type", value=feature_type, expected_type=type_hints["feature_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "feature_name": feature_name,
                "feature_type": feature_type,
            }

        @builtins.property
        def feature_name(self) -> builtins.str:
            '''The name of a feature.

            The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

            The name:

            - Must start with an alphanumeric character.
            - Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename
            '''
            result = self._values.get("feature_name")
            assert result is not None, "Required property 'feature_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def feature_type(self) -> builtins.str:
            '''The value type of a feature.

            Valid values are Integral, Fractional, or String.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype
            '''
            result = self._values.get("feature_type")
            assert result is not None, "Required property 'feature_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FeatureDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_storage_config": "s3StorageConfig",
            "data_catalog_config": "dataCatalogConfig",
            "disable_glue_table_creation": "disableGlueTableCreation",
            "table_format": "tableFormat",
        },
    )
    class OfflineStoreConfigProperty:
        def __init__(
            self,
            *,
            s3_storage_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.S3StorageConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            data_catalog_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.DataCatalogConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            disable_glue_table_creation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            table_format: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of an ``OfflineStore`` .

            Provide an ``OfflineStoreConfig`` in a request to ``CreateFeatureGroup`` to create an ``OfflineStore`` .

            To encrypt an ``OfflineStore`` using at rest data encryption, specify AWS Key Management Service (KMS) key ID, or ``KMSKeyId`` , in ``S3StorageConfig`` .

            :param s3_storage_config: The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .
            :param data_catalog_config: The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.
            :param disable_glue_table_creation: Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` . If set to ``False`` , Feature Store will name the ``OfflineStore`` Glue table following `Athena's naming recommendations <https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html>`_ . The default value is ``False`` .
            :param table_format: Format for the offline store table. Supported formats are Glue (Default) and `Apache Iceberg <https://docs.aws.amazon.com/https://iceberg.apache.org/>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                offline_store_config_property = sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty(
                    s3_storage_config=sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        kms_key_id="kmsKeyId"
                    ),
                
                    # the properties below are optional
                    data_catalog_config=sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                        catalog="catalog",
                        database="database",
                        table_name="tableName"
                    ),
                    disable_glue_table_creation=False,
                    table_format="tableFormat"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2f29e7edde4b24306bda02357db072f0b29e6110817a4c588bd3c02734019d42)
                check_type(argname="argument s3_storage_config", value=s3_storage_config, expected_type=type_hints["s3_storage_config"])
                check_type(argname="argument data_catalog_config", value=data_catalog_config, expected_type=type_hints["data_catalog_config"])
                check_type(argname="argument disable_glue_table_creation", value=disable_glue_table_creation, expected_type=type_hints["disable_glue_table_creation"])
                check_type(argname="argument table_format", value=table_format, expected_type=type_hints["table_format"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_storage_config": s3_storage_config,
            }
            if data_catalog_config is not None:
                self._values["data_catalog_config"] = data_catalog_config
            if disable_glue_table_creation is not None:
                self._values["disable_glue_table_creation"] = disable_glue_table_creation
            if table_format is not None:
                self._values["table_format"] = table_format

        @builtins.property
        def s3_storage_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.S3StorageConfigProperty"]:
            '''The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-s3storageconfig
            '''
            result = self._values.get("s3_storage_config")
            assert result is not None, "Required property 's3_storage_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.S3StorageConfigProperty"], result)

        @builtins.property
        def data_catalog_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.DataCatalogConfigProperty"]]:
            '''The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-datacatalogconfig
            '''
            result = self._values.get("data_catalog_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.DataCatalogConfigProperty"]], result)

        @builtins.property
        def disable_glue_table_creation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` .

            If set to ``False`` , Feature Store will name the ``OfflineStore`` Glue table following `Athena's naming recommendations <https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html>`_ .

            The default value is ``False`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-disablegluetablecreation
            '''
            result = self._values.get("disable_glue_table_creation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def table_format(self) -> typing.Optional[builtins.str]:
            '''Format for the offline store table.

            Supported formats are Glue (Default) and `Apache Iceberg <https://docs.aws.amazon.com/https://iceberg.apache.org/>`_ .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-tableformat
            '''
            result = self._values.get("table_format")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OfflineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_online_store": "enableOnlineStore",
            "security_config": "securityConfig",
            "storage_type": "storageType",
            "ttl_duration": "ttlDuration",
        },
    )
    class OnlineStoreConfigProperty:
        def __init__(
            self,
            *,
            enable_online_store: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            security_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.OnlineStoreSecurityConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            storage_type: typing.Optional[builtins.str] = None,
            ttl_duration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.TtlDurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Use this to specify the AWS Key Management Service (KMS) Key ID, or ``KMSKeyId`` , for at rest data encryption.

            You can turn ``OnlineStore`` on or off by specifying the ``EnableOnlineStore`` flag at General Assembly.

            The default value is ``False`` .

            :param enable_online_store: Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag. Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag. The default value is ``False`` .
            :param security_config: Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .
            :param storage_type: Option for different tiers of low latency storage for real-time data retrieval. - ``Standard`` : A managed low latency data store for feature groups. - ``InMemory`` : A managed data store for feature groups that supports very low latency retrieval.
            :param ttl_duration: Time to live duration, where the record is hard deleted after the expiration time is reached; ``ExpiresAt`` = ``EventTime`` + ``TtlDuration`` . For information on HardDelete, see the `DeleteRecord <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html>`_ API in the Amazon SageMaker API Reference guide.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                online_store_config_property = sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty(
                    enable_online_store=False,
                    security_config=sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                        kms_key_id="kmsKeyId"
                    ),
                    storage_type="storageType",
                    ttl_duration=sagemaker.CfnFeatureGroup.TtlDurationProperty(
                        unit="unit",
                        value=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4068ec17c64be821371cb37a174b97e325a38220882aa92f5b086d22af6c9c9b)
                check_type(argname="argument enable_online_store", value=enable_online_store, expected_type=type_hints["enable_online_store"])
                check_type(argname="argument security_config", value=security_config, expected_type=type_hints["security_config"])
                check_type(argname="argument storage_type", value=storage_type, expected_type=type_hints["storage_type"])
                check_type(argname="argument ttl_duration", value=ttl_duration, expected_type=type_hints["ttl_duration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_online_store is not None:
                self._values["enable_online_store"] = enable_online_store
            if security_config is not None:
                self._values["security_config"] = security_config
            if storage_type is not None:
                self._values["storage_type"] = storage_type
            if ttl_duration is not None:
                self._values["ttl_duration"] = ttl_duration

        @builtins.property
        def enable_online_store(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag.

            Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag.

            The default value is ``False`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-enableonlinestore
            '''
            result = self._values.get("enable_online_store")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def security_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.OnlineStoreSecurityConfigProperty"]]:
            '''Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-securityconfig
            '''
            result = self._values.get("security_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.OnlineStoreSecurityConfigProperty"]], result)

        @builtins.property
        def storage_type(self) -> typing.Optional[builtins.str]:
            '''Option for different tiers of low latency storage for real-time data retrieval.

            - ``Standard`` : A managed low latency data store for feature groups.
            - ``InMemory`` : A managed data store for feature groups that supports very low latency retrieval.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-storagetype
            '''
            result = self._values.get("storage_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ttl_duration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.TtlDurationProperty"]]:
            '''Time to live duration, where the record is hard deleted after the expiration time is reached;

            ``ExpiresAt`` = ``EventTime`` + ``TtlDuration`` . For information on HardDelete, see the `DeleteRecord <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html>`_ API in the Amazon SageMaker API Reference guide.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-ttlduration
            '''
            result = self._values.get("ttl_duration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.TtlDurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"kms_key_id": "kmsKeyId"},
    )
    class OnlineStoreSecurityConfigProperty:
        def __init__(self, *, kms_key_id: typing.Optional[builtins.str] = None) -> None:
            '''The security configuration for ``OnlineStore`` .

            :param kms_key_id: The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption. The caller (either user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` : - ``"kms:Encrypt"`` - ``"kms:Decrypt"`` - ``"kms:DescribeKey"`` - ``"kms:CreateGrant"`` - ``"kms:RetireGrant"`` - ``"kms:ReEncryptFrom"`` - ``"kms:ReEncryptTo"`` - ``"kms:GenerateDataKey"`` - ``"kms:ListAliases"`` - ``"kms:ListGrants"`` - ``"kms:RevokeGrant"`` The caller (either user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` : - ``"kms:Decrypt"``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                online_store_security_config_property = sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9ba97e020f46b5d443fb0f7a2b65107dfb083e44bf5c9573eb5b040837128996)
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.

            The caller (either user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` :

            - ``"kms:Encrypt"``
            - ``"kms:Decrypt"``
            - ``"kms:DescribeKey"``
            - ``"kms:CreateGrant"``
            - ``"kms:RetireGrant"``
            - ``"kms:ReEncryptFrom"``
            - ``"kms:ReEncryptTo"``
            - ``"kms:GenerateDataKey"``
            - ``"kms:ListAliases"``
            - ``"kms:ListGrants"``
            - ``"kms:RevokeGrant"``

            The caller (either user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` :

            - ``"kms:Decrypt"``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html#cfn-sagemaker-featuregroup-onlinestoresecurityconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreSecurityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri", "kms_key_id": "kmsKeyId"},
    )
    class S3StorageConfigProperty:
        def __init__(
            self,
            *,
            s3_uri: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Simple Storage (Amazon S3) location and security configuration for ``OfflineStore`` .

            :param s3_uri: The S3 URI, or location in Amazon S3, of ``OfflineStore`` . S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .
            :param kms_key_id: The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the ``OfflineStore`` S3 location. The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` : - ``"kms:GenerateDataKey"``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                s3_storage_config_property = sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4deea26cb2dc59d1dedd4813cf07b36e4bf8da5eff8446a0b746de73938917fc)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_uri": s3_uri,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''The S3 URI, or location in Amazon S3, of ``OfflineStore`` .

            S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the ``OfflineStore`` S3 location.

            The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` :

            - ``"kms:GenerateDataKey"``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3StorageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.ThroughputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "throughput_mode": "throughputMode",
            "provisioned_read_capacity_units": "provisionedReadCapacityUnits",
            "provisioned_write_capacity_units": "provisionedWriteCapacityUnits",
        },
    )
    class ThroughputConfigProperty:
        def __init__(
            self,
            *,
            throughput_mode: builtins.str,
            provisioned_read_capacity_units: typing.Optional[jsii.Number] = None,
            provisioned_write_capacity_units: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Used to set feature group throughput configuration.

            There are two modes: ``ON_DEMAND`` and ``PROVISIONED`` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.

            Note: ``PROVISIONED`` throughput mode is supported only for feature groups that are offline-only, or use the ```Standard`` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType>`_ tier online store.

            :param throughput_mode: The mode used for your feature group throughput: ``ON_DEMAND`` or ``PROVISIONED`` .
            :param provisioned_read_capacity_units: For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling. This field is not applicable for on-demand feature groups.
            :param provisioned_write_capacity_units: For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling. This field is not applicable for on-demand feature groups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                throughput_config_property = sagemaker.CfnFeatureGroup.ThroughputConfigProperty(
                    throughput_mode="throughputMode",
                
                    # the properties below are optional
                    provisioned_read_capacity_units=123,
                    provisioned_write_capacity_units=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6d458f28019d4b4a6f2a06acd0db6858b60dffb2d229940dd18dcb6dd4e010a3)
                check_type(argname="argument throughput_mode", value=throughput_mode, expected_type=type_hints["throughput_mode"])
                check_type(argname="argument provisioned_read_capacity_units", value=provisioned_read_capacity_units, expected_type=type_hints["provisioned_read_capacity_units"])
                check_type(argname="argument provisioned_write_capacity_units", value=provisioned_write_capacity_units, expected_type=type_hints["provisioned_write_capacity_units"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "throughput_mode": throughput_mode,
            }
            if provisioned_read_capacity_units is not None:
                self._values["provisioned_read_capacity_units"] = provisioned_read_capacity_units
            if provisioned_write_capacity_units is not None:
                self._values["provisioned_write_capacity_units"] = provisioned_write_capacity_units

        @builtins.property
        def throughput_mode(self) -> builtins.str:
            '''The mode used for your feature group throughput: ``ON_DEMAND`` or ``PROVISIONED`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-throughputmode
            '''
            result = self._values.get("throughput_mode")
            assert result is not None, "Required property 'throughput_mode' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def provisioned_read_capacity_units(self) -> typing.Optional[jsii.Number]:
            '''For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.

            This field is not applicable for on-demand feature groups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedreadcapacityunits
            '''
            result = self._values.get("provisioned_read_capacity_units")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def provisioned_write_capacity_units(self) -> typing.Optional[jsii.Number]:
            '''For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.

            This field is not applicable for on-demand feature groups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedwritecapacityunits
            '''
            result = self._values.get("provisioned_write_capacity_units")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ThroughputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.TtlDurationProperty",
        jsii_struct_bases=[],
        name_mapping={"unit": "unit", "value": "value"},
    )
    class TtlDurationProperty:
        def __init__(
            self,
            *,
            unit: typing.Optional[builtins.str] = None,
            value: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Time to live duration, where the record is hard deleted after the expiration time is reached;

            ``ExpiresAt`` = ``EventTime`` + ``TtlDuration`` . For information on HardDelete, see the `DeleteRecord <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html>`_ API in the Amazon SageMaker API Reference guide.

            :param unit: ``TtlDuration`` time unit.
            :param value: ``TtlDuration`` time value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                ttl_duration_property = sagemaker.CfnFeatureGroup.TtlDurationProperty(
                    unit="unit",
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fa489e49dd38138cfa086540aa4f5147cea22e4f7f0e4313176c224c7663ff32)
                check_type(argname="argument unit", value=unit, expected_type=type_hints["unit"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if unit is not None:
                self._values["unit"] = unit
            if value is not None:
                self._values["value"] = value

        @builtins.property
        def unit(self) -> typing.Optional[builtins.str]:
            '''``TtlDuration`` time unit.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-unit
            '''
            result = self._values.get("unit")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def value(self) -> typing.Optional[jsii.Number]:
            '''``TtlDuration`` time value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-value
            '''
            result = self._values.get("value")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TtlDurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "event_time_feature_name": "eventTimeFeatureName",
        "feature_definitions": "featureDefinitions",
        "feature_group_name": "featureGroupName",
        "record_identifier_feature_name": "recordIdentifierFeatureName",
        "description": "description",
        "offline_store_config": "offlineStoreConfig",
        "online_store_config": "onlineStoreConfig",
        "role_arn": "roleArn",
        "tags": "tags",
        "throughput_config": "throughputConfig",
    },
)
class CfnFeatureGroupProps:
    def __init__(
        self,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnFeatureGroup.FeatureDefinitionProperty, typing.Dict[builtins.str, typing.Any]]]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        throughput_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnFeatureGroup.ThroughputConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnFeatureGroup``.

        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .
        :param throughput_config: Used to set feature group throughput configuration. There are two modes: ``ON_DEMAND`` and ``PROVISIONED`` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled. Note: ``PROVISIONED`` throughput mode is supported only for feature groups that are offline-only, or use the ```Standard`` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType>`_ tier online store.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            # offline_store_config: Any
            # online_store_config: Any
            
            cfn_feature_group_props = sagemaker.CfnFeatureGroupProps(
                event_time_feature_name="eventTimeFeatureName",
                feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )],
                feature_group_name="featureGroupName",
                record_identifier_feature_name="recordIdentifierFeatureName",
            
                # the properties below are optional
                description="description",
                offline_store_config=offline_store_config,
                online_store_config=online_store_config,
                role_arn="roleArn",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )],
                throughput_config=sagemaker.CfnFeatureGroup.ThroughputConfigProperty(
                    throughput_mode="throughputMode",
            
                    # the properties below are optional
                    provisioned_read_capacity_units=123,
                    provisioned_write_capacity_units=123
                )
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb1e9da53f754dd8978f06cdc95c9101b0ef89f3b1a689ab0a1e92eacd0a0951)
            check_type(argname="argument event_time_feature_name", value=event_time_feature_name, expected_type=type_hints["event_time_feature_name"])
            check_type(argname="argument feature_definitions", value=feature_definitions, expected_type=type_hints["feature_definitions"])
            check_type(argname="argument feature_group_name", value=feature_group_name, expected_type=type_hints["feature_group_name"])
            check_type(argname="argument record_identifier_feature_name", value=record_identifier_feature_name, expected_type=type_hints["record_identifier_feature_name"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument offline_store_config", value=offline_store_config, expected_type=type_hints["offline_store_config"])
            check_type(argname="argument online_store_config", value=online_store_config, expected_type=type_hints["online_store_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
            check_type(argname="argument throughput_config", value=throughput_config, expected_type=type_hints["throughput_config"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "event_time_feature_name": event_time_feature_name,
            "feature_definitions": feature_definitions,
            "feature_group_name": feature_group_name,
            "record_identifier_feature_name": record_identifier_feature_name,
        }
        if description is not None:
            self._values["description"] = description
        if offline_store_config is not None:
            self._values["offline_store_config"] = offline_store_config
        if online_store_config is not None:
            self._values["online_store_config"] = online_store_config
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if tags is not None:
            self._values["tags"] = tags
        if throughput_config is not None:
            self._values["throughput_config"] = throughput_config

    @builtins.property
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .

        A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
        '''
        result = self._values.get("event_time_feature_name")
        assert result is not None, "Required property 'event_time_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.FeatureDefinitionProperty]]]:
        '''A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .

        Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

        ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

        You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
        '''
        result = self._values.get("feature_definitions")
        assert result is not None, "Required property 'feature_definitions' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.FeatureDefinitionProperty]]], result)

    @builtins.property
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
        '''
        result = self._values.get("feature_group_name")
        assert result is not None, "Required property 'feature_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
        '''
        result = self._values.get("record_identifier_feature_name")
        assert result is not None, "Required property 'record_identifier_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
        '''
        result = self._values.get("offline_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
        '''
        result = self._values.get("online_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
        '''
        result = self._values.get("role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags used to define a ``FeatureGroup`` .

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    @builtins.property
    def throughput_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.ThroughputConfigProperty]]:
        '''Used to set feature group throughput configuration.

        There are two modes: ``ON_DEMAND`` and ``PROVISIONED`` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.

        Note: ``PROVISIONED`` throughput mode is supported only for feature groups that are offline-only, or use the ```Standard`` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType>`_ tier online store.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig
        '''
        result = self._values.get("throughput_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.ThroughputConfigProperty]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnFeatureGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnImage(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImage",
):
    '''Creates a custom SageMaker AI image.

    A SageMaker AI image is a set of image versions. Each image version represents a container image stored in Amazon ECR. For more information, see `Bring your own SageMaker AI image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
    :cloudformationResource: AWS::SageMaker::Image
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_image = sagemaker.CfnImage(self, "MyCfnImage",
            image_name="imageName",
            image_role_arn="imageRoleArn",
        
            # the properties below are optional
            image_description="imageDescription",
            image_display_name="imageDisplayName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image.
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dde982bdab4dea21946725303bd84c1eb61267733b6351eb23c00f7d036f6966)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageProps(
            image_name=image_name,
            image_role_arn=image_role_arn,
            image_description=image_description,
            image_display_name=image_display_name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3683228322bbbd09cb4aac0a4469f1685a49afb4d71c553abbab272eaef100dc)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4230003faeb71eb706948f19ec046a12d72b36d81d5e22c11bcc3b1ebe02c2c0)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image/[a-z0-9]([-.]?[a-z0-9])*$``

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the Image.

        Must be unique by region in your account.
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c83dda1eec4dea7e586e14528740a9a908c8dc9cfdfaa25322bcb6254256fe95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="imageRoleArn")
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.'''
        return typing.cast(builtins.str, jsii.get(self, "imageRoleArn"))

    @image_role_arn.setter
    def image_role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4cb3cf1a068192a3c85d41bfd4e7865613f5eaad72e81e906ea09806af1a6a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageRoleArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="imageDescription")
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDescription"))

    @image_description.setter
    def image_description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d98fb90f3bdd23e0a7e2f8f7f3b5da1a34a2efdfb7989565b70a598777d1d2e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDescription", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="imageDisplayName")
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDisplayName"))

    @image_display_name.setter
    def image_display_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9507742917d9e396f824e9318497084f8ae68b4ebb9daa0f6845e96629a78a4d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDisplayName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc08ec4a8b34363d9c0cf6afe34c04e17ea65e896db8f146c6a6a1ba5a120bb1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageProps",
    jsii_struct_bases=[],
    name_mapping={
        "image_name": "imageName",
        "image_role_arn": "imageRoleArn",
        "image_description": "imageDescription",
        "image_display_name": "imageDisplayName",
        "tags": "tags",
    },
)
class CfnImageProps:
    def __init__(
        self,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnImage``.

        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image.
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_image_props = sagemaker.CfnImageProps(
                image_name="imageName",
                image_role_arn="imageRoleArn",
            
                # the properties below are optional
                image_description="imageDescription",
                image_display_name="imageDisplayName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc32c041f4bbebc30466bd7f70f1571b2e2a1def5e8e2166caa2d830a35fe8e8)
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
            check_type(argname="argument image_role_arn", value=image_role_arn, expected_type=type_hints["image_role_arn"])
            check_type(argname="argument image_description", value=image_description, expected_type=type_hints["image_description"])
            check_type(argname="argument image_display_name", value=image_display_name, expected_type=type_hints["image_display_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image_name": image_name,
            "image_role_arn": image_role_arn,
        }
        if image_description is not None:
            self._values["image_description"] = image_description
        if image_display_name is not None:
            self._values["image_display_name"] = image_display_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
        '''
        result = self._values.get("image_role_arn")
        assert result is not None, "Required property 'image_role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
        '''
        result = self._values.get("image_description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : ``^\\S(.*\\S)?$``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
        '''
        result = self._values.get("image_display_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnImageVersion(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageVersion",
):
    '''Creates a version of the SageMaker image specified by ``ImageName`` .

    The version represents the Amazon Container Registry (ECR) container image specified by ``BaseImage`` .
    .. epigraph::

       You can use the ``DependsOn`` attribute to specify that the creation of a specific resource follows another. You can use it for the following use cases. For more information, see ```DependsOn`` attribute <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html>`_ .

       1. ``DependsOn`` can be used to establish a parent/child relationship between ``ImageVersion`` and ``Image`` where the ``ImageVersion`` ``DependsOn`` the ``Image`` .
       2. ``DependsOn`` can be used to establish order among ``ImageVersion`` s within the same ``Image`` namespace. For example, if ImageVersionB ``DependsOn`` ImageVersionA and both share the same parent ``Image`` , then ImageVersionA is version N and ImageVersionB is N+1.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
    :cloudformationResource: AWS::SageMaker::ImageVersion
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_image_version = sagemaker.CfnImageVersion(self, "MyCfnImageVersion",
            base_image="baseImage",
            image_name="imageName",
        
            # the properties below are optional
            alias="alias",
            aliases=["aliases"],
            horovod=False,
            job_type="jobType",
            ml_framework="mlFramework",
            processor="processor",
            programming_lang="programmingLang",
            release_notes="releaseNotes",
            vendor_guidance="vendorGuidance"
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        base_image: builtins.str,
        image_name: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        aliases: typing.Optional[typing.Sequence[builtins.str]] = None,
        horovod: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        job_type: typing.Optional[builtins.str] = None,
        ml_framework: typing.Optional[builtins.str] = None,
        processor: typing.Optional[builtins.str] = None,
        programming_lang: typing.Optional[builtins.str] = None,
        release_notes: typing.Optional[builtins.str] = None,
        vendor_guidance: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param base_image: The container image that the SageMaker image version is based on.
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param alias: The alias of the image version.
        :param aliases: List of aliases for the image version.
        :param horovod: Indicates Horovod compatibility.
        :param job_type: Indicates SageMaker job type compatibility.
        :param ml_framework: The machine learning framework vended in the image version.
        :param processor: Indicates CPU or GPU compatibility.
        :param programming_lang: The supported programming language and its version.
        :param release_notes: The maintainer description of the image version.
        :param vendor_guidance: The availability of the image version specified by the maintainer.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ad8c361f2876657ea1cf0f0f9f7356de06575f95ad80d7a587da19094ecd39f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageVersionProps(
            base_image=base_image,
            image_name=image_name,
            alias=alias,
            aliases=aliases,
            horovod=horovod,
            job_type=job_type,
            ml_framework=ml_framework,
            processor=processor,
            programming_lang=programming_lang,
            release_notes=release_notes,
            vendor_guidance=vendor_guidance,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5617eaff0fc7e0099928623a36e2b9f1458a37ad9fe1fa24bd54f054ebffae4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c4bc42175535dc7e1f18100775e38634217828944c7afb9a921d5d4ded34609)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrContainerImage")
    def attr_container_image(self) -> builtins.str:
        '''The URI of the container image version referenced by ImageVersion.

        :cloudformationAttribute: ContainerImage
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrContainerImage"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the parent Image.

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="attrImageVersionArn")
    def attr_image_version_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image version.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image-version/[a-z0-9]([-.]?[a-z0-9])* /[0-9]+$``

        :cloudformationAttribute: ImageVersionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageVersionArn"))

    @builtins.property
    @jsii.member(jsii_name="attrVersion")
    def attr_version(self) -> jsii.Number:
        '''The version of the image.

        :cloudformationAttribute: Version
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrVersion"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="baseImage")
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.'''
        return typing.cast(builtins.str, jsii.get(self, "baseImage"))

    @base_image.setter
    def base_image(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cd7f0125c670f13843a82d4765f1707e53ed79633a107bc8f478ee89f7c4447)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "baseImage", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the parent image.'''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32397b68bd7477c88dd5aca2fab6262902fec8c5be04520516af969354dc3411)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="alias")
    def alias(self) -> typing.Optional[builtins.str]:
        '''The alias of the image version.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alias"))

    @alias.setter
    def alias(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__130335aafd8604a37bb0c6378189d323e11f1c9a8d9de59d6826369f2086fb54)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alias", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="aliases")
    def aliases(self) -> typing.Optional[typing.List[builtins.str]]:
        '''List of aliases for the image version.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "aliases"))

    @aliases.setter
    def aliases(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b53841ef8f974620a34f1089ddd34dab945dc1cfc6214ff5c96805c28fee339)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "aliases", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="horovod")
    def horovod(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Indicates Horovod compatibility.'''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "horovod"))

    @horovod.setter
    def horovod(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63b740d348bf3bc8f512963928cc212f67fef7490d5bc60dbf44641d8a8bba80)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "horovod", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="jobType")
    def job_type(self) -> typing.Optional[builtins.str]:
        '''Indicates SageMaker job type compatibility.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobType"))

    @job_type.setter
    def job_type(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4325909e50b32e3c971c803ff8d527558eaf27440a7e1eecd39347ec829edf7e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobType", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="mlFramework")
    def ml_framework(self) -> typing.Optional[builtins.str]:
        '''The machine learning framework vended in the image version.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "mlFramework"))

    @ml_framework.setter
    def ml_framework(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__81d68f0650f7bba3ce23357345acab3a7f8c2473cb1f04dd8ec3718f4ad3f061)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "mlFramework", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="processor")
    def processor(self) -> typing.Optional[builtins.str]:
        '''Indicates CPU or GPU compatibility.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "processor"))

    @processor.setter
    def processor(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51796dc1c41721e2403c8fcaf57981fc62e4d27583b46f696048e71c11c42217)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "processor", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="programmingLang")
    def programming_lang(self) -> typing.Optional[builtins.str]:
        '''The supported programming language and its version.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "programmingLang"))

    @programming_lang.setter
    def programming_lang(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__558e00760dafdf270030f6c74f7af644a9073b029f802c09baf4ca45a0f96579)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "programmingLang", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="releaseNotes")
    def release_notes(self) -> typing.Optional[builtins.str]:
        '''The maintainer description of the image version.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "releaseNotes"))

    @release_notes.setter
    def release_notes(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fdda2091c290a3c94f3594803b8ff7d3846931cb6976f4fbe76584d69581fac1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "releaseNotes", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="vendorGuidance")
    def vendor_guidance(self) -> typing.Optional[builtins.str]:
        '''The availability of the image version specified by the maintainer.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vendorGuidance"))

    @vendor_guidance.setter
    def vendor_guidance(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5382fea0d28fb1b1a6c04307334e93f65dd93058c962443126e5776048b93ac6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vendorGuidance", value) # pyright: ignore[reportArgumentType]


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageVersionProps",
    jsii_struct_bases=[],
    name_mapping={
        "base_image": "baseImage",
        "image_name": "imageName",
        "alias": "alias",
        "aliases": "aliases",
        "horovod": "horovod",
        "job_type": "jobType",
        "ml_framework": "mlFramework",
        "processor": "processor",
        "programming_lang": "programmingLang",
        "release_notes": "releaseNotes",
        "vendor_guidance": "vendorGuidance",
    },
)
class CfnImageVersionProps:
    def __init__(
        self,
        *,
        base_image: builtins.str,
        image_name: builtins.str,
        alias: typing.Optional[builtins.str] = None,
        aliases: typing.Optional[typing.Sequence[builtins.str]] = None,
        horovod: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        job_type: typing.Optional[builtins.str] = None,
        ml_framework: typing.Optional[builtins.str] = None,
        processor: typing.Optional[builtins.str] = None,
        programming_lang: typing.Optional[builtins.str] = None,
        release_notes: typing.Optional[builtins.str] = None,
        vendor_guidance: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for defining a ``CfnImageVersion``.

        :param base_image: The container image that the SageMaker image version is based on.
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param alias: The alias of the image version.
        :param aliases: List of aliases for the image version.
        :param horovod: Indicates Horovod compatibility.
        :param job_type: Indicates SageMaker job type compatibility.
        :param ml_framework: The machine learning framework vended in the image version.
        :param processor: Indicates CPU or GPU compatibility.
        :param programming_lang: The supported programming language and its version.
        :param release_notes: The maintainer description of the image version.
        :param vendor_guidance: The availability of the image version specified by the maintainer.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_image_version_props = sagemaker.CfnImageVersionProps(
                base_image="baseImage",
                image_name="imageName",
            
                # the properties below are optional
                alias="alias",
                aliases=["aliases"],
                horovod=False,
                job_type="jobType",
                ml_framework="mlFramework",
                processor="processor",
                programming_lang="programmingLang",
                release_notes="releaseNotes",
                vendor_guidance="vendorGuidance"
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb1cf2f49fa3a5bb0e6e9fdd2097a7a9401edb65fabfda045235c1b04b02fbf1)
            check_type(argname="argument base_image", value=base_image, expected_type=type_hints["base_image"])
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
            check_type(argname="argument alias", value=alias, expected_type=type_hints["alias"])
            check_type(argname="argument aliases", value=aliases, expected_type=type_hints["aliases"])
            check_type(argname="argument horovod", value=horovod, expected_type=type_hints["horovod"])
            check_type(argname="argument job_type", value=job_type, expected_type=type_hints["job_type"])
            check_type(argname="argument ml_framework", value=ml_framework, expected_type=type_hints["ml_framework"])
            check_type(argname="argument processor", value=processor, expected_type=type_hints["processor"])
            check_type(argname="argument programming_lang", value=programming_lang, expected_type=type_hints["programming_lang"])
            check_type(argname="argument release_notes", value=release_notes, expected_type=type_hints["release_notes"])
            check_type(argname="argument vendor_guidance", value=vendor_guidance, expected_type=type_hints["vendor_guidance"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "base_image": base_image,
            "image_name": image_name,
        }
        if alias is not None:
            self._values["alias"] = alias
        if aliases is not None:
            self._values["aliases"] = aliases
        if horovod is not None:
            self._values["horovod"] = horovod
        if job_type is not None:
            self._values["job_type"] = job_type
        if ml_framework is not None:
            self._values["ml_framework"] = ml_framework
        if processor is not None:
            self._values["processor"] = processor
        if programming_lang is not None:
            self._values["programming_lang"] = programming_lang
        if release_notes is not None:
            self._values["release_notes"] = release_notes
        if vendor_guidance is not None:
            self._values["vendor_guidance"] = vendor_guidance

    @builtins.property
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
        '''
        result = self._values.get("base_image")
        assert result is not None, "Required property 'base_image' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the parent image.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alias(self) -> typing.Optional[builtins.str]:
        '''The alias of the image version.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-alias
        '''
        result = self._values.get("alias")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def aliases(self) -> typing.Optional[typing.List[builtins.str]]:
        '''List of aliases for the image version.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-aliases
        '''
        result = self._values.get("aliases")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def horovod(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Indicates Horovod compatibility.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-horovod
        '''
        result = self._values.get("horovod")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def job_type(self) -> typing.Optional[builtins.str]:
        '''Indicates SageMaker job type compatibility.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-jobtype
        '''
        result = self._values.get("job_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ml_framework(self) -> typing.Optional[builtins.str]:
        '''The machine learning framework vended in the image version.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-mlframework
        '''
        result = self._values.get("ml_framework")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def processor(self) -> typing.Optional[builtins.str]:
        '''Indicates CPU or GPU compatibility.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-processor
        '''
        result = self._values.get("processor")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def programming_lang(self) -> typing.Optional[builtins.str]:
        '''The supported programming language and its version.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-programminglang
        '''
        result = self._values.get("programming_lang")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def release_notes(self) -> typing.Optional[builtins.str]:
        '''The maintainer description of the image version.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-releasenotes
        '''
        result = self._values.get("release_notes")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def vendor_guidance(self) -> typing.Optional[builtins.str]:
        '''The availability of the image version specified by the maintainer.

        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-vendorguidance
        '''
        result = self._values.get("vendor_guidance")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageVersionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556, _ITaggableV2_4e6798f8)
class CfnInferenceComponent(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent",
):
    '''Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an endpoint.

    In the inference component settings, you specify the model, the endpoint, and how the model utilizes the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where each inference component contains one model and the resource utilization needs for that individual model. After you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint API action.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html
    :cloudformationResource: AWS::SageMaker::InferenceComponent
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_inference_component = sagemaker.CfnInferenceComponent(self, "MyCfnInferenceComponent",
            endpoint_name="endpointName",
            specification=sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty(
                base_inference_component_name="baseInferenceComponentName",
                compute_resource_requirements=sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty(
                    max_memory_required_in_mb=123,
                    min_memory_required_in_mb=123,
                    number_of_accelerator_devices_required=123,
                    number_of_cpu_cores_required=123
                ),
                container=sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty(
                    artifact_url="artifactUrl",
                    deployed_image=sagemaker.CfnInferenceComponent.DeployedImageProperty(
                        resolution_time="resolutionTime",
                        resolved_image="resolvedImage",
                        specified_image="specifiedImage"
                    ),
                    environment={
                        "environment_key": "environment"
                    },
                    image="image"
                ),
                model_name="modelName",
                startup_parameters=sagemaker.CfnInferenceComponent.InferenceComponentStartupParametersProperty(
                    container_startup_health_check_timeout_in_seconds=123,
                    model_data_download_timeout_in_seconds=123
                )
            ),
        
            # the properties below are optional
            deployment_config=sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty(
                auto_rollback_configuration=sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty(
                    alarms=[sagemaker.CfnInferenceComponent.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                ),
                rolling_update_policy=sagemaker.CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty(
                    maximum_batch_size=sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    maximum_execution_timeout_in_seconds=123,
                    rollback_maximum_batch_size=sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123
                )
            ),
            endpoint_arn="endpointArn",
            inference_component_name="inferenceComponentName",
            runtime_config=sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty(
                copy_count=123,
                current_copy_count=123,
                desired_copy_count=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            variant_name="variantName"
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        endpoint_name: builtins.str,
        specification: typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.InferenceComponentSpecificationProperty", typing.Dict[builtins.str, typing.Any]]],
        deployment_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.InferenceComponentDeploymentConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_arn: typing.Optional[builtins.str] = None,
        inference_component_name: typing.Optional[builtins.str] = None,
        runtime_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.InferenceComponentRuntimeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        variant_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param endpoint_name: The name of the endpoint that hosts the inference component.
        :param specification: The specification for the inference component.
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_arn: The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
        :param inference_component_name: The name of the inference component.
        :param runtime_config: The runtime config for the inference component.
        :param tags: An array of tags to apply to the resource.
        :param variant_name: The name of the production variant that hosts the inference component.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f4e5766b29b94468be54bb573abdb408c06e9ece9272100939b3c0180556e58)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnInferenceComponentProps(
            endpoint_name=endpoint_name,
            specification=specification,
            deployment_config=deployment_config,
            endpoint_arn=endpoint_arn,
            inference_component_name=inference_component_name,
            runtime_config=runtime_config,
            tags=tags,
            variant_name=variant_name,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1229b87a01037ac1a39fba400729787882a0e5da916a89f8f2d664594cf6695)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea8877be2acff923e7ef08e1efa4d1f02452a154b43e2e34180d83113e4cb35a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the inference component was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrFailureReason")
    def attr_failure_reason(self) -> builtins.str:
        '''The failure reason if the inference component is in a failed state.

        :cloudformationAttribute: FailureReason
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrFailureReason"))

    @builtins.property
    @jsii.member(jsii_name="attrInferenceComponentArn")
    def attr_inference_component_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the inference component.

        :cloudformationAttribute: InferenceComponentArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrInferenceComponentArn"))

    @builtins.property
    @jsii.member(jsii_name="attrInferenceComponentStatus")
    def attr_inference_component_status(self) -> builtins.str:
        '''The status of the inference component.

        :cloudformationAttribute: InferenceComponentStatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrInferenceComponentStatus"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedTime")
    def attr_last_modified_time(self) -> builtins.str:
        '''The time when the inference component was last updated.

        :cloudformationAttribute: LastModifiedTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedTime"))

    @builtins.property
    @jsii.member(jsii_name="attrRuntimeConfigCurrentCopyCount")
    def attr_runtime_config_current_copy_count(self) -> jsii.Number:
        '''The number of runtime copies of the model container that are currently deployed.

        :cloudformationAttribute: RuntimeConfig.CurrentCopyCount
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrRuntimeConfigCurrentCopyCount"))

    @builtins.property
    @jsii.member(jsii_name="attrRuntimeConfigDesiredCopyCount")
    def attr_runtime_config_desired_copy_count(self) -> jsii.Number:
        '''The number of runtime copies of the model container that you requested to deploy with the inference component.

        :cloudformationAttribute: RuntimeConfig.DesiredCopyCount
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrRuntimeConfigDesiredCopyCount"))

    @builtins.property
    @jsii.member(jsii_name="attrSpecificationContainerDeployedImage")
    def attr_specification_container_deployed_image(self) -> _IResolvable_da3f097b:
        '''
        :cloudformationAttribute: Specification.Container.DeployedImage
        '''
        return typing.cast(_IResolvable_da3f097b, jsii.get(self, "attrSpecificationContainerDeployedImage"))

    @builtins.property
    @jsii.member(jsii_name="cdkTagManager")
    def cdk_tag_manager(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "cdkTagManager"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> builtins.str:
        '''The name of the endpoint that hosts the inference component.'''
        return typing.cast(builtins.str, jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5da5a7b9146494fb112ee7d607f46334dc3051d93d50b77735f62bdd6ca326a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="specification")
    def specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentSpecificationProperty"]:
        '''The specification for the inference component.'''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentSpecificationProperty"], jsii.get(self, "specification"))

    @specification.setter
    def specification(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentSpecificationProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0adfcd5be0b7e042e0a87c6ccfbe4b53fc4803e5b7da8ad8951b7875f1bc187d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "specification", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="deploymentConfig")
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentDeploymentConfigProperty"]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentDeploymentConfigProperty"]], jsii.get(self, "deploymentConfig"))

    @deployment_config.setter
    def deployment_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentDeploymentConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e199bdfdfc0d9fd1ee6e1e738627e42cbf742196ce04c25062153cb3351b483d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deploymentConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="endpointArn")
    def endpoint_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointArn"))

    @endpoint_arn.setter
    def endpoint_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6177c630f46f5680f400bfc08061f6f7a9f5f1e1736976ebe24194a8378cbb9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="inferenceComponentName")
    def inference_component_name(self) -> typing.Optional[builtins.str]:
        '''The name of the inference component.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "inferenceComponentName"))

    @inference_component_name.setter
    def inference_component_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3472a30311d416ad067afa5672326f2c73cf974625b4aa6be0907db35a5a4bac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "inferenceComponentName", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="runtimeConfig")
    def runtime_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentRuntimeConfigProperty"]]:
        '''The runtime config for the inference component.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentRuntimeConfigProperty"]], jsii.get(self, "runtimeConfig"))

    @runtime_config.setter
    def runtime_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.InferenceComponentRuntimeConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e7c351a25e5bcfa57adb1a6effe98407a73bd29e017ee9e9dea5d09a2106d9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "runtimeConfig", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of tags to apply to the resource.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tags"))

    @tags.setter
    def tags(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01670e9b8687fbb8bb10369a12d0d3b7f4aba931c3ce72496c12f3a81c2890f4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tags", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="variantName")
    def variant_name(self) -> typing.Optional[builtins.str]:
        '''The name of the production variant that hosts the inference component.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "variantName"))

    @variant_name.setter
    def variant_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca03af9ff83216f8a0636af33c0e4a7a2eb600513b2eed7eb75f082151eb70e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "variantName", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AlarmProperty",
        jsii_struct_bases=[],
        name_mapping={"alarm_name": "alarmName"},
    )
    class AlarmProperty:
        def __init__(self, *, alarm_name: builtins.str) -> None:
            '''An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.

            :param alarm_name: The name of a CloudWatch alarm in your account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                alarm_property = sagemaker.CfnInferenceComponent.AlarmProperty(
                    alarm_name="alarmName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c2e57d9659cdb5d7e18be641744517d4d5f2d248d3f33ad5971d10def8f016e8)
                check_type(argname="argument alarm_name", value=alarm_name, expected_type=type_hints["alarm_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarm_name": alarm_name,
            }

        @builtins.property
        def alarm_name(self) -> builtins.str:
            '''The name of a CloudWatch alarm in your account.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html#cfn-sagemaker-inferencecomponent-alarm-alarmname
            '''
            result = self._values.get("alarm_name")
            assert result is not None, "Required property 'alarm_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AlarmProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"alarms": "alarms"},
    )
    class AutoRollbackConfigurationProperty:
        def __init__(
            self,
            *,
            alarms: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.AlarmProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''
            :param alarms: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                auto_rollback_configuration_property = sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty(
                    alarms=[sagemaker.CfnInferenceComponent.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b45c128e4eb34d277b6582f23b7a23327ba1c7a555322e894c50830f7e239c67)
                check_type(argname="argument alarms", value=alarms, expected_type=type_hints["alarms"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarms": alarms,
            }

        @builtins.property
        def alarms(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.AlarmProperty"]]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html#cfn-sagemaker-inferencecomponent-autorollbackconfiguration-alarms
            '''
            result = self._values.get("alarms")
            assert result is not None, "Required property 'alarms' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.AlarmProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AutoRollbackConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.DeployedImageProperty",
        jsii_struct_bases=[],
        name_mapping={
            "resolution_time": "resolutionTime",
            "resolved_image": "resolvedImage",
            "specified_image": "specifiedImage",
        },
    )
    class DeployedImageProperty:
        def __init__(
            self,
            *,
            resolution_time: typing.Optional[builtins.str] = None,
            resolved_image: typing.Optional[builtins.str] = None,
            specified_image: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this `ProductionVariant <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html>`_ .

            If you used the ``registry/repository[:tag]`` form to specify the image path of the primary container when you created the model hosted in this ``ProductionVariant`` , the path resolves to a path of the form ``registry/repository[@digest]`` . A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see `Pulling an Image <https://docs.aws.amazon.com//AmazonECR/latest/userguide/docker-pull-ecr-image.html>`_ in the *Amazon ECR User Guide* .

            :param resolution_time: The date and time when the image path for the model resolved to the ``ResolvedImage``.
            :param resolved_image: The specific digest path of the image hosted in this ``ProductionVariant`` .
            :param specified_image: The image path you specified when you created the model.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                deployed_image_property = sagemaker.CfnInferenceComponent.DeployedImageProperty(
                    resolution_time="resolutionTime",
                    resolved_image="resolvedImage",
                    specified_image="specifiedImage"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c27834d414a93bc1a61027191b0a24b7e6f65578d28266dfd21a6ed1a5a85ee1)
                check_type(argname="argument resolution_time", value=resolution_time, expected_type=type_hints["resolution_time"])
                check_type(argname="argument resolved_image", value=resolved_image, expected_type=type_hints["resolved_image"])
                check_type(argname="argument specified_image", value=specified_image, expected_type=type_hints["specified_image"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if resolution_time is not None:
                self._values["resolution_time"] = resolution_time
            if resolved_image is not None:
                self._values["resolved_image"] = resolved_image
            if specified_image is not None:
                self._values["specified_image"] = specified_image

        @builtins.property
        def resolution_time(self) -> typing.Optional[builtins.str]:
            '''The date and time when the image path for the model resolved to the ``ResolvedImage``.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolutiontime
            '''
            result = self._values.get("resolution_time")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def resolved_image(self) -> typing.Optional[builtins.str]:
            '''The specific digest path of the image hosted in this ``ProductionVariant`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolvedimage
            '''
            result = self._values.get("resolved_image")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def specified_image(self) -> typing.Optional[builtins.str]:
            '''The image path you specified when you created the model.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-specifiedimage
            '''
            result = self._values.get("specified_image")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeployedImageProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type", "value": "value"},
    )
    class InferenceComponentCapacitySizeProperty:
        def __init__(self, *, type: builtins.str, value: jsii.Number) -> None:
            '''Specifies the type and size of the endpoint capacity to activate for a rolling deployment or a rollback strategy.

            You can specify your batches as either of the following:

            - A count of inference component copies
            - The overall percentage or your fleet

            For a rollback strategy, if you don't specify the fields in this object, or if you set the ``Value`` parameter to 100%, then SageMaker AI uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.

            :param type: Specifies the endpoint capacity type. - **COPY_COUNT** - The endpoint activates based on the number of inference component copies. - **CAPACITY_PERCENT** - The endpoint activates based on the specified percentage of capacity.
            :param value: Defines the capacity size, either as a number of inference component copies or a capacity percentage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_component_capacity_size_property = sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty(
                    type="type",
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__70eb38a8a5ac51cd3be509b73d5f6b909e71847b744359bf2883142f67c4b907)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
                "value": value,
            }

        @builtins.property
        def type(self) -> builtins.str:
            '''Specifies the endpoint capacity type.

            - **COPY_COUNT** - The endpoint activates based on the number of inference component copies.
            - **CAPACITY_PERCENT** - The endpoint activates based on the specified percentage of capacity.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> jsii.Number:
            '''Defines the capacity size, either as a number of inference component copies or a capacity percentage.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceComponentCapacitySizeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_memory_required_in_mb": "maxMemoryRequiredInMb",
            "min_memory_required_in_mb": "minMemoryRequiredInMb",
            "number_of_accelerator_devices_required": "numberOfAcceleratorDevicesRequired",
            "number_of_cpu_cores_required": "numberOfCpuCoresRequired",
        },
    )
    class InferenceComponentComputeResourceRequirementsProperty:
        def __init__(
            self,
            *,
            max_memory_required_in_mb: typing.Optional[jsii.Number] = None,
            min_memory_required_in_mb: typing.Optional[jsii.Number] = None,
            number_of_accelerator_devices_required: typing.Optional[jsii.Number] = None,
            number_of_cpu_cores_required: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Defines the compute resources to allocate to run a model, plus any adapter models, that you assign to an inference component.

            These resources include CPU cores, accelerators, and memory.

            :param max_memory_required_in_mb: The maximum MB of memory to allocate to run a model that you assign to an inference component.
            :param min_memory_required_in_mb: The minimum MB of memory to allocate to run a model that you assign to an inference component.
            :param number_of_accelerator_devices_required: The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and AWS Inferentia.
            :param number_of_cpu_cores_required: The number of CPU cores to allocate to run a model that you assign to an inference component.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_component_compute_resource_requirements_property = sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty(
                    max_memory_required_in_mb=123,
                    min_memory_required_in_mb=123,
                    number_of_accelerator_devices_required=123,
                    number_of_cpu_cores_required=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c434e562757acaaae52cb6bda4572fad68492cf9a55f32d82b5e11d8f3897a91)
                check_type(argname="argument max_memory_required_in_mb", value=max_memory_required_in_mb, expected_type=type_hints["max_memory_required_in_mb"])
                check_type(argname="argument min_memory_required_in_mb", value=min_memory_required_in_mb, expected_type=type_hints["min_memory_required_in_mb"])
                check_type(argname="argument number_of_accelerator_devices_required", value=number_of_accelerator_devices_required, expected_type=type_hints["number_of_accelerator_devices_required"])
                check_type(argname="argument number_of_cpu_cores_required", value=number_of_cpu_cores_required, expected_type=type_hints["number_of_cpu_cores_required"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max_memory_required_in_mb is not None:
                self._values["max_memory_required_in_mb"] = max_memory_required_in_mb
            if min_memory_required_in_mb is not None:
                self._values["min_memory_required_in_mb"] = min_memory_required_in_mb
            if number_of_accelerator_devices_required is not None:
                self._values["number_of_accelerator_devices_required"] = number_of_accelerator_devices_required
            if number_of_cpu_cores_required is not None:
                self._values["number_of_cpu_cores_required"] = number_of_cpu_cores_required

        @builtins.property
        def max_memory_required_in_mb(self) -> typing.Optional[jsii.Number]:
            '''The maximum MB of memory to allocate to run a model that you assign to an inference component.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-maxmemoryrequiredinmb
            '''
            result = self._values.get("max_memory_required_in_mb")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min_memory_required_in_mb(self) -> typing.Optional[jsii.Number]:
            '''The minimum MB of memory to allocate to run a model that you assign to an inference component.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-minmemoryrequiredinmb
            '''
            result = self._values.get("min_memory_required_in_mb")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def number_of_accelerator_devices_required(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The number of accelerators to allocate to run a model that you assign to an inference component.

            Accelerators include GPUs and AWS Inferentia.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofacceleratordevicesrequired
            '''
            result = self._values.get("number_of_accelerator_devices_required")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def number_of_cpu_cores_required(self) -> typing.Optional[jsii.Number]:
            '''The number of CPU cores to allocate to run a model that you assign to an inference component.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofcpucoresrequired
            '''
            result = self._values.get("number_of_cpu_cores_required")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceComponentComputeResourceRequirementsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "artifact_url": "artifactUrl",
            "deployed_image": "deployedImage",
            "environment": "environment",
            "image": "image",
        },
    )
    class InferenceComponentContainerSpecificationProperty:
        def __init__(
            self,
            *,
            artifact_url: typing.Optional[builtins.str] = None,
            deployed_image: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.DeployedImageProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            environment: typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]] = None,
            image: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Defines a container that provides the runtime environment for a model that you deploy with an inference component.

            :param artifact_url: The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
            :param deployed_image: 
            :param environment: The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
            :param image: The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_component_container_specification_property = sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty(
                    artifact_url="artifactUrl",
                    deployed_image=sagemaker.CfnInferenceComponent.DeployedImageProperty(
                        resolution_time="resolutionTime",
                        resolved_image="resolvedImage",
                        specified_image="specifiedImage"
                    ),
                    environment={
                        "environment_key": "environment"
                    },
                    image="image"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f5aed592935acb4ecc3dffe218101a8b9053d16d99e4a24219409fd2bd906fec)
                check_type(argname="argument artifact_url", value=artifact_url, expected_type=type_hints["artifact_url"])
                check_type(argname="argument deployed_image", value=deployed_image, expected_type=type_hints["deployed_image"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if artifact_url is not None:
                self._values["artifact_url"] = artifact_url
            if deployed_image is not None:
                self._values["deployed_image"] = deployed_image
            if environment is not None:
                self._values["environment"] = environment
            if image is not None:
                self._values["image"] = image

        @builtins.property
        def artifact_url(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 path where the model artifacts, which result from model training, are stored.

            This path must point to a single gzip compressed tar archive (.tar.gz suffix).

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-artifacturl
            '''
            result = self._values.get("artifact_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def deployed_image(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.DeployedImageProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-deployedimage
            '''
            result = self._values.get("deployed_image")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceComponent.DeployedImageProperty"]], result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]]:
            '''The environment variables to set in the Docker container.

            Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[typing.Mapping[builtins.str, builtins.str], _IResolvable_da3f097b]], result)

        @builtins.property
        def image(self) -> typing.Optional[builtins.str]:
            '''The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-image
            '''
            result = self._values.get("image")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceComponentContainerSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "auto_rollback_configuration": "autoRollbackConfiguration",
            "rolling_update_policy": "rollingUpdatePolicy",
        },
    )
    class InferenceComponentDeploymentConfigProperty:
        def __init__(
            self,
            *,
            auto_rollback_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.AutoRollbackConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rolling_update_policy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The deployment configuration for an endpoint that hosts inference components.

            The configuration includes the desired deployment strategy and rollback settings.

            :param auto_rollback_configuration: 
            :param rolling_update_policy: Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_component_deployment_config_property = sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty(
                    auto_rollback_configuration=sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty(
                        alarms=[sagemaker.CfnInferenceComponent.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    ),
                    rolling_update_policy=sagemaker.CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty(
                        maximum_batch_size=sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        maximum_execution_timeout_in_seconds=123,
                        rollback_maximum_batch_size=sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a70516845877d0ca21bee7e4344b7ffa9a86cd8096f492bb70c79806a615c46e)
                check_type(argname="argument auto_rollback_configuration", value=auto_rollback_configuration, expected_type=type_hints["auto_rollback_configuration"])
                check_type(argname="argument rolling_update_policy", value=rolling_update_policy, expected_type=type_hints["rolling_update_pol