r'''
# AWS::QuickSight Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_quicksight as quicksight
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for QuickSight construct libraries](https://constructs.dev/search?q=quicksight)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::QuickSight resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_QuickSight.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::QuickSight](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_QuickSight.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    ITaggable as _ITaggable_36806126,
    ITaggableV2 as _ITaggableV2_4e6798f8,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)


@jsii.implements(_IInspectable_c2943556, _ITaggable_36806126)
class CfnAnalysis(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis",
):
    '''Creates an analysis in Amazon QuickSight.

    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
    :cloudformationResource: AWS::QuickSight::Analysis
    :exampleMetadata: fixture=_generated

    Example::

        
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        analysis_id: builtins.str,
        aws_account_id: builtins.str,
        name: builtins.str,
        definition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AnalysisDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        errors: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AnalysisErrorProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        folder_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        parameters: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ParametersProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        permissions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ResourcePermissionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        sheets: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SheetProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        source_entity: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AnalysisSourceEntityProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        status: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        theme_arn: typing.Optional[builtins.str] = None,
        validation_strategy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ValidationStrategyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: Scope in which this resource is defined.
        :param id: Construct identifier for this resource (unique in its scope).
        :param analysis_id: The ID for the analysis that you're creating. This ID displays in the URL of the analysis.
        :param aws_account_id: The ID of the AWS account where you are creating an analysis.
        :param name: A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console.
        :param definition: 
        :param errors: Errors associated with the analysis.
        :param folder_arns: 
        :param parameters: The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values.
        :param permissions: A structure that describes the principals and the resource-level permissions on an analysis. You can use the ``Permissions`` structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). To specify no permissions, omit ``Permissions`` .
        :param sheets: A list of the associated sheets with the unique identifier and name of each sheet.
        :param source_entity: A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets. Either a ``SourceEntity`` or a ``Definition`` must be provided in order for the request to be valid.
        :param status: Status associated with the analysis.
        :param tags: Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
        :param theme_arn: The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.
        :param validation_strategy: The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects. When you set this value to ``LENIENT`` , validation is skipped for specific errors.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b3315f05d88d5e66533d2b20616a2e811e05c9fbafca2923d46fac3672de4c3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAnalysisProps(
            analysis_id=analysis_id,
            aws_account_id=aws_account_id,
            name=name,
            definition=definition,
            errors=errors,
            folder_arns=folder_arns,
            parameters=parameters,
            permissions=permissions,
            sheets=sheets,
            source_entity=source_entity,
            status=status,
            tags=tags,
            theme_arn=theme_arn,
            validation_strategy=validation_strategy,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ca8147b17b844ffbc3c2a9cd090ca0e94480c6c7ae381cf94ebe71edace477d)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53b97cfc102fb3684bd66abaed6039a9dfaeaec91be6718e5c5a729fb5bd4bce)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the analysis.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCreatedTime")
    def attr_created_time(self) -> builtins.str:
        '''The time that the analysis was created.

        :cloudformationAttribute: CreatedTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreatedTime"))

    @builtins.property
    @jsii.member(jsii_name="attrDataSetArns")
    def attr_data_set_arns(self) -> typing.List[builtins.str]:
        '''The ARNs of the datasets of the analysis.

        :cloudformationAttribute: DataSetArns
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "attrDataSetArns"))

    @builtins.property
    @jsii.member(jsii_name="attrErrors")
    def attr_errors(self) -> _IResolvable_da3f097b:
        '''
        :cloudformationAttribute: Errors
        '''
        return typing.cast(_IResolvable_da3f097b, jsii.get(self, "attrErrors"))

    @builtins.property
    @jsii.member(jsii_name="attrLastUpdatedTime")
    def attr_last_updated_time(self) -> builtins.str:
        '''The time that the analysis was last updated.

        :cloudformationAttribute: LastUpdatedTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastUpdatedTime"))

    @builtins.property
    @jsii.member(jsii_name="attrSheets")
    def attr_sheets(self) -> _IResolvable_da3f097b:
        '''
        :cloudformationAttribute: Sheets
        '''
        return typing.cast(_IResolvable_da3f097b, jsii.get(self, "attrSheets"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tag Manager which manages the tags for this resource.'''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="analysisId")
    def analysis_id(self) -> builtins.str:
        '''The ID for the analysis that you're creating.'''
        return typing.cast(builtins.str, jsii.get(self, "analysisId"))

    @analysis_id.setter
    def analysis_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e97a6221e06dbf461b9aa4823e3454ea44abab8e0005d388c8a957afba6a7546)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "analysisId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="awsAccountId")
    def aws_account_id(self) -> builtins.str:
        '''The ID of the AWS account where you are creating an analysis.'''
        return typing.cast(builtins.str, jsii.get(self, "awsAccountId"))

    @aws_account_id.setter
    def aws_account_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9813c24d422123fdb92156bf969c5184775e9ae04365dcc922fbd64d9a6fa0d4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "awsAccountId", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''A descriptive name for the analysis that you're creating.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca318b234683f1f107ce9a5125554a5e0541143b8749b8bfddc3af01f3eec1e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="definition")
    def definition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisDefinitionProperty"]]:
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisDefinitionProperty"]], jsii.get(self, "definition"))

    @definition.setter
    def definition(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisDefinitionProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__312c03143f0646ddac921317c4beafd13435a22bac7731ca4c80df7cf1291f07)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "definition", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="errors")
    def errors(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisErrorProperty"]]]]:
        '''Errors associated with the analysis.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisErrorProperty"]]]], jsii.get(self, "errors"))

    @errors.setter
    def errors(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisErrorProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c6a0b9f84708043b6388b7cc2507e80b2ec92bee4c20a36299936a33e1260cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "errors", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="folderArns")
    def folder_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "folderArns"))

    @folder_arns.setter
    def folder_arns(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__acb1ee971a3005e9aaf671478425a2defce0c42a4798b74fef66876536bc6205)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "folderArns", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="parameters")
    def parameters(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ParametersProperty"]]:
        '''The parameter names and override values that you want to use.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ParametersProperty"]], jsii.get(self, "parameters"))

    @parameters.setter
    def parameters(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ParametersProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef1f56dc35400e4931f1653bb22e70cc553ebe1114f5d755d003231b1324cba0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "parameters", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="permissions")
    def permissions(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ResourcePermissionProperty"]]]]:
        '''A structure that describes the principals and the resource-level permissions on an analysis.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ResourcePermissionProperty"]]]], jsii.get(self, "permissions"))

    @permissions.setter
    def permissions(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ResourcePermissionProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66d1950ca4f145650f0bbe6dd03ce20c1892373a45953eeae4c8d1e715e4e59f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "permissions", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="sheets")
    def sheets(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetProperty"]]]]:
        '''A list of the associated sheets with the unique identifier and name of each sheet.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetProperty"]]]], jsii.get(self, "sheets"))

    @sheets.setter
    def sheets(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ae5ac0286f6d69735847f21956cc7a189332cc0ba029898dc97822bc48ef4b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sheets", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="sourceEntity")
    def source_entity(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisSourceEntityProperty"]]:
        '''A source entity to use for the analysis that you're creating.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisSourceEntityProperty"]], jsii.get(self, "sourceEntity"))

    @source_entity.setter
    def source_entity(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisSourceEntityProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6af7e816d0168a8e494393a7d325b33b7608b06408d137df9bb53d12ddb0300)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sourceEntity", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> typing.Optional[builtins.str]:
        '''Status associated with the analysis.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "status"))

    @status.setter
    def status(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__960fdb2a491ce9d35ff5cabbedc58835f6818653fdd7bf86d6f4bc8a77bb74cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "status", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="tagsRaw")
    def tags_raw(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.'''
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], jsii.get(self, "tagsRaw"))

    @tags_raw.setter
    def tags_raw(self, value: typing.Optional[typing.List[_CfnTag_f6864754]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96a82327f73591975826047cd88720f3f49b18acb2dd6e14a4795868ce2805b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tagsRaw", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="themeArn")
    def theme_arn(self) -> typing.Optional[builtins.str]:
        '''The ARN for the theme to apply to the analysis that you're creating.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "themeArn"))

    @theme_arn.setter
    def theme_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63c9327e4ac918b6b057dc7c2832c61de3e22f29858922ea51482cc4bcc992e8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "themeArn", value) # pyright: ignore[reportArgumentType]

    @builtins.property
    @jsii.member(jsii_name="validationStrategy")
    def validation_strategy(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ValidationStrategyProperty"]]:
        '''The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.'''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ValidationStrategyProperty"]], jsii.get(self, "validationStrategy"))

    @validation_strategy.setter
    def validation_strategy(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ValidationStrategyProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4515d338bad3917a13aa84587ddde591fed0b18d3bc4dfedd4fa0f258fd89eb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "validationStrategy", value) # pyright: ignore[reportArgumentType]

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationFunctionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "attribute_aggregation_function": "attributeAggregationFunction",
            "categorical_aggregation_function": "categoricalAggregationFunction",
            "date_aggregation_function": "dateAggregationFunction",
            "numerical_aggregation_function": "numericalAggregationFunction",
        },
    )
    class AggregationFunctionProperty:
        def __init__(
            self,
            *,
            attribute_aggregation_function: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AttributeAggregationFunctionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            categorical_aggregation_function: typing.Optional[builtins.str] = None,
            date_aggregation_function: typing.Optional[builtins.str] = None,
            numerical_aggregation_function: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumericalAggregationFunctionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''An aggregation function aggregates values from a dimension or measure.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param attribute_aggregation_function: Aggregation for attributes.
            :param categorical_aggregation_function: Aggregation for categorical values. - ``COUNT`` : Aggregate by the total number of values, including duplicates. - ``DISTINCT_COUNT`` : Aggregate by the total number of distinct values.
            :param date_aggregation_function: Aggregation for date values. - ``COUNT`` : Aggregate by the total number of values, including duplicates. - ``DISTINCT_COUNT`` : Aggregate by the total number of distinct values. - ``MIN`` : Select the smallest date value. - ``MAX`` : Select the largest date value.
            :param numerical_aggregation_function: Aggregation for numerical values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                aggregation_function_property = quicksight.CfnAnalysis.AggregationFunctionProperty(
                    attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                        simple_attribute_aggregation="simpleAttributeAggregation",
                        value_for_multiple_values="valueForMultipleValues"
                    ),
                    categorical_aggregation_function="categoricalAggregationFunction",
                    date_aggregation_function="dateAggregationFunction",
                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                            percentile_value=123
                        ),
                        simple_numerical_aggregation="simpleNumericalAggregation"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__925d009ba27261c4511ddbb792d28c7eb0661fd2f049ebff6d7260489c45c820)
                check_type(argname="argument attribute_aggregation_function", value=attribute_aggregation_function, expected_type=type_hints["attribute_aggregation_function"])
                check_type(argname="argument categorical_aggregation_function", value=categorical_aggregation_function, expected_type=type_hints["categorical_aggregation_function"])
                check_type(argname="argument date_aggregation_function", value=date_aggregation_function, expected_type=type_hints["date_aggregation_function"])
                check_type(argname="argument numerical_aggregation_function", value=numerical_aggregation_function, expected_type=type_hints["numerical_aggregation_function"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if attribute_aggregation_function is not None:
                self._values["attribute_aggregation_function"] = attribute_aggregation_function
            if categorical_aggregation_function is not None:
                self._values["categorical_aggregation_function"] = categorical_aggregation_function
            if date_aggregation_function is not None:
                self._values["date_aggregation_function"] = date_aggregation_function
            if numerical_aggregation_function is not None:
                self._values["numerical_aggregation_function"] = numerical_aggregation_function

        @builtins.property
        def attribute_aggregation_function(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AttributeAggregationFunctionProperty"]]:
            '''Aggregation for attributes.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-attributeaggregationfunction
            '''
            result = self._values.get("attribute_aggregation_function")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AttributeAggregationFunctionProperty"]], result)

        @builtins.property
        def categorical_aggregation_function(self) -> typing.Optional[builtins.str]:
            '''Aggregation for categorical values.

            - ``COUNT`` : Aggregate by the total number of values, including duplicates.
            - ``DISTINCT_COUNT`` : Aggregate by the total number of distinct values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-categoricalaggregationfunction
            '''
            result = self._values.get("categorical_aggregation_function")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def date_aggregation_function(self) -> typing.Optional[builtins.str]:
            '''Aggregation for date values.

            - ``COUNT`` : Aggregate by the total number of values, including duplicates.
            - ``DISTINCT_COUNT`` : Aggregate by the total number of distinct values.
            - ``MIN`` : Select the smallest date value.
            - ``MAX`` : Select the largest date value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-dateaggregationfunction
            '''
            result = self._values.get("date_aggregation_function")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def numerical_aggregation_function(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericalAggregationFunctionProperty"]]:
            '''Aggregation for numerical values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-numericalaggregationfunction
            '''
            result = self._values.get("numerical_aggregation_function")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericalAggregationFunctionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AggregationFunctionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationSortConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "sort_direction": "sortDirection",
            "aggregation_function": "aggregationFunction",
        },
    )
    class AggregationSortConfigurationProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            sort_direction: builtins.str,
            aggregation_function: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AggregationFunctionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration options to sort aggregated values.

            :param column: The column that determines the sort order of aggregated values.
            :param sort_direction: The sort direction of values. - ``ASC`` : Sort in ascending order. - ``DESC`` : Sort in descending order.
            :param aggregation_function: The function that aggregates the values in ``Column`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                aggregation_sort_configuration_property = quicksight.CfnAnalysis.AggregationSortConfigurationProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    sort_direction="sortDirection",
                
                    # the properties below are optional
                    aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                        attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                            simple_attribute_aggregation="simpleAttributeAggregation",
                            value_for_multiple_values="valueForMultipleValues"
                        ),
                        categorical_aggregation_function="categoricalAggregationFunction",
                        date_aggregation_function="dateAggregationFunction",
                        numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                            percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                percentile_value=123
                            ),
                            simple_numerical_aggregation="simpleNumericalAggregation"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__78bad2ac32260dc84e2b7357f78d6b25ee5c88beec8c3afc46099f635c253b9e)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument sort_direction", value=sort_direction, expected_type=type_hints["sort_direction"])
                check_type(argname="argument aggregation_function", value=aggregation_function, expected_type=type_hints["aggregation_function"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "sort_direction": sort_direction,
            }
            if aggregation_function is not None:
                self._values["aggregation_function"] = aggregation_function

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that determines the sort order of aggregated values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def sort_direction(self) -> builtins.str:
            '''The sort direction of values.

            - ``ASC`` : Sort in ascending order.
            - ``DESC`` : Sort in descending order.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-sortdirection
            '''
            result = self._values.get("sort_direction")
            assert result is not None, "Required property 'sort_direction' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def aggregation_function(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]]:
            '''The function that aggregates the values in ``Column`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-aggregationfunction
            '''
            result = self._values.get("aggregation_function")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AggregationSortConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefaultsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_new_sheet_configuration": "defaultNewSheetConfiguration",
        },
    )
    class AnalysisDefaultsProperty:
        def __init__(
            self,
            *,
            default_new_sheet_configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultNewSheetConfigurationProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The configuration for default analysis settings.

            :param default_new_sheet_configuration: The configuration for default new sheet settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                analysis_defaults_property = quicksight.CfnAnalysis.AnalysisDefaultsProperty(
                    default_new_sheet_configuration=quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty(
                        interactive_layout_configuration=quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty(
                            free_form=quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            ),
                            grid=quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                        resize_option="resizeOption",
                
                                        # the properties below are optional
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            )
                        ),
                        paginated_layout_configuration=quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty(
                            section_based=quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                                    paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                                        paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        ),
                                        paper_orientation="paperOrientation",
                                        paper_size="paperSize"
                                    )
                                )
                            )
                        ),
                        sheet_content_type="sheetContentType"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__50c31b61023716b7d8ba53618c337c56297b3ca7493ebffe7c2166feb816acf5)
                check_type(argname="argument default_new_sheet_configuration", value=default_new_sheet_configuration, expected_type=type_hints["default_new_sheet_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_new_sheet_configuration": default_new_sheet_configuration,
            }

        @builtins.property
        def default_new_sheet_configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultNewSheetConfigurationProperty"]:
            '''The configuration for default new sheet settings.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html#cfn-quicksight-analysis-analysisdefaults-defaultnewsheetconfiguration
            '''
            result = self._values.get("default_new_sheet_configuration")
            assert result is not None, "Required property 'default_new_sheet_configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultNewSheetConfigurationProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnalysisDefaultsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_set_identifier_declarations": "dataSetIdentifierDeclarations",
            "analysis_defaults": "analysisDefaults",
            "calculated_fields": "calculatedFields",
            "column_configurations": "columnConfigurations",
            "filter_groups": "filterGroups",
            "options": "options",
            "parameter_declarations": "parameterDeclarations",
            "query_execution_options": "queryExecutionOptions",
            "sheets": "sheets",
            "static_files": "staticFiles",
        },
    )
    class AnalysisDefinitionProperty:
        def __init__(
            self,
            *,
            data_set_identifier_declarations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataSetIdentifierDeclarationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            analysis_defaults: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AnalysisDefaultsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            calculated_fields: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CalculatedFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            column_configurations: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            filter_groups: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterGroupProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AssetOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            parameter_declarations: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ParameterDeclarationProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            query_execution_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.QueryExecutionOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sheets: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SheetDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            static_files: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.StaticFileProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The definition of an analysis.

            :param data_set_identifier_declarations: An array of dataset identifier declarations. This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
            :param analysis_defaults: 
            :param calculated_fields: An array of calculated field definitions for the analysis.
            :param column_configurations: An array of analysis-level column configurations. Column configurations can be used to set default formatting for a column to be used throughout an analysis.
            :param filter_groups: Filter definitions for an analysis. For more information, see `Filtering Data in Amazon QuickSight <https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html>`_ in the *Amazon QuickSight User Guide* .
            :param options: An array of option definitions for an analysis.
            :param parameter_declarations: An array of parameter declarations for an analysis. Parameters are named variables that can transfer a value for use by an action or an object. For more information, see `Parameters in Amazon QuickSight <https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html>`_ in the *Amazon QuickSight User Guide* .
            :param query_execution_options: 
            :param sheets: An array of sheet definitions for an analysis. Each ``SheetDefinition`` provides detailed information about a sheet within this analysis.
            :param static_files: The static files for the definition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__743f6de00af3d8850478c1cec470f5e4bbc39e00ef3e785c354c25f2a4f0444f)
                check_type(argname="argument data_set_identifier_declarations", value=data_set_identifier_declarations, expected_type=type_hints["data_set_identifier_declarations"])
                check_type(argname="argument analysis_defaults", value=analysis_defaults, expected_type=type_hints["analysis_defaults"])
                check_type(argname="argument calculated_fields", value=calculated_fields, expected_type=type_hints["calculated_fields"])
                check_type(argname="argument column_configurations", value=column_configurations, expected_type=type_hints["column_configurations"])
                check_type(argname="argument filter_groups", value=filter_groups, expected_type=type_hints["filter_groups"])
                check_type(argname="argument options", value=options, expected_type=type_hints["options"])
                check_type(argname="argument parameter_declarations", value=parameter_declarations, expected_type=type_hints["parameter_declarations"])
                check_type(argname="argument query_execution_options", value=query_execution_options, expected_type=type_hints["query_execution_options"])
                check_type(argname="argument sheets", value=sheets, expected_type=type_hints["sheets"])
                check_type(argname="argument static_files", value=static_files, expected_type=type_hints["static_files"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_set_identifier_declarations": data_set_identifier_declarations,
            }
            if analysis_defaults is not None:
                self._values["analysis_defaults"] = analysis_defaults
            if calculated_fields is not None:
                self._values["calculated_fields"] = calculated_fields
            if column_configurations is not None:
                self._values["column_configurations"] = column_configurations
            if filter_groups is not None:
                self._values["filter_groups"] = filter_groups
            if options is not None:
                self._values["options"] = options
            if parameter_declarations is not None:
                self._values["parameter_declarations"] = parameter_declarations
            if query_execution_options is not None:
                self._values["query_execution_options"] = query_execution_options
            if sheets is not None:
                self._values["sheets"] = sheets
            if static_files is not None:
                self._values["static_files"] = static_files

        @builtins.property
        def data_set_identifier_declarations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataSetIdentifierDeclarationProperty"]]]:
            '''An array of dataset identifier declarations.

            This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-datasetidentifierdeclarations
            '''
            result = self._values.get("data_set_identifier_declarations")
            assert result is not None, "Required property 'data_set_identifier_declarations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataSetIdentifierDeclarationProperty"]]], result)

        @builtins.property
        def analysis_defaults(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisDefaultsProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-analysisdefaults
            '''
            result = self._values.get("analysis_defaults")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisDefaultsProperty"]], result)

        @builtins.property
        def calculated_fields(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CalculatedFieldProperty"]]]]:
            '''An array of calculated field definitions for the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-calculatedfields
            '''
            result = self._values.get("calculated_fields")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CalculatedFieldProperty"]]]], result)

        @builtins.property
        def column_configurations(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnConfigurationProperty"]]]]:
            '''An array of analysis-level column configurations.

            Column configurations can be used to set default formatting for a column to be used throughout an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-columnconfigurations
            '''
            result = self._values.get("column_configurations")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnConfigurationProperty"]]]], result)

        @builtins.property
        def filter_groups(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterGroupProperty"]]]]:
            '''Filter definitions for an analysis.

            For more information, see `Filtering Data in Amazon QuickSight <https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html>`_ in the *Amazon QuickSight User Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-filtergroups
            '''
            result = self._values.get("filter_groups")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterGroupProperty"]]]], result)

        @builtins.property
        def options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AssetOptionsProperty"]]:
            '''An array of option definitions for an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-options
            '''
            result = self._values.get("options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AssetOptionsProperty"]], result)

        @builtins.property
        def parameter_declarations(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ParameterDeclarationProperty"]]]]:
            '''An array of parameter declarations for an analysis.

            Parameters are named variables that can transfer a value for use by an action or an object.

            For more information, see `Parameters in Amazon QuickSight <https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html>`_ in the *Amazon QuickSight User Guide* .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-parameterdeclarations
            '''
            result = self._values.get("parameter_declarations")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ParameterDeclarationProperty"]]]], result)

        @builtins.property
        def query_execution_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.QueryExecutionOptionsProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-queryexecutionoptions
            '''
            result = self._values.get("query_execution_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.QueryExecutionOptionsProperty"]], result)

        @builtins.property
        def sheets(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetDefinitionProperty"]]]]:
            '''An array of sheet definitions for an analysis.

            Each ``SheetDefinition`` provides detailed information about a sheet within this analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-sheets
            '''
            result = self._values.get("sheets")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetDefinitionProperty"]]]], result)

        @builtins.property
        def static_files(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StaticFileProperty"]]]]:
            '''The static files for the definition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-staticfiles
            '''
            result = self._values.get("static_files")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StaticFileProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnalysisDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty",
        jsii_struct_bases=[],
        name_mapping={
            "message": "message",
            "type": "type",
            "violated_entities": "violatedEntities",
        },
    )
    class AnalysisErrorProperty:
        def __init__(
            self,
            *,
            message: typing.Optional[builtins.str] = None,
            type: typing.Optional[builtins.str] = None,
            violated_entities: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.EntityProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Analysis error.

            :param message: The message associated with the analysis error.
            :param type: The type of the analysis error.
            :param violated_entities: Lists the violated entities that caused the analysis error.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                analysis_error_property = quicksight.CfnAnalysis.AnalysisErrorProperty(
                    message="message",
                    type="type",
                    violated_entities=[quicksight.CfnAnalysis.EntityProperty(
                        path="path"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d24a90ca3aa452a90f96fcfd4a5a877d8b3420dac8dd89194eefc7cf2d995a3e)
                check_type(argname="argument message", value=message, expected_type=type_hints["message"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument violated_entities", value=violated_entities, expected_type=type_hints["violated_entities"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if message is not None:
                self._values["message"] = message
            if type is not None:
                self._values["type"] = type
            if violated_entities is not None:
                self._values["violated_entities"] = violated_entities

        @builtins.property
        def message(self) -> typing.Optional[builtins.str]:
            '''The message associated with the analysis error.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message
            '''
            result = self._values.get("message")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            '''The type of the analysis error.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type
            '''
            result = self._values.get("type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def violated_entities(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.EntityProperty"]]]]:
            '''Lists the violated entities that caused the analysis error.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-violatedentities
            '''
            result = self._values.get("violated_entities")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.EntityProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnalysisErrorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty",
        jsii_struct_bases=[],
        name_mapping={"source_template": "sourceTemplate"},
    )
    class AnalysisSourceEntityProperty:
        def __init__(
            self,
            *,
            source_template: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AnalysisSourceTemplateProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The source entity of an analysis.

            :param source_template: The source template for the source entity of the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                analysis_source_entity_property = quicksight.CfnAnalysis.AnalysisSourceEntityProperty(
                    source_template=quicksight.CfnAnalysis.AnalysisSourceTemplateProperty(
                        arn="arn",
                        data_set_references=[quicksight.CfnAnalysis.DataSetReferenceProperty(
                            data_set_arn="dataSetArn",
                            data_set_placeholder="dataSetPlaceholder"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2ecdbd45ff5b11d9790994a68adfcf0f92e2edd71f85a3c48a1682c8262080ba)
                check_type(argname="argument source_template", value=source_template, expected_type=type_hints["source_template"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if source_template is not None:
                self._values["source_template"] = source_template

        @builtins.property
        def source_template(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisSourceTemplateProperty"]]:
            '''The source template for the source entity of the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate
            '''
            result = self._values.get("source_template")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AnalysisSourceTemplateProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnalysisSourceEntityProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty",
        jsii_struct_bases=[],
        name_mapping={"arn": "arn", "data_set_references": "dataSetReferences"},
    )
    class AnalysisSourceTemplateProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            data_set_references: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataSetReferenceProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''The source template of an analysis.

            :param arn: The Amazon Resource Name (ARN) of the source template of an analysis.
            :param data_set_references: The dataset references of the source template of an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                analysis_source_template_property = quicksight.CfnAnalysis.AnalysisSourceTemplateProperty(
                    arn="arn",
                    data_set_references=[quicksight.CfnAnalysis.DataSetReferenceProperty(
                        data_set_arn="dataSetArn",
                        data_set_placeholder="dataSetPlaceholder"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e49cd94ff28900c4ae630948d7ccea67de75a0db33d071821700a175ccf1c97f)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument data_set_references", value=data_set_references, expected_type=type_hints["data_set_references"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
                "data_set_references": data_set_references,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the source template of an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def data_set_references(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataSetReferenceProperty"]]]:
            '''The dataset references of the source template of an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences
            '''
            result = self._values.get("data_set_references")
            assert result is not None, "Required property 'data_set_references' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataSetReferenceProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnalysisSourceTemplateProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AnchorDateConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "anchor_option": "anchorOption",
            "parameter_name": "parameterName",
        },
    )
    class AnchorDateConfigurationProperty:
        def __init__(
            self,
            *,
            anchor_option: typing.Optional[builtins.str] = None,
            parameter_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The date configuration of the filter.

            :param anchor_option: The options for the date configuration. Choose one of the options below:. - ``NOW``
            :param parameter_name: The name of the parameter that is used for the anchor date configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                anchor_date_configuration_property = quicksight.CfnAnalysis.AnchorDateConfigurationProperty(
                    anchor_option="anchorOption",
                    parameter_name="parameterName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5fcc6f6525e366303c9db7e8ff24617e72ce0a488feda6c9ad8187f55d8ab56e)
                check_type(argname="argument anchor_option", value=anchor_option, expected_type=type_hints["anchor_option"])
                check_type(argname="argument parameter_name", value=parameter_name, expected_type=type_hints["parameter_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if anchor_option is not None:
                self._values["anchor_option"] = anchor_option
            if parameter_name is not None:
                self._values["parameter_name"] = parameter_name

        @builtins.property
        def anchor_option(self) -> typing.Optional[builtins.str]:
            '''The options for the date configuration. Choose one of the options below:.

            - ``NOW``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-anchoroption
            '''
            result = self._values.get("anchor_option")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def parameter_name(self) -> typing.Optional[builtins.str]:
            '''The name of the parameter that is used for the anchor date configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-parametername
            '''
            result = self._values.get("parameter_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AnchorDateConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"range": "range", "reserve_range": "reserveRange"},
    )
    class ArcAxisConfigurationProperty:
        def __init__(
            self,
            *,
            range: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ArcAxisDisplayRangeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            reserve_range: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The arc axis configuration of a ``GaugeChartVisual`` .

            :param range: The arc axis range of a ``GaugeChartVisual`` .
            :param reserve_range: The reserved range of the arc axis. Default: - 0

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                arc_axis_configuration_property = quicksight.CfnAnalysis.ArcAxisConfigurationProperty(
                    range=quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty(
                        max=123,
                        min=123
                    ),
                    reserve_range=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d54e637872882a6173bd225ee587908fd78c7f4daecbf84ec402376d4ffade92)
                check_type(argname="argument range", value=range, expected_type=type_hints["range"])
                check_type(argname="argument reserve_range", value=reserve_range, expected_type=type_hints["reserve_range"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if range is not None:
                self._values["range"] = range
            if reserve_range is not None:
                self._values["reserve_range"] = reserve_range

        @builtins.property
        def range(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ArcAxisDisplayRangeProperty"]]:
            '''The arc axis range of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-range
            '''
            result = self._values.get("range")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ArcAxisDisplayRangeProperty"]], result)

        @builtins.property
        def reserve_range(self) -> typing.Optional[jsii.Number]:
            '''The reserved range of the arc axis.

            :default: - 0

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-reserverange
            '''
            result = self._values.get("reserve_range")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArcAxisConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty",
        jsii_struct_bases=[],
        name_mapping={"max": "max", "min": "min"},
    )
    class ArcAxisDisplayRangeProperty:
        def __init__(
            self,
            *,
            max: typing.Optional[jsii.Number] = None,
            min: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The arc axis range of a ``GaugeChartVisual`` .

            :param max: The maximum value of the arc axis range.
            :param min: The minimum value of the arc axis range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                arc_axis_display_range_property = quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty(
                    max=123,
                    min=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ed3f8887663271e93178c46a42a1aeed0fa3ca1be562b706c4a69616b2752b6e)
                check_type(argname="argument max", value=max, expected_type=type_hints["max"])
                check_type(argname="argument min", value=min, expected_type=type_hints["min"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max is not None:
                self._values["max"] = max
            if min is not None:
                self._values["min"] = min

        @builtins.property
        def max(self) -> typing.Optional[jsii.Number]:
            '''The maximum value of the arc axis range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-max
            '''
            result = self._values.get("max")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min(self) -> typing.Optional[jsii.Number]:
            '''The minimum value of the arc axis range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-min
            '''
            result = self._values.get("min")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArcAxisDisplayRangeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"arc_angle": "arcAngle", "arc_thickness": "arcThickness"},
    )
    class ArcConfigurationProperty:
        def __init__(
            self,
            *,
            arc_angle: typing.Optional[jsii.Number] = None,
            arc_thickness: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The arc configuration of a ``GaugeChartVisual`` .

            :param arc_angle: The option that determines the arc angle of a ``GaugeChartVisual`` .
            :param arc_thickness: The options that determine the arc thickness of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                arc_configuration_property = quicksight.CfnAnalysis.ArcConfigurationProperty(
                    arc_angle=123,
                    arc_thickness="arcThickness"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6467b443ad9493fad2ed833817e6e804c21ec4bb657ad9f80369ad9dc86cb37e)
                check_type(argname="argument arc_angle", value=arc_angle, expected_type=type_hints["arc_angle"])
                check_type(argname="argument arc_thickness", value=arc_thickness, expected_type=type_hints["arc_thickness"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if arc_angle is not None:
                self._values["arc_angle"] = arc_angle
            if arc_thickness is not None:
                self._values["arc_thickness"] = arc_thickness

        @builtins.property
        def arc_angle(self) -> typing.Optional[jsii.Number]:
            '''The option that determines the arc angle of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcangle
            '''
            result = self._values.get("arc_angle")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def arc_thickness(self) -> typing.Optional[builtins.str]:
            '''The options that determine the arc thickness of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcthickness
            '''
            result = self._values.get("arc_thickness")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArcConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"arc_thickness": "arcThickness"},
    )
    class ArcOptionsProperty:
        def __init__(
            self,
            *,
            arc_thickness: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The options that determine the arc thickness of a ``GaugeChartVisual`` .

            :param arc_thickness: The arc thickness of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                arc_options_property = quicksight.CfnAnalysis.ArcOptionsProperty(
                    arc_thickness="arcThickness"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3f6963705589da3cdf278cf29ec86cc70224eb186ec79d898a87727068b732fc)
                check_type(argname="argument arc_thickness", value=arc_thickness, expected_type=type_hints["arc_thickness"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if arc_thickness is not None:
                self._values["arc_thickness"] = arc_thickness

        @builtins.property
        def arc_thickness(self) -> typing.Optional[builtins.str]:
            '''The arc thickness of a ``GaugeChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html#cfn-quicksight-analysis-arcoptions-arcthickness
            '''
            result = self._values.get("arc_thickness")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArcOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AssetOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"timezone": "timezone", "week_start": "weekStart"},
    )
    class AssetOptionsProperty:
        def __init__(
            self,
            *,
            timezone: typing.Optional[builtins.str] = None,
            week_start: typing.Optional[builtins.str] = None,
        ) -> None:
            '''An array of analysis level configurations.

            :param timezone: Determines the timezone for the analysis.
            :param week_start: Determines the week start day for an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                asset_options_property = quicksight.CfnAnalysis.AssetOptionsProperty(
                    timezone="timezone",
                    week_start="weekStart"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b036419146adc925061a8649db3f06ee7cc3a080ffd431d521f4374dda141d4c)
                check_type(argname="argument timezone", value=timezone, expected_type=type_hints["timezone"])
                check_type(argname="argument week_start", value=week_start, expected_type=type_hints["week_start"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if timezone is not None:
                self._values["timezone"] = timezone
            if week_start is not None:
                self._values["week_start"] = week_start

        @builtins.property
        def timezone(self) -> typing.Optional[builtins.str]:
            '''Determines the timezone for the analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-timezone
            '''
            result = self._values.get("timezone")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def week_start(self) -> typing.Optional[builtins.str]:
            '''Determines the week start day for an analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-weekstart
            '''
            result = self._values.get("week_start")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AssetOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AttributeAggregationFunctionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "simple_attribute_aggregation": "simpleAttributeAggregation",
            "value_for_multiple_values": "valueForMultipleValues",
        },
    )
    class AttributeAggregationFunctionProperty:
        def __init__(
            self,
            *,
            simple_attribute_aggregation: typing.Optional[builtins.str] = None,
            value_for_multiple_values: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Aggregation for attributes.

            :param simple_attribute_aggregation: The built-in aggregation functions for attributes. - ``UNIQUE_VALUE`` : Returns the unique value for a field, aggregated by the dimension fields.
            :param value_for_multiple_values: Used by the ``UNIQUE_VALUE`` aggregation function. If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                attribute_aggregation_function_property = quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                    simple_attribute_aggregation="simpleAttributeAggregation",
                    value_for_multiple_values="valueForMultipleValues"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__239322ef0f76b06b43847222b973f1c2dab05370b2ec6eb4609aa0ded5f6facc)
                check_type(argname="argument simple_attribute_aggregation", value=simple_attribute_aggregation, expected_type=type_hints["simple_attribute_aggregation"])
                check_type(argname="argument value_for_multiple_values", value=value_for_multiple_values, expected_type=type_hints["value_for_multiple_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if simple_attribute_aggregation is not None:
                self._values["simple_attribute_aggregation"] = simple_attribute_aggregation
            if value_for_multiple_values is not None:
                self._values["value_for_multiple_values"] = value_for_multiple_values

        @builtins.property
        def simple_attribute_aggregation(self) -> typing.Optional[builtins.str]:
            '''The built-in aggregation functions for attributes.

            - ``UNIQUE_VALUE`` : Returns the unique value for a field, aggregated by the dimension fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-simpleattributeaggregation
            '''
            result = self._values.get("simple_attribute_aggregation")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def value_for_multiple_values(self) -> typing.Optional[builtins.str]:
            '''Used by the ``UNIQUE_VALUE`` aggregation function.

            If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-valueformultiplevalues
            '''
            result = self._values.get("value_for_multiple_values")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AttributeAggregationFunctionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDataOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "date_axis_options": "dateAxisOptions",
            "numeric_axis_options": "numericAxisOptions",
        },
    )
    class AxisDataOptionsProperty:
        def __init__(
            self,
            *,
            date_axis_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateAxisOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            numeric_axis_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumericAxisOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The data options for an axis.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param date_axis_options: The options for an axis with a date field.
            :param numeric_axis_options: The options for an axis with a numeric field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                # data_driven: Any
                
                axis_data_options_property = quicksight.CfnAnalysis.AxisDataOptionsProperty(
                    date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                        missing_date_visibility="missingDateVisibility"
                    ),
                    numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                        range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                            data_driven=data_driven,
                            min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                maximum=123,
                                minimum=123
                            )
                        ),
                        scale=quicksight.CfnAnalysis.AxisScaleProperty(
                            linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                step_count=123,
                                step_size=123
                            ),
                            logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                base=123
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__78edd36053c1005b13a557e025be3a3720bda781507e2e555c70560a0d7e3259)
                check_type(argname="argument date_axis_options", value=date_axis_options, expected_type=type_hints["date_axis_options"])
                check_type(argname="argument numeric_axis_options", value=numeric_axis_options, expected_type=type_hints["numeric_axis_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if date_axis_options is not None:
                self._values["date_axis_options"] = date_axis_options
            if numeric_axis_options is not None:
                self._values["numeric_axis_options"] = numeric_axis_options

        @builtins.property
        def date_axis_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateAxisOptionsProperty"]]:
            '''The options for an axis with a date field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-dateaxisoptions
            '''
            result = self._values.get("date_axis_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateAxisOptionsProperty"]], result)

        @builtins.property
        def numeric_axis_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericAxisOptionsProperty"]]:
            '''The options for an axis with a numeric field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-numericaxisoptions
            '''
            result = self._values.get("numeric_axis_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericAxisOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisDataOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty",
        jsii_struct_bases=[],
        name_mapping={"maximum": "maximum", "minimum": "minimum"},
    )
    class AxisDisplayMinMaxRangeProperty:
        def __init__(
            self,
            *,
            maximum: typing.Optional[jsii.Number] = None,
            minimum: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The minimum and maximum setup for an axis display range.

            :param maximum: The maximum setup for an axis display range.
            :param minimum: The minimum setup for an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_display_min_max_range_property = quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                    maximum=123,
                    minimum=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4b4c5af5cc74aa0ccdc5a34f6c71e69180d271c0d9deca42d71f6e7519e3b965)
                check_type(argname="argument maximum", value=maximum, expected_type=type_hints["maximum"])
                check_type(argname="argument minimum", value=minimum, expected_type=type_hints["minimum"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if maximum is not None:
                self._values["maximum"] = maximum
            if minimum is not None:
                self._values["minimum"] = minimum

        @builtins.property
        def maximum(self) -> typing.Optional[jsii.Number]:
            '''The maximum setup for an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-maximum
            '''
            result = self._values.get("maximum")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def minimum(self) -> typing.Optional[jsii.Number]:
            '''The minimum setup for an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-minimum
            '''
            result = self._values.get("minimum")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisDisplayMinMaxRangeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "axis_line_visibility": "axisLineVisibility",
            "axis_offset": "axisOffset",
            "data_options": "dataOptions",
            "grid_line_visibility": "gridLineVisibility",
            "scrollbar_options": "scrollbarOptions",
            "tick_label_options": "tickLabelOptions",
        },
    )
    class AxisDisplayOptionsProperty:
        def __init__(
            self,
            *,
            axis_line_visibility: typing.Optional[builtins.str] = None,
            axis_offset: typing.Optional[builtins.str] = None,
            data_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDataOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            grid_line_visibility: typing.Optional[builtins.str] = None,
            scrollbar_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ScrollBarOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            tick_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisTickLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The display options for the axis label.

            :param axis_line_visibility: Determines whether or not the axis line is visible.
            :param axis_offset: The offset value that determines the starting placement of the axis within a visual's bounds.
            :param data_options: The data options for an axis.
            :param grid_line_visibility: Determines whether or not the grid line is visible.
            :param scrollbar_options: The scroll bar options for an axis.
            :param tick_label_options: The tick label options of an axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                # data_driven: Any
                
                axis_display_options_property = quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                    axis_line_visibility="axisLineVisibility",
                    axis_offset="axisOffset",
                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                            missing_date_visibility="missingDateVisibility"
                        ),
                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                data_driven=data_driven,
                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                    maximum=123,
                                    minimum=123
                                )
                            ),
                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                    step_count=123,
                                    step_size=123
                                ),
                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                    base=123
                                )
                            )
                        )
                    ),
                    grid_line_visibility="gridLineVisibility",
                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                        visibility="visibility",
                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                from=123,
                                to=123
                            )
                        )
                    ),
                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        ),
                        rotation_angle=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1ce4112654b0cd5421008601c76af6b776bbd67f39c758fb78c8f8dc12fe8eb4)
                check_type(argname="argument axis_line_visibility", value=axis_line_visibility, expected_type=type_hints["axis_line_visibility"])
                check_type(argname="argument axis_offset", value=axis_offset, expected_type=type_hints["axis_offset"])
                check_type(argname="argument data_options", value=data_options, expected_type=type_hints["data_options"])
                check_type(argname="argument grid_line_visibility", value=grid_line_visibility, expected_type=type_hints["grid_line_visibility"])
                check_type(argname="argument scrollbar_options", value=scrollbar_options, expected_type=type_hints["scrollbar_options"])
                check_type(argname="argument tick_label_options", value=tick_label_options, expected_type=type_hints["tick_label_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if axis_line_visibility is not None:
                self._values["axis_line_visibility"] = axis_line_visibility
            if axis_offset is not None:
                self._values["axis_offset"] = axis_offset
            if data_options is not None:
                self._values["data_options"] = data_options
            if grid_line_visibility is not None:
                self._values["grid_line_visibility"] = grid_line_visibility
            if scrollbar_options is not None:
                self._values["scrollbar_options"] = scrollbar_options
            if tick_label_options is not None:
                self._values["tick_label_options"] = tick_label_options

        @builtins.property
        def axis_line_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines whether or not the axis line is visible.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axislinevisibility
            '''
            result = self._values.get("axis_line_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def axis_offset(self) -> typing.Optional[builtins.str]:
            '''The offset value that determines the starting placement of the axis within a visual's bounds.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axisoffset
            '''
            result = self._values.get("axis_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def data_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDataOptionsProperty"]]:
            '''The data options for an axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-dataoptions
            '''
            result = self._values.get("data_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDataOptionsProperty"]], result)

        @builtins.property
        def grid_line_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines whether or not the grid line is visible.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-gridlinevisibility
            '''
            result = self._values.get("grid_line_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scrollbar_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ScrollBarOptionsProperty"]]:
            '''The scroll bar options for an axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-scrollbaroptions
            '''
            result = self._values.get("scrollbar_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ScrollBarOptionsProperty"]], result)

        @builtins.property
        def tick_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisTickLabelOptionsProperty"]]:
            '''The tick label options of an axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-ticklabeloptions
            '''
            result = self._values.get("tick_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisTickLabelOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisDisplayOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayRangeProperty",
        jsii_struct_bases=[],
        name_mapping={"data_driven": "dataDriven", "min_max": "minMax"},
    )
    class AxisDisplayRangeProperty:
        def __init__(
            self,
            *,
            data_driven: typing.Any = None,
            min_max: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayMinMaxRangeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The range setup of a numeric axis display range.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param data_driven: The data-driven setup of an axis display range.
            :param min_max: The minimum and maximum setup of an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                # data_driven: Any
                
                axis_display_range_property = quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                    data_driven=data_driven,
                    min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                        maximum=123,
                        minimum=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9d1f3cfb0e15cf882a7641e844dead6be56b0b912c5ad84ca6fbeb1a3f6708e2)
                check_type(argname="argument data_driven", value=data_driven, expected_type=type_hints["data_driven"])
                check_type(argname="argument min_max", value=min_max, expected_type=type_hints["min_max"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if data_driven is not None:
                self._values["data_driven"] = data_driven
            if min_max is not None:
                self._values["min_max"] = min_max

        @builtins.property
        def data_driven(self) -> typing.Any:
            '''The data-driven setup of an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-datadriven
            '''
            result = self._values.get("data_driven")
            return typing.cast(typing.Any, result)

        @builtins.property
        def min_max(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayMinMaxRangeProperty"]]:
            '''The minimum and maximum setup of an axis display range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-minmax
            '''
            result = self._values.get("min_max")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayMinMaxRangeProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisDisplayRangeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "apply_to": "applyTo",
            "custom_label": "customLabel",
            "font_configuration": "fontConfiguration",
        },
    )
    class AxisLabelOptionsProperty:
        def __init__(
            self,
            *,
            apply_to: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisLabelReferenceOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            custom_label: typing.Optional[builtins.str] = None,
            font_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FontConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The label options for a chart axis.

            You must specify the field that the label is targeted to.

            :param apply_to: The options that indicate which field the label belongs to.
            :param custom_label: The text for the axis label.
            :param font_configuration: The font configuration of the axis label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_label_options_property = quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                    apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        field_id="fieldId"
                    ),
                    custom_label="customLabel",
                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                        font_color="fontColor",
                        font_decoration="fontDecoration",
                        font_family="fontFamily",
                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                            absolute="absolute",
                            relative="relative"
                        ),
                        font_style="fontStyle",
                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                            name="name"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bca9702cb7afaa3a7f9b3ad0e4acb34452f17e91211faa3d6f1d04077ab66e87)
                check_type(argname="argument apply_to", value=apply_to, expected_type=type_hints["apply_to"])
                check_type(argname="argument custom_label", value=custom_label, expected_type=type_hints["custom_label"])
                check_type(argname="argument font_configuration", value=font_configuration, expected_type=type_hints["font_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if apply_to is not None:
                self._values["apply_to"] = apply_to
            if custom_label is not None:
                self._values["custom_label"] = custom_label
            if font_configuration is not None:
                self._values["font_configuration"] = font_configuration

        @builtins.property
        def apply_to(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLabelReferenceOptionsProperty"]]:
            '''The options that indicate which field the label belongs to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-applyto
            '''
            result = self._values.get("apply_to")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLabelReferenceOptionsProperty"]], result)

        @builtins.property
        def custom_label(self) -> typing.Optional[builtins.str]:
            '''The text for the axis label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-customlabel
            '''
            result = self._values.get("custom_label")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def font_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FontConfigurationProperty"]]:
            '''The font configuration of the axis label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-fontconfiguration
            '''
            result = self._values.get("font_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FontConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisLabelOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"column": "column", "field_id": "fieldId"},
    )
    class AxisLabelReferenceOptionsProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            field_id: builtins.str,
        ) -> None:
            '''The reference that specifies where the axis label is applied to.

            :param column: The column that the axis label is targeted to.
            :param field_id: The field that the axis label is targeted to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_label_reference_options_property = quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    field_id="fieldId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5a41941fd4b6c34fbb36f8455884251f8e49d3a1bc0f3144be7b27b47f0d9a85)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "field_id": field_id,
            }

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that the axis label is targeted to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The field that the axis label is targeted to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisLabelReferenceOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLinearScaleProperty",
        jsii_struct_bases=[],
        name_mapping={"step_count": "stepCount", "step_size": "stepSize"},
    )
    class AxisLinearScaleProperty:
        def __init__(
            self,
            *,
            step_count: typing.Optional[jsii.Number] = None,
            step_size: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The liner axis scale setup.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param step_count: The step count setup of a linear axis.
            :param step_size: The step size setup of a linear axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_linear_scale_property = quicksight.CfnAnalysis.AxisLinearScaleProperty(
                    step_count=123,
                    step_size=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__de2ed81b442a112dc0e5d3f1eaa2866e34c18bd6582d5dfaf8da256fed592114)
                check_type(argname="argument step_count", value=step_count, expected_type=type_hints["step_count"])
                check_type(argname="argument step_size", value=step_size, expected_type=type_hints["step_size"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if step_count is not None:
                self._values["step_count"] = step_count
            if step_size is not None:
                self._values["step_size"] = step_size

        @builtins.property
        def step_count(self) -> typing.Optional[jsii.Number]:
            '''The step count setup of a linear axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepcount
            '''
            result = self._values.get("step_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def step_size(self) -> typing.Optional[jsii.Number]:
            '''The step size setup of a linear axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepsize
            '''
            result = self._values.get("step_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisLinearScaleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLogarithmicScaleProperty",
        jsii_struct_bases=[],
        name_mapping={"base": "base"},
    )
    class AxisLogarithmicScaleProperty:
        def __init__(self, *, base: typing.Optional[jsii.Number] = None) -> None:
            '''The logarithmic axis scale setup.

            :param base: The base setup of a logarithmic axis scale.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_logarithmic_scale_property = quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                    base=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__381902f283cd7b9a04480082e8bdb608c28e6b8d6c5de55e66eb320c97567350)
                check_type(argname="argument base", value=base, expected_type=type_hints["base"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if base is not None:
                self._values["base"] = base

        @builtins.property
        def base(self) -> typing.Optional[jsii.Number]:
            '''The base setup of a logarithmic axis scale.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html#cfn-quicksight-analysis-axislogarithmicscale-base
            '''
            result = self._values.get("base")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisLogarithmicScaleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisScaleProperty",
        jsii_struct_bases=[],
        name_mapping={"linear": "linear", "logarithmic": "logarithmic"},
    )
    class AxisScaleProperty:
        def __init__(
            self,
            *,
            linear: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisLinearScaleProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            logarithmic: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisLogarithmicScaleProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The scale setup options for a numeric axis display.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param linear: The linear axis scale setup.
            :param logarithmic: The logarithmic axis scale setup.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_scale_property = quicksight.CfnAnalysis.AxisScaleProperty(
                    linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                        step_count=123,
                        step_size=123
                    ),
                    logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                        base=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0c88b551eac07288842d97071c3029b47d5623858616e1fe83f80d2048ec76e9)
                check_type(argname="argument linear", value=linear, expected_type=type_hints["linear"])
                check_type(argname="argument logarithmic", value=logarithmic, expected_type=type_hints["logarithmic"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if linear is not None:
                self._values["linear"] = linear
            if logarithmic is not None:
                self._values["logarithmic"] = logarithmic

        @builtins.property
        def linear(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLinearScaleProperty"]]:
            '''The linear axis scale setup.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-linear
            '''
            result = self._values.get("linear")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLinearScaleProperty"]], result)

        @builtins.property
        def logarithmic(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLogarithmicScaleProperty"]]:
            '''The logarithmic axis scale setup.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-logarithmic
            '''
            result = self._values.get("logarithmic")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLogarithmicScaleProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisScaleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisTickLabelOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "label_options": "labelOptions",
            "rotation_angle": "rotationAngle",
        },
    )
    class AxisTickLabelOptionsProperty:
        def __init__(
            self,
            *,
            label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rotation_angle: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The tick label options of an axis.

            :param label_options: Determines whether or not the axis ticks are visible.
            :param rotation_angle: The rotation angle of the axis tick labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                axis_tick_label_options_property = quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                    label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                        custom_label="customLabel",
                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                            font_color="fontColor",
                            font_decoration="fontDecoration",
                            font_family="fontFamily",
                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                absolute="absolute",
                                relative="relative"
                            ),
                            font_style="fontStyle",
                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                name="name"
                            )
                        ),
                        visibility="visibility"
                    ),
                    rotation_angle=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cc6f05f510c841613789e96111c71665c3690785353fb7564171d840cff188b8)
                check_type(argname="argument label_options", value=label_options, expected_type=type_hints["label_options"])
                check_type(argname="argument rotation_angle", value=rotation_angle, expected_type=type_hints["rotation_angle"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if label_options is not None:
                self._values["label_options"] = label_options
            if rotation_angle is not None:
                self._values["rotation_angle"] = rotation_angle

        @builtins.property
        def label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LabelOptionsProperty"]]:
            '''Determines whether or not the axis ticks are visible.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-labeloptions
            '''
            result = self._values.get("label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LabelOptionsProperty"]], result)

        @builtins.property
        def rotation_angle(self) -> typing.Optional[jsii.Number]:
            '''The rotation angle of the axis tick labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-rotationangle
            '''
            result = self._values.get("rotation_angle")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AxisTickLabelOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "category": "category",
            "colors": "colors",
            "small_multiples": "smallMultiples",
            "values": "values",
        },
    )
    class BarChartAggregatedFieldWellsProperty:
        def __init__(
            self,
            *,
            category: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            colors: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            small_multiples: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MeasureFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The aggregated field wells of a bar chart.

            :param category: The category (y-axis) field well of a bar chart.
            :param colors: The color (group/color) field well of a bar chart.
            :param small_multiples: The small multiples field well of a bar chart.
            :param values: The value field wells of a bar chart. Values are aggregated by category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__14d09f84e0529894a371328f931fac3530bd776eb35de0075819430e70ff8806)
                check_type(argname="argument category", value=category, expected_type=type_hints["category"])
                check_type(argname="argument colors", value=colors, expected_type=type_hints["colors"])
                check_type(argname="argument small_multiples", value=small_multiples, expected_type=type_hints["small_multiples"])
                check_type(argname="argument values", value=values, expected_type=type_hints["values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if category is not None:
                self._values["category"] = category
            if colors is not None:
                self._values["colors"] = colors
            if small_multiples is not None:
                self._values["small_multiples"] = small_multiples
            if values is not None:
                self._values["values"] = values

        @builtins.property
        def category(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The category (y-axis) field well of a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-category
            '''
            result = self._values.get("category")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def colors(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The color (group/color) field well of a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-colors
            '''
            result = self._values.get("colors")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def small_multiples(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The small multiples field well of a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-smallmultiples
            '''
            result = self._values.get("small_multiples")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]]:
            '''The value field wells of a bar chart.

            Values are aggregated by category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-values
            '''
            result = self._values.get("values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BarChartAggregatedFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bars_arrangement": "barsArrangement",
            "category_axis": "categoryAxis",
            "category_label_options": "categoryLabelOptions",
            "color_label_options": "colorLabelOptions",
            "contribution_analysis_defaults": "contributionAnalysisDefaults",
            "data_labels": "dataLabels",
            "field_wells": "fieldWells",
            "interactions": "interactions",
            "legend": "legend",
            "orientation": "orientation",
            "reference_lines": "referenceLines",
            "small_multiples_options": "smallMultiplesOptions",
            "sort_configuration": "sortConfiguration",
            "tooltip": "tooltip",
            "value_axis": "valueAxis",
            "value_label_options": "valueLabelOptions",
            "visual_palette": "visualPalette",
        },
    )
    class BarChartConfigurationProperty:
        def __init__(
            self,
            *,
            bars_arrangement: typing.Optional[builtins.str] = None,
            category_axis: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            color_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            contribution_analysis_defaults: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ContributionAnalysisDefaultProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            data_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BarChartFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            interactions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualInteractionOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            legend: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LegendOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            orientation: typing.Optional[builtins.str] = None,
            reference_lines: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ReferenceLineProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            small_multiples_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SmallMultiplesOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sort_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BarChartSortConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            tooltip: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TooltipOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            value_axis: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            value_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_palette: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualPaletteProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of a ``BarChartVisual`` .

            :param bars_arrangement: Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar that is used in the visual.
            :param category_axis: The label display options (grid line, range, scale, axis step) for bar chart category.
            :param category_label_options: The label options (label text, label visibility and sort icon visibility) for a bar chart.
            :param color_label_options: The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.
            :param contribution_analysis_defaults: The contribution analysis (anomaly configuration) setup of the visual.
            :param data_labels: The options that determine if visual data labels are displayed.
            :param field_wells: The field wells of the visual.
            :param interactions: The general visual interactions setup for a visual.
            :param legend: The legend display setup of the visual.
            :param orientation: The orientation of the bars in a bar chart visual. There are two valid values in this structure:. - ``HORIZONTAL`` : Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts. - ``VERTICAL`` : Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
            :param reference_lines: The reference line setup of the visual.
            :param small_multiples_options: The small multiples setup for the visual.
            :param sort_configuration: The sort configuration of a ``BarChartVisual`` .
            :param tooltip: The tooltip display setup of the visual.
            :param value_axis: The label display options (grid line, range, scale, axis step) for a bar chart value.
            :param value_label_options: The label options (label text, label visibility and sort icon visibility) for a bar chart value.
            :param visual_palette: The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f82e6ee1add2fdb859f27b13f529aafc1f0a7f416e16682c5d67e2df723a9e71)
                check_type(argname="argument bars_arrangement", value=bars_arrangement, expected_type=type_hints["bars_arrangement"])
                check_type(argname="argument category_axis", value=category_axis, expected_type=type_hints["category_axis"])
                check_type(argname="argument category_label_options", value=category_label_options, expected_type=type_hints["category_label_options"])
                check_type(argname="argument color_label_options", value=color_label_options, expected_type=type_hints["color_label_options"])
                check_type(argname="argument contribution_analysis_defaults", value=contribution_analysis_defaults, expected_type=type_hints["contribution_analysis_defaults"])
                check_type(argname="argument data_labels", value=data_labels, expected_type=type_hints["data_labels"])
                check_type(argname="argument field_wells", value=field_wells, expected_type=type_hints["field_wells"])
                check_type(argname="argument interactions", value=interactions, expected_type=type_hints["interactions"])
                check_type(argname="argument legend", value=legend, expected_type=type_hints["legend"])
                check_type(argname="argument orientation", value=orientation, expected_type=type_hints["orientation"])
                check_type(argname="argument reference_lines", value=reference_lines, expected_type=type_hints["reference_lines"])
                check_type(argname="argument small_multiples_options", value=small_multiples_options, expected_type=type_hints["small_multiples_options"])
                check_type(argname="argument sort_configuration", value=sort_configuration, expected_type=type_hints["sort_configuration"])
                check_type(argname="argument tooltip", value=tooltip, expected_type=type_hints["tooltip"])
                check_type(argname="argument value_axis", value=value_axis, expected_type=type_hints["value_axis"])
                check_type(argname="argument value_label_options", value=value_label_options, expected_type=type_hints["value_label_options"])
                check_type(argname="argument visual_palette", value=visual_palette, expected_type=type_hints["visual_palette"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if bars_arrangement is not None:
                self._values["bars_arrangement"] = bars_arrangement
            if category_axis is not None:
                self._values["category_axis"] = category_axis
            if category_label_options is not None:
                self._values["category_label_options"] = category_label_options
            if color_label_options is not None:
                self._values["color_label_options"] = color_label_options
            if contribution_analysis_defaults is not None:
                self._values["contribution_analysis_defaults"] = contribution_analysis_defaults
            if data_labels is not None:
                self._values["data_labels"] = data_labels
            if field_wells is not None:
                self._values["field_wells"] = field_wells
            if interactions is not None:
                self._values["interactions"] = interactions
            if legend is not None:
                self._values["legend"] = legend
            if orientation is not None:
                self._values["orientation"] = orientation
            if reference_lines is not None:
                self._values["reference_lines"] = reference_lines
            if small_multiples_options is not None:
                self._values["small_multiples_options"] = small_multiples_options
            if sort_configuration is not None:
                self._values["sort_configuration"] = sort_configuration
            if tooltip is not None:
                self._values["tooltip"] = tooltip
            if value_axis is not None:
                self._values["value_axis"] = value_axis
            if value_label_options is not None:
                self._values["value_label_options"] = value_label_options
            if visual_palette is not None:
                self._values["visual_palette"] = visual_palette

        @builtins.property
        def bars_arrangement(self) -> typing.Optional[builtins.str]:
            '''Determines the arrangement of the bars.

            The orientation and arrangement of bars determine the type of bar that is used in the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-barsarrangement
            '''
            result = self._values.get("bars_arrangement")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def category_axis(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, axis step) for bar chart category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categoryaxis
            '''
            result = self._values.get("category_axis")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def category_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility and sort icon visibility) for a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categorylabeloptions
            '''
            result = self._values.get("category_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def color_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-colorlabeloptions
            '''
            result = self._values.get("color_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def contribution_analysis_defaults(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ContributionAnalysisDefaultProperty"]]]]:
            '''The contribution analysis (anomaly configuration) setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-contributionanalysisdefaults
            '''
            result = self._values.get("contribution_analysis_defaults")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ContributionAnalysisDefaultProperty"]]]], result)

        @builtins.property
        def data_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]]:
            '''The options that determine if visual data labels are displayed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-datalabels
            '''
            result = self._values.get("data_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]], result)

        @builtins.property
        def field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartFieldWellsProperty"]]:
            '''The field wells of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-fieldwells
            '''
            result = self._values.get("field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartFieldWellsProperty"]], result)

        @builtins.property
        def interactions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]]:
            '''The general visual interactions setup for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-interactions
            '''
            result = self._values.get("interactions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]], result)

        @builtins.property
        def legend(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]]:
            '''The legend display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-legend
            '''
            result = self._values.get("legend")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]], result)

        @builtins.property
        def orientation(self) -> typing.Optional[builtins.str]:
            '''The orientation of the bars in a bar chart visual. There are two valid values in this structure:.

            - ``HORIZONTAL`` : Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
            - ``VERTICAL`` : Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-orientation
            '''
            result = self._values.get("orientation")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def reference_lines(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]]:
            '''The reference line setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-referencelines
            '''
            result = self._values.get("reference_lines")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]], result)

        @builtins.property
        def small_multiples_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SmallMultiplesOptionsProperty"]]:
            '''The small multiples setup for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-smallmultiplesoptions
            '''
            result = self._values.get("small_multiples_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SmallMultiplesOptionsProperty"]], result)

        @builtins.property
        def sort_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartSortConfigurationProperty"]]:
            '''The sort configuration of a ``BarChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-sortconfiguration
            '''
            result = self._values.get("sort_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartSortConfigurationProperty"]], result)

        @builtins.property
        def tooltip(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]]:
            '''The tooltip display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-tooltip
            '''
            result = self._values.get("tooltip")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]], result)

        @builtins.property
        def value_axis(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, axis step) for a bar chart value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valueaxis
            '''
            result = self._values.get("value_axis")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def value_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility and sort icon visibility) for a bar chart value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valuelabeloptions
            '''
            result = self._values.get("value_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def visual_palette(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]]:
            '''The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-visualpalette
            '''
            result = self._values.get("visual_palette")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BarChartConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bar_chart_aggregated_field_wells": "barChartAggregatedFieldWells",
        },
    )
    class BarChartFieldWellsProperty:
        def __init__(
            self,
            *,
            bar_chart_aggregated_field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BarChartAggregatedFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The field wells of a ``BarChartVisual`` .

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param bar_chart_aggregated_field_wells: The aggregated field wells of a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__57e94b3218a71f9a221c4546912c0125a1236895085ccf54fe565d569bf21a63)
                check_type(argname="argument bar_chart_aggregated_field_wells", value=bar_chart_aggregated_field_wells, expected_type=type_hints["bar_chart_aggregated_field_wells"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if bar_chart_aggregated_field_wells is not None:
                self._values["bar_chart_aggregated_field_wells"] = bar_chart_aggregated_field_wells

        @builtins.property
        def bar_chart_aggregated_field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartAggregatedFieldWellsProperty"]]:
            '''The aggregated field wells of a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html#cfn-quicksight-analysis-barchartfieldwells-barchartaggregatedfieldwells
            '''
            result = self._values.get("bar_chart_aggregated_field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartAggregatedFieldWellsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BarChartFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartSortConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "category_items_limit": "categoryItemsLimit",
            "category_sort": "categorySort",
            "color_items_limit": "colorItemsLimit",
            "color_sort": "colorSort",
            "small_multiples_limit_configuration": "smallMultiplesLimitConfiguration",
            "small_multiples_sort": "smallMultiplesSort",
        },
    )
    class BarChartSortConfigurationProperty:
        def __init__(
            self,
            *,
            category_items_limit: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ItemsLimitConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            color_items_limit: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ItemsLimitConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            color_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            small_multiples_limit_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ItemsLimitConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            small_multiples_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''sort-configuration-description.

            :param category_items_limit: The limit on the number of categories displayed in a bar chart.
            :param category_sort: The sort configuration of category fields.
            :param color_items_limit: The limit on the number of values displayed in a bar chart.
            :param color_sort: The sort configuration of color fields in a bar chart.
            :param small_multiples_limit_configuration: The limit on the number of small multiples panels that are displayed.
            :param small_multiples_sort: The sort configuration of the small multiples field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                bar_chart_sort_configuration_property = quicksight.CfnAnalysis.BarChartSortConfigurationProperty(
                    category_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                        items_limit=123,
                        other_categories="otherCategories"
                    ),
                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )],
                    color_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                        items_limit=123,
                        other_categories="otherCategories"
                    ),
                    color_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )],
                    small_multiples_limit_configuration=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                        items_limit=123,
                        other_categories="otherCategories"
                    ),
                    small_multiples_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9bfd09e91f4971d3675d55e8b7c84cc7b2d5d2b84f29fec31127f56611a737cf)
                check_type(argname="argument category_items_limit", value=category_items_limit, expected_type=type_hints["category_items_limit"])
                check_type(argname="argument category_sort", value=category_sort, expected_type=type_hints["category_sort"])
                check_type(argname="argument color_items_limit", value=color_items_limit, expected_type=type_hints["color_items_limit"])
                check_type(argname="argument color_sort", value=color_sort, expected_type=type_hints["color_sort"])
                check_type(argname="argument small_multiples_limit_configuration", value=small_multiples_limit_configuration, expected_type=type_hints["small_multiples_limit_configuration"])
                check_type(argname="argument small_multiples_sort", value=small_multiples_sort, expected_type=type_hints["small_multiples_sort"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if category_items_limit is not None:
                self._values["category_items_limit"] = category_items_limit
            if category_sort is not None:
                self._values["category_sort"] = category_sort
            if color_items_limit is not None:
                self._values["color_items_limit"] = color_items_limit
            if color_sort is not None:
                self._values["color_sort"] = color_sort
            if small_multiples_limit_configuration is not None:
                self._values["small_multiples_limit_configuration"] = small_multiples_limit_configuration
            if small_multiples_sort is not None:
                self._values["small_multiples_sort"] = small_multiples_sort

        @builtins.property
        def category_items_limit(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]]:
            '''The limit on the number of categories displayed in a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categoryitemslimit
            '''
            result = self._values.get("category_items_limit")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]], result)

        @builtins.property
        def category_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of category fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categorysort
            '''
            result = self._values.get("category_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        @builtins.property
        def color_items_limit(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]]:
            '''The limit on the number of values displayed in a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-coloritemslimit
            '''
            result = self._values.get("color_items_limit")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]], result)

        @builtins.property
        def color_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of color fields in a bar chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-colorsort
            '''
            result = self._values.get("color_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        @builtins.property
        def small_multiples_limit_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]]:
            '''The limit on the number of small multiples panels that are displayed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultipleslimitconfiguration
            '''
            result = self._values.get("small_multiples_limit_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]], result)

        @builtins.property
        def small_multiples_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of the small multiples field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultiplessort
            '''
            result = self._values.get("small_multiples_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BarChartSortConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartVisualProperty",
        jsii_struct_bases=[],
        name_mapping={
            "visual_id": "visualId",
            "actions": "actions",
            "chart_configuration": "chartConfiguration",
            "column_hierarchies": "columnHierarchies",
            "subtitle": "subtitle",
            "title": "title",
            "visual_content_alt_text": "visualContentAltText",
        },
    )
    class BarChartVisualProperty:
        def __init__(
            self,
            *,
            visual_id: builtins.str,
            actions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualCustomActionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            chart_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BarChartConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            column_hierarchies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            subtitle: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualSubtitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            title: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualTitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_content_alt_text: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A bar chart.

            The ``BarChartVisual`` structure describes a visual that is a member of the bar chart family. The following charts can be described using this structure:

            - Horizontal bar chart
            - Vertical bar chart
            - Horizontal stacked bar chart
            - Vertical stacked bar chart
            - Horizontal stacked 100% bar chart
            - Vertical stacked 100% bar chart

            For more information, see `Using bar charts <https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html>`_ in the *Amazon QuickSight User Guide* .

            :param visual_id: The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
            :param actions: The list of custom actions that are configured for a visual.
            :param chart_configuration: The configuration settings of the visual.
            :param column_hierarchies: The column hierarchy that is used during drill-downs and drill-ups.
            :param subtitle: The subtitle that is displayed on the visual.
            :param title: The title that is displayed on the visual.
            :param visual_content_alt_text: The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad3846bbad8b69a74a650c9a66c96d4c5617a1d4379c57502d538c2439700765)
                check_type(argname="argument visual_id", value=visual_id, expected_type=type_hints["visual_id"])
                check_type(argname="argument actions", value=actions, expected_type=type_hints["actions"])
                check_type(argname="argument chart_configuration", value=chart_configuration, expected_type=type_hints["chart_configuration"])
                check_type(argname="argument column_hierarchies", value=column_hierarchies, expected_type=type_hints["column_hierarchies"])
                check_type(argname="argument subtitle", value=subtitle, expected_type=type_hints["subtitle"])
                check_type(argname="argument title", value=title, expected_type=type_hints["title"])
                check_type(argname="argument visual_content_alt_text", value=visual_content_alt_text, expected_type=type_hints["visual_content_alt_text"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "visual_id": visual_id,
            }
            if actions is not None:
                self._values["actions"] = actions
            if chart_configuration is not None:
                self._values["chart_configuration"] = chart_configuration
            if column_hierarchies is not None:
                self._values["column_hierarchies"] = column_hierarchies
            if subtitle is not None:
                self._values["subtitle"] = subtitle
            if title is not None:
                self._values["title"] = title
            if visual_content_alt_text is not None:
                self._values["visual_content_alt_text"] = visual_content_alt_text

        @builtins.property
        def visual_id(self) -> builtins.str:
            '''The unique identifier of a visual.

            This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualid
            '''
            result = self._values.get("visual_id")
            assert result is not None, "Required property 'visual_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def actions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]]:
            '''The list of custom actions that are configured for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-actions
            '''
            result = self._values.get("actions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]], result)

        @builtins.property
        def chart_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartConfigurationProperty"]]:
            '''The configuration settings of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-chartconfiguration
            '''
            result = self._values.get("chart_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BarChartConfigurationProperty"]], result)

        @builtins.property
        def column_hierarchies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]]:
            '''The column hierarchy that is used during drill-downs and drill-ups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-columnhierarchies
            '''
            result = self._values.get("column_hierarchies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]], result)

        @builtins.property
        def subtitle(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]]:
            '''The subtitle that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-subtitle
            '''
            result = self._values.get("subtitle")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]], result)

        @builtins.property
        def title(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]]:
            '''The title that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-title
            '''
            result = self._values.get("title")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]], result)

        @builtins.property
        def visual_content_alt_text(self) -> typing.Optional[builtins.str]:
            '''The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualcontentalttext
            '''
            result = self._values.get("visual_content_alt_text")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BarChartVisualProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BinCountOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"value": "value"},
    )
    class BinCountOptionsProperty:
        def __init__(self, *, value: typing.Optional[jsii.Number] = None) -> None:
            '''The options that determine the bin count of a histogram.

            :param value: The options that determine the bin count value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                bin_count_options_property = quicksight.CfnAnalysis.BinCountOptionsProperty(
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1c9a0dbb5a09986420c28ddb1fa6dbe46b74b4966dcd5e2134c71ddfe180df39)
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if value is not None:
                self._values["value"] = value

        @builtins.property
        def value(self) -> typing.Optional[jsii.Number]:
            '''The options that determine the bin count value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html#cfn-quicksight-analysis-bincountoptions-value
            '''
            result = self._values.get("value")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BinCountOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BinWidthOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"bin_count_limit": "binCountLimit", "value": "value"},
    )
    class BinWidthOptionsProperty:
        def __init__(
            self,
            *,
            bin_count_limit: typing.Optional[jsii.Number] = None,
            value: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The options that determine the bin width of a histogram.

            :param bin_count_limit: The options that determine the bin count limit.
            :param value: The options that determine the bin width value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                bin_width_options_property = quicksight.CfnAnalysis.BinWidthOptionsProperty(
                    bin_count_limit=123,
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5bf9a31675e53c4ed03f804fe10a9e945f4cb2d3265ed6fcb315ab9a91b63087)
                check_type(argname="argument bin_count_limit", value=bin_count_limit, expected_type=type_hints["bin_count_limit"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if bin_count_limit is not None:
                self._values["bin_count_limit"] = bin_count_limit
            if value is not None:
                self._values["value"] = value

        @builtins.property
        def bin_count_limit(self) -> typing.Optional[jsii.Number]:
            '''The options that determine the bin count limit.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-bincountlimit
            '''
            result = self._values.get("bin_count_limit")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def value(self) -> typing.Optional[jsii.Number]:
            '''The options that determine the bin width value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-value
            '''
            result = self._values.get("value")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BinWidthOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "content": "content",
            "section_id": "sectionId",
            "page_break_configuration": "pageBreakConfiguration",
            "repeat_configuration": "repeatConfiguration",
            "style": "style",
        },
    )
    class BodySectionConfigurationProperty:
        def __init__(
            self,
            *,
            content: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionContentProperty", typing.Dict[builtins.str, typing.Any]]],
            section_id: builtins.str,
            page_break_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SectionPageBreakConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            repeat_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionRepeatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            style: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SectionStyleProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of a body section.

            :param content: The configuration of content in a body section.
            :param section_id: The unique identifier of a body section.
            :param page_break_configuration: The configuration of a page break for a section.
            :param repeat_configuration: Describes the configurations that are required to declare a section as repeating.
            :param style: The style options of a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_configuration_property = quicksight.CfnAnalysis.BodySectionConfigurationProperty(
                    content=quicksight.CfnAnalysis.BodySectionContentProperty(
                        layout=quicksight.CfnAnalysis.SectionLayoutConfigurationProperty(
                            free_form_layout=quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty(
                                elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                    element_id="elementId",
                                    element_type="elementType",
                                    height="height",
                                    width="width",
                                    x_axis_location="xAxisLocation",
                                    y_axis_location="yAxisLocation",
                
                                    # the properties below are optional
                                    background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                        visibility="visibility"
                                    ),
                                    rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                        configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                            visibility="visibility"
                                        ),
                                        expression="expression"
                                    )],
                                    selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    visibility="visibility"
                                )]
                            )
                        )
                    ),
                    section_id="sectionId",
                
                    # the properties below are optional
                    page_break_configuration=quicksight.CfnAnalysis.SectionPageBreakConfigurationProperty(
                        after=quicksight.CfnAnalysis.SectionAfterPageBreakProperty(
                            status="status"
                        )
                    ),
                    repeat_configuration=quicksight.CfnAnalysis.BodySectionRepeatConfigurationProperty(
                        dimension_configurations=[quicksight.CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty(
                            dynamic_category_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                
                                # the properties below are optional
                                limit=123,
                                sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                                    direction="direction",
                                    sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                
                                    # the properties below are optional
                                    aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                        attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                            simple_attribute_aggregation="simpleAttributeAggregation",
                                            value_for_multiple_values="valueForMultipleValues"
                                        ),
                                        categorical_aggregation_function="categoricalAggregationFunction",
                                        date_aggregation_function="dateAggregationFunction",
                                        numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                            percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                percentile_value=123
                                            ),
                                            simple_numerical_aggregation="simpleNumericalAggregation"
                                        )
                                    )
                                )]
                            ),
                            dynamic_numeric_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                
                                # the properties below are optional
                                limit=123,
                                sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                                    direction="direction",
                                    sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                
                                    # the properties below are optional
                                    aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                        attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                            simple_attribute_aggregation="simpleAttributeAggregation",
                                            value_for_multiple_values="valueForMultipleValues"
                                        ),
                                        categorical_aggregation_function="categoricalAggregationFunction",
                                        date_aggregation_function="dateAggregationFunction",
                                        numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                            percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                percentile_value=123
                                            ),
                                            simple_numerical_aggregation="simpleNumericalAggregation"
                                        )
                                    )
                                )]
                            )
                        )],
                        non_repeating_visuals=["nonRepeatingVisuals"],
                        page_break_configuration=quicksight.CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty(
                            after=quicksight.CfnAnalysis.SectionAfterPageBreakProperty(
                                status="status"
                            )
                        )
                    ),
                    style=quicksight.CfnAnalysis.SectionStyleProperty(
                        height="height",
                        padding=quicksight.CfnAnalysis.SpacingProperty(
                            bottom="bottom",
                            left="left",
                            right="right",
                            top="top"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2470326817442ac7529c78646a6f521d33b36a0b4ce5470a868a1d02e2c13a38)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument section_id", value=section_id, expected_type=type_hints["section_id"])
                check_type(argname="argument page_break_configuration", value=page_break_configuration, expected_type=type_hints["page_break_configuration"])
                check_type(argname="argument repeat_configuration", value=repeat_configuration, expected_type=type_hints["repeat_configuration"])
                check_type(argname="argument style", value=style, expected_type=type_hints["style"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "section_id": section_id,
            }
            if page_break_configuration is not None:
                self._values["page_break_configuration"] = page_break_configuration
            if repeat_configuration is not None:
                self._values["repeat_configuration"] = repeat_configuration
            if style is not None:
                self._values["style"] = style

        @builtins.property
        def content(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionContentProperty"]:
            '''The configuration of content in a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionContentProperty"], result)

        @builtins.property
        def section_id(self) -> builtins.str:
            '''The unique identifier of a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-sectionid
            '''
            result = self._values.get("section_id")
            assert result is not None, "Required property 'section_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def page_break_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionPageBreakConfigurationProperty"]]:
            '''The configuration of a page break for a section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-pagebreakconfiguration
            '''
            result = self._values.get("page_break_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionPageBreakConfigurationProperty"]], result)

        @builtins.property
        def repeat_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatConfigurationProperty"]]:
            '''Describes the configurations that are required to declare a section as repeating.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-repeatconfiguration
            '''
            result = self._values.get("repeat_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatConfigurationProperty"]], result)

        @builtins.property
        def style(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionStyleProperty"]]:
            '''The style options of a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-style
            '''
            result = self._values.get("style")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionStyleProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionContentProperty",
        jsii_struct_bases=[],
        name_mapping={"layout": "layout"},
    )
    class BodySectionContentProperty:
        def __init__(
            self,
            *,
            layout: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SectionLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of content in a body section.

            :param layout: The layout configuration of a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_content_property = quicksight.CfnAnalysis.BodySectionContentProperty(
                    layout=quicksight.CfnAnalysis.SectionLayoutConfigurationProperty(
                        free_form_layout=quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty(
                            elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                element_id="elementId",
                                element_type="elementType",
                                height="height",
                                width="width",
                                x_axis_location="xAxisLocation",
                                y_axis_location="yAxisLocation",
                
                                # the properties below are optional
                                background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                    color="color",
                                    visibility="visibility"
                                ),
                                border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                    color="color",
                                    visibility="visibility"
                                ),
                                loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                    visibility="visibility"
                                ),
                                rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                    configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                        visibility="visibility"
                                    ),
                                    expression="expression"
                                )],
                                selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                    color="color",
                                    visibility="visibility"
                                ),
                                visibility="visibility"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__52862e0cf0f944ba3a4d77a6336d986d75842281f1d4a4497c0ea8035c3aa5d7)
                check_type(argname="argument layout", value=layout, expected_type=type_hints["layout"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if layout is not None:
                self._values["layout"] = layout

        @builtins.property
        def layout(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionLayoutConfigurationProperty"]]:
            '''The layout configuration of a body section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html#cfn-quicksight-analysis-bodysectioncontent-layout
            '''
            result = self._values.get("layout")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionLayoutConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionContentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "limit": "limit",
            "sort_by_metrics": "sortByMetrics",
        },
    )
    class BodySectionDynamicCategoryDimensionConfigurationProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            limit: typing.Optional[jsii.Number] = None,
            sort_by_metrics: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnSortProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Describes the *Category* dataset column and constraints for the dynamic values used to repeat the contents of a section.

            :param column: 
            :param limit: Number of values to use from the column for repetition.
            :param sort_by_metrics: Sort criteria on the column values that you use for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_dynamic_category_dimension_configuration_property = quicksight.CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                
                    # the properties below are optional
                    limit=123,
                    sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                        direction="direction",
                        sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                            attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                simple_attribute_aggregation="simpleAttributeAggregation",
                                value_for_multiple_values="valueForMultipleValues"
                            ),
                            categorical_aggregation_function="categoricalAggregationFunction",
                            date_aggregation_function="dateAggregationFunction",
                            numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                    percentile_value=123
                                ),
                                simple_numerical_aggregation="simpleNumericalAggregation"
                            )
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e3508d1ff4aa7dcf90ac8b3ab430f422a778a1454c7d7fac21cc2dd61ea08cb8)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument sort_by_metrics", value=sort_by_metrics, expected_type=type_hints["sort_by_metrics"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
            }
            if limit is not None:
                self._values["limit"] = limit
            if sort_by_metrics is not None:
                self._values["sort_by_metrics"] = sort_by_metrics

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def limit(self) -> typing.Optional[jsii.Number]:
            '''Number of values to use from the column for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-limit
            '''
            result = self._values.get("limit")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def sort_by_metrics(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnSortProperty"]]]]:
            '''Sort criteria on the column values that you use for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-sortbymetrics
            '''
            result = self._values.get("sort_by_metrics")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnSortProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionDynamicCategoryDimensionConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "limit": "limit",
            "sort_by_metrics": "sortByMetrics",
        },
    )
    class BodySectionDynamicNumericDimensionConfigurationProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            limit: typing.Optional[jsii.Number] = None,
            sort_by_metrics: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnSortProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Describes the *Numeric* dataset column and constraints for the dynamic values used to repeat the contents of a section.

            :param column: 
            :param limit: Number of values to use from the column for repetition.
            :param sort_by_metrics: Sort criteria on the column values that you use for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_dynamic_numeric_dimension_configuration_property = quicksight.CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                
                    # the properties below are optional
                    limit=123,
                    sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                        direction="direction",
                        sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                            attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                simple_attribute_aggregation="simpleAttributeAggregation",
                                value_for_multiple_values="valueForMultipleValues"
                            ),
                            categorical_aggregation_function="categoricalAggregationFunction",
                            date_aggregation_function="dateAggregationFunction",
                            numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                    percentile_value=123
                                ),
                                simple_numerical_aggregation="simpleNumericalAggregation"
                            )
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5af65aac7b9a27d718138625a8d7f7654c0d3af2d105336da4cdad51590aba90)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument sort_by_metrics", value=sort_by_metrics, expected_type=type_hints["sort_by_metrics"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
            }
            if limit is not None:
                self._values["limit"] = limit
            if sort_by_metrics is not None:
                self._values["sort_by_metrics"] = sort_by_metrics

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def limit(self) -> typing.Optional[jsii.Number]:
            '''Number of values to use from the column for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-limit
            '''
            result = self._values.get("limit")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def sort_by_metrics(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnSortProperty"]]]]:
            '''Sort criteria on the column values that you use for repetition.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-sortbymetrics
            '''
            result = self._values.get("sort_by_metrics")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnSortProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionDynamicNumericDimensionConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionRepeatConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "dimension_configurations": "dimensionConfigurations",
            "non_repeating_visuals": "nonRepeatingVisuals",
            "page_break_configuration": "pageBreakConfiguration",
        },
    )
    class BodySectionRepeatConfigurationProperty:
        def __init__(
            self,
            *,
            dimension_configurations: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            non_repeating_visuals: typing.Optional[typing.Sequence[builtins.str]] = None,
            page_break_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Describes the configurations that are required to declare a section as repeating.

            :param dimension_configurations: List of ``BodySectionRepeatDimensionConfiguration`` values that describe the dataset column and constraints for the column used to repeat the contents of a section.
            :param non_repeating_visuals: List of visuals to exclude from repetition in repeating sections. The visuals will render identically, and ignore the repeating configurations in all repeating instances.
            :param page_break_configuration: Page break configuration to apply for each repeating instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_repeat_configuration_property = quicksight.CfnAnalysis.BodySectionRepeatConfigurationProperty(
                    dimension_configurations=[quicksight.CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty(
                        dynamic_category_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            limit=123,
                            sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                                direction="direction",
                                sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                
                                # the properties below are optional
                                aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                    attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                        simple_attribute_aggregation="simpleAttributeAggregation",
                                        value_for_multiple_values="valueForMultipleValues"
                                    ),
                                    categorical_aggregation_function="categoricalAggregationFunction",
                                    date_aggregation_function="dateAggregationFunction",
                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                            percentile_value=123
                                        ),
                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                    )
                                )
                            )]
                        ),
                        dynamic_numeric_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            limit=123,
                            sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                                direction="direction",
                                sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                
                                # the properties below are optional
                                aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                    attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                        simple_attribute_aggregation="simpleAttributeAggregation",
                                        value_for_multiple_values="valueForMultipleValues"
                                    ),
                                    categorical_aggregation_function="categoricalAggregationFunction",
                                    date_aggregation_function="dateAggregationFunction",
                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                            percentile_value=123
                                        ),
                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                    )
                                )
                            )]
                        )
                    )],
                    non_repeating_visuals=["nonRepeatingVisuals"],
                    page_break_configuration=quicksight.CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty(
                        after=quicksight.CfnAnalysis.SectionAfterPageBreakProperty(
                            status="status"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__85bb9f3e242375b72691e17727acfe4b72929137d664cdf47a3f186017bbb0ce)
                check_type(argname="argument dimension_configurations", value=dimension_configurations, expected_type=type_hints["dimension_configurations"])
                check_type(argname="argument non_repeating_visuals", value=non_repeating_visuals, expected_type=type_hints["non_repeating_visuals"])
                check_type(argname="argument page_break_configuration", value=page_break_configuration, expected_type=type_hints["page_break_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if dimension_configurations is not None:
                self._values["dimension_configurations"] = dimension_configurations
            if non_repeating_visuals is not None:
                self._values["non_repeating_visuals"] = non_repeating_visuals
            if page_break_configuration is not None:
                self._values["page_break_configuration"] = page_break_configuration

        @builtins.property
        def dimension_configurations(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty"]]]]:
            '''List of ``BodySectionRepeatDimensionConfiguration`` values that describe the dataset column and constraints for the column used to repeat the contents of a section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-dimensionconfigurations
            '''
            result = self._values.get("dimension_configurations")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty"]]]], result)

        @builtins.property
        def non_repeating_visuals(self) -> typing.Optional[typing.List[builtins.str]]:
            '''List of visuals to exclude from repetition in repeating sections.

            The visuals will render identically, and ignore the repeating configurations in all repeating instances.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-nonrepeatingvisuals
            '''
            result = self._values.get("non_repeating_visuals")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def page_break_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty"]]:
            '''Page break configuration to apply for each repeating instance.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-pagebreakconfiguration
            '''
            result = self._values.get("page_break_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionRepeatConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "dynamic_category_dimension_configuration": "dynamicCategoryDimensionConfiguration",
            "dynamic_numeric_dimension_configuration": "dynamicNumericDimensionConfiguration",
        },
    )
    class BodySectionRepeatDimensionConfigurationProperty:
        def __init__(
            self,
            *,
            dynamic_category_dimension_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            dynamic_numeric_dimension_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Describes the dataset column and constraints for the dynamic values used to repeat the contents of a section.

            The dataset column is either *Category* or *Numeric* column configuration

            :param dynamic_category_dimension_configuration: Describes the *Category* dataset column and constraints around the dynamic values that will be used in repeating the section contents.
            :param dynamic_numeric_dimension_configuration: Describes the *Numeric* dataset column and constraints around the dynamic values used to repeat the contents of a section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_repeat_dimension_configuration_property = quicksight.CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty(
                    dynamic_category_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        limit=123,
                        sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        )]
                    ),
                    dynamic_numeric_dimension_configuration=quicksight.CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        limit=123,
                        sort_by_metrics=[quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__62d4f104efbe1aadac5d1456ed3cac127e0ac08a9cd1d64abf2df2819b99b226)
                check_type(argname="argument dynamic_category_dimension_configuration", value=dynamic_category_dimension_configuration, expected_type=type_hints["dynamic_category_dimension_configuration"])
                check_type(argname="argument dynamic_numeric_dimension_configuration", value=dynamic_numeric_dimension_configuration, expected_type=type_hints["dynamic_numeric_dimension_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if dynamic_category_dimension_configuration is not None:
                self._values["dynamic_category_dimension_configuration"] = dynamic_category_dimension_configuration
            if dynamic_numeric_dimension_configuration is not None:
                self._values["dynamic_numeric_dimension_configuration"] = dynamic_numeric_dimension_configuration

        @builtins.property
        def dynamic_category_dimension_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty"]]:
            '''Describes the *Category* dataset column and constraints around the dynamic values that will be used in repeating the section contents.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatdimensionconfiguration-dynamiccategorydimensionconfiguration
            '''
            result = self._values.get("dynamic_category_dimension_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty"]], result)

        @builtins.property
        def dynamic_numeric_dimension_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty"]]:
            '''Describes the *Numeric* dataset column and constraints around the dynamic values used to repeat the contents of a section.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatdimensionconfiguration-dynamicnumericdimensionconfiguration
            '''
            result = self._values.get("dynamic_numeric_dimension_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionRepeatDimensionConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"after": "after"},
    )
    class BodySectionRepeatPageBreakConfigurationProperty:
        def __init__(
            self,
            *,
            after: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SectionAfterPageBreakProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The page break configuration to apply for each repeating instance.

            :param after: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatpagebreakconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                body_section_repeat_page_break_configuration_property = quicksight.CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty(
                    after=quicksight.CfnAnalysis.SectionAfterPageBreakProperty(
                        status="status"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__85de2420247db2a052a0fe9b0a437d2ba79e82911563c8a84741abe832986787)
                check_type(argname="argument after", value=after, expected_type=type_hints["after"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if after is not None:
                self._values["after"] = after

        @builtins.property
        def after(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionAfterPageBreakProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatpagebreakconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatpagebreakconfiguration-after
            '''
            result = self._values.get("after")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionAfterPageBreakProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodySectionRepeatPageBreakConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={"group_by": "groupBy", "values": "values"},
    )
    class BoxPlotAggregatedFieldWellsProperty:
        def __init__(
            self,
            *,
            group_by: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MeasureFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The aggregated field well for a box plot.

            :param group_by: The group by field well of a box plot chart. Values are grouped based on group by fields.
            :param values: The value field well of a box plot chart. Values are aggregated based on group by fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fe1567634ff247e915bad385ea901faa429b429895c09a83d0322d4c7cd8bdff)
                check_type(argname="argument group_by", value=group_by, expected_type=type_hints["group_by"])
                check_type(argname="argument values", value=values, expected_type=type_hints["values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if group_by is not None:
                self._values["group_by"] = group_by
            if values is not None:
                self._values["values"] = values

        @builtins.property
        def group_by(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The group by field well of a box plot chart.

            Values are grouped based on group by fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-groupby
            '''
            result = self._values.get("group_by")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]]:
            '''The value field well of a box plot chart.

            Values are aggregated based on group by fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-values
            '''
            result = self._values.get("values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotAggregatedFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "box_plot_options": "boxPlotOptions",
            "category_axis": "categoryAxis",
            "category_label_options": "categoryLabelOptions",
            "field_wells": "fieldWells",
            "interactions": "interactions",
            "legend": "legend",
            "primary_y_axis_display_options": "primaryYAxisDisplayOptions",
            "primary_y_axis_label_options": "primaryYAxisLabelOptions",
            "reference_lines": "referenceLines",
            "sort_configuration": "sortConfiguration",
            "tooltip": "tooltip",
            "visual_palette": "visualPalette",
        },
    )
    class BoxPlotChartConfigurationProperty:
        def __init__(
            self,
            *,
            box_plot_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_axis: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            interactions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualInteractionOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            legend: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LegendOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            primary_y_axis_display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            primary_y_axis_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            reference_lines: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ReferenceLineProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            sort_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotSortConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            tooltip: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TooltipOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_palette: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualPaletteProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of a ``BoxPlotVisual`` .

            :param box_plot_options: The box plot chart options for a box plot visual.
            :param category_axis: The label display options (grid line, range, scale, axis step) of a box plot category.
            :param category_label_options: The label options (label text, label visibility and sort Icon visibility) of a box plot category.
            :param field_wells: The field wells of the visual.
            :param interactions: The general visual interactions setup for a visual.
            :param legend: 
            :param primary_y_axis_display_options: The label display options (grid line, range, scale, axis step) of a box plot category.
            :param primary_y_axis_label_options: The label options (label text, label visibility and sort icon visibility) of a box plot value.
            :param reference_lines: The reference line setup of the visual.
            :param sort_configuration: The sort configuration of a ``BoxPlotVisual`` .
            :param tooltip: The tooltip display setup of the visual.
            :param visual_palette: The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__df46651962cedb1ef6652ed395524dbc2b63cba61bdd0276f355d4aea35da887)
                check_type(argname="argument box_plot_options", value=box_plot_options, expected_type=type_hints["box_plot_options"])
                check_type(argname="argument category_axis", value=category_axis, expected_type=type_hints["category_axis"])
                check_type(argname="argument category_label_options", value=category_label_options, expected_type=type_hints["category_label_options"])
                check_type(argname="argument field_wells", value=field_wells, expected_type=type_hints["field_wells"])
                check_type(argname="argument interactions", value=interactions, expected_type=type_hints["interactions"])
                check_type(argname="argument legend", value=legend, expected_type=type_hints["legend"])
                check_type(argname="argument primary_y_axis_display_options", value=primary_y_axis_display_options, expected_type=type_hints["primary_y_axis_display_options"])
                check_type(argname="argument primary_y_axis_label_options", value=primary_y_axis_label_options, expected_type=type_hints["primary_y_axis_label_options"])
                check_type(argname="argument reference_lines", value=reference_lines, expected_type=type_hints["reference_lines"])
                check_type(argname="argument sort_configuration", value=sort_configuration, expected_type=type_hints["sort_configuration"])
                check_type(argname="argument tooltip", value=tooltip, expected_type=type_hints["tooltip"])
                check_type(argname="argument visual_palette", value=visual_palette, expected_type=type_hints["visual_palette"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if box_plot_options is not None:
                self._values["box_plot_options"] = box_plot_options
            if category_axis is not None:
                self._values["category_axis"] = category_axis
            if category_label_options is not None:
                self._values["category_label_options"] = category_label_options
            if field_wells is not None:
                self._values["field_wells"] = field_wells
            if interactions is not None:
                self._values["interactions"] = interactions
            if legend is not None:
                self._values["legend"] = legend
            if primary_y_axis_display_options is not None:
                self._values["primary_y_axis_display_options"] = primary_y_axis_display_options
            if primary_y_axis_label_options is not None:
                self._values["primary_y_axis_label_options"] = primary_y_axis_label_options
            if reference_lines is not None:
                self._values["reference_lines"] = reference_lines
            if sort_configuration is not None:
                self._values["sort_configuration"] = sort_configuration
            if tooltip is not None:
                self._values["tooltip"] = tooltip
            if visual_palette is not None:
                self._values["visual_palette"] = visual_palette

        @builtins.property
        def box_plot_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotOptionsProperty"]]:
            '''The box plot chart options for a box plot visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-boxplotoptions
            '''
            result = self._values.get("box_plot_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotOptionsProperty"]], result)

        @builtins.property
        def category_axis(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, axis step) of a box plot category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categoryaxis
            '''
            result = self._values.get("category_axis")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def category_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility and sort Icon visibility) of a box plot category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categorylabeloptions
            '''
            result = self._values.get("category_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotFieldWellsProperty"]]:
            '''The field wells of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-fieldwells
            '''
            result = self._values.get("field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotFieldWellsProperty"]], result)

        @builtins.property
        def interactions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]]:
            '''The general visual interactions setup for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-interactions
            '''
            result = self._values.get("interactions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]], result)

        @builtins.property
        def legend(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-legend
            '''
            result = self._values.get("legend")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]], result)

        @builtins.property
        def primary_y_axis_display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, axis step) of a box plot category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxisdisplayoptions
            '''
            result = self._values.get("primary_y_axis_display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def primary_y_axis_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility and sort icon visibility) of a box plot value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxislabeloptions
            '''
            result = self._values.get("primary_y_axis_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def reference_lines(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]]:
            '''The reference line setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-referencelines
            '''
            result = self._values.get("reference_lines")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]], result)

        @builtins.property
        def sort_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotSortConfigurationProperty"]]:
            '''The sort configuration of a ``BoxPlotVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-sortconfiguration
            '''
            result = self._values.get("sort_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotSortConfigurationProperty"]], result)

        @builtins.property
        def tooltip(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]]:
            '''The tooltip display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-tooltip
            '''
            result = self._values.get("tooltip")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]], result)

        @builtins.property
        def visual_palette(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]]:
            '''The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-visualpalette
            '''
            result = self._values.get("visual_palette")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotChartConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "box_plot_aggregated_field_wells": "boxPlotAggregatedFieldWells",
        },
    )
    class BoxPlotFieldWellsProperty:
        def __init__(
            self,
            *,
            box_plot_aggregated_field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotAggregatedFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The field wells of a ``BoxPlotVisual`` .

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param box_plot_aggregated_field_wells: The aggregated field wells of a box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ac1a8fba8f6c2f661b078e185c31574bc3d302ed5e28f085da15f15ce024416f)
                check_type(argname="argument box_plot_aggregated_field_wells", value=box_plot_aggregated_field_wells, expected_type=type_hints["box_plot_aggregated_field_wells"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if box_plot_aggregated_field_wells is not None:
                self._values["box_plot_aggregated_field_wells"] = box_plot_aggregated_field_wells

        @builtins.property
        def box_plot_aggregated_field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotAggregatedFieldWellsProperty"]]:
            '''The aggregated field wells of a box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html#cfn-quicksight-analysis-boxplotfieldwells-boxplotaggregatedfieldwells
            '''
            result = self._values.get("box_plot_aggregated_field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotAggregatedFieldWellsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_data_points_visibility": "allDataPointsVisibility",
            "outlier_visibility": "outlierVisibility",
            "style_options": "styleOptions",
        },
    )
    class BoxPlotOptionsProperty:
        def __init__(
            self,
            *,
            all_data_points_visibility: typing.Optional[builtins.str] = None,
            outlier_visibility: typing.Optional[builtins.str] = None,
            style_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotStyleOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The options of a box plot visual.

            :param all_data_points_visibility: Determines the visibility of all data points of the box plot.
            :param outlier_visibility: Determines the visibility of the outlier in a box plot.
            :param style_options: The style options of the box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                box_plot_options_property = quicksight.CfnAnalysis.BoxPlotOptionsProperty(
                    all_data_points_visibility="allDataPointsVisibility",
                    outlier_visibility="outlierVisibility",
                    style_options=quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty(
                        fill_style="fillStyle"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f609ac1c7e2111a40dac58ec2bf94644d7ec89bb7e811f05ac3791b0bd840ca1)
                check_type(argname="argument all_data_points_visibility", value=all_data_points_visibility, expected_type=type_hints["all_data_points_visibility"])
                check_type(argname="argument outlier_visibility", value=outlier_visibility, expected_type=type_hints["outlier_visibility"])
                check_type(argname="argument style_options", value=style_options, expected_type=type_hints["style_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_data_points_visibility is not None:
                self._values["all_data_points_visibility"] = all_data_points_visibility
            if outlier_visibility is not None:
                self._values["outlier_visibility"] = outlier_visibility
            if style_options is not None:
                self._values["style_options"] = style_options

        @builtins.property
        def all_data_points_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of all data points of the box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-alldatapointsvisibility
            '''
            result = self._values.get("all_data_points_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def outlier_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of the outlier in a box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-outliervisibility
            '''
            result = self._values.get("outlier_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def style_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotStyleOptionsProperty"]]:
            '''The style options of the box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-styleoptions
            '''
            result = self._values.get("style_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotStyleOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "category_sort": "categorySort",
            "pagination_configuration": "paginationConfiguration",
        },
    )
    class BoxPlotSortConfigurationProperty:
        def __init__(
            self,
            *,
            category_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            pagination_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.PaginationConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The sort configuration of a ``BoxPlotVisual`` .

            :param category_sort: The sort configuration of a group by fields.
            :param pagination_configuration: The pagination configuration of a table visual or box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                box_plot_sort_configuration_property = quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty(
                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )],
                    pagination_configuration=quicksight.CfnAnalysis.PaginationConfigurationProperty(
                        page_number=123,
                        page_size=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4c1d82075e81046c13020ab880f86084f3bffe25cd8098d935779d515db720da)
                check_type(argname="argument category_sort", value=category_sort, expected_type=type_hints["category_sort"])
                check_type(argname="argument pagination_configuration", value=pagination_configuration, expected_type=type_hints["pagination_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if category_sort is not None:
                self._values["category_sort"] = category_sort
            if pagination_configuration is not None:
                self._values["pagination_configuration"] = pagination_configuration

        @builtins.property
        def category_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of a group by fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-categorysort
            '''
            result = self._values.get("category_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        @builtins.property
        def pagination_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PaginationConfigurationProperty"]]:
            '''The pagination configuration of a table visual or box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-paginationconfiguration
            '''
            result = self._values.get("pagination_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PaginationConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotSortConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"fill_style": "fillStyle"},
    )
    class BoxPlotStyleOptionsProperty:
        def __init__(self, *, fill_style: typing.Optional[builtins.str] = None) -> None:
            '''The style options of the box plot.

            :param fill_style: The fill styles (solid, transparent) of the box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                box_plot_style_options_property = quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty(
                    fill_style="fillStyle"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__89d49edf39c70224f925125d76ee7b0de600605a2b15e684aa0b7ee96041320c)
                check_type(argname="argument fill_style", value=fill_style, expected_type=type_hints["fill_style"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if fill_style is not None:
                self._values["fill_style"] = fill_style

        @builtins.property
        def fill_style(self) -> typing.Optional[builtins.str]:
            '''The fill styles (solid, transparent) of the box plot.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html#cfn-quicksight-analysis-boxplotstyleoptions-fillstyle
            '''
            result = self._values.get("fill_style")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotStyleOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotVisualProperty",
        jsii_struct_bases=[],
        name_mapping={
            "visual_id": "visualId",
            "actions": "actions",
            "chart_configuration": "chartConfiguration",
            "column_hierarchies": "columnHierarchies",
            "subtitle": "subtitle",
            "title": "title",
            "visual_content_alt_text": "visualContentAltText",
        },
    )
    class BoxPlotVisualProperty:
        def __init__(
            self,
            *,
            visual_id: builtins.str,
            actions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualCustomActionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            chart_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.BoxPlotChartConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            column_hierarchies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            subtitle: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualSubtitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            title: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualTitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_content_alt_text: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A box plot.

            For more information, see `Using box plots <https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html>`_ in the *Amazon QuickSight User Guide* .

            :param visual_id: The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
            :param actions: The list of custom actions that are configured for a visual.
            :param chart_configuration: The configuration settings of the visual.
            :param column_hierarchies: The column hierarchy that is used during drill-downs and drill-ups.
            :param subtitle: The subtitle that is displayed on the visual.
            :param title: The title that is displayed on the visual.
            :param visual_content_alt_text: The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5b3b42e671b910ca19129eb109ab58af3c253cd6b5c6f5c94a4b737e1287fcd6)
                check_type(argname="argument visual_id", value=visual_id, expected_type=type_hints["visual_id"])
                check_type(argname="argument actions", value=actions, expected_type=type_hints["actions"])
                check_type(argname="argument chart_configuration", value=chart_configuration, expected_type=type_hints["chart_configuration"])
                check_type(argname="argument column_hierarchies", value=column_hierarchies, expected_type=type_hints["column_hierarchies"])
                check_type(argname="argument subtitle", value=subtitle, expected_type=type_hints["subtitle"])
                check_type(argname="argument title", value=title, expected_type=type_hints["title"])
                check_type(argname="argument visual_content_alt_text", value=visual_content_alt_text, expected_type=type_hints["visual_content_alt_text"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "visual_id": visual_id,
            }
            if actions is not None:
                self._values["actions"] = actions
            if chart_configuration is not None:
                self._values["chart_configuration"] = chart_configuration
            if column_hierarchies is not None:
                self._values["column_hierarchies"] = column_hierarchies
            if subtitle is not None:
                self._values["subtitle"] = subtitle
            if title is not None:
                self._values["title"] = title
            if visual_content_alt_text is not None:
                self._values["visual_content_alt_text"] = visual_content_alt_text

        @builtins.property
        def visual_id(self) -> builtins.str:
            '''The unique identifier of a visual.

            This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualid
            '''
            result = self._values.get("visual_id")
            assert result is not None, "Required property 'visual_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def actions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]]:
            '''The list of custom actions that are configured for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-actions
            '''
            result = self._values.get("actions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]], result)

        @builtins.property
        def chart_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotChartConfigurationProperty"]]:
            '''The configuration settings of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-chartconfiguration
            '''
            result = self._values.get("chart_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.BoxPlotChartConfigurationProperty"]], result)

        @builtins.property
        def column_hierarchies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]]:
            '''The column hierarchy that is used during drill-downs and drill-ups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-columnhierarchies
            '''
            result = self._values.get("column_hierarchies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]], result)

        @builtins.property
        def subtitle(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]]:
            '''The subtitle that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-subtitle
            '''
            result = self._values.get("subtitle")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]], result)

        @builtins.property
        def title(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]]:
            '''The title that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-title
            '''
            result = self._values.get("title")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]], result)

        @builtins.property
        def visual_content_alt_text(self) -> typing.Optional[builtins.str]:
            '''The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualcontentalttext
            '''
            result = self._values.get("visual_content_alt_text")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BoxPlotVisualProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_set_identifier": "dataSetIdentifier",
            "expression": "expression",
            "name": "name",
        },
    )
    class CalculatedFieldProperty:
        def __init__(
            self,
            *,
            data_set_identifier: builtins.str,
            expression: builtins.str,
            name: builtins.str,
        ) -> None:
            '''The calculated field of an analysis.

            :param data_set_identifier: The data set that is used in this calculated field.
            :param expression: The expression of the calculated field.
            :param name: The name of the calculated field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                calculated_field_property = quicksight.CfnAnalysis.CalculatedFieldProperty(
                    data_set_identifier="dataSetIdentifier",
                    expression="expression",
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2b3e5b275e2f35fcdf8efe7f2989ea0bda663184c63636414e26198b88057139)
                check_type(argname="argument data_set_identifier", value=data_set_identifier, expected_type=type_hints["data_set_identifier"])
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_set_identifier": data_set_identifier,
                "expression": expression,
                "name": name,
            }

        @builtins.property
        def data_set_identifier(self) -> builtins.str:
            '''The data set that is used in this calculated field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-datasetidentifier
            '''
            result = self._values.get("data_set_identifier")
            assert result is not None, "Required property 'data_set_identifier' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression of the calculated field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the calculated field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CalculatedFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedMeasureFieldProperty",
        jsii_struct_bases=[],
        name_mapping={"expression": "expression", "field_id": "fieldId"},
    )
    class CalculatedMeasureFieldProperty:
        def __init__(self, *, expression: builtins.str, field_id: builtins.str) -> None:
            '''The table calculation measure field for pivot tables.

            :param expression: The expression in the table calculation.
            :param field_id: The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                calculated_measure_field_property = quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                    expression="expression",
                    field_id="fieldId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0374ef2482b9185adce203520bc3bf342ce2682847ee02c9c7de9eb4b573df1b)
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "expression": expression,
                "field_id": field_id,
            }

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression in the table calculation.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CalculatedMeasureFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"source_controls": "sourceControls"},
    )
    class CascadingControlConfigurationProperty:
        def __init__(
            self,
            *,
            source_controls: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CascadingControlSourceProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.

            :param source_controls: A list of source controls that determine the values that are used in the current control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                cascading_control_configuration_property = quicksight.CfnAnalysis.CascadingControlConfigurationProperty(
                    source_controls=[quicksight.CfnAnalysis.CascadingControlSourceProperty(
                        column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        source_sheet_control_id="sourceSheetControlId"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e73299bcd6703fa1955807823fedc8668167418e46d6a1f346fdf0f2a291c90c)
                check_type(argname="argument source_controls", value=source_controls, expected_type=type_hints["source_controls"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if source_controls is not None:
                self._values["source_controls"] = source_controls

        @builtins.property
        def source_controls(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CascadingControlSourceProperty"]]]]:
            '''A list of source controls that determine the values that are used in the current control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html#cfn-quicksight-analysis-cascadingcontrolconfiguration-sourcecontrols
            '''
            result = self._values.get("source_controls")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CascadingControlSourceProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CascadingControlConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlSourceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column_to_match": "columnToMatch",
            "source_sheet_control_id": "sourceSheetControlId",
        },
    )
    class CascadingControlSourceProperty:
        def __init__(
            self,
            *,
            column_to_match: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            source_sheet_control_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The source controls that are used in a ``CascadingControlConfiguration`` .

            :param column_to_match: The column identifier that determines which column to look up for the source sheet control.
            :param source_sheet_control_id: The source sheet control ID of a ``CascadingControlSource`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                cascading_control_source_property = quicksight.CfnAnalysis.CascadingControlSourceProperty(
                    column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    source_sheet_control_id="sourceSheetControlId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7d12dfeb0e547c026b1df8c2f6d543f7aa0dc0842e96b7484d1e6da2e024e49d)
                check_type(argname="argument column_to_match", value=column_to_match, expected_type=type_hints["column_to_match"])
                check_type(argname="argument source_sheet_control_id", value=source_sheet_control_id, expected_type=type_hints["source_sheet_control_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if column_to_match is not None:
                self._values["column_to_match"] = column_to_match
            if source_sheet_control_id is not None:
                self._values["source_sheet_control_id"] = source_sheet_control_id

        @builtins.property
        def column_to_match(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]]:
            '''The column identifier that determines which column to look up for the source sheet control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-columntomatch
            '''
            result = self._values.get("column_to_match")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]], result)

        @builtins.property
        def source_sheet_control_id(self) -> typing.Optional[builtins.str]:
            '''The source sheet control ID of a ``CascadingControlSource`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-sourcesheetcontrolid
            '''
            result = self._values.get("source_sheet_control_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CascadingControlSourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalDimensionFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "field_id": "fieldId",
            "format_configuration": "formatConfiguration",
            "hierarchy_id": "hierarchyId",
        },
    )
    class CategoricalDimensionFieldProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            field_id: builtins.str,
            format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.StringFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            hierarchy_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The dimension type field with categorical type columns..

            :param column: The column that is used in the ``CategoricalDimensionField`` .
            :param field_id: The custom field ID.
            :param format_configuration: The format configuration of the field.
            :param hierarchy_id: The custom hierarchy ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                categorical_dimension_field_property = quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    field_id="fieldId",
                
                    # the properties below are optional
                    format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                            currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix",
                                symbol="symbol"
                            ),
                            number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            ),
                            percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            )
                        )
                    ),
                    hierarchy_id="hierarchyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6f1f38bb0addf439daae4206b32dfabc93aced0cbdd4dc11840c7bc899eea7e3)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument format_configuration", value=format_configuration, expected_type=type_hints["format_configuration"])
                check_type(argname="argument hierarchy_id", value=hierarchy_id, expected_type=type_hints["hierarchy_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "field_id": field_id,
            }
            if format_configuration is not None:
                self._values["format_configuration"] = format_configuration
            if hierarchy_id is not None:
                self._values["hierarchy_id"] = hierarchy_id

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that is used in the ``CategoricalDimensionField`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StringFormatConfigurationProperty"]]:
            '''The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-formatconfiguration
            '''
            result = self._values.get("format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StringFormatConfigurationProperty"]], result)

        @builtins.property
        def hierarchy_id(self) -> typing.Optional[builtins.str]:
            '''The custom hierarchy ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-hierarchyid
            '''
            result = self._values.get("hierarchy_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoricalDimensionFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalMeasureFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "field_id": "fieldId",
            "aggregation_function": "aggregationFunction",
            "format_configuration": "formatConfiguration",
        },
    )
    class CategoricalMeasureFieldProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            field_id: builtins.str,
            aggregation_function: typing.Optional[builtins.str] = None,
            format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.StringFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The measure type field with categorical type columns.

            :param column: The column that is used in the ``CategoricalMeasureField`` .
            :param field_id: The custom field ID.
            :param aggregation_function: The aggregation function of the measure field.
            :param format_configuration: The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                categorical_measure_field_property = quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    field_id="fieldId",
                
                    # the properties below are optional
                    aggregation_function="aggregationFunction",
                    format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                            currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix",
                                symbol="symbol"
                            ),
                            number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            ),
                            percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a9fcef98715e02f90cb5e1a80001e6046d16394dec171ccd1c964880913fe68c)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument aggregation_function", value=aggregation_function, expected_type=type_hints["aggregation_function"])
                check_type(argname="argument format_configuration", value=format_configuration, expected_type=type_hints["format_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "field_id": field_id,
            }
            if aggregation_function is not None:
                self._values["aggregation_function"] = aggregation_function
            if format_configuration is not None:
                self._values["format_configuration"] = format_configuration

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that is used in the ``CategoricalMeasureField`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def aggregation_function(self) -> typing.Optional[builtins.str]:
            '''The aggregation function of the measure field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-aggregationfunction
            '''
            result = self._values.get("aggregation_function")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StringFormatConfigurationProperty"]]:
            '''The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-formatconfiguration
            '''
            result = self._values.get("format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.StringFormatConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoricalMeasureFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryDrillDownFilterProperty",
        jsii_struct_bases=[],
        name_mapping={"category_values": "categoryValues", "column": "column"},
    )
    class CategoryDrillDownFilterProperty:
        def __init__(
            self,
            *,
            category_values: typing.Sequence[builtins.str],
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The category drill down filter.

            :param category_values: A list of the string inputs that are the values of the category drill down filter.
            :param column: The column that the filter is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                category_drill_down_filter_property = quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                    category_values=["categoryValues"],
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__723c70aef9408e55ed338e2c0930c0382941de2c4ef2a7418407d520c5de26b3)
                check_type(argname="argument category_values", value=category_values, expected_type=type_hints["category_values"])
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "category_values": category_values,
                "column": column,
            }

        @builtins.property
        def category_values(self) -> typing.List[builtins.str]:
            '''A list of the string inputs that are the values of the category drill down filter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-categoryvalues
            '''
            result = self._values.get("category_values")
            assert result is not None, "Required property 'category_values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that the filter is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoryDrillDownFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_filter_configuration": "customFilterConfiguration",
            "custom_filter_list_configuration": "customFilterListConfiguration",
            "filter_list_configuration": "filterListConfiguration",
        },
    )
    class CategoryFilterConfigurationProperty:
        def __init__(
            self,
            *,
            custom_filter_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomFilterConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            custom_filter_list_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomFilterListConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            filter_list_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterListConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for a ``CategoryFilter`` .

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param custom_filter_configuration: A custom filter that filters based on a single value. This filter can be partially matched.
            :param custom_filter_list_configuration: A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom filter list.
            :param filter_list_configuration: A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                category_filter_configuration_property = quicksight.CfnAnalysis.CategoryFilterConfigurationProperty(
                    custom_filter_configuration=quicksight.CfnAnalysis.CustomFilterConfigurationProperty(
                        match_operator="matchOperator",
                        null_option="nullOption",
                
                        # the properties below are optional
                        category_value="categoryValue",
                        parameter_name="parameterName",
                        select_all_options="selectAllOptions"
                    ),
                    custom_filter_list_configuration=quicksight.CfnAnalysis.CustomFilterListConfigurationProperty(
                        match_operator="matchOperator",
                        null_option="nullOption",
                
                        # the properties below are optional
                        category_values=["categoryValues"],
                        select_all_options="selectAllOptions"
                    ),
                    filter_list_configuration=quicksight.CfnAnalysis.FilterListConfigurationProperty(
                        match_operator="matchOperator",
                
                        # the properties below are optional
                        category_values=["categoryValues"],
                        null_option="nullOption",
                        select_all_options="selectAllOptions"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a6e5a83eb58b86ba1db93dde36f36bc38753955033efcd6df85274323c052315)
                check_type(argname="argument custom_filter_configuration", value=custom_filter_configuration, expected_type=type_hints["custom_filter_configuration"])
                check_type(argname="argument custom_filter_list_configuration", value=custom_filter_list_configuration, expected_type=type_hints["custom_filter_list_configuration"])
                check_type(argname="argument filter_list_configuration", value=filter_list_configuration, expected_type=type_hints["filter_list_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_filter_configuration is not None:
                self._values["custom_filter_configuration"] = custom_filter_configuration
            if custom_filter_list_configuration is not None:
                self._values["custom_filter_list_configuration"] = custom_filter_list_configuration
            if filter_list_configuration is not None:
                self._values["filter_list_configuration"] = filter_list_configuration

        @builtins.property
        def custom_filter_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomFilterConfigurationProperty"]]:
            '''A custom filter that filters based on a single value.

            This filter can be partially matched.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterconfiguration
            '''
            result = self._values.get("custom_filter_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomFilterConfigurationProperty"]], result)

        @builtins.property
        def custom_filter_list_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomFilterListConfigurationProperty"]]:
            '''A list of custom filter values.

            In the Amazon QuickSight console, this filter type is called a custom filter list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterlistconfiguration
            '''
            result = self._values.get("custom_filter_list_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomFilterListConfigurationProperty"]], result)

        @builtins.property
        def filter_list_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterListConfigurationProperty"]]:
            '''A list of filter configurations.

            In the Amazon QuickSight console, this filter type is called a filter list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-filterlistconfiguration
            '''
            result = self._values.get("filter_list_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterListConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoryFilterConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "configuration": "configuration",
            "filter_id": "filterId",
            "default_filter_control_configuration": "defaultFilterControlConfiguration",
        },
    )
    class CategoryFilterProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CategoryFilterConfigurationProperty", typing.Dict[builtins.str, typing.Any]]],
            filter_id: builtins.str,
            default_filter_control_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFilterControlConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A ``CategoryFilter`` filters text values.

            For more information, see `Adding text filters <https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html>`_ in the *Amazon QuickSight User Guide* .

            :param column: The column that the filter is applied to.
            :param configuration: The configuration for a ``CategoryFilter`` .
            :param filter_id: An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
            :param default_filter_control_configuration: The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                category_filter_property = quicksight.CfnAnalysis.CategoryFilterProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    configuration=quicksight.CfnAnalysis.CategoryFilterConfigurationProperty(
                        custom_filter_configuration=quicksight.CfnAnalysis.CustomFilterConfigurationProperty(
                            match_operator="matchOperator",
                            null_option="nullOption",
                
                            # the properties below are optional
                            category_value="categoryValue",
                            parameter_name="parameterName",
                            select_all_options="selectAllOptions"
                        ),
                        custom_filter_list_configuration=quicksight.CfnAnalysis.CustomFilterListConfigurationProperty(
                            match_operator="matchOperator",
                            null_option="nullOption",
                
                            # the properties below are optional
                            category_values=["categoryValues"],
                            select_all_options="selectAllOptions"
                        ),
                        filter_list_configuration=quicksight.CfnAnalysis.FilterListConfigurationProperty(
                            match_operator="matchOperator",
                
                            # the properties below are optional
                            category_values=["categoryValues"],
                            null_option="nullOption",
                            select_all_options="selectAllOptions"
                        )
                    ),
                    filter_id="filterId",
                
                    # the properties below are optional
                    default_filter_control_configuration=quicksight.CfnAnalysis.DefaultFilterControlConfigurationProperty(
                        control_options=quicksight.CfnAnalysis.DefaultFilterControlOptionsProperty(
                            default_date_time_picker_options=quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                                    date_icon_visibility="dateIconVisibility",
                                    date_time_format="dateTimeFormat",
                                    helper_text_visibility="helperTextVisibility",
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                type="type"
                            ),
                            default_dropdown_options=quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                    values=["values"]
                                ),
                                type="type"
                            ),
                            default_list_options=quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty(
                                display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                    values=["values"]
                                ),
                                type="type"
                            ),
                            default_relative_date_time_options=quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                                    date_time_format="dateTimeFormat",
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            ),
                            default_slider_options=quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty(
                                maximum_value=123,
                                minimum_value=123,
                                step_size=123,
                
                                # the properties below are optional
                                display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                type="type"
                            ),
                            default_text_area_options=quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty(
                                delimiter="delimiter",
                                display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            ),
                            default_text_field_options=quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty(
                                display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            )
                        ),
                        title="title"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cd5df25b1a6ff9a1098d6d573aaa7220ac13f7af43bbeca0f4bc97a2cef5b96f)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument configuration", value=configuration, expected_type=type_hints["configuration"])
                check_type(argname="argument filter_id", value=filter_id, expected_type=type_hints["filter_id"])
                check_type(argname="argument default_filter_control_configuration", value=default_filter_control_configuration, expected_type=type_hints["default_filter_control_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "configuration": configuration,
                "filter_id": filter_id,
            }
            if default_filter_control_configuration is not None:
                self._values["default_filter_control_configuration"] = default_filter_control_configuration

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that the filter is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CategoryFilterConfigurationProperty"]:
            '''The configuration for a ``CategoryFilter`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-configuration
            '''
            result = self._values.get("configuration")
            assert result is not None, "Required property 'configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CategoryFilterConfigurationProperty"], result)

        @builtins.property
        def filter_id(self) -> builtins.str:
            '''An identifier that uniquely identifies a filter within a dashboard, analysis, or template.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-filterid
            '''
            result = self._values.get("filter_id")
            assert result is not None, "Required property 'filter_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_filter_control_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlConfigurationProperty"]]:
            '''The default configurations for the associated controls.

            This applies only for filters that are scoped to multiple sheets.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-defaultfiltercontrolconfiguration
            '''
            result = self._values.get("default_filter_control_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoryFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryInnerFilterProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "configuration": "configuration",
            "default_filter_control_configuration": "defaultFilterControlConfiguration",
        },
    )
    class CategoryInnerFilterProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CategoryFilterConfigurationProperty", typing.Dict[builtins.str, typing.Any]]],
            default_filter_control_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFilterControlConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A ``CategoryInnerFilter`` filters text values for the ``NestedFilter`` .

            :param column: 
            :param configuration: 
            :param default_filter_control_configuration: 

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                category_inner_filter_property = quicksight.CfnAnalysis.CategoryInnerFilterProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    configuration=quicksight.CfnAnalysis.CategoryFilterConfigurationProperty(
                        custom_filter_configuration=quicksight.CfnAnalysis.CustomFilterConfigurationProperty(
                            match_operator="matchOperator",
                            null_option="nullOption",
                
                            # the properties below are optional
                            category_value="categoryValue",
                            parameter_name="parameterName",
                            select_all_options="selectAllOptions"
                        ),
                        custom_filter_list_configuration=quicksight.CfnAnalysis.CustomFilterListConfigurationProperty(
                            match_operator="matchOperator",
                            null_option="nullOption",
                
                            # the properties below are optional
                            category_values=["categoryValues"],
                            select_all_options="selectAllOptions"
                        ),
                        filter_list_configuration=quicksight.CfnAnalysis.FilterListConfigurationProperty(
                            match_operator="matchOperator",
                
                            # the properties below are optional
                            category_values=["categoryValues"],
                            null_option="nullOption",
                            select_all_options="selectAllOptions"
                        )
                    ),
                
                    # the properties below are optional
                    default_filter_control_configuration=quicksight.CfnAnalysis.DefaultFilterControlConfigurationProperty(
                        control_options=quicksight.CfnAnalysis.DefaultFilterControlOptionsProperty(
                            default_date_time_picker_options=quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                                    date_icon_visibility="dateIconVisibility",
                                    date_time_format="dateTimeFormat",
                                    helper_text_visibility="helperTextVisibility",
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                type="type"
                            ),
                            default_dropdown_options=quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                    values=["values"]
                                ),
                                type="type"
                            ),
                            default_list_options=quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty(
                                display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                    values=["values"]
                                ),
                                type="type"
                            ),
                            default_relative_date_time_options=quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty(
                                commit_mode="commitMode",
                                display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                                    date_time_format="dateTimeFormat",
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            ),
                            default_slider_options=quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty(
                                maximum_value=123,
                                minimum_value=123,
                                step_size=123,
                
                                # the properties below are optional
                                display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                ),
                                type="type"
                            ),
                            default_text_area_options=quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty(
                                delimiter="delimiter",
                                display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            ),
                            default_text_field_options=quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty(
                                display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                        info_icon_text="infoIconText",
                                        visibility="visibility"
                                    ),
                                    placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                        visibility="visibility"
                                    ),
                                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_family="fontFamily",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                absolute="absolute",
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    )
                                )
                            )
                        ),
                        title="title"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fa46e3dafba0f42142e194e9a84fc7c39c34b77252141686ed7953c4557ed2f0)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument configuration", value=configuration, expected_type=type_hints["configuration"])
                check_type(argname="argument default_filter_control_configuration", value=default_filter_control_configuration, expected_type=type_hints["default_filter_control_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "configuration": configuration,
            }
            if default_filter_control_configuration is not None:
                self._values["default_filter_control_configuration"] = default_filter_control_configuration

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CategoryFilterConfigurationProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-configuration
            '''
            result = self._values.get("configuration")
            assert result is not None, "Required property 'configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CategoryFilterConfigurationProperty"], result)

        @builtins.property
        def default_filter_control_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlConfigurationProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-defaultfiltercontrolconfiguration
            '''
            result = self._values.get("default_filter_control_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CategoryInnerFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "axis_label_options": "axisLabelOptions",
            "sort_icon_visibility": "sortIconVisibility",
            "visibility": "visibility",
        },
    )
    class ChartAxisLabelOptionsProperty:
        def __init__(
            self,
            *,
            axis_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            sort_icon_visibility: typing.Optional[builtins.str] = None,
            visibility: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The label options for an axis on a chart.

            :param axis_label_options: The label options for a chart axis.
            :param sort_icon_visibility: The visibility configuration of the sort icon on a chart's axis label.
            :param visibility: The visibility of an axis label on a chart. Choose one of the following options:. - ``VISIBLE`` : Shows the axis. - ``HIDDEN`` : Hides the axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                chart_axis_label_options_property = quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            field_id="fieldId"
                        ),
                        custom_label="customLabel",
                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                            font_color="fontColor",
                            font_decoration="fontDecoration",
                            font_family="fontFamily",
                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                absolute="absolute",
                                relative="relative"
                            ),
                            font_style="fontStyle",
                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                name="name"
                            )
                        )
                    )],
                    sort_icon_visibility="sortIconVisibility",
                    visibility="visibility"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cdb4eeafd511c20ae740891fafdc3d7f3d7cfde84fc43817149bce640d505ce6)
                check_type(argname="argument axis_label_options", value=axis_label_options, expected_type=type_hints["axis_label_options"])
                check_type(argname="argument sort_icon_visibility", value=sort_icon_visibility, expected_type=type_hints["sort_icon_visibility"])
                check_type(argname="argument visibility", value=visibility, expected_type=type_hints["visibility"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if axis_label_options is not None:
                self._values["axis_label_options"] = axis_label_options
            if sort_icon_visibility is not None:
                self._values["sort_icon_visibility"] = sort_icon_visibility
            if visibility is not None:
                self._values["visibility"] = visibility

        @builtins.property
        def axis_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLabelOptionsProperty"]]]]:
            '''The label options for a chart axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-axislabeloptions
            '''
            result = self._values.get("axis_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisLabelOptionsProperty"]]]], result)

        @builtins.property
        def sort_icon_visibility(self) -> typing.Optional[builtins.str]:
            '''The visibility configuration of the sort icon on a chart's axis label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-sorticonvisibility
            '''
            result = self._values.get("sort_icon_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def visibility(self) -> typing.Optional[builtins.str]:
            '''The visibility of an axis label on a chart. Choose one of the following options:.

            - ``VISIBLE`` : Shows the axis.
            - ``HIDDEN`` : Hides the axis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-visibility
            '''
            result = self._values.get("visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChartAxisLabelOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_marker": "clusterMarker"},
    )
    class ClusterMarkerConfigurationProperty:
        def __init__(
            self,
            *,
            cluster_marker: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ClusterMarkerProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The cluster marker configuration of the geospatial map selected point style.

            :param cluster_marker: The cluster marker that is a part of the cluster marker configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                cluster_marker_configuration_property = quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty(
                    cluster_marker=quicksight.CfnAnalysis.ClusterMarkerProperty(
                        simple_cluster_marker=quicksight.CfnAnalysis.SimpleClusterMarkerProperty(
                            color="color"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__98f37cdd4ca6a15f7da6a38e0b8de29bb69f8019e6eed91dd94d65ca0e9ecd7f)
                check_type(argname="argument cluster_marker", value=cluster_marker, expected_type=type_hints["cluster_marker"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if cluster_marker is not None:
                self._values["cluster_marker"] = cluster_marker

        @builtins.property
        def cluster_marker(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ClusterMarkerProperty"]]:
            '''The cluster marker that is a part of the cluster marker configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html#cfn-quicksight-analysis-clustermarkerconfiguration-clustermarker
            '''
            result = self._values.get("cluster_marker")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ClusterMarkerProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterMarkerConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerProperty",
        jsii_struct_bases=[],
        name_mapping={"simple_cluster_marker": "simpleClusterMarker"},
    )
    class ClusterMarkerProperty:
        def __init__(
            self,
            *,
            simple_cluster_marker: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SimpleClusterMarkerProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The cluster marker that is a part of the cluster marker configuration.

            :param simple_cluster_marker: The simple cluster marker of the cluster marker.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                cluster_marker_property = quicksight.CfnAnalysis.ClusterMarkerProperty(
                    simple_cluster_marker=quicksight.CfnAnalysis.SimpleClusterMarkerProperty(
                        color="color"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4a2783133d20e8b551d6ea144cbd6b328f577eb8803ad9ccc941a6626951f69f)
                check_type(argname="argument simple_cluster_marker", value=simple_cluster_marker, expected_type=type_hints["simple_cluster_marker"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if simple_cluster_marker is not None:
                self._values["simple_cluster_marker"] = simple_cluster_marker

        @builtins.property
        def simple_cluster_marker(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SimpleClusterMarkerProperty"]]:
            '''The simple cluster marker of the cluster marker.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html#cfn-quicksight-analysis-clustermarker-simpleclustermarker
            '''
            result = self._values.get("simple_cluster_marker")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SimpleClusterMarkerProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterMarkerProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorScaleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "color_fill_type": "colorFillType",
            "colors": "colors",
            "null_value_color": "nullValueColor",
        },
    )
    class ColorScaleProperty:
        def __init__(
            self,
            *,
            color_fill_type: builtins.str,
            colors: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataColorProperty", typing.Dict[builtins.str, typing.Any]]]]],
            null_value_color: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataColorProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Determines the color scale that is applied to the visual.

            :param color_fill_type: Determines the color fill type.
            :param colors: Determines the list of colors that are applied to the visual.
            :param null_value_color: Determines the color that is applied to null values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                color_scale_property = quicksight.CfnAnalysis.ColorScaleProperty(
                    color_fill_type="colorFillType",
                    colors=[quicksight.CfnAnalysis.DataColorProperty(
                        color="color",
                        data_value=123
                    )],
                
                    # the properties below are optional
                    null_value_color=quicksight.CfnAnalysis.DataColorProperty(
                        color="color",
                        data_value=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f689b41b461f9d73e613d32fb06c81644f5d7da73bc45bce6809d7b5b2e1602c)
                check_type(argname="argument color_fill_type", value=color_fill_type, expected_type=type_hints["color_fill_type"])
                check_type(argname="argument colors", value=colors, expected_type=type_hints["colors"])
                check_type(argname="argument null_value_color", value=null_value_color, expected_type=type_hints["null_value_color"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "color_fill_type": color_fill_type,
                "colors": colors,
            }
            if null_value_color is not None:
                self._values["null_value_color"] = null_value_color

        @builtins.property
        def color_fill_type(self) -> builtins.str:
            '''Determines the color fill type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colorfilltype
            '''
            result = self._values.get("color_fill_type")
            assert result is not None, "Required property 'color_fill_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def colors(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataColorProperty"]]]:
            '''Determines the list of colors that are applied to the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colors
            '''
            result = self._values.get("colors")
            assert result is not None, "Required property 'colors' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataColorProperty"]]], result)

        @builtins.property
        def null_value_color(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataColorProperty"]]:
            '''Determines the color that is applied to null values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-nullvaluecolor
            '''
            result = self._values.get("null_value_color")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataColorProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColorScaleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorsConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_colors": "customColors"},
    )
    class ColorsConfigurationProperty:
        def __init__(
            self,
            *,
            custom_colors: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomColorProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The color configurations for a column.

            :param custom_colors: A list of up to 50 custom colors.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                colors_configuration_property = quicksight.CfnAnalysis.ColorsConfigurationProperty(
                    custom_colors=[quicksight.CfnAnalysis.CustomColorProperty(
                        color="color",
                
                        # the properties below are optional
                        field_value="fieldValue",
                        special_value="specialValue"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7f072c6c4e3112557f99bd411406e084171378a001e7229e58365a958f5a28e8)
                check_type(argname="argument custom_colors", value=custom_colors, expected_type=type_hints["custom_colors"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_colors is not None:
                self._values["custom_colors"] = custom_colors

        @builtins.property
        def custom_colors(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomColorProperty"]]]]:
            '''A list of up to 50 custom colors.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html#cfn-quicksight-analysis-colorsconfiguration-customcolors
            '''
            result = self._values.get("custom_colors")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomColorProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColorsConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "colors_configuration": "colorsConfiguration",
            "format_configuration": "formatConfiguration",
            "role": "role",
        },
    )
    class ColumnConfigurationProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            colors_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColorsConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            role: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The general configuration of a column.

            :param column: The column.
            :param colors_configuration: The color configurations of the column.
            :param format_configuration: The format configuration of a column.
            :param role: The role of the column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                column_configuration_property = quicksight.CfnAnalysis.ColumnConfigurationProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                
                    # the properties below are optional
                    colors_configuration=quicksight.CfnAnalysis.ColorsConfigurationProperty(
                        custom_colors=[quicksight.CfnAnalysis.CustomColorProperty(
                            color="color",
                
                            # the properties below are optional
                            field_value="fieldValue",
                            special_value="specialValue"
                        )]
                    ),
                    format_configuration=quicksight.CfnAnalysis.FormatConfigurationProperty(
                        date_time_format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                            date_time_format="dateTimeFormat",
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        number_format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                            format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        string_format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        )
                    ),
                    role="role"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0caa6540ab9ae618258469c56ddb4a7ac1db36480f095b1823437269d94846d9)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument colors_configuration", value=colors_configuration, expected_type=type_hints["colors_configuration"])
                check_type(argname="argument format_configuration", value=format_configuration, expected_type=type_hints["format_configuration"])
                check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
            }
            if colors_configuration is not None:
                self._values["colors_configuration"] = colors_configuration
            if format_configuration is not None:
                self._values["format_configuration"] = format_configuration
            if role is not None:
                self._values["role"] = role

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def colors_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColorsConfigurationProperty"]]:
            '''The color configurations of the column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-colorsconfiguration
            '''
            result = self._values.get("colors_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColorsConfigurationProperty"]], result)

        @builtins.property
        def format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FormatConfigurationProperty"]]:
            '''The format configuration of a column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-formatconfiguration
            '''
            result = self._values.get("format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FormatConfigurationProperty"]], result)

        @builtins.property
        def role(self) -> typing.Optional[builtins.str]:
            '''The role of the column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-role
            '''
            result = self._values.get("role")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColumnConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnHierarchyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "date_time_hierarchy": "dateTimeHierarchy",
            "explicit_hierarchy": "explicitHierarchy",
            "predefined_hierarchy": "predefinedHierarchy",
        },
    )
    class ColumnHierarchyProperty:
        def __init__(
            self,
            *,
            date_time_hierarchy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimeHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            explicit_hierarchy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ExplicitHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            predefined_hierarchy: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.PredefinedHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The option that determines the hierarchy of the fields for a visual element.

            :param date_time_hierarchy: The option that determines the hierarchy of any ``DateTime`` fields.
            :param explicit_hierarchy: The option that determines the hierarchy of the fields that are built within a visual's field wells. These fields can't be duplicated to other visuals.
            :param predefined_hierarchy: The option that determines the hierarchy of the fields that are defined during data preparation. These fields are available to use in any analysis that uses the data source.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                column_hierarchy_property = quicksight.CfnAnalysis.ColumnHierarchyProperty(
                    date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                        hierarchy_id="hierarchyId",
                
                        # the properties below are optional
                        drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                            category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                category_values=["categoryValues"],
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                value=123
                            ),
                            time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                range_maximum="rangeMaximum",
                                range_minimum="rangeMinimum",
                                time_granularity="timeGranularity"
                            )
                        )]
                    ),
                    explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                        columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        )],
                        hierarchy_id="hierarchyId",
                
                        # the properties below are optional
                        drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                            category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                category_values=["categoryValues"],
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                value=123
                            ),
                            time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                range_maximum="rangeMaximum",
                                range_minimum="rangeMinimum",
                                time_granularity="timeGranularity"
                            )
                        )]
                    ),
                    predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                        columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        )],
                        hierarchy_id="hierarchyId",
                
                        # the properties below are optional
                        drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                            category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                category_values=["categoryValues"],
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                value=123
                            ),
                            time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                range_maximum="rangeMaximum",
                                range_minimum="rangeMinimum",
                                time_granularity="timeGranularity"
                            )
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9af0953c9dd6d093bb97c949a7eafa66197bdadb0d2a6546efbbea740696b37e)
                check_type(argname="argument date_time_hierarchy", value=date_time_hierarchy, expected_type=type_hints["date_time_hierarchy"])
                check_type(argname="argument explicit_hierarchy", value=explicit_hierarchy, expected_type=type_hints["explicit_hierarchy"])
                check_type(argname="argument predefined_hierarchy", value=predefined_hierarchy, expected_type=type_hints["predefined_hierarchy"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if date_time_hierarchy is not None:
                self._values["date_time_hierarchy"] = date_time_hierarchy
            if explicit_hierarchy is not None:
                self._values["explicit_hierarchy"] = explicit_hierarchy
            if predefined_hierarchy is not None:
                self._values["predefined_hierarchy"] = predefined_hierarchy

        @builtins.property
        def date_time_hierarchy(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeHierarchyProperty"]]:
            '''The option that determines the hierarchy of any ``DateTime`` fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-datetimehierarchy
            '''
            result = self._values.get("date_time_hierarchy")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeHierarchyProperty"]], result)

        @builtins.property
        def explicit_hierarchy(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ExplicitHierarchyProperty"]]:
            '''The option that determines the hierarchy of the fields that are built within a visual's field wells.

            These fields can't be duplicated to other visuals.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-explicithierarchy
            '''
            result = self._values.get("explicit_hierarchy")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ExplicitHierarchyProperty"]], result)

        @builtins.property
        def predefined_hierarchy(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PredefinedHierarchyProperty"]]:
            '''The option that determines the hierarchy of the fields that are defined during data preparation.

            These fields are available to use in any analysis that uses the data source.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-predefinedhierarchy
            '''
            result = self._values.get("predefined_hierarchy")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PredefinedHierarchyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColumnHierarchyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnIdentifierProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column_name": "columnName",
            "data_set_identifier": "dataSetIdentifier",
        },
    )
    class ColumnIdentifierProperty:
        def __init__(
            self,
            *,
            column_name: builtins.str,
            data_set_identifier: builtins.str,
        ) -> None:
            '''A column of a data set.

            :param column_name: The name of the column.
            :param data_set_identifier: The data set that the column belongs to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                column_identifier_property = quicksight.CfnAnalysis.ColumnIdentifierProperty(
                    column_name="columnName",
                    data_set_identifier="dataSetIdentifier"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__46742d202db724573544c68fcaf77bebd24074a6cfe5236855684fee3384e8ad)
                check_type(argname="argument column_name", value=column_name, expected_type=type_hints["column_name"])
                check_type(argname="argument data_set_identifier", value=data_set_identifier, expected_type=type_hints["data_set_identifier"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column_name": column_name,
                "data_set_identifier": data_set_identifier,
            }

        @builtins.property
        def column_name(self) -> builtins.str:
            '''The name of the column.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-columnname
            '''
            result = self._values.get("column_name")
            assert result is not None, "Required property 'column_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def data_set_identifier(self) -> builtins.str:
            '''The data set that the column belongs to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-datasetidentifier
            '''
            result = self._values.get("data_set_identifier")
            assert result is not None, "Required property 'data_set_identifier' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColumnIdentifierProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnSortProperty",
        jsii_struct_bases=[],
        name_mapping={
            "direction": "direction",
            "sort_by": "sortBy",
            "aggregation_function": "aggregationFunction",
        },
    )
    class ColumnSortProperty:
        def __init__(
            self,
            *,
            direction: builtins.str,
            sort_by: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            aggregation_function: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AggregationFunctionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The sort configuration for a column that is not used in a field well.

            :param direction: The sort direction.
            :param sort_by: 
            :param aggregation_function: The aggregation function that is defined in the column sort.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                column_sort_property = quicksight.CfnAnalysis.ColumnSortProperty(
                    direction="direction",
                    sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                
                    # the properties below are optional
                    aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                        attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                            simple_attribute_aggregation="simpleAttributeAggregation",
                            value_for_multiple_values="valueForMultipleValues"
                        ),
                        categorical_aggregation_function="categoricalAggregationFunction",
                        date_aggregation_function="dateAggregationFunction",
                        numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                            percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                percentile_value=123
                            ),
                            simple_numerical_aggregation="simpleNumericalAggregation"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f5996308d06dca8fcdc4fccbb3e75d61da28c753855f270dcfe532b6588e65d4)
                check_type(argname="argument direction", value=direction, expected_type=type_hints["direction"])
                check_type(argname="argument sort_by", value=sort_by, expected_type=type_hints["sort_by"])
                check_type(argname="argument aggregation_function", value=aggregation_function, expected_type=type_hints["aggregation_function"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "direction": direction,
                "sort_by": sort_by,
            }
            if aggregation_function is not None:
                self._values["aggregation_function"] = aggregation_function

        @builtins.property
        def direction(self) -> builtins.str:
            '''The sort direction.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-direction
            '''
            result = self._values.get("direction")
            assert result is not None, "Required property 'direction' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def sort_by(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-sortby
            '''
            result = self._values.get("sort_by")
            assert result is not None, "Required property 'sort_by' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def aggregation_function(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]]:
            '''The aggregation function that is defined in the column sort.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-aggregationfunction
            '''
            result = self._values.get("aggregation_function")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColumnSortProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnTooltipItemProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "aggregation": "aggregation",
            "label": "label",
            "tooltip_target": "tooltipTarget",
            "visibility": "visibility",
        },
    )
    class ColumnTooltipItemProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            aggregation: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AggregationFunctionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label: typing.Optional[builtins.str] = None,
            tooltip_target: typing.Optional[builtins.str] = None,
            visibility: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The tooltip item for the columns that are not part of a field well.

            :param column: The target column of the tooltip item.
            :param aggregation: The aggregation function of the column tooltip item.
            :param label: The label of the tooltip item.
            :param tooltip_target: Determines the target of the column tooltip item in a combo chart visual.
            :param visibility: The visibility of the tooltip item.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                column_tooltip_item_property = quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                
                    # the properties below are optional
                    aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                        attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                            simple_attribute_aggregation="simpleAttributeAggregation",
                            value_for_multiple_values="valueForMultipleValues"
                        ),
                        categorical_aggregation_function="categoricalAggregationFunction",
                        date_aggregation_function="dateAggregationFunction",
                        numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                            percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                percentile_value=123
                            ),
                            simple_numerical_aggregation="simpleNumericalAggregation"
                        )
                    ),
                    label="label",
                    tooltip_target="tooltipTarget",
                    visibility="visibility"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__12db1f9cc37d2edf229e12062c9eab5719bcac0eab45d7cef4de82861fd08916)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument aggregation", value=aggregation, expected_type=type_hints["aggregation"])
                check_type(argname="argument label", value=label, expected_type=type_hints["label"])
                check_type(argname="argument tooltip_target", value=tooltip_target, expected_type=type_hints["tooltip_target"])
                check_type(argname="argument visibility", value=visibility, expected_type=type_hints["visibility"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
            }
            if aggregation is not None:
                self._values["aggregation"] = aggregation
            if label is not None:
                self._values["label"] = label
            if tooltip_target is not None:
                self._values["tooltip_target"] = tooltip_target
            if visibility is not None:
                self._values["visibility"] = visibility

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The target column of the tooltip item.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def aggregation(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]]:
            '''The aggregation function of the column tooltip item.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-aggregation
            '''
            result = self._values.get("aggregation")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AggregationFunctionProperty"]], result)

        @builtins.property
        def label(self) -> typing.Optional[builtins.str]:
            '''The label of the tooltip item.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-label
            '''
            result = self._values.get("label")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def tooltip_target(self) -> typing.Optional[builtins.str]:
            '''Determines the target of the column tooltip item in a combo chart visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-tooltiptarget
            '''
            result = self._values.get("tooltip_target")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def visibility(self) -> typing.Optional[builtins.str]:
            '''The visibility of the tooltip item.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-visibility
            '''
            result = self._values.get("visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColumnTooltipItemProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bar_values": "barValues",
            "category": "category",
            "colors": "colors",
            "line_values": "lineValues",
        },
    )
    class ComboChartAggregatedFieldWellsProperty:
        def __init__(
            self,
            *,
            bar_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MeasureFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            category: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            colors: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            line_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MeasureFieldProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The aggregated field wells of a combo chart.

            :param bar_values: The aggregated ``BarValues`` field well of a combo chart.
            :param category: The aggregated category field wells of a combo chart.
            :param colors: The aggregated colors field well of a combo chart.
            :param line_values: The aggregated ``LineValues`` field well of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__591a9749b2006f091f1b536872c6d1c0855cefdd0be4aee2b30d49d9fbfa0233)
                check_type(argname="argument bar_values", value=bar_values, expected_type=type_hints["bar_values"])
                check_type(argname="argument category", value=category, expected_type=type_hints["category"])
                check_type(argname="argument colors", value=colors, expected_type=type_hints["colors"])
                check_type(argname="argument line_values", value=line_values, expected_type=type_hints["line_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if bar_values is not None:
                self._values["bar_values"] = bar_values
            if category is not None:
                self._values["category"] = category
            if colors is not None:
                self._values["colors"] = colors
            if line_values is not None:
                self._values["line_values"] = line_values

        @builtins.property
        def bar_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]]:
            '''The aggregated ``BarValues`` field well of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-barvalues
            '''
            result = self._values.get("bar_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]], result)

        @builtins.property
        def category(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The aggregated category field wells of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-category
            '''
            result = self._values.get("category")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def colors(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]]:
            '''The aggregated colors field well of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-colors
            '''
            result = self._values.get("colors")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DimensionFieldProperty"]]]], result)

        @builtins.property
        def line_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]]:
            '''The aggregated ``LineValues`` field well of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-linevalues
            '''
            result = self._values.get("line_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MeasureFieldProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComboChartAggregatedFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bar_data_labels": "barDataLabels",
            "bars_arrangement": "barsArrangement",
            "category_axis": "categoryAxis",
            "category_label_options": "categoryLabelOptions",
            "color_label_options": "colorLabelOptions",
            "field_wells": "fieldWells",
            "interactions": "interactions",
            "legend": "legend",
            "line_data_labels": "lineDataLabels",
            "primary_y_axis_display_options": "primaryYAxisDisplayOptions",
            "primary_y_axis_label_options": "primaryYAxisLabelOptions",
            "reference_lines": "referenceLines",
            "secondary_y_axis_display_options": "secondaryYAxisDisplayOptions",
            "secondary_y_axis_label_options": "secondaryYAxisLabelOptions",
            "single_axis_options": "singleAxisOptions",
            "sort_configuration": "sortConfiguration",
            "tooltip": "tooltip",
            "visual_palette": "visualPalette",
        },
    )
    class ComboChartConfigurationProperty:
        def __init__(
            self,
            *,
            bar_data_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            bars_arrangement: typing.Optional[builtins.str] = None,
            category_axis: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            color_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ComboChartFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            interactions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualInteractionOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            legend: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LegendOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            line_data_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            primary_y_axis_display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            primary_y_axis_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            reference_lines: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ReferenceLineProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            secondary_y_axis_display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.AxisDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            secondary_y_axis_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ChartAxisLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            single_axis_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SingleAxisOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sort_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ComboChartSortConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            tooltip: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TooltipOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_palette: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualPaletteProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of a ``ComboChartVisual`` .

            :param bar_data_labels: The options that determine if visual data labels are displayed. The data label options for a bar in a combo chart.
            :param bars_arrangement: Determines the bar arrangement in a combo chart. The following are valid values in this structure:. - ``CLUSTERED`` : For clustered bar combo charts. - ``STACKED`` : For stacked bar combo charts. - ``STACKED_PERCENT`` : Do not use. If you use this value, the operation returns a validation error.
            :param category_axis: The category axis of a combo chart.
            :param category_label_options: The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
            :param color_label_options: The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
            :param field_wells: The field wells of the visual.
            :param interactions: The general visual interactions setup for a visual.
            :param legend: The legend display setup of the visual.
            :param line_data_labels: The options that determine if visual data labels are displayed. The data label options for a line in a combo chart.
            :param primary_y_axis_display_options: The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
            :param primary_y_axis_label_options: The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
            :param reference_lines: The reference line setup of the visual.
            :param secondary_y_axis_display_options: The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
            :param secondary_y_axis_label_options: The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
            :param single_axis_options: 
            :param sort_configuration: The sort configuration of a ``ComboChartVisual`` .
            :param tooltip: The legend display setup of the visual.
            :param visual_palette: The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a515c71821e7f00825720a4573683ad269b842d55f7b80847bdc1398d91a83f9)
                check_type(argname="argument bar_data_labels", value=bar_data_labels, expected_type=type_hints["bar_data_labels"])
                check_type(argname="argument bars_arrangement", value=bars_arrangement, expected_type=type_hints["bars_arrangement"])
                check_type(argname="argument category_axis", value=category_axis, expected_type=type_hints["category_axis"])
                check_type(argname="argument category_label_options", value=category_label_options, expected_type=type_hints["category_label_options"])
                check_type(argname="argument color_label_options", value=color_label_options, expected_type=type_hints["color_label_options"])
                check_type(argname="argument field_wells", value=field_wells, expected_type=type_hints["field_wells"])
                check_type(argname="argument interactions", value=interactions, expected_type=type_hints["interactions"])
                check_type(argname="argument legend", value=legend, expected_type=type_hints["legend"])
                check_type(argname="argument line_data_labels", value=line_data_labels, expected_type=type_hints["line_data_labels"])
                check_type(argname="argument primary_y_axis_display_options", value=primary_y_axis_display_options, expected_type=type_hints["primary_y_axis_display_options"])
                check_type(argname="argument primary_y_axis_label_options", value=primary_y_axis_label_options, expected_type=type_hints["primary_y_axis_label_options"])
                check_type(argname="argument reference_lines", value=reference_lines, expected_type=type_hints["reference_lines"])
                check_type(argname="argument secondary_y_axis_display_options", value=secondary_y_axis_display_options, expected_type=type_hints["secondary_y_axis_display_options"])
                check_type(argname="argument secondary_y_axis_label_options", value=secondary_y_axis_label_options, expected_type=type_hints["secondary_y_axis_label_options"])
                check_type(argname="argument single_axis_options", value=single_axis_options, expected_type=type_hints["single_axis_options"])
                check_type(argname="argument sort_configuration", value=sort_configuration, expected_type=type_hints["sort_configuration"])
                check_type(argname="argument tooltip", value=tooltip, expected_type=type_hints["tooltip"])
                check_type(argname="argument visual_palette", value=visual_palette, expected_type=type_hints["visual_palette"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if bar_data_labels is not None:
                self._values["bar_data_labels"] = bar_data_labels
            if bars_arrangement is not None:
                self._values["bars_arrangement"] = bars_arrangement
            if category_axis is not None:
                self._values["category_axis"] = category_axis
            if category_label_options is not None:
                self._values["category_label_options"] = category_label_options
            if color_label_options is not None:
                self._values["color_label_options"] = color_label_options
            if field_wells is not None:
                self._values["field_wells"] = field_wells
            if interactions is not None:
                self._values["interactions"] = interactions
            if legend is not None:
                self._values["legend"] = legend
            if line_data_labels is not None:
                self._values["line_data_labels"] = line_data_labels
            if primary_y_axis_display_options is not None:
                self._values["primary_y_axis_display_options"] = primary_y_axis_display_options
            if primary_y_axis_label_options is not None:
                self._values["primary_y_axis_label_options"] = primary_y_axis_label_options
            if reference_lines is not None:
                self._values["reference_lines"] = reference_lines
            if secondary_y_axis_display_options is not None:
                self._values["secondary_y_axis_display_options"] = secondary_y_axis_display_options
            if secondary_y_axis_label_options is not None:
                self._values["secondary_y_axis_label_options"] = secondary_y_axis_label_options
            if single_axis_options is not None:
                self._values["single_axis_options"] = single_axis_options
            if sort_configuration is not None:
                self._values["sort_configuration"] = sort_configuration
            if tooltip is not None:
                self._values["tooltip"] = tooltip
            if visual_palette is not None:
                self._values["visual_palette"] = visual_palette

        @builtins.property
        def bar_data_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]]:
            '''The options that determine if visual data labels are displayed.

            The data label options for a bar in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-bardatalabels
            '''
            result = self._values.get("bar_data_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]], result)

        @builtins.property
        def bars_arrangement(self) -> typing.Optional[builtins.str]:
            '''Determines the bar arrangement in a combo chart. The following are valid values in this structure:.

            - ``CLUSTERED`` : For clustered bar combo charts.
            - ``STACKED`` : For stacked bar combo charts.
            - ``STACKED_PERCENT`` : Do not use. If you use this value, the operation returns a validation error.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-barsarrangement
            '''
            result = self._values.get("bars_arrangement")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def category_axis(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The category axis of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categoryaxis
            '''
            result = self._values.get("category_axis")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def category_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categorylabeloptions
            '''
            result = self._values.get("category_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def color_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-colorlabeloptions
            '''
            result = self._values.get("color_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartFieldWellsProperty"]]:
            '''The field wells of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-fieldwells
            '''
            result = self._values.get("field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartFieldWellsProperty"]], result)

        @builtins.property
        def interactions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]]:
            '''The general visual interactions setup for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-interactions
            '''
            result = self._values.get("interactions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]], result)

        @builtins.property
        def legend(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]]:
            '''The legend display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-legend
            '''
            result = self._values.get("legend")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LegendOptionsProperty"]], result)

        @builtins.property
        def line_data_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]]:
            '''The options that determine if visual data labels are displayed.

            The data label options for a line in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-linedatalabels
            '''
            result = self._values.get("line_data_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelOptionsProperty"]], result)

        @builtins.property
        def primary_y_axis_display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxisdisplayoptions
            '''
            result = self._values.get("primary_y_axis_display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def primary_y_axis_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxislabeloptions
            '''
            result = self._values.get("primary_y_axis_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def reference_lines(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]]:
            '''The reference line setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-referencelines
            '''
            result = self._values.get("reference_lines")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ReferenceLineProperty"]]]], result)

        @builtins.property
        def secondary_y_axis_display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]]:
            '''The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxisdisplayoptions
            '''
            result = self._values.get("secondary_y_axis_display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.AxisDisplayOptionsProperty"]], result)

        @builtins.property
        def secondary_y_axis_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]]:
            '''The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxislabeloptions
            '''
            result = self._values.get("secondary_y_axis_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ChartAxisLabelOptionsProperty"]], result)

        @builtins.property
        def single_axis_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SingleAxisOptionsProperty"]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-singleaxisoptions
            '''
            result = self._values.get("single_axis_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SingleAxisOptionsProperty"]], result)

        @builtins.property
        def sort_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartSortConfigurationProperty"]]:
            '''The sort configuration of a ``ComboChartVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-sortconfiguration
            '''
            result = self._values.get("sort_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartSortConfigurationProperty"]], result)

        @builtins.property
        def tooltip(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]]:
            '''The legend display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-tooltip
            '''
            result = self._values.get("tooltip")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TooltipOptionsProperty"]], result)

        @builtins.property
        def visual_palette(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]]:
            '''The palette (chart color) display setup of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-visualpalette
            '''
            result = self._values.get("visual_palette")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualPaletteProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComboChartConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartFieldWellsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "combo_chart_aggregated_field_wells": "comboChartAggregatedFieldWells",
        },
    )
    class ComboChartFieldWellsProperty:
        def __init__(
            self,
            *,
            combo_chart_aggregated_field_wells: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ComboChartAggregatedFieldWellsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The field wells of the visual.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param combo_chart_aggregated_field_wells: The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3147af60ae2143d1a034a36f8c9a82e70085ccb8ab9084867cf2765ed2324af3)
                check_type(argname="argument combo_chart_aggregated_field_wells", value=combo_chart_aggregated_field_wells, expected_type=type_hints["combo_chart_aggregated_field_wells"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if combo_chart_aggregated_field_wells is not None:
                self._values["combo_chart_aggregated_field_wells"] = combo_chart_aggregated_field_wells

        @builtins.property
        def combo_chart_aggregated_field_wells(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartAggregatedFieldWellsProperty"]]:
            '''The aggregated field wells of a combo chart.

            Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html#cfn-quicksight-analysis-combochartfieldwells-combochartaggregatedfieldwells
            '''
            result = self._values.get("combo_chart_aggregated_field_wells")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartAggregatedFieldWellsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComboChartFieldWellsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartSortConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "category_items_limit": "categoryItemsLimit",
            "category_sort": "categorySort",
            "color_items_limit": "colorItemsLimit",
            "color_sort": "colorSort",
        },
    )
    class ComboChartSortConfigurationProperty:
        def __init__(
            self,
            *,
            category_items_limit: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ItemsLimitConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            category_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            color_items_limit: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ItemsLimitConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            color_sort: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldSortOptionsProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The sort configuration of a ``ComboChartVisual`` .

            :param category_items_limit: The item limit configuration for the category field well of a combo chart.
            :param category_sort: The sort configuration of the category field well in a combo chart.
            :param color_items_limit: The item limit configuration of the color field well in a combo chart.
            :param color_sort: The sort configuration of the color field well in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                combo_chart_sort_configuration_property = quicksight.CfnAnalysis.ComboChartSortConfigurationProperty(
                    category_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                        items_limit=123,
                        other_categories="otherCategories"
                    ),
                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )],
                    color_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                        items_limit=123,
                        other_categories="otherCategories"
                    ),
                    color_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                            direction="direction",
                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                attribute_aggregation_function=quicksight.CfnAnalysis.AttributeAggregationFunctionProperty(
                                    simple_attribute_aggregation="simpleAttributeAggregation",
                                    value_for_multiple_values="valueForMultipleValues"
                                ),
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            )
                        ),
                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                            direction="direction",
                            field_id="fieldId"
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__faaa8b2a496188587008b5c7df0d9610c9d579850447a07f3ed4c0e5d23a2ad5)
                check_type(argname="argument category_items_limit", value=category_items_limit, expected_type=type_hints["category_items_limit"])
                check_type(argname="argument category_sort", value=category_sort, expected_type=type_hints["category_sort"])
                check_type(argname="argument color_items_limit", value=color_items_limit, expected_type=type_hints["color_items_limit"])
                check_type(argname="argument color_sort", value=color_sort, expected_type=type_hints["color_sort"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if category_items_limit is not None:
                self._values["category_items_limit"] = category_items_limit
            if category_sort is not None:
                self._values["category_sort"] = category_sort
            if color_items_limit is not None:
                self._values["color_items_limit"] = color_items_limit
            if color_sort is not None:
                self._values["color_sort"] = color_sort

        @builtins.property
        def category_items_limit(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]]:
            '''The item limit configuration for the category field well of a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categoryitemslimit
            '''
            result = self._values.get("category_items_limit")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]], result)

        @builtins.property
        def category_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of the category field well in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categorysort
            '''
            result = self._values.get("category_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        @builtins.property
        def color_items_limit(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]]:
            '''The item limit configuration of the color field well in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-coloritemslimit
            '''
            result = self._values.get("color_items_limit")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ItemsLimitConfigurationProperty"]], result)

        @builtins.property
        def color_sort(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]]:
            '''The sort configuration of the color field well in a combo chart.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-colorsort
            '''
            result = self._values.get("color_sort")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldSortOptionsProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComboChartSortConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartVisualProperty",
        jsii_struct_bases=[],
        name_mapping={
            "visual_id": "visualId",
            "actions": "actions",
            "chart_configuration": "chartConfiguration",
            "column_hierarchies": "columnHierarchies",
            "subtitle": "subtitle",
            "title": "title",
            "visual_content_alt_text": "visualContentAltText",
        },
    )
    class ComboChartVisualProperty:
        def __init__(
            self,
            *,
            visual_id: builtins.str,
            actions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualCustomActionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            chart_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ComboChartConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            column_hierarchies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnHierarchyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            subtitle: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualSubtitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            title: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualTitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_content_alt_text: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A combo chart.

            The ``ComboChartVisual`` includes stacked bar combo charts and clustered bar combo charts

            For more information, see `Using combo charts <https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html>`_ in the *Amazon QuickSight User Guide* .

            :param visual_id: The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
            :param actions: The list of custom actions that are configured for a visual.
            :param chart_configuration: The configuration settings of the visual.
            :param column_hierarchies: The column hierarchy that is used during drill-downs and drill-ups.
            :param subtitle: The subtitle that is displayed on the visual.
            :param title: The title that is displayed on the visual.
            :param visual_content_alt_text: The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b14c3bbad40e0afa7fd81b42e30c7725d3f3d5f2db8054112cc12f490640ad4c)
                check_type(argname="argument visual_id", value=visual_id, expected_type=type_hints["visual_id"])
                check_type(argname="argument actions", value=actions, expected_type=type_hints["actions"])
                check_type(argname="argument chart_configuration", value=chart_configuration, expected_type=type_hints["chart_configuration"])
                check_type(argname="argument column_hierarchies", value=column_hierarchies, expected_type=type_hints["column_hierarchies"])
                check_type(argname="argument subtitle", value=subtitle, expected_type=type_hints["subtitle"])
                check_type(argname="argument title", value=title, expected_type=type_hints["title"])
                check_type(argname="argument visual_content_alt_text", value=visual_content_alt_text, expected_type=type_hints["visual_content_alt_text"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "visual_id": visual_id,
            }
            if actions is not None:
                self._values["actions"] = actions
            if chart_configuration is not None:
                self._values["chart_configuration"] = chart_configuration
            if column_hierarchies is not None:
                self._values["column_hierarchies"] = column_hierarchies
            if subtitle is not None:
                self._values["subtitle"] = subtitle
            if title is not None:
                self._values["title"] = title
            if visual_content_alt_text is not None:
                self._values["visual_content_alt_text"] = visual_content_alt_text

        @builtins.property
        def visual_id(self) -> builtins.str:
            '''The unique identifier of a visual.

            This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-visualid
            '''
            result = self._values.get("visual_id")
            assert result is not None, "Required property 'visual_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def actions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]]:
            '''The list of custom actions that are configured for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-actions
            '''
            result = self._values.get("actions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]], result)

        @builtins.property
        def chart_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartConfigurationProperty"]]:
            '''The configuration settings of the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-chartconfiguration
            '''
            result = self._values.get("chart_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComboChartConfigurationProperty"]], result)

        @builtins.property
        def column_hierarchies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]]:
            '''The column hierarchy that is used during drill-downs and drill-ups.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-columnhierarchies
            '''
            result = self._values.get("column_hierarchies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnHierarchyProperty"]]]], result)

        @builtins.property
        def subtitle(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]]:
            '''The subtitle that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-subtitle
            '''
            result = self._values.get("subtitle")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]], result)

        @builtins.property
        def title(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]]:
            '''The title that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-title
            '''
            result = self._values.get("title")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]], result)

        @builtins.property
        def visual_content_alt_text(self) -> typing.Optional[builtins.str]:
            '''The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-visualcontentalttext
            '''
            result = self._values.get("visual_content_alt_text")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComboChartVisualProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComparisonConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "comparison_format": "comparisonFormat",
            "comparison_method": "comparisonMethod",
        },
    )
    class ComparisonConfigurationProperty:
        def __init__(
            self,
            *,
            comparison_format: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ComparisonFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            comparison_method: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The comparison display configuration of a KPI or gauge chart.

            :param comparison_format: The format of the comparison.
            :param comparison_method: The method of the comparison. Choose from the following options:. - ``DIFFERENCE`` - ``PERCENT_DIFFERENCE`` - ``PERCENT``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                comparison_configuration_property = quicksight.CfnAnalysis.ComparisonConfigurationProperty(
                    comparison_format=quicksight.CfnAnalysis.ComparisonFormatConfigurationProperty(
                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                decimal_places=123
                            ),
                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                display_mode="displayMode"
                            ),
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            number_scale="numberScale",
                            prefix="prefix",
                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                decimal_separator="decimalSeparator",
                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                    grouping_style="groupingStyle",
                                    symbol="symbol",
                                    visibility="visibility"
                                )
                            ),
                            suffix="suffix"
                        ),
                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                decimal_places=123
                            ),
                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                display_mode="displayMode"
                            ),
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            prefix="prefix",
                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                decimal_separator="decimalSeparator",
                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                    grouping_style="groupingStyle",
                                    symbol="symbol",
                                    visibility="visibility"
                                )
                            ),
                            suffix="suffix"
                        )
                    ),
                    comparison_method="comparisonMethod"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__efcddd73fc9f096352e7d41e36263d6ac82160f33a961daa63e25016155bb1d7)
                check_type(argname="argument comparison_format", value=comparison_format, expected_type=type_hints["comparison_format"])
                check_type(argname="argument comparison_method", value=comparison_method, expected_type=type_hints["comparison_method"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if comparison_format is not None:
                self._values["comparison_format"] = comparison_format
            if comparison_method is not None:
                self._values["comparison_method"] = comparison_method

        @builtins.property
        def comparison_format(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComparisonFormatConfigurationProperty"]]:
            '''The format of the comparison.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html#cfn-quicksight-analysis-comparisonconfiguration-comparisonformat
            '''
            result = self._values.get("comparison_format")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ComparisonFormatConfigurationProperty"]], result)

        @builtins.property
        def comparison_method(self) -> typing.Optional[builtins.str]:
            '''The method of the comparison. Choose from the following options:.

            - ``DIFFERENCE``
            - ``PERCENT_DIFFERENCE``
            - ``PERCENT``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html#cfn-quicksight-analysis-comparisonconfiguration-comparisonmethod
            '''
            result = self._values.get("comparison_method")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComparisonConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComparisonFormatConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "number_display_format_configuration": "numberDisplayFormatConfiguration",
            "percentage_display_format_configuration": "percentageDisplayFormatConfiguration",
        },
    )
    class ComparisonFormatConfigurationProperty:
        def __init__(
            self,
            *,
            number_display_format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumberDisplayFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            percentage_display_format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.PercentageDisplayFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The format of the comparison.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param number_display_format_configuration: The number display format.
            :param percentage_display_format_configuration: The percentage display format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                comparison_format_configuration_property = quicksight.CfnAnalysis.ComparisonFormatConfigurationProperty(
                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                            decimal_places=123
                        ),
                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                            display_mode="displayMode"
                        ),
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        number_scale="numberScale",
                        prefix="prefix",
                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                            decimal_separator="decimalSeparator",
                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                grouping_style="groupingStyle",
                                symbol="symbol",
                                visibility="visibility"
                            )
                        ),
                        suffix="suffix"
                    ),
                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                            decimal_places=123
                        ),
                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                            display_mode="displayMode"
                        ),
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        prefix="prefix",
                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                            decimal_separator="decimalSeparator",
                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                grouping_style="groupingStyle",
                                symbol="symbol",
                                visibility="visibility"
                            )
                        ),
                        suffix="suffix"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa91709855f99095961061d282729fba9d83b47411ddcd5cc76b3c7ee88b4975)
                check_type(argname="argument number_display_format_configuration", value=number_display_format_configuration, expected_type=type_hints["number_display_format_configuration"])
                check_type(argname="argument percentage_display_format_configuration", value=percentage_display_format_configuration, expected_type=type_hints["percentage_display_format_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if number_display_format_configuration is not None:
                self._values["number_display_format_configuration"] = number_display_format_configuration
            if percentage_display_format_configuration is not None:
                self._values["percentage_display_format_configuration"] = percentage_display_format_configuration

        @builtins.property
        def number_display_format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumberDisplayFormatConfigurationProperty"]]:
            '''The number display format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html#cfn-quicksight-analysis-comparisonformatconfiguration-numberdisplayformatconfiguration
            '''
            result = self._values.get("number_display_format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumberDisplayFormatConfigurationProperty"]], result)

        @builtins.property
        def percentage_display_format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PercentageDisplayFormatConfigurationProperty"]]:
            '''The percentage display format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html#cfn-quicksight-analysis-comparisonformatconfiguration-percentagedisplayformatconfiguration
            '''
            result = self._values.get("percentage_display_format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PercentageDisplayFormatConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComparisonFormatConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ComputationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "forecast": "forecast",
            "growth_rate": "growthRate",
            "maximum_minimum": "maximumMinimum",
            "metric_comparison": "metricComparison",
            "period_over_period": "periodOverPeriod",
            "period_to_date": "periodToDate",
            "top_bottom_movers": "topBottomMovers",
            "top_bottom_ranked": "topBottomRanked",
            "total_aggregation": "totalAggregation",
            "unique_values": "uniqueValues",
        },
    )
    class ComputationProperty:
        def __init__(
            self,
            *,
            forecast: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ForecastComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            growth_rate: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.GrowthRateComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            maximum_minimum: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MaximumMinimumComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            metric_comparison: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MetricComparisonComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            period_over_period: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.PeriodOverPeriodComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            period_to_date: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.PeriodToDateComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            top_bottom_movers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TopBottomMoversComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            top_bottom_ranked: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TopBottomRankedComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            total_aggregation: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TotalAggregationComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            unique_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.UniqueValuesComputationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The computation union that is used in an insight visual.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param forecast: The forecast computation configuration.
            :param growth_rate: The growth rate computation configuration.
            :param maximum_minimum: The maximum and minimum computation configuration.
            :param metric_comparison: The metric comparison computation configuration.
            :param period_over_period: The period over period computation configuration.
            :param period_to_date: The period to ``DataSetIdentifier`` computation configuration.
            :param top_bottom_movers: The top movers and bottom movers computation configuration.
            :param top_bottom_ranked: The top ranked and bottom ranked computation configuration.
            :param total_aggregation: The total aggregation computation configuration.
            :param unique_values: The unique values computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__10d34f637e011375fff8ef66740a653ac3902a71882f8c6c5f45e4c23f09f53d)
                check_type(argname="argument forecast", value=forecast, expected_type=type_hints["forecast"])
                check_type(argname="argument growth_rate", value=growth_rate, expected_type=type_hints["growth_rate"])
                check_type(argname="argument maximum_minimum", value=maximum_minimum, expected_type=type_hints["maximum_minimum"])
                check_type(argname="argument metric_comparison", value=metric_comparison, expected_type=type_hints["metric_comparison"])
                check_type(argname="argument period_over_period", value=period_over_period, expected_type=type_hints["period_over_period"])
                check_type(argname="argument period_to_date", value=period_to_date, expected_type=type_hints["period_to_date"])
                check_type(argname="argument top_bottom_movers", value=top_bottom_movers, expected_type=type_hints["top_bottom_movers"])
                check_type(argname="argument top_bottom_ranked", value=top_bottom_ranked, expected_type=type_hints["top_bottom_ranked"])
                check_type(argname="argument total_aggregation", value=total_aggregation, expected_type=type_hints["total_aggregation"])
                check_type(argname="argument unique_values", value=unique_values, expected_type=type_hints["unique_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if forecast is not None:
                self._values["forecast"] = forecast
            if growth_rate is not None:
                self._values["growth_rate"] = growth_rate
            if maximum_minimum is not None:
                self._values["maximum_minimum"] = maximum_minimum
            if metric_comparison is not None:
                self._values["metric_comparison"] = metric_comparison
            if period_over_period is not None:
                self._values["period_over_period"] = period_over_period
            if period_to_date is not None:
                self._values["period_to_date"] = period_to_date
            if top_bottom_movers is not None:
                self._values["top_bottom_movers"] = top_bottom_movers
            if top_bottom_ranked is not None:
                self._values["top_bottom_ranked"] = top_bottom_ranked
            if total_aggregation is not None:
                self._values["total_aggregation"] = total_aggregation
            if unique_values is not None:
                self._values["unique_values"] = unique_values

        @builtins.property
        def forecast(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ForecastComputationProperty"]]:
            '''The forecast computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-forecast
            '''
            result = self._values.get("forecast")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ForecastComputationProperty"]], result)

        @builtins.property
        def growth_rate(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GrowthRateComputationProperty"]]:
            '''The growth rate computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-growthrate
            '''
            result = self._values.get("growth_rate")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GrowthRateComputationProperty"]], result)

        @builtins.property
        def maximum_minimum(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MaximumMinimumComputationProperty"]]:
            '''The maximum and minimum computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-maximumminimum
            '''
            result = self._values.get("maximum_minimum")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MaximumMinimumComputationProperty"]], result)

        @builtins.property
        def metric_comparison(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MetricComparisonComputationProperty"]]:
            '''The metric comparison computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-metriccomparison
            '''
            result = self._values.get("metric_comparison")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MetricComparisonComputationProperty"]], result)

        @builtins.property
        def period_over_period(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PeriodOverPeriodComputationProperty"]]:
            '''The period over period computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-periodoverperiod
            '''
            result = self._values.get("period_over_period")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PeriodOverPeriodComputationProperty"]], result)

        @builtins.property
        def period_to_date(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PeriodToDateComputationProperty"]]:
            '''The period to ``DataSetIdentifier`` computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-periodtodate
            '''
            result = self._values.get("period_to_date")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.PeriodToDateComputationProperty"]], result)

        @builtins.property
        def top_bottom_movers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TopBottomMoversComputationProperty"]]:
            '''The top movers and bottom movers computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-topbottommovers
            '''
            result = self._values.get("top_bottom_movers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TopBottomMoversComputationProperty"]], result)

        @builtins.property
        def top_bottom_ranked(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TopBottomRankedComputationProperty"]]:
            '''The top ranked and bottom ranked computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-topbottomranked
            '''
            result = self._values.get("top_bottom_ranked")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TopBottomRankedComputationProperty"]], result)

        @builtins.property
        def total_aggregation(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TotalAggregationComputationProperty"]]:
            '''The total aggregation computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-totalaggregation
            '''
            result = self._values.get("total_aggregation")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TotalAggregationComputationProperty"]], result)

        @builtins.property
        def unique_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.UniqueValuesComputationProperty"]]:
            '''The unique values computation configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-uniquevalues
            '''
            result = self._values.get("unique_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.UniqueValuesComputationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ComputationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingColorProperty",
        jsii_struct_bases=[],
        name_mapping={"gradient": "gradient", "solid": "solid"},
    )
    class ConditionalFormattingColorProperty:
        def __init__(
            self,
            *,
            gradient: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingGradientColorProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            solid: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingSolidColorProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The formatting configuration for the color.

            :param gradient: Formatting configuration for gradient color.
            :param solid: Formatting configuration for solid color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_color_property = quicksight.CfnAnalysis.ConditionalFormattingColorProperty(
                    gradient=quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty(
                        color=quicksight.CfnAnalysis.GradientColorProperty(
                            stops=[quicksight.CfnAnalysis.GradientStopProperty(
                                gradient_offset=123,
                
                                # the properties below are optional
                                color="color",
                                data_value=123
                            )]
                        ),
                        expression="expression"
                    ),
                    solid=quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty(
                        expression="expression",
                
                        # the properties below are optional
                        color="color"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d52148b7056c2d0312222fff65e42ec0e5fd53022ae05a99fa0d30f027edb590)
                check_type(argname="argument gradient", value=gradient, expected_type=type_hints["gradient"])
                check_type(argname="argument solid", value=solid, expected_type=type_hints["solid"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if gradient is not None:
                self._values["gradient"] = gradient
            if solid is not None:
                self._values["solid"] = solid

        @builtins.property
        def gradient(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingGradientColorProperty"]]:
            '''Formatting configuration for gradient color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html#cfn-quicksight-analysis-conditionalformattingcolor-gradient
            '''
            result = self._values.get("gradient")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingGradientColorProperty"]], result)

        @builtins.property
        def solid(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingSolidColorProperty"]]:
            '''Formatting configuration for solid color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html#cfn-quicksight-analysis-conditionalformattingcolor-solid
            '''
            result = self._values.get("solid")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingSolidColorProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingCustomIconConditionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "expression": "expression",
            "icon_options": "iconOptions",
            "color": "color",
            "display_configuration": "displayConfiguration",
        },
    )
    class ConditionalFormattingCustomIconConditionProperty:
        def __init__(
            self,
            *,
            expression: builtins.str,
            icon_options: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty", typing.Dict[builtins.str, typing.Any]]],
            color: typing.Optional[builtins.str] = None,
            display_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Determines the custom condition for an icon set.

            :param expression: The expression that determines the condition of the icon set.
            :param icon_options: Custom icon options for an icon set.
            :param color: Determines the color of the icon.
            :param display_configuration: Determines the icon display configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_custom_icon_condition_property = quicksight.CfnAnalysis.ConditionalFormattingCustomIconConditionProperty(
                    expression="expression",
                    icon_options=quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty(
                        icon="icon",
                        unicode_icon="unicodeIcon"
                    ),
                
                    # the properties below are optional
                    color="color",
                    display_configuration=quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty(
                        icon_display_option="iconDisplayOption"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c82e4ee5649da3ac08b6284e8b4daf22e5eaab886e5a4f96686f8adaf7eed9d5)
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
                check_type(argname="argument icon_options", value=icon_options, expected_type=type_hints["icon_options"])
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
                check_type(argname="argument display_configuration", value=display_configuration, expected_type=type_hints["display_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "expression": expression,
                "icon_options": icon_options,
            }
            if color is not None:
                self._values["color"] = color
            if display_configuration is not None:
                self._values["display_configuration"] = display_configuration

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression that determines the condition of the icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def icon_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty"]:
            '''Custom icon options for an icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-iconoptions
            '''
            result = self._values.get("icon_options")
            assert result is not None, "Required property 'icon_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty"], result)

        @builtins.property
        def color(self) -> typing.Optional[builtins.str]:
            '''Determines the color of the icon.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-color
            '''
            result = self._values.get("color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty"]]:
            '''Determines the icon display configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-displayconfiguration
            '''
            result = self._values.get("display_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingCustomIconConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"icon": "icon", "unicode_icon": "unicodeIcon"},
    )
    class ConditionalFormattingCustomIconOptionsProperty:
        def __init__(
            self,
            *,
            icon: typing.Optional[builtins.str] = None,
            unicode_icon: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Custom icon options for an icon set.

            :param icon: Determines the type of icon.
            :param unicode_icon: Determines the Unicode icon type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_custom_icon_options_property = quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty(
                    icon="icon",
                    unicode_icon="unicodeIcon"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e2dadbe74f021f3e0e69b962cc389b96db48ba2bbdcd5e500656ada1005067aa)
                check_type(argname="argument icon", value=icon, expected_type=type_hints["icon"])
                check_type(argname="argument unicode_icon", value=unicode_icon, expected_type=type_hints["unicode_icon"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if icon is not None:
                self._values["icon"] = icon
            if unicode_icon is not None:
                self._values["unicode_icon"] = unicode_icon

        @builtins.property
        def icon(self) -> typing.Optional[builtins.str]:
            '''Determines the type of icon.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html#cfn-quicksight-analysis-conditionalformattingcustomiconoptions-icon
            '''
            result = self._values.get("icon")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def unicode_icon(self) -> typing.Optional[builtins.str]:
            '''Determines the Unicode icon type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html#cfn-quicksight-analysis-conditionalformattingcustomiconoptions-unicodeicon
            '''
            result = self._values.get("unicode_icon")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingCustomIconOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty",
        jsii_struct_bases=[],
        name_mapping={"color": "color", "expression": "expression"},
    )
    class ConditionalFormattingGradientColorProperty:
        def __init__(
            self,
            *,
            color: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.GradientColorProperty", typing.Dict[builtins.str, typing.Any]]],
            expression: builtins.str,
        ) -> None:
            '''Formatting configuration for gradient color.

            :param color: Determines the color.
            :param expression: The expression that determines the formatting configuration for gradient color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_gradient_color_property = quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty(
                    color=quicksight.CfnAnalysis.GradientColorProperty(
                        stops=[quicksight.CfnAnalysis.GradientStopProperty(
                            gradient_offset=123,
                
                            # the properties below are optional
                            color="color",
                            data_value=123
                        )]
                    ),
                    expression="expression"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e74308d9e744f21b3a92b03e46e01454a2c192b8b8db9cc813ec014cd56851ab)
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "color": color,
                "expression": expression,
            }

        @builtins.property
        def color(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GradientColorProperty"]:
            '''Determines the color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html#cfn-quicksight-analysis-conditionalformattinggradientcolor-color
            '''
            result = self._values.get("color")
            assert result is not None, "Required property 'color' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GradientColorProperty"], result)

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression that determines the formatting configuration for gradient color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html#cfn-quicksight-analysis-conditionalformattinggradientcolor-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingGradientColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"icon_display_option": "iconDisplayOption"},
    )
    class ConditionalFormattingIconDisplayConfigurationProperty:
        def __init__(
            self,
            *,
            icon_display_option: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Determines the icon display configuration.

            :param icon_display_option: Determines the icon display configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicondisplayconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_icon_display_configuration_property = quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty(
                    icon_display_option="iconDisplayOption"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b8801e4508f2a867536d4c59d5f83793796e56c2f395e012b11fbfed0fc32915)
                check_type(argname="argument icon_display_option", value=icon_display_option, expected_type=type_hints["icon_display_option"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if icon_display_option is not None:
                self._values["icon_display_option"] = icon_display_option

        @builtins.property
        def icon_display_option(self) -> typing.Optional[builtins.str]:
            '''Determines the icon display configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicondisplayconfiguration.html#cfn-quicksight-analysis-conditionalformattingicondisplayconfiguration-icondisplayoption
            '''
            result = self._values.get("icon_display_option")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingIconDisplayConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_condition": "customCondition", "icon_set": "iconSet"},
    )
    class ConditionalFormattingIconProperty:
        def __init__(
            self,
            *,
            custom_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingCustomIconConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            icon_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ConditionalFormattingIconSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The formatting configuration for the icon.

            :param custom_condition: Determines the custom condition for an icon set.
            :param icon_set: Formatting configuration for icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_icon_property = quicksight.CfnAnalysis.ConditionalFormattingIconProperty(
                    custom_condition=quicksight.CfnAnalysis.ConditionalFormattingCustomIconConditionProperty(
                        expression="expression",
                        icon_options=quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty(
                            icon="icon",
                            unicode_icon="unicodeIcon"
                        ),
                
                        # the properties below are optional
                        color="color",
                        display_configuration=quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty(
                            icon_display_option="iconDisplayOption"
                        )
                    ),
                    icon_set=quicksight.CfnAnalysis.ConditionalFormattingIconSetProperty(
                        expression="expression",
                
                        # the properties below are optional
                        icon_set_type="iconSetType"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6df240f326c7bda2dad75563204ea5754a7501cc88f6bd969e922137c95d803a)
                check_type(argname="argument custom_condition", value=custom_condition, expected_type=type_hints["custom_condition"])
                check_type(argname="argument icon_set", value=icon_set, expected_type=type_hints["icon_set"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_condition is not None:
                self._values["custom_condition"] = custom_condition
            if icon_set is not None:
                self._values["icon_set"] = icon_set

        @builtins.property
        def custom_condition(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingCustomIconConditionProperty"]]:
            '''Determines the custom condition for an icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html#cfn-quicksight-analysis-conditionalformattingicon-customcondition
            '''
            result = self._values.get("custom_condition")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingCustomIconConditionProperty"]], result)

        @builtins.property
        def icon_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingIconSetProperty"]]:
            '''Formatting configuration for icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html#cfn-quicksight-analysis-conditionalformattingicon-iconset
            '''
            result = self._values.get("icon_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ConditionalFormattingIconSetProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingIconProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingIconSetProperty",
        jsii_struct_bases=[],
        name_mapping={"expression": "expression", "icon_set_type": "iconSetType"},
    )
    class ConditionalFormattingIconSetProperty:
        def __init__(
            self,
            *,
            expression: builtins.str,
            icon_set_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Formatting configuration for icon set.

            :param expression: The expression that determines the formatting configuration for the icon set.
            :param icon_set_type: Determines the icon set type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_icon_set_property = quicksight.CfnAnalysis.ConditionalFormattingIconSetProperty(
                    expression="expression",
                
                    # the properties below are optional
                    icon_set_type="iconSetType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__37c00764af02fc0e5c936772d2729c7a412350549bea9dd4f115809c91ec66b6)
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
                check_type(argname="argument icon_set_type", value=icon_set_type, expected_type=type_hints["icon_set_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "expression": expression,
            }
            if icon_set_type is not None:
                self._values["icon_set_type"] = icon_set_type

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression that determines the formatting configuration for the icon set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html#cfn-quicksight-analysis-conditionalformattingiconset-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def icon_set_type(self) -> typing.Optional[builtins.str]:
            '''Determines the icon set type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html#cfn-quicksight-analysis-conditionalformattingiconset-iconsettype
            '''
            result = self._values.get("icon_set_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingIconSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty",
        jsii_struct_bases=[],
        name_mapping={"expression": "expression", "color": "color"},
    )
    class ConditionalFormattingSolidColorProperty:
        def __init__(
            self,
            *,
            expression: builtins.str,
            color: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Formatting configuration for solid color.

            :param expression: The expression that determines the formatting configuration for solid color.
            :param color: Determines the color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                conditional_formatting_solid_color_property = quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty(
                    expression="expression",
                
                    # the properties below are optional
                    color="color"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__79725fa3ccee01583125c515396717e5a6314accd5df430e08b159d27267cc2d)
                check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "expression": expression,
            }
            if color is not None:
                self._values["color"] = color

        @builtins.property
        def expression(self) -> builtins.str:
            '''The expression that determines the formatting configuration for solid color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html#cfn-quicksight-analysis-conditionalformattingsolidcolor-expression
            '''
            result = self._values.get("expression")
            assert result is not None, "Required property 'expression' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def color(self) -> typing.Optional[builtins.str]:
            '''Determines the color.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html#cfn-quicksight-analysis-conditionalformattingsolidcolor-color
            '''
            result = self._values.get("color")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionalFormattingSolidColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ContextMenuOptionProperty",
        jsii_struct_bases=[],
        name_mapping={"availability_status": "availabilityStatus"},
    )
    class ContextMenuOptionProperty:
        def __init__(
            self,
            *,
            availability_status: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The context menu options for a visual's interactions.

            :param availability_status: The availability status of the context menu options. If the value of this property is set to ``ENABLED`` , dashboard readers can interact with the context menu.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contextmenuoption.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                context_menu_option_property = quicksight.CfnAnalysis.ContextMenuOptionProperty(
                    availability_status="availabilityStatus"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__41f7c423cd88840e52b18d0e2a968794074f4cfd3dd0157b6b14b7c54583bbae)
                check_type(argname="argument availability_status", value=availability_status, expected_type=type_hints["availability_status"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if availability_status is not None:
                self._values["availability_status"] = availability_status

        @builtins.property
        def availability_status(self) -> typing.Optional[builtins.str]:
            '''The availability status of the context menu options.

            If the value of this property is set to ``ENABLED`` , dashboard readers can interact with the context menu.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contextmenuoption.html#cfn-quicksight-analysis-contextmenuoption-availabilitystatus
            '''
            result = self._values.get("availability_status")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContextMenuOptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.ContributionAnalysisDefaultProperty",
        jsii_struct_bases=[],
        name_mapping={
            "contributor_dimensions": "contributorDimensions",
            "measure_field_id": "measureFieldId",
        },
    )
    class ContributionAnalysisDefaultProperty:
        def __init__(
            self,
            *,
            contributor_dimensions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]]],
            measure_field_id: builtins.str,
        ) -> None:
            '''The contribution analysis visual display for a line, pie, or bar chart.

            :param contributor_dimensions: The dimensions columns that are used in the contribution analysis, usually a list of ``ColumnIdentifiers`` .
            :param measure_field_id: The measure field that is used in the contribution analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                contribution_analysis_default_property = quicksight.CfnAnalysis.ContributionAnalysisDefaultProperty(
                    contributor_dimensions=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    )],
                    measure_field_id="measureFieldId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__14c868a949edd50a1aefe3b168b7430cd7748a22966fb04165749b9a8c09dc8e)
                check_type(argname="argument contributor_dimensions", value=contributor_dimensions, expected_type=type_hints["contributor_dimensions"])
                check_type(argname="argument measure_field_id", value=measure_field_id, expected_type=type_hints["measure_field_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "contributor_dimensions": contributor_dimensions,
                "measure_field_id": measure_field_id,
            }

        @builtins.property
        def contributor_dimensions(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]]]:
            '''The dimensions columns that are used in the contribution analysis, usually a list of ``ColumnIdentifiers`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html#cfn-quicksight-analysis-contributionanalysisdefault-contributordimensions
            '''
            result = self._values.get("contributor_dimensions")
            assert result is not None, "Required property 'contributor_dimensions' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]]], result)

        @builtins.property
        def measure_field_id(self) -> builtins.str:
            '''The measure field that is used in the contribution analysis.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html#cfn-quicksight-analysis-contributionanalysisdefault-measurefieldid
            '''
            result = self._values.get("measure_field_id")
            assert result is not None, "Required property 'measure_field_id' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContributionAnalysisDefaultProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "decimal_places_configuration": "decimalPlacesConfiguration",
            "negative_value_configuration": "negativeValueConfiguration",
            "null_value_format_configuration": "nullValueFormatConfiguration",
            "number_scale": "numberScale",
            "prefix": "prefix",
            "separator_configuration": "separatorConfiguration",
            "suffix": "suffix",
            "symbol": "symbol",
        },
    )
    class CurrencyDisplayFormatConfigurationProperty:
        def __init__(
            self,
            *,
            decimal_places_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DecimalPlacesConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            negative_value_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NegativeValueConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            null_value_format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NullValueFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            number_scale: typing.Optional[builtins.str] = None,
            prefix: typing.Optional[builtins.str] = None,
            separator_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumericSeparatorConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            suffix: typing.Optional[builtins.str] = None,
            symbol: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The options that determine the currency display format configuration.

            :param decimal_places_configuration: The option that determines the decimal places configuration.
            :param negative_value_configuration: The options that determine the negative value configuration.
            :param null_value_format_configuration: The options that determine the null value format configuration.
            :param number_scale: Determines the number scale value for the currency format.
            :param prefix: Determines the prefix value of the currency format.
            :param separator_configuration: The options that determine the numeric separator configuration.
            :param suffix: Determines the suffix value of the currency format.
            :param symbol: Determines the symbol for the currency format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                currency_display_format_configuration_property = quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                        decimal_places=123
                    ),
                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                        display_mode="displayMode"
                    ),
                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                        null_string="nullString"
                    ),
                    number_scale="numberScale",
                    prefix="prefix",
                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                        decimal_separator="decimalSeparator",
                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                            grouping_style="groupingStyle",
                            symbol="symbol",
                            visibility="visibility"
                        )
                    ),
                    suffix="suffix",
                    symbol="symbol"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2d5fef0036b605708ff2c6f83939aef36f764848a1ea8b749ac6a7cb9f7bfac8)
                check_type(argname="argument decimal_places_configuration", value=decimal_places_configuration, expected_type=type_hints["decimal_places_configuration"])
                check_type(argname="argument negative_value_configuration", value=negative_value_configuration, expected_type=type_hints["negative_value_configuration"])
                check_type(argname="argument null_value_format_configuration", value=null_value_format_configuration, expected_type=type_hints["null_value_format_configuration"])
                check_type(argname="argument number_scale", value=number_scale, expected_type=type_hints["number_scale"])
                check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
                check_type(argname="argument separator_configuration", value=separator_configuration, expected_type=type_hints["separator_configuration"])
                check_type(argname="argument suffix", value=suffix, expected_type=type_hints["suffix"])
                check_type(argname="argument symbol", value=symbol, expected_type=type_hints["symbol"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if decimal_places_configuration is not None:
                self._values["decimal_places_configuration"] = decimal_places_configuration
            if negative_value_configuration is not None:
                self._values["negative_value_configuration"] = negative_value_configuration
            if null_value_format_configuration is not None:
                self._values["null_value_format_configuration"] = null_value_format_configuration
            if number_scale is not None:
                self._values["number_scale"] = number_scale
            if prefix is not None:
                self._values["prefix"] = prefix
            if separator_configuration is not None:
                self._values["separator_configuration"] = separator_configuration
            if suffix is not None:
                self._values["suffix"] = suffix
            if symbol is not None:
                self._values["symbol"] = symbol

        @builtins.property
        def decimal_places_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalPlacesConfigurationProperty"]]:
            '''The option that determines the decimal places configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-decimalplacesconfiguration
            '''
            result = self._values.get("decimal_places_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalPlacesConfigurationProperty"]], result)

        @builtins.property
        def negative_value_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NegativeValueConfigurationProperty"]]:
            '''The options that determine the negative value configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-negativevalueconfiguration
            '''
            result = self._values.get("negative_value_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NegativeValueConfigurationProperty"]], result)

        @builtins.property
        def null_value_format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NullValueFormatConfigurationProperty"]]:
            '''The options that determine the null value format configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-nullvalueformatconfiguration
            '''
            result = self._values.get("null_value_format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NullValueFormatConfigurationProperty"]], result)

        @builtins.property
        def number_scale(self) -> typing.Optional[builtins.str]:
            '''Determines the number scale value for the currency format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-numberscale
            '''
            result = self._values.get("number_scale")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def prefix(self) -> typing.Optional[builtins.str]:
            '''Determines the prefix value of the currency format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-prefix
            '''
            result = self._values.get("prefix")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def separator_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericSeparatorConfigurationProperty"]]:
            '''The options that determine the numeric separator configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-separatorconfiguration
            '''
            result = self._values.get("separator_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericSeparatorConfigurationProperty"]], result)

        @builtins.property
        def suffix(self) -> typing.Optional[builtins.str]:
            '''Determines the suffix value of the currency format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-suffix
            '''
            result = self._values.get("suffix")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def symbol(self) -> typing.Optional[builtins.str]:
            '''Determines the symbol for the currency format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-symbol
            '''
            result = self._values.get("symbol")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CurrencyDisplayFormatConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionFilterOperationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "selected_fields_configuration": "selectedFieldsConfiguration",
            "target_visuals_configuration": "targetVisualsConfiguration",
        },
    )
    class CustomActionFilterOperationProperty:
        def __init__(
            self,
            *,
            selected_fields_configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty", typing.Dict[builtins.str, typing.Any]]],
            target_visuals_configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The filter operation that filters data included in a visual or in an entire sheet.

            :param selected_fields_configuration: The configuration that chooses the fields to be filtered.
            :param target_visuals_configuration: The configuration that chooses the target visuals to be filtered.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_action_filter_operation_property = quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                    selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                        selected_columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        )],
                        selected_field_options="selectedFieldOptions",
                        selected_fields=["selectedFields"]
                    ),
                    target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                        same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                            target_visual_options="targetVisualOptions",
                            target_visuals=["targetVisuals"]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a383546d3eec1bdd3b061adab9ba14818917abd43a51c8f586e6db1ffaa56092)
                check_type(argname="argument selected_fields_configuration", value=selected_fields_configuration, expected_type=type_hints["selected_fields_configuration"])
                check_type(argname="argument target_visuals_configuration", value=target_visuals_configuration, expected_type=type_hints["target_visuals_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "selected_fields_configuration": selected_fields_configuration,
                "target_visuals_configuration": target_visuals_configuration,
            }

        @builtins.property
        def selected_fields_configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty"]:
            '''The configuration that chooses the fields to be filtered.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html#cfn-quicksight-analysis-customactionfilteroperation-selectedfieldsconfiguration
            '''
            result = self._values.get("selected_fields_configuration")
            assert result is not None, "Required property 'selected_fields_configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty"], result)

        @builtins.property
        def target_visuals_configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty"]:
            '''The configuration that chooses the target visuals to be filtered.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html#cfn-quicksight-analysis-customactionfilteroperation-targetvisualsconfiguration
            '''
            result = self._values.get("target_visuals_configuration")
            assert result is not None, "Required property 'target_visuals_configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomActionFilterOperationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionNavigationOperationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_navigation_configuration": "localNavigationConfiguration",
        },
    )
    class CustomActionNavigationOperationProperty:
        def __init__(
            self,
            *,
            local_navigation_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LocalNavigationConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The navigation operation that navigates between different sheets in the same analysis.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param local_navigation_configuration: The configuration that chooses the navigation target.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionnavigationoperation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_action_navigation_operation_property = quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                    local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                        target_sheet_id="targetSheetId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c0d2a1c805344be2956837393f966072a0c76504117dbac06fb620e8d3950734)
                check_type(argname="argument local_navigation_configuration", value=local_navigation_configuration, expected_type=type_hints["local_navigation_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if local_navigation_configuration is not None:
                self._values["local_navigation_configuration"] = local_navigation_configuration

        @builtins.property
        def local_navigation_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LocalNavigationConfigurationProperty"]]:
            '''The configuration that chooses the navigation target.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionnavigationoperation.html#cfn-quicksight-analysis-customactionnavigationoperation-localnavigationconfiguration
            '''
            result = self._values.get("local_navigation_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LocalNavigationConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomActionNavigationOperationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "parameter_value_configurations": "parameterValueConfigurations",
        },
    )
    class CustomActionSetParametersOperationProperty:
        def __init__(
            self,
            *,
            parameter_value_configurations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SetParameterValueConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''The set parameter operation that sets parameters in custom action.

            :param parameter_value_configurations: The parameter that determines the value configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionsetparametersoperation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_action_set_parameters_operation_property = quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                    parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                        destination_parameter_name="destinationParameterName",
                        value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                            custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                    date_time_values=["dateTimeValues"],
                                    decimal_values=[123],
                                    integer_values=[123],
                                    string_values=["stringValues"]
                                ),
                
                                # the properties below are optional
                                include_null_value=False
                            ),
                            select_all_value_options="selectAllValueOptions",
                            source_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            source_field="sourceField",
                            source_parameter_name="sourceParameterName"
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9651a29ef076c161348b549e839408de6de0962e62f9664a79a5f1a6b6d899fa)
                check_type(argname="argument parameter_value_configurations", value=parameter_value_configurations, expected_type=type_hints["parameter_value_configurations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "parameter_value_configurations": parameter_value_configurations,
            }

        @builtins.property
        def parameter_value_configurations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SetParameterValueConfigurationProperty"]]]:
            '''The parameter that determines the value configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionsetparametersoperation.html#cfn-quicksight-analysis-customactionsetparametersoperation-parametervalueconfigurations
            '''
            result = self._values.get("parameter_value_configurations")
            assert result is not None, "Required property 'parameter_value_configurations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SetParameterValueConfigurationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomActionSetParametersOperationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomActionURLOperationProperty",
        jsii_struct_bases=[],
        name_mapping={"url_target": "urlTarget", "url_template": "urlTemplate"},
    )
    class CustomActionURLOperationProperty:
        def __init__(
            self,
            *,
            url_target: builtins.str,
            url_template: builtins.str,
        ) -> None:
            '''The URL operation that opens a link to another webpage.

            :param url_target: The target of the ``CustomActionURLOperation`` . Valid values are defined as follows: - ``NEW_TAB`` : Opens the target URL in a new browser tab. - ``NEW_WINDOW`` : Opens the target URL in a new browser window. - ``SAME_TAB`` : Opens the target URL in the same browser tab.
            :param url_template: THe URL link of the ``CustomActionURLOperation`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_action_uRLOperation_property = quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                    url_target="urlTarget",
                    url_template="urlTemplate"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4f737bd1c08cfbb480b0afd6dfcd8872739d8bf63785cf22f4d210654a386c28)
                check_type(argname="argument url_target", value=url_target, expected_type=type_hints["url_target"])
                check_type(argname="argument url_template", value=url_template, expected_type=type_hints["url_template"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "url_target": url_target,
                "url_template": url_template,
            }

        @builtins.property
        def url_target(self) -> builtins.str:
            '''The target of the ``CustomActionURLOperation`` .

            Valid values are defined as follows:

            - ``NEW_TAB`` : Opens the target URL in a new browser tab.
            - ``NEW_WINDOW`` : Opens the target URL in a new browser window.
            - ``SAME_TAB`` : Opens the target URL in the same browser tab.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html#cfn-quicksight-analysis-customactionurloperation-urltarget
            '''
            result = self._values.get("url_target")
            assert result is not None, "Required property 'url_target' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def url_template(self) -> builtins.str:
            '''THe URL link of the ``CustomActionURLOperation`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html#cfn-quicksight-analysis-customactionurloperation-urltemplate
            '''
            result = self._values.get("url_template")
            assert result is not None, "Required property 'url_template' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomActionURLOperationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomColorProperty",
        jsii_struct_bases=[],
        name_mapping={
            "color": "color",
            "field_value": "fieldValue",
            "special_value": "specialValue",
        },
    )
    class CustomColorProperty:
        def __init__(
            self,
            *,
            color: builtins.str,
            field_value: typing.Optional[builtins.str] = None,
            special_value: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Determines the color that's applied to a particular data value in a column.

            :param color: The color that is applied to the data value.
            :param field_value: The data value that the color is applied to.
            :param special_value: The value of a special data value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_color_property = quicksight.CfnAnalysis.CustomColorProperty(
                    color="color",
                
                    # the properties below are optional
                    field_value="fieldValue",
                    special_value="specialValue"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d872ac03245931eb5686c4a3f554633a94a804f7c635ee5d321186b3f751c581)
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
                check_type(argname="argument field_value", value=field_value, expected_type=type_hints["field_value"])
                check_type(argname="argument special_value", value=special_value, expected_type=type_hints["special_value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "color": color,
            }
            if field_value is not None:
                self._values["field_value"] = field_value
            if special_value is not None:
                self._values["special_value"] = special_value

        @builtins.property
        def color(self) -> builtins.str:
            '''The color that is applied to the data value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-color
            '''
            result = self._values.get("color")
            assert result is not None, "Required property 'color' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_value(self) -> typing.Optional[builtins.str]:
            '''The data value that the color is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-fieldvalue
            '''
            result = self._values.get("field_value")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def special_value(self) -> typing.Optional[builtins.str]:
            '''The value of a special data value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-specialvalue
            '''
            result = self._values.get("special_value")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomContentConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "content_type": "contentType",
            "content_url": "contentUrl",
            "image_scaling": "imageScaling",
            "interactions": "interactions",
        },
    )
    class CustomContentConfigurationProperty:
        def __init__(
            self,
            *,
            content_type: typing.Optional[builtins.str] = None,
            content_url: typing.Optional[builtins.str] = None,
            image_scaling: typing.Optional[builtins.str] = None,
            interactions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualInteractionOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration of a ``CustomContentVisual`` .

            :param content_type: The content type of the custom content visual. You can use this to have the visual render as an image.
            :param content_url: The input URL that links to the custom content that you want in the custom visual.
            :param image_scaling: The sizing options for the size of the custom content visual. This structure is required when the ``ContentType`` of the visual is ``'IMAGE'`` .
            :param interactions: The general visual interactions setup for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_content_configuration_property = quicksight.CfnAnalysis.CustomContentConfigurationProperty(
                    content_type="contentType",
                    content_url="contentUrl",
                    image_scaling="imageScaling",
                    interactions=quicksight.CfnAnalysis.VisualInteractionOptionsProperty(
                        context_menu_option=quicksight.CfnAnalysis.ContextMenuOptionProperty(
                            availability_status="availabilityStatus"
                        ),
                        visual_menu_option=quicksight.CfnAnalysis.VisualMenuOptionProperty(
                            availability_status="availabilityStatus"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6e3335fa4f454c6e8b71e44a4416f2d735b6a775ae146fc15d67b0c53b4cbc11)
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
                check_type(argname="argument content_url", value=content_url, expected_type=type_hints["content_url"])
                check_type(argname="argument image_scaling", value=image_scaling, expected_type=type_hints["image_scaling"])
                check_type(argname="argument interactions", value=interactions, expected_type=type_hints["interactions"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if content_type is not None:
                self._values["content_type"] = content_type
            if content_url is not None:
                self._values["content_url"] = content_url
            if image_scaling is not None:
                self._values["image_scaling"] = image_scaling
            if interactions is not None:
                self._values["interactions"] = interactions

        @builtins.property
        def content_type(self) -> typing.Optional[builtins.str]:
            '''The content type of the custom content visual.

            You can use this to have the visual render as an image.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-contenttype
            '''
            result = self._values.get("content_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def content_url(self) -> typing.Optional[builtins.str]:
            '''The input URL that links to the custom content that you want in the custom visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-contenturl
            '''
            result = self._values.get("content_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def image_scaling(self) -> typing.Optional[builtins.str]:
            '''The sizing options for the size of the custom content visual.

            This structure is required when the ``ContentType`` of the visual is ``'IMAGE'`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-imagescaling
            '''
            result = self._values.get("image_scaling")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def interactions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]]:
            '''The general visual interactions setup for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-interactions
            '''
            result = self._values.get("interactions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualInteractionOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomContentConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomContentVisualProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_set_identifier": "dataSetIdentifier",
            "visual_id": "visualId",
            "actions": "actions",
            "chart_configuration": "chartConfiguration",
            "subtitle": "subtitle",
            "title": "title",
            "visual_content_alt_text": "visualContentAltText",
        },
    )
    class CustomContentVisualProperty:
        def __init__(
            self,
            *,
            data_set_identifier: builtins.str,
            visual_id: builtins.str,
            actions: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualCustomActionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            chart_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomContentConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            subtitle: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualSubtitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            title: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.VisualTitleLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            visual_content_alt_text: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A visual that contains custom content.

            For more information, see `Using custom visual content <https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html>`_ in the *Amazon QuickSight User Guide* .

            :param data_set_identifier: The dataset that is used to create the custom content visual. You can't create a visual without a dataset.
            :param visual_id: The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
            :param actions: The list of custom actions that are configured for a visual.
            :param chart_configuration: The configuration of a ``CustomContentVisual`` .
            :param subtitle: The subtitle that is displayed on the visual.
            :param title: The title that is displayed on the visual.
            :param visual_content_alt_text: The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_content_visual_property = quicksight.CfnAnalysis.CustomContentVisualProperty(
                    data_set_identifier="dataSetIdentifier",
                    visual_id="visualId",
                
                    # the properties below are optional
                    actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                        action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                            filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                    selected_columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    selected_field_options="selectedFieldOptions",
                                    selected_fields=["selectedFields"]
                                ),
                                target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                    same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                        target_visual_options="targetVisualOptions",
                                        target_visuals=["targetVisuals"]
                                    )
                                )
                            ),
                            navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                    target_sheet_id="targetSheetId"
                                )
                            ),
                            set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                    destination_parameter_name="destinationParameterName",
                                    value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                        custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                            custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                date_time_values=["dateTimeValues"],
                                                decimal_values=[123],
                                                integer_values=[123],
                                                string_values=["stringValues"]
                                            ),
                
                                            # the properties below are optional
                                            include_null_value=False
                                        ),
                                        select_all_value_options="selectAllValueOptions",
                                        source_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                            column_name="columnName",
                                            data_set_identifier="dataSetIdentifier"
                                        ),
                                        source_field="sourceField",
                                        source_parameter_name="sourceParameterName"
                                    )
                                )]
                            ),
                            url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                url_target="urlTarget",
                                url_template="urlTemplate"
                            )
                        )],
                        custom_action_id="customActionId",
                        name="name",
                        trigger="trigger",
                
                        # the properties below are optional
                        status="status"
                    )],
                    chart_configuration=quicksight.CfnAnalysis.CustomContentConfigurationProperty(
                        content_type="contentType",
                        content_url="contentUrl",
                        image_scaling="imageScaling",
                        interactions=quicksight.CfnAnalysis.VisualInteractionOptionsProperty(
                            context_menu_option=quicksight.CfnAnalysis.ContextMenuOptionProperty(
                                availability_status="availabilityStatus"
                            ),
                            visual_menu_option=quicksight.CfnAnalysis.VisualMenuOptionProperty(
                                availability_status="availabilityStatus"
                            )
                        )
                    ),
                    subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                        format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                            plain_text="plainText",
                            rich_text="richText"
                        ),
                        visibility="visibility"
                    ),
                    title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                        format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                            plain_text="plainText",
                            rich_text="richText"
                        ),
                        visibility="visibility"
                    ),
                    visual_content_alt_text="visualContentAltText"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ebca1ef6a5d4a7a0ace89b9095ff8fdd543b79c30f056718329c56a45dcdef68)
                check_type(argname="argument data_set_identifier", value=data_set_identifier, expected_type=type_hints["data_set_identifier"])
                check_type(argname="argument visual_id", value=visual_id, expected_type=type_hints["visual_id"])
                check_type(argname="argument actions", value=actions, expected_type=type_hints["actions"])
                check_type(argname="argument chart_configuration", value=chart_configuration, expected_type=type_hints["chart_configuration"])
                check_type(argname="argument subtitle", value=subtitle, expected_type=type_hints["subtitle"])
                check_type(argname="argument title", value=title, expected_type=type_hints["title"])
                check_type(argname="argument visual_content_alt_text", value=visual_content_alt_text, expected_type=type_hints["visual_content_alt_text"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_set_identifier": data_set_identifier,
                "visual_id": visual_id,
            }
            if actions is not None:
                self._values["actions"] = actions
            if chart_configuration is not None:
                self._values["chart_configuration"] = chart_configuration
            if subtitle is not None:
                self._values["subtitle"] = subtitle
            if title is not None:
                self._values["title"] = title
            if visual_content_alt_text is not None:
                self._values["visual_content_alt_text"] = visual_content_alt_text

        @builtins.property
        def data_set_identifier(self) -> builtins.str:
            '''The dataset that is used to create the custom content visual.

            You can't create a visual without a dataset.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-datasetidentifier
            '''
            result = self._values.get("data_set_identifier")
            assert result is not None, "Required property 'data_set_identifier' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def visual_id(self) -> builtins.str:
            '''The unique identifier of a visual.

            This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-visualid
            '''
            result = self._values.get("visual_id")
            assert result is not None, "Required property 'visual_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def actions(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]]:
            '''The list of custom actions that are configured for a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-actions
            '''
            result = self._values.get("actions")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualCustomActionProperty"]]]], result)

        @builtins.property
        def chart_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomContentConfigurationProperty"]]:
            '''The configuration of a ``CustomContentVisual`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-chartconfiguration
            '''
            result = self._values.get("chart_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomContentConfigurationProperty"]], result)

        @builtins.property
        def subtitle(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]]:
            '''The subtitle that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-subtitle
            '''
            result = self._values.get("subtitle")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualSubtitleLabelOptionsProperty"]], result)

        @builtins.property
        def title(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]]:
            '''The title that is displayed on the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-title
            '''
            result = self._values.get("title")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.VisualTitleLabelOptionsProperty"]], result)

        @builtins.property
        def visual_content_alt_text(self) -> typing.Optional[builtins.str]:
            '''The alt text for the visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-visualcontentalttext
            '''
            result = self._values.get("visual_content_alt_text")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomContentVisualProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomFilterConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_operator": "matchOperator",
            "null_option": "nullOption",
            "category_value": "categoryValue",
            "parameter_name": "parameterName",
            "select_all_options": "selectAllOptions",
        },
    )
    class CustomFilterConfigurationProperty:
        def __init__(
            self,
            *,
            match_operator: builtins.str,
            null_option: builtins.str,
            category_value: typing.Optional[builtins.str] = None,
            parameter_name: typing.Optional[builtins.str] = None,
            select_all_options: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A custom filter that filters based on a single value.

            This filter can be partially matched.

            :param match_operator: The match operator that is used to determine if a filter should be applied.
            :param null_option: This option determines how null values should be treated when filtering data. - ``ALL_VALUES`` : Include null values in filtered results. - ``NULLS_ONLY`` : Only include null values in filtered results. - ``NON_NULLS_ONLY`` : Exclude null values from filtered results.
            :param category_value: The category value for the filter. This field is mutually exclusive to ``ParameterName`` .
            :param parameter_name: The parameter whose value should be used for the filter value. This field is mutually exclusive to ``CategoryValue`` .
            :param select_all_options: Select all of the values. Null is not the assigned value of select all. - ``FILTER_ALL_VALUES``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_filter_configuration_property = quicksight.CfnAnalysis.CustomFilterConfigurationProperty(
                    match_operator="matchOperator",
                    null_option="nullOption",
                
                    # the properties below are optional
                    category_value="categoryValue",
                    parameter_name="parameterName",
                    select_all_options="selectAllOptions"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a271d758f3b9ebb8bd046ed3ce2bc4ce6c245d44ed2a96989f3803c36c1d12ee)
                check_type(argname="argument match_operator", value=match_operator, expected_type=type_hints["match_operator"])
                check_type(argname="argument null_option", value=null_option, expected_type=type_hints["null_option"])
                check_type(argname="argument category_value", value=category_value, expected_type=type_hints["category_value"])
                check_type(argname="argument parameter_name", value=parameter_name, expected_type=type_hints["parameter_name"])
                check_type(argname="argument select_all_options", value=select_all_options, expected_type=type_hints["select_all_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_operator": match_operator,
                "null_option": null_option,
            }
            if category_value is not None:
                self._values["category_value"] = category_value
            if parameter_name is not None:
                self._values["parameter_name"] = parameter_name
            if select_all_options is not None:
                self._values["select_all_options"] = select_all_options

        @builtins.property
        def match_operator(self) -> builtins.str:
            '''The match operator that is used to determine if a filter should be applied.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-matchoperator
            '''
            result = self._values.get("match_operator")
            assert result is not None, "Required property 'match_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def null_option(self) -> builtins.str:
            '''This option determines how null values should be treated when filtering data.

            - ``ALL_VALUES`` : Include null values in filtered results.
            - ``NULLS_ONLY`` : Only include null values in filtered results.
            - ``NON_NULLS_ONLY`` : Exclude null values from filtered results.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-nulloption
            '''
            result = self._values.get("null_option")
            assert result is not None, "Required property 'null_option' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def category_value(self) -> typing.Optional[builtins.str]:
            '''The category value for the filter.

            This field is mutually exclusive to ``ParameterName`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-categoryvalue
            '''
            result = self._values.get("category_value")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def parameter_name(self) -> typing.Optional[builtins.str]:
            '''The parameter whose value should be used for the filter value.

            This field is mutually exclusive to ``CategoryValue`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-parametername
            '''
            result = self._values.get("parameter_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def select_all_options(self) -> typing.Optional[builtins.str]:
            '''Select all of the values. Null is not the assigned value of select all.

            - ``FILTER_ALL_VALUES``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-selectalloptions
            '''
            result = self._values.get("select_all_options")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomFilterConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomFilterListConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_operator": "matchOperator",
            "null_option": "nullOption",
            "category_values": "categoryValues",
            "select_all_options": "selectAllOptions",
        },
    )
    class CustomFilterListConfigurationProperty:
        def __init__(
            self,
            *,
            match_operator: builtins.str,
            null_option: builtins.str,
            category_values: typing.Optional[typing.Sequence[builtins.str]] = None,
            select_all_options: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A list of custom filter values.

            :param match_operator: The match operator that is used to determine if a filter should be applied.
            :param null_option: This option determines how null values should be treated when filtering data. - ``ALL_VALUES`` : Include null values in filtered results. - ``NULLS_ONLY`` : Only include null values in filtered results. - ``NON_NULLS_ONLY`` : Exclude null values from filtered results.
            :param category_values: The list of category values for the filter.
            :param select_all_options: Select all of the values. Null is not the assigned value of select all. - ``FILTER_ALL_VALUES``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_filter_list_configuration_property = quicksight.CfnAnalysis.CustomFilterListConfigurationProperty(
                    match_operator="matchOperator",
                    null_option="nullOption",
                
                    # the properties below are optional
                    category_values=["categoryValues"],
                    select_all_options="selectAllOptions"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e5f1b84b0a9078e6b57b9051d15522aac25e644f5e28e8a62515c76a3e69cba6)
                check_type(argname="argument match_operator", value=match_operator, expected_type=type_hints["match_operator"])
                check_type(argname="argument null_option", value=null_option, expected_type=type_hints["null_option"])
                check_type(argname="argument category_values", value=category_values, expected_type=type_hints["category_values"])
                check_type(argname="argument select_all_options", value=select_all_options, expected_type=type_hints["select_all_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_operator": match_operator,
                "null_option": null_option,
            }
            if category_values is not None:
                self._values["category_values"] = category_values
            if select_all_options is not None:
                self._values["select_all_options"] = select_all_options

        @builtins.property
        def match_operator(self) -> builtins.str:
            '''The match operator that is used to determine if a filter should be applied.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-matchoperator
            '''
            result = self._values.get("match_operator")
            assert result is not None, "Required property 'match_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def null_option(self) -> builtins.str:
            '''This option determines how null values should be treated when filtering data.

            - ``ALL_VALUES`` : Include null values in filtered results.
            - ``NULLS_ONLY`` : Only include null values in filtered results.
            - ``NON_NULLS_ONLY`` : Exclude null values from filtered results.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-nulloption
            '''
            result = self._values.get("null_option")
            assert result is not None, "Required property 'null_option' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def category_values(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The list of category values for the filter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-categoryvalues
            '''
            result = self._values.get("category_values")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def select_all_options(self) -> typing.Optional[builtins.str]:
            '''Select all of the values. Null is not the assigned value of select all.

            - ``FILTER_ALL_VALUES``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-selectalloptions
            '''
            result = self._values.get("select_all_options")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomFilterListConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomNarrativeOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"narrative": "narrative"},
    )
    class CustomNarrativeOptionsProperty:
        def __init__(self, *, narrative: builtins.str) -> None:
            '''The custom narrative options.

            :param narrative: The string input of custom narrative.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customnarrativeoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_narrative_options_property = quicksight.CfnAnalysis.CustomNarrativeOptionsProperty(
                    narrative="narrative"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e3661c9796a9728382d87c363f3bef8f8cf6723d1074574a85bd456d01ec1927)
                check_type(argname="argument narrative", value=narrative, expected_type=type_hints["narrative"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "narrative": narrative,
            }

        @builtins.property
        def narrative(self) -> builtins.str:
            '''The string input of custom narrative.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customnarrativeoptions.html#cfn-quicksight-analysis-customnarrativeoptions-narrative
            '''
            result = self._values.get("narrative")
            assert result is not None, "Required property 'narrative' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomNarrativeOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomParameterValuesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "date_time_values": "dateTimeValues",
            "decimal_values": "decimalValues",
            "integer_values": "integerValues",
            "string_values": "stringValues",
        },
    )
    class CustomParameterValuesProperty:
        def __init__(
            self,
            *,
            date_time_values: typing.Optional[typing.Sequence[builtins.str]] = None,
            decimal_values: typing.Optional[typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b]] = None,
            integer_values: typing.Optional[typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b]] = None,
            string_values: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The customized parameter values.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param date_time_values: A list of datetime-type parameter values.
            :param decimal_values: A list of decimal-type parameter values.
            :param integer_values: A list of integer-type parameter values.
            :param string_values: A list of string-type parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_parameter_values_property = quicksight.CfnAnalysis.CustomParameterValuesProperty(
                    date_time_values=["dateTimeValues"],
                    decimal_values=[123],
                    integer_values=[123],
                    string_values=["stringValues"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a5be83345843551e0be466c923ea971b83e6b63668370180560da67f794fb896)
                check_type(argname="argument date_time_values", value=date_time_values, expected_type=type_hints["date_time_values"])
                check_type(argname="argument decimal_values", value=decimal_values, expected_type=type_hints["decimal_values"])
                check_type(argname="argument integer_values", value=integer_values, expected_type=type_hints["integer_values"])
                check_type(argname="argument string_values", value=string_values, expected_type=type_hints["string_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if date_time_values is not None:
                self._values["date_time_values"] = date_time_values
            if decimal_values is not None:
                self._values["decimal_values"] = decimal_values
            if integer_values is not None:
                self._values["integer_values"] = integer_values
            if string_values is not None:
                self._values["string_values"] = string_values

        @builtins.property
        def date_time_values(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of datetime-type parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-datetimevalues
            '''
            result = self._values.get("date_time_values")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def decimal_values(
            self,
        ) -> typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]]:
            '''A list of decimal-type parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-decimalvalues
            '''
            result = self._values.get("decimal_values")
            return typing.cast(typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]], result)

        @builtins.property
        def integer_values(
            self,
        ) -> typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]]:
            '''A list of integer-type parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-integervalues
            '''
            result = self._values.get("integer_values")
            return typing.cast(typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]], result)

        @builtins.property
        def string_values(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of string-type parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-stringvalues
            '''
            result = self._values.get("string_values")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomParameterValuesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.CustomValuesConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_values": "customValues",
            "include_null_value": "includeNullValue",
        },
    )
    class CustomValuesConfigurationProperty:
        def __init__(
            self,
            *,
            custom_values: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomParameterValuesProperty", typing.Dict[builtins.str, typing.Any]]],
            include_null_value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The configuration of custom values for the destination parameter in ``DestinationParameterValueConfiguration`` .

            :param custom_values: 
            :param include_null_value: Includes the null value in custom action parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                custom_values_configuration_property = quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                        date_time_values=["dateTimeValues"],
                        decimal_values=[123],
                        integer_values=[123],
                        string_values=["stringValues"]
                    ),
                
                    # the properties below are optional
                    include_null_value=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a6197934fa1bd9bfeab069abdfd02d7eaac44db71933bdecd67af20812e128e7)
                check_type(argname="argument custom_values", value=custom_values, expected_type=type_hints["custom_values"])
                check_type(argname="argument include_null_value", value=include_null_value, expected_type=type_hints["include_null_value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "custom_values": custom_values,
            }
            if include_null_value is not None:
                self._values["include_null_value"] = include_null_value

        @builtins.property
        def custom_values(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomParameterValuesProperty"]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html#cfn-quicksight-analysis-customvaluesconfiguration-customvalues
            '''
            result = self._values.get("custom_values")
            assert result is not None, "Required property 'custom_values' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomParameterValuesProperty"], result)

        @builtins.property
        def include_null_value(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Includes the null value in custom action parameter values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html#cfn-quicksight-analysis-customvaluesconfiguration-includenullvalue
            '''
            result = self._values.get("include_null_value")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomValuesConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataBarsOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_id": "fieldId",
            "negative_color": "negativeColor",
            "positive_color": "positiveColor",
        },
    )
    class DataBarsOptionsProperty:
        def __init__(
            self,
            *,
            field_id: builtins.str,
            negative_color: typing.Optional[builtins.str] = None,
            positive_color: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The options for data bars.

            :param field_id: The field ID for the data bars options.
            :param negative_color: The color of the negative data bar.
            :param positive_color: The color of the positive data bar.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_bars_options_property = quicksight.CfnAnalysis.DataBarsOptionsProperty(
                    field_id="fieldId",
                
                    # the properties below are optional
                    negative_color="negativeColor",
                    positive_color="positiveColor"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0b7c93e7f58e34129aee78309943f4c7156f17e5a06ed7a43c38285a625d878a)
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument negative_color", value=negative_color, expected_type=type_hints["negative_color"])
                check_type(argname="argument positive_color", value=positive_color, expected_type=type_hints["positive_color"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_id": field_id,
            }
            if negative_color is not None:
                self._values["negative_color"] = negative_color
            if positive_color is not None:
                self._values["positive_color"] = positive_color

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The field ID for the data bars options.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def negative_color(self) -> typing.Optional[builtins.str]:
            '''The color of the negative data bar.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-negativecolor
            '''
            result = self._values.get("negative_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def positive_color(self) -> typing.Optional[builtins.str]:
            '''The color of the positive data bar.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-positivecolor
            '''
            result = self._values.get("positive_color")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataBarsOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataColorProperty",
        jsii_struct_bases=[],
        name_mapping={"color": "color", "data_value": "dataValue"},
    )
    class DataColorProperty:
        def __init__(
            self,
            *,
            color: typing.Optional[builtins.str] = None,
            data_value: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Determines the color that is applied to a particular data value.

            :param color: The color that is applied to the data value.
            :param data_value: The data value that the color is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_color_property = quicksight.CfnAnalysis.DataColorProperty(
                    color="color",
                    data_value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0336c5685cce8463a8784817939facd63e5d4858cbaf0a240808f76f9c35cfee)
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
                check_type(argname="argument data_value", value=data_value, expected_type=type_hints["data_value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if color is not None:
                self._values["color"] = color
            if data_value is not None:
                self._values["data_value"] = data_value

        @builtins.property
        def color(self) -> typing.Optional[builtins.str]:
            '''The color that is applied to the data value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html#cfn-quicksight-analysis-datacolor-color
            '''
            result = self._values.get("color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def data_value(self) -> typing.Optional[jsii.Number]:
            '''The data value that the color is applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html#cfn-quicksight-analysis-datacolor-datavalue
            '''
            result = self._values.get("data_value")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataFieldSeriesItemProperty",
        jsii_struct_bases=[],
        name_mapping={
            "axis_binding": "axisBinding",
            "field_id": "fieldId",
            "field_value": "fieldValue",
            "settings": "settings",
        },
    )
    class DataFieldSeriesItemProperty:
        def __init__(
            self,
            *,
            axis_binding: builtins.str,
            field_id: builtins.str,
            field_value: typing.Optional[builtins.str] = None,
            settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LineChartSeriesSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The data field series item configuration of a line chart.

            :param axis_binding: The axis that you are binding the field to.
            :param field_id: The field ID of the field that you are setting the axis binding to.
            :param field_value: The field value of the field that you are setting the axis binding to.
            :param settings: The options that determine the presentation of line series associated to the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_field_series_item_property = quicksight.CfnAnalysis.DataFieldSeriesItemProperty(
                    axis_binding="axisBinding",
                    field_id="fieldId",
                
                    # the properties below are optional
                    field_value="fieldValue",
                    settings=quicksight.CfnAnalysis.LineChartSeriesSettingsProperty(
                        line_style_settings=quicksight.CfnAnalysis.LineChartLineStyleSettingsProperty(
                            line_interpolation="lineInterpolation",
                            line_style="lineStyle",
                            line_visibility="lineVisibility",
                            line_width="lineWidth"
                        ),
                        marker_style_settings=quicksight.CfnAnalysis.LineChartMarkerStyleSettingsProperty(
                            marker_color="markerColor",
                            marker_shape="markerShape",
                            marker_size="markerSize",
                            marker_visibility="markerVisibility"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e357f1d2093881569025e1138e344ed72afcb5baf371c67a4f89182cc5ecd479)
                check_type(argname="argument axis_binding", value=axis_binding, expected_type=type_hints["axis_binding"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument field_value", value=field_value, expected_type=type_hints["field_value"])
                check_type(argname="argument settings", value=settings, expected_type=type_hints["settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "axis_binding": axis_binding,
                "field_id": field_id,
            }
            if field_value is not None:
                self._values["field_value"] = field_value
            if settings is not None:
                self._values["settings"] = settings

        @builtins.property
        def axis_binding(self) -> builtins.str:
            '''The axis that you are binding the field to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-axisbinding
            '''
            result = self._values.get("axis_binding")
            assert result is not None, "Required property 'axis_binding' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The field ID of the field that you are setting the axis binding to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_value(self) -> typing.Optional[builtins.str]:
            '''The field value of the field that you are setting the axis binding to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-fieldvalue
            '''
            result = self._values.get("field_value")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LineChartSeriesSettingsProperty"]]:
            '''The options that determine the presentation of line series associated to the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-settings
            '''
            result = self._values.get("settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LineChartSeriesSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataFieldSeriesItemProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataLabelOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "category_label_visibility": "categoryLabelVisibility",
            "data_label_types": "dataLabelTypes",
            "label_color": "labelColor",
            "label_content": "labelContent",
            "label_font_configuration": "labelFontConfiguration",
            "measure_label_visibility": "measureLabelVisibility",
            "overlap": "overlap",
            "position": "position",
            "totals_visibility": "totalsVisibility",
            "visibility": "visibility",
        },
    )
    class DataLabelOptionsProperty:
        def __init__(
            self,
            *,
            category_label_visibility: typing.Optional[builtins.str] = None,
            data_label_types: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            label_color: typing.Optional[builtins.str] = None,
            label_content: typing.Optional[builtins.str] = None,
            label_font_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FontConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            measure_label_visibility: typing.Optional[builtins.str] = None,
            overlap: typing.Optional[builtins.str] = None,
            position: typing.Optional[builtins.str] = None,
            totals_visibility: typing.Optional[builtins.str] = None,
            visibility: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The options that determine the presentation of the data labels.

            :param category_label_visibility: Determines the visibility of the category field labels.
            :param data_label_types: The option that determines the data label type.
            :param label_color: Determines the color of the data labels.
            :param label_content: Determines the content of the data labels.
            :param label_font_configuration: Determines the font configuration of the data labels.
            :param measure_label_visibility: Determines the visibility of the measure field labels.
            :param overlap: Determines whether overlap is enabled or disabled for the data labels.
            :param position: Determines the position of the data labels.
            :param totals_visibility: Determines the visibility of the total.
            :param visibility: Determines the visibility of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_label_options_property = quicksight.CfnAnalysis.DataLabelOptionsProperty(
                    category_label_visibility="categoryLabelVisibility",
                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                            field_id="fieldId",
                            field_value="fieldValue",
                            visibility="visibility"
                        ),
                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                            field_id="fieldId",
                            visibility="visibility"
                        ),
                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                            visibility="visibility"
                        ),
                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                            visibility="visibility"
                        ),
                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                            visibility="visibility"
                        )
                    )],
                    label_color="labelColor",
                    label_content="labelContent",
                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                        font_color="fontColor",
                        font_decoration="fontDecoration",
                        font_family="fontFamily",
                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                            absolute="absolute",
                            relative="relative"
                        ),
                        font_style="fontStyle",
                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                            name="name"
                        )
                    ),
                    measure_label_visibility="measureLabelVisibility",
                    overlap="overlap",
                    position="position",
                    totals_visibility="totalsVisibility",
                    visibility="visibility"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d723fb6e0272cbb7a4b92a44aa3f1bc37eac283d3c2cd28d0a97f180b84be5a1)
                check_type(argname="argument category_label_visibility", value=category_label_visibility, expected_type=type_hints["category_label_visibility"])
                check_type(argname="argument data_label_types", value=data_label_types, expected_type=type_hints["data_label_types"])
                check_type(argname="argument label_color", value=label_color, expected_type=type_hints["label_color"])
                check_type(argname="argument label_content", value=label_content, expected_type=type_hints["label_content"])
                check_type(argname="argument label_font_configuration", value=label_font_configuration, expected_type=type_hints["label_font_configuration"])
                check_type(argname="argument measure_label_visibility", value=measure_label_visibility, expected_type=type_hints["measure_label_visibility"])
                check_type(argname="argument overlap", value=overlap, expected_type=type_hints["overlap"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
                check_type(argname="argument totals_visibility", value=totals_visibility, expected_type=type_hints["totals_visibility"])
                check_type(argname="argument visibility", value=visibility, expected_type=type_hints["visibility"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if category_label_visibility is not None:
                self._values["category_label_visibility"] = category_label_visibility
            if data_label_types is not None:
                self._values["data_label_types"] = data_label_types
            if label_color is not None:
                self._values["label_color"] = label_color
            if label_content is not None:
                self._values["label_content"] = label_content
            if label_font_configuration is not None:
                self._values["label_font_configuration"] = label_font_configuration
            if measure_label_visibility is not None:
                self._values["measure_label_visibility"] = measure_label_visibility
            if overlap is not None:
                self._values["overlap"] = overlap
            if position is not None:
                self._values["position"] = position
            if totals_visibility is not None:
                self._values["totals_visibility"] = totals_visibility
            if visibility is not None:
                self._values["visibility"] = visibility

        @builtins.property
        def category_label_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of the category field labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-categorylabelvisibility
            '''
            result = self._values.get("category_label_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def data_label_types(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelTypeProperty"]]]]:
            '''The option that determines the data label type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-datalabeltypes
            '''
            result = self._values.get("data_label_types")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataLabelTypeProperty"]]]], result)

        @builtins.property
        def label_color(self) -> typing.Optional[builtins.str]:
            '''Determines the color of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelcolor
            '''
            result = self._values.get("label_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def label_content(self) -> typing.Optional[builtins.str]:
            '''Determines the content of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelcontent
            '''
            result = self._values.get("label_content")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def label_font_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FontConfigurationProperty"]]:
            '''Determines the font configuration of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelfontconfiguration
            '''
            result = self._values.get("label_font_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FontConfigurationProperty"]], result)

        @builtins.property
        def measure_label_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of the measure field labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-measurelabelvisibility
            '''
            result = self._values.get("measure_label_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def overlap(self) -> typing.Optional[builtins.str]:
            '''Determines whether overlap is enabled or disabled for the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-overlap
            '''
            result = self._values.get("overlap")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def position(self) -> typing.Optional[builtins.str]:
            '''Determines the position of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-position
            '''
            result = self._values.get("position")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def totals_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of the total.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-totalsvisibility
            '''
            result = self._values.get("totals_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def visibility(self) -> typing.Optional[builtins.str]:
            '''Determines the visibility of the data labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-visibility
            '''
            result = self._values.get("visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataLabelOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataLabelTypeProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_path_label_type": "dataPathLabelType",
            "field_label_type": "fieldLabelType",
            "maximum_label_type": "maximumLabelType",
            "minimum_label_type": "minimumLabelType",
            "range_ends_label_type": "rangeEndsLabelType",
        },
    )
    class DataLabelTypeProperty:
        def __init__(
            self,
            *,
            data_path_label_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataPathLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            field_label_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FieldLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            maximum_label_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MaximumLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            minimum_label_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MinimumLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            range_ends_label_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.RangeEndsLabelTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The option that determines the data label type.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param data_path_label_type: The option that specifies individual data values for labels.
            :param field_label_type: Determines the label configuration for the entire field.
            :param maximum_label_type: Determines the label configuration for the maximum value in a visual.
            :param minimum_label_type: Determines the label configuration for the minimum value in a visual.
            :param range_ends_label_type: Determines the label configuration for range end value in a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_label_type_property = quicksight.CfnAnalysis.DataLabelTypeProperty(
                    data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                        field_id="fieldId",
                        field_value="fieldValue",
                        visibility="visibility"
                    ),
                    field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                        field_id="fieldId",
                        visibility="visibility"
                    ),
                    maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                        visibility="visibility"
                    ),
                    minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                        visibility="visibility"
                    ),
                    range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                        visibility="visibility"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__baf45f94503ae9ca876cab034e08e9d0ffd39650ca278a4a24826388a6dee6c7)
                check_type(argname="argument data_path_label_type", value=data_path_label_type, expected_type=type_hints["data_path_label_type"])
                check_type(argname="argument field_label_type", value=field_label_type, expected_type=type_hints["field_label_type"])
                check_type(argname="argument maximum_label_type", value=maximum_label_type, expected_type=type_hints["maximum_label_type"])
                check_type(argname="argument minimum_label_type", value=minimum_label_type, expected_type=type_hints["minimum_label_type"])
                check_type(argname="argument range_ends_label_type", value=range_ends_label_type, expected_type=type_hints["range_ends_label_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if data_path_label_type is not None:
                self._values["data_path_label_type"] = data_path_label_type
            if field_label_type is not None:
                self._values["field_label_type"] = field_label_type
            if maximum_label_type is not None:
                self._values["maximum_label_type"] = maximum_label_type
            if minimum_label_type is not None:
                self._values["minimum_label_type"] = minimum_label_type
            if range_ends_label_type is not None:
                self._values["range_ends_label_type"] = range_ends_label_type

        @builtins.property
        def data_path_label_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathLabelTypeProperty"]]:
            '''The option that specifies individual data values for labels.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-datapathlabeltype
            '''
            result = self._values.get("data_path_label_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathLabelTypeProperty"]], result)

        @builtins.property
        def field_label_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldLabelTypeProperty"]]:
            '''Determines the label configuration for the entire field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-fieldlabeltype
            '''
            result = self._values.get("field_label_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FieldLabelTypeProperty"]], result)

        @builtins.property
        def maximum_label_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MaximumLabelTypeProperty"]]:
            '''Determines the label configuration for the maximum value in a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-maximumlabeltype
            '''
            result = self._values.get("maximum_label_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MaximumLabelTypeProperty"]], result)

        @builtins.property
        def minimum_label_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MinimumLabelTypeProperty"]]:
            '''Determines the label configuration for the minimum value in a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-minimumlabeltype
            '''
            result = self._values.get("minimum_label_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MinimumLabelTypeProperty"]], result)

        @builtins.property
        def range_ends_label_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RangeEndsLabelTypeProperty"]]:
            '''Determines the label configuration for range end value in a visual.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-rangeendslabeltype
            '''
            result = self._values.get("range_ends_label_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RangeEndsLabelTypeProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataLabelTypeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathColorProperty",
        jsii_struct_bases=[],
        name_mapping={
            "color": "color",
            "element": "element",
            "time_granularity": "timeGranularity",
        },
    )
    class DataPathColorProperty:
        def __init__(
            self,
            *,
            color: builtins.str,
            element: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataPathValueProperty", typing.Dict[builtins.str, typing.Any]]],
            time_granularity: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The color map that determines the color options for a particular element.

            :param color: The color that needs to be applied to the element.
            :param element: The element that the color needs to be applied to.
            :param time_granularity: The time granularity of the field that the color needs to be applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_path_color_property = quicksight.CfnAnalysis.DataPathColorProperty(
                    color="color",
                    element=quicksight.CfnAnalysis.DataPathValueProperty(
                        data_path_type=quicksight.CfnAnalysis.DataPathTypeProperty(
                            pivot_table_data_path_type="pivotTableDataPathType"
                        ),
                        field_id="fieldId",
                        field_value="fieldValue"
                    ),
                
                    # the properties below are optional
                    time_granularity="timeGranularity"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__22d7ab72c9e58d8a805483a123dd94538f8a59bd4b43e25b3c94b8fbb4093b3b)
                check_type(argname="argument color", value=color, expected_type=type_hints["color"])
                check_type(argname="argument element", value=element, expected_type=type_hints["element"])
                check_type(argname="argument time_granularity", value=time_granularity, expected_type=type_hints["time_granularity"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "color": color,
                "element": element,
            }
            if time_granularity is not None:
                self._values["time_granularity"] = time_granularity

        @builtins.property
        def color(self) -> builtins.str:
            '''The color that needs to be applied to the element.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-color
            '''
            result = self._values.get("color")
            assert result is not None, "Required property 'color' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def element(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathValueProperty"]:
            '''The element that the color needs to be applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-element
            '''
            result = self._values.get("element")
            assert result is not None, "Required property 'element' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathValueProperty"], result)

        @builtins.property
        def time_granularity(self) -> typing.Optional[builtins.str]:
            '''The time granularity of the field that the color needs to be applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-timegranularity
            '''
            result = self._values.get("time_granularity")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPathColorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathLabelTypeProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_id": "fieldId",
            "field_value": "fieldValue",
            "visibility": "visibility",
        },
    )
    class DataPathLabelTypeProperty:
        def __init__(
            self,
            *,
            field_id: typing.Optional[builtins.str] = None,
            field_value: typing.Optional[builtins.str] = None,
            visibility: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The option that specifies individual data values for labels.

            :param field_id: The field ID of the field that the data label needs to be applied to.
            :param field_value: The actual value of the field that is labeled.
            :param visibility: The visibility of the data label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_path_label_type_property = quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                    field_id="fieldId",
                    field_value="fieldValue",
                    visibility="visibility"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__92299d1328c6ec5763c4a2529888ce5ef3900ed776a8b1970a55b3c37c3b0dfb)
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument field_value", value=field_value, expected_type=type_hints["field_value"])
                check_type(argname="argument visibility", value=visibility, expected_type=type_hints["visibility"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if field_id is not None:
                self._values["field_id"] = field_id
            if field_value is not None:
                self._values["field_value"] = field_value
            if visibility is not None:
                self._values["visibility"] = visibility

        @builtins.property
        def field_id(self) -> typing.Optional[builtins.str]:
            '''The field ID of the field that the data label needs to be applied to.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-fieldid
            '''
            result = self._values.get("field_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def field_value(self) -> typing.Optional[builtins.str]:
            '''The actual value of the field that is labeled.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-fieldvalue
            '''
            result = self._values.get("field_value")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def visibility(self) -> typing.Optional[builtins.str]:
            '''The visibility of the data label.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-visibility
            '''
            result = self._values.get("visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPathLabelTypeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathSortProperty",
        jsii_struct_bases=[],
        name_mapping={"direction": "direction", "sort_paths": "sortPaths"},
    )
    class DataPathSortProperty:
        def __init__(
            self,
            *,
            direction: builtins.str,
            sort_paths: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataPathValueProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Allows data paths to be sorted by a specific data value.

            :param direction: Determines the sort direction.
            :param sort_paths: The list of data paths that need to be sorted.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_path_sort_property = quicksight.CfnAnalysis.DataPathSortProperty(
                    direction="direction",
                    sort_paths=[quicksight.CfnAnalysis.DataPathValueProperty(
                        data_path_type=quicksight.CfnAnalysis.DataPathTypeProperty(
                            pivot_table_data_path_type="pivotTableDataPathType"
                        ),
                        field_id="fieldId",
                        field_value="fieldValue"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__86d4fba3d65e1f121b841e1ea3ae51b09bf6d5742f286dbf05292fa7726c0166)
                check_type(argname="argument direction", value=direction, expected_type=type_hints["direction"])
                check_type(argname="argument sort_paths", value=sort_paths, expected_type=type_hints["sort_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "direction": direction,
                "sort_paths": sort_paths,
            }

        @builtins.property
        def direction(self) -> builtins.str:
            '''Determines the sort direction.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html#cfn-quicksight-analysis-datapathsort-direction
            '''
            result = self._values.get("direction")
            assert result is not None, "Required property 'direction' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def sort_paths(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathValueProperty"]]]:
            '''The list of data paths that need to be sorted.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html#cfn-quicksight-analysis-datapathsort-sortpaths
            '''
            result = self._values.get("sort_paths")
            assert result is not None, "Required property 'sort_paths' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathValueProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPathSortProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathTypeProperty",
        jsii_struct_bases=[],
        name_mapping={"pivot_table_data_path_type": "pivotTableDataPathType"},
    )
    class DataPathTypeProperty:
        def __init__(
            self,
            *,
            pivot_table_data_path_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The type of the data path value.

            :param pivot_table_data_path_type: The type of data path value utilized in a pivot table. Choose one of the following options:. - ``HIERARCHY_ROWS_LAYOUT_COLUMN`` - The type of data path for the rows layout column, when ``RowsLayout`` is set to ``HIERARCHY`` . - ``MULTIPLE_ROW_METRICS_COLUMN`` - The type of data path for the metric column when the row is set to Metric Placement. - ``EMPTY_COLUMN_HEADER`` - The type of data path for the column with empty column header, when there is no field in ``ColumnsFieldWell`` and the row is set to Metric Placement. - ``COUNT_METRIC_COLUMN`` - The type of data path for the column with ``COUNT`` as the metric, when there is no field in the ``ValuesFieldWell`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathtype.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_path_type_property = quicksight.CfnAnalysis.DataPathTypeProperty(
                    pivot_table_data_path_type="pivotTableDataPathType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9124deacbcb1f63197a3bd5a840753ac0339784eda57ade6bb68b6fcacb08d23)
                check_type(argname="argument pivot_table_data_path_type", value=pivot_table_data_path_type, expected_type=type_hints["pivot_table_data_path_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if pivot_table_data_path_type is not None:
                self._values["pivot_table_data_path_type"] = pivot_table_data_path_type

        @builtins.property
        def pivot_table_data_path_type(self) -> typing.Optional[builtins.str]:
            '''The type of data path value utilized in a pivot table. Choose one of the following options:.

            - ``HIERARCHY_ROWS_LAYOUT_COLUMN`` - The type of data path for the rows layout column, when ``RowsLayout`` is set to ``HIERARCHY`` .
            - ``MULTIPLE_ROW_METRICS_COLUMN`` - The type of data path for the metric column when the row is set to Metric Placement.
            - ``EMPTY_COLUMN_HEADER`` - The type of data path for the column with empty column header, when there is no field in ``ColumnsFieldWell`` and the row is set to Metric Placement.
            - ``COUNT_METRIC_COLUMN`` - The type of data path for the column with ``COUNT`` as the metric, when there is no field in the ``ValuesFieldWell`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathtype.html#cfn-quicksight-analysis-datapathtype-pivottabledatapathtype
            '''
            result = self._values.get("pivot_table_data_path_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPathTypeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataPathValueProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_path_type": "dataPathType",
            "field_id": "fieldId",
            "field_value": "fieldValue",
        },
    )
    class DataPathValueProperty:
        def __init__(
            self,
            *,
            data_path_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DataPathTypeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            field_id: typing.Optional[builtins.str] = None,
            field_value: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The data path that needs to be sorted.

            :param data_path_type: The type configuration of the field.
            :param field_id: The field ID of the field that needs to be sorted.
            :param field_value: The actual value of the field that needs to be sorted.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_path_value_property = quicksight.CfnAnalysis.DataPathValueProperty(
                    data_path_type=quicksight.CfnAnalysis.DataPathTypeProperty(
                        pivot_table_data_path_type="pivotTableDataPathType"
                    ),
                    field_id="fieldId",
                    field_value="fieldValue"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ba849ca69e22a9c090b73d793791dc533d8bf31d54e27c2ca76b1b941a6ce8d2)
                check_type(argname="argument data_path_type", value=data_path_type, expected_type=type_hints["data_path_type"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument field_value", value=field_value, expected_type=type_hints["field_value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if data_path_type is not None:
                self._values["data_path_type"] = data_path_type
            if field_id is not None:
                self._values["field_id"] = field_id
            if field_value is not None:
                self._values["field_value"] = field_value

        @builtins.property
        def data_path_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathTypeProperty"]]:
            '''The type configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-datapathtype
            '''
            result = self._values.get("data_path_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DataPathTypeProperty"]], result)

        @builtins.property
        def field_id(self) -> typing.Optional[builtins.str]:
            '''The field ID of the field that needs to be sorted.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-fieldid
            '''
            result = self._values.get("field_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def field_value(self) -> typing.Optional[builtins.str]:
            '''The actual value of the field that needs to be sorted.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-fieldvalue
            '''
            result = self._values.get("field_value")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataPathValueProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetIdentifierDeclarationProperty",
        jsii_struct_bases=[],
        name_mapping={"data_set_arn": "dataSetArn", "identifier": "identifier"},
    )
    class DataSetIdentifierDeclarationProperty:
        def __init__(
            self,
            *,
            data_set_arn: builtins.str,
            identifier: builtins.str,
        ) -> None:
            '''A data set.

            :param data_set_arn: The Amazon Resource Name (ARN) of the data set.
            :param identifier: The identifier of the data set, typically the data set's name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_set_identifier_declaration_property = quicksight.CfnAnalysis.DataSetIdentifierDeclarationProperty(
                    data_set_arn="dataSetArn",
                    identifier="identifier"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f3de1e151dbe34974f8b59029404441fba53ab091ea12315947279f3102413d3)
                check_type(argname="argument data_set_arn", value=data_set_arn, expected_type=type_hints["data_set_arn"])
                check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_set_arn": data_set_arn,
                "identifier": identifier,
            }

        @builtins.property
        def data_set_arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the data set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html#cfn-quicksight-analysis-datasetidentifierdeclaration-datasetarn
            '''
            result = self._values.get("data_set_arn")
            assert result is not None, "Required property 'data_set_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def identifier(self) -> builtins.str:
            '''The identifier of the data set, typically the data set's name.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html#cfn-quicksight-analysis-datasetidentifierdeclaration-identifier
            '''
            result = self._values.get("identifier")
            assert result is not None, "Required property 'identifier' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataSetIdentifierDeclarationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DataSetReferenceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_set_arn": "dataSetArn",
            "data_set_placeholder": "dataSetPlaceholder",
        },
    )
    class DataSetReferenceProperty:
        def __init__(
            self,
            *,
            data_set_arn: builtins.str,
            data_set_placeholder: builtins.str,
        ) -> None:
            '''Dataset reference.

            :param data_set_arn: Dataset Amazon Resource Name (ARN).
            :param data_set_placeholder: Dataset placeholder.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                data_set_reference_property = quicksight.CfnAnalysis.DataSetReferenceProperty(
                    data_set_arn="dataSetArn",
                    data_set_placeholder="dataSetPlaceholder"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e9a568b8d078664e0579c655148b615087e4791d2d616b8bec0caf8c3bff67c8)
                check_type(argname="argument data_set_arn", value=data_set_arn, expected_type=type_hints["data_set_arn"])
                check_type(argname="argument data_set_placeholder", value=data_set_placeholder, expected_type=type_hints["data_set_placeholder"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_set_arn": data_set_arn,
                "data_set_placeholder": data_set_placeholder,
            }

        @builtins.property
        def data_set_arn(self) -> builtins.str:
            '''Dataset Amazon Resource Name (ARN).

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetarn
            '''
            result = self._values.get("data_set_arn")
            assert result is not None, "Required property 'data_set_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def data_set_placeholder(self) -> builtins.str:
            '''Dataset placeholder.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetplaceholder
            '''
            result = self._values.get("data_set_placeholder")
            assert result is not None, "Required property 'data_set_placeholder' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataSetReferenceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateAxisOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"missing_date_visibility": "missingDateVisibility"},
    )
    class DateAxisOptionsProperty:
        def __init__(
            self,
            *,
            missing_date_visibility: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The options that determine how a date axis is displayed.

            :param missing_date_visibility: Determines whether or not missing dates are displayed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dateaxisoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_axis_options_property = quicksight.CfnAnalysis.DateAxisOptionsProperty(
                    missing_date_visibility="missingDateVisibility"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9200345b8443d7700b28884e93da7759942bd2a60eb6f37859aa8714fe8a4ea8)
                check_type(argname="argument missing_date_visibility", value=missing_date_visibility, expected_type=type_hints["missing_date_visibility"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if missing_date_visibility is not None:
                self._values["missing_date_visibility"] = missing_date_visibility

        @builtins.property
        def missing_date_visibility(self) -> typing.Optional[builtins.str]:
            '''Determines whether or not missing dates are displayed.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dateaxisoptions.html#cfn-quicksight-analysis-dateaxisoptions-missingdatevisibility
            '''
            result = self._values.get("missing_date_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateAxisOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateDimensionFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "field_id": "fieldId",
            "date_granularity": "dateGranularity",
            "format_configuration": "formatConfiguration",
            "hierarchy_id": "hierarchyId",
        },
    )
    class DateDimensionFieldProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            field_id: builtins.str,
            date_granularity: typing.Optional[builtins.str] = None,
            format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimeFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            hierarchy_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The dimension type field with date type columns.

            :param column: The column that is used in the ``DateDimensionField`` .
            :param field_id: The custom field ID.
            :param date_granularity: The date granularity of the ``DateDimensionField`` . Choose one of the following options:. - ``YEAR`` - ``QUARTER`` - ``MONTH`` - ``WEEK`` - ``DAY`` - ``HOUR`` - ``MINUTE`` - ``SECOND`` - ``MILLISECOND``
            :param format_configuration: The format configuration of the field.
            :param hierarchy_id: The custom hierarchy ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_dimension_field_property = quicksight.CfnAnalysis.DateDimensionFieldProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    field_id="fieldId",
                
                    # the properties below are optional
                    date_granularity="dateGranularity",
                    format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                        date_time_format="dateTimeFormat",
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                            currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix",
                                symbol="symbol"
                            ),
                            number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            ),
                            percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            )
                        )
                    ),
                    hierarchy_id="hierarchyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fd0d8474bb61fc8fe81036b6842e1cc601b74662e1cb56e92f82e04ed92343ba)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument date_granularity", value=date_granularity, expected_type=type_hints["date_granularity"])
                check_type(argname="argument format_configuration", value=format_configuration, expected_type=type_hints["format_configuration"])
                check_type(argname="argument hierarchy_id", value=hierarchy_id, expected_type=type_hints["hierarchy_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "field_id": field_id,
            }
            if date_granularity is not None:
                self._values["date_granularity"] = date_granularity
            if format_configuration is not None:
                self._values["format_configuration"] = format_configuration
            if hierarchy_id is not None:
                self._values["hierarchy_id"] = hierarchy_id

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that is used in the ``DateDimensionField`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def date_granularity(self) -> typing.Optional[builtins.str]:
            '''The date granularity of the ``DateDimensionField`` . Choose one of the following options:.

            - ``YEAR``
            - ``QUARTER``
            - ``MONTH``
            - ``WEEK``
            - ``DAY``
            - ``HOUR``
            - ``MINUTE``
            - ``SECOND``
            - ``MILLISECOND``

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-dategranularity
            '''
            result = self._values.get("date_granularity")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeFormatConfigurationProperty"]]:
            '''The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-formatconfiguration
            '''
            result = self._values.get("format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeFormatConfigurationProperty"]], result)

        @builtins.property
        def hierarchy_id(self) -> typing.Optional[builtins.str]:
            '''The custom hierarchy ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-hierarchyid
            '''
            result = self._values.get("hierarchy_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateDimensionFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateMeasureFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column": "column",
            "field_id": "fieldId",
            "aggregation_function": "aggregationFunction",
            "format_configuration": "formatConfiguration",
        },
    )
    class DateMeasureFieldProperty:
        def __init__(
            self,
            *,
            column: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            field_id: builtins.str,
            aggregation_function: typing.Optional[builtins.str] = None,
            format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimeFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The measure type field with date type columns.

            :param column: The column that is used in the ``DateMeasureField`` .
            :param field_id: The custom field ID.
            :param aggregation_function: The aggregation function of the measure field.
            :param format_configuration: The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_measure_field_property = quicksight.CfnAnalysis.DateMeasureFieldProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    field_id="fieldId",
                
                    # the properties below are optional
                    aggregation_function="aggregationFunction",
                    format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                        date_time_format="dateTimeFormat",
                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                            null_string="nullString"
                        ),
                        numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                            currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix",
                                symbol="symbol"
                            ),
                            number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                number_scale="numberScale",
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            ),
                            percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                    decimal_places=123
                                ),
                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                    display_mode="displayMode"
                                ),
                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                    null_string="nullString"
                                ),
                                prefix="prefix",
                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                    decimal_separator="decimalSeparator",
                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                        grouping_style="groupingStyle",
                                        symbol="symbol",
                                        visibility="visibility"
                                    )
                                ),
                                suffix="suffix"
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8ec1ded69f32897bf459edf237407416761a83ddfcc44202f6659bbe97b15b2b)
                check_type(argname="argument column", value=column, expected_type=type_hints["column"])
                check_type(argname="argument field_id", value=field_id, expected_type=type_hints["field_id"])
                check_type(argname="argument aggregation_function", value=aggregation_function, expected_type=type_hints["aggregation_function"])
                check_type(argname="argument format_configuration", value=format_configuration, expected_type=type_hints["format_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "column": column,
                "field_id": field_id,
            }
            if aggregation_function is not None:
                self._values["aggregation_function"] = aggregation_function
            if format_configuration is not None:
                self._values["format_configuration"] = format_configuration

        @builtins.property
        def column(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]:
            '''The column that is used in the ``DateMeasureField`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-column
            '''
            result = self._values.get("column")
            assert result is not None, "Required property 'column' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"], result)

        @builtins.property
        def field_id(self) -> builtins.str:
            '''The custom field ID.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-fieldid
            '''
            result = self._values.get("field_id")
            assert result is not None, "Required property 'field_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def aggregation_function(self) -> typing.Optional[builtins.str]:
            '''The aggregation function of the measure field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-aggregationfunction
            '''
            result = self._values.get("aggregation_function")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeFormatConfigurationProperty"]]:
            '''The format configuration of the field.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-formatconfiguration
            '''
            result = self._values.get("format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeFormatConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateMeasureFieldProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeDefaultValuesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "dynamic_value": "dynamicValue",
            "rolling_date": "rollingDate",
            "static_values": "staticValues",
        },
    )
    class DateTimeDefaultValuesProperty:
        def __init__(
            self,
            *,
            dynamic_value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DynamicDefaultValueProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rolling_date: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.RollingDateConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            static_values: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The default values of the ``DateTimeParameterDeclaration`` .

            :param dynamic_value: The dynamic value of the ``DataTimeDefaultValues`` . Different defaults are displayed according to users, groups, and values mapping.
            :param rolling_date: The rolling date of the ``DataTimeDefaultValues`` . The date is determined from the dataset based on input expression.
            :param static_values: The static values of the ``DataTimeDefaultValues`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_default_values_property = quicksight.CfnAnalysis.DateTimeDefaultValuesProperty(
                    dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                        default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        )
                    ),
                    rolling_date=quicksight.CfnAnalysis.RollingDateConfigurationProperty(
                        expression="expression",
                
                        # the properties below are optional
                        data_set_identifier="dataSetIdentifier"
                    ),
                    static_values=["staticValues"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1da8f843d15a3d85a3e70a9ec36f8e4d6bc5d873c5af842246e2e9fa1285e22c)
                check_type(argname="argument dynamic_value", value=dynamic_value, expected_type=type_hints["dynamic_value"])
                check_type(argname="argument rolling_date", value=rolling_date, expected_type=type_hints["rolling_date"])
                check_type(argname="argument static_values", value=static_values, expected_type=type_hints["static_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if dynamic_value is not None:
                self._values["dynamic_value"] = dynamic_value
            if rolling_date is not None:
                self._values["rolling_date"] = rolling_date
            if static_values is not None:
                self._values["static_values"] = static_values

        @builtins.property
        def dynamic_value(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DynamicDefaultValueProperty"]]:
            '''The dynamic value of the ``DataTimeDefaultValues`` .

            Different defaults are displayed according to users, groups, and values mapping.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-dynamicvalue
            '''
            result = self._values.get("dynamic_value")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DynamicDefaultValueProperty"]], result)

        @builtins.property
        def rolling_date(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RollingDateConfigurationProperty"]]:
            '''The rolling date of the ``DataTimeDefaultValues`` .

            The date is determined from the dataset based on input expression.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-rollingdate
            '''
            result = self._values.get("rolling_date")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RollingDateConfigurationProperty"]], result)

        @builtins.property
        def static_values(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The static values of the ``DataTimeDefaultValues`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-staticvalues
            '''
            result = self._values.get("static_values")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeDefaultValuesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "date_time_format": "dateTimeFormat",
            "null_value_format_configuration": "nullValueFormatConfiguration",
            "numeric_format_configuration": "numericFormatConfiguration",
        },
    )
    class DateTimeFormatConfigurationProperty:
        def __init__(
            self,
            *,
            date_time_format: typing.Optional[builtins.str] = None,
            null_value_format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NullValueFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            numeric_format_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumericFormatConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Formatting configuration for ``DateTime`` fields.

            :param date_time_format: Determines the ``DateTime`` format.
            :param null_value_format_configuration: The options that determine the null value format configuration.
            :param numeric_format_configuration: The formatting configuration for numeric ``DateTime`` fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_format_configuration_property = quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                    date_time_format="dateTimeFormat",
                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                        null_string="nullString"
                    ),
                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                decimal_places=123
                            ),
                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                display_mode="displayMode"
                            ),
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            number_scale="numberScale",
                            prefix="prefix",
                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                decimal_separator="decimalSeparator",
                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                    grouping_style="groupingStyle",
                                    symbol="symbol",
                                    visibility="visibility"
                                )
                            ),
                            suffix="suffix",
                            symbol="symbol"
                        ),
                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                decimal_places=123
                            ),
                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                display_mode="displayMode"
                            ),
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            number_scale="numberScale",
                            prefix="prefix",
                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                decimal_separator="decimalSeparator",
                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                    grouping_style="groupingStyle",
                                    symbol="symbol",
                                    visibility="visibility"
                                )
                            ),
                            suffix="suffix"
                        ),
                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                decimal_places=123
                            ),
                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                display_mode="displayMode"
                            ),
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            prefix="prefix",
                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                decimal_separator="decimalSeparator",
                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                    grouping_style="groupingStyle",
                                    symbol="symbol",
                                    visibility="visibility"
                                )
                            ),
                            suffix="suffix"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0a52a1effef6a37135b62fc99fba7a1801c65a2611508716eb6e2fc95a2a1d70)
                check_type(argname="argument date_time_format", value=date_time_format, expected_type=type_hints["date_time_format"])
                check_type(argname="argument null_value_format_configuration", value=null_value_format_configuration, expected_type=type_hints["null_value_format_configuration"])
                check_type(argname="argument numeric_format_configuration", value=numeric_format_configuration, expected_type=type_hints["numeric_format_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if date_time_format is not None:
                self._values["date_time_format"] = date_time_format
            if null_value_format_configuration is not None:
                self._values["null_value_format_configuration"] = null_value_format_configuration
            if numeric_format_configuration is not None:
                self._values["numeric_format_configuration"] = numeric_format_configuration

        @builtins.property
        def date_time_format(self) -> typing.Optional[builtins.str]:
            '''Determines the ``DateTime`` format.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-datetimeformat
            '''
            result = self._values.get("date_time_format")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def null_value_format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NullValueFormatConfigurationProperty"]]:
            '''The options that determine the null value format configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-nullvalueformatconfiguration
            '''
            result = self._values.get("null_value_format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NullValueFormatConfigurationProperty"]], result)

        @builtins.property
        def numeric_format_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericFormatConfigurationProperty"]]:
            '''The formatting configuration for numeric ``DateTime`` fields.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-numericformatconfiguration
            '''
            result = self._values.get("numeric_format_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.NumericFormatConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeFormatConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeHierarchyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "hierarchy_id": "hierarchyId",
            "drill_down_filters": "drillDownFilters",
        },
    )
    class DateTimeHierarchyProperty:
        def __init__(
            self,
            *,
            hierarchy_id: builtins.str,
            drill_down_filters: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DrillDownFilterProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''The option that determines the hierarchy of any ``DateTime`` fields.

            :param hierarchy_id: The hierarchy ID of the ``DateTime`` hierarchy.
            :param drill_down_filters: The option that determines the drill down filters for the ``DateTime`` hierarchy.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_hierarchy_property = quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                    hierarchy_id="hierarchyId",
                
                    # the properties below are optional
                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                            category_values=["categoryValues"],
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            )
                        ),
                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            value=123
                        ),
                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            range_maximum="rangeMaximum",
                            range_minimum="rangeMinimum",
                            time_granularity="timeGranularity"
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__10eb1a9ed2c4e66745e808132025ab28e7933d9384f2ad68e2a825f3210ff210)
                check_type(argname="argument hierarchy_id", value=hierarchy_id, expected_type=type_hints["hierarchy_id"])
                check_type(argname="argument drill_down_filters", value=drill_down_filters, expected_type=type_hints["drill_down_filters"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "hierarchy_id": hierarchy_id,
            }
            if drill_down_filters is not None:
                self._values["drill_down_filters"] = drill_down_filters

        @builtins.property
        def hierarchy_id(self) -> builtins.str:
            '''The hierarchy ID of the ``DateTime`` hierarchy.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html#cfn-quicksight-analysis-datetimehierarchy-hierarchyid
            '''
            result = self._values.get("hierarchy_id")
            assert result is not None, "Required property 'hierarchy_id' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def drill_down_filters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DrillDownFilterProperty"]]]]:
            '''The option that determines the drill down filters for the ``DateTime`` hierarchy.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html#cfn-quicksight-analysis-datetimehierarchy-drilldownfilters
            '''
            result = self._values.get("drill_down_filters")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DrillDownFilterProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeHierarchyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterDeclarationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "default_values": "defaultValues",
            "mapped_data_set_parameters": "mappedDataSetParameters",
            "time_granularity": "timeGranularity",
            "value_when_unset": "valueWhenUnset",
        },
    )
    class DateTimeParameterDeclarationProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            default_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimeDefaultValuesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            mapped_data_set_parameters: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MappedDataSetParameterProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            time_granularity: typing.Optional[builtins.str] = None,
            value_when_unset: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A parameter declaration for the ``DateTime`` data type.

            :param name: The name of the parameter that is being declared.
            :param default_values: The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.
            :param mapped_data_set_parameters: 
            :param time_granularity: The level of time precision that is used to aggregate ``DateTime`` values.
            :param value_when_unset: The configuration that defines the default value of a ``DateTime`` parameter when a value has not been set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_parameter_declaration_property = quicksight.CfnAnalysis.DateTimeParameterDeclarationProperty(
                    name="name",
                
                    # the properties below are optional
                    default_values=quicksight.CfnAnalysis.DateTimeDefaultValuesProperty(
                        dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                            default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            )
                        ),
                        rolling_date=quicksight.CfnAnalysis.RollingDateConfigurationProperty(
                            expression="expression",
                
                            # the properties below are optional
                            data_set_identifier="dataSetIdentifier"
                        ),
                        static_values=["staticValues"]
                    ),
                    mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                        data_set_identifier="dataSetIdentifier",
                        data_set_parameter_name="dataSetParameterName"
                    )],
                    time_granularity="timeGranularity",
                    value_when_unset=quicksight.CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty(
                        custom_value="customValue",
                        value_when_unset_option="valueWhenUnsetOption"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7a68ab56c16f4db8843b372cb5d3ee1a3e4be61d10c8ef69ba820c5da2b8a931)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument default_values", value=default_values, expected_type=type_hints["default_values"])
                check_type(argname="argument mapped_data_set_parameters", value=mapped_data_set_parameters, expected_type=type_hints["mapped_data_set_parameters"])
                check_type(argname="argument time_granularity", value=time_granularity, expected_type=type_hints["time_granularity"])
                check_type(argname="argument value_when_unset", value=value_when_unset, expected_type=type_hints["value_when_unset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }
            if default_values is not None:
                self._values["default_values"] = default_values
            if mapped_data_set_parameters is not None:
                self._values["mapped_data_set_parameters"] = mapped_data_set_parameters
            if time_granularity is not None:
                self._values["time_granularity"] = time_granularity
            if value_when_unset is not None:
                self._values["value_when_unset"] = value_when_unset

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the parameter that is being declared.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeDefaultValuesProperty"]]:
            '''The default values of a parameter.

            If the parameter is a single-value parameter, a maximum of one default value can be provided.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-defaultvalues
            '''
            result = self._values.get("default_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeDefaultValuesProperty"]], result)

        @builtins.property
        def mapped_data_set_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MappedDataSetParameterProperty"]]]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-mappeddatasetparameters
            '''
            result = self._values.get("mapped_data_set_parameters")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MappedDataSetParameterProperty"]]]], result)

        @builtins.property
        def time_granularity(self) -> typing.Optional[builtins.str]:
            '''The level of time precision that is used to aggregate ``DateTime`` values.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-timegranularity
            '''
            result = self._values.get("time_granularity")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def value_when_unset(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty"]]:
            '''The configuration that defines the default value of a ``DateTime`` parameter when a value has not been set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-valuewhenunset
            '''
            result = self._values.get("value_when_unset")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeParameterDeclarationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeParameterProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "values": "values"},
    )
    class DateTimeParameterProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            values: typing.Sequence[builtins.str],
        ) -> None:
            '''A date-time parameter.

            :param name: A display name for the date-time parameter.
            :param values: The values for the date-time parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_parameter_property = quicksight.CfnAnalysis.DateTimeParameterProperty(
                    name="name",
                    values=["values"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c4df0ff05d2f7f0ede02161ea59214e17a3da562d2ba522d066c007b3508815e)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument values", value=values, expected_type=type_hints["values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "values": values,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''A display name for the date-time parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def values(self) -> typing.List[builtins.str]:
            '''The values for the date-time parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-values
            '''
            result = self._values.get("values")
            assert result is not None, "Required property 'values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeParameterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "date_icon_visibility": "dateIconVisibility",
            "date_time_format": "dateTimeFormat",
            "helper_text_visibility": "helperTextVisibility",
            "info_icon_label_options": "infoIconLabelOptions",
            "title_options": "titleOptions",
        },
    )
    class DateTimePickerControlDisplayOptionsProperty:
        def __init__(
            self,
            *,
            date_icon_visibility: typing.Optional[builtins.str] = None,
            date_time_format: typing.Optional[builtins.str] = None,
            helper_text_visibility: typing.Optional[builtins.str] = None,
            info_icon_label_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SheetControlInfoIconLabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            title_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.LabelOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The display options of a control.

            :param date_icon_visibility: The date icon visibility of the ``DateTimePickerControlDisplayOptions`` .
            :param date_time_format: Customize how dates are formatted in controls.
            :param helper_text_visibility: The helper text visibility of the ``DateTimePickerControlDisplayOptions`` .
            :param info_icon_label_options: The configuration of info icon label options.
            :param title_options: The options to configure the title visibility, name, and font size.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_picker_control_display_options_property = quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                    date_icon_visibility="dateIconVisibility",
                    date_time_format="dateTimeFormat",
                    helper_text_visibility="helperTextVisibility",
                    info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                        info_icon_text="infoIconText",
                        visibility="visibility"
                    ),
                    title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                        custom_label="customLabel",
                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                            font_color="fontColor",
                            font_decoration="fontDecoration",
                            font_family="fontFamily",
                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                absolute="absolute",
                                relative="relative"
                            ),
                            font_style="fontStyle",
                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                name="name"
                            )
                        ),
                        visibility="visibility"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__16031b544a2c676bbfee7ed1c93e204aa5a7f2dab58622a274141ef9710b48c8)
                check_type(argname="argument date_icon_visibility", value=date_icon_visibility, expected_type=type_hints["date_icon_visibility"])
                check_type(argname="argument date_time_format", value=date_time_format, expected_type=type_hints["date_time_format"])
                check_type(argname="argument helper_text_visibility", value=helper_text_visibility, expected_type=type_hints["helper_text_visibility"])
                check_type(argname="argument info_icon_label_options", value=info_icon_label_options, expected_type=type_hints["info_icon_label_options"])
                check_type(argname="argument title_options", value=title_options, expected_type=type_hints["title_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if date_icon_visibility is not None:
                self._values["date_icon_visibility"] = date_icon_visibility
            if date_time_format is not None:
                self._values["date_time_format"] = date_time_format
            if helper_text_visibility is not None:
                self._values["helper_text_visibility"] = helper_text_visibility
            if info_icon_label_options is not None:
                self._values["info_icon_label_options"] = info_icon_label_options
            if title_options is not None:
                self._values["title_options"] = title_options

        @builtins.property
        def date_icon_visibility(self) -> typing.Optional[builtins.str]:
            '''The date icon visibility of the ``DateTimePickerControlDisplayOptions`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-dateiconvisibility
            '''
            result = self._values.get("date_icon_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def date_time_format(self) -> typing.Optional[builtins.str]:
            '''Customize how dates are formatted in controls.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-datetimeformat
            '''
            result = self._values.get("date_time_format")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def helper_text_visibility(self) -> typing.Optional[builtins.str]:
            '''The helper text visibility of the ``DateTimePickerControlDisplayOptions`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-helpertextvisibility
            '''
            result = self._values.get("helper_text_visibility")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def info_icon_label_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetControlInfoIconLabelOptionsProperty"]]:
            '''The configuration of info icon label options.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-infoiconlabeloptions
            '''
            result = self._values.get("info_icon_label_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SheetControlInfoIconLabelOptionsProperty"]], result)

        @builtins.property
        def title_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LabelOptionsProperty"]]:
            '''The options to configure the title visibility, name, and font size.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-titleoptions
            '''
            result = self._values.get("title_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.LabelOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimePickerControlDisplayOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_value": "customValue",
            "value_when_unset_option": "valueWhenUnsetOption",
        },
    )
    class DateTimeValueWhenUnsetConfigurationProperty:
        def __init__(
            self,
            *,
            custom_value: typing.Optional[builtins.str] = None,
            value_when_unset_option: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration that defines the default value of a ``DateTime`` parameter when a value has not been set.

            :param custom_value: A custom value that's used when the value of a parameter isn't set.
            :param value_when_unset_option: The built-in options for default values. The value can be one of the following:. - ``RECOMMENDED`` : The recommended value. - ``NULL`` : The ``NULL`` value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                date_time_value_when_unset_configuration_property = quicksight.CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty(
                    custom_value="customValue",
                    value_when_unset_option="valueWhenUnsetOption"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__496e42293484deb5a0ef4cc356b965767bd664aee533cf7d9bcb6320cc824c66)
                check_type(argname="argument custom_value", value=custom_value, expected_type=type_hints["custom_value"])
                check_type(argname="argument value_when_unset_option", value=value_when_unset_option, expected_type=type_hints["value_when_unset_option"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_value is not None:
                self._values["custom_value"] = custom_value
            if value_when_unset_option is not None:
                self._values["value_when_unset_option"] = value_when_unset_option

        @builtins.property
        def custom_value(self) -> typing.Optional[builtins.str]:
            '''A custom value that's used when the value of a parameter isn't set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html#cfn-quicksight-analysis-datetimevaluewhenunsetconfiguration-customvalue
            '''
            result = self._values.get("custom_value")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def value_when_unset_option(self) -> typing.Optional[builtins.str]:
            '''The built-in options for default values. The value can be one of the following:.

            - ``RECOMMENDED`` : The recommended value.
            - ``NULL`` : The ``NULL`` value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html#cfn-quicksight-analysis-datetimevaluewhenunsetconfiguration-valuewhenunsetoption
            '''
            result = self._values.get("value_when_unset_option")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DateTimeValueWhenUnsetConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalDefaultValuesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "dynamic_value": "dynamicValue",
            "static_values": "staticValues",
        },
    )
    class DecimalDefaultValuesProperty:
        def __init__(
            self,
            *,
            dynamic_value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DynamicDefaultValueProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            static_values: typing.Optional[typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b]] = None,
        ) -> None:
            '''The default values of the ``DecimalParameterDeclaration`` .

            :param dynamic_value: The dynamic value of the ``DecimalDefaultValues`` . Different defaults are displayed according to users, groups, and values mapping.
            :param static_values: The static values of the ``DecimalDefaultValues`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                decimal_default_values_property = quicksight.CfnAnalysis.DecimalDefaultValuesProperty(
                    dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                        default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                
                        # the properties below are optional
                        group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        )
                    ),
                    static_values=[123]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6041f968355c092078a2031614955bc07a4930897e0c000ded27c288989fb7ee)
                check_type(argname="argument dynamic_value", value=dynamic_value, expected_type=type_hints["dynamic_value"])
                check_type(argname="argument static_values", value=static_values, expected_type=type_hints["static_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if dynamic_value is not None:
                self._values["dynamic_value"] = dynamic_value
            if static_values is not None:
                self._values["static_values"] = static_values

        @builtins.property
        def dynamic_value(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DynamicDefaultValueProperty"]]:
            '''The dynamic value of the ``DecimalDefaultValues`` .

            Different defaults are displayed according to users, groups, and values mapping.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html#cfn-quicksight-analysis-decimaldefaultvalues-dynamicvalue
            '''
            result = self._values.get("dynamic_value")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DynamicDefaultValueProperty"]], result)

        @builtins.property
        def static_values(
            self,
        ) -> typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]]:
            '''The static values of the ``DecimalDefaultValues`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html#cfn-quicksight-analysis-decimaldefaultvalues-staticvalues
            '''
            result = self._values.get("static_values")
            return typing.cast(typing.Optional[typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DecimalDefaultValuesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterDeclarationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "parameter_value_type": "parameterValueType",
            "default_values": "defaultValues",
            "mapped_data_set_parameters": "mappedDataSetParameters",
            "value_when_unset": "valueWhenUnset",
        },
    )
    class DecimalParameterDeclarationProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            parameter_value_type: builtins.str,
            default_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DecimalDefaultValuesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            mapped_data_set_parameters: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.MappedDataSetParameterProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            value_when_unset: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A parameter declaration for the ``Decimal`` data type.

            :param name: The name of the parameter that is being declared.
            :param parameter_value_type: The value type determines whether the parameter is a single-value or multi-value parameter.
            :param default_values: The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.
            :param mapped_data_set_parameters: 
            :param value_when_unset: The configuration that defines the default value of a ``Decimal`` parameter when a value has not been set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                decimal_parameter_declaration_property = quicksight.CfnAnalysis.DecimalParameterDeclarationProperty(
                    name="name",
                    parameter_value_type="parameterValueType",
                
                    # the properties below are optional
                    default_values=quicksight.CfnAnalysis.DecimalDefaultValuesProperty(
                        dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                            default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                
                            # the properties below are optional
                            group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            )
                        ),
                        static_values=[123]
                    ),
                    mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                        data_set_identifier="dataSetIdentifier",
                        data_set_parameter_name="dataSetParameterName"
                    )],
                    value_when_unset=quicksight.CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty(
                        custom_value=123,
                        value_when_unset_option="valueWhenUnsetOption"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e7a7efdffb85dad0fe095929a9da76445b466b9316260d44790824714f09c274)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument parameter_value_type", value=parameter_value_type, expected_type=type_hints["parameter_value_type"])
                check_type(argname="argument default_values", value=default_values, expected_type=type_hints["default_values"])
                check_type(argname="argument mapped_data_set_parameters", value=mapped_data_set_parameters, expected_type=type_hints["mapped_data_set_parameters"])
                check_type(argname="argument value_when_unset", value=value_when_unset, expected_type=type_hints["value_when_unset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "parameter_value_type": parameter_value_type,
            }
            if default_values is not None:
                self._values["default_values"] = default_values
            if mapped_data_set_parameters is not None:
                self._values["mapped_data_set_parameters"] = mapped_data_set_parameters
            if value_when_unset is not None:
                self._values["value_when_unset"] = value_when_unset

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the parameter that is being declared.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def parameter_value_type(self) -> builtins.str:
            '''The value type determines whether the parameter is a single-value or multi-value parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-parametervaluetype
            '''
            result = self._values.get("parameter_value_type")
            assert result is not None, "Required property 'parameter_value_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalDefaultValuesProperty"]]:
            '''The default values of a parameter.

            If the parameter is a single-value parameter, a maximum of one default value can be provided.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-defaultvalues
            '''
            result = self._values.get("default_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalDefaultValuesProperty"]], result)

        @builtins.property
        def mapped_data_set_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MappedDataSetParameterProperty"]]]]:
            '''
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-mappeddatasetparameters
            '''
            result = self._values.get("mapped_data_set_parameters")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.MappedDataSetParameterProperty"]]]], result)

        @builtins.property
        def value_when_unset(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty"]]:
            '''The configuration that defines the default value of a ``Decimal`` parameter when a value has not been set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-valuewhenunset
            '''
            result = self._values.get("value_when_unset")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DecimalParameterDeclarationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalParameterProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "values": "values"},
    )
    class DecimalParameterProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            values: typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b],
        ) -> None:
            '''A decimal parameter.

            :param name: A display name for the decimal parameter.
            :param values: The values for the decimal parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                decimal_parameter_property = quicksight.CfnAnalysis.DecimalParameterProperty(
                    name="name",
                    values=[123]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1c30fcfd3a96dfa875b3537e48e84a223b349d53190700099dc7830feb1f0b64)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument values", value=values, expected_type=type_hints["values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "values": values,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''A display name for the decimal parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def values(
            self,
        ) -> typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]:
            '''The values for the decimal parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values
            '''
            result = self._values.get("values")
            assert result is not None, "Required property 'values' is missing"
            return typing.cast(typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DecimalParameterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"decimal_places": "decimalPlaces"},
    )
    class DecimalPlacesConfigurationProperty:
        def __init__(self, *, decimal_places: jsii.Number) -> None:
            '''The option that determines the decimal places configuration.

            :param decimal_places: The values of the decimal places.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalplacesconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                decimal_places_configuration_property = quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                    decimal_places=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fdba937bce62805797d8bd38df0006794f78ccf7a86bb2a96afd1ccc3c7d830d)
                check_type(argname="argument decimal_places", value=decimal_places, expected_type=type_hints["decimal_places"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "decimal_places": decimal_places,
            }

        @builtins.property
        def decimal_places(self) -> jsii.Number:
            '''The values of the decimal places.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalplacesconfiguration.html#cfn-quicksight-analysis-decimalplacesconfiguration-decimalplaces
            '''
            result = self._values.get("decimal_places")
            assert result is not None, "Required property 'decimal_places' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DecimalPlacesConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_value": "customValue",
            "value_when_unset_option": "valueWhenUnsetOption",
        },
    )
    class DecimalValueWhenUnsetConfigurationProperty:
        def __init__(
            self,
            *,
            custom_value: typing.Optional[jsii.Number] = None,
            value_when_unset_option: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration that defines the default value of a ``Decimal`` parameter when a value has not been set.

            :param custom_value: A custom value that's used when the value of a parameter isn't set.
            :param value_when_unset_option: The built-in options for default values. The value can be one of the following:. - ``RECOMMENDED`` : The recommended value. - ``NULL`` : The ``NULL`` value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                decimal_value_when_unset_configuration_property = quicksight.CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty(
                    custom_value=123,
                    value_when_unset_option="valueWhenUnsetOption"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b5b58e947afff94824ee0192ed7fb58383917df19648d81c4312996d2c9149d1)
                check_type(argname="argument custom_value", value=custom_value, expected_type=type_hints["custom_value"])
                check_type(argname="argument value_when_unset_option", value=value_when_unset_option, expected_type=type_hints["value_when_unset_option"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_value is not None:
                self._values["custom_value"] = custom_value
            if value_when_unset_option is not None:
                self._values["value_when_unset_option"] = value_when_unset_option

        @builtins.property
        def custom_value(self) -> typing.Optional[jsii.Number]:
            '''A custom value that's used when the value of a parameter isn't set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-decimalvaluewhenunsetconfiguration-customvalue
            '''
            result = self._values.get("custom_value")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def value_when_unset_option(self) -> typing.Optional[builtins.str]:
            '''The built-in options for default values. The value can be one of the following:.

            - ``RECOMMENDED`` : The recommended value.
            - ``NULL`` : The ``NULL`` value.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-decimalvaluewhenunsetconfiguration-valuewhenunsetoption
            '''
            result = self._values.get("value_when_unset_option")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DecimalValueWhenUnsetConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "commit_mode": "commitMode",
            "display_options": "displayOptions",
            "type": "type",
        },
    )
    class DefaultDateTimePickerControlOptionsProperty:
        def __init__(
            self,
            *,
            commit_mode: typing.Optional[builtins.str] = None,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateTimePickerControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The default options that correspond to the filter control type of a ``DateTimePicker`` .

            :param commit_mode: The visibility configuration of the Apply button on a ``DateTimePickerControl`` .
            :param display_options: The display options of a control.
            :param type: The date time picker type of the ``DefaultDateTimePickerControlOptions`` . Choose one of the following options:. - ``SINGLE_VALUED`` : The filter condition is a fixed date. - ``DATE_RANGE`` : The filter condition is a date time range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_date_time_picker_control_options_property = quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty(
                    commit_mode="commitMode",
                    display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                        date_icon_visibility="dateIconVisibility",
                        date_time_format="dateTimeFormat",
                        helper_text_visibility="helperTextVisibility",
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    ),
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__52fd2c3e57bfcf88ae48256a8376a66a8e65189b3c80fbf4e5c127c6c6b186ec)
                check_type(argname="argument commit_mode", value=commit_mode, expected_type=type_hints["commit_mode"])
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if commit_mode is not None:
                self._values["commit_mode"] = commit_mode
            if display_options is not None:
                self._values["display_options"] = display_options
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def commit_mode(self) -> typing.Optional[builtins.str]:
            '''The visibility configuration of the Apply button on a ``DateTimePickerControl`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-commitmode
            '''
            result = self._values.get("commit_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimePickerControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DateTimePickerControlDisplayOptionsProperty"]], result)

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            '''The date time picker type of the ``DefaultDateTimePickerControlOptions`` . Choose one of the following options:.

            - ``SINGLE_VALUED`` : The filter condition is a fixed date.
            - ``DATE_RANGE`` : The filter condition is a date time range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-type
            '''
            result = self._values.get("type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultDateTimePickerControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFilterControlConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"control_options": "controlOptions", "title": "title"},
    )
    class DefaultFilterControlConfigurationProperty:
        def __init__(
            self,
            *,
            control_options: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFilterControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]],
            title: builtins.str,
        ) -> None:
            '''The default configuration for all dependent controls of the filter.

            :param control_options: The control option for the ``DefaultFilterControlConfiguration`` .
            :param title: The title of the ``DefaultFilterControlConfiguration`` . This title is shared by all controls that are tied to this filter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_filter_control_configuration_property = quicksight.CfnAnalysis.DefaultFilterControlConfigurationProperty(
                    control_options=quicksight.CfnAnalysis.DefaultFilterControlOptionsProperty(
                        default_date_time_picker_options=quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty(
                            commit_mode="commitMode",
                            display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                                date_icon_visibility="dateIconVisibility",
                                date_time_format="dateTimeFormat",
                                helper_text_visibility="helperTextVisibility",
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            type="type"
                        ),
                        default_dropdown_options=quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty(
                            commit_mode="commitMode",
                            display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                values=["values"]
                            ),
                            type="type"
                        ),
                        default_list_options=quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty(
                            display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                    visibility="visibility"
                                ),
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                values=["values"]
                            ),
                            type="type"
                        ),
                        default_relative_date_time_options=quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty(
                            commit_mode="commitMode",
                            display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                                date_time_format="dateTimeFormat",
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        default_slider_options=quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty(
                            maximum_value=123,
                            minimum_value=123,
                            step_size=123,
                
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            type="type"
                        ),
                        default_text_area_options=quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty(
                            delimiter="delimiter",
                            display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        default_text_field_options=quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty(
                            display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                                info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                    info_icon_text="infoIconText",
                                    visibility="visibility"
                                ),
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_family="fontFamily",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            absolute="absolute",
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        )
                    ),
                    title="title"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9c54ffa25aef3d0006c58bcb7eac07d4710e567ec8fb974acf6d68a94a3e8758)
                check_type(argname="argument control_options", value=control_options, expected_type=type_hints["control_options"])
                check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "control_options": control_options,
                "title": title,
            }

        @builtins.property
        def control_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlOptionsProperty"]:
            '''The control option for the ``DefaultFilterControlConfiguration`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html#cfn-quicksight-analysis-defaultfiltercontrolconfiguration-controloptions
            '''
            result = self._values.get("control_options")
            assert result is not None, "Required property 'control_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterControlOptionsProperty"], result)

        @builtins.property
        def title(self) -> builtins.str:
            '''The title of the ``DefaultFilterControlConfiguration`` .

            This title is shared by all controls that are tied to this filter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html#cfn-quicksight-analysis-defaultfiltercontrolconfiguration-title
            '''
            result = self._values.get("title")
            assert result is not None, "Required property 'title' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultFilterControlConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFilterControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_date_time_picker_options": "defaultDateTimePickerOptions",
            "default_dropdown_options": "defaultDropdownOptions",
            "default_list_options": "defaultListOptions",
            "default_relative_date_time_options": "defaultRelativeDateTimeOptions",
            "default_slider_options": "defaultSliderOptions",
            "default_text_area_options": "defaultTextAreaOptions",
            "default_text_field_options": "defaultTextFieldOptions",
        },
    )
    class DefaultFilterControlOptionsProperty:
        def __init__(
            self,
            *,
            default_date_time_picker_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultDateTimePickerControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_dropdown_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFilterDropDownControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_list_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFilterListControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_relative_date_time_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_slider_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultSliderControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_text_area_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultTextAreaControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            default_text_field_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultTextFieldControlOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The option that corresponds to the control type of the filter.

            :param default_date_time_picker_options: The default options that correspond to the filter control type of a ``DateTimePicker`` .
            :param default_dropdown_options: The default options that correspond to the ``Dropdown`` filter control type.
            :param default_list_options: The default options that correspond to the ``List`` filter control type.
            :param default_relative_date_time_options: The default options that correspond to the ``RelativeDateTime`` filter control type.
            :param default_slider_options: The default options that correspond to the ``Slider`` filter control type.
            :param default_text_area_options: The default options that correspond to the ``TextArea`` filter control type.
            :param default_text_field_options: The default options that correspond to the ``TextField`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_filter_control_options_property = quicksight.CfnAnalysis.DefaultFilterControlOptionsProperty(
                    default_date_time_picker_options=quicksight.CfnAnalysis.DefaultDateTimePickerControlOptionsProperty(
                        commit_mode="commitMode",
                        display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                            date_icon_visibility="dateIconVisibility",
                            date_time_format="dateTimeFormat",
                            helper_text_visibility="helperTextVisibility",
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        ),
                        type="type"
                    ),
                    default_dropdown_options=quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty(
                        commit_mode="commitMode",
                        display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        ),
                        selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                            values=["values"]
                        ),
                        type="type"
                    ),
                    default_list_options=quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty(
                        display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                visibility="visibility"
                            ),
                            select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        ),
                        selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                            values=["values"]
                        ),
                        type="type"
                    ),
                    default_relative_date_time_options=quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty(
                        commit_mode="commitMode",
                        display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                            date_time_format="dateTimeFormat",
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        )
                    ),
                    default_slider_options=quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty(
                        maximum_value=123,
                        minimum_value=123,
                        step_size=123,
                
                        # the properties below are optional
                        display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        ),
                        type="type"
                    ),
                    default_text_area_options=quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty(
                        delimiter="delimiter",
                        display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        )
                    ),
                    default_text_field_options=quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty(
                        display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                            info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                                info_icon_text="infoIconText",
                                visibility="visibility"
                            ),
                            placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                visibility="visibility"
                            ),
                            title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                custom_label="customLabel",
                                font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                    font_color="fontColor",
                                    font_decoration="fontDecoration",
                                    font_family="fontFamily",
                                    font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                        absolute="absolute",
                                        relative="relative"
                                    ),
                                    font_style="fontStyle",
                                    font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                        name="name"
                                    )
                                ),
                                visibility="visibility"
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__27b627960050d3c2cdf76aac886a9d384e7246b266fad2f94446379ec4e5d8b7)
                check_type(argname="argument default_date_time_picker_options", value=default_date_time_picker_options, expected_type=type_hints["default_date_time_picker_options"])
                check_type(argname="argument default_dropdown_options", value=default_dropdown_options, expected_type=type_hints["default_dropdown_options"])
                check_type(argname="argument default_list_options", value=default_list_options, expected_type=type_hints["default_list_options"])
                check_type(argname="argument default_relative_date_time_options", value=default_relative_date_time_options, expected_type=type_hints["default_relative_date_time_options"])
                check_type(argname="argument default_slider_options", value=default_slider_options, expected_type=type_hints["default_slider_options"])
                check_type(argname="argument default_text_area_options", value=default_text_area_options, expected_type=type_hints["default_text_area_options"])
                check_type(argname="argument default_text_field_options", value=default_text_field_options, expected_type=type_hints["default_text_field_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_date_time_picker_options is not None:
                self._values["default_date_time_picker_options"] = default_date_time_picker_options
            if default_dropdown_options is not None:
                self._values["default_dropdown_options"] = default_dropdown_options
            if default_list_options is not None:
                self._values["default_list_options"] = default_list_options
            if default_relative_date_time_options is not None:
                self._values["default_relative_date_time_options"] = default_relative_date_time_options
            if default_slider_options is not None:
                self._values["default_slider_options"] = default_slider_options
            if default_text_area_options is not None:
                self._values["default_text_area_options"] = default_text_area_options
            if default_text_field_options is not None:
                self._values["default_text_field_options"] = default_text_field_options

        @builtins.property
        def default_date_time_picker_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultDateTimePickerControlOptionsProperty"]]:
            '''The default options that correspond to the filter control type of a ``DateTimePicker`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultdatetimepickeroptions
            '''
            result = self._values.get("default_date_time_picker_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultDateTimePickerControlOptionsProperty"]], result)

        @builtins.property
        def default_dropdown_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterDropDownControlOptionsProperty"]]:
            '''The default options that correspond to the ``Dropdown`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultdropdownoptions
            '''
            result = self._values.get("default_dropdown_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterDropDownControlOptionsProperty"]], result)

        @builtins.property
        def default_list_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterListControlOptionsProperty"]]:
            '''The default options that correspond to the ``List`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultlistoptions
            '''
            result = self._values.get("default_list_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFilterListControlOptionsProperty"]], result)

        @builtins.property
        def default_relative_date_time_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty"]]:
            '''The default options that correspond to the ``RelativeDateTime`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultrelativedatetimeoptions
            '''
            result = self._values.get("default_relative_date_time_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty"]], result)

        @builtins.property
        def default_slider_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultSliderControlOptionsProperty"]]:
            '''The default options that correspond to the ``Slider`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultslideroptions
            '''
            result = self._values.get("default_slider_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultSliderControlOptionsProperty"]], result)

        @builtins.property
        def default_text_area_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultTextAreaControlOptionsProperty"]]:
            '''The default options that correspond to the ``TextArea`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaulttextareaoptions
            '''
            result = self._values.get("default_text_area_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultTextAreaControlOptionsProperty"]], result)

        @builtins.property
        def default_text_field_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultTextFieldControlOptionsProperty"]]:
            '''The default options that correspond to the ``TextField`` filter control type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaulttextfieldoptions
            '''
            result = self._values.get("default_text_field_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultTextFieldControlOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultFilterControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "commit_mode": "commitMode",
            "display_options": "displayOptions",
            "selectable_values": "selectableValues",
            "type": "type",
        },
    )
    class DefaultFilterDropDownControlOptionsProperty:
        def __init__(
            self,
            *,
            commit_mode: typing.Optional[builtins.str] = None,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DropDownControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            selectable_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterSelectableValuesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The default options that correspond to the ``Dropdown`` filter control type.

            :param commit_mode: The visibility configuration of the Apply button on a ``FilterDropDownControl`` .
            :param display_options: The display options of a control.
            :param selectable_values: A list of selectable values that are used in a control.
            :param type: The type of the ``FilterDropDownControl`` . Choose one of the following options:. - ``MULTI_SELECT`` : The user can select multiple entries from a dropdown menu. - ``SINGLE_SELECT`` : The user can select a single entry from a dropdown menu.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_filter_drop_down_control_options_property = quicksight.CfnAnalysis.DefaultFilterDropDownControlOptionsProperty(
                    commit_mode="commitMode",
                    display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    ),
                    selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                        values=["values"]
                    ),
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__00d4312e6cf7d6b386f290ad11b6c17be510948da18718023b41f8ec7a6ac06a)
                check_type(argname="argument commit_mode", value=commit_mode, expected_type=type_hints["commit_mode"])
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
                check_type(argname="argument selectable_values", value=selectable_values, expected_type=type_hints["selectable_values"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if commit_mode is not None:
                self._values["commit_mode"] = commit_mode
            if display_options is not None:
                self._values["display_options"] = display_options
            if selectable_values is not None:
                self._values["selectable_values"] = selectable_values
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def commit_mode(self) -> typing.Optional[builtins.str]:
            '''The visibility configuration of the Apply button on a ``FilterDropDownControl`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-commitmode
            '''
            result = self._values.get("commit_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DropDownControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DropDownControlDisplayOptionsProperty"]], result)

        @builtins.property
        def selectable_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterSelectableValuesProperty"]]:
            '''A list of selectable values that are used in a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-selectablevalues
            '''
            result = self._values.get("selectable_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterSelectableValuesProperty"]], result)

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            '''The type of the ``FilterDropDownControl`` . Choose one of the following options:.

            - ``MULTI_SELECT`` : The user can select multiple entries from a dropdown menu.
            - ``SINGLE_SELECT`` : The user can select a single entry from a dropdown menu.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-type
            '''
            result = self._values.get("type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultFilterDropDownControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "display_options": "displayOptions",
            "selectable_values": "selectableValues",
            "type": "type",
        },
    )
    class DefaultFilterListControlOptionsProperty:
        def __init__(
            self,
            *,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ListControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            selectable_values: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FilterSelectableValuesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The default options that correspond to the ``List`` filter control type.

            :param display_options: The display options of a control.
            :param selectable_values: A list of selectable values that are used in a control.
            :param type: The type of the ``DefaultFilterListControlOptions`` . Choose one of the following options:. - ``MULTI_SELECT`` : The user can select multiple entries from the list. - ``SINGLE_SELECT`` : The user can select a single entry from the list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_filter_list_control_options_property = quicksight.CfnAnalysis.DefaultFilterListControlOptionsProperty(
                    display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                            visibility="visibility"
                        ),
                        select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    ),
                    selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                        values=["values"]
                    ),
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f641da615cfeb129ca98765fa21e13079cf56817ce0766f97ed20dd07c3e87d1)
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
                check_type(argname="argument selectable_values", value=selectable_values, expected_type=type_hints["selectable_values"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if display_options is not None:
                self._values["display_options"] = display_options
            if selectable_values is not None:
                self._values["selectable_values"] = selectable_values
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ListControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ListControlDisplayOptionsProperty"]], result)

        @builtins.property
        def selectable_values(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterSelectableValuesProperty"]]:
            '''A list of selectable values that are used in a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-selectablevalues
            '''
            result = self._values.get("selectable_values")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FilterSelectableValuesProperty"]], result)

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            '''The type of the ``DefaultFilterListControlOptions`` . Choose one of the following options:.

            - ``MULTI_SELECT`` : The user can select multiple entries from the list.
            - ``SINGLE_SELECT`` : The user can select a single entry from the list.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-type
            '''
            result = self._values.get("type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultFilterListControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"canvas_size_options": "canvasSizeOptions"},
    )
    class DefaultFreeFormLayoutConfigurationProperty:
        def __init__(
            self,
            *,
            canvas_size_options: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The options that determine the default settings of a free-form layout configuration.

            :param canvas_size_options: Determines the screen canvas size options for a free-form layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfreeformlayoutconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_free_form_layout_configuration_property = quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty(
                    canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                        screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                            optimized_view_port_width="optimizedViewPortWidth"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2576800bc2c6797c492467497289cafee3725d83b8b2a0c3e9ada116b562fb6d)
                check_type(argname="argument canvas_size_options", value=canvas_size_options, expected_type=type_hints["canvas_size_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "canvas_size_options": canvas_size_options,
            }

        @builtins.property
        def canvas_size_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty"]:
            '''Determines the screen canvas size options for a free-form layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfreeformlayoutconfiguration.html#cfn-quicksight-analysis-defaultfreeformlayoutconfiguration-canvassizeoptions
            '''
            result = self._values.get("canvas_size_options")
            assert result is not None, "Required property 'canvas_size_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultFreeFormLayoutConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"canvas_size_options": "canvasSizeOptions"},
    )
    class DefaultGridLayoutConfigurationProperty:
        def __init__(
            self,
            *,
            canvas_size_options: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.GridLayoutCanvasSizeOptionsProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The options that determine the default settings for a grid layout configuration.

            :param canvas_size_options: Determines the screen canvas size options for a grid layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultgridlayoutconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_grid_layout_configuration_property = quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty(
                    canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                        screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                            resize_option="resizeOption",
                
                            # the properties below are optional
                            optimized_view_port_width="optimizedViewPortWidth"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8086a8fa2fdaace4e00baac5605b96e46ed5fb1925470181b7056cabae70c506)
                check_type(argname="argument canvas_size_options", value=canvas_size_options, expected_type=type_hints["canvas_size_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "canvas_size_options": canvas_size_options,
            }

        @builtins.property
        def canvas_size_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GridLayoutCanvasSizeOptionsProperty"]:
            '''Determines the screen canvas size options for a grid layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultgridlayoutconfiguration.html#cfn-quicksight-analysis-defaultgridlayoutconfiguration-canvassizeoptions
            '''
            result = self._values.get("canvas_size_options")
            assert result is not None, "Required property 'canvas_size_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.GridLayoutCanvasSizeOptionsProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultGridLayoutConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"free_form": "freeForm", "grid": "grid"},
    )
    class DefaultInteractiveLayoutConfigurationProperty:
        def __init__(
            self,
            *,
            free_form: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            grid: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultGridLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The options that determine the default settings for interactive layout configuration.

            :param free_form: The options that determine the default settings of a free-form layout configuration.
            :param grid: The options that determine the default settings for a grid layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_interactive_layout_configuration_property = quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty(
                    free_form=quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty(
                        canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                            screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                                optimized_view_port_width="optimizedViewPortWidth"
                            )
                        )
                    ),
                    grid=quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty(
                        canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                            screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                resize_option="resizeOption",
                
                                # the properties below are optional
                                optimized_view_port_width="optimizedViewPortWidth"
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d04354276f7247945ccd165e93cd180a01a97b610a00894675eb0c9f03759f12)
                check_type(argname="argument free_form", value=free_form, expected_type=type_hints["free_form"])
                check_type(argname="argument grid", value=grid, expected_type=type_hints["grid"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if free_form is not None:
                self._values["free_form"] = free_form
            if grid is not None:
                self._values["grid"] = grid

        @builtins.property
        def free_form(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty"]]:
            '''The options that determine the default settings of a free-form layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html#cfn-quicksight-analysis-defaultinteractivelayoutconfiguration-freeform
            '''
            result = self._values.get("free_form")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty"]], result)

        @builtins.property
        def grid(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultGridLayoutConfigurationProperty"]]:
            '''The options that determine the default settings for a grid layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html#cfn-quicksight-analysis-defaultinteractivelayoutconfiguration-grid
            '''
            result = self._values.get("grid")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultGridLayoutConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultInteractiveLayoutConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "interactive_layout_configuration": "interactiveLayoutConfiguration",
            "paginated_layout_configuration": "paginatedLayoutConfiguration",
            "sheet_content_type": "sheetContentType",
        },
    )
    class DefaultNewSheetConfigurationProperty:
        def __init__(
            self,
            *,
            interactive_layout_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            paginated_layout_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sheet_content_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for default new sheet settings.

            :param interactive_layout_configuration: The options that determine the default settings for interactive layout configuration.
            :param paginated_layout_configuration: The options that determine the default settings for a paginated layout configuration.
            :param sheet_content_type: The option that determines the sheet content type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_new_sheet_configuration_property = quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty(
                    interactive_layout_configuration=quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty(
                        free_form=quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty(
                            canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                                screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                                    optimized_view_port_width="optimizedViewPortWidth"
                                )
                            )
                        ),
                        grid=quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty(
                            canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                                screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                    resize_option="resizeOption",
                
                                    # the properties below are optional
                                    optimized_view_port_width="optimizedViewPortWidth"
                                )
                            )
                        )
                    ),
                    paginated_layout_configuration=quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty(
                        section_based=quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty(
                            canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                                paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                                    paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                        bottom="bottom",
                                        left="left",
                                        right="right",
                                        top="top"
                                    ),
                                    paper_orientation="paperOrientation",
                                    paper_size="paperSize"
                                )
                            )
                        )
                    ),
                    sheet_content_type="sheetContentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e7279c174707162e2869656b88d69fa16e6e97a88e1e9041bec55319aab36d19)
                check_type(argname="argument interactive_layout_configuration", value=interactive_layout_configuration, expected_type=type_hints["interactive_layout_configuration"])
                check_type(argname="argument paginated_layout_configuration", value=paginated_layout_configuration, expected_type=type_hints["paginated_layout_configuration"])
                check_type(argname="argument sheet_content_type", value=sheet_content_type, expected_type=type_hints["sheet_content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if interactive_layout_configuration is not None:
                self._values["interactive_layout_configuration"] = interactive_layout_configuration
            if paginated_layout_configuration is not None:
                self._values["paginated_layout_configuration"] = paginated_layout_configuration
            if sheet_content_type is not None:
                self._values["sheet_content_type"] = sheet_content_type

        @builtins.property
        def interactive_layout_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty"]]:
            '''The options that determine the default settings for interactive layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-interactivelayoutconfiguration
            '''
            result = self._values.get("interactive_layout_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty"]], result)

        @builtins.property
        def paginated_layout_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty"]]:
            '''The options that determine the default settings for a paginated layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-paginatedlayoutconfiguration
            '''
            result = self._values.get("paginated_layout_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty"]], result)

        @builtins.property
        def sheet_content_type(self) -> typing.Optional[builtins.str]:
            '''The option that determines the sheet content type.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-sheetcontenttype
            '''
            result = self._values.get("sheet_content_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultNewSheetConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"section_based": "sectionBased"},
    )
    class DefaultPaginatedLayoutConfigurationProperty:
        def __init__(
            self,
            *,
            section_based: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The options that determine the default settings for a paginated layout configuration.

            :param section_based: The options that determine the default settings for a section-based layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultpaginatedlayoutconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_paginated_layout_configuration_property = quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty(
                    section_based=quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty(
                        canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                            paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                                paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                    bottom="bottom",
                                    left="left",
                                    right="right",
                                    top="top"
                                ),
                                paper_orientation="paperOrientation",
                                paper_size="paperSize"
                            )
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5bd1fdbfb41878c1a01bf4ec5b04bee7584ad858147b67db1a2d05dda1702891)
                check_type(argname="argument section_based", value=section_based, expected_type=type_hints["section_based"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if section_based is not None:
                self._values["section_based"] = section_based

        @builtins.property
        def section_based(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty"]]:
            '''The options that determine the default settings for a section-based layout configuration.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultpaginatedlayoutconfiguration.html#cfn-quicksight-analysis-defaultpaginatedlayoutconfiguration-sectionbased
            '''
            result = self._values.get("section_based")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultPaginatedLayoutConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "commit_mode": "commitMode",
            "display_options": "displayOptions",
        },
    )
    class DefaultRelativeDateTimeControlOptionsProperty:
        def __init__(
            self,
            *,
            commit_mode: typing.Optional[builtins.str] = None,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The default options that correspond to the ``RelativeDateTime`` filter control type.

            :param commit_mode: The visibility configuration of the Apply button on a ``RelativeDateTimeControl`` .
            :param display_options: The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_relative_date_time_control_options_property = quicksight.CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty(
                    commit_mode="commitMode",
                    display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                        date_time_format="dateTimeFormat",
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1bd65586357ac07b086b4a81b5d3f1f351c9b2f5ee8daeddf95e0d79795820a9)
                check_type(argname="argument commit_mode", value=commit_mode, expected_type=type_hints["commit_mode"])
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if commit_mode is not None:
                self._values["commit_mode"] = commit_mode
            if display_options is not None:
                self._values["display_options"] = display_options

        @builtins.property
        def commit_mode(self) -> typing.Optional[builtins.str]:
            '''The visibility configuration of the Apply button on a ``RelativeDateTimeControl`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html#cfn-quicksight-analysis-defaultrelativedatetimecontroloptions-commitmode
            '''
            result = self._values.get("commit_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html#cfn-quicksight-analysis-defaultrelativedatetimecontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultRelativeDateTimeControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"canvas_size_options": "canvasSizeOptions"},
    )
    class DefaultSectionBasedLayoutConfigurationProperty:
        def __init__(
            self,
            *,
            canvas_size_options: typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The options that determine the default settings for a section-based layout configuration.

            :param canvas_size_options: Determines the screen canvas size options for a section-based layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultsectionbasedlayoutconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_section_based_layout_configuration_property = quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty(
                    canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                        paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                            paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                bottom="bottom",
                                left="left",
                                right="right",
                                top="top"
                            ),
                            paper_orientation="paperOrientation",
                            paper_size="paperSize"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__844118c582547d0457e97e77b0e34513191da4989820067b337b49d1e239a90b)
                check_type(argname="argument canvas_size_options", value=canvas_size_options, expected_type=type_hints["canvas_size_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "canvas_size_options": canvas_size_options,
            }

        @builtins.property
        def canvas_size_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty"]:
            '''Determines the screen canvas size options for a section-based layout.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultsectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-defaultsectionbasedlayoutconfiguration-canvassizeoptions
            '''
            result = self._values.get("canvas_size_options")
            assert result is not None, "Required property 'canvas_size_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultSectionBasedLayoutConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "maximum_value": "maximumValue",
            "minimum_value": "minimumValue",
            "step_size": "stepSize",
            "display_options": "displayOptions",
            "type": "type",
        },
    )
    class DefaultSliderControlOptionsProperty:
        def __init__(
            self,
            *,
            maximum_value: jsii.Number,
            minimum_value: jsii.Number,
            step_size: jsii.Number,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.SliderControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The default options that correspond to the ``Slider`` filter control type.

            :param maximum_value: The larger value that is displayed at the right of the slider. Default: - 0
            :param minimum_value: The smaller value that is displayed at the left of the slider. Default: - 0
            :param step_size: The number of increments that the slider bar is divided into. Default: - 0
            :param display_options: The display options of a control.
            :param type: The type of the ``DefaultSliderControlOptions`` . Choose one of the following options:. - ``SINGLE_POINT`` : Filter against(equals) a single data point. - ``RANGE`` : Filter data that is in a specified range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_slider_control_options_property = quicksight.CfnAnalysis.DefaultSliderControlOptionsProperty(
                    maximum_value=123,
                    minimum_value=123,
                    step_size=123,
                
                    # the properties below are optional
                    display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    ),
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__61d7bb3aff6e0969598d75d381b03158fdccf2281b38d66c965c3d8836aeaa93)
                check_type(argname="argument maximum_value", value=maximum_value, expected_type=type_hints["maximum_value"])
                check_type(argname="argument minimum_value", value=minimum_value, expected_type=type_hints["minimum_value"])
                check_type(argname="argument step_size", value=step_size, expected_type=type_hints["step_size"])
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "maximum_value": maximum_value,
                "minimum_value": minimum_value,
                "step_size": step_size,
            }
            if display_options is not None:
                self._values["display_options"] = display_options
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def maximum_value(self) -> jsii.Number:
            '''The larger value that is displayed at the right of the slider.

            :default: - 0

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-maximumvalue
            '''
            result = self._values.get("maximum_value")
            assert result is not None, "Required property 'maximum_value' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def minimum_value(self) -> jsii.Number:
            '''The smaller value that is displayed at the left of the slider.

            :default: - 0

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-minimumvalue
            '''
            result = self._values.get("minimum_value")
            assert result is not None, "Required property 'minimum_value' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def step_size(self) -> jsii.Number:
            '''The number of increments that the slider bar is divided into.

            :default: - 0

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-stepsize
            '''
            result = self._values.get("step_size")
            assert result is not None, "Required property 'step_size' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SliderControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.SliderControlDisplayOptionsProperty"]], result)

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            '''The type of the ``DefaultSliderControlOptions`` . Choose one of the following options:.

            - ``SINGLE_POINT`` : Filter against(equals) a single data point.
            - ``RANGE`` : Filter data that is in a specified range.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-type
            '''
            result = self._values.get("type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultSliderControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"delimiter": "delimiter", "display_options": "displayOptions"},
    )
    class DefaultTextAreaControlOptionsProperty:
        def __init__(
            self,
            *,
            delimiter: typing.Optional[builtins.str] = None,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TextAreaControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The default options that correspond to the ``TextArea`` filter control type.

            :param delimiter: The delimiter that is used to separate the lines in text.
            :param display_options: The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_text_area_control_options_property = quicksight.CfnAnalysis.DefaultTextAreaControlOptionsProperty(
                    delimiter="delimiter",
                    display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__32d46582e653eb3bbb2c0d8a14d1ae31497cf731e36bf03c644e3f5d7c36aa1e)
                check_type(argname="argument delimiter", value=delimiter, expected_type=type_hints["delimiter"])
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if delimiter is not None:
                self._values["delimiter"] = delimiter
            if display_options is not None:
                self._values["display_options"] = display_options

        @builtins.property
        def delimiter(self) -> typing.Optional[builtins.str]:
            '''The delimiter that is used to separate the lines in text.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html#cfn-quicksight-analysis-defaulttextareacontroloptions-delimiter
            '''
            result = self._values.get("delimiter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TextAreaControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html#cfn-quicksight-analysis-defaulttextareacontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TextAreaControlDisplayOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultTextAreaControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"display_options": "displayOptions"},
    )
    class DefaultTextFieldControlOptionsProperty:
        def __init__(
            self,
            *,
            display_options: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.TextFieldControlDisplayOptionsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The default options that correspond to the ``TextField`` filter control type.

            :param display_options: The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextfieldcontroloptions.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                default_text_field_control_options_property = quicksight.CfnAnalysis.DefaultTextFieldControlOptionsProperty(
                    display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                        info_icon_label_options=quicksight.CfnAnalysis.SheetControlInfoIconLabelOptionsProperty(
                            info_icon_text="infoIconText",
                            visibility="visibility"
                        ),
                        placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                            visibility="visibility"
                        ),
                        title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                            custom_label="customLabel",
                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                font_color="fontColor",
                                font_decoration="fontDecoration",
                                font_family="fontFamily",
                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                    absolute="absolute",
                                    relative="relative"
                                ),
                                font_style="fontStyle",
                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                    name="name"
                                )
                            ),
                            visibility="visibility"
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f70679bf4fa62b6e3e00f82cdba5ad6d943ea4cc3a282e2ffdacac322a165688)
                check_type(argname="argument display_options", value=display_options, expected_type=type_hints["display_options"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if display_options is not None:
                self._values["display_options"] = display_options

        @builtins.property
        def display_options(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TextFieldControlDisplayOptionsProperty"]]:
            '''The display options of a control.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextfieldcontroloptions.html#cfn-quicksight-analysis-defaulttextfieldcontroloptions-displayoptions
            '''
            result = self._values.get("display_options")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.TextFieldControlDisplayOptionsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultTextFieldControlOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_values_configuration": "customValuesConfiguration",
            "select_all_value_options": "selectAllValueOptions",
            "source_column": "sourceColumn",
            "source_field": "sourceField",
            "source_parameter_name": "sourceParameterName",
        },
    )
    class DestinationParameterValueConfigurationProperty:
        def __init__(
            self,
            *,
            custom_values_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CustomValuesConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            select_all_value_options: typing.Optional[builtins.str] = None,
            source_column: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.ColumnIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            source_field: typing.Optional[builtins.str] = None,
            source_parameter_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of destination parameter values.

            This is a union type structure. For this structure to be valid, only one of the attributes can be defined.

            :param custom_values_configuration: The configuration of custom values for destination parameter in ``DestinationParameterValueConfiguration`` .
            :param select_all_value_options: The configuration that selects all options.
            :param source_column: A column of a data set.
            :param source_field: The source field ID of the destination parameter.
            :param source_parameter_name: The source parameter name of the destination parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                destination_parameter_value_configuration_property = quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                    custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                        custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                            date_time_values=["dateTimeValues"],
                            decimal_values=[123],
                            integer_values=[123],
                            string_values=["stringValues"]
                        ),
                
                        # the properties below are optional
                        include_null_value=False
                    ),
                    select_all_value_options="selectAllValueOptions",
                    source_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
                    source_field="sourceField",
                    source_parameter_name="sourceParameterName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b568ad7c5608ef334c1467a57d1b9916a10bda6f9c7696669cedd4a8a2c78a8c)
                check_type(argname="argument custom_values_configuration", value=custom_values_configuration, expected_type=type_hints["custom_values_configuration"])
                check_type(argname="argument select_all_value_options", value=select_all_value_options, expected_type=type_hints["select_all_value_options"])
                check_type(argname="argument source_column", value=source_column, expected_type=type_hints["source_column"])
                check_type(argname="argument source_field", value=source_field, expected_type=type_hints["source_field"])
                check_type(argname="argument source_parameter_name", value=source_parameter_name, expected_type=type_hints["source_parameter_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_values_configuration is not None:
                self._values["custom_values_configuration"] = custom_values_configuration
            if select_all_value_options is not None:
                self._values["select_all_value_options"] = select_all_value_options
            if source_column is not None:
                self._values["source_column"] = source_column
            if source_field is not None:
                self._values["source_field"] = source_field
            if source_parameter_name is not None:
                self._values["source_parameter_name"] = source_parameter_name

        @builtins.property
        def custom_values_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomValuesConfigurationProperty"]]:
            '''The configuration of custom values for destination parameter in ``DestinationParameterValueConfiguration`` .

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-customvaluesconfiguration
            '''
            result = self._values.get("custom_values_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.CustomValuesConfigurationProperty"]], result)

        @builtins.property
        def select_all_value_options(self) -> typing.Optional[builtins.str]:
            '''The configuration that selects all options.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-selectallvalueoptions
            '''
            result = self._values.get("select_all_value_options")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def source_column(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]]:
            '''A column of a data set.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourcecolumn
            '''
            result = self._values.get("source_column")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAnalysis.ColumnIdentifierProperty"]], result)

        @builtins.property
        def source_field(self) -> typing.Optional[builtins.str]:
            '''The source field ID of the destination parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourcefield
            '''
            result = self._values.get("source_field")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def source_parameter_name(self) -> typing.Optional[builtins.str]:
            '''The source parameter name of the destination parameter.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourceparametername
            '''
            result = self._values.get("source_parameter_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DestinationParameterValueConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis.DimensionFieldProperty",
        jsii_struct_bases=[],
        name_mapping={
            "categorical_dimension_field": "categoricalDimensionField",
            "date_dimension_field": "dateDimensionField",
            "numerical_dimension_field": "numericalDimensionField",
        },
    )
    class DimensionFieldProperty:
        def __init__(
            self,
            *,
            categorical_dimension_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.CategoricalDimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            date_dimension_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.DateDimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            numerical_dimension_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAnalysis.NumericalDimensionFieldProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The dimension type field.

            :param categorical_dimension_field: The dimension type field with categorical type columns.
            :param date_dimension_field: The dimension type field with date type columns.
            :param numerical_dimension_field: The dimension type field with numerical type columns.

            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_quicksight as quicksight
                
                dimension_field_property = quicksight.CfnAnalysis.DimensionFieldProperty(
                    categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        field_id="fieldId",
                
                        # the properties below are optional
                        format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        hierarchy_id="hierarchyId"
                    ),
                    date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
                        field_id="fieldId",
                
                        # the properties below are optional
                        date_granularity="dateGranularity",
                        format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                            date_time_format="dateTimeFormat",
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            grouping_style="groupingStyle",
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        hierarchy_id="hierarchyId"
                    ),
                    numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                        column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                            column_name="columnName",
                            data_set_identifier="dataSetIdentifier"
                        ),
             