# Generated by Django 5.1.11 on 2025-07-07 16:01

import django.db.models.deletion
import django_dramatiq_postgres.models
import pgtrigger.compiler
import pgtrigger.migrations
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Schedule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "actor_name",
                    models.TextField(editable=False, help_text="Dramatiq actor to call"),
                ),
                ("args", models.BinaryField(help_text="Args to send to the actor")),
                ("kwargs", models.BinaryField(help_text="Kwargs to send to the actor")),
                ("options", models.BinaryField(help_text="Options to send to the actor")),
                (
                    "crontab",
                    models.TextField(
                        help_text="When to schedule tasks",
                        validators=[django_dramatiq_postgres.models.validate_crontab],
                    ),
                ),
                ("paused", models.BooleanField(default=False, help_text="Pause this schedule")),
                ("next_run", models.DateTimeField(auto_now_add=True)),
                (
                    "identifier",
                    models.TextField(
                        editable=False,
                        help_text="Unique schedule identifier",
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "_uid",
                    models.TextField(blank=True, help_text="User schedule identifier", null=True),
                ),
                ("rel_obj_id", models.TextField(null=True)),
                (
                    "rel_obj_content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Schedule",
                "verbose_name_plural": "Schedules",
                "permissions": [("send_schedule", "Manually trigger a schedule")],
                "abstract": False,
                "default_permissions": ("change", "view"),
                "indexes": [
                    models.Index(
                        fields=["rel_obj_content_type", "rel_obj_id"],
                        name="authentik_t_rel_obj_575af2_idx",
                    )
                ],
            },
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="schedule",
            trigger=pgtrigger.compiler.Trigger(
                name="set_next_run_on_paused",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    condition='WHEN (NEW."paused" AND NOT OLD."paused")',
                    func="\n                    NEW.next_run = to_timestamp(0);\n                    RETURN NEW;\n                ",
                    hash="7fe580a86de70723522cfcbac712785984000f92",
                    operation="UPDATE",
                    pgid="pgtrigger_set_next_run_on_paused_95c6d",
                    table="authentik_tasks_schedules_schedule",
                    when="BEFORE",
                ),
            ),
        ),
    ]
