# Generated by Django 5.1.11 on 2025-06-25 14:50

import django.db.models.deletion
import django.utils.timezone
import pgtrigger.compiler
import pgtrigger.migrations
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("authentik_tenants", "0005_tenant_reputation_lower_limit_and_more"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="WorkerStatus",
            fields=[
                ("id", models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ("hostname", models.TextField()),
                ("version", models.TextField()),
                ("last_seen", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "verbose_name": "Worker status",
                "verbose_name_plural": "Worker statuses",
                "default_permissions": [],
            },
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "message_id",
                    models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False),
                ),
                ("queue_name", models.TextField(default="default", help_text="Queue name")),
                ("actor_name", models.TextField(help_text="Dramatiq actor name")),
                ("message", models.BinaryField(help_text="Message body", null=True)),
                (
                    "state",
                    models.CharField(
                        choices=[
                            ("queued", "Queued"),
                            ("consumed", "Consumed"),
                            ("rejected", "Rejected"),
                            ("done", "Done"),
                        ],
                        default="queued",
                        help_text="Task status",
                    ),
                ),
                (
                    "mtime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, help_text="Task last modified time"
                    ),
                ),
                ("result", models.BinaryField(help_text="Task result", null=True)),
                ("result_expiry", models.DateTimeField(help_text="Result expiry time", null=True)),
                ("rel_obj_id", models.TextField(null=True)),
                ("_uid", models.TextField(blank=True, null=True)),
                ("_messages", models.JSONField(default=list)),
                ("_previous_messages", models.JSONField(default=list)),
                (
                    "aggregated_status",
                    models.TextField(
                        choices=[
                            ("queued", "Queued"),
                            ("consumed", "Consumed"),
                            ("rejected", "Rejected"),
                            ("done", "Done"),
                            ("info", "Info"),
                            ("warning", "Warning"),
                            ("error", "Error"),
                        ]
                    ),
                ),
                (
                    "rel_obj_content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        help_text="Tenant this task belongs to",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_tenants.tenant",
                    ),
                ),
            ],
            options={
                "verbose_name": "Task",
                "verbose_name_plural": "Tasks",
                "permissions": [("retry_task", "Retry failed task")],
                "abstract": False,
                "default_permissions": ("view",),
                "indexes": [
                    models.Index(fields=["state", "mtime"], name="authentik_t_state_bb4a31_idx"),
                    models.Index(
                        fields=["rel_obj_content_type", "rel_obj_id"],
                        name="authentik_t_rel_obj_3a177a_idx",
                    ),
                ],
            },
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="task",
            trigger=pgtrigger.compiler.Trigger(
                name="notify_enqueueing",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    condition="WHEN (NEW.\"state\" = 'queued')",
                    constraint="CONSTRAINT",
                    func="\n                    PERFORM pg_notify(\n                        'authentik.tasks.' || NEW.queue_name || '.enqueue',\n                        NEW.message_id::text\n                    );\n                    RETURN NEW;\n                ",
                    hash="0a9ee3db61e4d63fd72b31322fbb821706dd8a78",
                    operation="INSERT OR UPDATE",
                    pgid="pgtrigger_notify_enqueueing_0bc94",
                    table="authentik_tasks_task",
                    timing="DEFERRABLE INITIALLY DEFERRED",
                    when="AFTER",
                ),
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="task",
            trigger=pgtrigger.compiler.Trigger(
                name="update_aggregated_status",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func="\n                    NEW.aggregated_status := CASE\n                        WHEN NEW.state != 'done' THEN NEW.state\n                        ELSE COALESCE((\n                            SELECT CASE\n                                WHEN bool_or(msg->>'log_level' = 'error') THEN 'error'\n                                WHEN bool_or(msg->>'log_level' = 'warning') THEN 'warning'\n                                WHEN bool_or(msg->>'log_level' = 'info') THEN 'info'\n                                ELSE 'done'\n                            END\n                            FROM jsonb_array_elements(NEW._messages) AS msg\n                        ), 'done')\n                    END;\n\n                    RETURN NEW;\n                ",
                    hash="ebc09bc08c1624966c0c58a52f243fe25a842058",
                    operation="INSERT OR UPDATE",
                    pgid="pgtrigger_update_aggregated_status_f18c4",
                    table="authentik_tasks_task",
                    when="BEFORE",
                ),
            ),
        ),
    ]
